---
title: Chapter 2 | The head element
keywords: html, html standard, how-to, learn html
description: As mentioned yesterday, today we are getting into the head of our HTML document and looking at the metadata that lives in it.
menu:
  book:
    weight: 2
---

# Chapter 2 - The `head` element

As mentioned yesterday, today we are getting into the `head` of our HTML document and looking at the metadata that lives in it. So what is metadata?

In a single short phrase, it is [“data about data”](https://en.wikipedia.org/wiki/Metadata). That’s so meta right? 😉

Not all metadata lives in the `head` though, and not all metadata that lives in the `head` is necessarily descriptive, but I am getting a-`head` of myself.

{{< youtube id="fVYbaw_xTsM" title="150DaysofHTML, Chapter 2, The head element" >}}

## head

Most of the metadata about our document lives in the `head` of the document, and it makes perfect sense. Most information about our bodies also live in _our_ head. Expanding on the code from yesterday, the following example adds a `head` to our document:

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    ...
  </head>
  ...
</html>
```

And that is pretty much it for the `head`. It is a rather boring element but; it serves a very important role, and while it is technically possible to omit the `head`, who wants a document without a `head`?

That is it for Day 2.
