# JetBrains IDEs

JetBrains is a company creating tools for developers. Their mission is: _We make professional software development a more productive and enjoyable experience_. In this section a number of IDEs (integrated development environment) as well as a selection of features will be presented.

## Selection of Features

**Note that these features apply to _all_ IDEs mentioned.**

### Shared Key Mappings

If you use different programming languages you might also use different IDEs/editors. This forces you to learn different key mappings for each individual IDE/editor. With IDEs from JetBrains you only need to learn one key mapping because it's shared between all of their IDEs. If you customize your key mapping you can even export it from one IDE and import in the other one.

### Highly Customizable

Not only can you do lots of customization when it comes to appearance, key mapping and a lot more, you also have plugins. These plugins cover everything from dealing with different file types to using external tools such as Git, Docker, databases, linters and time tracking. JetBrains offer a bunch of their own plugins but you can also develop and publish your own plugins.

### Integrated Tools

Their IDEs offer so many tools that you never have to leave it if you don't want to. It supports a number of different VCSs (Git, Subversion, Perforce etc.), a terminal window, database browser, debuggers, SSH sessions and more.

### Powerful Refactoring

Rename a method used all over your project with a few clicks, or change a method signature in the same way. With statically typed languages like Java and C the refactoring becomes even more powerful.

## Useful Shortcuts

* Search for a file -- `CMD + SHIFT + O`
* Search for a string -- `CMD + SHIFT + F`
* Search everything, press `SHIFT` two (2) times
* Context based action -- `ALT + ENTER` (this one is very contextual, you have to just try it out having your cursor in different places)
* Refactor this -- `CTRL + T` (place your cursor on what you want to refactor)

## Supported Languages

Their IDEs support a number of languages, here's a list covering all of the listed ones sorted alphabetically.

* C, C#, C++
* CSS, Less, Sass, Stylus
* F#
* Go
* Groovy
* Java
* JavaScript, TypeScript
* Kotlin
* Objective-C
* PHP
* Python
* Ruby
* Scala
* SQL
* Swift
* VB.NET

They offer support for more languages using plugins such as Rust, Dart, Haxe, Markdown, Pug/Jade, Slim, Twig and more.

## Installation

Go to [their website](https://www.jetbrains.com/products.html?fromMenu#type=ide) and select what product you'd like to download.

Alternatively, use the [Jetbrains Toolbox App](https://www.jetbrains.com/toolbox-app/) to manage product installations.

## Pricing

If you're a **student** or an **instructor** (teaching staff members) all IDEs from JetBrains are free to use. You can read more on [their website](https://www.jetbrains.com/student/). If you're not a student they still offer a few free Community Edition (CE) IDEs. Check out [IntelliJ](https://www.jetbrains.com/idea/) (Java) or [PyCharm Edu](https://www.jetbrains.com/pycharm-edu/).

If you as an individual want to have an [IntelliJ subscription](https://www.jetbrains.com/idea/buy/#edition=personal), for example, it's €14.90/$14.90 every month. Before buying a subscription you should [see if you apply for a free/discounted license](https://www.jetbrains.com/idea/buy/#edition=discounts).
