<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Document') }}
        </h2>
    </x-slot>
    {{--print_r(Session::all())--}}

    <div class="py-8">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg">
                <div class="flex flex-col">
                    <div class="-my-2 overflow-x-auto sm:-mx-6 lg:-mx-8">
                        <div class="py-2 align-middle inline-block min-w-full sm:px-6 lg:px-8">
                            <div class="shadow overflow-hidden border-b border-gray-200 sm:rounded-lg">
                                <table class="min-w-full divide-y divide-gray-200">
                                    <thead class="bg-gray-50">
                                    <tr>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Title
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Language
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Issuer
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Date Published
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Category
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Tag
                                        </th>
                                        <th scope="col" class="relative px-6 py-3">
                                            <span class="sr-only">Edit</span>
                                        </th>
                                    </tr>
                                    </thead>
                                    <tbody class="bg-white divide-y divide-gray-200">
                                    <tr>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <div class="flex items-center">
                                                    <div class="text-sm font-medium text-gray-900">
                                                        {{$result['_source']['external']['title']}}
                                                    </div>
                                            </div>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <div class="flex items-left">
                                                    <div class="text-sm font-medium text-gray-900">
                                                        {{$result['_source']['external']['language']}}
                                                    </div>
                                            </div>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <div class="flex items-left">
                                                    <div class="text-sm font-medium text-gray-900">
                                                        {{$result['_source']['external']['issuer']}}
                                                    </div>
                                            </div>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <div class="flex items-left">
                                                    <div class="text-sm font-medium text-gray-900">
                                                        {{$result['_source']['external']['date_published']}}
                                                    </div>
                                            </div>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <div class="flex items-left">
                                                    <div class="text-sm font-medium text-gray-900">
                                                        {{$result['_source']['external']['category']}}
                                                    </div>
                                            </div>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <div class="flex items-left">
                                                    <div class="text-sm font-medium text-gray-900">
                                                        {{$result['_source']['external']['tag']}}
                                                    </div>
                                            </div>
                                        </td>

                                    </tr>
                                    </tbody>
                                </table>
                                <div class="px-4 py-3 bg-gray-50 text-right sm:px-6">
                                    <a href="{{route('document.mail', ['filename' => $result['_source']['file']['filename']])}}"
                                       class="btn btn-primary inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">Mail
                                    </a>
                                @can('isLibrarian', App\Models\User::class)
                                    @include('partials.edit')
                                @endcan
                                </div>
                                <hr>
                                <iframe height="600px"
                                        width="100%"
                                        src= {{Storage::url($result['_source']['file']['filename'])}}>
                                </iframe>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
<script src="{{url('/js/form.js')}}"></script>
