<?php

namespace App\Http\Livewire;

use App\Models\User;
use Livewire\Component;
use Livewire\WithPagination;
use Illuminate\Support\Facades\DB;

class SearchUsers extends Component
{
    use WithPagination;
    public $search = '';
    public function updatingSearch()
    {
        $this->resetPage();
    }
    public function render()
    {
        return view('livewire.search-users', [
            'users' => DB::table('users')
            ->where('name', 'LIKE', "%{$this->search}%")
            ->orWhere('firstname', 'LIKE', "%{$this->search}%")
            ->orWhere('email', 'LIKE', "%{$this->search}%")
            ->orWhere('type', 'LIKE', "%{$this->search}%")
            ->paginate(5),
        ]);
    }
}
