<img src="logo.svg" width="64px"/>

# Kotlin Coding Style Guide (Diktat Code Style), v.1.0.0

I [Preface](#c0)
* [I.I Purpose of this document](#c0.1)
* [I.II General principles](#c0.2)
* [I.III Terminology](#c0.3)
* [I.IV Exceptions](#c0.4)

[1. Naming](#c1)

* [1.1 Identifiers](#c1.1)
* [1.2 Packages](#c1.2)
* [1.3 Classes, enumerations, interfaces](#c1.3)
* [1.4 Functions](#c1.4)
* [1.5 Constants](#c1.5)
* [1.6 Non-constant fields (variables)](#c1.6)
    * [1.6.1 Non-constant field name](#r1.6.1)
    * [1.6.2 Boolean variable names with negative meaning](#r1.6.2)

[2. Comments](#c2)
* [2.1 General form of Kdoc](#c2.1)
    * [2.1.1 Using KDoc for the public, protected, or internal code elements](#r2.1.1)
    * [2.1.2 Describing methods that have arguments, a return value, or can throw an exception in the KDoc block](#r2.1.2)
    * [2.1.3 Only one space between the Kdoc tag and content. Tags are arranged in the order.](#r2.1.3)
* [2.2 Adding comments on the file header](#c2.2)
* [2.3 Comments on the function header](#c2.3)
* [2.4 Code comments](#c2.4)
    * [2.4.1 Adding a blank line between the body of the comment and Kdoc tag-blocks](#r2.4.1)
    * [2.4.2 Do not comment on unused code blocks](#r2.4.2)
    * [2.4.3 Code delivered to the client must not contain TODO/FIXME comments](#r2.4.3)

[3. General formatting (typesetting)](#c3)
* [3.1 File-related rules](#c3.1)
    * [3.1.1 Avoid files that are too long](#r3.1.1)
    * [3.1.2 Code blocks in the source file must be separated by one blank line](#r3.1.2)
    * [3.1.3 Import statements order](#r3.1.3)
    * [3.1.4 Order of declaration parts of class-like code structures](#r3.1.4)
    * [3.1.5 Order of declaration of top-level code structures](#r3.1.5)
* [3.2 Braces](#c3.2)
    * [3.2.1 Using braces in conditional statements and loop blocks](#r3.2.1)
    * [3.2.2 Opening braces are placed at the end of the line in *non-empty* blocks and block structures](#r3.2.2)
* [3.3 Indentation](#c3.3)
* [3.4 Empty blocks](#c3.4)
* [3.5 Line length](#c3.5)
* [3.6 Line breaks (newlines)](#c3.6)
    * [3.6.1 Each line can have a maximum of one statement](#r3.6.1)
    * [3.6.2 Rules for line-breaking](#r3.6.2)
* [3.7 Using blank lines](#c3.7)
* [3.8 Horizontal space](#c3.8)
    * [3.8.1 Using whitespace for code separation](#r3.8.1)
    * [3.8.2 No spaces for horizontal alignment](#r3.8.2)
* [3.9 Enumerations](#c3.9)
* [3.10 Variable declaration](#c3.10)
    * [3.10.1 Declare one variable per line](#r3.10.1)
    * [3.10.2 Variables should be declared near the line where they are first used](#r3.10.2)
* [3.11 'When' expression](#c3.11)
* [3.12 Annotations](#c3.12)
* [3.13 Block comments](#c3.13)
* [3.14 Modifiers and constant values](#c3.14)
    * [3.14.1 Declaration with multiple modifiers](#r3.14.1)
    * [3.14.2 Separating long numerical values with an underscore](#r3.14.2)
 * [3.15 Strings](#c3.15)
     * [3.15.1 Concatenation of Strings](#r3.15.1)
     * [3.15.2 String template format](#r3.15.2)
 * [3.16 Conditional statements](#c3.16)
     * [3.16.1 Collapsing redundant nested if-statements](#r3.16.1)
     * [3.16.2 Too complex conditions](#r3.16.2)

[4. Variables and types](#c4)
* [4.1 Variables](#c4.1)
    * [4.1.1 Do not use Float and Double types when accurate calculations are needed](#r4.1.1)
    * [4.1.2 Comparing numeric float type values](#r4.1.2)
    * [4.1.3 Using 'val' instead of 'var' for variable declaration [SAY_NO_TO_VAR]](#r4.1.3)
* [4.2 Types](#c4.2)
    * [4.2.1 Using Contracts and smart cast as much as possible](#r4.2.1)
    * [4.2.2 Trying to use type alias to represent types making code more readable](#r4.2.2)
* [4.3 Null safety and variable declarations](#c4.3)
    * [4.3.1 Avoid declaring variables with nullable types, especially from Kotlin stdlib](#r4.3.1)
    * [4.3.2 Variables of generic types should have an explicit type declaration](#r4.3.2)
    * [4.3.3 Null-safety](#r4.3.3)

[5. Functions](#c5)
* [5.1 Function design](#c5.1)
    * [5.1.1 Avoid functions that are too long ](#r5.1.1)
    * [5.1.2 Avoid deep nesting of function code blocks, limiting to four levels](#r5.1.2)
    * [5.1.3 Avoid using nested functions](#r5.1.3)
    * [5.1.4 Negated function calls](#r5.1.4)
* [5.2 Function arguments](#c5.2)
    * [5.2.1 The lambda parameter of the function should be placed at the end of the argument list](#r5.2.1)
    * [5.2.2 Number of function parameters should be limited to five](#r5.2.2)
    * [5.2.3 Use default values for function arguments instead of overloading them](#r5.2.3)
    * [5.2.4 Synchronizing code inside asynchronous code](#r5.2.4)
    * [5.2.5 Long lambdas must have explicit parameters](#r5.2.5)
    * [5.2.6 Avoid using unnecessary, custom label](#r5.2.6)

[6. Classes, interfaces, and extension functions](#c6)
* [6.1 Classes](#c6.1)
    * [6.1.1 Denoting a class with a single constructor](#r6.1.1)
    * [6.1.2 Prefer data classes instead of classes without any functional logic](#r6.1.2)
    * [6.1.3 Do not use the primary constructor if it is empty or useless](#r6.1.3)
    * [6.1.4 Do not use redundant init blocks in your class](#r6.1.4)
    * [6.1.5 Explicit supertype qualification](#r6.1.5)
    * [6.1.6 Abstract class must have at least one abstract method](#r6.1.6)
    * [6.1.7 When using the "implicit backing property" scheme, the name of real and back property should be the same](#r6.1.7)
    * [6.1.8 Avoid using custom getters and setters](#r6.1.8)
    * [6.1.9 Never use the name of a variable in the custom getter or setter (possible_bug)](#r6.1.9)
    * [6.1.10 No trivial getters and setters are allowed in the code](#r6.1.10)
    * [6.1.11 Use 'apply' for grouping object initialization](#r6.1.11)
    * [6.1.12 Prefer Inline classes when the class has a single property](#r6.1.12)
* [6.2 Extension functions](#c6.2)
    * [6.2.1 Use extension functions for making logic of classes less coupled](#r6.2.1)
    * [6.2.2 No extension functions with the same name and signature if they extend base and inheritor classes (possible_bug)](#r6.2.2)
    * [6.2.3 Don't use extension functions for the class in the same file](#r6.2.3)
* [6.3 Interfaces](#c6.3)
* [6.4 Objects](#c6.4)
    * [6.4.1 Instead of using utility classes/objects, use extensions](#r6.4.1)
    * [6.4.2 Objects must be used for Stateless Interfaces](#r6.4.2)
* [6.5 Kts Files](#c6.5)
    * [6.5.1 kts files should wrap logic into top-level scope](#r6.5.1)
