| Chap | Standard | Rule name                                 | Description                                                                                                                                                                                                                                                                                                                                                 | Fix | Config                                                                                                                                                                                                                     | FixMe                                                                                                                                                                                                                                 |
|------|----------|-------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| 1    | 1.1.1    | CONFUSING_IDENTIFIER_NAMING               | Check: warns if the identifier has an inappropriate name (see table of [rule 1.2 part 6](guide/diktat-coding-convention.md#-111-identifiers-naming-conventions)).                                                                                                                                                                                           | no  | no                                                                                                                                                                                                                         | no                                                                                                                                                                                                                                    |
| 1    | 1.1.1    | BACKTICKS_PROHIBITED                      | Check: warns if backticks (``) are used in the identifier name, except in the case when it is a test method (marked with `@Test` annotation).                                                                                                                                                                                                               | no  | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 1    | 1.1.1    | VARIABLE_NAME_INCORRECT                   | Check: warns if a variable name consists of only a single character; the only exceptions are industry-standard fixed names, such as {`i`, `j`}.<br>Fix: No fix is available, since it is the responsibility of a human to choose a meaningful identifier name.                                                                                              | no  | no                                                                                                                                                                                                                         | Recursively update usages of this class in the projectMake exceptions configurable.                                                                                                                                                   |
| 1    | 1.1.1    | EXCEPTION_SUFFIX                          | Check: warns if a class that extends any `Exception` class does not have an "Exception" suffix.<br>Fix: adding the "Exception" suffix to the class name.                                                                                                                                                                                                    | yes | no                                                                                                                                                                                                                         | Need to add tests for this.                                                                                                                                                                                                           |
| 1    | 1.1.1    | IDENTIFIER_LENGTH                         | Check: identifier length should be in the [2,64] range , except for industry-standard names, such as {`i`, `j`} and 'e' for catching exceptions.<br>Fix: Fix: no fix is available, since only a human can choose a meaningful identifier name, depending on the context.                                                                                    | no  | no                                                                                                                                                                                                                         | May be make this rule configurable (length)                                                                                                                                                                                           |
| 1    | 1.1.1    | FILE_NAME_INCORRECT                       | Check: warns if a file name does not have a `.kt`/`.kts` extension.<br>Fix: no                                                                                                                                                                                                                                                                              | no  | no                                                                                                                                                                                                                         | Extensions should be configurable; it can be autofixed.                                                                                                                                                                               |
| 1    | 1.1.1    | GENERIC_NAME                              | Check: warns if the name of a  [_generic type parameter_](https://kotlinlang.org/docs/generics.html) (e.g. `T`) consists of more than a single capital letter. The capital letter can be followed by numbers, though (e.g. `T12`).<br>Fix:                                                                                                                  | yes | no                                                                                                                                                                                                                         | Recursively update usages of this identifier in the project.                                                                                                                                                                          |
| 1    | 1.1.1    | VARIABLE_HAS_PREFIX                       | Check: warns if the name of a variable has a [Hungarian notation](https://en.wikipedia.org/wiki/Hungarian_notation) specific prefix (like `mVariable` or `M_VARIABLE`), which is considered a bad code style (_Android_ is the only exception).<br>Fix: none is available, as only a human can choose a meaningful name, depending on a particular context. | no  | no                                                                                                                                                                                                                         |                                                                                                                                                                                                                                       |
| 1    | 1.2.1    | PACKAGE_NAME_MISSING                      | Check: warns if a package declaration is missing in the file.<br>Fix: automatically adds a package directive with the name that starts from the domain name (example - com.huawei) and contains the real directory.                                                                                                                                         | yes | no                                                                                                                                                                                                                         | Recursively fix all imports in the project.<br>Fix the directory where the code is stored.<br>Make this check isolated from the domain name addition.                                                                                 |
| 1    | 1.2.1    | PACKAGE_NAME_INCORRECT_CASE               | Check: warns if a package name is incorrect (non-lower) case.<br>Fix: automatically update the case in package name.                                                                                                                                                                                                                                        | yes | no                                                                                                                                                                                                                         | Recursively update all imports in the project.                                                                                                                                                                                        |
| 1    | 1.2.1    | PACKAGE_NAME_INCORRECT_PREFIX             | Check: warns if a package name does not start with the company's domain.<br>Fix: automatically update the prefix in the package name.                                                                                                                                                                                                                       | yes | no                                                                                                                                                                                                                         | Fix the directory where the code is stored.<br>Recursively update all imports in the project.                                                                                                                                         |
| 1    | 1.2.1    | PACKAGE_NAME_INCORRECT_SYMBOLS            | Check: warns if a package name has incorrect symbols, such as underscore or non-ASCII letters/digits. Exception: underscores that are used for differentiating of keywords in a name.<br>Fix: no fix currently available; will be suggested later.                                                                                                          | no  | no                                                                                                                                                                                                                         | Add autofix for at least converting underscore to a dot or replacing itFix the directory where the code is stored. Cover autofix with tests.                                                                                          |
| 1    | 1.2.1    | PACKAGE_NAME_INCORRECT_PATH               | Check: warns if the path for a file does not match with a package name.<br>Fix: replacing the incorrect package name with the name constructed from a path to the file.                                                                                                                                                                                     | yes | no                                                                                                                                                                                                                         | Make this check isolated from domain name creation. Recursively update all imports in the project. Fix the directory where the code is stored. Add a test mechanism to test checker.                                                  |
| 1    | 1.2.1    | INCORRECT_PACKAGE_SEPARATOR               | Check: warns if the underscore is incorrectly used in package naming to split name parts.<br>Fix: fixing all nodes in AST and the package name to remove all underscores.                                                                                                                                                                                   | no  | no                                                                                                                                                                                                                         | Recursively update usages of this class in the project.                                                                                                                                                                               |
| 1    | 1.3.1    | CLASS_NAME_INCORRECT                      | Check: warns if the Class/Enum/Interface name does not match the Pascal case ("([A-Z][a-z0-9]+)+").<br>Fix: fixing the case. If it is some fixed case (like Snake or Camel) - with word saving; if not - will restore PascalCase as is.                                                                                                                     | yes | no                                                                                                                                                                                                                         | Recursively update usages of this class in the projectCheck and find the better way of converting the identifier to PascalCaseNeed to add checks using natural language processing and check that the class name contains only nouns. |
| 1    | 1.3.1    | OBJECT_NAME_INCORRECT                     | Check: warns if the object does not match the Pascal case ("([A-Z][a-z0-9]+)+").<br>Fix: fixing the case in the same way as for the classes.                                                                                                                                                                                                                | yes | no                                                                                                                                                                                                                         | Recursively update usages of this class in the project.                                                                                                                                                                               |
| 1    | 1.3.1    | ENUM_VALUE                                | Check: verifies if the enum value is in UPPER_SNAKE_CASE or in PascalCase depending on the configuration. UPPER_SNAKE_CASE is the default configuration, but can be changed by 'enumStyle' config.<br>Fix: automatically converting the enum case to a properly selected case                                                                               | yes | enumStyle: snakeCase, pascalCase                                                                                                                                                                                           | Recursively update usages of this identifier in the project.                                                                                                                                                                          |
| 1    | 1.3.1    | TYPEALIAS_NAME_INCORRECT_CASE             | Check: typealias name should be in pascalCase.<br>Fix:                                                                                                                                                                                                                                                                                                      | yes | no                                                                                                                                                                                                                         | Recursively update usages of this typealias in the project.                                                                                                                                                                           |
| 1    | 1.4.1    | FUNCTION_NAME_INCORRECT_CASE              | Check: function/method name should be in lowerCamelCase.<br>Fix:                                                                                                                                                                                                                                                                                            | yes | no                                                                                                                                                                                                                         | Recursively update usages of this function in the project.                                                                                                                                                                            |
| 1    | 1.5.1    | CONSTANT_UPPERCASE                        | Check: warns if CONSTANT (treated as const val from companion object or class level) is not in UPPER_SNAKE_CASE.<br>Fix: name is changed to UPPER_SNAKE_CASE.                                                                                                                                                                                               | yes | no                                                                                                                                                                                                                         | Recursively update usages of this identifier in the project.                                                                                                                                                                          |
| 1    | 1.6.1    | VARIABLE_NAME_INCORRECT_FORMAT            | Check: warns if the name of a variable is not in lowerCamelCase or contains non-ASCII letters.<br>Fix: fixing the case format to lowerCamelCase.                                                                                                                                                                                                            | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 1    | 1.6.2    | FUNCTION_BOOLEAN_PREFIX                   | Check: functions/methods that return boolean should have a special prefix, such as "is/should/etc."<br>Fix:                                                                                                                                                                                                                                                 | yes | no                                                                                                                                                                                                                         | Recursively update usages of this function in the project. Aggressive fix - what if the new name will not be valid?                                                                                                                   |
| 2    | 2.1.1    | MISSING_KDOC_TOP_LEVEL                    | Check: warns at a file level internal or public class or if the function has a missing KDoc.<br>Fix: no                                                                                                                                                                                                                                                     | no  | no                                                                                                                                                                                                                         | Support extension for setters/getters. Support extension for method "override".                                                                                                                                                       |
| 2    | 2.1.1    | KDOC_EXTRA_PROPERTY                       | Check: warn if there is a property in KDoc that is not present in the class.                                                                                                                                                                                                                                                                                | no  | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 2    | 2.1.1    | KDOC_DUPLICATE_PROPERTY                   | Check: warn if there's a property in KDoc which is already present.                                                                                                                                                                                                                                                                                         | no  | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 2    | 2.1.1    | MISSING_KDOC_CLASS_ELEMENTS               | Check: warns if accessible internal elements (protected, public, internal) in a class are not documented.<br>Fix: no                                                                                                                                                                                                                                        | no  | no                                                                                                                                                                                                                         | Maybe exception cases for setters and getters are needed; no sense in adding KDoc to them.                                                                                                                                            |
| 2    | 2.1.1    | MISSING_KDOC_ON_FUNCTION                  | Check: warns if accessible function doesn't have KDoc.<br>Fix: adds KDoc template if it is not empty.                                                                                                                                                                                                                                                       | yes | no                                                                                                                                                                                                                         |                                                                                                                                                                                                                                       |
| 2    | 2.1.1    | KDOC_NO_CONSTRUCTOR_PROPERTY              | Check: warns if there is no property tag inside KDoc before the constructor.                                                                                                                                                                                                                                                                                | yes | isParamTagsForParameters, isParamTagsForPrivateProperties, isParamTagsForGenericTypes                                                                                                                                      |                                                                                                                                                                                                                                       |
| 2    | 2.1.1    | KDOC_NO_CLASS_BODY_PROPERTIES_IN_HEADER   | Check: warns if the property is declared in a class body but documented with a property tag inside KDoc before the constructor.                                                                                                                                                                                                                             | yes | no                                                                                                                                                                                                                         |                                                                                                                                                                                                                                       |
| 2    | 2.1.1    | KDOC_NO_CONSTRUCTOR_PROPERTY_WITH_COMMENT | Check: warns if there is a comment before the property in the constructor.                                                                                                                                                                                                                                                                                  | yes | no                                                                                                                                                                                                                         |                                                                                                                                                                                                                                       |
| 2    | 2.1.1    | COMMENTED_BY_KDOC                         | Check: warns if there is a kdoc comment in the code block.                                                                                                                                                                                                                                                                                                  | yes | no                                                                                                                                                                                                                         | replace "/**" to "/*"                                                                                                                                                                                                                 |
| 2    | 2.1.2    | KDOC_WITHOUT_PARAM_TAG                    | Check: warns if an accessible method has parameters and they are not documented in KDoc.<br>Fix: If accessible method has no KDoc, the KDoc template is added.                                                                                                                                                                                              | yes | no                                                                                                                                                                                                                         | Should also make a separate fix, even if there is already some Kdoc in place.                                                                                                                                                         |
| 2    | 2.1.2    | KDOC_WITHOUT_RETURN_TAG                   | Check: warns if the accessible method has an explicit return type. Then it is not documented in KDoc.<br>Fix: If the accessible method has no KDoc, the KDoc template is added.                                                                                                                                                                             | yes | no                                                                                                                                                                                                                         | Should also make separate fix, even if there is already some Kdoc in place.                                                                                                                                                           |
| 2    | 2.1.2    | KDOC_WITHOUT_THROWS_TAG                   | Check: warns if the accessible method has the throw keyword and it is not documented in KDoc.<br>Fix: if the accessible method has no KDoc, KDoc template is added.                                                                                                                                                                                         | yes | no                                                                                                                                                                                                                         | Should also make separate fix, even if there is already some Kdoc in place.                                                                                                                                                           |
| 2    | 2.1.3    | KDOC_EMPTY_KDOC                           | Check: warns if the KDoc is empty.<br>Fix: no                                                                                                                                                                                                                                                                                                               | no  | no                                                                                                                                                                                                                         |                                                                                                                                                                                                                                       |
| 2    | 2.1.3    | KDOC_WRONG_SPACES_AFTER_TAG               | Check: warns if there is more than one space after the KDoc tag.<br>Fix: removes redundant spaces.                                                                                                                                                                                                                                                          | yes | no                                                                                                                                                                                                                         |                                                                                                                                                                                                                                       |
| 2    | 2.1.3    | KDOC_WRONG_TAGS_ORDER                     | Check: warns if the basic KDoc tags are not ordered properly.<br>Fix: reorders tags (`@receiver`, `@param`, `@property`, `@return`, `@throws` or `@exception`, `@constructor`).                                                                                                                                                                             | yes | no                                                                                                                                                                                                                         | Ensure basic tags are at the end of KDoc.                                                                                                                                                                                             |
| 2    | 2.1.3    | KDOC_NEWLINES_BEFORE_BASIC_TAGS           | Check: warns if the block of tags (@param, @return, @throws) is not separated from the previous part of KDoc by exactly one empty line.<br>Fix: adds an empty line or removes a redundant one.                                                                                                                                                              | yes | no                                                                                                                                                                                                                         |                                                                                                                                                                                                                                       |
| 2    | 2.1.3    | KDOC_NO_NEWLINES_BETWEEN_BASIC_TAGS       | Check: if there is a newline of an empty KDoc line (with a leading asterisk) between `@param`, `@return`, `@throws` tags.<br>Fix: removes the line.                                                                                                                                                                                                         | yes | no                                                                                                                                                                                                                         |                                                                                                                                                                                                                                       |
| 2    | 2.1.3    | KDOC_NO_NEWLINE_AFTER_SPECIAL_TAGS        | Check: warns if special tags `@apiNote`, `@implNote`, `@implSpec` don't have exactly one empty line after.<br>Fix: removes redundant lines or adds one.                                                                                                                                                                                                     | yes | no                                                                                                                                                                                                                         | Handle empty lines without a leading asterisk.                                                                                                                                                                                        |
| 2    | 2.1.3    | KDOC_NO_DEPRECATED_TAG                    | Check: warns if `@deprecated` is used in KDoc.<br>Fix: adds `@Deprecated` annotation with a message; removes the tag.                                                                                                                                                                                                                                       | yes | no                                                                                                                                                                                                                         | The `replaceWith` field in the annotation can also be filled with a meaningful value.                                                                                                                                                 |
| 2    | 2.2.1    | KDOC_NO_EMPTY_TAGS                        | Check: warns if the KDoc tags have an empty content.                                                                                                                                                                                                                                                                                                        | no  | no                                                                                                                                                                                                                         |                                                                                                                                                                                                                                       |
| 2    | 2.2.1    | KDOC_CONTAINS_DATE_OR_AUTHOR              | Check: warns if the KDoc header contains the `@author` tag.<br>Also warns if the `@since` tag is present but contains anything but version (e.g.: a date).                                                                                                                                                                                                  | no  | no                                                                                                                                                                                                                         | Detect the author by other patterns (e.g. 'created by' etc.)                                                                                                                                                                          |
| 2    | 2.2.1    | HEADER_WRONG_FORMAT                       | Checks: warns if there is no newline after the KDoc header.<br>Fix: adds a newline                                                                                                                                                                                                                                                                          | yes | no                                                                                                                                                                                                                         | Check if the header is on the very top of the file. It is hard to determine when it is not.                                                                                                                                           |
| 2    | 2.2.1    | HEADER_MISSING_OR_WRONG_COPYRIGHT         | Checks: copyright exists on top of the file and is properly formatted (as a block comment).<br>Fix: adds copyright if it is missing and required.                                                                                                                                                                                                           | yes | isCopyrightMandatory, copyrightText (sets the copyright pattern for your project, you also can use `;@currYear;` the key word in your text in aim to indicate the current year, instead of explicitly specifying).         |                                                                                                                                                                                                                                       |
| 2    | 2.2.1    | WRONG_COPYRIGHT_YEAR                      | Checks: copyright has a valid year.<br>Fix: makes the year valid.                                                                                                                                                                                                                                                                                           | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 2    | 2.2.1    | HEADER_MISSING_IN_NON_SINGLE_CLASS_FILE   | Check: warns if a file with zero or >1 classes doesn't have a KDoc header.                                                                                                                                                                                                                                                                                  | no  | no                                                                                                                                                                                                                         |                                                                                                                                                                                                                                       |
| 2    | 2.2.1    | HEADER_NOT_BEFORE_PACKAGE                 | Check: warns if a KDoc file header is located not before a package directive.<br>Fix: moves this KDoc                                                                                                                                                                                                                                                       | yes | no                                                                                                                                                                                                                         |                                                                                                                                                                                                                                       |
| 2    | 2.3.1    | KDOC_TRIVIAL_KDOC_ON_FUNCTION             | Check: warns if KDoc contains a single line with words 'return', 'get' or 'set'.                                                                                                                                                                                                                                                                            | no  | no                                                                                                                                                                                                                         |                                                                                                                                                                                                                                       |
| 2    | 2.4.1    | COMMENT_WHITE_SPACE                       | Check: warns if there is no space between // and comment, and if there is no space between the code and the comment <br>.Fix: adds a white space.                                                                                                                                                                                                           | yes | maxSpaces                                                                                                                                                                                                                  | -                                                                                                                                                                                                                                     |
| 2    | 2.4.1    | WRONG_NEWLINES_AROUND_KDOC                | Check: warns if there is no new line above and under the comment. Exception on the first comment.<br>Fix: adds a new line.                                                                                                                                                                                                                                  | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 2    | 2.4.1    | FIRST_COMMENT_NO_BLANK_LINE               | Check: warns if there is a new line before the first comment.<br>Fix: deletes a new line.                                                                                                                                                                                                                                                                   | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 2    | 2.4.1    | IF_ELSE_COMMENTS                          | Check: warns if there is a comment outside of the else block.<br>Fix: adds the comment to the first line in else block.                                                                                                                                                                                                                                     | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 2    | 2.4.2    | COMMENTED_OUT_CODE                        | Check: warns if the commented code is detected (when uncommented, can be parsed).                                                                                                                                                                                                                                                                           | no  | no                                                                                                                                                                                                                         | Offset is lost when the joined EOL comments are split again.                                                                                                                                                                          |
| 3    | 3.1.1    | FILE_IS_TOO_LONG                          | Check: warns if the file has too many lines.<br>Fix: no                                                                                                                                                                                                                                                                                                     | no  | maxSize                                                                                                                                                                                                                    | -                                                                                                                                                                                                                                     |
| 1    | 3.1.2    | FILE_NAME_MATCH_CLASS                     | Check: warns<br>Fix: no                                                                                                                                                                                                                                                                                                                                     | no  | no                                                                                                                                                                                                                         | Probably, it can be agressively autofixed.                                                                                                                                                                                            |
| 3    | 3.1.2    | FILE_CONTAINS_ONLY_COMMENTS               | Check: warns if the file contains only comments, imports, and package directive.                                                                                                                                                                                                                                                                            | no  | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 3    | 3.1.2    | FILE_INCORRECT_BLOCKS_ORDER               | Check: warns if the general order of code parts is wrong.<br>Fix: rearranges parts of code.                                                                                                                                                                                                                                                                 | yes | no                                                                                                                                                                                                                         | handle other elements that could be present before the package directive (other comments).                                                                                                                                            |
| 3    | 3.1.2    | FILE_NO_BLANK_LINE_BETWEEN_BLOCKS         | Check: warns if there is not exactly one blank line between the code parts.<br>Fix: leaves a single empty line.                                                                                                                                                                                                                                             | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 3    | 3.1.2    | FILE_UNORDERED_IMPORTS                    | Check: warns if the imports are not sorted alphabetically, or there are empty lines among them.<br>Fix: reorders imports.                                                                                                                                                                                                                                   | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 3    | 3.1.2    | FILE_WILDCARD_IMPORTS                     | Check: warns if the wildcard imports are used except the cases when they are allowed.                                                                                                                                                                                                                                                                       | no  | allowedWildcards                                                                                                                                                                                                           | -                                                                                                                                                                                                                                     |
| 3    | 3.1.2    | UNUSED_IMPORT                             | Check: warns if an import is not used.                                                                                                                                                                                                                                                                                                                      | no  | deleteUnusedImport                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 3    | 3.1.4    | WRONG_ORDER_IN_CLASS_LIKE_STRUCTURES      | Check: warns if the declaration part of a class, such as a code structure (class, interface, etc.) is not in the proper order.<br>Fix: restores the order according to the code style guide.                                                                                                                                                                | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 3    | 3.1.4    | BLANK_LINE_BETWEEN_PROPERTIES             | Check: warns if properties with comments are not separated by a blank line.<br>Fix: fixes the number of blank lines.                                                                                                                                                                                                                                        | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 3    | 3.1.4    | WRONG_DECLARATIONS_ORDER                  | Check: if the order of enum values or constant properties inside the companion is not correct.                                                                                                                                                                                                                                                              | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 3    | 3.1.5    | TOP_LEVEL_ORDER                           | Check: warns if the top level order is incorrect.                                                                                                                                                                                                                                                                                                           | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 3    | 3.2.1    | NO_BRACES_IN_CONDITIONALS_AND_LOOPS       | Check: warns if braces are not used in `if`, `else`, `when`, `for`, `do`, and `while` statements. Exception: single line if statement (ternary operator).<br>Fix: adds missing braces.                                                                                                                                                                      | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 3    | 3.2.2    | BRACES_BLOCK_STRUCTURE_ERROR              | Check: warns if non-empty code blocks with braces do not follow the K&R style (1TBS or OTBS style).                                                                                                                                                                                                                                                         | yes | openBraceNewline closeBraceNewline                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 3    | 3.3.1    | WRONG_INDENTATION                         | Check: warns if an indentation is incorrect.<br>Fix: corrects the indentation.<br><br>Basic cases are covered currently.                                                                                                                                                                                                                                    | yes | extendedIndentOfParameters<br>alignedParameters<br>extendedIndentForExpressionBodies<br>extendedIndentAfterOperators<br>extendedIndentBeforeDot<br>indentationSize                                                         | -                                                                                                                                                                                                                                     |
| 3    | 3.4.1    | EMPTY_BLOCK_STRUCTURE_ERROR               | Check: warns if an empty block exists or if its style is incorrect.                                                                                                                                                                                                                                                                                         | yes | allowEmptyBlocks styleEmptyBlockWithNewline                                                                                                                                                                                | -                                                                                                                                                                                                                                     |
| 3    | 3.5.1    | LONG_LINE                                 | Check: warns if the length doesn't exceed the specified length.                                                                                                                                                                                                                                                                                             | no  | lineLength                                                                                                                                                                                                                 | Handle json method in KDoc.                                                                                                                                                                                                           |
| 3    | 3.6.1    | MORE_THAN_ONE_STATEMENT_PER_LINE          | Check: warns if there is more than one statement per line.                                                                                                                                                                                                                                                                                                  | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 3    | 3.6.2    | REDUNDANT_SEMICOLON                       | Check: warns if semicolons are used at the end of a line.<br>Fix: removes the semicolon.                                                                                                                                                                                                                                                                    | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 3    | 3.6.2    | WRONG_NEWLINES                            | Check: warns if line breaks do not follow the code style guide.<br>Fix: fixes incorrect line breaks.                                                                                                                                                                                                                                                        | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 3    | 3.6.2    | COMPLEX_EXPRESSION                        | Check: warns if a long dot-qualified expression is used in a condition or as an argument.                                                                                                                                                                                                                                                                   | no  | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 3    | 3.6.2    | TRAILING_COMMA                            | Check: warns if a trailing comma is missing.                                                                                                                                                                                                                                                                                                                | yes | valueArgument valueParameter indices whenConditions collectionLiteral typeArgument typeParameter destructuringDeclaration                                                                                                  | -                                                                                                                                                                                                                                     |
| 3    | 3.7.1    | TOO_MANY_BLANK_LINES                      | Check: warns if blank lines are used or placed incorrectly.<br>Fix: removes redundant blank lines.                                                                                                                                                                                                                                                          | yes | no                                                                                                                                                                                                                         |                                                                                                                                                                                                                                       |
| 3    | 3.8.1    | WRONG_WHITESPACE                          | Check: warns if the usage of horizontal spaces violates the code style guide.<br>Fix: fixes incorrect whitespaces.                                                                                                                                                                                                                                          | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 3    | 3.8.1    | TOO_MANY_CONSECUTIVE_SPACES               | Check: warns if there are too many consecutive spaces in a line. Exception: in an enum if there is a configured and single eol comment. <br>Fix: squeezes spaces to 1.                                                                                                                                                                                      | yes | maxSpaces saveInitialFormattingForEnums                                                                                                                                                                                    | -                                                                                                                                                                                                                                     |
| 3    | 3.9.1    | ENUMS_SEPARATED                           | Check: warns if an enum structure is incorrect: the enum entries should be separated by a comma and a line break, and the last entry should have a semicolon in the end.                                                                                                                                                                                    | yes | no                                                                                                                                                                                                                         | Replace variable to enum if it possible.                                                                                                                                                                                              |
| 3    | 3.10.2   | LOCAL_VARIABLE_EARLY_DECLARATION          | Check: warns if a local variable is declared not immediately before its usage.<br>Fix (not implemented yet): moves the variable declaration.                                                                                                                                                                                                                | no  | no                                                                                                                                                                                                                         | add auto fix                                                                                                                                                                                                                          |
| 3    | 3.11.1   | WHEN_WITHOUT_ELSE                         | Check: warns if a `when` statement does not have `else` in the end.<br>Fix: adds `else` when a statement doesn't have it.                                                                                                                                                                                                                                   | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     | If a `when` statement of the enum or sealed type contains all values of the enum, there is no need to have the "else" branch.
| 3    | 3.12.1   | ANNOTATION_NEW_LINE                       | Check: warns if an annotation is not on a new single line.                                                                                                                                                                                                                                                                                                  | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 3    | 3.12.2   | PREVIEW_ANNOTATION                        | Check: warns if method, annotated with `@Preview` is not private or has no `Preview` suffix.                                                                                                                                                                                                                                                                | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 3    | 3.14.1   | WRONG_MULTIPLE_MODIFIERS_ORDER            | Check: warns if the multiple modifiers in the sequence are in the wrong order. Value identifier supported in Kotlin 1.5                                                                                                                                                                                                                                     | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 3    | 3.14.2   | LONG_NUMERICAL_VALUES_SEPARATED           | Check: warns if the value of the integer or float constant is too big.                                                                                                                                                                                                                                                                                      | no  | maxNumberLength maxBlockLength                                                                                                                                                                                             | -                                                                                                                                                                                                                                     |
| 3    | 3.14.3   | MAGIC_NUMBER                              | Check: warns if there are magic numbers in the code.                                                                                                                                                                                                                                                                                                        | no  | ignoreNumbers, ignoreHashCodeFunction, ignorePropertyDeclaration, ignoreLocalVariableDeclaration, ignoreConstantDeclaration, ignoreCompanionObjectPropertyDeclaration, ignoreEnums, ignoreRanges, ignoreExtensionFunctions | no                                                                                                                                                                                                                                    |
| 3    | 3.15.1   | STRING_CONCATENATION                      | Check: warns if the concatenation of strings is used in a single line.                                                                                                                                                                                                                                                                                      | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 3    | 3.15.2   | STRING_TEMPLATE_CURLY_BRACES              | Check: warns if there are redundant curly braces in the string template.<br> Fix: deletes the curly braces.                                                                                                                                                                                                                                                 | yes | no                                                                                                                                                                                                                         | +                                                                                                                                                                                                                                     |
| 3    | 3.15.2   | STRING_TEMPLATE_QUOTES                    | Check: warns if there are redundant quotes in the string template.<br> Fix: deletes the quotes and $ symbol.                                                                                                                                                                                                                                                | yes | no                                                                                                                                                                                                                         | +                                                                                                                                                                                                                                     |
| 3    | 3.16.1   | COLLAPSE_IF_STATEMENTS                    | Check: warns if there are redundant nested if-statements, which could be collapsed into a single statement by concatenating their conditions.                                                                                                                                                                                                               | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 3    | 3.16.2   | COMPLEX_BOOLEAN_EXPRESSION                | Check: warns if the boolean expression is complex and can be simplified.<br>Fix: replaces the boolean expression with a simpler one.                                                                                                                                                                                                                        | yes | no                                                                                                                                                                                                                         | +                                                                                                                                                                                                                                     |
| 3    | 3.17.1   | CONVENTIONAL_RANGE                        | Check: warns if it is possible to replace the range with `until` or replace the `rangeTo` function with a range.<br>Fix: replace range with `until` or replace the `rangeTo` function with a range.                                                                                                                                                         | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 3    | 3.18.1   | DEBUG_PRINT                               | Check: warns if there is a printing to console (assumption that it's a debug logging).                                                                                                                                                                                                                                                                      | no  | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 4    | 4.1.1    | FLOAT_IN_ACCURATE_CALCULATIONS            | Checks that floating-point values are not used in the arithmetic expressions.<br>Fix: no                                                                                                                                                                                                                                                                    | no  | no                                                                                                                                                                                                                         | Current implementation detects only floating-point constants.                                                                                                                                                                         |
| 4    | 4.1.3    | SAY_NO_TO_VAR                             | Check: warns if the `var` modifier is used for a local variable (not in a class or at file level), and this var is not used in accumulators.                                                                                                                                                                                                                | no  | no                                                                                                                                                                                                                         | no                                                                                                                                                                                                                                    | Several fixmes related to the search mechanism (VariablesSearch) and fixme for checking reassinment of this var
| 4    | 4.2.1    | SMART_CAST_NEEDED                         | Check: warns if the casting can be omitted.<br>Fix: Deletes casting.                                                                                                                                                                                                                                                                                        | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 4    | 4.2.2    | TYPE_ALIAS                                | Check: if the type reference of a property is longer than expected.                                                                                                                                                                                                                                                                                         | yes | typeReferenceLength                                                                                                                                                                                                        | -                                                                                                                                                                                                                                     |                                                                                                                                                                                                                        |
| 4    | 4.3.1    | NULLABLE_PROPERTY_TYPE                    | Check: warns if an immutable property is initialized with null, or if the immutable property can have non-nullable type instead of nullable.<br>Fix: suggests the initial value instead of null or changes in the immutable property type.                                                                                                                  | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 4    | 4.3.2    | GENERIC_VARIABLE_WRONG_DECLARATION        | Check: warns if variables of generic types don't have an explicit type declaration.<br>Fix: fixes only the variables that have a generic declaration on both sides.                                                                                                                                                                                         | yes | no                                                                                                                                                                                                                         | +                                                                                                                                                                                                                                     |
| 4    | 4.3.3    | AVOID_NULL_CHECKS                         | Check: warns if the null-check is used explicitly (for example: if (a == null)).                                                                                                                                                                                                                                                                            | yes | no                                                                                                                                                                                                                         | Fix if\else conditions on null.                                                                                                                                                                                                       |
| 5    | 5.1.1    | TOO_LONG_FUNCTION                         | Check: warns if the length of a function is too long.                                                                                                                                                                                                                                                                                                       | no  | maxFunctionLength isIncludeHeader                                                                                                                                                                                          |                                                                                                                                                                                                                                       |
| 5    | 5.1.2    | NESTED_BLOCK                              | Warns if a function has more nested blocks than expected.                                                                                                                                                                                                                                                                                                   | no  | maxNestedBlockQuantit                                                                                                                                                                                                      |                                                                                                                                                                                                                                       |
| 5    | 5.1.3    | AVOID_NESTED_FUNCTIONS                    | Check: Warns if there are nested functions.<br>Fix: declare the function in the outer scope.                                                                                                                                                                                                                                                                | yes | no                                                                                                                                                                                                                         | +                                                                                                                                                                                                                                     |
| 5    | 5.1.4    | INVERSE_FUNCTION_PREFERRED                | Check: Warns if a function call with "!" can be rewritten to the inverse function (!isEmpty() -> isNotEmpty()).<br>Fix: Rewrites the function call.                                                                                                                                                                                                         | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 5    | 5.2.1    | LAMBDA_IS_NOT_LAST_PARAMETER              | Checks that the lambda inside function parameters block is not at the end.                                                                                                                                                                                                                                                                                  | no  | no                                                                                                                                                                                                                         |                                                                                                                                                                                                                                       |
| 5    | 5.2.2    | TOO_MANY_PARAMETERS                       | Check: Warns if a function contains more parameters than allowed.                                                                                                                                                                                                                                                                                           | no  | maxParameterListSize                                                                                                                                                                                                       |                                                                                                                                                                                                                                       |
| 5    | 5.2.3    | WRONG_OVERLOADING_FUNCTION_ARGUMENTS      | Check: Warns if a function has overloading instead of using default arguments.                                                                                                                                                                                                                                                                              | no  | no                                                                                                                                                                                                                         |                                                                                                                                                                                                                                       |
| 5    | 5.2.4    | RUN_BLOCKING_INSIDE_ASYNC                 | Check: Warns if the runBlocking is used inside the async block code.                                                                                                                                                                                                                                                                                        | no  | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 5    | 5.2.5    | TOO_MANY_LINES_IN_LAMBDA                  | Checks that the long lambda has parameters.                                                                                                                                                                                                                                                                                                                 | no  | maxLambdaLength                                                                                                                                                                                                            |                                                                                                                                                                                                                                       |
| 5    | 5.2.6    | CUSTOM_LABEL                              | Check: Warns if using an unnecessary custom label.                                                                                                                                                                                                                                                                                                          | no  | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 5    | 5.2.7    | PARAMETER_NAME_IN_OUTER_LAMBDA            | Check: warns if the outer lambda uses an implicit parameter `it`.                                                                                                                                                                                                                                                                                           | no  | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 6    | 6.1.1    | SINGLE_CONSTRUCTOR_SHOULD_BE_PRIMARY      | Check: warns if there is only one secondary constructor in a class.<br>Fix: converts it to a primary constructor.                                                                                                                                                                                                                                           | yes | no                                                                                                                                                                                                                         | Support the more complicated logic of the constructor conversion.                                                                                                                                                                     |
| 6    | 6.1.2    | USE_DATA_CLASS                            | Check: if the class can be made as a data class.                                                                                                                                                                                                                                                                                                            | no  | no                                                                                                                                                                                                                         | yes                                                                                                                                                                                                                                   |
| 6    | 6.1.3    | EMPTY_PRIMARY_CONSTRUCTOR                 | Check: warns if there is an empty primary constructor.                                                                                                                                                                                                                                                                                                      | yes | no                                                                                                                                                                                                                         | yes                                                                                                                                                                                                                                   |
| 6    | 6.1.4    | MULTIPLE_INIT_BLOCKS                      | Checks that the classes have only one init block.                                                                                                                                                                                                                                                                                                           | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 6    | 6.1.5    | USELESS_SUPERTYPE                         | Checks if the override function can be removed.                                                                                                                                                                                                                                                                                                             | yes | no                                                                                                                                                                                                                         |                                                                                                                                                                                                                                       |
| 6    | 6.1.6    | CLASS_SHOULD_NOT_BE_ABSTRACT              | Checks if the abstract class has any abstract method. If not, it warns that the class must not be abstract.<br>Fix: deletes the abstract modifier.                                                                                                                                                                                                          | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 6    | 6.1.7    | NO_CORRESPONDING_PROPERTY                 | Checks: warns if with using "backing property" scheme, the name of a real and a back property are the same.                                                                                                                                                                                                                                                 | no  | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 6    | 6.1.8    | CUSTOM_GETTERS_SETTERS                    | Check that no custom getters and setters are used for the properties.                                                                                                                                                                                                                                                                                       | no  | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 6    | 6.1.9    | WRONG_NAME_OF_VARIABLE_INSIDE_ACCESSOR    | Checks if the name of a variable is used in the custom getter or setter.                                                                                                                                                                                                                                                                                    | no  | no                                                                                                                                                                                                                         |                                                                                                                                                                                                                                       |
| 6    | 6.1.10   | TRIVIAL_ACCESSORS_ARE_NOT_RECOMMENDED     | Checks if there are trivial getters or setters. <br> Fix: Delete the trivial getter or setter.                                                                                                                                                                                                                                                              | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 6    | 6.1.11   | COMPACT_OBJECT_INITIALIZATION             | Checks if the class instantiation can be wrapped in `apply` for better readability.                                                                                                                                                                                                                                                                         | yes | no                                                                                                                                                                                                                         |                                                                                                                                                                                                                                       |
| 6    | 6.1.12   | INLINE_CLASS_CAN_BE_USED                  | Check: warns if the class can be transferred to the inline class.                                                                                                                                                                                                                                                                                           | no  | no                                                                                                                                                                                                                         | yes                                                                                                                                                                                                                                   |
| 6    | 6.2.2    | EXTENSION_FUNCTION_SAME_SIGNATURE         | Checks if an extension function has the same signature as another extension function, and their classes are related.                                                                                                                                                                                                                                        | no  | no                                                                                                                                                                                                                         | +                                                                                                                                                                                                                                     |
| 6    | 6.2.3    | EXTENSION_FUNCTION_WITH_CLASS             | Check: if the file contains a class, then it can not have extension functions for the same class.                                                                                                                                                                                                                                                           | no  | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 6    | 6.2.4    | USE_LAST_INDEX                            | Check: change a property length - 1 to the property lastIndex.                                                                                                                                                                                                                                                                                              | no  | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 6    | 6.4.1    | AVOID_USING_UTILITY_CLASS                 | Checks if there is a class/object that can be replaced with the extension function.                                                                                                                                                                                                                                                                         | no  | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
| 6    | 6.4.2    | OBJECT_IS_PREFERRED                       | Check: if class is stateless, then it is preferred to use `object.`                                                                                                                                                                                                                                                                                         | yes | no                                                                                                                                                                                                                         | +                                                                                                                                                                                                                                     |
| 6    | 6.5.1    | RUN_IN_SCRIPT                             | Checks : if the kts script contains other functions except the run code.                                                                                                                                                                                                                                                                                    | yes | no                                                                                                                                                                                                                         | -                                                                                                                                                                                                                                     |
