// Copyright (c) 2023, Charles Mason <chuck+github@borboggle.com>
// All rights reserved.
// 
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree. 
#pragma once

namespace Systems::NES {

enum ADDRESSING_MODE {
    AM_ACCUM,
    AM_IMPLIED, 
    AM_IMMEDIATE,
    AM_ZEROPAGE,
    AM_ZEROPAGE_X,
    AM_ZEROPAGE_Y,
    AM_ABSOLUTE,
    AM_ABSOLUTE_X,
    AM_ABSOLUTE_Y,
    AM_INDIRECT,
    AM_INDIRECT_X,
    AM_INDIRECT_Y,
    AM_RELATIVE,

    UNIMPLEMENTED
};

enum CONTENT_BLOCK_TYPE {
    CONTENT_BLOCK_TYPE_DATA = 0,
    CONTENT_BLOCK_TYPE_CODE,
    CONTENT_BLOCK_TYPE_CHR,
};

enum CONTENT_BLOCK_DATA_TYPE {
    CONTENT_BLOCK_DATA_TYPE_UBYTE = 0,
    CONTENT_BLOCK_DATA_TYPE_UWORD
};

enum MIRRORING {
    MIRRORING_HORIZONTAL = 0,
    MIRRORING_VERTICAL,
    MIRRORING_FOUR_SCREEN,
};

enum PROGRAM_ROM_BANK_LOAD {
    PROGRAM_ROM_BANK_LOAD_LOW_16K,
    PROGRAM_ROM_BANK_LOAD_HIGH_16K
};

enum PROGRAM_ROM_BANK_SIZE {
    PROGRAM_ROM_BANK_SIZE_16K,
    PROGRAM_ROM_BANK_SIZE_32K
};

enum CHARACTER_ROM_BANK_LOAD {
    CHARACTER_ROM_BANK_LOAD_LOW,
    CHARACTER_ROM_BANK_LOAD_HIGH
};

enum CHARACTER_ROM_BANK_SIZE {
    CHARACTER_ROM_BANK_SIZE_4K,
    CHARACTER_ROM_BANK_SIZE_8K
};

} // namespace Systems::NES

