# Shared Clipboard app
Have a easy to remember **same** clipboard URL forever for your entire pastebin needs!

## Introduction
This project is like pastebin, with one key difference. When I want to share a snippet (or clip), I can tell them to go to the same URL every time I need to share a different one. It is very easy!

### Motivation
Recently, while using pastebin, me and my friends found using WhatsApp, Email or similar text services to share the link generated by pastebin. Which I found to be an extreme **antipattern**. Therefore, I thought emails are an asy to remember string!

## Features
- No need to share garbage strings like Jdjslv, etc! Just use Email!
- Choose between private and public clips
- Hide clips with ease
- Familiar and secure Google Sign In!
- Copy button to copy long text conveniently

### How to use (Scnario: Private clips)
- Say user 1 (user1@gmail.com) wants to share string "abc" to user 2(user2@gmail.com)
- User 1 logs in, makes a new clip with the content "abc" and allows user2@gmail.com.
- User 2 goes to shared-clipboard.com/user1@gmail.com
- Signs in using Google using the email ID user2@gmail.com
- Voila! Can see the shared text securely!

### How to use (Scenario: Public clips)
- Say user 1 (user1@gmail.com) wants to share string "abc" to user 2 or any other user (Can be multiple too)!
- User 1 logs in, makes a new clip with the content "abc".
- Now any user can go to shared-clipboard.com/user1@gmail.com
- And can access the shared text!

## How to install and run locally?
- Simple Next JS project
- Setup ENV file
  - DATABASE_URL: postgres DB, could be local...
  - NEXTAUTH_SECRET: any random string
  - NEXTAUTH_URL: http://localhost:3000 or deployed URL
  - GOOGLE_CLIENT_ID: google auth client ID
  - GOOGLE_CLIENT_SECRET: google auth client secret
- `npm install`
- `npx prisma db push`
- `npm run dev`

## How to Contribute?
- If you want to contribute, please check the open issues.
- Contact me

## About me
- Passionate Full stack dev and I love to build simple tools like this for myself and the world! 
- Email: sankalpmukim@gmail.com
- GitHub: https://github.com/sankalpmukim
