import {SearchIcon} from '@sanity/icons'
import {Box, Flex} from '@sanity/ui'
import {forwardRef, type KeyboardEvent} from 'react'
import {styled} from 'styled-components'

import {useTranslation} from '../../../../../../../i18n'
import {useSearchState} from '../../../contexts/search/useSearchState'
import {CustomTextInput} from '../../common/CustomTextInput'

interface FilterPopoverContentHeaderProps {
  ariaInputLabel: string
  onChange: (e: KeyboardEvent<HTMLInputElement>) => void
  onClear: () => void
  typeFilter: string
}

const SearchHeaderBox = styled(Box)`
  border-bottom: 1px solid ${({theme}) => theme.sanity.color.base.border};
  flex-shrink: 0;
`

const SearchHeaderContentFlex = styled(Flex)`
  box-sizing: border-box;
`

export const FilterPopoverContentHeader = forwardRef<
  HTMLInputElement,
  FilterPopoverContentHeaderProps
>(function FilterPopoverContentHeader({ariaInputLabel, onChange, onClear, typeFilter}, ref) {
  const {
    state: {fullscreen},
  } = useSearchState()
  const {t} = useTranslation()

  return (
    <SearchHeaderBox>
      <SearchHeaderContentFlex align="center" flex={1} padding={1}>
        <CustomTextInput
          __unstable_disableFocusRing
          $smallClearButton
          aria-label={ariaInputLabel}
          autoComplete="off"
          border={false}
          clearButton={!!typeFilter}
          fontSize={fullscreen ? 2 : 1}
          icon={SearchIcon}
          muted
          onChange={onChange}
          onClear={onClear}
          placeholder={t('search.filter-placeholder')}
          ref={ref}
          spellCheck={false}
          radius={2}
          value={typeFilter}
        />
      </SearchHeaderContentFlex>
    </SearchHeaderBox>
  )
})
