import {type SVGProps} from 'react'

interface Props {
  props?: SVGProps<SVGSVGElement>
}

const BigIconScreen = (props: Props) => {
  return (
    <svg
      width="100"
      height="100"
      viewBox="0 0 100 100"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <path
        d="M35 84.5L41.7308 67H50V69.5M65 84.5L58.2692 67M32 65H42.5H50H57.5H81V23H19V65H24"
        stroke="#7B8CA8"
        strokeWidth="1.2"
      />
      <path d="M84 16V23H16V16M84 16H16M84 16L82 14H18L16 16" stroke="#7B8CA8" strokeWidth="1.2" />
      <path d="M24 65H18L17 67H83L82 65H32" stroke="#7B8CA8" strokeWidth="1.2" />
      <circle cx="50" cy="72" r="2" stroke="#7B8CA8" strokeWidth="1.2" />
      <path
        d="M24 63C24 61.8954 24.8954 61 26 61H30C31.1046 61 32 61.8954 32 63V67H24V63Z"
        stroke="#7B8CA8"
        strokeWidth="1.2"
      />
      <path
        d="M24 65C24 63.8954 24.8954 63 26 63H30C31.1046 63 32 63.8954 32 65V67H24V65Z"
        stroke="#7B8CA8"
        strokeWidth="1.2"
      />
      <path
        d="M28 44.9975C31.0617 44.62 33.5601 42.4793 35.2478 39.995C36.199 38.5947 36.9116 37.0761 36.9653 35.3597C36.9973 34.3355 36.8332 33.1459 35.8944 32.5454C35.3035 32.1675 34.4935 32.0285 33.8044 32.0022C32.7788 31.9631 32.1643 32.4357 31.8489 33.4197C30.3123 38.2145 33.0184 42.7025 36.3911 45.8977C38.1152 47.531 40.0746 48.9275 42.1179 50.1294C43.9867 51.2287 46.003 52.2595 48.1189 52.7885C48.9466 52.9954 50.4951 53.3913 51.3211 52.954C52.3579 52.4051 51.8285 49.7323 51.7091 48.9809C51.3862 46.9486 50.7293 45.0311 49.8726 43.1662C49.3791 42.0918 48.7948 40.8004 47.9999 39.8967C47.4959 39.3237 47.1331 39.4889 47.1101 40.2278C47.0699 41.5204 47.5768 42.7535 48.3103 43.7973C50.633 47.1024 54.4924 49.4656 58.2792 50.6985C59.9643 51.2471 61.8953 51.7306 63.6853 51.6193C65.3845 51.5137 65.6225 50.1321 65.7287 48.655C65.9958 44.9405 64.9629 40.7695 62.6403 37.7963C61.615 36.4839 60.3547 35.6334 58.6879 35.4476C57.7554 35.3437 56.665 35.3303 55.7391 35.5097C54.8073 35.6903 54.0162 36.297 54.3371 37.3462C54.6464 38.3572 55.8044 39.0666 56.6444 39.5759C57.983 40.3876 59.4813 40.9898 61.0262 41.2624C63.2658 41.6576 65.1745 41.1715 67.141 40.1346C67.9966 39.6835 68.8825 39.1795 69.4379 38.3861"
        stroke="#7B8CA8"
        strokeWidth="1.2"
      />
    </svg>
  )
}

export default BigIconScreen
