<p align="center">
  <a href="https://sanity.io">
    <img src="https://cdn.sanity.io/images/3do82whm/next/1dfce9dde7a62ccaa8e8377254a1e919f6c07ad3-128x128.svg" />
  </a>
  <h1 align="center">Sanity</h1>
  <h4 align="center">
    <a href="https://www.sanity.io/get-started?ref=gh">Get Started</a> |
    <a href="https://www.sanity.io/docs">Docs</a> |
    <a href="https://www.sanity.io">Website</a>
  </h4>
</p>

<p align="center">
  <img alt="" src="https://img.shields.io/npm/v/sanity?style=flat">
  <img alt="" src="https://img.shields.io/npm/dm/@sanity/client?style=flat">
  <img alt="" src="https://img.shields.io/npm/l/sanity.svg?style=flat">
  <a aria-label="Join the community on Slack" href="https://slack.sanity.io">
    <img alt="" src="https://img.shields.io/badge/Join%20Slack-f03e2f?logo=Slack&style=flat">
  </a>
  <a aria-label="Follow Sanity on Twitter" href="https://twitter.com/sanity_io">
    <img alt="" src="https://img.shields.io/twitter/follow/sanity_io?style=flat&color=blue">
  </a>
</p>

## Build powerful production-ready content workspaces

> The Sanity Composable Content Cloud lets teams create remarkable digital experiences at scale. Sanity Studio is an open-source, single-page application that is fast to set up and quick to configure. The Studio comes with a complete studio customization framework that lets you tailor the workspace as your needs grow.
>
> Sanity hosts your content in a real-time, hosted data store called Content Lake. [Get started](https://www.sanity.io/get-started?ref=gh) with the free plan with generous bandwidth and hosting included and pay-as-you-go for overages.

## Quickstart

Initiate a new project by running the following command:

```bash
npm create sanity@latest

# With other package managers:
yarn create sanity@latest
pnpm create sanity@latest
```

[Go here for a step-by-step guide](https://www.sanity.io/docs/getting-started-with-sanity) on how to get up and running.

Check out [the docs](https://www.sanity.io/docs/sanity-studio) and [plugins](https://www.sanity.io/plugins) and start building.

## Key Features

![Sanity Studio](https://cdn.sanity.io/images/3do82whm/next/634bd76e8333f9c824a3f09ff563b5373bcfac3a-7684x4322.png?w=2000&fit=max&auto=format&dpr=2)

### [Sanity Studio](https://www.sanity.io/studio)

[Sanity Studio](https://www.sanity.io/studio) is an open-source real-time CMS, that you can customize with JavaScript and React.

- Efficient editing, instant UI for complex fields
- Responsive, works on narrow screens
- [Plug-in architecture](https://www.sanity.io/plugins) and [custom components](https://www.sanity.io/docs/component-api)
- [Style with your own branding](https://www.sanity.io/docs/theming)
- [Advanced block editor for structured content](https://www.sanity.io/docs/block-content)
- Use JavaScript to add [field validations](https://www.sanity.io/docs/validation), [organize documents](https://www.sanity.io/docs/overview-structure-builder), and set [initial values](https://www.sanity.io/docs/theming)

### [Developer experience](https://www.sanity.io/developer-experience)

- [Bring your own frontend, or whatever else you might need](https://www.sanity.io/docs/build-with-sanity).
- [Sweet APIs for reading, writing, importing, exporting, go back in time, and listening for updates](https://www.sanity.io/docs/datastore).
- [Secure, scalable and GDPR compliant](https://www.sanity.io/security).
- [Zero config Graph Oriented Query Language (GROQ)](https://www.sanity.io/docs/how-queries-work), and [GraphQL API](https://www.sanity.io/docs/graphql).
- [Helpful and friendly developer community](https://slack.sanity.io).

### [Structured Content](https://www.sanity.io/structured-content)

- Distribute from a single source of truth, in real-time.
- Unlock programmatic approaches to workflows and design.
- [Upload images and transform them on demand](https://www.sanity.io/docs/asset-pipeline).
- Query images for metadata like dominant colors, sizes, geo-location, and EXIF metadata.
- [Rich text that can be serialized into any markup language](https://www.sanity.io/guides/introduction-to-portable-text).

## Stay up to date

- Follow **@sanity_io** on [Twitter](https://twitter.com/sanity_io)
- Subscribe to [our blog by RSS](https://www.sanity.io/feed/rss)
- Subscribe to our [newsletter](http://eepurl.com/b2yaDz)
- Join the [developer community on Slack](https://slack.sanity.io)

## Code of Conduct

We aim to be an inclusive, welcoming community for everyone. To make that explicit, we have a [code of conduct](https://github.com/sanity-io/sanity/blob/current/CODE_OF_CONDUCT.md) that applies to communication around the project.

## Want to contribute?

Found a bug, or want to contribute code? Pull requests and issues are most welcome. Read our [contributing guidelines](https://github.com/sanity-io/sanity/blob/current/CONTRIBUTING.md) to learn how.

### Help Improve Sanity Studio translations

We're always looking to make Sanity Studio more accessible and user-friendly, and your contributions can make a big difference. Whether you're a seasoned developer or just starting out, helping with translations is a fantastic way to get involved.

If you're fluent in a language other than English, we'd love your help in reviewing and improving translations. Your expertise can greatly enhance the experience for users worldwide.

How to Contribute:

1. Visit our [sanity-io/locales](https://github.com/sanity-io/locales) repository and try out a locale you are fluent in.
2. Have ideas for improvements? Submit a PR following the [contributing guide](https://github.com/sanity-io/locales/blob/main/CONTRIBUTING.md#getting-started).
3. See if there are open PRs in languages you are fluent in and help review them.

Interested in playing a bigger role? You can ask to be added as a maintainer to oversee translations for specific languages, where you will be automatically added as a reviewer on PRs that involve your language. See the [sanity-io/locales README](https://github.com/sanity-io/locales#readme) for more.

Your contributions not only improve Sanity Studio but also bring together a diverse and global community of users. We appreciate every effort, big or small, and we can't wait to see what you bring to the table!

## License

Sanity Studio is available under the [_MIT License_](https://github.com/sanity-io/sanity/blob/current/LICENSE)
