import {buildLegacyTheme} from 'sanity'

const color = {
  'geist-foreground': '#000',
  'geist-background': '#fff',
  'geist-success': '#2276fc',
  'geist-error': '#f03e2f',
  'geist-warning': '#f5a623',
  'geist-warning-lighter': '#ffefcf',
  'geist-highlight-purple': '#f81ce5',

  'accents-1': '#fafafa',
  'accents-2': '#eaeaea',
  'accents-3': '#999',
  'accents-4': '#888',
  'accents-5': '#666',
  'accents-6': '#444',
  'accents-7': '#333',
  'accents-8': '#111',
}

const legacyTheme = buildLegacyTheme({
  // Base
  '--black': color['geist-background'],
  '--white': color['geist-background'],

  // Gray
  '--gray-base': color['accents-5'],
  '--gray': color['accents-5'],

  '--component-bg': color['geist-background'],
  '--component-text-color': color['geist-foreground'],

  // Brand
  '--brand-primary': color['geist-foreground'],

  // Main navigation
  '--main-navigation-color': color['geist-background'],
  '--main-navigation-color--inverted': color['geist-foreground'],

  // Default button
  '--default-button-color': color['geist-foreground'],
  '--default-button-primary-color': color['geist-highlight-purple'],
  '--default-button-success-color': color['geist-success'],
  '--default-button-warning-color': color['geist-warning'],
  '--default-button-danger-color': color['geist-error'],

  // State
  '--state-success-color': color['geist-success'],
  '--state-info-color': color['geist-highlight-purple'],
  '--state-warning-color': color['geist-warning'],
  '--state-danger-color': color['geist-error'],

  // Focus
  '--focus-color': color['geist-highlight-purple'],
})

export const vercelTheme = {
  ...legacyTheme,
  // space: legacyTheme.space.map((v) => v * 2),
}
