import {buildLegacyTheme} from 'sanity'

const props = {
  '--google-white': '#fff',
  '--google-black': '#1a1a1a',
  '--google-blue': '#4285f4',
  '--google-red': '#db4437',
  '--google-yellow': '#f4b400',
  '--google-green': '#0f9d58',
}

export const googleTheme = buildLegacyTheme({
  /* Base theme colors */
  '--black': props['--google-black'],
  '--white': props['--google-white'],

  '--gray': '#666',
  '--gray-base': '#666',

  '--component-bg': props['--google-white'],
  '--component-text-color': props['--google-black'],

  /* Brand */
  '--brand-primary': props['--google-blue'],

  // Default button
  '--default-button-color': '#666',
  '--default-button-primary-color': props['--google-blue'],
  '--default-button-success-color': props['--google-green'],
  '--default-button-warning-color': props['--google-yellow'],
  '--default-button-danger-color': props['--google-red'],

  /* State */
  '--state-info-color': props['--google-blue'],
  '--state-success-color': props['--google-green'],
  '--state-warning-color': props['--google-yellow'],
  '--state-danger-color': props['--google-red'],

  /* Navbar */
  '--main-navigation-color': props['--google-black'],
  '--main-navigation-color--inverted': props['--google-white'],

  '--focus-color': props['--google-blue'],
})
