// Copyright 2024 Hugeicons. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// This file is based on https://github.com/hugeicons/hugeicons-flutter
// Modified to add @staticIconProvider annotation for tree-shaking support.

part of 'ui.dart';

/// A collection of stroke-rounded icons for use in Flutter applications.
///
/// The [HugeIcons] class provides a comprehensive set of stroke-rounded icons
/// for enhancing the UI design of your Flutter applications.
@staticIconProvider
abstract final class HugeIcons {
  /// IconData for the 'strokeRoundedAbacus' icon.
  static const IconData strokeRoundedAbacus =
      IconData(0x3a9c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAbsolute' icon.
  static const IconData strokeRoundedAbsolute =
      IconData(0x3a9d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAcceleration' icon.
  static const IconData strokeRoundedAcceleration =
      IconData(0x3a9e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAccess' icon.
  static const IconData strokeRoundedAccess =
      IconData(0x3a9f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAccident' icon.
  static const IconData strokeRoundedAccident =
      IconData(0x3aa0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAccountSetting01' icon.
  static const IconData strokeRoundedAccountSetting01 =
      IconData(0x3aa1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAccountSetting02' icon.
  static const IconData strokeRoundedAccountSetting02 =
      IconData(0x3aa2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAccountSetting03' icon.
  static const IconData strokeRoundedAccountSetting03 =
      IconData(0x3aa3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedActivity01' icon.
  static const IconData strokeRoundedActivity01 =
      IconData(0x3aa4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedActivity02' icon.
  static const IconData strokeRoundedActivity02 =
      IconData(0x3aa5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedActivity03' icon.
  static const IconData strokeRoundedActivity03 =
      IconData(0x3aa6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedActivity04' icon.
  static const IconData strokeRoundedActivity04 =
      IconData(0x3aa7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAcute' icon.
  static const IconData strokeRoundedAcute =
      IconData(0x3aa8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAdd01' icon.
  static const IconData strokeRoundedAdd01 =
      IconData(0x3aa9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAdd02' icon.
  static const IconData strokeRoundedAdd02 =
      IconData(0x3aaa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAddCircleHalfDot' icon.
  static const IconData strokeRoundedAddCircleHalfDot =
      IconData(0x3aab, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAddCircle' icon.
  static const IconData strokeRoundedAddCircle =
      IconData(0x3aac, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAddSquare' icon.
  static const IconData strokeRoundedAddSquare =
      IconData(0x3aad, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAddTeam' icon.
  static const IconData strokeRoundedAddTeam =
      IconData(0x3aae, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAddressBook' icon.
  static const IconData strokeRoundedAddressBook =
      IconData(0x3aaf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAdobeAfterEffect' icon.
  static const IconData strokeRoundedAdobeAfterEffect =
      IconData(0x3ab0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAdobeIllustrator' icon.
  static const IconData strokeRoundedAdobeIllustrator =
      IconData(0x3ab1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAdobeIndesign' icon.
  static const IconData strokeRoundedAdobeIndesign =
      IconData(0x3ab2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAdobePhotoshop' icon.
  static const IconData strokeRoundedAdobePhotoshop =
      IconData(0x3ab3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAdobePremier' icon.
  static const IconData strokeRoundedAdobePremier =
      IconData(0x3ab4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAdobeXd' icon.
  static const IconData strokeRoundedAdobeXd =
      IconData(0x3ab5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAdventure' icon.
  static const IconData strokeRoundedAdventure =
      IconData(0x3ab6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAdvertisiment' icon.
  static const IconData strokeRoundedAdvertisiment =
      IconData(0x3ab7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAdzan' icon.
  static const IconData strokeRoundedAdzan =
      IconData(0x3ab8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAffiliate' icon.
  static const IconData strokeRoundedAffiliate =
      IconData(0x3ab9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAgreement01' icon.
  static const IconData strokeRoundedAgreement01 =
      IconData(0x3aba, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAgreement02' icon.
  static const IconData strokeRoundedAgreement02 =
      IconData(0x3abb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAgreement03' icon.
  static const IconData strokeRoundedAgreement03 =
      IconData(0x3abc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiBeautify' icon.
  static const IconData strokeRoundedAiBeautify =
      IconData(0x3abd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiBook' icon.
  static const IconData strokeRoundedAiBook =
      IconData(0x3abe, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiBrain01' icon.
  static const IconData strokeRoundedAiBrain01 =
      IconData(0x3abf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiBrain02' icon.
  static const IconData strokeRoundedAiBrain02 =
      IconData(0x3ac0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiBrain03' icon.
  static const IconData strokeRoundedAiBrain03 =
      IconData(0x3ac1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiBrain04' icon.
  static const IconData strokeRoundedAiBrain04 =
      IconData(0x3ac2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiBrain05' icon.
  static const IconData strokeRoundedAiBrain05 =
      IconData(0x3ac3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiBrowser' icon.
  static const IconData strokeRoundedAiBrowser =
      IconData(0x3ac4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiChat01' icon.
  static const IconData strokeRoundedAiChat01 =
      IconData(0x3ac5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiChat02' icon.
  static const IconData strokeRoundedAiChat02 =
      IconData(0x3ac6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiCloud01' icon.
  static const IconData strokeRoundedAiCloud01 =
      IconData(0x3ac7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiCloud02' icon.
  static const IconData strokeRoundedAiCloud02 =
      IconData(0x3ac8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiCloud' icon.
  static const IconData strokeRoundedAiCloud =
      IconData(0x3ac9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiComputer' icon.
  static const IconData strokeRoundedAiComputer =
      IconData(0x3aca, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiDna' icon.
  static const IconData strokeRoundedAiDna =
      IconData(0x3acb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiEraser' icon.
  static const IconData strokeRoundedAiEraser =
      IconData(0x3acc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiFolder01' icon.
  static const IconData strokeRoundedAiFolder01 =
      IconData(0x3acd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiFolder02' icon.
  static const IconData strokeRoundedAiFolder02 =
      IconData(0x3ace, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiGame' icon.
  static const IconData strokeRoundedAiGame =
      IconData(0x3acf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiGenerative' icon.
  static const IconData strokeRoundedAiGenerative =
      IconData(0x3ad0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiIdea' icon.
  static const IconData strokeRoundedAiIdea =
      IconData(0x3ad1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiImage' icon.
  static const IconData strokeRoundedAiImage =
      IconData(0x3ad2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiInnovation01' icon.
  static const IconData strokeRoundedAiInnovation01 =
      IconData(0x3ad3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiInnovation02' icon.
  static const IconData strokeRoundedAiInnovation02 =
      IconData(0x3ad4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiInnovation03' icon.
  static const IconData strokeRoundedAiInnovation03 =
      IconData(0x3ad5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiLaptop' icon.
  static const IconData strokeRoundedAiLaptop =
      IconData(0x3ad6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiLearning' icon.
  static const IconData strokeRoundedAiLearning =
      IconData(0x3ad7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiLock' icon.
  static const IconData strokeRoundedAiLock =
      IconData(0x3ad8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiMagic' icon.
  static const IconData strokeRoundedAiMagic =
      IconData(0x3ad9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiMail01' icon.
  static const IconData strokeRoundedAiMail01 =
      IconData(0x3ada, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiMail02' icon.
  static const IconData strokeRoundedAiMail02 =
      IconData(0x3adb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiMail' icon.
  static const IconData strokeRoundedAiMail =
      IconData(0x3adc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiNetwork' icon.
  static const IconData strokeRoundedAiNetwork =
      IconData(0x3add, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiPhone01' icon.
  static const IconData strokeRoundedAiPhone01 =
      IconData(0x3ade, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiPhone02' icon.
  static const IconData strokeRoundedAiPhone02 =
      IconData(0x3adf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiProgramming' icon.
  static const IconData strokeRoundedAiProgramming =
      IconData(0x3ae0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiSearch' icon.
  static const IconData strokeRoundedAiSearch =
      IconData(0x3ae1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiSecurity01' icon.
  static const IconData strokeRoundedAiSecurity01 =
      IconData(0x3ae2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiSecurity02' icon.
  static const IconData strokeRoundedAiSecurity02 =
      IconData(0x3ae3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiSetting' icon.
  static const IconData strokeRoundedAiSetting =
      IconData(0x3ae4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiSmartwatch' icon.
  static const IconData strokeRoundedAiSmartwatch =
      IconData(0x3ae5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiUser' icon.
  static const IconData strokeRoundedAiUser =
      IconData(0x3ae6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiVideo' icon.
  static const IconData strokeRoundedAiVideo =
      IconData(0x3ae7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAiView' icon.
  static const IconData strokeRoundedAiView =
      IconData(0x3ae8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAids' icon.
  static const IconData strokeRoundedAids =
      IconData(0x3ae9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAirbnb' icon.
  static const IconData strokeRoundedAirbnb =
      IconData(0x3aea, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAircraftGame' icon.
  static const IconData strokeRoundedAircraftGame =
      IconData(0x3aeb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAirdrop' icon.
  static const IconData strokeRoundedAirdrop =
      IconData(0x3aec, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAirplane01' icon.
  static const IconData strokeRoundedAirplane01 =
      IconData(0x3aed, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAirplane02' icon.
  static const IconData strokeRoundedAirplane02 =
      IconData(0x3aee, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAirplaneLanding01' icon.
  static const IconData strokeRoundedAirplaneLanding01 =
      IconData(0x3aef, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAirplaneLanding02' icon.
  static const IconData strokeRoundedAirplaneLanding02 =
      IconData(0x3af0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAirplaneModeOff' icon.
  static const IconData strokeRoundedAirplaneModeOff =
      IconData(0x3af1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAirplaneMode' icon.
  static const IconData strokeRoundedAirplaneMode =
      IconData(0x3af2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAirplaneSeat' icon.
  static const IconData strokeRoundedAirplaneSeat =
      IconData(0x3af3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAirplaneTakeOff01' icon.
  static const IconData strokeRoundedAirplaneTakeOff01 =
      IconData(0x3af4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAirplaneTakeOff02' icon.
  static const IconData strokeRoundedAirplaneTakeOff02 =
      IconData(0x3af5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAirplayLine' icon.
  static const IconData strokeRoundedAirplayLine =
      IconData(0x3af6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAirpod01' icon.
  static const IconData strokeRoundedAirpod01 =
      IconData(0x3af7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAirpod02' icon.
  static const IconData strokeRoundedAirpod02 =
      IconData(0x3af8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAirpod03' icon.
  static const IconData strokeRoundedAirpod03 =
      IconData(0x3af9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAirport' icon.
  static const IconData strokeRoundedAirport =
      IconData(0x3afa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlAqsaMosque' icon.
  static const IconData strokeRoundedAlAqsaMosque =
      IconData(0x3afb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlarmClock' icon.
  static const IconData strokeRoundedAlarmClock =
      IconData(0x3afc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlbum01' icon.
  static const IconData strokeRoundedAlbum01 =
      IconData(0x3afd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlbum02' icon.
  static const IconData strokeRoundedAlbum02 =
      IconData(0x3afe, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlbumNotFound01' icon.
  static const IconData strokeRoundedAlbumNotFound01 =
      IconData(0x3aff, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlbumNotFound02' icon.
  static const IconData strokeRoundedAlbumNotFound02 =
      IconData(0x3b00, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlert01' icon.
  static const IconData strokeRoundedAlert01 =
      IconData(0x3b01, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlert02' icon.
  static const IconData strokeRoundedAlert02 =
      IconData(0x3b02, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlertCircle' icon.
  static const IconData strokeRoundedAlertCircle =
      IconData(0x3b03, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlertDiamond' icon.
  static const IconData strokeRoundedAlertDiamond =
      IconData(0x3b04, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlertSquare' icon.
  static const IconData strokeRoundedAlertSquare =
      IconData(0x3b05, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlgorithm' icon.
  static const IconData strokeRoundedAlgorithm =
      IconData(0x3b06, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlien01' icon.
  static const IconData strokeRoundedAlien01 =
      IconData(0x3b07, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlien02' icon.
  static const IconData strokeRoundedAlien02 =
      IconData(0x3b08, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlignBottom' icon.
  static const IconData strokeRoundedAlignBottom =
      IconData(0x3b09, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlignBoxBottomCenter' icon.
  static const IconData strokeRoundedAlignBoxBottomCenter =
      IconData(0x3b0a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlignBoxBottomLeft' icon.
  static const IconData strokeRoundedAlignBoxBottomLeft =
      IconData(0x3b0b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlignBoxBottomRight' icon.
  static const IconData strokeRoundedAlignBoxBottomRight =
      IconData(0x3b0c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlignBoxMiddleCenter' icon.
  static const IconData strokeRoundedAlignBoxMiddleCenter =
      IconData(0x3b0d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlignBoxMiddleLeft' icon.
  static const IconData strokeRoundedAlignBoxMiddleLeft =
      IconData(0x3b0e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlignBoxMiddleRight' icon.
  static const IconData strokeRoundedAlignBoxMiddleRight =
      IconData(0x3b0f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlignBoxTopCenter' icon.
  static const IconData strokeRoundedAlignBoxTopCenter =
      IconData(0x3b10, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlignBoxTopLeft' icon.
  static const IconData strokeRoundedAlignBoxTopLeft =
      IconData(0x3b11, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlignBoxTopRight' icon.
  static const IconData strokeRoundedAlignBoxTopRight =
      IconData(0x3b12, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlignHorizontalCenter' icon.
  static const IconData strokeRoundedAlignHorizontalCenter =
      IconData(0x3b13, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlignKeyObject' icon.
  static const IconData strokeRoundedAlignKeyObject =
      IconData(0x3b14, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlignLeft' icon.
  static const IconData strokeRoundedAlignLeft =
      IconData(0x3b15, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlignRight' icon.
  static const IconData strokeRoundedAlignRight =
      IconData(0x3b16, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlignSelection' icon.
  static const IconData strokeRoundedAlignSelection =
      IconData(0x3b17, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlignTop' icon.
  static const IconData strokeRoundedAlignTop =
      IconData(0x3b18, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlignVerticalCenter' icon.
  static const IconData strokeRoundedAlignVerticalCenter =
      IconData(0x3b19, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAllBookmark' icon.
  static const IconData strokeRoundedAllBookmark =
      IconData(0x3b1a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAllah' icon.
  static const IconData strokeRoundedAllah =
      IconData(0x3b1b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlms' icon.
  static const IconData strokeRoundedAlms =
      IconData(0x3b1c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlphaCircle' icon.
  static const IconData strokeRoundedAlphaCircle =
      IconData(0x3b1d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlphaSquare' icon.
  static const IconData strokeRoundedAlphaSquare =
      IconData(0x3b1e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlpha' icon.
  static const IconData strokeRoundedAlpha =
      IconData(0x3b1f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlphabetArabic' icon.
  static const IconData strokeRoundedAlphabetArabic =
      IconData(0x3b20, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlphabetBangla' icon.
  static const IconData strokeRoundedAlphabetBangla =
      IconData(0x3b21, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlphabetChinese' icon.
  static const IconData strokeRoundedAlphabetChinese =
      IconData(0x3b22, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlphabetGreek' icon.
  static const IconData strokeRoundedAlphabetGreek =
      IconData(0x3b23, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlphabetHebrew' icon.
  static const IconData strokeRoundedAlphabetHebrew =
      IconData(0x3b24, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlphabetHindi' icon.
  static const IconData strokeRoundedAlphabetHindi =
      IconData(0x3b25, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlphabetJapanese' icon.
  static const IconData strokeRoundedAlphabetJapanese =
      IconData(0x3b26, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlphabetKorean' icon.
  static const IconData strokeRoundedAlphabetKorean =
      IconData(0x3b27, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAlphabetThai' icon.
  static const IconData strokeRoundedAlphabetThai =
      IconData(0x3b28, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAmazon' icon.
  static const IconData strokeRoundedAmazon =
      IconData(0x3b29, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAmbulance' icon.
  static const IconData strokeRoundedAmbulance =
      IconData(0x3b2a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAmericanFootball' icon.
  static const IconData strokeRoundedAmericanFootball =
      IconData(0x3b2b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAmie' icon.
  static const IconData strokeRoundedAmie =
      IconData(0x3b2c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAmpoule' icon.
  static const IconData strokeRoundedAmpoule =
      IconData(0x3b2d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAnalysisTextLink' icon.
  static const IconData strokeRoundedAnalysisTextLink =
      IconData(0x3b2e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAnalytics01' icon.
  static const IconData strokeRoundedAnalytics01 =
      IconData(0x3b2f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAnalytics02' icon.
  static const IconData strokeRoundedAnalytics02 =
      IconData(0x3b30, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAnalyticsDown' icon.
  static const IconData strokeRoundedAnalyticsDown =
      IconData(0x3b31, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAnalyticsUp' icon.
  static const IconData strokeRoundedAnalyticsUp =
      IconData(0x3b32, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAnchorPoint' icon.
  static const IconData strokeRoundedAnchorPoint =
      IconData(0x3b33, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAndroid' icon.
  static const IconData strokeRoundedAndroid =
      IconData(0x3b34, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAngel' icon.
  static const IconData strokeRoundedAngel =
      IconData(0x3b35, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAngle01' icon.
  static const IconData strokeRoundedAngle01 =
      IconData(0x3b36, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAngle' icon.
  static const IconData strokeRoundedAngle =
      IconData(0x3b37, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAngryBird' icon.
  static const IconData strokeRoundedAngryBird =
      IconData(0x3b38, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAngry' icon.
  static const IconData strokeRoundedAngry =
      IconData(0x3b39, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAnonymous' icon.
  static const IconData strokeRoundedAnonymous =
      IconData(0x3b3a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedApi' icon.
  static const IconData strokeRoundedApi =
      IconData(0x3b3b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAppStore' icon.
  static const IconData strokeRoundedAppStore =
      IconData(0x3b3c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedApple01' icon.
  static const IconData strokeRoundedApple01 =
      IconData(0x3b3d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAppleFinder' icon.
  static const IconData strokeRoundedAppleFinder =
      IconData(0x3b3e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAppleNews' icon.
  static const IconData strokeRoundedAppleNews =
      IconData(0x3b3f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedApplePie' icon.
  static const IconData strokeRoundedApplePie =
      IconData(0x3b40, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAppleReminder' icon.
  static const IconData strokeRoundedAppleReminder =
      IconData(0x3b41, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAppleStocks' icon.
  static const IconData strokeRoundedAppleStocks =
      IconData(0x3b42, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAppleVisionPro' icon.
  static const IconData strokeRoundedAppleVisionPro =
      IconData(0x3b43, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedApple' icon.
  static const IconData strokeRoundedApple =
      IconData(0x3b44, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedApproximatelyEqualCircle' icon.
  static const IconData strokeRoundedApproximatelyEqualCircle =
      IconData(0x3b45, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedApproximatelyEqualSquare' icon.
  static const IconData strokeRoundedApproximatelyEqualSquare =
      IconData(0x3b46, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedApproximatelyEqual' icon.
  static const IconData strokeRoundedApproximatelyEqual =
      IconData(0x3b47, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedApricot' icon.
  static const IconData strokeRoundedApricot =
      IconData(0x3b48, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedApron' icon.
  static const IconData strokeRoundedApron =
      IconData(0x3b49, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArcBrowser' icon.
  static const IconData strokeRoundedArcBrowser =
      IconData(0x3b4a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArcher' icon.
  static const IconData strokeRoundedArcher =
      IconData(0x3b4b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArchive01' icon.
  static const IconData strokeRoundedArchive01 =
      IconData(0x3b4c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArchive02' icon.
  static const IconData strokeRoundedArchive02 =
      IconData(0x3b4d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArchive' icon.
  static const IconData strokeRoundedArchive =
      IconData(0x3b4e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArmoredBoot' icon.
  static const IconData strokeRoundedArmoredBoot =
      IconData(0x3b4f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrangeByLettersAZ' icon.
  static const IconData strokeRoundedArrangeByLettersAZ =
      IconData(0x3b50, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrangeByLettersZA' icon.
  static const IconData strokeRoundedArrangeByLettersZA =
      IconData(0x3b51, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrangeByNumbers19' icon.
  static const IconData strokeRoundedArrangeByNumbers19 =
      IconData(0x3b52, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrangeByNumbers91' icon.
  static const IconData strokeRoundedArrangeByNumbers91 =
      IconData(0x3b53, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrange' icon.
  static const IconData strokeRoundedArrange =
      IconData(0x3b54, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowAllDirection' icon.
  static const IconData strokeRoundedArrowAllDirection =
      IconData(0x3b55, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowDataTransferDiagonal' icon.
  static const IconData strokeRoundedArrowDataTransferDiagonal =
      IconData(0x3b56, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowDataTransferHorizontal' icon.
  static const IconData strokeRoundedArrowDataTransferHorizontal =
      IconData(0x3b57, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowDataTransferVertical' icon.
  static const IconData strokeRoundedArrowDataTransferVertical =
      IconData(0x3b58, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowDiagonal' icon.
  static const IconData strokeRoundedArrowDiagonal =
      IconData(0x3b59, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowDown01' icon.
  static const IconData strokeRoundedArrowDown01 =
      IconData(0x3b5a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowDown02' icon.
  static const IconData strokeRoundedArrowDown02 =
      IconData(0x3b5b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowDown03' icon.
  static const IconData strokeRoundedArrowDown03 =
      IconData(0x3b5c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowDown04' icon.
  static const IconData strokeRoundedArrowDown04 =
      IconData(0x3b5d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowDown05' icon.
  static const IconData strokeRoundedArrowDown05 =
      IconData(0x3b5e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowDownDouble' icon.
  static const IconData strokeRoundedArrowDownDouble =
      IconData(0x3b5f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowDownLeft01' icon.
  static const IconData strokeRoundedArrowDownLeft01 =
      IconData(0x3b60, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowDownLeft02' icon.
  static const IconData strokeRoundedArrowDownLeft02 =
      IconData(0x3b61, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowDownRight01' icon.
  static const IconData strokeRoundedArrowDownRight01 =
      IconData(0x3b62, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowDownRight02' icon.
  static const IconData strokeRoundedArrowDownRight02 =
      IconData(0x3b63, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowExpand01' icon.
  static const IconData strokeRoundedArrowExpand01 =
      IconData(0x3b64, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowExpand02' icon.
  static const IconData strokeRoundedArrowExpand02 =
      IconData(0x3b65, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowExpandDiagonal01' icon.
  static const IconData strokeRoundedArrowExpandDiagonal01 =
      IconData(0x3b66, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowExpandDiagonal02' icon.
  static const IconData strokeRoundedArrowExpandDiagonal02 =
      IconData(0x3b67, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowExpand' icon.
  static const IconData strokeRoundedArrowExpand =
      IconData(0x3b68, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowHorizontal' icon.
  static const IconData strokeRoundedArrowHorizontal =
      IconData(0x3b69, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowLeft01' icon.
  static const IconData strokeRoundedArrowLeft01 =
      IconData(0x3b6a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowLeft02' icon.
  static const IconData strokeRoundedArrowLeft02 =
      IconData(0x3b6b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowLeft03' icon.
  static const IconData strokeRoundedArrowLeft03 =
      IconData(0x3b6c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowLeft04' icon.
  static const IconData strokeRoundedArrowLeft04 =
      IconData(0x3b6d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowLeft05' icon.
  static const IconData strokeRoundedArrowLeft05 =
      IconData(0x3b6e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowLeftDouble' icon.
  static const IconData strokeRoundedArrowLeftDouble =
      IconData(0x3b6f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowLeftRight' icon.
  static const IconData strokeRoundedArrowLeftRight =
      IconData(0x3b70, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowMoveDownLeft' icon.
  static const IconData strokeRoundedArrowMoveDownLeft =
      IconData(0x3b71, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowMoveDownRight' icon.
  static const IconData strokeRoundedArrowMoveDownRight =
      IconData(0x3b72, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowMoveLeftDown' icon.
  static const IconData strokeRoundedArrowMoveLeftDown =
      IconData(0x3b73, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowMoveRightDown' icon.
  static const IconData strokeRoundedArrowMoveRightDown =
      IconData(0x3b74, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowMoveUpLeft' icon.
  static const IconData strokeRoundedArrowMoveUpLeft =
      IconData(0x3b75, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowMoveUpRight' icon.
  static const IconData strokeRoundedArrowMoveUpRight =
      IconData(0x3b76, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowReloadHorizontal' icon.
  static const IconData strokeRoundedArrowReloadHorizontal =
      IconData(0x3b77, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowReloadVertical' icon.
  static const IconData strokeRoundedArrowReloadVertical =
      IconData(0x3b78, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowRight01' icon.
  static const IconData strokeRoundedArrowRight01 =
      IconData(0x3b79, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowRight02' icon.
  static const IconData strokeRoundedArrowRight02 =
      IconData(0x3b7a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowRight03' icon.
  static const IconData strokeRoundedArrowRight03 =
      IconData(0x3b7b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowRight04' icon.
  static const IconData strokeRoundedArrowRight04 =
      IconData(0x3b7c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowRight05' icon.
  static const IconData strokeRoundedArrowRight05 =
      IconData(0x3b7d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowRightDouble' icon.
  static const IconData strokeRoundedArrowRightDouble =
      IconData(0x3b7e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowShrink01' icon.
  static const IconData strokeRoundedArrowShrink01 =
      IconData(0x3b7f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowShrink02' icon.
  static const IconData strokeRoundedArrowShrink02 =
      IconData(0x3b80, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowShrink' icon.
  static const IconData strokeRoundedArrowShrink =
      IconData(0x3b81, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowTurnBackward' icon.
  static const IconData strokeRoundedArrowTurnBackward =
      IconData(0x3b82, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowTurnDown' icon.
  static const IconData strokeRoundedArrowTurnDown =
      IconData(0x3b83, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowTurnForward' icon.
  static const IconData strokeRoundedArrowTurnForward =
      IconData(0x3b84, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowTurnUp' icon.
  static const IconData strokeRoundedArrowTurnUp =
      IconData(0x3b85, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowUp01' icon.
  static const IconData strokeRoundedArrowUp01 =
      IconData(0x3b86, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowUp02' icon.
  static const IconData strokeRoundedArrowUp02 =
      IconData(0x3b87, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowUp03' icon.
  static const IconData strokeRoundedArrowUp03 =
      IconData(0x3b88, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowUp04' icon.
  static const IconData strokeRoundedArrowUp04 =
      IconData(0x3b89, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowUp05' icon.
  static const IconData strokeRoundedArrowUp05 =
      IconData(0x3b8a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowUpDouble' icon.
  static const IconData strokeRoundedArrowUpDouble =
      IconData(0x3b8b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowUpDown' icon.
  static const IconData strokeRoundedArrowUpDown =
      IconData(0x3b8c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowUpLeft01' icon.
  static const IconData strokeRoundedArrowUpLeft01 =
      IconData(0x3b8d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowUpLeft02' icon.
  static const IconData strokeRoundedArrowUpLeft02 =
      IconData(0x3b8e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowUpRight01' icon.
  static const IconData strokeRoundedArrowUpRight01 =
      IconData(0x3b8f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowUpRight02' icon.
  static const IconData strokeRoundedArrowUpRight02 =
      IconData(0x3b90, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArrowVertical' icon.
  static const IconData strokeRoundedArrowVertical =
      IconData(0x3b91, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArtboardTool' icon.
  static const IconData strokeRoundedArtboardTool =
      IconData(0x3b92, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArtboard' icon.
  static const IconData strokeRoundedArtboard =
      IconData(0x3b93, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArtificialIntelligence01' icon.
  static const IconData strokeRoundedArtificialIntelligence01 =
      IconData(0x3b94, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArtificialIntelligence02' icon.
  static const IconData strokeRoundedArtificialIntelligence02 =
      IconData(0x3b95, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArtificialIntelligence03' icon.
  static const IconData strokeRoundedArtificialIntelligence03 =
      IconData(0x3b96, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArtificialIntelligence04' icon.
  static const IconData strokeRoundedArtificialIntelligence04 =
      IconData(0x3b97, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArtificialIntelligence05' icon.
  static const IconData strokeRoundedArtificialIntelligence05 =
      IconData(0x3b98, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArtificialIntelligence06' icon.
  static const IconData strokeRoundedArtificialIntelligence06 =
      IconData(0x3b99, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedArtificialIntelligence07' icon.
  static const IconData strokeRoundedArtificialIntelligence07 =
      IconData(0x3b9a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAspectRatio' icon.
  static const IconData strokeRoundedAspectRatio =
      IconData(0x3b9b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAssignments' icon.
  static const IconData strokeRoundedAssignments =
      IconData(0x3b9c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAsteroid01' icon.
  static const IconData strokeRoundedAsteroid01 =
      IconData(0x3b9d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAsteroid02' icon.
  static const IconData strokeRoundedAsteroid02 =
      IconData(0x3b9e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAstronaut01' icon.
  static const IconData strokeRoundedAstronaut01 =
      IconData(0x3b9f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAstronaut02' icon.
  static const IconData strokeRoundedAstronaut02 =
      IconData(0x3ba0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAt' icon.
  static const IconData strokeRoundedAt =
      IconData(0x3ba1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAtm01' icon.
  static const IconData strokeRoundedAtm01 =
      IconData(0x3ba2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAtm02' icon.
  static const IconData strokeRoundedAtm02 =
      IconData(0x3ba3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAtom01' icon.
  static const IconData strokeRoundedAtom01 =
      IconData(0x3ba4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAtom02' icon.
  static const IconData strokeRoundedAtom02 =
      IconData(0x3ba5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAtomicPower' icon.
  static const IconData strokeRoundedAtomicPower =
      IconData(0x3ba6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAttachment01' icon.
  static const IconData strokeRoundedAttachment01 =
      IconData(0x3ba7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAttachment02' icon.
  static const IconData strokeRoundedAttachment02 =
      IconData(0x3ba8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAttachmentCircle' icon.
  static const IconData strokeRoundedAttachmentCircle =
      IconData(0x3ba9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAttachmentSquare' icon.
  static const IconData strokeRoundedAttachmentSquare =
      IconData(0x3baa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAttachment' icon.
  static const IconData strokeRoundedAttachment =
      IconData(0x3bab, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAuction' icon.
  static const IconData strokeRoundedAuction =
      IconData(0x3bac, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAudioBook01' icon.
  static const IconData strokeRoundedAudioBook01 =
      IconData(0x3bad, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAudioBook02' icon.
  static const IconData strokeRoundedAudioBook02 =
      IconData(0x3bae, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAudioBook03' icon.
  static const IconData strokeRoundedAudioBook03 =
      IconData(0x3baf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAudioBook04' icon.
  static const IconData strokeRoundedAudioBook04 =
      IconData(0x3bb0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAudit01' icon.
  static const IconData strokeRoundedAudit01 =
      IconData(0x3bb1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAudit02' icon.
  static const IconData strokeRoundedAudit02 =
      IconData(0x3bb2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAugmentedRealityAr' icon.
  static const IconData strokeRoundedAugmentedRealityAr =
      IconData(0x3bb3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAuthorized' icon.
  static const IconData strokeRoundedAuthorized =
      IconData(0x3bb4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAutoConversations' icon.
  static const IconData strokeRoundedAutoConversations =
      IconData(0x3bb5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAutomotiveBattery01' icon.
  static const IconData strokeRoundedAutomotiveBattery01 =
      IconData(0x3bb6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAutomotiveBattery02' icon.
  static const IconData strokeRoundedAutomotiveBattery02 =
      IconData(0x3bb7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAvalanche' icon.
  static const IconData strokeRoundedAvalanche =
      IconData(0x3bb8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAvocado' icon.
  static const IconData strokeRoundedAvocado =
      IconData(0x3bb9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAward01' icon.
  static const IconData strokeRoundedAward01 =
      IconData(0x3bba, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAward02' icon.
  static const IconData strokeRoundedAward02 =
      IconData(0x3bbb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAward03' icon.
  static const IconData strokeRoundedAward03 =
      IconData(0x3bbc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAward04' icon.
  static const IconData strokeRoundedAward04 =
      IconData(0x3bbd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedAward05' icon.
  static const IconData strokeRoundedAward05 =
      IconData(0x3bbe, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBaby01' icon.
  static const IconData strokeRoundedBaby01 =
      IconData(0x3bbf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBaby02' icon.
  static const IconData strokeRoundedBaby02 =
      IconData(0x3bc0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBabyBed01' icon.
  static const IconData strokeRoundedBabyBed01 =
      IconData(0x3bc1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBabyBed02' icon.
  static const IconData strokeRoundedBabyBed02 =
      IconData(0x3bc2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBabyBottle' icon.
  static const IconData strokeRoundedBabyBottle =
      IconData(0x3bc3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBabyBoyDress' icon.
  static const IconData strokeRoundedBabyBoyDress =
      IconData(0x3bc4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBabyGirlDress' icon.
  static const IconData strokeRoundedBabyGirlDress =
      IconData(0x3bc5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBackpack01' icon.
  static const IconData strokeRoundedBackpack01 =
      IconData(0x3bc6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBackpack02' icon.
  static const IconData strokeRoundedBackpack02 =
      IconData(0x3bc7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBackpack03' icon.
  static const IconData strokeRoundedBackpack03 =
      IconData(0x3bc8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBackward01' icon.
  static const IconData strokeRoundedBackward01 =
      IconData(0x3bc9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBackward02' icon.
  static const IconData strokeRoundedBackward02 =
      IconData(0x3bca, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBacteria' icon.
  static const IconData strokeRoundedBacteria =
      IconData(0x3bcb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBadmintonShuttle' icon.
  static const IconData strokeRoundedBadmintonShuttle =
      IconData(0x3bcc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBadminton' icon.
  static const IconData strokeRoundedBadminton =
      IconData(0x3bcd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBanana' icon.
  static const IconData strokeRoundedBanana =
      IconData(0x3bce, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBandage' icon.
  static const IconData strokeRoundedBandage =
      IconData(0x3bcf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBank' icon.
  static const IconData strokeRoundedBank =
      IconData(0x3bd0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBarCode01' icon.
  static const IconData strokeRoundedBarCode01 =
      IconData(0x3bd1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBarCode02' icon.
  static const IconData strokeRoundedBarCode02 =
      IconData(0x3bd2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBarns' icon.
  static const IconData strokeRoundedBarns =
      IconData(0x3bd3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBaseballBat' icon.
  static const IconData strokeRoundedBaseballBat =
      IconData(0x3bd4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBaseballHelmet' icon.
  static const IconData strokeRoundedBaseballHelmet =
      IconData(0x3bd5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBaseball' icon.
  static const IconData strokeRoundedBaseball =
      IconData(0x3bd6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBasketball01' icon.
  static const IconData strokeRoundedBasketball01 =
      IconData(0x3bd7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBasketball02' icon.
  static const IconData strokeRoundedBasketball02 =
      IconData(0x3bd8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBasketballHoop' icon.
  static const IconData strokeRoundedBasketballHoop =
      IconData(0x3bd9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBathtub01' icon.
  static const IconData strokeRoundedBathtub01 =
      IconData(0x3bda, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBathtub02' icon.
  static const IconData strokeRoundedBathtub02 =
      IconData(0x3bdb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBatteriesEnergy' icon.
  static const IconData strokeRoundedBatteriesEnergy =
      IconData(0x3bdc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBatteryCharging01' icon.
  static const IconData strokeRoundedBatteryCharging01 =
      IconData(0x3bdd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBatteryCharging02' icon.
  static const IconData strokeRoundedBatteryCharging02 =
      IconData(0x3bde, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBatteryEcoCharging' icon.
  static const IconData strokeRoundedBatteryEcoCharging =
      IconData(0x3bdf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBatteryEmpty' icon.
  static const IconData strokeRoundedBatteryEmpty =
      IconData(0x3be0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBatteryFull' icon.
  static const IconData strokeRoundedBatteryFull =
      IconData(0x3be1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBatteryLow' icon.
  static const IconData strokeRoundedBatteryLow =
      IconData(0x3be2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBatteryMedium01' icon.
  static const IconData strokeRoundedBatteryMedium01 =
      IconData(0x3be3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBatteryMedium02' icon.
  static const IconData strokeRoundedBatteryMedium02 =
      IconData(0x3be4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBbqGrill' icon.
  static const IconData strokeRoundedBbqGrill =
      IconData(0x3be5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBeach02' icon.
  static const IconData strokeRoundedBeach02 =
      IconData(0x3be6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBeach' icon.
  static const IconData strokeRoundedBeach =
      IconData(0x3be7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBeater' icon.
  static const IconData strokeRoundedBeater =
      IconData(0x3be8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBebo' icon.
  static const IconData strokeRoundedBebo =
      IconData(0x3be9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBedBunk' icon.
  static const IconData strokeRoundedBedBunk =
      IconData(0x3bea, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBedDouble' icon.
  static const IconData strokeRoundedBedDouble =
      IconData(0x3beb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBedSingle01' icon.
  static const IconData strokeRoundedBedSingle01 =
      IconData(0x3bec, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBedSingle02' icon.
  static const IconData strokeRoundedBedSingle02 =
      IconData(0x3bed, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBed' icon.
  static const IconData strokeRoundedBed =
      IconData(0x3bee, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBedug01' icon.
  static const IconData strokeRoundedBedug01 =
      IconData(0x3bef, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBedug02' icon.
  static const IconData strokeRoundedBedug02 =
      IconData(0x3bf0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBehance01' icon.
  static const IconData strokeRoundedBehance01 =
      IconData(0x3bf1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBehance02' icon.
  static const IconData strokeRoundedBehance02 =
      IconData(0x3bf2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBelt' icon.
  static const IconData strokeRoundedBelt =
      IconData(0x3bf3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBendTool' icon.
  static const IconData strokeRoundedBendTool =
      IconData(0x3bf4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBerlinTower' icon.
  static const IconData strokeRoundedBerlinTower =
      IconData(0x3bf5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBerlin' icon.
  static const IconData strokeRoundedBerlin =
      IconData(0x3bf6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBeta' icon.
  static const IconData strokeRoundedBeta =
      IconData(0x3bf7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBicycle01' icon.
  static const IconData strokeRoundedBicycle01 =
      IconData(0x3bf8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBicycle' icon.
  static const IconData strokeRoundedBicycle =
      IconData(0x3bf9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBilliard01' icon.
  static const IconData strokeRoundedBilliard01 =
      IconData(0x3bfa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBilliard02' icon.
  static const IconData strokeRoundedBilliard02 =
      IconData(0x3bfb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBinaryCode' icon.
  static const IconData strokeRoundedBinaryCode =
      IconData(0x3bfc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBing' icon.
  static const IconData strokeRoundedBing =
      IconData(0x3bfd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBioEnergy' icon.
  static const IconData strokeRoundedBioEnergy =
      IconData(0x3bfe, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBiomassEnergy' icon.
  static const IconData strokeRoundedBiomassEnergy =
      IconData(0x3bff, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBiometricAccess' icon.
  static const IconData strokeRoundedBiometricAccess =
      IconData(0x3c00, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBiometricDevice' icon.
  static const IconData strokeRoundedBiometricDevice =
      IconData(0x3c01, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBirthdayCake' icon.
  static const IconData strokeRoundedBirthdayCake =
      IconData(0x3c02, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBiscuit' icon.
  static const IconData strokeRoundedBiscuit =
      IconData(0x3c03, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoin01' icon.
  static const IconData strokeRoundedBitcoin01 =
      IconData(0x3c04, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoin02' icon.
  static const IconData strokeRoundedBitcoin02 =
      IconData(0x3c05, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoin03' icon.
  static const IconData strokeRoundedBitcoin03 =
      IconData(0x3c06, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoin04' icon.
  static const IconData strokeRoundedBitcoin04 =
      IconData(0x3c07, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinBag' icon.
  static const IconData strokeRoundedBitcoinBag =
      IconData(0x3c08, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinCircle' icon.
  static const IconData strokeRoundedBitcoinCircle =
      IconData(0x3c09, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinCloud' icon.
  static const IconData strokeRoundedBitcoinCloud =
      IconData(0x3c0a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinCpu' icon.
  static const IconData strokeRoundedBitcoinCpu =
      IconData(0x3c0b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinCreditCard' icon.
  static const IconData strokeRoundedBitcoinCreditCard =
      IconData(0x3c0c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinDatabase' icon.
  static const IconData strokeRoundedBitcoinDatabase =
      IconData(0x3c0d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinDown01' icon.
  static const IconData strokeRoundedBitcoinDown01 =
      IconData(0x3c0e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinDown02' icon.
  static const IconData strokeRoundedBitcoinDown02 =
      IconData(0x3c0f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinEllipse' icon.
  static const IconData strokeRoundedBitcoinEllipse =
      IconData(0x3c10, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinEye' icon.
  static const IconData strokeRoundedBitcoinEye =
      IconData(0x3c11, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinFilter' icon.
  static const IconData strokeRoundedBitcoinFilter =
      IconData(0x3c12, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinFlashdisk' icon.
  static const IconData strokeRoundedBitcoinFlashdisk =
      IconData(0x3c13, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinGraph' icon.
  static const IconData strokeRoundedBitcoinGraph =
      IconData(0x3c14, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinInvoice' icon.
  static const IconData strokeRoundedBitcoinInvoice =
      IconData(0x3c15, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinKey' icon.
  static const IconData strokeRoundedBitcoinKey =
      IconData(0x3c16, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinLocation' icon.
  static const IconData strokeRoundedBitcoinLocation =
      IconData(0x3c17, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinLock' icon.
  static const IconData strokeRoundedBitcoinLock =
      IconData(0x3c18, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinMail' icon.
  static const IconData strokeRoundedBitcoinMail =
      IconData(0x3c19, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinMind' icon.
  static const IconData strokeRoundedBitcoinMind =
      IconData(0x3c1a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinMoney01' icon.
  static const IconData strokeRoundedBitcoinMoney01 =
      IconData(0x3c1b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinMoney02' icon.
  static const IconData strokeRoundedBitcoinMoney02 =
      IconData(0x3c1c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinPieChart' icon.
  static const IconData strokeRoundedBitcoinPieChart =
      IconData(0x3c1d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinPiggyBank' icon.
  static const IconData strokeRoundedBitcoinPiggyBank =
      IconData(0x3c1e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinPresentation' icon.
  static const IconData strokeRoundedBitcoinPresentation =
      IconData(0x3c1f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinReceipt' icon.
  static const IconData strokeRoundedBitcoinReceipt =
      IconData(0x3c20, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinReceive' icon.
  static const IconData strokeRoundedBitcoinReceive =
      IconData(0x3c21, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinRectangle' icon.
  static const IconData strokeRoundedBitcoinRectangle =
      IconData(0x3c22, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinSafe' icon.
  static const IconData strokeRoundedBitcoinSafe =
      IconData(0x3c23, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinSearch' icon.
  static const IconData strokeRoundedBitcoinSearch =
      IconData(0x3c24, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinSend' icon.
  static const IconData strokeRoundedBitcoinSend =
      IconData(0x3c25, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinSetting' icon.
  static const IconData strokeRoundedBitcoinSetting =
      IconData(0x3c26, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinShield' icon.
  static const IconData strokeRoundedBitcoinShield =
      IconData(0x3c27, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinShopping' icon.
  static const IconData strokeRoundedBitcoinShopping =
      IconData(0x3c28, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinSmartphone01' icon.
  static const IconData strokeRoundedBitcoinSmartphone01 =
      IconData(0x3c29, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinSmartphone02' icon.
  static const IconData strokeRoundedBitcoinSmartphone02 =
      IconData(0x3c2a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinSquare' icon.
  static const IconData strokeRoundedBitcoinSquare =
      IconData(0x3c2b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinStore' icon.
  static const IconData strokeRoundedBitcoinStore =
      IconData(0x3c2c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinTag' icon.
  static const IconData strokeRoundedBitcoinTag =
      IconData(0x3c2d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinTarget' icon.
  static const IconData strokeRoundedBitcoinTarget =
      IconData(0x3c2e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinTransaction' icon.
  static const IconData strokeRoundedBitcoinTransaction =
      IconData(0x3c2f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinUp01' icon.
  static const IconData strokeRoundedBitcoinUp01 =
      IconData(0x3c30, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinUp02' icon.
  static const IconData strokeRoundedBitcoinUp02 =
      IconData(0x3c31, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinWallet' icon.
  static const IconData strokeRoundedBitcoinWallet =
      IconData(0x3c32, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoinWithdraw' icon.
  static const IconData strokeRoundedBitcoinWithdraw =
      IconData(0x3c33, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBitcoin' icon.
  static const IconData strokeRoundedBitcoin =
      IconData(0x3c34, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBlackHole01' icon.
  static const IconData strokeRoundedBlackHole01 =
      IconData(0x3c35, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBlackHole' icon.
  static const IconData strokeRoundedBlackHole =
      IconData(0x3c36, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBlend' icon.
  static const IconData strokeRoundedBlend =
      IconData(0x3c37, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBlender' icon.
  static const IconData strokeRoundedBlender =
      IconData(0x3c38, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBlockGame' icon.
  static const IconData strokeRoundedBlockGame =
      IconData(0x3c39, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBlockchain01' icon.
  static const IconData strokeRoundedBlockchain01 =
      IconData(0x3c3a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBlockchain02' icon.
  static const IconData strokeRoundedBlockchain02 =
      IconData(0x3c3b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBlockchain03' icon.
  static const IconData strokeRoundedBlockchain03 =
      IconData(0x3c3c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBlockchain04' icon.
  static const IconData strokeRoundedBlockchain04 =
      IconData(0x3c3d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBlockchain05' icon.
  static const IconData strokeRoundedBlockchain05 =
      IconData(0x3c3e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBlockchain06' icon.
  static const IconData strokeRoundedBlockchain06 =
      IconData(0x3c3f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBlockchain07' icon.
  static const IconData strokeRoundedBlockchain07 =
      IconData(0x3c40, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBlocked' icon.
  static const IconData strokeRoundedBlocked =
      IconData(0x3c41, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBlogger' icon.
  static const IconData strokeRoundedBlogger =
      IconData(0x3c42, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBloodBag' icon.
  static const IconData strokeRoundedBloodBag =
      IconData(0x3c43, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBloodBottle' icon.
  static const IconData strokeRoundedBloodBottle =
      IconData(0x3c44, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBloodPressure' icon.
  static const IconData strokeRoundedBloodPressure =
      IconData(0x3c45, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBloodType' icon.
  static const IconData strokeRoundedBloodType =
      IconData(0x3c46, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBlood' icon.
  static const IconData strokeRoundedBlood =
      IconData(0x3c47, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBluetoothCircle' icon.
  static const IconData strokeRoundedBluetoothCircle =
      IconData(0x3c48, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBluetoothNotConnected' icon.
  static const IconData strokeRoundedBluetoothNotConnected =
      IconData(0x3c49, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBluetoothSearch' icon.
  static const IconData strokeRoundedBluetoothSearch =
      IconData(0x3c4a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBluetoothSquare' icon.
  static const IconData strokeRoundedBluetoothSquare =
      IconData(0x3c4b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBluetooth' icon.
  static const IconData strokeRoundedBluetooth =
      IconData(0x3c4c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBlur' icon.
  static const IconData strokeRoundedBlur =
      IconData(0x3c4d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBlushBrush01' icon.
  static const IconData strokeRoundedBlushBrush01 =
      IconData(0x3c4e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBlushBrush02' icon.
  static const IconData strokeRoundedBlushBrush02 =
      IconData(0x3c4f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBoardMath' icon.
  static const IconData strokeRoundedBoardMath =
      IconData(0x3c50, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBoat' icon.
  static const IconData strokeRoundedBoat =
      IconData(0x3c51, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBodyArmor' icon.
  static const IconData strokeRoundedBodyArmor =
      IconData(0x3c52, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBodyPartLeg' icon.
  static const IconData strokeRoundedBodyPartLeg =
      IconData(0x3c53, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBodyPartMuscle' icon.
  static const IconData strokeRoundedBodyPartMuscle =
      IconData(0x3c54, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBodyPartSixPack' icon.
  static const IconData strokeRoundedBodyPartSixPack =
      IconData(0x3c55, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBodySoap' icon.
  static const IconData strokeRoundedBodySoap =
      IconData(0x3c56, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBodyWeight' icon.
  static const IconData strokeRoundedBodyWeight =
      IconData(0x3c57, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBomb' icon.
  static const IconData strokeRoundedBomb =
      IconData(0x3c58, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBone01' icon.
  static const IconData strokeRoundedBone01 =
      IconData(0x3c59, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBone02' icon.
  static const IconData strokeRoundedBone02 =
      IconData(0x3c5a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBook01' icon.
  static const IconData strokeRoundedBook01 =
      IconData(0x3c5b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBook02' icon.
  static const IconData strokeRoundedBook02 =
      IconData(0x3c5c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBook03' icon.
  static const IconData strokeRoundedBook03 =
      IconData(0x3c5d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBook04' icon.
  static const IconData strokeRoundedBook04 =
      IconData(0x3c5e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBookBookmark01' icon.
  static const IconData strokeRoundedBookBookmark01 =
      IconData(0x3c5f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBookBookmark02' icon.
  static const IconData strokeRoundedBookBookmark02 =
      IconData(0x3c60, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBookDownload' icon.
  static const IconData strokeRoundedBookDownload =
      IconData(0x3c61, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBookEdit' icon.
  static const IconData strokeRoundedBookEdit =
      IconData(0x3c62, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBookOpen01' icon.
  static const IconData strokeRoundedBookOpen01 =
      IconData(0x3c63, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBookOpen02' icon.
  static const IconData strokeRoundedBookOpen02 =
      IconData(0x3c64, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBookUpload' icon.
  static const IconData strokeRoundedBookUpload =
      IconData(0x3c65, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBookmark01' icon.
  static const IconData strokeRoundedBookmark01 =
      IconData(0x3c66, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBookmark02' icon.
  static const IconData strokeRoundedBookmark02 =
      IconData(0x3c67, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBookmark03' icon.
  static const IconData strokeRoundedBookmark03 =
      IconData(0x3c68, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBookmarkAdd01' icon.
  static const IconData strokeRoundedBookmarkAdd01 =
      IconData(0x3c69, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBookmarkAdd02' icon.
  static const IconData strokeRoundedBookmarkAdd02 =
      IconData(0x3c6a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBookmarkBlock01' icon.
  static const IconData strokeRoundedBookmarkBlock01 =
      IconData(0x3c6b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBookmarkBlock02' icon.
  static const IconData strokeRoundedBookmarkBlock02 =
      IconData(0x3c6c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBookmarkCheck01' icon.
  static const IconData strokeRoundedBookmarkCheck01 =
      IconData(0x3c6d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBookmarkCheck02' icon.
  static const IconData strokeRoundedBookmarkCheck02 =
      IconData(0x3c6e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBookmarkMinus01' icon.
  static const IconData strokeRoundedBookmarkMinus01 =
      IconData(0x3c6f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBookmarkMinus02' icon.
  static const IconData strokeRoundedBookmarkMinus02 =
      IconData(0x3c70, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBookmarkOff01' icon.
  static const IconData strokeRoundedBookmarkOff01 =
      IconData(0x3c71, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBookmarkOff02' icon.
  static const IconData strokeRoundedBookmarkOff02 =
      IconData(0x3c72, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBookmarkRemove01' icon.
  static const IconData strokeRoundedBookmarkRemove01 =
      IconData(0x3c73, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBookmarkRemove02' icon.
  static const IconData strokeRoundedBookmarkRemove02 =
      IconData(0x3c74, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBooks01' icon.
  static const IconData strokeRoundedBooks01 =
      IconData(0x3c75, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBooks02' icon.
  static const IconData strokeRoundedBooks02 =
      IconData(0x3c76, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBookshelf01' icon.
  static const IconData strokeRoundedBookshelf01 =
      IconData(0x3c77, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBookshelf02' icon.
  static const IconData strokeRoundedBookshelf02 =
      IconData(0x3c78, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBookshelf03' icon.
  static const IconData strokeRoundedBookshelf03 =
      IconData(0x3c79, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBootstrap' icon.
  static const IconData strokeRoundedBootstrap =
      IconData(0x3c7a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBorderAll01' icon.
  static const IconData strokeRoundedBorderAll01 =
      IconData(0x3c7b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBorderAll02' icon.
  static const IconData strokeRoundedBorderAll02 =
      IconData(0x3c7c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBorderBottom01' icon.
  static const IconData strokeRoundedBorderBottom01 =
      IconData(0x3c7d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBorderBottom02' icon.
  static const IconData strokeRoundedBorderBottom02 =
      IconData(0x3c7e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBorderFull' icon.
  static const IconData strokeRoundedBorderFull =
      IconData(0x3c7f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBorderHorizontal' icon.
  static const IconData strokeRoundedBorderHorizontal =
      IconData(0x3c80, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBorderInner' icon.
  static const IconData strokeRoundedBorderInner =
      IconData(0x3c81, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBorderLeft01' icon.
  static const IconData strokeRoundedBorderLeft01 =
      IconData(0x3c82, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBorderLeft02' icon.
  static const IconData strokeRoundedBorderLeft02 =
      IconData(0x3c83, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBorderNone01' icon.
  static const IconData strokeRoundedBorderNone01 =
      IconData(0x3c84, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBorderNone02' icon.
  static const IconData strokeRoundedBorderNone02 =
      IconData(0x3c85, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBorderRight01' icon.
  static const IconData strokeRoundedBorderRight01 =
      IconData(0x3c86, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBorderRight02' icon.
  static const IconData strokeRoundedBorderRight02 =
      IconData(0x3c87, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBorderTop01' icon.
  static const IconData strokeRoundedBorderTop01 =
      IconData(0x3c88, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBorderTop02' icon.
  static const IconData strokeRoundedBorderTop02 =
      IconData(0x3c89, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBorderVertical' icon.
  static const IconData strokeRoundedBorderVertical =
      IconData(0x3c8a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBorobudur' icon.
  static const IconData strokeRoundedBorobudur =
      IconData(0x3c8b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBot' icon.
  static const IconData strokeRoundedBot =
      IconData(0x3c8c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBounceLeft' icon.
  static const IconData strokeRoundedBounceLeft =
      IconData(0x3c8d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBounceRight' icon.
  static const IconData strokeRoundedBounceRight =
      IconData(0x3c8e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBoundingBox' icon.
  static const IconData strokeRoundedBoundingBox =
      IconData(0x3c8f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBowTie' icon.
  static const IconData strokeRoundedBowTie =
      IconData(0x3c90, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBowlingPins' icon.
  static const IconData strokeRoundedBowlingPins =
      IconData(0x3c91, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBowling' icon.
  static const IconData strokeRoundedBowling =
      IconData(0x3c92, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBoxer' icon.
  static const IconData strokeRoundedBoxer =
      IconData(0x3c93, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBoxingBag' icon.
  static const IconData strokeRoundedBoxingBag =
      IconData(0x3c94, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBoxingGlove01' icon.
  static const IconData strokeRoundedBoxingGlove01 =
      IconData(0x3c95, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBoxingGlove' icon.
  static const IconData strokeRoundedBoxingGlove =
      IconData(0x3c96, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBrain01' icon.
  static const IconData strokeRoundedBrain01 =
      IconData(0x3c97, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBrain02' icon.
  static const IconData strokeRoundedBrain02 =
      IconData(0x3c98, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBrain' icon.
  static const IconData strokeRoundedBrain =
      IconData(0x3c99, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBrandfetch' icon.
  static const IconData strokeRoundedBrandfetch =
      IconData(0x3c9a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBread01' icon.
  static const IconData strokeRoundedBread01 =
      IconData(0x3c9b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBread02' icon.
  static const IconData strokeRoundedBread02 =
      IconData(0x3c9c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBread03' icon.
  static const IconData strokeRoundedBread03 =
      IconData(0x3c9d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBread04' icon.
  static const IconData strokeRoundedBread04 =
      IconData(0x3c9e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBreastPump' icon.
  static const IconData strokeRoundedBreastPump =
      IconData(0x3c9f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBridge' icon.
  static const IconData strokeRoundedBridge =
      IconData(0x3ca0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBriefcase01' icon.
  static const IconData strokeRoundedBriefcase01 =
      IconData(0x3ca1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBriefcase02' icon.
  static const IconData strokeRoundedBriefcase02 =
      IconData(0x3ca2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBriefcase03' icon.
  static const IconData strokeRoundedBriefcase03 =
      IconData(0x3ca3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBriefcase04' icon.
  static const IconData strokeRoundedBriefcase04 =
      IconData(0x3ca4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBriefcase05' icon.
  static const IconData strokeRoundedBriefcase05 =
      IconData(0x3ca5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBriefcase06' icon.
  static const IconData strokeRoundedBriefcase06 =
      IconData(0x3ca6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBriefcase07' icon.
  static const IconData strokeRoundedBriefcase07 =
      IconData(0x3ca7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBriefcase08' icon.
  static const IconData strokeRoundedBriefcase08 =
      IconData(0x3ca8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBriefcase09' icon.
  static const IconData strokeRoundedBriefcase09 =
      IconData(0x3ca9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBriefcaseDollar' icon.
  static const IconData strokeRoundedBriefcaseDollar =
      IconData(0x3caa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBroccoli' icon.
  static const IconData strokeRoundedBroccoli =
      IconData(0x3cab, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBrochure' icon.
  static const IconData strokeRoundedBrochure =
      IconData(0x3cac, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBrokenBone' icon.
  static const IconData strokeRoundedBrokenBone =
      IconData(0x3cad, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBrowser' icon.
  static const IconData strokeRoundedBrowser =
      IconData(0x3cae, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBrush' icon.
  static const IconData strokeRoundedBrush =
      IconData(0x3caf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBubbleChatAdd' icon.
  static const IconData strokeRoundedBubbleChatAdd =
      IconData(0x3cb0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBubbleChatBlocked' icon.
  static const IconData strokeRoundedBubbleChatBlocked =
      IconData(0x3cb1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBubbleChatCancel' icon.
  static const IconData strokeRoundedBubbleChatCancel =
      IconData(0x3cb2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBubbleChatDelay' icon.
  static const IconData strokeRoundedBubbleChatDelay =
      IconData(0x3cb3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBubbleChatDone' icon.
  static const IconData strokeRoundedBubbleChatDone =
      IconData(0x3cb4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBubbleChatDownload01' icon.
  static const IconData strokeRoundedBubbleChatDownload01 =
      IconData(0x3cb5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBubbleChatDownload02' icon.
  static const IconData strokeRoundedBubbleChatDownload02 =
      IconData(0x3cb6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBubbleChatEdit' icon.
  static const IconData strokeRoundedBubbleChatEdit =
      IconData(0x3cb7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBubbleChatFavourite' icon.
  static const IconData strokeRoundedBubbleChatFavourite =
      IconData(0x3cb8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBubbleChatIncome' icon.
  static const IconData strokeRoundedBubbleChatIncome =
      IconData(0x3cb9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBubbleChatLock' icon.
  static const IconData strokeRoundedBubbleChatLock =
      IconData(0x3cba, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBubbleChatNotification' icon.
  static const IconData strokeRoundedBubbleChatNotification =
      IconData(0x3cbb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBubbleChatOutcome' icon.
  static const IconData strokeRoundedBubbleChatOutcome =
      IconData(0x3cbc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBubbleChatPreview' icon.
  static const IconData strokeRoundedBubbleChatPreview =
      IconData(0x3cbd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBubbleChatQuestion' icon.
  static const IconData strokeRoundedBubbleChatQuestion =
      IconData(0x3cbe, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBubbleChatSearch' icon.
  static const IconData strokeRoundedBubbleChatSearch =
      IconData(0x3cbf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBubbleChatSecure' icon.
  static const IconData strokeRoundedBubbleChatSecure =
      IconData(0x3cc0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBubbleChatTranslate' icon.
  static const IconData strokeRoundedBubbleChatTranslate =
      IconData(0x3cc1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBubbleChatUnlock' icon.
  static const IconData strokeRoundedBubbleChatUnlock =
      IconData(0x3cc2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBubbleChatUpload' icon.
  static const IconData strokeRoundedBubbleChatUpload =
      IconData(0x3cc3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBubbleChatUser' icon.
  static const IconData strokeRoundedBubbleChatUser =
      IconData(0x3cc4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBubbleChat' icon.
  static const IconData strokeRoundedBubbleChat =
      IconData(0x3cc5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBubbleTea01' icon.
  static const IconData strokeRoundedBubbleTea01 =
      IconData(0x3cc6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBubbleTea02' icon.
  static const IconData strokeRoundedBubbleTea02 =
      IconData(0x3cc7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBug01' icon.
  static const IconData strokeRoundedBug01 =
      IconData(0x3cc8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBug02' icon.
  static const IconData strokeRoundedBug02 =
      IconData(0x3cc9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBuilding01' icon.
  static const IconData strokeRoundedBuilding01 =
      IconData(0x3cca, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBuilding02' icon.
  static const IconData strokeRoundedBuilding02 =
      IconData(0x3ccb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBuilding03' icon.
  static const IconData strokeRoundedBuilding03 =
      IconData(0x3ccc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBuilding04' icon.
  static const IconData strokeRoundedBuilding04 =
      IconData(0x3ccd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBuilding05' icon.
  static const IconData strokeRoundedBuilding05 =
      IconData(0x3cce, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBuilding06' icon.
  static const IconData strokeRoundedBuilding06 =
      IconData(0x3ccf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBulbCharging' icon.
  static const IconData strokeRoundedBulbCharging =
      IconData(0x3cd0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBulb' icon.
  static const IconData strokeRoundedBulb =
      IconData(0x3cd1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBulletproofVest' icon.
  static const IconData strokeRoundedBulletproofVest =
      IconData(0x3cd2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBurjAlArab' icon.
  static const IconData strokeRoundedBurjAlArab =
      IconData(0x3cd3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBurningCd' icon.
  static const IconData strokeRoundedBurningCd =
      IconData(0x3cd4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBus01' icon.
  static const IconData strokeRoundedBus01 =
      IconData(0x3cd5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBus02' icon.
  static const IconData strokeRoundedBus02 =
      IconData(0x3cd6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedBus03' icon.
  static const IconData strokeRoundedBus03 =
      IconData(0x3cd7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCProgramming' icon.
  static const IconData strokeRoundedCProgramming =
      IconData(0x3cd8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCabinet01' icon.
  static const IconData strokeRoundedCabinet01 =
      IconData(0x3cd9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCabinet02' icon.
  static const IconData strokeRoundedCabinet02 =
      IconData(0x3cda, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCabinet03' icon.
  static const IconData strokeRoundedCabinet03 =
      IconData(0x3cdb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCabinet04' icon.
  static const IconData strokeRoundedCabinet04 =
      IconData(0x3cdc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCableCar' icon.
  static const IconData strokeRoundedCableCar =
      IconData(0x3cdd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCactus' icon.
  static const IconData strokeRoundedCactus =
      IconData(0x3cde, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCaduceus' icon.
  static const IconData strokeRoundedCaduceus =
      IconData(0x3cdf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCafe' icon.
  static const IconData strokeRoundedCafe =
      IconData(0x3ce0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalculate' icon.
  static const IconData strokeRoundedCalculate =
      IconData(0x3ce1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalculator01' icon.
  static const IconData strokeRoundedCalculator01 =
      IconData(0x3ce2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalculator' icon.
  static const IconData strokeRoundedCalculator =
      IconData(0x3ce3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendar01' icon.
  static const IconData strokeRoundedCalendar01 =
      IconData(0x3ce4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendar02' icon.
  static const IconData strokeRoundedCalendar02 =
      IconData(0x3ce5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendar03' icon.
  static const IconData strokeRoundedCalendar03 =
      IconData(0x3ce6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendar04' icon.
  static const IconData strokeRoundedCalendar04 =
      IconData(0x3ce7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendarAdd01' icon.
  static const IconData strokeRoundedCalendarAdd01 =
      IconData(0x3ce8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendarAdd02' icon.
  static const IconData strokeRoundedCalendarAdd02 =
      IconData(0x3ce9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendarBlock01' icon.
  static const IconData strokeRoundedCalendarBlock01 =
      IconData(0x3cea, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendarBlock02' icon.
  static const IconData strokeRoundedCalendarBlock02 =
      IconData(0x3ceb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendarCheckIn01' icon.
  static const IconData strokeRoundedCalendarCheckIn01 =
      IconData(0x3cec, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendarCheckIn02' icon.
  static const IconData strokeRoundedCalendarCheckIn02 =
      IconData(0x3ced, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendarCheckOut01' icon.
  static const IconData strokeRoundedCalendarCheckOut01 =
      IconData(0x3cee, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendarCheckOut02' icon.
  static const IconData strokeRoundedCalendarCheckOut02 =
      IconData(0x3cef, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendarDownload01' icon.
  static const IconData strokeRoundedCalendarDownload01 =
      IconData(0x3cf0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendarDownload02' icon.
  static const IconData strokeRoundedCalendarDownload02 =
      IconData(0x3cf1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendarFavorite01' icon.
  static const IconData strokeRoundedCalendarFavorite01 =
      IconData(0x3cf2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendarFavorite02' icon.
  static const IconData strokeRoundedCalendarFavorite02 =
      IconData(0x3cf3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendarLock01' icon.
  static const IconData strokeRoundedCalendarLock01 =
      IconData(0x3cf4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendarLock02' icon.
  static const IconData strokeRoundedCalendarLock02 =
      IconData(0x3cf5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendarLove01' icon.
  static const IconData strokeRoundedCalendarLove01 =
      IconData(0x3cf6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendarLove02' icon.
  static const IconData strokeRoundedCalendarLove02 =
      IconData(0x3cf7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendarMinus01' icon.
  static const IconData strokeRoundedCalendarMinus01 =
      IconData(0x3cf8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendarMinus02' icon.
  static const IconData strokeRoundedCalendarMinus02 =
      IconData(0x3cf9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendarRemove01' icon.
  static const IconData strokeRoundedCalendarRemove01 =
      IconData(0x3cfa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendarRemove02' icon.
  static const IconData strokeRoundedCalendarRemove02 =
      IconData(0x3cfb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendarSetting01' icon.
  static const IconData strokeRoundedCalendarSetting01 =
      IconData(0x3cfc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendarSetting02' icon.
  static const IconData strokeRoundedCalendarSetting02 =
      IconData(0x3cfd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendarUpload01' icon.
  static const IconData strokeRoundedCalendarUpload01 =
      IconData(0x3cfe, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalendarUpload02' icon.
  static const IconData strokeRoundedCalendarUpload02 =
      IconData(0x3cff, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCall02' icon.
  static const IconData strokeRoundedCall02 =
      IconData(0x3d00, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallAdd02' icon.
  static const IconData strokeRoundedCallAdd02 =
      IconData(0x3d01, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallAdd' icon.
  static const IconData strokeRoundedCallAdd =
      IconData(0x3d02, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallBlocked02' icon.
  static const IconData strokeRoundedCallBlocked02 =
      IconData(0x3d03, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallBlocked' icon.
  static const IconData strokeRoundedCallBlocked =
      IconData(0x3d04, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallDisabled02' icon.
  static const IconData strokeRoundedCallDisabled02 =
      IconData(0x3d05, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallDisabled' icon.
  static const IconData strokeRoundedCallDisabled =
      IconData(0x3d06, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallDone02' icon.
  static const IconData strokeRoundedCallDone02 =
      IconData(0x3d07, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallDone' icon.
  static const IconData strokeRoundedCallDone =
      IconData(0x3d08, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallEnd01' icon.
  static const IconData strokeRoundedCallEnd01 =
      IconData(0x3d09, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallEnd02' icon.
  static const IconData strokeRoundedCallEnd02 =
      IconData(0x3d0a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallEnd03' icon.
  static const IconData strokeRoundedCallEnd03 =
      IconData(0x3d0b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallEnd04' icon.
  static const IconData strokeRoundedCallEnd04 =
      IconData(0x3d0c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallIncoming01' icon.
  static const IconData strokeRoundedCallIncoming01 =
      IconData(0x3d0d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallIncoming02' icon.
  static const IconData strokeRoundedCallIncoming02 =
      IconData(0x3d0e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallIncoming03' icon.
  static const IconData strokeRoundedCallIncoming03 =
      IconData(0x3d0f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallIncoming04' icon.
  static const IconData strokeRoundedCallIncoming04 =
      IconData(0x3d10, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallInternal02' icon.
  static const IconData strokeRoundedCallInternal02 =
      IconData(0x3d11, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallInternal' icon.
  static const IconData strokeRoundedCallInternal =
      IconData(0x3d12, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallLocked02' icon.
  static const IconData strokeRoundedCallLocked02 =
      IconData(0x3d13, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallLocked' icon.
  static const IconData strokeRoundedCallLocked =
      IconData(0x3d14, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallMinus02' icon.
  static const IconData strokeRoundedCallMinus02 =
      IconData(0x3d15, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallMinus' icon.
  static const IconData strokeRoundedCallMinus =
      IconData(0x3d16, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallMissed01' icon.
  static const IconData strokeRoundedCallMissed01 =
      IconData(0x3d17, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallMissed02' icon.
  static const IconData strokeRoundedCallMissed02 =
      IconData(0x3d18, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallMissed03' icon.
  static const IconData strokeRoundedCallMissed03 =
      IconData(0x3d19, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallMissed04' icon.
  static const IconData strokeRoundedCallMissed04 =
      IconData(0x3d1a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallOutgoing01' icon.
  static const IconData strokeRoundedCallOutgoing01 =
      IconData(0x3d1b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallOutgoing02' icon.
  static const IconData strokeRoundedCallOutgoing02 =
      IconData(0x3d1c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallOutgoing03' icon.
  static const IconData strokeRoundedCallOutgoing03 =
      IconData(0x3d1d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallOutgoing04' icon.
  static const IconData strokeRoundedCallOutgoing04 =
      IconData(0x3d1e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallPaused02' icon.
  static const IconData strokeRoundedCallPaused02 =
      IconData(0x3d1f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallPaused' icon.
  static const IconData strokeRoundedCallPaused =
      IconData(0x3d20, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallReceived02' icon.
  static const IconData strokeRoundedCallReceived02 =
      IconData(0x3d21, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallReceived' icon.
  static const IconData strokeRoundedCallReceived =
      IconData(0x3d22, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallRinging01' icon.
  static const IconData strokeRoundedCallRinging01 =
      IconData(0x3d23, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallRinging02' icon.
  static const IconData strokeRoundedCallRinging02 =
      IconData(0x3d24, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallRinging03' icon.
  static const IconData strokeRoundedCallRinging03 =
      IconData(0x3d25, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallRinging04' icon.
  static const IconData strokeRoundedCallRinging04 =
      IconData(0x3d26, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallUnlocked02' icon.
  static const IconData strokeRoundedCallUnlocked02 =
      IconData(0x3d27, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCallUnlocked' icon.
  static const IconData strokeRoundedCallUnlocked =
      IconData(0x3d28, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCall' icon.
  static const IconData strokeRoundedCall =
      IconData(0x3d29, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalling02' icon.
  static const IconData strokeRoundedCalling02 =
      IconData(0x3d2a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCalling' icon.
  static const IconData strokeRoundedCalling =
      IconData(0x3d2b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCamel' icon.
  static const IconData strokeRoundedCamel =
      IconData(0x3d2c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCamera01' icon.
  static const IconData strokeRoundedCamera01 =
      IconData(0x3d2d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCamera02' icon.
  static const IconData strokeRoundedCamera02 =
      IconData(0x3d2e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCameraAdd01' icon.
  static const IconData strokeRoundedCameraAdd01 =
      IconData(0x3d2f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCameraAdd02' icon.
  static const IconData strokeRoundedCameraAdd02 =
      IconData(0x3d30, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCameraAutomatically01' icon.
  static const IconData strokeRoundedCameraAutomatically01 =
      IconData(0x3d31, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCameraAutomatically02' icon.
  static const IconData strokeRoundedCameraAutomatically02 =
      IconData(0x3d32, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCameraLens' icon.
  static const IconData strokeRoundedCameraLens =
      IconData(0x3d33, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCameraMicrophone01' icon.
  static const IconData strokeRoundedCameraMicrophone01 =
      IconData(0x3d34, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCameraMicrophone02' icon.
  static const IconData strokeRoundedCameraMicrophone02 =
      IconData(0x3d35, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCameraNightMode01' icon.
  static const IconData strokeRoundedCameraNightMode01 =
      IconData(0x3d36, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCameraNightMode02' icon.
  static const IconData strokeRoundedCameraNightMode02 =
      IconData(0x3d37, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCameraOff01' icon.
  static const IconData strokeRoundedCameraOff01 =
      IconData(0x3d38, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCameraOff02' icon.
  static const IconData strokeRoundedCameraOff02 =
      IconData(0x3d39, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCameraRotated01' icon.
  static const IconData strokeRoundedCameraRotated01 =
      IconData(0x3d3a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCameraRotated02' icon.
  static const IconData strokeRoundedCameraRotated02 =
      IconData(0x3d3b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCameraSmile01' icon.
  static const IconData strokeRoundedCameraSmile01 =
      IconData(0x3d3c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCameraSmile02' icon.
  static const IconData strokeRoundedCameraSmile02 =
      IconData(0x3d3d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCameraTripod' icon.
  static const IconData strokeRoundedCameraTripod =
      IconData(0x3d3e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCameraVideo' icon.
  static const IconData strokeRoundedCameraVideo =
      IconData(0x3d3f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCamper' icon.
  static const IconData strokeRoundedCamper =
      IconData(0x3d40, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCampfire' icon.
  static const IconData strokeRoundedCampfire =
      IconData(0x3d41, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCancel01' icon.
  static const IconData strokeRoundedCancel01 =
      IconData(0x3d42, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCancel02' icon.
  static const IconData strokeRoundedCancel02 =
      IconData(0x3d43, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCancelCircleHalfDot' icon.
  static const IconData strokeRoundedCancelCircleHalfDot =
      IconData(0x3d44, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCancelCircle' icon.
  static const IconData strokeRoundedCancelCircle =
      IconData(0x3d45, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCancelSquare' icon.
  static const IconData strokeRoundedCancelSquare =
      IconData(0x3d46, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCandelier01' icon.
  static const IconData strokeRoundedCandelier01 =
      IconData(0x3d47, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCandelier02' icon.
  static const IconData strokeRoundedCandelier02 =
      IconData(0x3d48, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCanvas' icon.
  static const IconData strokeRoundedCanvas =
      IconData(0x3d49, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCapProjecting' icon.
  static const IconData strokeRoundedCapProjecting =
      IconData(0x3d4a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCapRound' icon.
  static const IconData strokeRoundedCapRound =
      IconData(0x3d4b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCapStraight' icon.
  static const IconData strokeRoundedCapStraight =
      IconData(0x3d4c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCap' icon.
  static const IconData strokeRoundedCap =
      IconData(0x3d4d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCapcutRectangle' icon.
  static const IconData strokeRoundedCapcutRectangle =
      IconData(0x3d4e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCapcut' icon.
  static const IconData strokeRoundedCapcut =
      IconData(0x3d4f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCar01' icon.
  static const IconData strokeRoundedCar01 =
      IconData(0x3d50, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCar02' icon.
  static const IconData strokeRoundedCar02 =
      IconData(0x3d51, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCar03' icon.
  static const IconData strokeRoundedCar03 =
      IconData(0x3d52, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCar04' icon.
  static const IconData strokeRoundedCar04 =
      IconData(0x3d53, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCarParking01' icon.
  static const IconData strokeRoundedCarParking01 =
      IconData(0x3d54, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCarParking02' icon.
  static const IconData strokeRoundedCarParking02 =
      IconData(0x3d55, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCaravan' icon.
  static const IconData strokeRoundedCaravan =
      IconData(0x3d56, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCardExchange01' icon.
  static const IconData strokeRoundedCardExchange01 =
      IconData(0x3d57, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCardExchange02' icon.
  static const IconData strokeRoundedCardExchange02 =
      IconData(0x3d58, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCardigan' icon.
  static const IconData strokeRoundedCardigan =
      IconData(0x3d59, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCardiogram01' icon.
  static const IconData strokeRoundedCardiogram01 =
      IconData(0x3d5a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCardiogram02' icon.
  static const IconData strokeRoundedCardiogram02 =
      IconData(0x3d5b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCards01' icon.
  static const IconData strokeRoundedCards01 =
      IconData(0x3d5c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCards02' icon.
  static const IconData strokeRoundedCards02 =
      IconData(0x3d5d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCargoShip' icon.
  static const IconData strokeRoundedCargoShip =
      IconData(0x3d5e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCarouselHorizontal02' icon.
  static const IconData strokeRoundedCarouselHorizontal02 =
      IconData(0x3d5f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCarouselHorizontal' icon.
  static const IconData strokeRoundedCarouselHorizontal =
      IconData(0x3d60, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCarouselVertical' icon.
  static const IconData strokeRoundedCarouselVertical =
      IconData(0x3d61, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCarrot' icon.
  static const IconData strokeRoundedCarrot =
      IconData(0x3d62, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCash01' icon.
  static const IconData strokeRoundedCash01 =
      IconData(0x3d63, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCash02' icon.
  static const IconData strokeRoundedCash02 =
      IconData(0x3d64, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCashback' icon.
  static const IconData strokeRoundedCashback =
      IconData(0x3d65, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCashier02' icon.
  static const IconData strokeRoundedCashier02 =
      IconData(0x3d66, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCashier' icon.
  static const IconData strokeRoundedCashier =
      IconData(0x3d67, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCastle01' icon.
  static const IconData strokeRoundedCastle01 =
      IconData(0x3d68, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCastle02' icon.
  static const IconData strokeRoundedCastle02 =
      IconData(0x3d69, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCastle' icon.
  static const IconData strokeRoundedCastle =
      IconData(0x3d6a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCatalogue' icon.
  static const IconData strokeRoundedCatalogue =
      IconData(0x3d6b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCayanTower' icon.
  static const IconData strokeRoundedCayanTower =
      IconData(0x3d6c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCctvCamera' icon.
  static const IconData strokeRoundedCctvCamera =
      IconData(0x3d6d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCd' icon.
  static const IconData strokeRoundedCd =
      IconData(0x3d6e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCells' icon.
  static const IconData strokeRoundedCells =
      IconData(0x3d6f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCellularNetworkOffline' icon.
  static const IconData strokeRoundedCellularNetworkOffline =
      IconData(0x3d70, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCellularNetwork' icon.
  static const IconData strokeRoundedCellularNetwork =
      IconData(0x3d71, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCelsius' icon.
  static const IconData strokeRoundedCelsius =
      IconData(0x3d72, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCenterFocus' icon.
  static const IconData strokeRoundedCenterFocus =
      IconData(0x3d73, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCentralShaheedMinar' icon.
  static const IconData strokeRoundedCentralShaheedMinar =
      IconData(0x3d74, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCentralized' icon.
  static const IconData strokeRoundedCentralized =
      IconData(0x3d75, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCertificate01' icon.
  static const IconData strokeRoundedCertificate01 =
      IconData(0x3d76, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCertificate02' icon.
  static const IconData strokeRoundedCertificate02 =
      IconData(0x3d77, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChair01' icon.
  static const IconData strokeRoundedChair01 =
      IconData(0x3d78, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChair02' icon.
  static const IconData strokeRoundedChair02 =
      IconData(0x3d79, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChair03' icon.
  static const IconData strokeRoundedChair03 =
      IconData(0x3d7a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChair04' icon.
  static const IconData strokeRoundedChair04 =
      IconData(0x3d7b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChair05' icon.
  static const IconData strokeRoundedChair05 =
      IconData(0x3d7c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChairBarber' icon.
  static const IconData strokeRoundedChairBarber =
      IconData(0x3d7d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChampion' icon.
  static const IconData strokeRoundedChampion =
      IconData(0x3d7e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChangeScreenMode' icon.
  static const IconData strokeRoundedChangeScreenMode =
      IconData(0x3d7f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCharacterPhonetic' icon.
  static const IconData strokeRoundedCharacterPhonetic =
      IconData(0x3d80, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCharity' icon.
  static const IconData strokeRoundedCharity =
      IconData(0x3d81, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChartAverage' icon.
  static const IconData strokeRoundedChartAverage =
      IconData(0x3d82, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChartBarLine' icon.
  static const IconData strokeRoundedChartBarLine =
      IconData(0x3d83, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChartBreakoutCircle' icon.
  static const IconData strokeRoundedChartBreakoutCircle =
      IconData(0x3d84, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChartBreakoutSquare' icon.
  static const IconData strokeRoundedChartBreakoutSquare =
      IconData(0x3d85, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChartBubble01' icon.
  static const IconData strokeRoundedChartBubble01 =
      IconData(0x3d86, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChartBubble02' icon.
  static const IconData strokeRoundedChartBubble02 =
      IconData(0x3d87, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChartColumn' icon.
  static const IconData strokeRoundedChartColumn =
      IconData(0x3d88, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChartDecrease' icon.
  static const IconData strokeRoundedChartDecrease =
      IconData(0x3d89, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChartEvaluation' icon.
  static const IconData strokeRoundedChartEvaluation =
      IconData(0x3d8a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChartHighLow' icon.
  static const IconData strokeRoundedChartHighLow =
      IconData(0x3d8b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChartHistogram' icon.
  static const IconData strokeRoundedChartHistogram =
      IconData(0x3d8c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChartIncrease' icon.
  static const IconData strokeRoundedChartIncrease =
      IconData(0x3d8d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChartLineData01' icon.
  static const IconData strokeRoundedChartLineData01 =
      IconData(0x3d8e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChartLineData02' icon.
  static const IconData strokeRoundedChartLineData02 =
      IconData(0x3d8f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChartLineData03' icon.
  static const IconData strokeRoundedChartLineData03 =
      IconData(0x3d90, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChartMaximum' icon.
  static const IconData strokeRoundedChartMaximum =
      IconData(0x3d91, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChartMedium' icon.
  static const IconData strokeRoundedChartMedium =
      IconData(0x3d92, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChartMinimum' icon.
  static const IconData strokeRoundedChartMinimum =
      IconData(0x3d93, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChartRadar' icon.
  static const IconData strokeRoundedChartRadar =
      IconData(0x3d94, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChartRelationship' icon.
  static const IconData strokeRoundedChartRelationship =
      IconData(0x3d95, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChartRing' icon.
  static const IconData strokeRoundedChartRing =
      IconData(0x3d96, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChartRose' icon.
  static const IconData strokeRoundedChartRose =
      IconData(0x3d97, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChartScatter' icon.
  static const IconData strokeRoundedChartScatter =
      IconData(0x3d98, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChart' icon.
  static const IconData strokeRoundedChart =
      IconData(0x3d99, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChatBot' icon.
  static const IconData strokeRoundedChatBot =
      IconData(0x3d9a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChatGpt' icon.
  static const IconData strokeRoundedChatGpt =
      IconData(0x3d9b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChatting01' icon.
  static const IconData strokeRoundedChatting01 =
      IconData(0x3d9c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCheckList' icon.
  static const IconData strokeRoundedCheckList =
      IconData(0x3d9d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCheckUnread01' icon.
  static const IconData strokeRoundedCheckUnread01 =
      IconData(0x3d9e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCheckUnread02' icon.
  static const IconData strokeRoundedCheckUnread02 =
      IconData(0x3d9f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCheckUnread03' icon.
  static const IconData strokeRoundedCheckUnread03 =
      IconData(0x3da0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCheckUnread04' icon.
  static const IconData strokeRoundedCheckUnread04 =
      IconData(0x3da1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCheckmarkBadge01' icon.
  static const IconData strokeRoundedCheckmarkBadge01 =
      IconData(0x3da2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCheckmarkBadge02' icon.
  static const IconData strokeRoundedCheckmarkBadge02 =
      IconData(0x3da3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCheckmarkBadge03' icon.
  static const IconData strokeRoundedCheckmarkBadge03 =
      IconData(0x3da4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCheckmarkBadge04' icon.
  static const IconData strokeRoundedCheckmarkBadge04 =
      IconData(0x3da5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCheckmarkCircle01' icon.
  static const IconData strokeRoundedCheckmarkCircle01 =
      IconData(0x3da6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCheckmarkCircle02' icon.
  static const IconData strokeRoundedCheckmarkCircle02 =
      IconData(0x3da7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCheckmarkCircle03' icon.
  static const IconData strokeRoundedCheckmarkCircle03 =
      IconData(0x3da8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCheckmarkCircle04' icon.
  static const IconData strokeRoundedCheckmarkCircle04 =
      IconData(0x3da9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCheckmarkSquare01' icon.
  static const IconData strokeRoundedCheckmarkSquare01 =
      IconData(0x3daa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCheckmarkSquare02' icon.
  static const IconData strokeRoundedCheckmarkSquare02 =
      IconData(0x3dab, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCheckmarkSquare03' icon.
  static const IconData strokeRoundedCheckmarkSquare03 =
      IconData(0x3dac, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCheckmarkSquare04' icon.
  static const IconData strokeRoundedCheckmarkSquare04 =
      IconData(0x3dad, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCheeseCake01' icon.
  static const IconData strokeRoundedCheeseCake01 =
      IconData(0x3dae, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCheeseCake02' icon.
  static const IconData strokeRoundedCheeseCake02 =
      IconData(0x3daf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCheese' icon.
  static const IconData strokeRoundedCheese =
      IconData(0x3db0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChefHat' icon.
  static const IconData strokeRoundedChefHat =
      IconData(0x3db1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChef' icon.
  static const IconData strokeRoundedChef =
      IconData(0x3db2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChemistry01' icon.
  static const IconData strokeRoundedChemistry01 =
      IconData(0x3db3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChemistry02' icon.
  static const IconData strokeRoundedChemistry02 =
      IconData(0x3db4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChemistry03' icon.
  static const IconData strokeRoundedChemistry03 =
      IconData(0x3db5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCherry' icon.
  static const IconData strokeRoundedCherry =
      IconData(0x3db6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChess01' icon.
  static const IconData strokeRoundedChess01 =
      IconData(0x3db7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChess02' icon.
  static const IconData strokeRoundedChess02 =
      IconData(0x3db8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChessPawn' icon.
  static const IconData strokeRoundedChessPawn =
      IconData(0x3db9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChickenThighs' icon.
  static const IconData strokeRoundedChickenThighs =
      IconData(0x3dba, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChimney' icon.
  static const IconData strokeRoundedChimney =
      IconData(0x3dbb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChinaTemple' icon.
  static const IconData strokeRoundedChinaTemple =
      IconData(0x3dbc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChip02' icon.
  static const IconData strokeRoundedChip02 =
      IconData(0x3dbd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChip' icon.
  static const IconData strokeRoundedChip =
      IconData(0x3dbe, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChocolate' icon.
  static const IconData strokeRoundedChocolate =
      IconData(0x3dbf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChrome' icon.
  static const IconData strokeRoundedChrome =
      IconData(0x3dc0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChrysler' icon.
  static const IconData strokeRoundedChrysler =
      IconData(0x3dc1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedChurch' icon.
  static const IconData strokeRoundedChurch =
      IconData(0x3dc2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCinnamonRoll' icon.
  static const IconData strokeRoundedCinnamonRoll =
      IconData(0x3dc3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowDataTransferDiagonal' icon.
  static const IconData strokeRoundedCircleArrowDataTransferDiagonal =
      IconData(0x3dc4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowDataTransferHorizontal' icon.
  static const IconData strokeRoundedCircleArrowDataTransferHorizontal =
      IconData(0x3dc5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowDataTransferVertical' icon.
  static const IconData strokeRoundedCircleArrowDataTransferVertical =
      IconData(0x3dc6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowDiagonal01' icon.
  static const IconData strokeRoundedCircleArrowDiagonal01 =
      IconData(0x3dc7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowDiagonal02' icon.
  static const IconData strokeRoundedCircleArrowDiagonal02 =
      IconData(0x3dc8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowDown01' icon.
  static const IconData strokeRoundedCircleArrowDown01 =
      IconData(0x3dc9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowDown02' icon.
  static const IconData strokeRoundedCircleArrowDown02 =
      IconData(0x3dca, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowDown03' icon.
  static const IconData strokeRoundedCircleArrowDown03 =
      IconData(0x3dcb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowDownDouble' icon.
  static const IconData strokeRoundedCircleArrowDownDouble =
      IconData(0x3dcc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowDownLeft' icon.
  static const IconData strokeRoundedCircleArrowDownLeft =
      IconData(0x3dcd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowDownRight' icon.
  static const IconData strokeRoundedCircleArrowDownRight =
      IconData(0x3dce, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowExpand01' icon.
  static const IconData strokeRoundedCircleArrowExpand01 =
      IconData(0x3dcf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowExpand02' icon.
  static const IconData strokeRoundedCircleArrowExpand02 =
      IconData(0x3dd0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowHorizontal' icon.
  static const IconData strokeRoundedCircleArrowHorizontal =
      IconData(0x3dd1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowLeft01' icon.
  static const IconData strokeRoundedCircleArrowLeft01 =
      IconData(0x3dd2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowLeft02' icon.
  static const IconData strokeRoundedCircleArrowLeft02 =
      IconData(0x3dd3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowLeft03' icon.
  static const IconData strokeRoundedCircleArrowLeft03 =
      IconData(0x3dd4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowLeftDouble' icon.
  static const IconData strokeRoundedCircleArrowLeftDouble =
      IconData(0x3dd5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowLeftRight' icon.
  static const IconData strokeRoundedCircleArrowLeftRight =
      IconData(0x3dd6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowMoveDownLeft' icon.
  static const IconData strokeRoundedCircleArrowMoveDownLeft =
      IconData(0x3dd7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowMoveDownRight' icon.
  static const IconData strokeRoundedCircleArrowMoveDownRight =
      IconData(0x3dd8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowMoveLeftDown' icon.
  static const IconData strokeRoundedCircleArrowMoveLeftDown =
      IconData(0x3dd9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowMoveRightDown' icon.
  static const IconData strokeRoundedCircleArrowMoveRightDown =
      IconData(0x3dda, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowMoveUpLeft' icon.
  static const IconData strokeRoundedCircleArrowMoveUpLeft =
      IconData(0x3ddb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowMoveUpRight' icon.
  static const IconData strokeRoundedCircleArrowMoveUpRight =
      IconData(0x3ddc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowReload01' icon.
  static const IconData strokeRoundedCircleArrowReload01 =
      IconData(0x3ddd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowReload02' icon.
  static const IconData strokeRoundedCircleArrowReload02 =
      IconData(0x3dde, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowRight01' icon.
  static const IconData strokeRoundedCircleArrowRight01 =
      IconData(0x3ddf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowRight02' icon.
  static const IconData strokeRoundedCircleArrowRight02 =
      IconData(0x3de0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowRight03' icon.
  static const IconData strokeRoundedCircleArrowRight03 =
      IconData(0x3de1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowRightDouble' icon.
  static const IconData strokeRoundedCircleArrowRightDouble =
      IconData(0x3de2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowShrink01' icon.
  static const IconData strokeRoundedCircleArrowShrink01 =
      IconData(0x3de3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowShrink02' icon.
  static const IconData strokeRoundedCircleArrowShrink02 =
      IconData(0x3de4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowUp01' icon.
  static const IconData strokeRoundedCircleArrowUp01 =
      IconData(0x3de5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowUp02' icon.
  static const IconData strokeRoundedCircleArrowUp02 =
      IconData(0x3de6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowUp03' icon.
  static const IconData strokeRoundedCircleArrowUp03 =
      IconData(0x3de7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowUpDouble' icon.
  static const IconData strokeRoundedCircleArrowUpDouble =
      IconData(0x3de8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowUpDown' icon.
  static const IconData strokeRoundedCircleArrowUpDown =
      IconData(0x3de9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowUpLeft' icon.
  static const IconData strokeRoundedCircleArrowUpLeft =
      IconData(0x3dea, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowUpRight' icon.
  static const IconData strokeRoundedCircleArrowUpRight =
      IconData(0x3deb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleArrowVertical' icon.
  static const IconData strokeRoundedCircleArrowVertical =
      IconData(0x3dec, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleLock01' icon.
  static const IconData strokeRoundedCircleLock01 =
      IconData(0x3ded, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleLock02' icon.
  static const IconData strokeRoundedCircleLock02 =
      IconData(0x3dee, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleLockAdd01' icon.
  static const IconData strokeRoundedCircleLockAdd01 =
      IconData(0x3def, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleLockAdd02' icon.
  static const IconData strokeRoundedCircleLockAdd02 =
      IconData(0x3df0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleLockCheck01' icon.
  static const IconData strokeRoundedCircleLockCheck01 =
      IconData(0x3df1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleLockCheck02' icon.
  static const IconData strokeRoundedCircleLockCheck02 =
      IconData(0x3df2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleLockMinus01' icon.
  static const IconData strokeRoundedCircleLockMinus01 =
      IconData(0x3df3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleLockMinus02' icon.
  static const IconData strokeRoundedCircleLockMinus02 =
      IconData(0x3df4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleLockRemove01' icon.
  static const IconData strokeRoundedCircleLockRemove01 =
      IconData(0x3df5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleLockRemove02' icon.
  static const IconData strokeRoundedCircleLockRemove02 =
      IconData(0x3df6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCirclePassword' icon.
  static const IconData strokeRoundedCirclePassword =
      IconData(0x3df7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleUnlock01' icon.
  static const IconData strokeRoundedCircleUnlock01 =
      IconData(0x3df8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircleUnlock02' icon.
  static const IconData strokeRoundedCircleUnlock02 =
      IconData(0x3df9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCircle' icon.
  static const IconData strokeRoundedCircle =
      IconData(0x3dfa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCity01' icon.
  static const IconData strokeRoundedCity01 =
      IconData(0x3dfb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCity02' icon.
  static const IconData strokeRoundedCity02 =
      IconData(0x3dfc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCity03' icon.
  static const IconData strokeRoundedCity03 =
      IconData(0x3dfd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedClapping01' icon.
  static const IconData strokeRoundedClapping01 =
      IconData(0x3dfe, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedClapping02' icon.
  static const IconData strokeRoundedClapping02 =
      IconData(0x3dff, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedClean' icon.
  static const IconData strokeRoundedClean =
      IconData(0x3e00, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCleaningBucket' icon.
  static const IconData strokeRoundedCleaningBucket =
      IconData(0x3e01, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedClinic' icon.
  static const IconData strokeRoundedClinic =
      IconData(0x3e02, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedClip' icon.
  static const IconData strokeRoundedClip =
      IconData(0x3e03, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedClipboard' icon.
  static const IconData strokeRoundedClipboard =
      IconData(0x3e04, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedClock01' icon.
  static const IconData strokeRoundedClock01 =
      IconData(0x3e05, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedClock02' icon.
  static const IconData strokeRoundedClock02 =
      IconData(0x3e06, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedClock03' icon.
  static const IconData strokeRoundedClock03 =
      IconData(0x3e07, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedClock04' icon.
  static const IconData strokeRoundedClock04 =
      IconData(0x3e08, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedClock05' icon.
  static const IconData strokeRoundedClock05 =
      IconData(0x3e09, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedClosedCaptionAlt' icon.
  static const IconData strokeRoundedClosedCaptionAlt =
      IconData(0x3e0a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedClosedCaption' icon.
  static const IconData strokeRoundedClosedCaption =
      IconData(0x3e0b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedClothes' icon.
  static const IconData strokeRoundedClothes =
      IconData(0x3e0c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCloudAngledRainZap' icon.
  static const IconData strokeRoundedCloudAngledRainZap =
      IconData(0x3e0d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCloudAngledRain' icon.
  static const IconData strokeRoundedCloudAngledRain =
      IconData(0x3e0e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCloudAngledZap' icon.
  static const IconData strokeRoundedCloudAngledZap =
      IconData(0x3e0f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCloudBigRain' icon.
  static const IconData strokeRoundedCloudBigRain =
      IconData(0x3e10, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCloudDownload' icon.
  static const IconData strokeRoundedCloudDownload =
      IconData(0x3e11, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCloudFastWind' icon.
  static const IconData strokeRoundedCloudFastWind =
      IconData(0x3e12, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCloudHailstone' icon.
  static const IconData strokeRoundedCloudHailstone =
      IconData(0x3e13, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCloudLittleRain' icon.
  static const IconData strokeRoundedCloudLittleRain =
      IconData(0x3e14, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCloudLittleSnow' icon.
  static const IconData strokeRoundedCloudLittleSnow =
      IconData(0x3e15, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCloudLoading' icon.
  static const IconData strokeRoundedCloudLoading =
      IconData(0x3e16, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCloudMidRain' icon.
  static const IconData strokeRoundedCloudMidRain =
      IconData(0x3e17, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCloudMidSnow' icon.
  static const IconData strokeRoundedCloudMidSnow =
      IconData(0x3e18, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCloudSavingDone01' icon.
  static const IconData strokeRoundedCloudSavingDone01 =
      IconData(0x3e19, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCloudSavingDone02' icon.
  static const IconData strokeRoundedCloudSavingDone02 =
      IconData(0x3e1a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCloudServer' icon.
  static const IconData strokeRoundedCloudServer =
      IconData(0x3e1b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCloudSlowWind' icon.
  static const IconData strokeRoundedCloudSlowWind =
      IconData(0x3e1c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCloudSnow' icon.
  static const IconData strokeRoundedCloudSnow =
      IconData(0x3e1d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCloudUpload' icon.
  static const IconData strokeRoundedCloudUpload =
      IconData(0x3e1e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCloud' icon.
  static const IconData strokeRoundedCloud =
      IconData(0x3e1f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedClubs01' icon.
  static const IconData strokeRoundedClubs01 =
      IconData(0x3e20, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedClubs02' icon.
  static const IconData strokeRoundedClubs02 =
      IconData(0x3e21, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCoPresent' icon.
  static const IconData strokeRoundedCoPresent =
      IconData(0x3e22, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCodeCircle' icon.
  static const IconData strokeRoundedCodeCircle =
      IconData(0x3e23, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCodeFolder' icon.
  static const IconData strokeRoundedCodeFolder =
      IconData(0x3e24, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCodeSquare' icon.
  static const IconData strokeRoundedCodeSquare =
      IconData(0x3e25, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCode' icon.
  static const IconData strokeRoundedCode =
      IconData(0x3e26, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCodesandbox' icon.
  static const IconData strokeRoundedCodesandbox =
      IconData(0x3e27, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCoffee01' icon.
  static const IconData strokeRoundedCoffee01 =
      IconData(0x3e28, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCoffee02' icon.
  static const IconData strokeRoundedCoffee02 =
      IconData(0x3e29, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCoffeeBeans' icon.
  static const IconData strokeRoundedCoffeeBeans =
      IconData(0x3e2a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCoins01' icon.
  static const IconData strokeRoundedCoins01 =
      IconData(0x3e2b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCoins02' icon.
  static const IconData strokeRoundedCoins02 =
      IconData(0x3e2c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCoinsBitcoin' icon.
  static const IconData strokeRoundedCoinsBitcoin =
      IconData(0x3e2d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCoinsDollar' icon.
  static const IconData strokeRoundedCoinsDollar =
      IconData(0x3e2e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCoinsEuro' icon.
  static const IconData strokeRoundedCoinsEuro =
      IconData(0x3e2f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCoinsPound' icon.
  static const IconData strokeRoundedCoinsPound =
      IconData(0x3e30, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCoinsSwap' icon.
  static const IconData strokeRoundedCoinsSwap =
      IconData(0x3e31, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCoinsYen' icon.
  static const IconData strokeRoundedCoinsYen =
      IconData(0x3e32, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCollectionsBookmark' icon.
  static const IconData strokeRoundedCollectionsBookmark =
      IconData(0x3e33, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedColorPicker' icon.
  static const IconData strokeRoundedColorPicker =
      IconData(0x3e34, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedColors' icon.
  static const IconData strokeRoundedColors =
      IconData(0x3e35, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedColosseum' icon.
  static const IconData strokeRoundedColosseum =
      IconData(0x3e36, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedColumnDelete' icon.
  static const IconData strokeRoundedColumnDelete =
      IconData(0x3e37, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedColumnInsert' icon.
  static const IconData strokeRoundedColumnInsert =
      IconData(0x3e38, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedComet01' icon.
  static const IconData strokeRoundedComet01 =
      IconData(0x3e39, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedComet02' icon.
  static const IconData strokeRoundedComet02 =
      IconData(0x3e3a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedComingSoon01' icon.
  static const IconData strokeRoundedComingSoon01 =
      IconData(0x3e3b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedComingSoon02' icon.
  static const IconData strokeRoundedComingSoon02 =
      IconData(0x3e3c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCommandLine' icon.
  static const IconData strokeRoundedCommandLine =
      IconData(0x3e3d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCommand' icon.
  static const IconData strokeRoundedCommand =
      IconData(0x3e3e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedComment01' icon.
  static const IconData strokeRoundedComment01 =
      IconData(0x3e3f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedComment02' icon.
  static const IconData strokeRoundedComment02 =
      IconData(0x3e40, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCommentAdd01' icon.
  static const IconData strokeRoundedCommentAdd01 =
      IconData(0x3e41, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCommentAdd02' icon.
  static const IconData strokeRoundedCommentAdd02 =
      IconData(0x3e42, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCommentBlock01' icon.
  static const IconData strokeRoundedCommentBlock01 =
      IconData(0x3e43, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCommentBlock02' icon.
  static const IconData strokeRoundedCommentBlock02 =
      IconData(0x3e44, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCommentRemove01' icon.
  static const IconData strokeRoundedCommentRemove01 =
      IconData(0x3e45, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCommentRemove02' icon.
  static const IconData strokeRoundedCommentRemove02 =
      IconData(0x3e46, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCompass01' icon.
  static const IconData strokeRoundedCompass01 =
      IconData(0x3e47, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCompass' icon.
  static const IconData strokeRoundedCompass =
      IconData(0x3e48, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedComplaint' icon.
  static const IconData strokeRoundedComplaint =
      IconData(0x3e49, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedComputerAdd' icon.
  static const IconData strokeRoundedComputerAdd =
      IconData(0x3e4a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedComputerCheck' icon.
  static const IconData strokeRoundedComputerCheck =
      IconData(0x3e4b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedComputerCloud' icon.
  static const IconData strokeRoundedComputerCloud =
      IconData(0x3e4c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedComputerDesk01' icon.
  static const IconData strokeRoundedComputerDesk01 =
      IconData(0x3e4d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedComputerDesk02' icon.
  static const IconData strokeRoundedComputerDesk02 =
      IconData(0x3e4e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedComputerDesk03' icon.
  static const IconData strokeRoundedComputerDesk03 =
      IconData(0x3e4f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedComputerDollar' icon.
  static const IconData strokeRoundedComputerDollar =
      IconData(0x3e50, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedComputerPhoneSync' icon.
  static const IconData strokeRoundedComputerPhoneSync =
      IconData(0x3e51, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedComputerProgramming01' icon.
  static const IconData strokeRoundedComputerProgramming01 =
      IconData(0x3e52, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedComputerProgramming02' icon.
  static const IconData strokeRoundedComputerProgramming02 =
      IconData(0x3e53, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedComputerProtection' icon.
  static const IconData strokeRoundedComputerProtection =
      IconData(0x3e54, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedComputerRemove' icon.
  static const IconData strokeRoundedComputerRemove =
      IconData(0x3e55, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedComputerSettings' icon.
  static const IconData strokeRoundedComputerSettings =
      IconData(0x3e56, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedComputerVideoCall' icon.
  static const IconData strokeRoundedComputerVideoCall =
      IconData(0x3e57, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedComputerVideo' icon.
  static const IconData strokeRoundedComputerVideo =
      IconData(0x3e58, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedComputer' icon.
  static const IconData strokeRoundedComputer =
      IconData(0x3e59, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCone01' icon.
  static const IconData strokeRoundedCone01 =
      IconData(0x3e5a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCone02' icon.
  static const IconData strokeRoundedCone02 =
      IconData(0x3e5b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedConference' icon.
  static const IconData strokeRoundedConference =
      IconData(0x3e5c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedConfiguration01' icon.
  static const IconData strokeRoundedConfiguration01 =
      IconData(0x3e5d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedConfiguration02' icon.
  static const IconData strokeRoundedConfiguration02 =
      IconData(0x3e5e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedConfused' icon.
  static const IconData strokeRoundedConfused =
      IconData(0x3e5f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCongruentToCircle' icon.
  static const IconData strokeRoundedCongruentToCircle =
      IconData(0x3e60, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCongruentToSquare' icon.
  static const IconData strokeRoundedCongruentToSquare =
      IconData(0x3e61, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCongruentTo' icon.
  static const IconData strokeRoundedCongruentTo =
      IconData(0x3e62, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedConnect' icon.
  static const IconData strokeRoundedConnect =
      IconData(0x3e63, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedConsole' icon.
  static const IconData strokeRoundedConsole =
      IconData(0x3e64, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedConstellation' icon.
  static const IconData strokeRoundedConstellation =
      IconData(0x3e65, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedContact01' icon.
  static const IconData strokeRoundedContact01 =
      IconData(0x3e66, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedContact02' icon.
  static const IconData strokeRoundedContact02 =
      IconData(0x3e67, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedContactBook' icon.
  static const IconData strokeRoundedContactBook =
      IconData(0x3e68, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedContact' icon.
  static const IconData strokeRoundedContact =
      IconData(0x3e69, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedContainerTruck01' icon.
  static const IconData strokeRoundedContainerTruck01 =
      IconData(0x3e6a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedContainerTruck02' icon.
  static const IconData strokeRoundedContainerTruck02 =
      IconData(0x3e6b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedContainerTruck' icon.
  static const IconData strokeRoundedContainerTruck =
      IconData(0x3e6c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedContracts' icon.
  static const IconData strokeRoundedContracts =
      IconData(0x3e6d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedConversation' icon.
  static const IconData strokeRoundedConversation =
      IconData(0x3e6e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCookBook' icon.
  static const IconData strokeRoundedCookBook =
      IconData(0x3e6f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCookie' icon.
  static const IconData strokeRoundedCookie =
      IconData(0x3e70, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCoordinate01' icon.
  static const IconData strokeRoundedCoordinate01 =
      IconData(0x3e71, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCoordinate02' icon.
  static const IconData strokeRoundedCoordinate02 =
      IconData(0x3e72, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCopilot' icon.
  static const IconData strokeRoundedCopilot =
      IconData(0x3e73, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCopy01' icon.
  static const IconData strokeRoundedCopy01 =
      IconData(0x3e74, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCopy02' icon.
  static const IconData strokeRoundedCopy02 =
      IconData(0x3e75, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCopyLink' icon.
  static const IconData strokeRoundedCopyLink =
      IconData(0x3e76, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCopyright' icon.
  static const IconData strokeRoundedCopyright =
      IconData(0x3e77, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCorn' icon.
  static const IconData strokeRoundedCorn =
      IconData(0x3e78, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCorporate' icon.
  static const IconData strokeRoundedCorporate =
      IconData(0x3e79, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCos' icon.
  static const IconData strokeRoundedCos =
      IconData(0x3e7a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCosine01' icon.
  static const IconData strokeRoundedCosine01 =
      IconData(0x3e7b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCosine02' icon.
  static const IconData strokeRoundedCosine02 =
      IconData(0x3e7c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCottage' icon.
  static const IconData strokeRoundedCottage =
      IconData(0x3e7d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCottonCandy' icon.
  static const IconData strokeRoundedCottonCandy =
      IconData(0x3e7e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCoupon01' icon.
  static const IconData strokeRoundedCoupon01 =
      IconData(0x3e7f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCoupon02' icon.
  static const IconData strokeRoundedCoupon02 =
      IconData(0x3e80, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCoupon03' icon.
  static const IconData strokeRoundedCoupon03 =
      IconData(0x3e81, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCouponPercent' icon.
  static const IconData strokeRoundedCouponPercent =
      IconData(0x3e82, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCourse' icon.
  static const IconData strokeRoundedCourse =
      IconData(0x3e83, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCourtHouse' icon.
  static const IconData strokeRoundedCourtHouse =
      IconData(0x3e84, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCourtLaw' icon.
  static const IconData strokeRoundedCourtLaw =
      IconData(0x3e85, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCovariate' icon.
  static const IconData strokeRoundedCovariate =
      IconData(0x3e86, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCovidInfo' icon.
  static const IconData strokeRoundedCovidInfo =
      IconData(0x3e87, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCowboyHat' icon.
  static const IconData strokeRoundedCowboyHat =
      IconData(0x3e88, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCplusplus' icon.
  static const IconData strokeRoundedCplusplus =
      IconData(0x3e89, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCpuCharge' icon.
  static const IconData strokeRoundedCpuCharge =
      IconData(0x3e8a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCpuSettings' icon.
  static const IconData strokeRoundedCpuSettings =
      IconData(0x3e8b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCpu' icon.
  static const IconData strokeRoundedCpu =
      IconData(0x3e8c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCrab' icon.
  static const IconData strokeRoundedCrab =
      IconData(0x3e8d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCrane' icon.
  static const IconData strokeRoundedCrane =
      IconData(0x3e8e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCrazy' icon.
  static const IconData strokeRoundedCrazy =
      IconData(0x3e8f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCreativeMarket' icon.
  static const IconData strokeRoundedCreativeMarket =
      IconData(0x3e90, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCreditCardAccept' icon.
  static const IconData strokeRoundedCreditCardAccept =
      IconData(0x3e91, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCreditCardAdd' icon.
  static const IconData strokeRoundedCreditCardAdd =
      IconData(0x3e92, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCreditCardChange' icon.
  static const IconData strokeRoundedCreditCardChange =
      IconData(0x3e93, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCreditCardDefrost' icon.
  static const IconData strokeRoundedCreditCardDefrost =
      IconData(0x3e94, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCreditCardFreeze' icon.
  static const IconData strokeRoundedCreditCardFreeze =
      IconData(0x3e95, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCreditCardNotAccept' icon.
  static const IconData strokeRoundedCreditCardNotAccept =
      IconData(0x3e96, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCreditCardNotFound' icon.
  static const IconData strokeRoundedCreditCardNotFound =
      IconData(0x3e97, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCreditCardPos' icon.
  static const IconData strokeRoundedCreditCardPos =
      IconData(0x3e98, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCreditCardValidation' icon.
  static const IconData strokeRoundedCreditCardValidation =
      IconData(0x3e99, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCreditCard' icon.
  static const IconData strokeRoundedCreditCard =
      IconData(0x3e9a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCricketBat' icon.
  static const IconData strokeRoundedCricketBat =
      IconData(0x3e9b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCricketHelmet' icon.
  static const IconData strokeRoundedCricketHelmet =
      IconData(0x3e9c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCroissant' icon.
  static const IconData strokeRoundedCroissant =
      IconData(0x3e9d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCrop' icon.
  static const IconData strokeRoundedCrop =
      IconData(0x3e9e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCrowdfunding' icon.
  static const IconData strokeRoundedCrowdfunding =
      IconData(0x3e9f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCrown' icon.
  static const IconData strokeRoundedCrown =
      IconData(0x3ea0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCrying' icon.
  static const IconData strokeRoundedCrying =
      IconData(0x3ea1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCsv01' icon.
  static const IconData strokeRoundedCsv01 =
      IconData(0x3ea2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCsv02' icon.
  static const IconData strokeRoundedCsv02 =
      IconData(0x3ea3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCube' icon.
  static const IconData strokeRoundedCube =
      IconData(0x3ea4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCupcake01' icon.
  static const IconData strokeRoundedCupcake01 =
      IconData(0x3ea5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCupcake02' icon.
  static const IconData strokeRoundedCupcake02 =
      IconData(0x3ea6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCupcake03' icon.
  static const IconData strokeRoundedCupcake03 =
      IconData(0x3ea7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCurling' icon.
  static const IconData strokeRoundedCurling =
      IconData(0x3ea8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursor01' icon.
  static const IconData strokeRoundedCursor01 =
      IconData(0x3ea9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursor02' icon.
  static const IconData strokeRoundedCursor02 =
      IconData(0x3eaa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorAddSelection01' icon.
  static const IconData strokeRoundedCursorAddSelection01 =
      IconData(0x3eab, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorAddSelection02' icon.
  static const IconData strokeRoundedCursorAddSelection02 =
      IconData(0x3eac, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorCircleSelection01' icon.
  static const IconData strokeRoundedCursorCircleSelection01 =
      IconData(0x3ead, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorCircleSelection02' icon.
  static const IconData strokeRoundedCursorCircleSelection02 =
      IconData(0x3eae, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorDisabled01' icon.
  static const IconData strokeRoundedCursorDisabled01 =
      IconData(0x3eaf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorDisabled02' icon.
  static const IconData strokeRoundedCursorDisabled02 =
      IconData(0x3eb0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorEdit01' icon.
  static const IconData strokeRoundedCursorEdit01 =
      IconData(0x3eb1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorEdit02' icon.
  static const IconData strokeRoundedCursorEdit02 =
      IconData(0x3eb2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorHold01' icon.
  static const IconData strokeRoundedCursorHold01 =
      IconData(0x3eb3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorHold02' icon.
  static const IconData strokeRoundedCursorHold02 =
      IconData(0x3eb4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorInWindow' icon.
  static const IconData strokeRoundedCursorInWindow =
      IconData(0x3eb5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorInfo01' icon.
  static const IconData strokeRoundedCursorInfo01 =
      IconData(0x3eb6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorInfo02' icon.
  static const IconData strokeRoundedCursorInfo02 =
      IconData(0x3eb7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorLoading01' icon.
  static const IconData strokeRoundedCursorLoading01 =
      IconData(0x3eb8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorLoading02' icon.
  static const IconData strokeRoundedCursorLoading02 =
      IconData(0x3eb9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorMagicSelection01' icon.
  static const IconData strokeRoundedCursorMagicSelection01 =
      IconData(0x3eba, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorMagicSelection02' icon.
  static const IconData strokeRoundedCursorMagicSelection02 =
      IconData(0x3ebb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorMove01' icon.
  static const IconData strokeRoundedCursorMove01 =
      IconData(0x3ebc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorMove02' icon.
  static const IconData strokeRoundedCursorMove02 =
      IconData(0x3ebd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorPointer01' icon.
  static const IconData strokeRoundedCursorPointer01 =
      IconData(0x3ebe, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorPointer02' icon.
  static const IconData strokeRoundedCursorPointer02 =
      IconData(0x3ebf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorProgress01' icon.
  static const IconData strokeRoundedCursorProgress01 =
      IconData(0x3ec0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorProgress02' icon.
  static const IconData strokeRoundedCursorProgress02 =
      IconData(0x3ec1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorProgress03' icon.
  static const IconData strokeRoundedCursorProgress03 =
      IconData(0x3ec2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorProgress04' icon.
  static const IconData strokeRoundedCursorProgress04 =
      IconData(0x3ec3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorRectangleSelection01' icon.
  static const IconData strokeRoundedCursorRectangleSelection01 =
      IconData(0x3ec4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorRectangleSelection02' icon.
  static const IconData strokeRoundedCursorRectangleSelection02 =
      IconData(0x3ec5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorRemoveSelection01' icon.
  static const IconData strokeRoundedCursorRemoveSelection01 =
      IconData(0x3ec6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorRemoveSelection02' icon.
  static const IconData strokeRoundedCursorRemoveSelection02 =
      IconData(0x3ec7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCursorText' icon.
  static const IconData strokeRoundedCursorText =
      IconData(0x3ec8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCurtains' icon.
  static const IconData strokeRoundedCurtains =
      IconData(0x3ec9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCurvyLeftDirection' icon.
  static const IconData strokeRoundedCurvyLeftDirection =
      IconData(0x3eca, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCurvyLeftRightDirection' icon.
  static const IconData strokeRoundedCurvyLeftRightDirection =
      IconData(0x3ecb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCurvyRightDirection' icon.
  static const IconData strokeRoundedCurvyRightDirection =
      IconData(0x3ecc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCurvyUpDownDirection' icon.
  static const IconData strokeRoundedCurvyUpDownDirection =
      IconData(0x3ecd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCustomerService01' icon.
  static const IconData strokeRoundedCustomerService01 =
      IconData(0x3ece, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCustomerService02' icon.
  static const IconData strokeRoundedCustomerService02 =
      IconData(0x3ecf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCustomerService' icon.
  static const IconData strokeRoundedCustomerService =
      IconData(0x3ed0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCustomerSupport' icon.
  static const IconData strokeRoundedCustomerSupport =
      IconData(0x3ed1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCustomize' icon.
  static const IconData strokeRoundedCustomize =
      IconData(0x3ed2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCylinder01' icon.
  static const IconData strokeRoundedCylinder01 =
      IconData(0x3ed3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCylinder02' icon.
  static const IconData strokeRoundedCylinder02 =
      IconData(0x3ed4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCylinder03' icon.
  static const IconData strokeRoundedCylinder03 =
      IconData(0x3ed5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedCylinder04' icon.
  static const IconData strokeRoundedCylinder04 =
      IconData(0x3ed6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDanger' icon.
  static const IconData strokeRoundedDanger =
      IconData(0x3ed7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDarkMode' icon.
  static const IconData strokeRoundedDarkMode =
      IconData(0x3ed8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDart' icon.
  static const IconData strokeRoundedDart =
      IconData(0x3ed9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDashboardBrowsing' icon.
  static const IconData strokeRoundedDashboardBrowsing =
      IconData(0x3eda, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDashboardCircleAdd' icon.
  static const IconData strokeRoundedDashboardCircleAdd =
      IconData(0x3edb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDashboardCircleEdit' icon.
  static const IconData strokeRoundedDashboardCircleEdit =
      IconData(0x3edc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDashboardCircleRemove' icon.
  static const IconData strokeRoundedDashboardCircleRemove =
      IconData(0x3edd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDashboardCircleSettings' icon.
  static const IconData strokeRoundedDashboardCircleSettings =
      IconData(0x3ede, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDashboardCircle' icon.
  static const IconData strokeRoundedDashboardCircle =
      IconData(0x3edf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDashboardSpeed01' icon.
  static const IconData strokeRoundedDashboardSpeed01 =
      IconData(0x3ee0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDashboardSpeed02' icon.
  static const IconData strokeRoundedDashboardSpeed02 =
      IconData(0x3ee1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDashboardSquare01' icon.
  static const IconData strokeRoundedDashboardSquare01 =
      IconData(0x3ee2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDashboardSquare02' icon.
  static const IconData strokeRoundedDashboardSquare02 =
      IconData(0x3ee3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDashboardSquare03' icon.
  static const IconData strokeRoundedDashboardSquare03 =
      IconData(0x3ee4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDashboardSquareAdd' icon.
  static const IconData strokeRoundedDashboardSquareAdd =
      IconData(0x3ee5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDashboardSquareEdit' icon.
  static const IconData strokeRoundedDashboardSquareEdit =
      IconData(0x3ee6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDashboardSquareRemove' icon.
  static const IconData strokeRoundedDashboardSquareRemove =
      IconData(0x3ee7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDashboardSquareSetting' icon.
  static const IconData strokeRoundedDashboardSquareSetting =
      IconData(0x3ee8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDashedLine01' icon.
  static const IconData strokeRoundedDashedLine01 =
      IconData(0x3ee9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDashedLine02' icon.
  static const IconData strokeRoundedDashedLine02 =
      IconData(0x3eea, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDataRecovery' icon.
  static const IconData strokeRoundedDataRecovery =
      IconData(0x3eeb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDatabase01' icon.
  static const IconData strokeRoundedDatabase01 =
      IconData(0x3eec, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDatabase02' icon.
  static const IconData strokeRoundedDatabase02 =
      IconData(0x3eed, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDatabaseAdd' icon.
  static const IconData strokeRoundedDatabaseAdd =
      IconData(0x3eee, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDatabaseExport' icon.
  static const IconData strokeRoundedDatabaseExport =
      IconData(0x3eef, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDatabaseImport' icon.
  static const IconData strokeRoundedDatabaseImport =
      IconData(0x3ef0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDatabaseLocked' icon.
  static const IconData strokeRoundedDatabaseLocked =
      IconData(0x3ef1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDatabaseRestore' icon.
  static const IconData strokeRoundedDatabaseRestore =
      IconData(0x3ef2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDatabaseSetting' icon.
  static const IconData strokeRoundedDatabaseSetting =
      IconData(0x3ef3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDatabaseSync01' icon.
  static const IconData strokeRoundedDatabaseSync01 =
      IconData(0x3ef4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDatabaseSync' icon.
  static const IconData strokeRoundedDatabaseSync =
      IconData(0x3ef5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDatabase' icon.
  static const IconData strokeRoundedDatabase =
      IconData(0x3ef6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDates' icon.
  static const IconData strokeRoundedDates =
      IconData(0x3ef7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDead' icon.
  static const IconData strokeRoundedDead =
      IconData(0x3ef8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDelete01' icon.
  static const IconData strokeRoundedDelete01 =
      IconData(0x3ef9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDelete02' icon.
  static const IconData strokeRoundedDelete02 =
      IconData(0x3efa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDelete03' icon.
  static const IconData strokeRoundedDelete03 =
      IconData(0x3efb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDelete04' icon.
  static const IconData strokeRoundedDelete04 =
      IconData(0x3efc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDeleteColumn' icon.
  static const IconData strokeRoundedDeleteColumn =
      IconData(0x3efd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDeletePutBack' icon.
  static const IconData strokeRoundedDeletePutBack =
      IconData(0x3efe, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDeleteRow' icon.
  static const IconData strokeRoundedDeleteRow =
      IconData(0x3eff, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDeleteThrow' icon.
  static const IconData strokeRoundedDeleteThrow =
      IconData(0x3f00, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDeliveredSent' icon.
  static const IconData strokeRoundedDeliveredSent =
      IconData(0x3f01, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDeliveryBox01' icon.
  static const IconData strokeRoundedDeliveryBox01 =
      IconData(0x3f02, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDeliveryBox02' icon.
  static const IconData strokeRoundedDeliveryBox02 =
      IconData(0x3f03, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDeliveryDelay01' icon.
  static const IconData strokeRoundedDeliveryDelay01 =
      IconData(0x3f04, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDeliveryDelay02' icon.
  static const IconData strokeRoundedDeliveryDelay02 =
      IconData(0x3f05, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDeliveryReturn01' icon.
  static const IconData strokeRoundedDeliveryReturn01 =
      IconData(0x3f06, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDeliveryReturn02' icon.
  static const IconData strokeRoundedDeliveryReturn02 =
      IconData(0x3f07, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDeliverySecure01' icon.
  static const IconData strokeRoundedDeliverySecure01 =
      IconData(0x3f08, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDeliverySecure02' icon.
  static const IconData strokeRoundedDeliverySecure02 =
      IconData(0x3f09, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDeliverySent01' icon.
  static const IconData strokeRoundedDeliverySent01 =
      IconData(0x3f0a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDeliverySent02' icon.
  static const IconData strokeRoundedDeliverySent02 =
      IconData(0x3f0b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDeliveryTracking01' icon.
  static const IconData strokeRoundedDeliveryTracking01 =
      IconData(0x3f0c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDeliveryTracking02' icon.
  static const IconData strokeRoundedDeliveryTracking02 =
      IconData(0x3f0d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDeliveryTruck01' icon.
  static const IconData strokeRoundedDeliveryTruck01 =
      IconData(0x3f0e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDeliveryTruck02' icon.
  static const IconData strokeRoundedDeliveryTruck02 =
      IconData(0x3f0f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDeliveryView01' icon.
  static const IconData strokeRoundedDeliveryView01 =
      IconData(0x3f10, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDeliveryView02' icon.
  static const IconData strokeRoundedDeliveryView02 =
      IconData(0x3f11, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDentalBraces' icon.
  static const IconData strokeRoundedDentalBraces =
      IconData(0x3f12, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDentalBrokenTooth' icon.
  static const IconData strokeRoundedDentalBrokenTooth =
      IconData(0x3f13, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDentalCare' icon.
  static const IconData strokeRoundedDentalCare =
      IconData(0x3f14, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDentalTooth' icon.
  static const IconData strokeRoundedDentalTooth =
      IconData(0x3f15, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDepartement' icon.
  static const IconData strokeRoundedDepartement =
      IconData(0x3f16, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDesert' icon.
  static const IconData strokeRoundedDesert =
      IconData(0x3f17, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDesk01' icon.
  static const IconData strokeRoundedDesk01 =
      IconData(0x3f18, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDesk02' icon.
  static const IconData strokeRoundedDesk02 =
      IconData(0x3f19, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDesk' icon.
  static const IconData strokeRoundedDesk =
      IconData(0x3f1a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDeveloper' icon.
  static const IconData strokeRoundedDeveloper =
      IconData(0x3f1b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDeviantart' icon.
  static const IconData strokeRoundedDeviantart =
      IconData(0x3f1c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDeviceAccess' icon.
  static const IconData strokeRoundedDeviceAccess =
      IconData(0x3f1d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDiagonalScrollPoint01' icon.
  static const IconData strokeRoundedDiagonalScrollPoint01 =
      IconData(0x3f1e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDiagonalScrollPoint02' icon.
  static const IconData strokeRoundedDiagonalScrollPoint02 =
      IconData(0x3f1f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDialpadCircle01' icon.
  static const IconData strokeRoundedDialpadCircle01 =
      IconData(0x3f20, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDialpadCircle02' icon.
  static const IconData strokeRoundedDialpadCircle02 =
      IconData(0x3f21, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDialpadSquare01' icon.
  static const IconData strokeRoundedDialpadSquare01 =
      IconData(0x3f22, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDialpadSquare02' icon.
  static const IconData strokeRoundedDialpadSquare02 =
      IconData(0x3f23, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDiameter' icon.
  static const IconData strokeRoundedDiameter =
      IconData(0x3f24, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDiamond01' icon.
  static const IconData strokeRoundedDiamond01 =
      IconData(0x3f25, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDiamond02' icon.
  static const IconData strokeRoundedDiamond02 =
      IconData(0x3f26, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDiamond' icon.
  static const IconData strokeRoundedDiamond =
      IconData(0x3f27, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDiaper' icon.
  static const IconData strokeRoundedDiaper =
      IconData(0x3f28, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDiceFaces01' icon.
  static const IconData strokeRoundedDiceFaces01 =
      IconData(0x3f29, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDiceFaces02' icon.
  static const IconData strokeRoundedDiceFaces02 =
      IconData(0x3f2a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDiceFaces03' icon.
  static const IconData strokeRoundedDiceFaces03 =
      IconData(0x3f2b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDiceFaces04' icon.
  static const IconData strokeRoundedDiceFaces04 =
      IconData(0x3f2c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDiceFaces05' icon.
  static const IconData strokeRoundedDiceFaces05 =
      IconData(0x3f2d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDiceFaces06' icon.
  static const IconData strokeRoundedDiceFaces06 =
      IconData(0x3f2e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDice' icon.
  static const IconData strokeRoundedDice =
      IconData(0x3f2f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDigestion' icon.
  static const IconData strokeRoundedDigestion =
      IconData(0x3f30, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDigg' icon.
  static const IconData strokeRoundedDigg =
      IconData(0x3f31, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDigitalClock' icon.
  static const IconData strokeRoundedDigitalClock =
      IconData(0x3f32, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDimSum01' icon.
  static const IconData strokeRoundedDimSum01 =
      IconData(0x3f33, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDimSum02' icon.
  static const IconData strokeRoundedDimSum02 =
      IconData(0x3f34, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDiningTable' icon.
  static const IconData strokeRoundedDiningTable =
      IconData(0x3f35, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDiploma' icon.
  static const IconData strokeRoundedDiploma =
      IconData(0x3f36, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDirectionLeft01' icon.
  static const IconData strokeRoundedDirectionLeft01 =
      IconData(0x3f37, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDirectionLeft02' icon.
  static const IconData strokeRoundedDirectionLeft02 =
      IconData(0x3f38, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDirectionRight01' icon.
  static const IconData strokeRoundedDirectionRight01 =
      IconData(0x3f39, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDirectionRight02' icon.
  static const IconData strokeRoundedDirectionRight02 =
      IconData(0x3f3a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDirections01' icon.
  static const IconData strokeRoundedDirections01 =
      IconData(0x3f3b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDirections02' icon.
  static const IconData strokeRoundedDirections02 =
      IconData(0x3f3c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDirham' icon.
  static const IconData strokeRoundedDirham =
      IconData(0x3f3d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDisability01' icon.
  static const IconData strokeRoundedDisability01 =
      IconData(0x3f3e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDisability02' icon.
  static const IconData strokeRoundedDisability02 =
      IconData(0x3f3f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDiscord' icon.
  static const IconData strokeRoundedDiscord =
      IconData(0x3f40, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDiscount01' icon.
  static const IconData strokeRoundedDiscount01 =
      IconData(0x3f41, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDiscountTag01' icon.
  static const IconData strokeRoundedDiscountTag01 =
      IconData(0x3f42, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDiscountTag02' icon.
  static const IconData strokeRoundedDiscountTag02 =
      IconData(0x3f43, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDiscount' icon.
  static const IconData strokeRoundedDiscount =
      IconData(0x3f44, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDiscoverCircle' icon.
  static const IconData strokeRoundedDiscoverCircle =
      IconData(0x3f45, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDiscoverSquare' icon.
  static const IconData strokeRoundedDiscoverSquare =
      IconData(0x3f46, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDish01' icon.
  static const IconData strokeRoundedDish01 =
      IconData(0x3f47, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDish02' icon.
  static const IconData strokeRoundedDish02 =
      IconData(0x3f48, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDishWasher' icon.
  static const IconData strokeRoundedDishWasher =
      IconData(0x3f49, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDispleased' icon.
  static const IconData strokeRoundedDispleased =
      IconData(0x3f4a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDistributeHorizontalCenter' icon.
  static const IconData strokeRoundedDistributeHorizontalCenter =
      IconData(0x3f4b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDistributeHorizontalLeft' icon.
  static const IconData strokeRoundedDistributeHorizontalLeft =
      IconData(0x3f4c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDistributeHorizontalRight' icon.
  static const IconData strokeRoundedDistributeHorizontalRight =
      IconData(0x3f4d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDistributeVerticalBottom' icon.
  static const IconData strokeRoundedDistributeVerticalBottom =
      IconData(0x3f4e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDistributeVerticalCenter' icon.
  static const IconData strokeRoundedDistributeVerticalCenter =
      IconData(0x3f4f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDistributeVerticalTop' icon.
  static const IconData strokeRoundedDistributeVerticalTop =
      IconData(0x3f50, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDistribution' icon.
  static const IconData strokeRoundedDistribution =
      IconData(0x3f51, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDivideSignCircle' icon.
  static const IconData strokeRoundedDivideSignCircle =
      IconData(0x3f52, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDivideSignSquare' icon.
  static const IconData strokeRoundedDivideSignSquare =
      IconData(0x3f53, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDivideSign' icon.
  static const IconData strokeRoundedDivideSign =
      IconData(0x3f54, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDna01' icon.
  static const IconData strokeRoundedDna01 =
      IconData(0x3f55, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDna' icon.
  static const IconData strokeRoundedDna =
      IconData(0x3f56, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDoNotTouch01' icon.
  static const IconData strokeRoundedDoNotTouch01 =
      IconData(0x3f57, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDoNotTouch02' icon.
  static const IconData strokeRoundedDoNotTouch02 =
      IconData(0x3f58, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDoc01' icon.
  static const IconData strokeRoundedDoc01 =
      IconData(0x3f59, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDoc02' icon.
  static const IconData strokeRoundedDoc02 =
      IconData(0x3f5a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDoctor01' icon.
  static const IconData strokeRoundedDoctor01 =
      IconData(0x3f5b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDoctor02' icon.
  static const IconData strokeRoundedDoctor02 =
      IconData(0x3f5c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDoctor03' icon.
  static const IconData strokeRoundedDoctor03 =
      IconData(0x3f5d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDocumentAttachment' icon.
  static const IconData strokeRoundedDocumentAttachment =
      IconData(0x3f5e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDocumentCode' icon.
  static const IconData strokeRoundedDocumentCode =
      IconData(0x3f5f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDocumentValidation' icon.
  static const IconData strokeRoundedDocumentValidation =
      IconData(0x3f60, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDollar01' icon.
  static const IconData strokeRoundedDollar01 =
      IconData(0x3f61, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDollar02' icon.
  static const IconData strokeRoundedDollar02 =
      IconData(0x3f62, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDollarCircle' icon.
  static const IconData strokeRoundedDollarCircle =
      IconData(0x3f63, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDollarReceive01' icon.
  static const IconData strokeRoundedDollarReceive01 =
      IconData(0x3f64, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDollarReceive02' icon.
  static const IconData strokeRoundedDollarReceive02 =
      IconData(0x3f65, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDollarSend01' icon.
  static const IconData strokeRoundedDollarSend01 =
      IconData(0x3f66, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDollarSend02' icon.
  static const IconData strokeRoundedDollarSend02 =
      IconData(0x3f67, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDollarSquare' icon.
  static const IconData strokeRoundedDollarSquare =
      IconData(0x3f68, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDome' icon.
  static const IconData strokeRoundedDome =
      IconData(0x3f69, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDomino' icon.
  static const IconData strokeRoundedDomino =
      IconData(0x3f6a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDoor01' icon.
  static const IconData strokeRoundedDoor01 =
      IconData(0x3f6b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDoor02' icon.
  static const IconData strokeRoundedDoor02 =
      IconData(0x3f6c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDoorLock' icon.
  static const IconData strokeRoundedDoorLock =
      IconData(0x3f6d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDoor' icon.
  static const IconData strokeRoundedDoor =
      IconData(0x3f6e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDoughnut' icon.
  static const IconData strokeRoundedDoughnut =
      IconData(0x3f6f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDownload01' icon.
  static const IconData strokeRoundedDownload01 =
      IconData(0x3f70, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDownload02' icon.
  static const IconData strokeRoundedDownload02 =
      IconData(0x3f71, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDownload03' icon.
  static const IconData strokeRoundedDownload03 =
      IconData(0x3f72, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDownload04' icon.
  static const IconData strokeRoundedDownload04 =
      IconData(0x3f73, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDownload05' icon.
  static const IconData strokeRoundedDownload05 =
      IconData(0x3f74, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDownloadCircle01' icon.
  static const IconData strokeRoundedDownloadCircle01 =
      IconData(0x3f75, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDownloadCircle02' icon.
  static const IconData strokeRoundedDownloadCircle02 =
      IconData(0x3f76, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDownloadSquare01' icon.
  static const IconData strokeRoundedDownloadSquare01 =
      IconData(0x3f77, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDownloadSquare02' icon.
  static const IconData strokeRoundedDownloadSquare02 =
      IconData(0x3f78, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDrag01' icon.
  static const IconData strokeRoundedDrag01 =
      IconData(0x3f79, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDrag02' icon.
  static const IconData strokeRoundedDrag02 =
      IconData(0x3f7a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDrag03' icon.
  static const IconData strokeRoundedDrag03 =
      IconData(0x3f7b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDrag04' icon.
  static const IconData strokeRoundedDrag04 =
      IconData(0x3f7c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDragDropHorizontal' icon.
  static const IconData strokeRoundedDragDropHorizontal =
      IconData(0x3f7d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDragDropVertical' icon.
  static const IconData strokeRoundedDragDropVertical =
      IconData(0x3f7e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDragDrop' icon.
  static const IconData strokeRoundedDragDrop =
      IconData(0x3f7f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDragLeft01' icon.
  static const IconData strokeRoundedDragLeft01 =
      IconData(0x3f80, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDragLeft02' icon.
  static const IconData strokeRoundedDragLeft02 =
      IconData(0x3f81, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDragLeft03' icon.
  static const IconData strokeRoundedDragLeft03 =
      IconData(0x3f82, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDragLeft04' icon.
  static const IconData strokeRoundedDragLeft04 =
      IconData(0x3f83, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDragRight01' icon.
  static const IconData strokeRoundedDragRight01 =
      IconData(0x3f84, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDragRight02' icon.
  static const IconData strokeRoundedDragRight02 =
      IconData(0x3f85, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDragRight03' icon.
  static const IconData strokeRoundedDragRight03 =
      IconData(0x3f86, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDragRight04' icon.
  static const IconData strokeRoundedDragRight04 =
      IconData(0x3f87, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDrawingCompass' icon.
  static const IconData strokeRoundedDrawingCompass =
      IconData(0x3f88, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDrawingMode' icon.
  static const IconData strokeRoundedDrawingMode =
      IconData(0x3f89, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDress01' icon.
  static const IconData strokeRoundedDress01 =
      IconData(0x3f8a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDress02' icon.
  static const IconData strokeRoundedDress02 =
      IconData(0x3f8b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDress03' icon.
  static const IconData strokeRoundedDress03 =
      IconData(0x3f8c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDress04' icon.
  static const IconData strokeRoundedDress04 =
      IconData(0x3f8d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDress05' icon.
  static const IconData strokeRoundedDress05 =
      IconData(0x3f8e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDress06' icon.
  static const IconData strokeRoundedDress06 =
      IconData(0x3f8f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDress07' icon.
  static const IconData strokeRoundedDress07 =
      IconData(0x3f90, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDressingTable01' icon.
  static const IconData strokeRoundedDressingTable01 =
      IconData(0x3f91, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDressingTable02' icon.
  static const IconData strokeRoundedDressingTable02 =
      IconData(0x3f92, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDressingTable03' icon.
  static const IconData strokeRoundedDressingTable03 =
      IconData(0x3f93, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDribbble' icon.
  static const IconData strokeRoundedDribbble =
      IconData(0x3f94, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDrink' icon.
  static const IconData strokeRoundedDrink =
      IconData(0x3f95, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDrone' icon.
  static const IconData strokeRoundedDrone =
      IconData(0x3f96, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDrooling' icon.
  static const IconData strokeRoundedDrooling =
      IconData(0x3f97, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDropbox' icon.
  static const IconData strokeRoundedDropbox =
      IconData(0x3f98, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDroplet' icon.
  static const IconData strokeRoundedDroplet =
      IconData(0x3f99, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDropper' icon.
  static const IconData strokeRoundedDropper =
      IconData(0x3f9a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDs3Tool' icon.
  static const IconData strokeRoundedDs3Tool =
      IconData(0x3f9b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDua' icon.
  static const IconData strokeRoundedDua =
      IconData(0x3f9c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDumbbell01' icon.
  static const IconData strokeRoundedDumbbell01 =
      IconData(0x3f9d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDumbbell02' icon.
  static const IconData strokeRoundedDumbbell02 =
      IconData(0x3f9e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedDumbbell03' icon.
  static const IconData strokeRoundedDumbbell03 =
      IconData(0x3f9f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEarRings01' icon.
  static const IconData strokeRoundedEarRings01 =
      IconData(0x3fa0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEarRings02' icon.
  static const IconData strokeRoundedEarRings02 =
      IconData(0x3fa1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEarRings03' icon.
  static const IconData strokeRoundedEarRings03 =
      IconData(0x3fa2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEar' icon.
  static const IconData strokeRoundedEar =
      IconData(0x3fa3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEarth' icon.
  static const IconData strokeRoundedEarth =
      IconData(0x3fa4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEaseCurveControlPoints' icon.
  static const IconData strokeRoundedEaseCurveControlPoints =
      IconData(0x3fa5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEaseInControlPoint' icon.
  static const IconData strokeRoundedEaseInControlPoint =
      IconData(0x3fa6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEaseInOut' icon.
  static const IconData strokeRoundedEaseInOut =
      IconData(0x3fa7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEaseIn' icon.
  static const IconData strokeRoundedEaseIn =
      IconData(0x3fa8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEaseOutControlPoint' icon.
  static const IconData strokeRoundedEaseOutControlPoint =
      IconData(0x3fa9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEaseOut' icon.
  static const IconData strokeRoundedEaseOut =
      IconData(0x3faa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEcoEnergy' icon.
  static const IconData strokeRoundedEcoEnergy =
      IconData(0x3fab, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEcoLab01' icon.
  static const IconData strokeRoundedEcoLab01 =
      IconData(0x3fac, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEcoLab02' icon.
  static const IconData strokeRoundedEcoLab02 =
      IconData(0x3fad, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEcoLab' icon.
  static const IconData strokeRoundedEcoLab =
      IconData(0x3fae, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEcoPower' icon.
  static const IconData strokeRoundedEcoPower =
      IconData(0x3faf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEdgeStyle' icon.
  static const IconData strokeRoundedEdgeStyle =
      IconData(0x3fb0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEdit01' icon.
  static const IconData strokeRoundedEdit01 =
      IconData(0x3fb1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEdit02' icon.
  static const IconData strokeRoundedEdit02 =
      IconData(0x3fb2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEditOff' icon.
  static const IconData strokeRoundedEditOff =
      IconData(0x3fb3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEditRoad' icon.
  static const IconData strokeRoundedEditRoad =
      IconData(0x3fb4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEditTable' icon.
  static const IconData strokeRoundedEditTable =
      IconData(0x3fb5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEditUser02' icon.
  static const IconData strokeRoundedEditUser02 =
      IconData(0x3fb6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEggs' icon.
  static const IconData strokeRoundedEggs =
      IconData(0x3fb7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEidMubarak' icon.
  static const IconData strokeRoundedEidMubarak =
      IconData(0x3fb8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEiffelTower' icon.
  static const IconData strokeRoundedEiffelTower =
      IconData(0x3fb9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedElearningExchange' icon.
  static const IconData strokeRoundedElearningExchange =
      IconData(0x3fba, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedElectricHome01' icon.
  static const IconData strokeRoundedElectricHome01 =
      IconData(0x3fbb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedElectricHome02' icon.
  static const IconData strokeRoundedElectricHome02 =
      IconData(0x3fbc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedElectricPlugs' icon.
  static const IconData strokeRoundedElectricPlugs =
      IconData(0x3fbd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedElectricTower01' icon.
  static const IconData strokeRoundedElectricTower01 =
      IconData(0x3fbe, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedElectricTower02' icon.
  static const IconData strokeRoundedElectricTower02 =
      IconData(0x3fbf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedElectricWire' icon.
  static const IconData strokeRoundedElectricWire =
      IconData(0x3fc0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEllipseSelection' icon.
  static const IconData strokeRoundedEllipseSelection =
      IconData(0x3fc1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEncrypt' icon.
  static const IconData strokeRoundedEncrypt =
      IconData(0x3fc2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEnergyEllipse' icon.
  static const IconData strokeRoundedEnergyEllipse =
      IconData(0x3fc3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEnergyRectangle' icon.
  static const IconData strokeRoundedEnergyRectangle =
      IconData(0x3fc4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEnergy' icon.
  static const IconData strokeRoundedEnergy =
      IconData(0x3fc5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEnteringGeoFence' icon.
  static const IconData strokeRoundedEnteringGeoFence =
      IconData(0x3fc6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEnvato' icon.
  static const IconData strokeRoundedEnvato =
      IconData(0x3fc7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEqualSignCircle' icon.
  static const IconData strokeRoundedEqualSignCircle =
      IconData(0x3fc8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEqualSignSquare' icon.
  static const IconData strokeRoundedEqualSignSquare =
      IconData(0x3fc9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEqualSign' icon.
  static const IconData strokeRoundedEqualSign =
      IconData(0x3fca, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEquipmentBenchPress' icon.
  static const IconData strokeRoundedEquipmentBenchPress =
      IconData(0x3fcb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEquipmentChestPress' icon.
  static const IconData strokeRoundedEquipmentChestPress =
      IconData(0x3fcc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEquipmentGym01' icon.
  static const IconData strokeRoundedEquipmentGym01 =
      IconData(0x3fcd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEquipmentGym02' icon.
  static const IconData strokeRoundedEquipmentGym02 =
      IconData(0x3fce, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEquipmentGym03' icon.
  static const IconData strokeRoundedEquipmentGym03 =
      IconData(0x3fcf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEquipmentWeightlifting' icon.
  static const IconData strokeRoundedEquipmentWeightlifting =
      IconData(0x3fd0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEraser01' icon.
  static const IconData strokeRoundedEraser01 =
      IconData(0x3fd1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEraserAdd' icon.
  static const IconData strokeRoundedEraserAdd =
      IconData(0x3fd2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEraserAuto' icon.
  static const IconData strokeRoundedEraserAuto =
      IconData(0x3fd3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEraser' icon.
  static const IconData strokeRoundedEraser =
      IconData(0x3fd4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEstimate01' icon.
  static const IconData strokeRoundedEstimate01 =
      IconData(0x3fd5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEstimate02' icon.
  static const IconData strokeRoundedEstimate02 =
      IconData(0x3fd6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEthereumEllipse' icon.
  static const IconData strokeRoundedEthereumEllipse =
      IconData(0x3fd7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEthereumRectangle' icon.
  static const IconData strokeRoundedEthereumRectangle =
      IconData(0x3fd8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEthereum' icon.
  static const IconData strokeRoundedEthereum =
      IconData(0x3fd9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEuroCircle' icon.
  static const IconData strokeRoundedEuroCircle =
      IconData(0x3fda, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEuroReceive' icon.
  static const IconData strokeRoundedEuroReceive =
      IconData(0x3fdb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEuroSend' icon.
  static const IconData strokeRoundedEuroSend =
      IconData(0x3fdc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEuroSquare' icon.
  static const IconData strokeRoundedEuroSquare =
      IconData(0x3fdd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEuro' icon.
  static const IconData strokeRoundedEuro =
      IconData(0x3fde, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEvCharging' icon.
  static const IconData strokeRoundedEvCharging =
      IconData(0x3fdf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEvil' icon.
  static const IconData strokeRoundedEvil =
      IconData(0x3fe0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedExchange01' icon.
  static const IconData strokeRoundedExchange01 =
      IconData(0x3fe1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedExchange02' icon.
  static const IconData strokeRoundedExchange02 =
      IconData(0x3fe2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedExchange03' icon.
  static const IconData strokeRoundedExchange03 =
      IconData(0x3fe3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedExpander' icon.
  static const IconData strokeRoundedExpander =
      IconData(0x3fe4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedExternalDrive' icon.
  static const IconData strokeRoundedExternalDrive =
      IconData(0x3fe5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedEye' icon.
  static const IconData strokeRoundedEye =
      IconData(0x3fe6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFaceId' icon.
  static const IconData strokeRoundedFaceId =
      IconData(0x3fe7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFacebook01' icon.
  static const IconData strokeRoundedFacebook01 =
      IconData(0x3fe8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFacebook02' icon.
  static const IconData strokeRoundedFacebook02 =
      IconData(0x3fe9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFactory01' icon.
  static const IconData strokeRoundedFactory01 =
      IconData(0x3fea, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFactory02' icon.
  static const IconData strokeRoundedFactory02 =
      IconData(0x3feb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFactory' icon.
  static const IconData strokeRoundedFactory =
      IconData(0x3fec, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFahrenheit' icon.
  static const IconData strokeRoundedFahrenheit =
      IconData(0x3fed, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFallingStar' icon.
  static const IconData strokeRoundedFallingStar =
      IconData(0x3fee, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFastWind' icon.
  static const IconData strokeRoundedFastWind =
      IconData(0x3fef, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFavouriteCircle' icon.
  static const IconData strokeRoundedFavouriteCircle =
      IconData(0x3ff0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFavouriteSquare' icon.
  static const IconData strokeRoundedFavouriteSquare =
      IconData(0x3ff1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFavourite' icon.
  static const IconData strokeRoundedFavourite =
      IconData(0x3ff2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFeather' icon.
  static const IconData strokeRoundedFeather =
      IconData(0x3ff3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFencingMask' icon.
  static const IconData strokeRoundedFencingMask =
      IconData(0x3ff4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFencing' icon.
  static const IconData strokeRoundedFencing =
      IconData(0x3ff5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFerrisWheel' icon.
  static const IconData strokeRoundedFerrisWheel =
      IconData(0x3ff6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFerryBoat' icon.
  static const IconData strokeRoundedFerryBoat =
      IconData(0x3ff7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFigma' icon.
  static const IconData strokeRoundedFigma =
      IconData(0x3ff8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFile01' icon.
  static const IconData strokeRoundedFile01 =
      IconData(0x3ff9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFile02' icon.
  static const IconData strokeRoundedFile02 =
      IconData(0x3ffa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileAdd' icon.
  static const IconData strokeRoundedFileAdd =
      IconData(0x3ffb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileAttachment' icon.
  static const IconData strokeRoundedFileAttachment =
      IconData(0x3ffc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileAudio' icon.
  static const IconData strokeRoundedFileAudio =
      IconData(0x3ffd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileBitcoin' icon.
  static const IconData strokeRoundedFileBitcoin =
      IconData(0x3ffe, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileBlock' icon.
  static const IconData strokeRoundedFileBlock =
      IconData(0x3fff, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileBookmark' icon.
  static const IconData strokeRoundedFileBookmark =
      IconData(0x4000, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileCloud' icon.
  static const IconData strokeRoundedFileCloud =
      IconData(0x4001, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileCorrupt' icon.
  static const IconData strokeRoundedFileCorrupt =
      IconData(0x4002, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileDollar' icon.
  static const IconData strokeRoundedFileDollar =
      IconData(0x4003, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileDownload' icon.
  static const IconData strokeRoundedFileDownload =
      IconData(0x4004, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileEdit' icon.
  static const IconData strokeRoundedFileEdit =
      IconData(0x4005, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileEuro' icon.
  static const IconData strokeRoundedFileEuro =
      IconData(0x4006, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileExport' icon.
  static const IconData strokeRoundedFileExport =
      IconData(0x4007, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileFavourite' icon.
  static const IconData strokeRoundedFileFavourite =
      IconData(0x4008, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileImport' icon.
  static const IconData strokeRoundedFileImport =
      IconData(0x4009, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileLink' icon.
  static const IconData strokeRoundedFileLink =
      IconData(0x400a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileLocked' icon.
  static const IconData strokeRoundedFileLocked =
      IconData(0x400b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileManagement' icon.
  static const IconData strokeRoundedFileManagement =
      IconData(0x400c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileMinus' icon.
  static const IconData strokeRoundedFileMinus =
      IconData(0x400d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileMusic' icon.
  static const IconData strokeRoundedFileMusic =
      IconData(0x400e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileNotFound' icon.
  static const IconData strokeRoundedFileNotFound =
      IconData(0x400f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFilePaste' icon.
  static const IconData strokeRoundedFilePaste =
      IconData(0x4010, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFilePin' icon.
  static const IconData strokeRoundedFilePin =
      IconData(0x4011, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFilePound' icon.
  static const IconData strokeRoundedFilePound =
      IconData(0x4012, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileRemove' icon.
  static const IconData strokeRoundedFileRemove =
      IconData(0x4013, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileScript' icon.
  static const IconData strokeRoundedFileScript =
      IconData(0x4014, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileSearch' icon.
  static const IconData strokeRoundedFileSearch =
      IconData(0x4015, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileSecurity' icon.
  static const IconData strokeRoundedFileSecurity =
      IconData(0x4016, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileShredder' icon.
  static const IconData strokeRoundedFileShredder =
      IconData(0x4017, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileStar' icon.
  static const IconData strokeRoundedFileStar =
      IconData(0x4018, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileSync' icon.
  static const IconData strokeRoundedFileSync =
      IconData(0x4019, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileUnknown' icon.
  static const IconData strokeRoundedFileUnknown =
      IconData(0x401a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileUnlocked' icon.
  static const IconData strokeRoundedFileUnlocked =
      IconData(0x401b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileUpload' icon.
  static const IconData strokeRoundedFileUpload =
      IconData(0x401c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileValidation' icon.
  static const IconData strokeRoundedFileValidation =
      IconData(0x401d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileVerified' icon.
  static const IconData strokeRoundedFileVerified =
      IconData(0x401e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileVideo' icon.
  static const IconData strokeRoundedFileVideo =
      IconData(0x401f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileView' icon.
  static const IconData strokeRoundedFileView =
      IconData(0x4020, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileYen' icon.
  static const IconData strokeRoundedFileYen =
      IconData(0x4021, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFileZip' icon.
  static const IconData strokeRoundedFileZip =
      IconData(0x4022, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFiles01' icon.
  static const IconData strokeRoundedFiles01 =
      IconData(0x4023, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFiles02' icon.
  static const IconData strokeRoundedFiles02 =
      IconData(0x4024, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFilm01' icon.
  static const IconData strokeRoundedFilm01 =
      IconData(0x4025, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFilm02' icon.
  static const IconData strokeRoundedFilm02 =
      IconData(0x4026, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFilmRoll01' icon.
  static const IconData strokeRoundedFilmRoll01 =
      IconData(0x4027, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFilmRoll02' icon.
  static const IconData strokeRoundedFilmRoll02 =
      IconData(0x4028, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFilterAdd' icon.
  static const IconData strokeRoundedFilterAdd =
      IconData(0x4029, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFilterEdit' icon.
  static const IconData strokeRoundedFilterEdit =
      IconData(0x402a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFilterHorizontal' icon.
  static const IconData strokeRoundedFilterHorizontal =
      IconData(0x402b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFilterMailCircle' icon.
  static const IconData strokeRoundedFilterMailCircle =
      IconData(0x402c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFilterMailSquare' icon.
  static const IconData strokeRoundedFilterMailSquare =
      IconData(0x402d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFilterRemove' icon.
  static const IconData strokeRoundedFilterRemove =
      IconData(0x402e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFilterReset' icon.
  static const IconData strokeRoundedFilterReset =
      IconData(0x402f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFilterVertical' icon.
  static const IconData strokeRoundedFilterVertical =
      IconData(0x4030, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFilter' icon.
  static const IconData strokeRoundedFilter =
      IconData(0x4031, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFingerAccess' icon.
  static const IconData strokeRoundedFingerAccess =
      IconData(0x4032, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFingerPrintAdd' icon.
  static const IconData strokeRoundedFingerPrintAdd =
      IconData(0x4033, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFingerPrintCheck' icon.
  static const IconData strokeRoundedFingerPrintCheck =
      IconData(0x4034, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFingerPrintMinus' icon.
  static const IconData strokeRoundedFingerPrintMinus =
      IconData(0x4035, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFingerPrintRemove' icon.
  static const IconData strokeRoundedFingerPrintRemove =
      IconData(0x4036, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFingerPrintScan' icon.
  static const IconData strokeRoundedFingerPrintScan =
      IconData(0x4037, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFingerPrint' icon.
  static const IconData strokeRoundedFingerPrint =
      IconData(0x4038, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFingerprintScan' icon.
  static const IconData strokeRoundedFingerprintScan =
      IconData(0x4039, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFins' icon.
  static const IconData strokeRoundedFins =
      IconData(0x403a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFirePit' icon.
  static const IconData strokeRoundedFirePit =
      IconData(0x403b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFireSecurity' icon.
  static const IconData strokeRoundedFireSecurity =
      IconData(0x403c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFire' icon.
  static const IconData strokeRoundedFire =
      IconData(0x403d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFirewall' icon.
  static const IconData strokeRoundedFirewall =
      IconData(0x403e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFirstAidKit' icon.
  static const IconData strokeRoundedFirstAidKit =
      IconData(0x403f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFirstBracketCircle' icon.
  static const IconData strokeRoundedFirstBracketCircle =
      IconData(0x4040, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFirstBracketSquare' icon.
  static const IconData strokeRoundedFirstBracketSquare =
      IconData(0x4041, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFirstBracket' icon.
  static const IconData strokeRoundedFirstBracket =
      IconData(0x4042, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFishFood' icon.
  static const IconData strokeRoundedFishFood =
      IconData(0x4043, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFiverr' icon.
  static const IconData strokeRoundedFiverr =
      IconData(0x4044, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFlag01' icon.
  static const IconData strokeRoundedFlag01 =
      IconData(0x4045, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFlag02' icon.
  static const IconData strokeRoundedFlag02 =
      IconData(0x4046, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFlag03' icon.
  static const IconData strokeRoundedFlag03 =
      IconData(0x4047, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFlashOff' icon.
  static const IconData strokeRoundedFlashOff =
      IconData(0x4048, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFlash' icon.
  static const IconData strokeRoundedFlash =
      IconData(0x4049, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFlaticon' icon.
  static const IconData strokeRoundedFlaticon =
      IconData(0x404a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFlickr' icon.
  static const IconData strokeRoundedFlickr =
      IconData(0x404b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFlimSlate' icon.
  static const IconData strokeRoundedFlimSlate =
      IconData(0x404c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFlipBottom' icon.
  static const IconData strokeRoundedFlipBottom =
      IconData(0x404d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFlipHorizontal' icon.
  static const IconData strokeRoundedFlipHorizontal =
      IconData(0x404e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFlipLeft' icon.
  static const IconData strokeRoundedFlipLeft =
      IconData(0x404f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFlipPhone' icon.
  static const IconData strokeRoundedFlipPhone =
      IconData(0x4050, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFlipRight' icon.
  static const IconData strokeRoundedFlipRight =
      IconData(0x4051, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFlipTop' icon.
  static const IconData strokeRoundedFlipTop =
      IconData(0x4052, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFlipVertical' icon.
  static const IconData strokeRoundedFlipVertical =
      IconData(0x4053, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFloorPlan' icon.
  static const IconData strokeRoundedFloorPlan =
      IconData(0x4054, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFloppyDisk' icon.
  static const IconData strokeRoundedFloppyDisk =
      IconData(0x4055, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFlowCircle' icon.
  static const IconData strokeRoundedFlowCircle =
      IconData(0x4056, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFlowConnection' icon.
  static const IconData strokeRoundedFlowConnection =
      IconData(0x4057, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFlowSquare' icon.
  static const IconData strokeRoundedFlowSquare =
      IconData(0x4058, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFlow' icon.
  static const IconData strokeRoundedFlow =
      IconData(0x4059, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFlowchart01' icon.
  static const IconData strokeRoundedFlowchart01 =
      IconData(0x405a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFlowchart02' icon.
  static const IconData strokeRoundedFlowchart02 =
      IconData(0x405b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFlowerPot' icon.
  static const IconData strokeRoundedFlowerPot =
      IconData(0x405c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFlower' icon.
  static const IconData strokeRoundedFlower =
      IconData(0x405d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFlushed' icon.
  static const IconData strokeRoundedFlushed =
      IconData(0x405e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFlyingHuman' icon.
  static const IconData strokeRoundedFlyingHuman =
      IconData(0x405f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFocusPoint' icon.
  static const IconData strokeRoundedFocusPoint =
      IconData(0x4060, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolder01' icon.
  static const IconData strokeRoundedFolder01 =
      IconData(0x4061, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolder02' icon.
  static const IconData strokeRoundedFolder02 =
      IconData(0x4062, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolder03' icon.
  static const IconData strokeRoundedFolder03 =
      IconData(0x4063, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderAdd' icon.
  static const IconData strokeRoundedFolderAdd =
      IconData(0x4064, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderAttachment' icon.
  static const IconData strokeRoundedFolderAttachment =
      IconData(0x4065, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderAudio' icon.
  static const IconData strokeRoundedFolderAudio =
      IconData(0x4066, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderBlock' icon.
  static const IconData strokeRoundedFolderBlock =
      IconData(0x4067, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderCheck' icon.
  static const IconData strokeRoundedFolderCheck =
      IconData(0x4068, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderCloud' icon.
  static const IconData strokeRoundedFolderCloud =
      IconData(0x4069, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderDetailsReference' icon.
  static const IconData strokeRoundedFolderDetailsReference =
      IconData(0x406a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderDetails' icon.
  static const IconData strokeRoundedFolderDetails =
      IconData(0x406b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderDownload' icon.
  static const IconData strokeRoundedFolderDownload =
      IconData(0x406c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderEdit' icon.
  static const IconData strokeRoundedFolderEdit =
      IconData(0x406d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderExport' icon.
  static const IconData strokeRoundedFolderExport =
      IconData(0x406e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderFavourite' icon.
  static const IconData strokeRoundedFolderFavourite =
      IconData(0x406f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderFileStorage' icon.
  static const IconData strokeRoundedFolderFileStorage =
      IconData(0x4070, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderImport' icon.
  static const IconData strokeRoundedFolderImport =
      IconData(0x4071, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderLibrary' icon.
  static const IconData strokeRoundedFolderLibrary =
      IconData(0x4072, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderLinks' icon.
  static const IconData strokeRoundedFolderLinks =
      IconData(0x4073, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderLocked' icon.
  static const IconData strokeRoundedFolderLocked =
      IconData(0x4074, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderManagement' icon.
  static const IconData strokeRoundedFolderManagement =
      IconData(0x4075, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderMinus' icon.
  static const IconData strokeRoundedFolderMinus =
      IconData(0x4076, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderMusic' icon.
  static const IconData strokeRoundedFolderMusic =
      IconData(0x4077, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderOff' icon.
  static const IconData strokeRoundedFolderOff =
      IconData(0x4078, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderOpen' icon.
  static const IconData strokeRoundedFolderOpen =
      IconData(0x4079, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderPin' icon.
  static const IconData strokeRoundedFolderPin =
      IconData(0x407a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderRemove' icon.
  static const IconData strokeRoundedFolderRemove =
      IconData(0x407b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderSearch' icon.
  static const IconData strokeRoundedFolderSearch =
      IconData(0x407c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderSecurity' icon.
  static const IconData strokeRoundedFolderSecurity =
      IconData(0x407d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderShared01' icon.
  static const IconData strokeRoundedFolderShared01 =
      IconData(0x407e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderShared02' icon.
  static const IconData strokeRoundedFolderShared02 =
      IconData(0x407f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderShared03' icon.
  static const IconData strokeRoundedFolderShared03 =
      IconData(0x4080, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderSync' icon.
  static const IconData strokeRoundedFolderSync =
      IconData(0x4081, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderTransfer' icon.
  static const IconData strokeRoundedFolderTransfer =
      IconData(0x4082, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderUnknown' icon.
  static const IconData strokeRoundedFolderUnknown =
      IconData(0x4083, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderUnlocked' icon.
  static const IconData strokeRoundedFolderUnlocked =
      IconData(0x4084, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderUpload' icon.
  static const IconData strokeRoundedFolderUpload =
      IconData(0x4085, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderVideo' icon.
  static const IconData strokeRoundedFolderVideo =
      IconData(0x4086, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderView' icon.
  static const IconData strokeRoundedFolderView =
      IconData(0x4087, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolderZip' icon.
  static const IconData strokeRoundedFolderZip =
      IconData(0x4088, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFolders' icon.
  static const IconData strokeRoundedFolders =
      IconData(0x4089, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFootballPitch' icon.
  static const IconData strokeRoundedFootballPitch =
      IconData(0x408a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFootball' icon.
  static const IconData strokeRoundedFootball =
      IconData(0x408b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedForgotPassword' icon.
  static const IconData strokeRoundedForgotPassword =
      IconData(0x408c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFork' icon.
  static const IconData strokeRoundedFork =
      IconData(0x408d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedForrst' icon.
  static const IconData strokeRoundedForrst =
      IconData(0x408e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFortress' icon.
  static const IconData strokeRoundedFortress =
      IconData(0x408f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedForward01' icon.
  static const IconData strokeRoundedForward01 =
      IconData(0x4090, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedForward02' icon.
  static const IconData strokeRoundedForward02 =
      IconData(0x4091, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFourFinger02' icon.
  static const IconData strokeRoundedFourFinger02 =
      IconData(0x4092, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFourFinger03' icon.
  static const IconData strokeRoundedFourFinger03 =
      IconData(0x4093, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFourK' icon.
  static const IconData strokeRoundedFourK =
      IconData(0x4094, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFoursquare' icon.
  static const IconData strokeRoundedFoursquare =
      IconData(0x4095, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFramer' icon.
  static const IconData strokeRoundedFramer =
      IconData(0x4096, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFrameworks' icon.
  static const IconData strokeRoundedFrameworks =
      IconData(0x4097, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFrenchFries01' icon.
  static const IconData strokeRoundedFrenchFries01 =
      IconData(0x4098, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFrenchFries02' icon.
  static const IconData strokeRoundedFrenchFries02 =
      IconData(0x4099, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFridge' icon.
  static const IconData strokeRoundedFridge =
      IconData(0x409a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFry' icon.
  static const IconData strokeRoundedFry =
      IconData(0x409b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFuel01' icon.
  static const IconData strokeRoundedFuel01 =
      IconData(0x409c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFuel02' icon.
  static const IconData strokeRoundedFuel02 =
      IconData(0x409d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFuelStation' icon.
  static const IconData strokeRoundedFuelStation =
      IconData(0x409e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFunctionCircle' icon.
  static const IconData strokeRoundedFunctionCircle =
      IconData(0x409f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFunctionOfX' icon.
  static const IconData strokeRoundedFunctionOfX =
      IconData(0x40a0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFunctionSquare' icon.
  static const IconData strokeRoundedFunctionSquare =
      IconData(0x40a1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedFunction' icon.
  static const IconData strokeRoundedFunction =
      IconData(0x40a2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGalaxy' icon.
  static const IconData strokeRoundedGalaxy =
      IconData(0x40a3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGameController01' icon.
  static const IconData strokeRoundedGameController01 =
      IconData(0x40a4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGameController02' icon.
  static const IconData strokeRoundedGameController02 =
      IconData(0x40a5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGameController03' icon.
  static const IconData strokeRoundedGameController03 =
      IconData(0x40a6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGame' icon.
  static const IconData strokeRoundedGame =
      IconData(0x40a7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGameboy' icon.
  static const IconData strokeRoundedGameboy =
      IconData(0x40a8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGarage' icon.
  static const IconData strokeRoundedGarage =
      IconData(0x40a9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGarbageTruck' icon.
  static const IconData strokeRoundedGarbageTruck =
      IconData(0x40aa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGasPipe' icon.
  static const IconData strokeRoundedGasPipe =
      IconData(0x40ab, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGasStove' icon.
  static const IconData strokeRoundedGasStove =
      IconData(0x40ac, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGem' icon.
  static const IconData strokeRoundedGem =
      IconData(0x40ad, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGeologyCrust' icon.
  static const IconData strokeRoundedGeologyCrust =
      IconData(0x40ae, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGeometricShapes01' icon.
  static const IconData strokeRoundedGeometricShapes01 =
      IconData(0x40af, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGeometricShapes02' icon.
  static const IconData strokeRoundedGeometricShapes02 =
      IconData(0x40b0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGibbousMoon' icon.
  static const IconData strokeRoundedGibbousMoon =
      IconData(0x40b1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGif01' icon.
  static const IconData strokeRoundedGif01 =
      IconData(0x40b2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGif02' icon.
  static const IconData strokeRoundedGif02 =
      IconData(0x40b3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGiftCard' icon.
  static const IconData strokeRoundedGiftCard =
      IconData(0x40b4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGift' icon.
  static const IconData strokeRoundedGift =
      IconData(0x40b5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGitBranch' icon.
  static const IconData strokeRoundedGitBranch =
      IconData(0x40b6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGitCommit' icon.
  static const IconData strokeRoundedGitCommit =
      IconData(0x40b7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGitCompare' icon.
  static const IconData strokeRoundedGitCompare =
      IconData(0x40b8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGitFork' icon.
  static const IconData strokeRoundedGitFork =
      IconData(0x40b9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGitMerge' icon.
  static const IconData strokeRoundedGitMerge =
      IconData(0x40ba, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGitPullRequestClosed' icon.
  static const IconData strokeRoundedGitPullRequestClosed =
      IconData(0x40bb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGitPullRequestDraft' icon.
  static const IconData strokeRoundedGitPullRequestDraft =
      IconData(0x40bc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGitPullRequest' icon.
  static const IconData strokeRoundedGitPullRequest =
      IconData(0x40bd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGitbook' icon.
  static const IconData strokeRoundedGitbook =
      IconData(0x40be, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGithub01' icon.
  static const IconData strokeRoundedGithub01 =
      IconData(0x40bf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGithub' icon.
  static const IconData strokeRoundedGithub =
      IconData(0x40c0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGitlab' icon.
  static const IconData strokeRoundedGitlab =
      IconData(0x40c1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGiveBlood' icon.
  static const IconData strokeRoundedGiveBlood =
      IconData(0x40c2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGivePill' icon.
  static const IconData strokeRoundedGivePill =
      IconData(0x40c3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGlasses' icon.
  static const IconData strokeRoundedGlasses =
      IconData(0x40c4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGlobalEditing' icon.
  static const IconData strokeRoundedGlobalEditing =
      IconData(0x40c5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGlobalEducation' icon.
  static const IconData strokeRoundedGlobalEducation =
      IconData(0x40c6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGlobalRefresh' icon.
  static const IconData strokeRoundedGlobalRefresh =
      IconData(0x40c7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGlobalSearch' icon.
  static const IconData strokeRoundedGlobalSearch =
      IconData(0x40c8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGlobal' icon.
  static const IconData strokeRoundedGlobal =
      IconData(0x40c9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGlobe02' icon.
  static const IconData strokeRoundedGlobe02 =
      IconData(0x40ca, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGlobe' icon.
  static const IconData strokeRoundedGlobe =
      IconData(0x40cb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGlove' icon.
  static const IconData strokeRoundedGlove =
      IconData(0x40cc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGoBackward10Sec' icon.
  static const IconData strokeRoundedGoBackward10Sec =
      IconData(0x40cd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGoBackward15Sec' icon.
  static const IconData strokeRoundedGoBackward15Sec =
      IconData(0x40ce, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGoBackward30Sec' icon.
  static const IconData strokeRoundedGoBackward30Sec =
      IconData(0x40cf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGoBackward5Sec' icon.
  static const IconData strokeRoundedGoBackward5Sec =
      IconData(0x40d0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGoBackward60Sec' icon.
  static const IconData strokeRoundedGoBackward60Sec =
      IconData(0x40d1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGoForward10Sec' icon.
  static const IconData strokeRoundedGoForward10Sec =
      IconData(0x40d2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGoForward15Sec' icon.
  static const IconData strokeRoundedGoForward15Sec =
      IconData(0x40d3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGoForward30Sec' icon.
  static const IconData strokeRoundedGoForward30Sec =
      IconData(0x40d4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGoForward5Sec' icon.
  static const IconData strokeRoundedGoForward5Sec =
      IconData(0x40d5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGoForward60Sec' icon.
  static const IconData strokeRoundedGoForward60Sec =
      IconData(0x40d6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGoldIngots' icon.
  static const IconData strokeRoundedGoldIngots =
      IconData(0x40d7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGold' icon.
  static const IconData strokeRoundedGold =
      IconData(0x40d8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGolfBall' icon.
  static const IconData strokeRoundedGolfBall =
      IconData(0x40d9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGolfBat' icon.
  static const IconData strokeRoundedGolfBat =
      IconData(0x40da, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGolfCart' icon.
  static const IconData strokeRoundedGolfCart =
      IconData(0x40db, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGolfHole' icon.
  static const IconData strokeRoundedGolfHole =
      IconData(0x40dc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGoogleDoc' icon.
  static const IconData strokeRoundedGoogleDoc =
      IconData(0x40dd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGoogleDrive' icon.
  static const IconData strokeRoundedGoogleDrive =
      IconData(0x40de, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGoogleGemini' icon.
  static const IconData strokeRoundedGoogleGemini =
      IconData(0x40df, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGoogleHome' icon.
  static const IconData strokeRoundedGoogleHome =
      IconData(0x40e0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGoogleLens' icon.
  static const IconData strokeRoundedGoogleLens =
      IconData(0x40e1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGoogleMaps' icon.
  static const IconData strokeRoundedGoogleMaps =
      IconData(0x40e2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGooglePhotos' icon.
  static const IconData strokeRoundedGooglePhotos =
      IconData(0x40e3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGoogleSheet' icon.
  static const IconData strokeRoundedGoogleSheet =
      IconData(0x40e4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGoogle' icon.
  static const IconData strokeRoundedGoogle =
      IconData(0x40e5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGps01' icon.
  static const IconData strokeRoundedGps01 =
      IconData(0x40e6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGps02' icon.
  static const IconData strokeRoundedGps02 =
      IconData(0x40e7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGpsDisconnected' icon.
  static const IconData strokeRoundedGpsDisconnected =
      IconData(0x40e8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGpsOff01' icon.
  static const IconData strokeRoundedGpsOff01 =
      IconData(0x40e9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGpsOff02' icon.
  static const IconData strokeRoundedGpsOff02 =
      IconData(0x40ea, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGpsSignal01' icon.
  static const IconData strokeRoundedGpsSignal01 =
      IconData(0x40eb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGpsSignal02' icon.
  static const IconData strokeRoundedGpsSignal02 =
      IconData(0x40ec, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGpu' icon.
  static const IconData strokeRoundedGpu =
      IconData(0x40ed, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGraduateFemale' icon.
  static const IconData strokeRoundedGraduateFemale =
      IconData(0x40ee, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGraduateMale' icon.
  static const IconData strokeRoundedGraduateMale =
      IconData(0x40ef, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGraduationScroll' icon.
  static const IconData strokeRoundedGraduationScroll =
      IconData(0x40f0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGrapes' icon.
  static const IconData strokeRoundedGrapes =
      IconData(0x40f1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGravity' icon.
  static const IconData strokeRoundedGravity =
      IconData(0x40f2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGreaterThanCircle' icon.
  static const IconData strokeRoundedGreaterThanCircle =
      IconData(0x40f3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGreaterThanSquare' icon.
  static const IconData strokeRoundedGreaterThanSquare =
      IconData(0x40f4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGreaterThan' icon.
  static const IconData strokeRoundedGreaterThan =
      IconData(0x40f5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGreekHelmet' icon.
  static const IconData strokeRoundedGreekHelmet =
      IconData(0x40f6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGreenHouse' icon.
  static const IconData strokeRoundedGreenHouse =
      IconData(0x40f7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGridOff' icon.
  static const IconData strokeRoundedGridOff =
      IconData(0x40f8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGridTable' icon.
  static const IconData strokeRoundedGridTable =
      IconData(0x40f9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGridView' icon.
  static const IconData strokeRoundedGridView =
      IconData(0x40fa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGrid' icon.
  static const IconData strokeRoundedGrid =
      IconData(0x40fb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGrimacing' icon.
  static const IconData strokeRoundedGrimacing =
      IconData(0x40fc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGrinning' icon.
  static const IconData strokeRoundedGrinning =
      IconData(0x40fd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGrok' icon.
  static const IconData strokeRoundedGrok =
      IconData(0x40fe, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGroupItems' icon.
  static const IconData strokeRoundedGroupItems =
      IconData(0x40ff, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGroupLayers' icon.
  static const IconData strokeRoundedGroupLayers =
      IconData(0x4100, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGuestHouse' icon.
  static const IconData strokeRoundedGuestHouse =
      IconData(0x4101, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGun' icon.
  static const IconData strokeRoundedGun =
      IconData(0x4102, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGymnasticRings' icon.
  static const IconData strokeRoundedGymnasticRings =
      IconData(0x4103, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedGymnastic' icon.
  static const IconData strokeRoundedGymnastic =
      IconData(0x4104, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHackerrank' icon.
  static const IconData strokeRoundedHackerrank =
      IconData(0x4105, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHairClips' icon.
  static const IconData strokeRoundedHairClips =
      IconData(0x4106, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHairDryer' icon.
  static const IconData strokeRoundedHairDryer =
      IconData(0x4107, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHaji' icon.
  static const IconData strokeRoundedHaji =
      IconData(0x4108, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHalal' icon.
  static const IconData strokeRoundedHalal =
      IconData(0x4109, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHamburger01' icon.
  static const IconData strokeRoundedHamburger01 =
      IconData(0x410a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHamburger02' icon.
  static const IconData strokeRoundedHamburger02 =
      IconData(0x410b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHandBag01' icon.
  static const IconData strokeRoundedHandBag01 =
      IconData(0x410c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHandBag02' icon.
  static const IconData strokeRoundedHandBag02 =
      IconData(0x410d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHandBeater' icon.
  static const IconData strokeRoundedHandBeater =
      IconData(0x410e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHandGrip' icon.
  static const IconData strokeRoundedHandGrip =
      IconData(0x410f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHandPointingDown01' icon.
  static const IconData strokeRoundedHandPointingDown01 =
      IconData(0x4110, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHandPointingDown02' icon.
  static const IconData strokeRoundedHandPointingDown02 =
      IconData(0x4111, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHandPointingDown03' icon.
  static const IconData strokeRoundedHandPointingDown03 =
      IconData(0x4112, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHandPointingDown04' icon.
  static const IconData strokeRoundedHandPointingDown04 =
      IconData(0x4113, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHandPointingLeft01' icon.
  static const IconData strokeRoundedHandPointingLeft01 =
      IconData(0x4114, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHandPointingLeft02' icon.
  static const IconData strokeRoundedHandPointingLeft02 =
      IconData(0x4115, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHandPointingLeft03' icon.
  static const IconData strokeRoundedHandPointingLeft03 =
      IconData(0x4116, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHandPointingLeft04' icon.
  static const IconData strokeRoundedHandPointingLeft04 =
      IconData(0x4117, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHandPointingRight01' icon.
  static const IconData strokeRoundedHandPointingRight01 =
      IconData(0x4118, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHandPointingRight02' icon.
  static const IconData strokeRoundedHandPointingRight02 =
      IconData(0x4119, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHandPointingRight03' icon.
  static const IconData strokeRoundedHandPointingRight03 =
      IconData(0x411a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHandPointingRight04' icon.
  static const IconData strokeRoundedHandPointingRight04 =
      IconData(0x411b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHandPrayer' icon.
  static const IconData strokeRoundedHandPrayer =
      IconData(0x411c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHandSanitizer' icon.
  static const IconData strokeRoundedHandSanitizer =
      IconData(0x411d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHandcuffs' icon.
  static const IconData strokeRoundedHandcuffs =
      IconData(0x411e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHanger' icon.
  static const IconData strokeRoundedHanger =
      IconData(0x411f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHangingClock' icon.
  static const IconData strokeRoundedHangingClock =
      IconData(0x4120, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHangout' icon.
  static const IconData strokeRoundedHangout =
      IconData(0x4121, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHappy' icon.
  static const IconData strokeRoundedHappy =
      IconData(0x4122, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHardDrive' icon.
  static const IconData strokeRoundedHardDrive =
      IconData(0x4123, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHdd' icon.
  static const IconData strokeRoundedHdd =
      IconData(0x4124, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHdr01' icon.
  static const IconData strokeRoundedHdr01 =
      IconData(0x4125, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHdr02' icon.
  static const IconData strokeRoundedHdr02 =
      IconData(0x4126, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHeading01' icon.
  static const IconData strokeRoundedHeading01 =
      IconData(0x4127, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHeading02' icon.
  static const IconData strokeRoundedHeading02 =
      IconData(0x4128, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHeading03' icon.
  static const IconData strokeRoundedHeading03 =
      IconData(0x4129, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHeading04' icon.
  static const IconData strokeRoundedHeading04 =
      IconData(0x412a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHeading05' icon.
  static const IconData strokeRoundedHeading05 =
      IconData(0x412b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHeading06' icon.
  static const IconData strokeRoundedHeading06 =
      IconData(0x412c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHeading' icon.
  static const IconData strokeRoundedHeading =
      IconData(0x412d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHeadphoneMute' icon.
  static const IconData strokeRoundedHeadphoneMute =
      IconData(0x412e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHeadphones' icon.
  static const IconData strokeRoundedHeadphones =
      IconData(0x412f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHeadsetConnected' icon.
  static const IconData strokeRoundedHeadsetConnected =
      IconData(0x4130, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHeadsetOff' icon.
  static const IconData strokeRoundedHeadsetOff =
      IconData(0x4131, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHeadset' icon.
  static const IconData strokeRoundedHeadset =
      IconData(0x4132, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHealtcare' icon.
  static const IconData strokeRoundedHealtcare =
      IconData(0x4133, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHealth' icon.
  static const IconData strokeRoundedHealth =
      IconData(0x4134, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHeartAdd' icon.
  static const IconData strokeRoundedHeartAdd =
      IconData(0x4135, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHeartCheck' icon.
  static const IconData strokeRoundedHeartCheck =
      IconData(0x4136, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHeartRemove' icon.
  static const IconData strokeRoundedHeartRemove =
      IconData(0x4137, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHeartbreak' icon.
  static const IconData strokeRoundedHeartbreak =
      IconData(0x4138, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHelicopter' icon.
  static const IconData strokeRoundedHelicopter =
      IconData(0x4139, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHelpCircle' icon.
  static const IconData strokeRoundedHelpCircle =
      IconData(0x413a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHelpSquare' icon.
  static const IconData strokeRoundedHelpSquare =
      IconData(0x413b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHexagon01' icon.
  static const IconData strokeRoundedHexagon01 =
      IconData(0x413c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHexagon' icon.
  static const IconData strokeRoundedHexagon =
      IconData(0x413d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHierarchyCircle01' icon.
  static const IconData strokeRoundedHierarchyCircle01 =
      IconData(0x413e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHierarchyCircle02' icon.
  static const IconData strokeRoundedHierarchyCircle02 =
      IconData(0x413f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHierarchyCircle03' icon.
  static const IconData strokeRoundedHierarchyCircle03 =
      IconData(0x4140, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHierarchyFiles' icon.
  static const IconData strokeRoundedHierarchyFiles =
      IconData(0x4141, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHierarchySquare01' icon.
  static const IconData strokeRoundedHierarchySquare01 =
      IconData(0x4142, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHierarchySquare02' icon.
  static const IconData strokeRoundedHierarchySquare02 =
      IconData(0x4143, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHierarchySquare03' icon.
  static const IconData strokeRoundedHierarchySquare03 =
      IconData(0x4144, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHierarchySquare04' icon.
  static const IconData strokeRoundedHierarchySquare04 =
      IconData(0x4145, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHierarchySquare05' icon.
  static const IconData strokeRoundedHierarchySquare05 =
      IconData(0x4146, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHierarchySquare06' icon.
  static const IconData strokeRoundedHierarchySquare06 =
      IconData(0x4147, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHierarchySquare07' icon.
  static const IconData strokeRoundedHierarchySquare07 =
      IconData(0x4148, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHierarchySquare08' icon.
  static const IconData strokeRoundedHierarchySquare08 =
      IconData(0x4149, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHierarchySquare10' icon.
  static const IconData strokeRoundedHierarchySquare10 =
      IconData(0x414a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHierarchy' icon.
  static const IconData strokeRoundedHierarchy =
      IconData(0x414b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHighHeels01' icon.
  static const IconData strokeRoundedHighHeels01 =
      IconData(0x414c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHighHeels02' icon.
  static const IconData strokeRoundedHighHeels02 =
      IconData(0x414d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHijab' icon.
  static const IconData strokeRoundedHijab =
      IconData(0x414e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHockey' icon.
  static const IconData strokeRoundedHockey =
      IconData(0x414f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHold01' icon.
  static const IconData strokeRoundedHold01 =
      IconData(0x4150, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHold02' icon.
  static const IconData strokeRoundedHold02 =
      IconData(0x4151, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHold03' icon.
  static const IconData strokeRoundedHold03 =
      IconData(0x4152, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHold04' icon.
  static const IconData strokeRoundedHold04 =
      IconData(0x4153, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHold05' icon.
  static const IconData strokeRoundedHold05 =
      IconData(0x4154, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHoldLocked01' icon.
  static const IconData strokeRoundedHoldLocked01 =
      IconData(0x4155, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHoldLocked02' icon.
  static const IconData strokeRoundedHoldLocked02 =
      IconData(0x4156, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHoldPhone' icon.
  static const IconData strokeRoundedHoldPhone =
      IconData(0x4157, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHologram' icon.
  static const IconData strokeRoundedHologram =
      IconData(0x4158, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHome01' icon.
  static const IconData strokeRoundedHome01 =
      IconData(0x4159, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHome02' icon.
  static const IconData strokeRoundedHome02 =
      IconData(0x415a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHome03' icon.
  static const IconData strokeRoundedHome03 =
      IconData(0x415b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHome04' icon.
  static const IconData strokeRoundedHome04 =
      IconData(0x415c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHome05' icon.
  static const IconData strokeRoundedHome05 =
      IconData(0x415d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHome06' icon.
  static const IconData strokeRoundedHome06 =
      IconData(0x415e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHome07' icon.
  static const IconData strokeRoundedHome07 =
      IconData(0x415f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHome08' icon.
  static const IconData strokeRoundedHome08 =
      IconData(0x4160, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHome09' icon.
  static const IconData strokeRoundedHome09 =
      IconData(0x4161, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHome10' icon.
  static const IconData strokeRoundedHome10 =
      IconData(0x4162, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHome11' icon.
  static const IconData strokeRoundedHome11 =
      IconData(0x4163, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHome12' icon.
  static const IconData strokeRoundedHome12 =
      IconData(0x4164, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHome13' icon.
  static const IconData strokeRoundedHome13 =
      IconData(0x4165, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHomeWifi' icon.
  static const IconData strokeRoundedHomeWifi =
      IconData(0x4166, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHoney01' icon.
  static const IconData strokeRoundedHoney01 =
      IconData(0x4167, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHoney02' icon.
  static const IconData strokeRoundedHoney02 =
      IconData(0x4168, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHonor' icon.
  static const IconData strokeRoundedHonor =
      IconData(0x4169, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHonourStar' icon.
  static const IconData strokeRoundedHonourStar =
      IconData(0x416a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHoodie' icon.
  static const IconData strokeRoundedHoodie =
      IconData(0x416b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHorizonalScrollPoint' icon.
  static const IconData strokeRoundedHorizonalScrollPoint =
      IconData(0x416c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHorizontalResize' icon.
  static const IconData strokeRoundedHorizontalResize =
      IconData(0x416d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHospital01' icon.
  static const IconData strokeRoundedHospital01 =
      IconData(0x416e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHospital02' icon.
  static const IconData strokeRoundedHospital02 =
      IconData(0x416f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHospitalBed01' icon.
  static const IconData strokeRoundedHospitalBed01 =
      IconData(0x4170, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHospitalBed02' icon.
  static const IconData strokeRoundedHospitalBed02 =
      IconData(0x4171, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHospitalLocation' icon.
  static const IconData strokeRoundedHospitalLocation =
      IconData(0x4172, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHotAirBalloon' icon.
  static const IconData strokeRoundedHotAirBalloon =
      IconData(0x4173, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHotPrice' icon.
  static const IconData strokeRoundedHotPrice =
      IconData(0x4174, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHotTube' icon.
  static const IconData strokeRoundedHotTube =
      IconData(0x4175, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHotdog' icon.
  static const IconData strokeRoundedHotdog =
      IconData(0x4176, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHotel01' icon.
  static const IconData strokeRoundedHotel01 =
      IconData(0x4177, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHotel02' icon.
  static const IconData strokeRoundedHotel02 =
      IconData(0x4178, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHotspotOffline' icon.
  static const IconData strokeRoundedHotspotOffline =
      IconData(0x4179, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHotspot' icon.
  static const IconData strokeRoundedHotspot =
      IconData(0x417a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHourglassOff' icon.
  static const IconData strokeRoundedHourglassOff =
      IconData(0x417b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHourglass' icon.
  static const IconData strokeRoundedHourglass =
      IconData(0x417c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHouse01' icon.
  static const IconData strokeRoundedHouse01 =
      IconData(0x417d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHouse02' icon.
  static const IconData strokeRoundedHouse02 =
      IconData(0x417e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHouse03' icon.
  static const IconData strokeRoundedHouse03 =
      IconData(0x417f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHouse04' icon.
  static const IconData strokeRoundedHouse04 =
      IconData(0x4180, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHouse05' icon.
  static const IconData strokeRoundedHouse05 =
      IconData(0x4181, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHouseSolarPanel' icon.
  static const IconData strokeRoundedHouseSolarPanel =
      IconData(0x4182, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHtml5' icon.
  static const IconData strokeRoundedHtml5 =
      IconData(0x4183, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHumidity' icon.
  static const IconData strokeRoundedHumidity =
      IconData(0x4184, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHut' icon.
  static const IconData strokeRoundedHut =
      IconData(0x4185, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHydroPower' icon.
  static const IconData strokeRoundedHydroPower =
      IconData(0x4186, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedHyperbole' icon.
  static const IconData strokeRoundedHyperbole =
      IconData(0x4187, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedIceCream01' icon.
  static const IconData strokeRoundedIceCream01 =
      IconData(0x4188, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedIceCream02' icon.
  static const IconData strokeRoundedIceCream02 =
      IconData(0x4189, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedIceCream03' icon.
  static const IconData strokeRoundedIceCream03 =
      IconData(0x418a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedIceCream04' icon.
  static const IconData strokeRoundedIceCream04 =
      IconData(0x418b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedIceHockey' icon.
  static const IconData strokeRoundedIceHockey =
      IconData(0x418c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedIceSkating' icon.
  static const IconData strokeRoundedIceSkating =
      IconData(0x418d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedIco' icon.
  static const IconData strokeRoundedIco =
      IconData(0x418e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedIconjar' icon.
  static const IconData strokeRoundedIconjar =
      IconData(0x418f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedIdNotVerified' icon.
  static const IconData strokeRoundedIdNotVerified =
      IconData(0x4190, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedIdVerified' icon.
  static const IconData strokeRoundedIdVerified =
      IconData(0x4191, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedId' icon.
  static const IconData strokeRoundedId =
      IconData(0x4192, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedIdea01' icon.
  static const IconData strokeRoundedIdea01 =
      IconData(0x4193, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedIdea' icon.
  static const IconData strokeRoundedIdea =
      IconData(0x4194, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedIdentification' icon.
  static const IconData strokeRoundedIdentification =
      IconData(0x4195, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedIdentityCard' icon.
  static const IconData strokeRoundedIdentityCard =
      IconData(0x4196, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedImage01' icon.
  static const IconData strokeRoundedImage01 =
      IconData(0x4197, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedImage02' icon.
  static const IconData strokeRoundedImage02 =
      IconData(0x4198, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedImageAdd01' icon.
  static const IconData strokeRoundedImageAdd01 =
      IconData(0x4199, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedImageAdd02' icon.
  static const IconData strokeRoundedImageAdd02 =
      IconData(0x419a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedImageCompositionOval' icon.
  static const IconData strokeRoundedImageCompositionOval =
      IconData(0x419b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedImageComposition' icon.
  static const IconData strokeRoundedImageComposition =
      IconData(0x419c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedImageCrop' icon.
  static const IconData strokeRoundedImageCrop =
      IconData(0x419d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedImageDelete01' icon.
  static const IconData strokeRoundedImageDelete01 =
      IconData(0x419e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedImageDelete02' icon.
  static const IconData strokeRoundedImageDelete02 =
      IconData(0x419f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedImageDone01' icon.
  static const IconData strokeRoundedImageDone01 =
      IconData(0x41a0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedImageDone02' icon.
  static const IconData strokeRoundedImageDone02 =
      IconData(0x41a1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedImageDownload02' icon.
  static const IconData strokeRoundedImageDownload02 =
      IconData(0x41a2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedImageDownload' icon.
  static const IconData strokeRoundedImageDownload =
      IconData(0x41a3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedImageNotFound01' icon.
  static const IconData strokeRoundedImageNotFound01 =
      IconData(0x41a4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedImageNotFound02' icon.
  static const IconData strokeRoundedImageNotFound02 =
      IconData(0x41a5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedImageRemove01' icon.
  static const IconData strokeRoundedImageRemove01 =
      IconData(0x41a6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedImageRemove02' icon.
  static const IconData strokeRoundedImageRemove02 =
      IconData(0x41a7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedImageUpload01' icon.
  static const IconData strokeRoundedImageUpload01 =
      IconData(0x41a8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedImageUpload' icon.
  static const IconData strokeRoundedImageUpload =
      IconData(0x41a9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedImo' icon.
  static const IconData strokeRoundedImo =
      IconData(0x41aa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedImportantBook' icon.
  static const IconData strokeRoundedImportantBook =
      IconData(0x41ab, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInLove' icon.
  static const IconData strokeRoundedInLove =
      IconData(0x41ac, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInboxCheck' icon.
  static const IconData strokeRoundedInboxCheck =
      IconData(0x41ad, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInboxDownload' icon.
  static const IconData strokeRoundedInboxDownload =
      IconData(0x41ae, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInboxUnread' icon.
  static const IconData strokeRoundedInboxUnread =
      IconData(0x41af, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInboxUpload' icon.
  static const IconData strokeRoundedInboxUpload =
      IconData(0x41b0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInbox' icon.
  static const IconData strokeRoundedInbox =
      IconData(0x41b1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedIncognito' icon.
  static const IconData strokeRoundedIncognito =
      IconData(0x41b2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedIndiaGate' icon.
  static const IconData strokeRoundedIndiaGate =
      IconData(0x41b3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInequality01' icon.
  static const IconData strokeRoundedInequality01 =
      IconData(0x41b4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInequality02' icon.
  static const IconData strokeRoundedInequality02 =
      IconData(0x41b5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInequalityCircle01' icon.
  static const IconData strokeRoundedInequalityCircle01 =
      IconData(0x41b6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInequalityCircle02' icon.
  static const IconData strokeRoundedInequalityCircle02 =
      IconData(0x41b7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInequalitySquare01' icon.
  static const IconData strokeRoundedInequalitySquare01 =
      IconData(0x41b8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInequalitySquare02' icon.
  static const IconData strokeRoundedInequalitySquare02 =
      IconData(0x41b9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInfinity01' icon.
  static const IconData strokeRoundedInfinity01 =
      IconData(0x41ba, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInfinity02' icon.
  static const IconData strokeRoundedInfinity02 =
      IconData(0x41bb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInfinityCircle' icon.
  static const IconData strokeRoundedInfinityCircle =
      IconData(0x41bc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInfinitySquare' icon.
  static const IconData strokeRoundedInfinitySquare =
      IconData(0x41bd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInformationCircle' icon.
  static const IconData strokeRoundedInformationCircle =
      IconData(0x41be, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInformationDiamond' icon.
  static const IconData strokeRoundedInformationDiamond =
      IconData(0x41bf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInformationSquare' icon.
  static const IconData strokeRoundedInformationSquare =
      IconData(0x41c0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInjection' icon.
  static const IconData strokeRoundedInjection =
      IconData(0x41c1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInsertBottomImage' icon.
  static const IconData strokeRoundedInsertBottomImage =
      IconData(0x41c2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInsertCenterImage' icon.
  static const IconData strokeRoundedInsertCenterImage =
      IconData(0x41c3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInsertColumnLeft' icon.
  static const IconData strokeRoundedInsertColumnLeft =
      IconData(0x41c4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInsertColumn' icon.
  static const IconData strokeRoundedInsertColumn =
      IconData(0x41c5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInsertPi' icon.
  static const IconData strokeRoundedInsertPi =
      IconData(0x41c6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInsertRowDown' icon.
  static const IconData strokeRoundedInsertRowDown =
      IconData(0x41c7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInsertRowUp' icon.
  static const IconData strokeRoundedInsertRowUp =
      IconData(0x41c8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInsertRow' icon.
  static const IconData strokeRoundedInsertRow =
      IconData(0x41c9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInsertTopImage' icon.
  static const IconData strokeRoundedInsertTopImage =
      IconData(0x41ca, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInspectCode' icon.
  static const IconData strokeRoundedInspectCode =
      IconData(0x41cb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInstagram' icon.
  static const IconData strokeRoundedInstagram =
      IconData(0x41cc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInstallingUpdates01' icon.
  static const IconData strokeRoundedInstallingUpdates01 =
      IconData(0x41cd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInstallingUpdates02' icon.
  static const IconData strokeRoundedInstallingUpdates02 =
      IconData(0x41ce, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInternetAntenna01' icon.
  static const IconData strokeRoundedInternetAntenna01 =
      IconData(0x41cf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInternetAntenna02' icon.
  static const IconData strokeRoundedInternetAntenna02 =
      IconData(0x41d0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInternetAntenna03' icon.
  static const IconData strokeRoundedInternetAntenna03 =
      IconData(0x41d1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInternetAntenna04' icon.
  static const IconData strokeRoundedInternetAntenna04 =
      IconData(0x41d2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInternet' icon.
  static const IconData strokeRoundedInternet =
      IconData(0x41d3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInvestigation' icon.
  static const IconData strokeRoundedInvestigation =
      IconData(0x41d4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInvoice01' icon.
  static const IconData strokeRoundedInvoice01 =
      IconData(0x41d5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInvoice02' icon.
  static const IconData strokeRoundedInvoice02 =
      IconData(0x41d6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInvoice03' icon.
  static const IconData strokeRoundedInvoice03 =
      IconData(0x41d7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInvoice04' icon.
  static const IconData strokeRoundedInvoice04 =
      IconData(0x41d8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedInvoice' icon.
  static const IconData strokeRoundedInvoice =
      IconData(0x41d9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedIpod' icon.
  static const IconData strokeRoundedIpod =
      IconData(0x41da, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedIrisScan' icon.
  static const IconData strokeRoundedIrisScan =
      IconData(0x41db, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedIsland' icon.
  static const IconData strokeRoundedIsland =
      IconData(0x41dc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedJar' icon.
  static const IconData strokeRoundedJar =
      IconData(0x41dd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedJavaScript' icon.
  static const IconData strokeRoundedJavaScript =
      IconData(0x41de, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedJava' icon.
  static const IconData strokeRoundedJava =
      IconData(0x41df, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedJobLink' icon.
  static const IconData strokeRoundedJobLink =
      IconData(0x41e0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedJobSearch' icon.
  static const IconData strokeRoundedJobSearch =
      IconData(0x41e1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedJobShare' icon.
  static const IconData strokeRoundedJobShare =
      IconData(0x41e2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedJoggerPants' icon.
  static const IconData strokeRoundedJoggerPants =
      IconData(0x41e3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedJoinBevel' icon.
  static const IconData strokeRoundedJoinBevel =
      IconData(0x41e4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedJoinRound' icon.
  static const IconData strokeRoundedJoinRound =
      IconData(0x41e5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedJoinStraight' icon.
  static const IconData strokeRoundedJoinStraight =
      IconData(0x41e6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedJoker' icon.
  static const IconData strokeRoundedJoker =
      IconData(0x41e7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedJoystick01' icon.
  static const IconData strokeRoundedJoystick01 =
      IconData(0x41e8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedJoystick02' icon.
  static const IconData strokeRoundedJoystick02 =
      IconData(0x41e9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedJoystick03' icon.
  static const IconData strokeRoundedJoystick03 =
      IconData(0x41ea, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedJoystick04' icon.
  static const IconData strokeRoundedJoystick04 =
      IconData(0x41eb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedJoystick05' icon.
  static const IconData strokeRoundedJoystick05 =
      IconData(0x41ec, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedJpg01' icon.
  static const IconData strokeRoundedJpg01 =
      IconData(0x41ed, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedJpg02' icon.
  static const IconData strokeRoundedJpg02 =
      IconData(0x41ee, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedJsx01' icon.
  static const IconData strokeRoundedJsx01 =
      IconData(0x41ef, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedJsx02' icon.
  static const IconData strokeRoundedJsx02 =
      IconData(0x41f0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedJsx03' icon.
  static const IconData strokeRoundedJsx03 =
      IconData(0x41f1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedJudge' icon.
  static const IconData strokeRoundedJudge =
      IconData(0x41f2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedJupiter' icon.
  static const IconData strokeRoundedJupiter =
      IconData(0x41f3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedJusticeScale01' icon.
  static const IconData strokeRoundedJusticeScale01 =
      IconData(0x41f4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedJusticeScale02' icon.
  static const IconData strokeRoundedJusticeScale02 =
      IconData(0x41f5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKaaba01' icon.
  static const IconData strokeRoundedKaaba01 =
      IconData(0x41f6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKaaba02' icon.
  static const IconData strokeRoundedKaaba02 =
      IconData(0x41f7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKayak' icon.
  static const IconData strokeRoundedKayak =
      IconData(0x41f8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKeffiyeh' icon.
  static const IconData strokeRoundedKeffiyeh =
      IconData(0x41f9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKettle01' icon.
  static const IconData strokeRoundedKettle01 =
      IconData(0x41fa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKettle' icon.
  static const IconData strokeRoundedKettle =
      IconData(0x41fb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKettlebell' icon.
  static const IconData strokeRoundedKettlebell =
      IconData(0x41fc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKetupat' icon.
  static const IconData strokeRoundedKetupat =
      IconData(0x41fd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKey01' icon.
  static const IconData strokeRoundedKey01 =
      IconData(0x41fe, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKey02' icon.
  static const IconData strokeRoundedKey02 =
      IconData(0x41ff, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKeyGeneratorFob' icon.
  static const IconData strokeRoundedKeyGeneratorFob =
      IconData(0x4200, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKeyboard' icon.
  static const IconData strokeRoundedKeyboard =
      IconData(0x4201, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKeyframeAdd' icon.
  static const IconData strokeRoundedKeyframeAdd =
      IconData(0x4202, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKeyframeAlignCenter' icon.
  static const IconData strokeRoundedKeyframeAlignCenter =
      IconData(0x4203, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKeyframeAlignHorizontal' icon.
  static const IconData strokeRoundedKeyframeAlignHorizontal =
      IconData(0x4204, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKeyframeAlignVertical' icon.
  static const IconData strokeRoundedKeyframeAlignVertical =
      IconData(0x4205, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKeyframeBottom' icon.
  static const IconData strokeRoundedKeyframeBottom =
      IconData(0x4206, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKeyframeLeft' icon.
  static const IconData strokeRoundedKeyframeLeft =
      IconData(0x4207, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKeyframeRemove' icon.
  static const IconData strokeRoundedKeyframeRemove =
      IconData(0x4208, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKeyframeRight' icon.
  static const IconData strokeRoundedKeyframeRight =
      IconData(0x4209, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKeyframeTop' icon.
  static const IconData strokeRoundedKeyframeTop =
      IconData(0x420a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKeyframe' icon.
  static const IconData strokeRoundedKeyframe =
      IconData(0x420b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKeyframesDoubleAdd' icon.
  static const IconData strokeRoundedKeyframesDoubleAdd =
      IconData(0x420c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKeyframesDoubleRemove' icon.
  static const IconData strokeRoundedKeyframesDoubleRemove =
      IconData(0x420d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKeyframesDouble' icon.
  static const IconData strokeRoundedKeyframesDouble =
      IconData(0x420e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKeyframesMultipleAdd' icon.
  static const IconData strokeRoundedKeyframesMultipleAdd =
      IconData(0x420f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKeyframesMultipleRemove' icon.
  static const IconData strokeRoundedKeyframesMultipleRemove =
      IconData(0x4210, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKeyframesMultiple' icon.
  static const IconData strokeRoundedKeyframesMultiple =
      IconData(0x4211, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKickstarter01' icon.
  static const IconData strokeRoundedKickstarter01 =
      IconData(0x4212, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKickstarter02' icon.
  static const IconData strokeRoundedKickstarter02 =
      IconData(0x4213, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKid' icon.
  static const IconData strokeRoundedKid =
      IconData(0x4214, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKidneys' icon.
  static const IconData strokeRoundedKidneys =
      IconData(0x4215, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKissing' icon.
  static const IconData strokeRoundedKissing =
      IconData(0x4216, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKitchenUtensils' icon.
  static const IconData strokeRoundedKitchenUtensils =
      IconData(0x4217, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKite' icon.
  static const IconData strokeRoundedKite =
      IconData(0x4218, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKnife01' icon.
  static const IconData strokeRoundedKnife01 =
      IconData(0x4219, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKnife02' icon.
  static const IconData strokeRoundedKnife02 =
      IconData(0x421a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKnifeBread' icon.
  static const IconData strokeRoundedKnifeBread =
      IconData(0x421b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKnightShield' icon.
  static const IconData strokeRoundedKnightShield =
      IconData(0x421c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKnives' icon.
  static const IconData strokeRoundedKnives =
      IconData(0x421d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKnowledge01' icon.
  static const IconData strokeRoundedKnowledge01 =
      IconData(0x421e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKnowledge02' icon.
  static const IconData strokeRoundedKnowledge02 =
      IconData(0x421f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKurta01' icon.
  static const IconData strokeRoundedKurta01 =
      IconData(0x4220, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedKurta' icon.
  static const IconData strokeRoundedKurta =
      IconData(0x4221, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLabelImportant' icon.
  static const IconData strokeRoundedLabelImportant =
      IconData(0x4222, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLabel' icon.
  static const IconData strokeRoundedLabel =
      IconData(0x4223, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLabor' icon.
  static const IconData strokeRoundedLabor =
      IconData(0x4224, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLabs' icon.
  static const IconData strokeRoundedLabs =
      IconData(0x4225, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLake' icon.
  static const IconData strokeRoundedLake =
      IconData(0x4226, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLamp01' icon.
  static const IconData strokeRoundedLamp01 =
      IconData(0x4227, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLamp02' icon.
  static const IconData strokeRoundedLamp02 =
      IconData(0x4228, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLamp03' icon.
  static const IconData strokeRoundedLamp03 =
      IconData(0x4229, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLamp04' icon.
  static const IconData strokeRoundedLamp04 =
      IconData(0x422a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLamp05' icon.
  static const IconData strokeRoundedLamp05 =
      IconData(0x422b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLamp' icon.
  static const IconData strokeRoundedLamp =
      IconData(0x422c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLanguageCircle' icon.
  static const IconData strokeRoundedLanguageCircle =
      IconData(0x422d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLanguageSkill' icon.
  static const IconData strokeRoundedLanguageSkill =
      IconData(0x422e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLanguageSquare' icon.
  static const IconData strokeRoundedLanguageSquare =
      IconData(0x422f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLantern' icon.
  static const IconData strokeRoundedLantern =
      IconData(0x4230, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLaptopAdd' icon.
  static const IconData strokeRoundedLaptopAdd =
      IconData(0x4231, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLaptopCharging' icon.
  static const IconData strokeRoundedLaptopCharging =
      IconData(0x4232, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLaptopCheck' icon.
  static const IconData strokeRoundedLaptopCheck =
      IconData(0x4233, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLaptopCloud' icon.
  static const IconData strokeRoundedLaptopCloud =
      IconData(0x4234, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLaptopIssue' icon.
  static const IconData strokeRoundedLaptopIssue =
      IconData(0x4235, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLaptopPerformance' icon.
  static const IconData strokeRoundedLaptopPerformance =
      IconData(0x4236, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLaptopPhoneSync' icon.
  static const IconData strokeRoundedLaptopPhoneSync =
      IconData(0x4237, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLaptopProgramming' icon.
  static const IconData strokeRoundedLaptopProgramming =
      IconData(0x4238, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLaptopRemove' icon.
  static const IconData strokeRoundedLaptopRemove =
      IconData(0x4239, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLaptopSettings' icon.
  static const IconData strokeRoundedLaptopSettings =
      IconData(0x423a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLaptopVideo' icon.
  static const IconData strokeRoundedLaptopVideo =
      IconData(0x423b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLaptop' icon.
  static const IconData strokeRoundedLaptop =
      IconData(0x423c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLassoTool01' icon.
  static const IconData strokeRoundedLassoTool01 =
      IconData(0x423d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLassoTool02' icon.
  static const IconData strokeRoundedLassoTool02 =
      IconData(0x423e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLastFm' icon.
  static const IconData strokeRoundedLastFm =
      IconData(0x423f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLatitude' icon.
  static const IconData strokeRoundedLatitude =
      IconData(0x4240, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLaughing' icon.
  static const IconData strokeRoundedLaughing =
      IconData(0x4241, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLaurelWreath01' icon.
  static const IconData strokeRoundedLaurelWreath01 =
      IconData(0x4242, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLaurelWreath02' icon.
  static const IconData strokeRoundedLaurelWreath02 =
      IconData(0x4243, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLaurelWreathFirst01' icon.
  static const IconData strokeRoundedLaurelWreathFirst01 =
      IconData(0x4244, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLaurelWreathFirst02' icon.
  static const IconData strokeRoundedLaurelWreathFirst02 =
      IconData(0x4245, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLaurelWreathLeft01' icon.
  static const IconData strokeRoundedLaurelWreathLeft01 =
      IconData(0x4246, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLaurelWreathLeft02' icon.
  static const IconData strokeRoundedLaurelWreathLeft02 =
      IconData(0x4247, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLaurelWreathLeft03' icon.
  static const IconData strokeRoundedLaurelWreathLeft03 =
      IconData(0x4248, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLaurelWreathRight01' icon.
  static const IconData strokeRoundedLaurelWreathRight01 =
      IconData(0x4249, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLaurelWreathRight02' icon.
  static const IconData strokeRoundedLaurelWreathRight02 =
      IconData(0x424a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLaurelWreathRight03' icon.
  static const IconData strokeRoundedLaurelWreathRight03 =
      IconData(0x424b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLayerAdd' icon.
  static const IconData strokeRoundedLayerAdd =
      IconData(0x424c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLayerMask01' icon.
  static const IconData strokeRoundedLayerMask01 =
      IconData(0x424d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLayerMask02' icon.
  static const IconData strokeRoundedLayerMask02 =
      IconData(0x424e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLayers01' icon.
  static const IconData strokeRoundedLayers01 =
      IconData(0x424f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLayers02' icon.
  static const IconData strokeRoundedLayers02 =
      IconData(0x4250, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLayersLogo' icon.
  static const IconData strokeRoundedLayersLogo =
      IconData(0x4251, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLayout01' icon.
  static const IconData strokeRoundedLayout01 =
      IconData(0x4252, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLayout02' icon.
  static const IconData strokeRoundedLayout02 =
      IconData(0x4253, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLayout03' icon.
  static const IconData strokeRoundedLayout03 =
      IconData(0x4254, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLayout04' icon.
  static const IconData strokeRoundedLayout04 =
      IconData(0x4255, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLayout05' icon.
  static const IconData strokeRoundedLayout05 =
      IconData(0x4256, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLayout06' icon.
  static const IconData strokeRoundedLayout06 =
      IconData(0x4257, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLayout07' icon.
  static const IconData strokeRoundedLayout07 =
      IconData(0x4258, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLayout2Column' icon.
  static const IconData strokeRoundedLayout2Column =
      IconData(0x4259, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLayout2Row' icon.
  static const IconData strokeRoundedLayout2Row =
      IconData(0x425a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLayout3Column' icon.
  static const IconData strokeRoundedLayout3Column =
      IconData(0x425b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLayout3Row' icon.
  static const IconData strokeRoundedLayout3Row =
      IconData(0x425c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLayoutBottom' icon.
  static const IconData strokeRoundedLayoutBottom =
      IconData(0x425d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLayoutGrid' icon.
  static const IconData strokeRoundedLayoutGrid =
      IconData(0x425e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLayoutLeft' icon.
  static const IconData strokeRoundedLayoutLeft =
      IconData(0x425f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLayoutRight' icon.
  static const IconData strokeRoundedLayoutRight =
      IconData(0x4260, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLayoutTable01' icon.
  static const IconData strokeRoundedLayoutTable01 =
      IconData(0x4261, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLayoutTable02' icon.
  static const IconData strokeRoundedLayoutTable02 =
      IconData(0x4262, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLayoutTop' icon.
  static const IconData strokeRoundedLayoutTop =
      IconData(0x4263, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLeaf01' icon.
  static const IconData strokeRoundedLeaf01 =
      IconData(0x4264, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLeaf02' icon.
  static const IconData strokeRoundedLeaf02 =
      IconData(0x4265, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLeaf03' icon.
  static const IconData strokeRoundedLeaf03 =
      IconData(0x4266, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLeaf04' icon.
  static const IconData strokeRoundedLeaf04 =
      IconData(0x4267, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLeavingGeoFence' icon.
  static const IconData strokeRoundedLeavingGeoFence =
      IconData(0x4268, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLeetcode' icon.
  static const IconData strokeRoundedLeetcode =
      IconData(0x4269, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLeftAngle' icon.
  static const IconData strokeRoundedLeftAngle =
      IconData(0x426a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLeftToRightBlockQuote' icon.
  static const IconData strokeRoundedLeftToRightBlockQuote =
      IconData(0x426b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLeftToRightListBullet' icon.
  static const IconData strokeRoundedLeftToRightListBullet =
      IconData(0x426c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLeftToRightListDash' icon.
  static const IconData strokeRoundedLeftToRightListDash =
      IconData(0x426d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLeftToRightListNumber' icon.
  static const IconData strokeRoundedLeftToRightListNumber =
      IconData(0x426e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLeftToRightListStar01' icon.
  static const IconData strokeRoundedLeftToRightListStar01 =
      IconData(0x426f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLeftToRightListStar' icon.
  static const IconData strokeRoundedLeftToRightListStar =
      IconData(0x4270, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLeftToRightListTriangle' icon.
  static const IconData strokeRoundedLeftToRightListTriangle =
      IconData(0x4271, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLeftTriangle' icon.
  static const IconData strokeRoundedLeftTriangle =
      IconData(0x4272, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLegal01' icon.
  static const IconData strokeRoundedLegal01 =
      IconData(0x4273, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLegal02' icon.
  static const IconData strokeRoundedLegal02 =
      IconData(0x4274, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLegalDocument01' icon.
  static const IconData strokeRoundedLegalDocument01 =
      IconData(0x4275, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLegalDocument02' icon.
  static const IconData strokeRoundedLegalDocument02 =
      IconData(0x4276, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLegalHammer' icon.
  static const IconData strokeRoundedLegalHammer =
      IconData(0x4277, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLessThanCircle' icon.
  static const IconData strokeRoundedLessThanCircle =
      IconData(0x4278, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLessThanSquare' icon.
  static const IconData strokeRoundedLessThanSquare =
      IconData(0x4279, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLessThan' icon.
  static const IconData strokeRoundedLessThan =
      IconData(0x427a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLetterSpacing' icon.
  static const IconData strokeRoundedLetterSpacing =
      IconData(0x427b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLibraries' icon.
  static const IconData strokeRoundedLibraries =
      IconData(0x427c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLibrary' icon.
  static const IconData strokeRoundedLibrary =
      IconData(0x427d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLicenseDraft' icon.
  static const IconData strokeRoundedLicenseDraft =
      IconData(0x427e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLicenseMaintenance' icon.
  static const IconData strokeRoundedLicenseMaintenance =
      IconData(0x427f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLicenseNo' icon.
  static const IconData strokeRoundedLicenseNo =
      IconData(0x4280, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLicensePin' icon.
  static const IconData strokeRoundedLicensePin =
      IconData(0x4281, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLicenseThirdParty' icon.
  static const IconData strokeRoundedLicenseThirdParty =
      IconData(0x4282, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLicense' icon.
  static const IconData strokeRoundedLicense =
      IconData(0x4283, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLiftTruck' icon.
  static const IconData strokeRoundedLiftTruck =
      IconData(0x4284, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLighthouse' icon.
  static const IconData strokeRoundedLighthouse =
      IconData(0x4285, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLimitation' icon.
  static const IconData strokeRoundedLimitation =
      IconData(0x4286, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLine' icon.
  static const IconData strokeRoundedLine =
      IconData(0x4287, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLiner' icon.
  static const IconData strokeRoundedLiner =
      IconData(0x4288, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLink01' icon.
  static const IconData strokeRoundedLink01 =
      IconData(0x4289, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLink02' icon.
  static const IconData strokeRoundedLink02 =
      IconData(0x428a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLink03' icon.
  static const IconData strokeRoundedLink03 =
      IconData(0x428b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLink04' icon.
  static const IconData strokeRoundedLink04 =
      IconData(0x428c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLink05' icon.
  static const IconData strokeRoundedLink05 =
      IconData(0x428d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLink06' icon.
  static const IconData strokeRoundedLink06 =
      IconData(0x428e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLinkBackward' icon.
  static const IconData strokeRoundedLinkBackward =
      IconData(0x428f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLinkCircle02' icon.
  static const IconData strokeRoundedLinkCircle02 =
      IconData(0x4290, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLinkCircle' icon.
  static const IconData strokeRoundedLinkCircle =
      IconData(0x4291, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLinkForward' icon.
  static const IconData strokeRoundedLinkForward =
      IconData(0x4292, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLinkSquare01' icon.
  static const IconData strokeRoundedLinkSquare01 =
      IconData(0x4293, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLinkSquare02' icon.
  static const IconData strokeRoundedLinkSquare02 =
      IconData(0x4294, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLinkedin01' icon.
  static const IconData strokeRoundedLinkedin01 =
      IconData(0x4295, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLinkedin02' icon.
  static const IconData strokeRoundedLinkedin02 =
      IconData(0x4296, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedListSetting' icon.
  static const IconData strokeRoundedListSetting =
      IconData(0x4297, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedListView' icon.
  static const IconData strokeRoundedListView =
      IconData(0x4298, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLitecoin' icon.
  static const IconData strokeRoundedLitecoin =
      IconData(0x4299, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLiver' icon.
  static const IconData strokeRoundedLiver =
      IconData(0x429a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLoading01' icon.
  static const IconData strokeRoundedLoading01 =
      IconData(0x429b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLoading02' icon.
  static const IconData strokeRoundedLoading02 =
      IconData(0x429c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLoading03' icon.
  static const IconData strokeRoundedLoading03 =
      IconData(0x429d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLoading04' icon.
  static const IconData strokeRoundedLoading04 =
      IconData(0x429e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocation01' icon.
  static const IconData strokeRoundedLocation01 =
      IconData(0x429f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocation02' icon.
  static const IconData strokeRoundedLocation02 =
      IconData(0x42a0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocation03' icon.
  static const IconData strokeRoundedLocation03 =
      IconData(0x42a1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocation04' icon.
  static const IconData strokeRoundedLocation04 =
      IconData(0x42a2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocation05' icon.
  static const IconData strokeRoundedLocation05 =
      IconData(0x42a3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocation06' icon.
  static const IconData strokeRoundedLocation06 =
      IconData(0x42a4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocation07' icon.
  static const IconData strokeRoundedLocation07 =
      IconData(0x42a5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocation08' icon.
  static const IconData strokeRoundedLocation08 =
      IconData(0x42a6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocation09' icon.
  static const IconData strokeRoundedLocation09 =
      IconData(0x42a7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocation10' icon.
  static const IconData strokeRoundedLocation10 =
      IconData(0x42a8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocationAdd01' icon.
  static const IconData strokeRoundedLocationAdd01 =
      IconData(0x42a9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocationAdd02' icon.
  static const IconData strokeRoundedLocationAdd02 =
      IconData(0x42aa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocationCheck01' icon.
  static const IconData strokeRoundedLocationCheck01 =
      IconData(0x42ab, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocationCheck02' icon.
  static const IconData strokeRoundedLocationCheck02 =
      IconData(0x42ac, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocationFavourite01' icon.
  static const IconData strokeRoundedLocationFavourite01 =
      IconData(0x42ad, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocationFavourite02' icon.
  static const IconData strokeRoundedLocationFavourite02 =
      IconData(0x42ae, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocationOffline01' icon.
  static const IconData strokeRoundedLocationOffline01 =
      IconData(0x42af, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocationOffline02' icon.
  static const IconData strokeRoundedLocationOffline02 =
      IconData(0x42b0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocationOffline03' icon.
  static const IconData strokeRoundedLocationOffline03 =
      IconData(0x42b1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocationOffline04' icon.
  static const IconData strokeRoundedLocationOffline04 =
      IconData(0x42b2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocationRemove01' icon.
  static const IconData strokeRoundedLocationRemove01 =
      IconData(0x42b3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocationRemove02' icon.
  static const IconData strokeRoundedLocationRemove02 =
      IconData(0x42b4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocationShare01' icon.
  static const IconData strokeRoundedLocationShare01 =
      IconData(0x42b5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocationShare02' icon.
  static const IconData strokeRoundedLocationShare02 =
      IconData(0x42b6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocationStar01' icon.
  static const IconData strokeRoundedLocationStar01 =
      IconData(0x42b7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocationStar02' icon.
  static const IconData strokeRoundedLocationStar02 =
      IconData(0x42b8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocationUpdate01' icon.
  static const IconData strokeRoundedLocationUpdate01 =
      IconData(0x42b9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocationUpdate02' icon.
  static const IconData strokeRoundedLocationUpdate02 =
      IconData(0x42ba, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocationUser01' icon.
  static const IconData strokeRoundedLocationUser01 =
      IconData(0x42bb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocationUser02' icon.
  static const IconData strokeRoundedLocationUser02 =
      IconData(0x42bc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocationUser03' icon.
  static const IconData strokeRoundedLocationUser03 =
      IconData(0x42bd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocationUser04' icon.
  static const IconData strokeRoundedLocationUser04 =
      IconData(0x42be, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLockComputer' icon.
  static const IconData strokeRoundedLockComputer =
      IconData(0x42bf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLockKey' icon.
  static const IconData strokeRoundedLockKey =
      IconData(0x42c0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLockPassword' icon.
  static const IconData strokeRoundedLockPassword =
      IconData(0x42c1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLockSync01' icon.
  static const IconData strokeRoundedLockSync01 =
      IconData(0x42c2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLockSync02' icon.
  static const IconData strokeRoundedLockSync02 =
      IconData(0x42c3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLock' icon.
  static const IconData strokeRoundedLock =
      IconData(0x42c4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocked' icon.
  static const IconData strokeRoundedLocked =
      IconData(0x42c5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocker01' icon.
  static const IconData strokeRoundedLocker01 =
      IconData(0x42c6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLocker' icon.
  static const IconData strokeRoundedLocker =
      IconData(0x42c7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLogin01' icon.
  static const IconData strokeRoundedLogin01 =
      IconData(0x42c8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLogin02' icon.
  static const IconData strokeRoundedLogin02 =
      IconData(0x42c9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLogin03' icon.
  static const IconData strokeRoundedLogin03 =
      IconData(0x42ca, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLoginCircle01' icon.
  static const IconData strokeRoundedLoginCircle01 =
      IconData(0x42cb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLoginCircle02' icon.
  static const IconData strokeRoundedLoginCircle02 =
      IconData(0x42cc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLoginMethod' icon.
  static const IconData strokeRoundedLoginMethod =
      IconData(0x42cd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLoginSquare01' icon.
  static const IconData strokeRoundedLoginSquare01 =
      IconData(0x42ce, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLoginSquare02' icon.
  static const IconData strokeRoundedLoginSquare02 =
      IconData(0x42cf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLogout01' icon.
  static const IconData strokeRoundedLogout01 =
      IconData(0x42d0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLogout02' icon.
  static const IconData strokeRoundedLogout02 =
      IconData(0x42d1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLogout03' icon.
  static const IconData strokeRoundedLogout03 =
      IconData(0x42d2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLogout04' icon.
  static const IconData strokeRoundedLogout04 =
      IconData(0x42d3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLogout05' icon.
  static const IconData strokeRoundedLogout05 =
      IconData(0x42d4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLogoutCircle01' icon.
  static const IconData strokeRoundedLogoutCircle01 =
      IconData(0x42d5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLogoutCircle02' icon.
  static const IconData strokeRoundedLogoutCircle02 =
      IconData(0x42d6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLogoutSquare01' icon.
  static const IconData strokeRoundedLogoutSquare01 =
      IconData(0x42d7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLogoutSquare02' icon.
  static const IconData strokeRoundedLogoutSquare02 =
      IconData(0x42d8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLollipop' icon.
  static const IconData strokeRoundedLollipop =
      IconData(0x42d9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLongSleeveShirt' icon.
  static const IconData strokeRoundedLongSleeveShirt =
      IconData(0x42da, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLongitude' icon.
  static const IconData strokeRoundedLongitude =
      IconData(0x42db, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLookBottom' icon.
  static const IconData strokeRoundedLookBottom =
      IconData(0x42dc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLookLeft' icon.
  static const IconData strokeRoundedLookLeft =
      IconData(0x42dd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLookRight' icon.
  static const IconData strokeRoundedLookRight =
      IconData(0x42de, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLookTop' icon.
  static const IconData strokeRoundedLookTop =
      IconData(0x42df, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLoom' icon.
  static const IconData strokeRoundedLoom =
      IconData(0x42e0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLottiefiles' icon.
  static const IconData strokeRoundedLottiefiles =
      IconData(0x42e1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLoveKoreanFinger' icon.
  static const IconData strokeRoundedLoveKoreanFinger =
      IconData(0x42e2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLoyaltyCard' icon.
  static const IconData strokeRoundedLoyaltyCard =
      IconData(0x42e3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLuggage01' icon.
  static const IconData strokeRoundedLuggage01 =
      IconData(0x42e4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLuggage02' icon.
  static const IconData strokeRoundedLuggage02 =
      IconData(0x42e5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedLungs' icon.
  static const IconData strokeRoundedLungs =
      IconData(0x42e6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMachineRobot' icon.
  static const IconData strokeRoundedMachineRobot =
      IconData(0x42e7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMagicWand01' icon.
  static const IconData strokeRoundedMagicWand01 =
      IconData(0x42e8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMagicWand02' icon.
  static const IconData strokeRoundedMagicWand02 =
      IconData(0x42e9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMagicWand03' icon.
  static const IconData strokeRoundedMagicWand03 =
      IconData(0x42ea, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMagnet01' icon.
  static const IconData strokeRoundedMagnet01 =
      IconData(0x42eb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMagnet02' icon.
  static const IconData strokeRoundedMagnet02 =
      IconData(0x42ec, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMagnet' icon.
  static const IconData strokeRoundedMagnet =
      IconData(0x42ed, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMail01' icon.
  static const IconData strokeRoundedMail01 =
      IconData(0x42ee, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMail02' icon.
  static const IconData strokeRoundedMail02 =
      IconData(0x42ef, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailAccount01' icon.
  static const IconData strokeRoundedMailAccount01 =
      IconData(0x42f0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailAccount02' icon.
  static const IconData strokeRoundedMailAccount02 =
      IconData(0x42f1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailAdd01' icon.
  static const IconData strokeRoundedMailAdd01 =
      IconData(0x42f2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailAdd02' icon.
  static const IconData strokeRoundedMailAdd02 =
      IconData(0x42f3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailAtSign01' icon.
  static const IconData strokeRoundedMailAtSign01 =
      IconData(0x42f4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailAtSign02' icon.
  static const IconData strokeRoundedMailAtSign02 =
      IconData(0x42f5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailBlock01' icon.
  static const IconData strokeRoundedMailBlock01 =
      IconData(0x42f6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailBlock02' icon.
  static const IconData strokeRoundedMailBlock02 =
      IconData(0x42f7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailDownload01' icon.
  static const IconData strokeRoundedMailDownload01 =
      IconData(0x42f8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailDownload02' icon.
  static const IconData strokeRoundedMailDownload02 =
      IconData(0x42f9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailEdit01' icon.
  static const IconData strokeRoundedMailEdit01 =
      IconData(0x42fa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailEdit02' icon.
  static const IconData strokeRoundedMailEdit02 =
      IconData(0x42fb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailLock01' icon.
  static const IconData strokeRoundedMailLock01 =
      IconData(0x42fc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailLock02' icon.
  static const IconData strokeRoundedMailLock02 =
      IconData(0x42fd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailLove01' icon.
  static const IconData strokeRoundedMailLove01 =
      IconData(0x42fe, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailLove02' icon.
  static const IconData strokeRoundedMailLove02 =
      IconData(0x42ff, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailMinus01' icon.
  static const IconData strokeRoundedMailMinus01 =
      IconData(0x4300, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailMinus02' icon.
  static const IconData strokeRoundedMailMinus02 =
      IconData(0x4301, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailOpen01' icon.
  static const IconData strokeRoundedMailOpen01 =
      IconData(0x4302, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailOpen02' icon.
  static const IconData strokeRoundedMailOpen02 =
      IconData(0x4303, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailOpenLove' icon.
  static const IconData strokeRoundedMailOpenLove =
      IconData(0x4304, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailOpen' icon.
  static const IconData strokeRoundedMailOpen =
      IconData(0x4305, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailReceive01' icon.
  static const IconData strokeRoundedMailReceive01 =
      IconData(0x4306, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailReceive02' icon.
  static const IconData strokeRoundedMailReceive02 =
      IconData(0x4307, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailRemove01' icon.
  static const IconData strokeRoundedMailRemove01 =
      IconData(0x4308, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailRemove02' icon.
  static const IconData strokeRoundedMailRemove02 =
      IconData(0x4309, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailReply01' icon.
  static const IconData strokeRoundedMailReply01 =
      IconData(0x430a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailReply02' icon.
  static const IconData strokeRoundedMailReply02 =
      IconData(0x430b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailReplyAll01' icon.
  static const IconData strokeRoundedMailReplyAll01 =
      IconData(0x430c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailReplyAll02' icon.
  static const IconData strokeRoundedMailReplyAll02 =
      IconData(0x430d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailSearch01' icon.
  static const IconData strokeRoundedMailSearch01 =
      IconData(0x430e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailSearch02' icon.
  static const IconData strokeRoundedMailSearch02 =
      IconData(0x430f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailSecure01' icon.
  static const IconData strokeRoundedMailSecure01 =
      IconData(0x4310, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailSecure02' icon.
  static const IconData strokeRoundedMailSecure02 =
      IconData(0x4311, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailSend01' icon.
  static const IconData strokeRoundedMailSend01 =
      IconData(0x4312, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailSend02' icon.
  static const IconData strokeRoundedMailSend02 =
      IconData(0x4313, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailSetting01' icon.
  static const IconData strokeRoundedMailSetting01 =
      IconData(0x4314, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailSetting02' icon.
  static const IconData strokeRoundedMailSetting02 =
      IconData(0x4315, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailUnlock01' icon.
  static const IconData strokeRoundedMailUnlock01 =
      IconData(0x4316, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailUnlock02' icon.
  static const IconData strokeRoundedMailUnlock02 =
      IconData(0x4317, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailUpload01' icon.
  static const IconData strokeRoundedMailUpload01 =
      IconData(0x4318, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailUpload02' icon.
  static const IconData strokeRoundedMailUpload02 =
      IconData(0x4319, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailValidation01' icon.
  static const IconData strokeRoundedMailValidation01 =
      IconData(0x431a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailValidation02' icon.
  static const IconData strokeRoundedMailValidation02 =
      IconData(0x431b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailVoice01' icon.
  static const IconData strokeRoundedMailVoice01 =
      IconData(0x431c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailVoice02' icon.
  static const IconData strokeRoundedMailVoice02 =
      IconData(0x431d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailbox01' icon.
  static const IconData strokeRoundedMailbox01 =
      IconData(0x431e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMailbox' icon.
  static const IconData strokeRoundedMailbox =
      IconData(0x431f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedManager' icon.
  static const IconData strokeRoundedManager =
      IconData(0x4320, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMapPin' icon.
  static const IconData strokeRoundedMapPin =
      IconData(0x4321, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMapPinpoint01' icon.
  static const IconData strokeRoundedMapPinpoint01 =
      IconData(0x4322, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMapPinpoint02' icon.
  static const IconData strokeRoundedMapPinpoint02 =
      IconData(0x4323, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMaping' icon.
  static const IconData strokeRoundedMaping =
      IconData(0x4324, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMapsCircle01' icon.
  static const IconData strokeRoundedMapsCircle01 =
      IconData(0x4325, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMapsCircle02' icon.
  static const IconData strokeRoundedMapsCircle02 =
      IconData(0x4326, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMapsEditing' icon.
  static const IconData strokeRoundedMapsEditing =
      IconData(0x4327, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMapsGlobal01' icon.
  static const IconData strokeRoundedMapsGlobal01 =
      IconData(0x4328, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMapsGlobal02' icon.
  static const IconData strokeRoundedMapsGlobal02 =
      IconData(0x4329, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMapsLocation01' icon.
  static const IconData strokeRoundedMapsLocation01 =
      IconData(0x432a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMapsLocation02' icon.
  static const IconData strokeRoundedMapsLocation02 =
      IconData(0x432b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMapsOff' icon.
  static const IconData strokeRoundedMapsOff =
      IconData(0x432c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMapsRefresh' icon.
  static const IconData strokeRoundedMapsRefresh =
      IconData(0x432d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMapsSearch' icon.
  static const IconData strokeRoundedMapsSearch =
      IconData(0x432e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMapsSquare01' icon.
  static const IconData strokeRoundedMapsSquare01 =
      IconData(0x432f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMapsSquare02' icon.
  static const IconData strokeRoundedMapsSquare02 =
      IconData(0x4330, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMaps' icon.
  static const IconData strokeRoundedMaps =
      IconData(0x4331, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMarketAnalysis' icon.
  static const IconData strokeRoundedMarketAnalysis =
      IconData(0x4332, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMarketing' icon.
  static const IconData strokeRoundedMarketing =
      IconData(0x4333, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMaskLove' icon.
  static const IconData strokeRoundedMaskLove =
      IconData(0x4334, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMask' icon.
  static const IconData strokeRoundedMask =
      IconData(0x4335, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMasterCard' icon.
  static const IconData strokeRoundedMasterCard =
      IconData(0x4336, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMatches' icon.
  static const IconData strokeRoundedMatches =
      IconData(0x4337, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMath' icon.
  static const IconData strokeRoundedMath =
      IconData(0x4338, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMatrix' icon.
  static const IconData strokeRoundedMatrix =
      IconData(0x4339, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMaximize01' icon.
  static const IconData strokeRoundedMaximize01 =
      IconData(0x433a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMaximize02' icon.
  static const IconData strokeRoundedMaximize02 =
      IconData(0x433b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMaximize03' icon.
  static const IconData strokeRoundedMaximize03 =
      IconData(0x433c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMaximize04' icon.
  static const IconData strokeRoundedMaximize04 =
      IconData(0x433d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMaximizeScreen' icon.
  static const IconData strokeRoundedMaximizeScreen =
      IconData(0x433e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMayanPyramid' icon.
  static const IconData strokeRoundedMayanPyramid =
      IconData(0x433f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMaze' icon.
  static const IconData strokeRoundedMaze =
      IconData(0x4340, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMedal01' icon.
  static const IconData strokeRoundedMedal01 =
      IconData(0x4341, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMedal02' icon.
  static const IconData strokeRoundedMedal02 =
      IconData(0x4342, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMedal03' icon.
  static const IconData strokeRoundedMedal03 =
      IconData(0x4343, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMedal04' icon.
  static const IconData strokeRoundedMedal04 =
      IconData(0x4344, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMedal05' icon.
  static const IconData strokeRoundedMedal05 =
      IconData(0x4345, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMedal06' icon.
  static const IconData strokeRoundedMedal06 =
      IconData(0x4346, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMedal07' icon.
  static const IconData strokeRoundedMedal07 =
      IconData(0x4347, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMedalFirstPlace' icon.
  static const IconData strokeRoundedMedalFirstPlace =
      IconData(0x4348, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMedalSecondPlace' icon.
  static const IconData strokeRoundedMedalSecondPlace =
      IconData(0x4349, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMedalThirdPlace' icon.
  static const IconData strokeRoundedMedalThirdPlace =
      IconData(0x434a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMedicalFile' icon.
  static const IconData strokeRoundedMedicalFile =
      IconData(0x434b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMedicalMask' icon.
  static const IconData strokeRoundedMedicalMask =
      IconData(0x434c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMedicine01' icon.
  static const IconData strokeRoundedMedicine01 =
      IconData(0x434d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMedicine02' icon.
  static const IconData strokeRoundedMedicine02 =
      IconData(0x434e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMedicineBottle01' icon.
  static const IconData strokeRoundedMedicineBottle01 =
      IconData(0x434f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMedicineBottle02' icon.
  static const IconData strokeRoundedMedicineBottle02 =
      IconData(0x4350, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMedicineSyrup' icon.
  static const IconData strokeRoundedMedicineSyrup =
      IconData(0x4351, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMediumSquare' icon.
  static const IconData strokeRoundedMediumSquare =
      IconData(0x4352, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMedium' icon.
  static const IconData strokeRoundedMedium =
      IconData(0x4353, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMeetingRoom' icon.
  static const IconData strokeRoundedMeetingRoom =
      IconData(0x4354, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMegaphone01' icon.
  static const IconData strokeRoundedMegaphone01 =
      IconData(0x4355, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMegaphone02' icon.
  static const IconData strokeRoundedMegaphone02 =
      IconData(0x4356, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMeh' icon.
  static const IconData strokeRoundedMeh =
      IconData(0x4357, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMentor' icon.
  static const IconData strokeRoundedMentor =
      IconData(0x4358, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMentoring' icon.
  static const IconData strokeRoundedMentoring =
      IconData(0x4359, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMenu01' icon.
  static const IconData strokeRoundedMenu01 =
      IconData(0x435a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMenu02' icon.
  static const IconData strokeRoundedMenu02 =
      IconData(0x435b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMenu03' icon.
  static const IconData strokeRoundedMenu03 =
      IconData(0x435c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMenu04' icon.
  static const IconData strokeRoundedMenu04 =
      IconData(0x435d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMenu05' icon.
  static const IconData strokeRoundedMenu05 =
      IconData(0x435e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMenu06' icon.
  static const IconData strokeRoundedMenu06 =
      IconData(0x435f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMenu07' icon.
  static const IconData strokeRoundedMenu07 =
      IconData(0x4360, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMenu08' icon.
  static const IconData strokeRoundedMenu08 =
      IconData(0x4361, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMenu09' icon.
  static const IconData strokeRoundedMenu09 =
      IconData(0x4362, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMenu10' icon.
  static const IconData strokeRoundedMenu10 =
      IconData(0x4363, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMenu11' icon.
  static const IconData strokeRoundedMenu11 =
      IconData(0x4364, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMenuCircle' icon.
  static const IconData strokeRoundedMenuCircle =
      IconData(0x4365, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMenuRestaurant' icon.
  static const IconData strokeRoundedMenuRestaurant =
      IconData(0x4366, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMenuSquare' icon.
  static const IconData strokeRoundedMenuSquare =
      IconData(0x4367, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessage01' icon.
  static const IconData strokeRoundedMessage01 =
      IconData(0x4368, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessage02' icon.
  static const IconData strokeRoundedMessage02 =
      IconData(0x4369, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageAdd01' icon.
  static const IconData strokeRoundedMessageAdd01 =
      IconData(0x436a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageAdd02' icon.
  static const IconData strokeRoundedMessageAdd02 =
      IconData(0x436b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageBlocked' icon.
  static const IconData strokeRoundedMessageBlocked =
      IconData(0x436c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageCancel01' icon.
  static const IconData strokeRoundedMessageCancel01 =
      IconData(0x436d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageCancel02' icon.
  static const IconData strokeRoundedMessageCancel02 =
      IconData(0x436e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageDelay01' icon.
  static const IconData strokeRoundedMessageDelay01 =
      IconData(0x436f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageDelay02' icon.
  static const IconData strokeRoundedMessageDelay02 =
      IconData(0x4370, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageDone01' icon.
  static const IconData strokeRoundedMessageDone01 =
      IconData(0x4371, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageDone02' icon.
  static const IconData strokeRoundedMessageDone02 =
      IconData(0x4372, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageDownload01' icon.
  static const IconData strokeRoundedMessageDownload01 =
      IconData(0x4373, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageDownload02' icon.
  static const IconData strokeRoundedMessageDownload02 =
      IconData(0x4374, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageEdit01' icon.
  static const IconData strokeRoundedMessageEdit01 =
      IconData(0x4375, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageEdit02' icon.
  static const IconData strokeRoundedMessageEdit02 =
      IconData(0x4376, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageFavourite01' icon.
  static const IconData strokeRoundedMessageFavourite01 =
      IconData(0x4377, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageFavourite02' icon.
  static const IconData strokeRoundedMessageFavourite02 =
      IconData(0x4378, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageIncoming01' icon.
  static const IconData strokeRoundedMessageIncoming01 =
      IconData(0x4379, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageIncoming02' icon.
  static const IconData strokeRoundedMessageIncoming02 =
      IconData(0x437a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageLock01' icon.
  static const IconData strokeRoundedMessageLock01 =
      IconData(0x437b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageLock02' icon.
  static const IconData strokeRoundedMessageLock02 =
      IconData(0x437c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageMultiple01' icon.
  static const IconData strokeRoundedMessageMultiple01 =
      IconData(0x437d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageMultiple02' icon.
  static const IconData strokeRoundedMessageMultiple02 =
      IconData(0x437e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageNotification01' icon.
  static const IconData strokeRoundedMessageNotification01 =
      IconData(0x437f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageNotification02' icon.
  static const IconData strokeRoundedMessageNotification02 =
      IconData(0x4380, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageOutgoing01' icon.
  static const IconData strokeRoundedMessageOutgoing01 =
      IconData(0x4381, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageOutgoing02' icon.
  static const IconData strokeRoundedMessageOutgoing02 =
      IconData(0x4382, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessagePreview01' icon.
  static const IconData strokeRoundedMessagePreview01 =
      IconData(0x4383, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessagePreview02' icon.
  static const IconData strokeRoundedMessagePreview02 =
      IconData(0x4384, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageProgramming' icon.
  static const IconData strokeRoundedMessageProgramming =
      IconData(0x4385, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageQuestion' icon.
  static const IconData strokeRoundedMessageQuestion =
      IconData(0x4386, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageSearch01' icon.
  static const IconData strokeRoundedMessageSearch01 =
      IconData(0x4387, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageSearch02' icon.
  static const IconData strokeRoundedMessageSearch02 =
      IconData(0x4388, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageSecure01' icon.
  static const IconData strokeRoundedMessageSecure01 =
      IconData(0x4389, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageSecure02' icon.
  static const IconData strokeRoundedMessageSecure02 =
      IconData(0x438a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageTranslate' icon.
  static const IconData strokeRoundedMessageTranslate =
      IconData(0x438b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageUnlock01' icon.
  static const IconData strokeRoundedMessageUnlock01 =
      IconData(0x438c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageUnlock02' icon.
  static const IconData strokeRoundedMessageUnlock02 =
      IconData(0x438d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageUpload01' icon.
  static const IconData strokeRoundedMessageUpload01 =
      IconData(0x438e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageUpload02' icon.
  static const IconData strokeRoundedMessageUpload02 =
      IconData(0x438f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageUser01' icon.
  static const IconData strokeRoundedMessageUser01 =
      IconData(0x4390, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessageUser02' icon.
  static const IconData strokeRoundedMessageUser02 =
      IconData(0x4391, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMessenger' icon.
  static const IconData strokeRoundedMessenger =
      IconData(0x4392, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMeta' icon.
  static const IconData strokeRoundedMeta =
      IconData(0x4393, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMetro' icon.
  static const IconData strokeRoundedMetro =
      IconData(0x4394, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMic01' icon.
  static const IconData strokeRoundedMic01 =
      IconData(0x4395, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMic02' icon.
  static const IconData strokeRoundedMic02 =
      IconData(0x4396, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMicOff01' icon.
  static const IconData strokeRoundedMicOff01 =
      IconData(0x4397, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMicOff02' icon.
  static const IconData strokeRoundedMicOff02 =
      IconData(0x4398, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMicrosoftAdmin' icon.
  static const IconData strokeRoundedMicrosoftAdmin =
      IconData(0x4399, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMicrosoft' icon.
  static const IconData strokeRoundedMicrosoft =
      IconData(0x439a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMicrowave' icon.
  static const IconData strokeRoundedMicrowave =
      IconData(0x439b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMilkBottle' icon.
  static const IconData strokeRoundedMilkBottle =
      IconData(0x439c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMilkCarton' icon.
  static const IconData strokeRoundedMilkCarton =
      IconData(0x439d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMilkCoconut' icon.
  static const IconData strokeRoundedMilkCoconut =
      IconData(0x439e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMilkOat' icon.
  static const IconData strokeRoundedMilkOat =
      IconData(0x439f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMinimize01' icon.
  static const IconData strokeRoundedMinimize01 =
      IconData(0x43a0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMinimize02' icon.
  static const IconData strokeRoundedMinimize02 =
      IconData(0x43a1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMinimize03' icon.
  static const IconData strokeRoundedMinimize03 =
      IconData(0x43a2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMinimize04' icon.
  static const IconData strokeRoundedMinimize04 =
      IconData(0x43a3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMinimizeScreen' icon.
  static const IconData strokeRoundedMinimizeScreen =
      IconData(0x43a4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMining01' icon.
  static const IconData strokeRoundedMining01 =
      IconData(0x43a5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMining02' icon.
  static const IconData strokeRoundedMining02 =
      IconData(0x43a6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMining03' icon.
  static const IconData strokeRoundedMining03 =
      IconData(0x43a7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMinusPlus01' icon.
  static const IconData strokeRoundedMinusPlus01 =
      IconData(0x43a8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMinusPlus02' icon.
  static const IconData strokeRoundedMinusPlus02 =
      IconData(0x43a9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMinusPlusCircle01' icon.
  static const IconData strokeRoundedMinusPlusCircle01 =
      IconData(0x43aa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMinusPlusCircle02' icon.
  static const IconData strokeRoundedMinusPlusCircle02 =
      IconData(0x43ab, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMinusPlusSquare01' icon.
  static const IconData strokeRoundedMinusPlusSquare01 =
      IconData(0x43ac, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMinusPlusSquare02' icon.
  static const IconData strokeRoundedMinusPlusSquare02 =
      IconData(0x43ad, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMinusSignCircle' icon.
  static const IconData strokeRoundedMinusSignCircle =
      IconData(0x43ae, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMinusSignSquare' icon.
  static const IconData strokeRoundedMinusSignSquare =
      IconData(0x43af, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMinusSign' icon.
  static const IconData strokeRoundedMinusSign =
      IconData(0x43b0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMirror' icon.
  static const IconData strokeRoundedMirror =
      IconData(0x43b1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMirroringScreen' icon.
  static const IconData strokeRoundedMirroringScreen =
      IconData(0x43b2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMixer' icon.
  static const IconData strokeRoundedMixer =
      IconData(0x43b3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMobileNavigator01' icon.
  static const IconData strokeRoundedMobileNavigator01 =
      IconData(0x43b4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMobileNavigator02' icon.
  static const IconData strokeRoundedMobileNavigator02 =
      IconData(0x43b5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMobileProgramming01' icon.
  static const IconData strokeRoundedMobileProgramming01 =
      IconData(0x43b6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMobileProgramming02' icon.
  static const IconData strokeRoundedMobileProgramming02 =
      IconData(0x43b7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMobileProtection' icon.
  static const IconData strokeRoundedMobileProtection =
      IconData(0x43b8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMobileSecurity' icon.
  static const IconData strokeRoundedMobileSecurity =
      IconData(0x43b9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMochi' icon.
  static const IconData strokeRoundedMochi =
      IconData(0x43ba, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedModernTvFourK' icon.
  static const IconData strokeRoundedModernTvFourK =
      IconData(0x43bb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedModernTvIssue' icon.
  static const IconData strokeRoundedModernTvIssue =
      IconData(0x43bc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedModernTv' icon.
  static const IconData strokeRoundedModernTv =
      IconData(0x43bd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMolecules' icon.
  static const IconData strokeRoundedMolecules =
      IconData(0x43be, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMonas' icon.
  static const IconData strokeRoundedMonas =
      IconData(0x43bf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoney01' icon.
  static const IconData strokeRoundedMoney01 =
      IconData(0x43c0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoney02' icon.
  static const IconData strokeRoundedMoney02 =
      IconData(0x43c1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoney03' icon.
  static const IconData strokeRoundedMoney03 =
      IconData(0x43c2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoney04' icon.
  static const IconData strokeRoundedMoney04 =
      IconData(0x43c3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneyAdd01' icon.
  static const IconData strokeRoundedMoneyAdd01 =
      IconData(0x43c4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneyAdd02' icon.
  static const IconData strokeRoundedMoneyAdd02 =
      IconData(0x43c5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneyBag01' icon.
  static const IconData strokeRoundedMoneyBag01 =
      IconData(0x43c6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneyBag02' icon.
  static const IconData strokeRoundedMoneyBag02 =
      IconData(0x43c7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneyExchange01' icon.
  static const IconData strokeRoundedMoneyExchange01 =
      IconData(0x43c8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneyExchange02' icon.
  static const IconData strokeRoundedMoneyExchange02 =
      IconData(0x43c9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneyExchange03' icon.
  static const IconData strokeRoundedMoneyExchange03 =
      IconData(0x43ca, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneyNotFound01' icon.
  static const IconData strokeRoundedMoneyNotFound01 =
      IconData(0x43cb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneyNotFound02' icon.
  static const IconData strokeRoundedMoneyNotFound02 =
      IconData(0x43cc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneyNotFound03' icon.
  static const IconData strokeRoundedMoneyNotFound03 =
      IconData(0x43cd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneyNotFound04' icon.
  static const IconData strokeRoundedMoneyNotFound04 =
      IconData(0x43ce, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneyReceive01' icon.
  static const IconData strokeRoundedMoneyReceive01 =
      IconData(0x43cf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneyReceive02' icon.
  static const IconData strokeRoundedMoneyReceive02 =
      IconData(0x43d0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneyReceiveCircle' icon.
  static const IconData strokeRoundedMoneyReceiveCircle =
      IconData(0x43d1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneyReceiveFlow01' icon.
  static const IconData strokeRoundedMoneyReceiveFlow01 =
      IconData(0x43d2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneyReceiveFlow02' icon.
  static const IconData strokeRoundedMoneyReceiveFlow02 =
      IconData(0x43d3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneyReceiveSquare' icon.
  static const IconData strokeRoundedMoneyReceiveSquare =
      IconData(0x43d4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneyRemove01' icon.
  static const IconData strokeRoundedMoneyRemove01 =
      IconData(0x43d5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneyRemove02' icon.
  static const IconData strokeRoundedMoneyRemove02 =
      IconData(0x43d6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneySafe' icon.
  static const IconData strokeRoundedMoneySafe =
      IconData(0x43d7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneySavingJar' icon.
  static const IconData strokeRoundedMoneySavingJar =
      IconData(0x43d8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneySecurity' icon.
  static const IconData strokeRoundedMoneySecurity =
      IconData(0x43d9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneySend01' icon.
  static const IconData strokeRoundedMoneySend01 =
      IconData(0x43da, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneySend02' icon.
  static const IconData strokeRoundedMoneySend02 =
      IconData(0x43db, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneySendCircle' icon.
  static const IconData strokeRoundedMoneySendCircle =
      IconData(0x43dc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneySendFlow01' icon.
  static const IconData strokeRoundedMoneySendFlow01 =
      IconData(0x43dd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneySendFlow02' icon.
  static const IconData strokeRoundedMoneySendFlow02 =
      IconData(0x43de, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoneySendSquare' icon.
  static const IconData strokeRoundedMoneySendSquare =
      IconData(0x43df, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMonocle01' icon.
  static const IconData strokeRoundedMonocle01 =
      IconData(0x43e0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMonocle' icon.
  static const IconData strokeRoundedMonocle =
      IconData(0x43e1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMonster' icon.
  static const IconData strokeRoundedMonster =
      IconData(0x43e2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoon01' icon.
  static const IconData strokeRoundedMoon01 =
      IconData(0x43e3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoon02' icon.
  static const IconData strokeRoundedMoon02 =
      IconData(0x43e4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoonAngledRainZap' icon.
  static const IconData strokeRoundedMoonAngledRainZap =
      IconData(0x43e5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoonCloudAngledRain' icon.
  static const IconData strokeRoundedMoonCloudAngledRain =
      IconData(0x43e6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoonCloudAngledZap' icon.
  static const IconData strokeRoundedMoonCloudAngledZap =
      IconData(0x43e7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoonCloudBigRain' icon.
  static const IconData strokeRoundedMoonCloudBigRain =
      IconData(0x43e8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoonCloudFastWind' icon.
  static const IconData strokeRoundedMoonCloudFastWind =
      IconData(0x43e9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoonCloudHailstone' icon.
  static const IconData strokeRoundedMoonCloudHailstone =
      IconData(0x43ea, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoonCloudLittleRain' icon.
  static const IconData strokeRoundedMoonCloudLittleRain =
      IconData(0x43eb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoonCloudLittleSnow' icon.
  static const IconData strokeRoundedMoonCloudLittleSnow =
      IconData(0x43ec, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoonCloudMidRain' icon.
  static const IconData strokeRoundedMoonCloudMidRain =
      IconData(0x43ed, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoonCloudMidSnow' icon.
  static const IconData strokeRoundedMoonCloudMidSnow =
      IconData(0x43ee, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoonCloudSlowWind' icon.
  static const IconData strokeRoundedMoonCloudSlowWind =
      IconData(0x43ef, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoonCloudSnow' icon.
  static const IconData strokeRoundedMoonCloudSnow =
      IconData(0x43f0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoonCloud' icon.
  static const IconData strokeRoundedMoonCloud =
      IconData(0x43f1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoonEclipse' icon.
  static const IconData strokeRoundedMoonEclipse =
      IconData(0x43f2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoonFastWind' icon.
  static const IconData strokeRoundedMoonFastWind =
      IconData(0x43f3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoonLanding' icon.
  static const IconData strokeRoundedMoonLanding =
      IconData(0x43f4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoonSlowWind' icon.
  static const IconData strokeRoundedMoonSlowWind =
      IconData(0x43f5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoon' icon.
  static const IconData strokeRoundedMoon =
      IconData(0x43f6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoonset' icon.
  static const IconData strokeRoundedMoonset =
      IconData(0x43f7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMore01' icon.
  static const IconData strokeRoundedMore01 =
      IconData(0x43f8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMore02' icon.
  static const IconData strokeRoundedMore02 =
      IconData(0x43f9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMore03' icon.
  static const IconData strokeRoundedMore03 =
      IconData(0x43fa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoreHorizontalCircle01' icon.
  static const IconData strokeRoundedMoreHorizontalCircle01 =
      IconData(0x43fb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoreHorizontalCircle02' icon.
  static const IconData strokeRoundedMoreHorizontalCircle02 =
      IconData(0x43fc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoreHorizontalSquare01' icon.
  static const IconData strokeRoundedMoreHorizontalSquare01 =
      IconData(0x43fd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoreHorizontalSquare02' icon.
  static const IconData strokeRoundedMoreHorizontalSquare02 =
      IconData(0x43fe, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoreHorizontal' icon.
  static const IconData strokeRoundedMoreHorizontal =
      IconData(0x43ff, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoreOrLessCircle' icon.
  static const IconData strokeRoundedMoreOrLessCircle =
      IconData(0x4400, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoreOrLessSquare' icon.
  static const IconData strokeRoundedMoreOrLessSquare =
      IconData(0x4401, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoreOrLess' icon.
  static const IconData strokeRoundedMoreOrLess =
      IconData(0x4402, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoreVerticalCircle01' icon.
  static const IconData strokeRoundedMoreVerticalCircle01 =
      IconData(0x4403, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoreVerticalCircle02' icon.
  static const IconData strokeRoundedMoreVerticalCircle02 =
      IconData(0x4404, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoreVerticalSquare01' icon.
  static const IconData strokeRoundedMoreVerticalSquare01 =
      IconData(0x4405, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoreVerticalSquare02' icon.
  static const IconData strokeRoundedMoreVerticalSquare02 =
      IconData(0x4406, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoreVertical' icon.
  static const IconData strokeRoundedMoreVertical =
      IconData(0x4407, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMore' icon.
  static const IconData strokeRoundedMore =
      IconData(0x4408, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMortar' icon.
  static const IconData strokeRoundedMortar =
      IconData(0x4409, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMortarboard01' icon.
  static const IconData strokeRoundedMortarboard01 =
      IconData(0x440a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMortarboard02' icon.
  static const IconData strokeRoundedMortarboard02 =
      IconData(0x440b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMosque01' icon.
  static const IconData strokeRoundedMosque01 =
      IconData(0x440c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMosque02' icon.
  static const IconData strokeRoundedMosque02 =
      IconData(0x440d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMosque03' icon.
  static const IconData strokeRoundedMosque03 =
      IconData(0x440e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMosque04' icon.
  static const IconData strokeRoundedMosque04 =
      IconData(0x440f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMosque05' icon.
  static const IconData strokeRoundedMosque05 =
      IconData(0x4410, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMosqueLocation' icon.
  static const IconData strokeRoundedMosqueLocation =
      IconData(0x4411, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMotion01' icon.
  static const IconData strokeRoundedMotion01 =
      IconData(0x4412, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMotion02' icon.
  static const IconData strokeRoundedMotion02 =
      IconData(0x4413, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMotorbike01' icon.
  static const IconData strokeRoundedMotorbike01 =
      IconData(0x4414, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMotorbike02' icon.
  static const IconData strokeRoundedMotorbike02 =
      IconData(0x4415, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMountain' icon.
  static const IconData strokeRoundedMountain =
      IconData(0x4416, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouse01' icon.
  static const IconData strokeRoundedMouse01 =
      IconData(0x4417, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouse02' icon.
  static const IconData strokeRoundedMouse02 =
      IconData(0x4418, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouse03' icon.
  static const IconData strokeRoundedMouse03 =
      IconData(0x4419, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouse04' icon.
  static const IconData strokeRoundedMouse04 =
      IconData(0x441a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouse05' icon.
  static const IconData strokeRoundedMouse05 =
      IconData(0x441b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouse06' icon.
  static const IconData strokeRoundedMouse06 =
      IconData(0x441c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouse07' icon.
  static const IconData strokeRoundedMouse07 =
      IconData(0x441d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouse08' icon.
  static const IconData strokeRoundedMouse08 =
      IconData(0x441e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouse09' icon.
  static const IconData strokeRoundedMouse09 =
      IconData(0x441f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouse10' icon.
  static const IconData strokeRoundedMouse10 =
      IconData(0x4420, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouse11' icon.
  static const IconData strokeRoundedMouse11 =
      IconData(0x4421, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouse12' icon.
  static const IconData strokeRoundedMouse12 =
      IconData(0x4422, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouse13' icon.
  static const IconData strokeRoundedMouse13 =
      IconData(0x4423, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouse14' icon.
  static const IconData strokeRoundedMouse14 =
      IconData(0x4424, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouse15' icon.
  static const IconData strokeRoundedMouse15 =
      IconData(0x4425, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouse16' icon.
  static const IconData strokeRoundedMouse16 =
      IconData(0x4426, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouse17' icon.
  static const IconData strokeRoundedMouse17 =
      IconData(0x4427, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouse18' icon.
  static const IconData strokeRoundedMouse18 =
      IconData(0x4428, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouse19' icon.
  static const IconData strokeRoundedMouse19 =
      IconData(0x4429, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouse20' icon.
  static const IconData strokeRoundedMouse20 =
      IconData(0x442a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouse21' icon.
  static const IconData strokeRoundedMouse21 =
      IconData(0x442b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouse22' icon.
  static const IconData strokeRoundedMouse22 =
      IconData(0x442c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouse23' icon.
  static const IconData strokeRoundedMouse23 =
      IconData(0x442d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouseLeftClick01' icon.
  static const IconData strokeRoundedMouseLeftClick01 =
      IconData(0x442e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouseLeftClick02' icon.
  static const IconData strokeRoundedMouseLeftClick02 =
      IconData(0x442f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouseLeftClick03' icon.
  static const IconData strokeRoundedMouseLeftClick03 =
      IconData(0x4430, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouseLeftClick04' icon.
  static const IconData strokeRoundedMouseLeftClick04 =
      IconData(0x4431, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouseLeftClick05' icon.
  static const IconData strokeRoundedMouseLeftClick05 =
      IconData(0x4432, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouseLeftClick06' icon.
  static const IconData strokeRoundedMouseLeftClick06 =
      IconData(0x4433, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouseRightClick01' icon.
  static const IconData strokeRoundedMouseRightClick01 =
      IconData(0x4434, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouseRightClick02' icon.
  static const IconData strokeRoundedMouseRightClick02 =
      IconData(0x4435, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouseRightClick03' icon.
  static const IconData strokeRoundedMouseRightClick03 =
      IconData(0x4436, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouseRightClick04' icon.
  static const IconData strokeRoundedMouseRightClick04 =
      IconData(0x4437, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouseRightClick05' icon.
  static const IconData strokeRoundedMouseRightClick05 =
      IconData(0x4438, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouseRightClick06' icon.
  static const IconData strokeRoundedMouseRightClick06 =
      IconData(0x4439, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouseScroll01' icon.
  static const IconData strokeRoundedMouseScroll01 =
      IconData(0x443a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMouseScroll02' icon.
  static const IconData strokeRoundedMouseScroll02 =
      IconData(0x443b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMove01' icon.
  static const IconData strokeRoundedMove01 =
      IconData(0x443c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMove02' icon.
  static const IconData strokeRoundedMove02 =
      IconData(0x443d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoveBottom' icon.
  static const IconData strokeRoundedMoveBottom =
      IconData(0x443e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoveLeft' icon.
  static const IconData strokeRoundedMoveLeft =
      IconData(0x443f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoveRight' icon.
  static const IconData strokeRoundedMoveRight =
      IconData(0x4440, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoveTo' icon.
  static const IconData strokeRoundedMoveTo =
      IconData(0x4441, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMoveTop' icon.
  static const IconData strokeRoundedMoveTop =
      IconData(0x4442, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMove' icon.
  static const IconData strokeRoundedMove =
      IconData(0x4443, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMp301' icon.
  static const IconData strokeRoundedMp301 =
      IconData(0x4444, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMp302' icon.
  static const IconData strokeRoundedMp302 =
      IconData(0x4445, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMp401' icon.
  static const IconData strokeRoundedMp401 =
      IconData(0x4446, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMp402' icon.
  static const IconData strokeRoundedMp402 =
      IconData(0x4447, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMuhammad' icon.
  static const IconData strokeRoundedMuhammad =
      IconData(0x4448, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMultiplicationSignCircle' icon.
  static const IconData strokeRoundedMultiplicationSignCircle =
      IconData(0x4449, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMultiplicationSignSquare' icon.
  static const IconData strokeRoundedMultiplicationSignSquare =
      IconData(0x444a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMultiplicationSign' icon.
  static const IconData strokeRoundedMultiplicationSign =
      IconData(0x444b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMushroom01' icon.
  static const IconData strokeRoundedMushroom01 =
      IconData(0x444c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMushroom' icon.
  static const IconData strokeRoundedMushroom =
      IconData(0x444d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMusicNote01' icon.
  static const IconData strokeRoundedMusicNote01 =
      IconData(0x444e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMusicNote02' icon.
  static const IconData strokeRoundedMusicNote02 =
      IconData(0x444f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMusicNote03' icon.
  static const IconData strokeRoundedMusicNote03 =
      IconData(0x4450, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMusicNote04' icon.
  static const IconData strokeRoundedMusicNote04 =
      IconData(0x4451, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMusicNoteSquare01' icon.
  static const IconData strokeRoundedMusicNoteSquare01 =
      IconData(0x4452, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMusicNoteSquare02' icon.
  static const IconData strokeRoundedMusicNoteSquare02 =
      IconData(0x4453, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMuslim' icon.
  static const IconData strokeRoundedMuslim =
      IconData(0x4454, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMute' icon.
  static const IconData strokeRoundedMute =
      IconData(0x4455, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedMymind' icon.
  static const IconData strokeRoundedMymind =
      IconData(0x4456, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNThRootCircle' icon.
  static const IconData strokeRoundedNThRootCircle =
      IconData(0x4457, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNThRootSquare' icon.
  static const IconData strokeRoundedNThRootSquare =
      IconData(0x4458, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNThRoot' icon.
  static const IconData strokeRoundedNThRoot =
      IconData(0x4459, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNanoTechnology' icon.
  static const IconData strokeRoundedNanoTechnology =
      IconData(0x445a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNaturalFood' icon.
  static const IconData strokeRoundedNaturalFood =
      IconData(0x445b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNavigation01' icon.
  static const IconData strokeRoundedNavigation01 =
      IconData(0x445c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNavigation02' icon.
  static const IconData strokeRoundedNavigation02 =
      IconData(0x445d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNavigation03' icon.
  static const IconData strokeRoundedNavigation03 =
      IconData(0x445e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNavigation04' icon.
  static const IconData strokeRoundedNavigation04 =
      IconData(0x445f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNavigator01' icon.
  static const IconData strokeRoundedNavigator01 =
      IconData(0x4460, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNavigator02' icon.
  static const IconData strokeRoundedNavigator02 =
      IconData(0x4461, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNecklace' icon.
  static const IconData strokeRoundedNecklace =
      IconData(0x4462, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNerd' icon.
  static const IconData strokeRoundedNerd =
      IconData(0x4463, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNeuralNetwork' icon.
  static const IconData strokeRoundedNeuralNetwork =
      IconData(0x4464, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNeutral' icon.
  static const IconData strokeRoundedNeutral =
      IconData(0x4465, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNewJob' icon.
  static const IconData strokeRoundedNewJob =
      IconData(0x4466, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNewOffice' icon.
  static const IconData strokeRoundedNewOffice =
      IconData(0x4467, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNewReleases' icon.
  static const IconData strokeRoundedNewReleases =
      IconData(0x4468, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNewTwitterEllipse' icon.
  static const IconData strokeRoundedNewTwitterEllipse =
      IconData(0x4469, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNewTwitterRectangle' icon.
  static const IconData strokeRoundedNewTwitterRectangle =
      IconData(0x446a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNewTwitter' icon.
  static const IconData strokeRoundedNewTwitter =
      IconData(0x446b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNews01' icon.
  static const IconData strokeRoundedNews01 =
      IconData(0x446c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNews' icon.
  static const IconData strokeRoundedNews =
      IconData(0x446d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNext' icon.
  static const IconData strokeRoundedNext =
      IconData(0x446e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNike' icon.
  static const IconData strokeRoundedNike =
      IconData(0x446f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNintendoSwitch' icon.
  static const IconData strokeRoundedNintendoSwitch =
      IconData(0x4470, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNintendo' icon.
  static const IconData strokeRoundedNintendo =
      IconData(0x4471, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNiqab' icon.
  static const IconData strokeRoundedNiqab =
      IconData(0x4472, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNoInternet' icon.
  static const IconData strokeRoundedNoInternet =
      IconData(0x4473, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNoMeetingRoom' icon.
  static const IconData strokeRoundedNoMeetingRoom =
      IconData(0x4474, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNodeAdd' icon.
  static const IconData strokeRoundedNodeAdd =
      IconData(0x4475, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNodeEdit' icon.
  static const IconData strokeRoundedNodeEdit =
      IconData(0x4476, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNodeMoveDown' icon.
  static const IconData strokeRoundedNodeMoveDown =
      IconData(0x4477, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNodeMoveUp' icon.
  static const IconData strokeRoundedNodeMoveUp =
      IconData(0x4478, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNodeRemove' icon.
  static const IconData strokeRoundedNodeRemove =
      IconData(0x4479, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNoodles' icon.
  static const IconData strokeRoundedNoodles =
      IconData(0x447a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNose' icon.
  static const IconData strokeRoundedNose =
      IconData(0x447b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNotEqualSignCircle' icon.
  static const IconData strokeRoundedNotEqualSignCircle =
      IconData(0x447c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNotEqualSignSquare' icon.
  static const IconData strokeRoundedNotEqualSignSquare =
      IconData(0x447d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNotEqualSign' icon.
  static const IconData strokeRoundedNotEqualSign =
      IconData(0x447e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNote01' icon.
  static const IconData strokeRoundedNote01 =
      IconData(0x447f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNote02' icon.
  static const IconData strokeRoundedNote02 =
      IconData(0x4480, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNote03' icon.
  static const IconData strokeRoundedNote03 =
      IconData(0x4481, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNote04' icon.
  static const IconData strokeRoundedNote04 =
      IconData(0x4482, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNote05' icon.
  static const IconData strokeRoundedNote05 =
      IconData(0x4483, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNoteAdd' icon.
  static const IconData strokeRoundedNoteAdd =
      IconData(0x4484, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNoteDone' icon.
  static const IconData strokeRoundedNoteDone =
      IconData(0x4485, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNoteEdit' icon.
  static const IconData strokeRoundedNoteEdit =
      IconData(0x4486, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNoteRemove' icon.
  static const IconData strokeRoundedNoteRemove =
      IconData(0x4487, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNote' icon.
  static const IconData strokeRoundedNote =
      IconData(0x4488, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNotebook01' icon.
  static const IconData strokeRoundedNotebook01 =
      IconData(0x4489, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNotebook02' icon.
  static const IconData strokeRoundedNotebook02 =
      IconData(0x448a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNotebook' icon.
  static const IconData strokeRoundedNotebook =
      IconData(0x448b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNotification01' icon.
  static const IconData strokeRoundedNotification01 =
      IconData(0x448c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNotification02' icon.
  static const IconData strokeRoundedNotification02 =
      IconData(0x448d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNotification03' icon.
  static const IconData strokeRoundedNotification03 =
      IconData(0x448e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNotificationBlock01' icon.
  static const IconData strokeRoundedNotificationBlock01 =
      IconData(0x448f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNotificationBlock02' icon.
  static const IconData strokeRoundedNotificationBlock02 =
      IconData(0x4490, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNotificationBlock03' icon.
  static const IconData strokeRoundedNotificationBlock03 =
      IconData(0x4491, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNotificationBubble' icon.
  static const IconData strokeRoundedNotificationBubble =
      IconData(0x4492, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNotificationCircle' icon.
  static const IconData strokeRoundedNotificationCircle =
      IconData(0x4493, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNotificationOff01' icon.
  static const IconData strokeRoundedNotificationOff01 =
      IconData(0x4494, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNotificationOff02' icon.
  static const IconData strokeRoundedNotificationOff02 =
      IconData(0x4495, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNotificationOff03' icon.
  static const IconData strokeRoundedNotificationOff03 =
      IconData(0x4496, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNotificationSnooze01' icon.
  static const IconData strokeRoundedNotificationSnooze01 =
      IconData(0x4497, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNotificationSnooze02' icon.
  static const IconData strokeRoundedNotificationSnooze02 =
      IconData(0x4498, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNotificationSnooze03' icon.
  static const IconData strokeRoundedNotificationSnooze03 =
      IconData(0x4499, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNotificationSquare' icon.
  static const IconData strokeRoundedNotificationSquare =
      IconData(0x449a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNotion01' icon.
  static const IconData strokeRoundedNotion01 =
      IconData(0x449b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNotion02' icon.
  static const IconData strokeRoundedNotion02 =
      IconData(0x449c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNpm' icon.
  static const IconData strokeRoundedNpm =
      IconData(0x449d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNuclearPower' icon.
  static const IconData strokeRoundedNuclearPower =
      IconData(0x449e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedNut' icon.
  static const IconData strokeRoundedNut =
      IconData(0x449f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedObtuse' icon.
  static const IconData strokeRoundedObtuse =
      IconData(0x44a0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedOctagon' icon.
  static const IconData strokeRoundedOctagon =
      IconData(0x44a1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedOctopus' icon.
  static const IconData strokeRoundedOctopus =
      IconData(0x44a2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedOffice365' icon.
  static const IconData strokeRoundedOffice365 =
      IconData(0x44a3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedOfficeChair' icon.
  static const IconData strokeRoundedOfficeChair =
      IconData(0x44a4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedOffice' icon.
  static const IconData strokeRoundedOffice =
      IconData(0x44a5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedOilBarrel' icon.
  static const IconData strokeRoundedOilBarrel =
      IconData(0x44a6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedOkFinger' icon.
  static const IconData strokeRoundedOkFinger =
      IconData(0x44a7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedOlympicTorch' icon.
  static const IconData strokeRoundedOlympicTorch =
      IconData(0x44a8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedOnlineLearning01' icon.
  static const IconData strokeRoundedOnlineLearning01 =
      IconData(0x44a9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedOnlineLearning02' icon.
  static const IconData strokeRoundedOnlineLearning02 =
      IconData(0x44aa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedOnlineLearning03' icon.
  static const IconData strokeRoundedOnlineLearning03 =
      IconData(0x44ab, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedOnlineLearning04' icon.
  static const IconData strokeRoundedOnlineLearning04 =
      IconData(0x44ac, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedOpenCaption' icon.
  static const IconData strokeRoundedOpenCaption =
      IconData(0x44ad, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedOption' icon.
  static const IconData strokeRoundedOption =
      IconData(0x44ae, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedOrange' icon.
  static const IconData strokeRoundedOrange =
      IconData(0x44af, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedOrbit01' icon.
  static const IconData strokeRoundedOrbit01 =
      IconData(0x44b0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedOrbit02' icon.
  static const IconData strokeRoundedOrbit02 =
      IconData(0x44b1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedOrganicFood' icon.
  static const IconData strokeRoundedOrganicFood =
      IconData(0x44b2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedOrthogonalEdge' icon.
  static const IconData strokeRoundedOrthogonalEdge =
      IconData(0x44b3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedOval' icon.
  static const IconData strokeRoundedOval =
      IconData(0x44b4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedOven' icon.
  static const IconData strokeRoundedOven =
      IconData(0x44b5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPackageAdd' icon.
  static const IconData strokeRoundedPackageAdd =
      IconData(0x44b6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPackageDelivered' icon.
  static const IconData strokeRoundedPackageDelivered =
      IconData(0x44b7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPackageMoving' icon.
  static const IconData strokeRoundedPackageMoving =
      IconData(0x44b8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPackageOpen' icon.
  static const IconData strokeRoundedPackageOpen =
      IconData(0x44b9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPackageOutOfStock' icon.
  static const IconData strokeRoundedPackageOutOfStock =
      IconData(0x44ba, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPackageProcess' icon.
  static const IconData strokeRoundedPackageProcess =
      IconData(0x44bb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPackageReceive' icon.
  static const IconData strokeRoundedPackageReceive =
      IconData(0x44bc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPackageRemove' icon.
  static const IconData strokeRoundedPackageRemove =
      IconData(0x44bd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPackageSearch' icon.
  static const IconData strokeRoundedPackageSearch =
      IconData(0x44be, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPackageSent' icon.
  static const IconData strokeRoundedPackageSent =
      IconData(0x44bf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPackage' icon.
  static const IconData strokeRoundedPackage =
      IconData(0x44c0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPacman01' icon.
  static const IconData strokeRoundedPacman01 =
      IconData(0x44c1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPacman02' icon.
  static const IconData strokeRoundedPacman02 =
      IconData(0x44c2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPaintBoard' icon.
  static const IconData strokeRoundedPaintBoard =
      IconData(0x44c3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPaintBrush01' icon.
  static const IconData strokeRoundedPaintBrush01 =
      IconData(0x44c4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPaintBrush02' icon.
  static const IconData strokeRoundedPaintBrush02 =
      IconData(0x44c5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPaintBrush03' icon.
  static const IconData strokeRoundedPaintBrush03 =
      IconData(0x44c6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPaintBrush04' icon.
  static const IconData strokeRoundedPaintBrush04 =
      IconData(0x44c7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPaintBucket' icon.
  static const IconData strokeRoundedPaintBucket =
      IconData(0x44c8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPan01' icon.
  static const IconData strokeRoundedPan01 =
      IconData(0x44c9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPan02' icon.
  static const IconData strokeRoundedPan02 =
      IconData(0x44ca, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPan03' icon.
  static const IconData strokeRoundedPan03 =
      IconData(0x44cb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedParabola01' icon.
  static const IconData strokeRoundedParabola01 =
      IconData(0x44cc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedParabola02' icon.
  static const IconData strokeRoundedParabola02 =
      IconData(0x44cd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedParabola03' icon.
  static const IconData strokeRoundedParabola03 =
      IconData(0x44ce, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedParagliding' icon.
  static const IconData strokeRoundedParagliding =
      IconData(0x44cf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedParagraphBulletsPoint01' icon.
  static const IconData strokeRoundedParagraphBulletsPoint01 =
      IconData(0x44d0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedParagraphBulletsPoint02' icon.
  static const IconData strokeRoundedParagraphBulletsPoint02 =
      IconData(0x44d1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedParagraphSpacing' icon.
  static const IconData strokeRoundedParagraphSpacing =
      IconData(0x44d2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedParagraph' icon.
  static const IconData strokeRoundedParagraph =
      IconData(0x44d3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedParallelogram' icon.
  static const IconData strokeRoundedParallelogram =
      IconData(0x44d4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedParkingAreaCircle' icon.
  static const IconData strokeRoundedParkingAreaCircle =
      IconData(0x44d5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedParkingAreaSquare' icon.
  static const IconData strokeRoundedParkingAreaSquare =
      IconData(0x44d6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPassport01' icon.
  static const IconData strokeRoundedPassport01 =
      IconData(0x44d7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPassportExpired' icon.
  static const IconData strokeRoundedPassportExpired =
      IconData(0x44d8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPassportValid' icon.
  static const IconData strokeRoundedPassportValid =
      IconData(0x44d9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPassport' icon.
  static const IconData strokeRoundedPassport =
      IconData(0x44da, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPasswordValidation' icon.
  static const IconData strokeRoundedPasswordValidation =
      IconData(0x44db, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPath' icon.
  static const IconData strokeRoundedPath =
      IconData(0x44dc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPathfinderCrop' icon.
  static const IconData strokeRoundedPathfinderCrop =
      IconData(0x44dd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPathfinderDivide' icon.
  static const IconData strokeRoundedPathfinderDivide =
      IconData(0x44de, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPathfinderExclude' icon.
  static const IconData strokeRoundedPathfinderExclude =
      IconData(0x44df, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPathfinderIntersect' icon.
  static const IconData strokeRoundedPathfinderIntersect =
      IconData(0x44e0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPathfinderMerge' icon.
  static const IconData strokeRoundedPathfinderMerge =
      IconData(0x44e1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPathfinderMinusBack' icon.
  static const IconData strokeRoundedPathfinderMinusBack =
      IconData(0x44e2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPathfinderMinusFront' icon.
  static const IconData strokeRoundedPathfinderMinusFront =
      IconData(0x44e3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPathfinderOutline' icon.
  static const IconData strokeRoundedPathfinderOutline =
      IconData(0x44e4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPathfinderTrim' icon.
  static const IconData strokeRoundedPathfinderTrim =
      IconData(0x44e5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPathfinderUnite' icon.
  static const IconData strokeRoundedPathfinderUnite =
      IconData(0x44e6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPatient' icon.
  static const IconData strokeRoundedPatient =
      IconData(0x44e7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPatio' icon.
  static const IconData strokeRoundedPatio =
      IconData(0x44e8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPause' icon.
  static const IconData strokeRoundedPause =
      IconData(0x44e9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPavilon' icon.
  static const IconData strokeRoundedPavilon =
      IconData(0x44ea, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPayByCheck' icon.
  static const IconData strokeRoundedPayByCheck =
      IconData(0x44eb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPayment01' icon.
  static const IconData strokeRoundedPayment01 =
      IconData(0x44ec, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPayment02' icon.
  static const IconData strokeRoundedPayment02 =
      IconData(0x44ed, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPaymentSuccess01' icon.
  static const IconData strokeRoundedPaymentSuccess01 =
      IconData(0x44ee, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPaymentSuccess02' icon.
  static const IconData strokeRoundedPaymentSuccess02 =
      IconData(0x44ef, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPayoneer' icon.
  static const IconData strokeRoundedPayoneer =
      IconData(0x44f0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPaypal' icon.
  static const IconData strokeRoundedPaypal =
      IconData(0x44f1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPdf01' icon.
  static const IconData strokeRoundedPdf01 =
      IconData(0x44f2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPdf02' icon.
  static const IconData strokeRoundedPdf02 =
      IconData(0x44f3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPeerToPeer01' icon.
  static const IconData strokeRoundedPeerToPeer01 =
      IconData(0x44f4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPeerToPeer02' icon.
  static const IconData strokeRoundedPeerToPeer02 =
      IconData(0x44f5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPeerToPeer03' icon.
  static const IconData strokeRoundedPeerToPeer03 =
      IconData(0x44f6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPenConnectBluetooth' icon.
  static const IconData strokeRoundedPenConnectBluetooth =
      IconData(0x44f7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPenConnectUsb' icon.
  static const IconData strokeRoundedPenConnectUsb =
      IconData(0x44f8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPenConnectWifi' icon.
  static const IconData strokeRoundedPenConnectWifi =
      IconData(0x44f9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPenTool01' icon.
  static const IconData strokeRoundedPenTool01 =
      IconData(0x44fa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPenTool02' icon.
  static const IconData strokeRoundedPenTool02 =
      IconData(0x44fb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPenTool03' icon.
  static const IconData strokeRoundedPenTool03 =
      IconData(0x44fc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPenToolAdd' icon.
  static const IconData strokeRoundedPenToolAdd =
      IconData(0x44fd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPenToolMinus' icon.
  static const IconData strokeRoundedPenToolMinus =
      IconData(0x44fe, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPencilEdit01' icon.
  static const IconData strokeRoundedPencilEdit01 =
      IconData(0x44ff, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPencilEdit02' icon.
  static const IconData strokeRoundedPencilEdit02 =
      IconData(0x4500, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPencil' icon.
  static const IconData strokeRoundedPencil =
      IconData(0x4501, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPendulum' icon.
  static const IconData strokeRoundedPendulum =
      IconData(0x4502, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPensive' icon.
  static const IconData strokeRoundedPensive =
      IconData(0x4503, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPentagon01' icon.
  static const IconData strokeRoundedPentagon01 =
      IconData(0x4504, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPentagon' icon.
  static const IconData strokeRoundedPentagon =
      IconData(0x4505, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPercentCircle' icon.
  static const IconData strokeRoundedPercentCircle =
      IconData(0x4506, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPercentSquare' icon.
  static const IconData strokeRoundedPercentSquare =
      IconData(0x4507, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPercent' icon.
  static const IconData strokeRoundedPercent =
      IconData(0x4508, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPerfume' icon.
  static const IconData strokeRoundedPerfume =
      IconData(0x4509, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPeriscope' icon.
  static const IconData strokeRoundedPeriscope =
      IconData(0x450a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPermanentJob' icon.
  static const IconData strokeRoundedPermanentJob =
      IconData(0x450b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPerspective' icon.
  static const IconData strokeRoundedPerspective =
      IconData(0x450c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPexels' icon.
  static const IconData strokeRoundedPexels =
      IconData(0x450d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPhoneOff01' icon.
  static const IconData strokeRoundedPhoneOff01 =
      IconData(0x450e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPhoneOff02' icon.
  static const IconData strokeRoundedPhoneOff02 =
      IconData(0x450f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPhp' icon.
  static const IconData strokeRoundedPhp =
      IconData(0x4510, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPhysics' icon.
  static const IconData strokeRoundedPhysics =
      IconData(0x4511, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPiCircle' icon.
  static const IconData strokeRoundedPiCircle =
      IconData(0x4512, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPiSquare' icon.
  static const IconData strokeRoundedPiSquare =
      IconData(0x4513, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPi' icon.
  static const IconData strokeRoundedPi =
      IconData(0x4514, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPicasa' icon.
  static const IconData strokeRoundedPicasa =
      IconData(0x4515, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPickup01' icon.
  static const IconData strokeRoundedPickup01 =
      IconData(0x4516, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPickup02' icon.
  static const IconData strokeRoundedPickup02 =
      IconData(0x4517, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPictureInPictureExit' icon.
  static const IconData strokeRoundedPictureInPictureExit =
      IconData(0x4518, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPictureInPictureOn' icon.
  static const IconData strokeRoundedPictureInPictureOn =
      IconData(0x4519, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPieChartSquare' icon.
  static const IconData strokeRoundedPieChartSquare =
      IconData(0x451a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPieChart' icon.
  static const IconData strokeRoundedPieChart =
      IconData(0x451b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPie' icon.
  static const IconData strokeRoundedPie =
      IconData(0x451c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPiggyBank' icon.
  static const IconData strokeRoundedPiggyBank =
      IconData(0x451d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPinCode' icon.
  static const IconData strokeRoundedPinCode =
      IconData(0x451e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPinLocation01' icon.
  static const IconData strokeRoundedPinLocation01 =
      IconData(0x451f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPinLocation02' icon.
  static const IconData strokeRoundedPinLocation02 =
      IconData(0x4520, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPinLocation03' icon.
  static const IconData strokeRoundedPinLocation03 =
      IconData(0x4521, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPinOff' icon.
  static const IconData strokeRoundedPinOff =
      IconData(0x4522, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPin' icon.
  static const IconData strokeRoundedPin =
      IconData(0x4523, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPinterest' icon.
  static const IconData strokeRoundedPinterest =
      IconData(0x4524, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPipeline' icon.
  static const IconData strokeRoundedPipeline =
      IconData(0x4525, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPisaTower' icon.
  static const IconData strokeRoundedPisaTower =
      IconData(0x4526, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPizza01' icon.
  static const IconData strokeRoundedPizza01 =
      IconData(0x4527, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPizza02' icon.
  static const IconData strokeRoundedPizza02 =
      IconData(0x4528, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPizzaCutter' icon.
  static const IconData strokeRoundedPizzaCutter =
      IconData(0x4529, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlane' icon.
  static const IconData strokeRoundedPlane =
      IconData(0x452a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlant01' icon.
  static const IconData strokeRoundedPlant01 =
      IconData(0x452b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlant02' icon.
  static const IconData strokeRoundedPlant02 =
      IconData(0x452c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlant03' icon.
  static const IconData strokeRoundedPlant03 =
      IconData(0x452d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlant04' icon.
  static const IconData strokeRoundedPlant04 =
      IconData(0x452e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlate' icon.
  static const IconData strokeRoundedPlate =
      IconData(0x452f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlaxo' icon.
  static const IconData strokeRoundedPlaxo =
      IconData(0x4530, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlayCircle02' icon.
  static const IconData strokeRoundedPlayCircle02 =
      IconData(0x4531, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlayCircle' icon.
  static const IconData strokeRoundedPlayCircle =
      IconData(0x4532, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlayListAdd' icon.
  static const IconData strokeRoundedPlayListAdd =
      IconData(0x4533, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlayListFavourite01' icon.
  static const IconData strokeRoundedPlayListFavourite01 =
      IconData(0x4534, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlayListFavourite02' icon.
  static const IconData strokeRoundedPlayListFavourite02 =
      IconData(0x4535, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlayListMinus' icon.
  static const IconData strokeRoundedPlayListMinus =
      IconData(0x4536, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlayListRemove' icon.
  static const IconData strokeRoundedPlayListRemove =
      IconData(0x4537, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlayList' icon.
  static const IconData strokeRoundedPlayList =
      IconData(0x4538, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlaySquare' icon.
  static const IconData strokeRoundedPlaySquare =
      IconData(0x4539, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlayStore' icon.
  static const IconData strokeRoundedPlayStore =
      IconData(0x453a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlay' icon.
  static const IconData strokeRoundedPlay =
      IconData(0x453b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlaylist01' icon.
  static const IconData strokeRoundedPlaylist01 =
      IconData(0x453c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlaylist02' icon.
  static const IconData strokeRoundedPlaylist02 =
      IconData(0x453d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlaylist03' icon.
  static const IconData strokeRoundedPlaylist03 =
      IconData(0x453e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlaza' icon.
  static const IconData strokeRoundedPlaza =
      IconData(0x453f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlug01' icon.
  static const IconData strokeRoundedPlug01 =
      IconData(0x4540, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlug02' icon.
  static const IconData strokeRoundedPlug02 =
      IconData(0x4541, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlugSocket' icon.
  static const IconData strokeRoundedPlugSocket =
      IconData(0x4542, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlusMinus01' icon.
  static const IconData strokeRoundedPlusMinus01 =
      IconData(0x4543, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlusMinus02' icon.
  static const IconData strokeRoundedPlusMinus02 =
      IconData(0x4544, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlusMinusCircle01' icon.
  static const IconData strokeRoundedPlusMinusCircle01 =
      IconData(0x4545, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlusMinusCircle02' icon.
  static const IconData strokeRoundedPlusMinusCircle02 =
      IconData(0x4546, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlusMinusSquare01' icon.
  static const IconData strokeRoundedPlusMinusSquare01 =
      IconData(0x4547, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlusMinusSquare02' icon.
  static const IconData strokeRoundedPlusMinusSquare02 =
      IconData(0x4548, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlusMinus' icon.
  static const IconData strokeRoundedPlusMinus =
      IconData(0x4549, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlusSignCircle' icon.
  static const IconData strokeRoundedPlusSignCircle =
      IconData(0x454a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlusSignSquare' icon.
  static const IconData strokeRoundedPlusSignSquare =
      IconData(0x454b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPlusSign' icon.
  static const IconData strokeRoundedPlusSign =
      IconData(0x454c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPng01' icon.
  static const IconData strokeRoundedPng01 =
      IconData(0x454d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPng02' icon.
  static const IconData strokeRoundedPng02 =
      IconData(0x454e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPodium' icon.
  static const IconData strokeRoundedPodium =
      IconData(0x454f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPointingLeft01' icon.
  static const IconData strokeRoundedPointingLeft01 =
      IconData(0x4550, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPointingLeft02' icon.
  static const IconData strokeRoundedPointingLeft02 =
      IconData(0x4551, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPointingLeft03' icon.
  static const IconData strokeRoundedPointingLeft03 =
      IconData(0x4552, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPointingLeft04' icon.
  static const IconData strokeRoundedPointingLeft04 =
      IconData(0x4553, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPointingLeft05' icon.
  static const IconData strokeRoundedPointingLeft05 =
      IconData(0x4554, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPointingLeft06' icon.
  static const IconData strokeRoundedPointingLeft06 =
      IconData(0x4555, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPointingLeft07' icon.
  static const IconData strokeRoundedPointingLeft07 =
      IconData(0x4556, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPointingLeft08' icon.
  static const IconData strokeRoundedPointingLeft08 =
      IconData(0x4557, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPointingRight01' icon.
  static const IconData strokeRoundedPointingRight01 =
      IconData(0x4558, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPointingRight02' icon.
  static const IconData strokeRoundedPointingRight02 =
      IconData(0x4559, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPointingRight03' icon.
  static const IconData strokeRoundedPointingRight03 =
      IconData(0x455a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPointingRight04' icon.
  static const IconData strokeRoundedPointingRight04 =
      IconData(0x455b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPointingRight05' icon.
  static const IconData strokeRoundedPointingRight05 =
      IconData(0x455c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPointingRight06' icon.
  static const IconData strokeRoundedPointingRight06 =
      IconData(0x455d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPointingRight07' icon.
  static const IconData strokeRoundedPointingRight07 =
      IconData(0x455e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPointingRight08' icon.
  static const IconData strokeRoundedPointingRight08 =
      IconData(0x455f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPokeball' icon.
  static const IconData strokeRoundedPokeball =
      IconData(0x4560, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPokemon' icon.
  static const IconData strokeRoundedPokemon =
      IconData(0x4561, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPoliceBadge' icon.
  static const IconData strokeRoundedPoliceBadge =
      IconData(0x4562, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPoliceCap' icon.
  static const IconData strokeRoundedPoliceCap =
      IconData(0x4563, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPoliceCar' icon.
  static const IconData strokeRoundedPoliceCar =
      IconData(0x4564, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPoliceStation' icon.
  static const IconData strokeRoundedPoliceStation =
      IconData(0x4565, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPolicy' icon.
  static const IconData strokeRoundedPolicy =
      IconData(0x4566, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPolygon' icon.
  static const IconData strokeRoundedPolygon =
      IconData(0x4567, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPoolTable' icon.
  static const IconData strokeRoundedPoolTable =
      IconData(0x4568, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPool' icon.
  static const IconData strokeRoundedPool =
      IconData(0x4569, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPoop' icon.
  static const IconData strokeRoundedPoop =
      IconData(0x456a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPopcorn' icon.
  static const IconData strokeRoundedPopcorn =
      IconData(0x456b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPot01' icon.
  static const IconData strokeRoundedPot01 =
      IconData(0x456c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPot02' icon.
  static const IconData strokeRoundedPot02 =
      IconData(0x456d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPotion' icon.
  static const IconData strokeRoundedPotion =
      IconData(0x456e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPoundCircle' icon.
  static const IconData strokeRoundedPoundCircle =
      IconData(0x456f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPoundReceive' icon.
  static const IconData strokeRoundedPoundReceive =
      IconData(0x4570, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPoundSend' icon.
  static const IconData strokeRoundedPoundSend =
      IconData(0x4571, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPoundSquare' icon.
  static const IconData strokeRoundedPoundSquare =
      IconData(0x4572, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPound' icon.
  static const IconData strokeRoundedPound =
      IconData(0x4573, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPowerService' icon.
  static const IconData strokeRoundedPowerService =
      IconData(0x4574, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPowerSocket01' icon.
  static const IconData strokeRoundedPowerSocket01 =
      IconData(0x4575, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPowerSocket02' icon.
  static const IconData strokeRoundedPowerSocket02 =
      IconData(0x4576, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPpt01' icon.
  static const IconData strokeRoundedPpt01 =
      IconData(0x4577, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPpt02' icon.
  static const IconData strokeRoundedPpt02 =
      IconData(0x4578, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPrawn' icon.
  static const IconData strokeRoundedPrawn =
      IconData(0x4579, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPrayerRug01' icon.
  static const IconData strokeRoundedPrayerRug01 =
      IconData(0x457a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPrayerRug02' icon.
  static const IconData strokeRoundedPrayerRug02 =
      IconData(0x457b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPreferenceHorizontal' icon.
  static const IconData strokeRoundedPreferenceHorizontal =
      IconData(0x457c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPreferenceVertical' icon.
  static const IconData strokeRoundedPreferenceVertical =
      IconData(0x457d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPrescription' icon.
  static const IconData strokeRoundedPrescription =
      IconData(0x457e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPresentation01' icon.
  static const IconData strokeRoundedPresentation01 =
      IconData(0x457f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPresentation02' icon.
  static const IconData strokeRoundedPresentation02 =
      IconData(0x4580, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPresentation03' icon.
  static const IconData strokeRoundedPresentation03 =
      IconData(0x4581, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPresentation04' icon.
  static const IconData strokeRoundedPresentation04 =
      IconData(0x4582, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPresentation05' icon.
  static const IconData strokeRoundedPresentation05 =
      IconData(0x4583, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPresentation06' icon.
  static const IconData strokeRoundedPresentation06 =
      IconData(0x4584, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPresentation07' icon.
  static const IconData strokeRoundedPresentation07 =
      IconData(0x4585, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPresentationBarChart01' icon.
  static const IconData strokeRoundedPresentationBarChart01 =
      IconData(0x4586, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPresentationBarChart02' icon.
  static const IconData strokeRoundedPresentationBarChart02 =
      IconData(0x4587, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPresentationLineChart01' icon.
  static const IconData strokeRoundedPresentationLineChart01 =
      IconData(0x4588, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPresentationLineChart02' icon.
  static const IconData strokeRoundedPresentationLineChart02 =
      IconData(0x4589, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPresentationOnline' icon.
  static const IconData strokeRoundedPresentationOnline =
      IconData(0x458a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPresentationPodium' icon.
  static const IconData strokeRoundedPresentationPodium =
      IconData(0x458b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPrevious' icon.
  static const IconData strokeRoundedPrevious =
      IconData(0x458c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPrinterOff' icon.
  static const IconData strokeRoundedPrinterOff =
      IconData(0x458d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPrinter' icon.
  static const IconData strokeRoundedPrinter =
      IconData(0x458e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPrism01' icon.
  static const IconData strokeRoundedPrism01 =
      IconData(0x458f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPrism' icon.
  static const IconData strokeRoundedPrism =
      IconData(0x4590, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPrisonGuard' icon.
  static const IconData strokeRoundedPrisonGuard =
      IconData(0x4591, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPrison' icon.
  static const IconData strokeRoundedPrison =
      IconData(0x4592, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPrisoner' icon.
  static const IconData strokeRoundedPrisoner =
      IconData(0x4593, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedProductLoading' icon.
  static const IconData strokeRoundedProductLoading =
      IconData(0x4594, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedProfile02' icon.
  static const IconData strokeRoundedProfile02 =
      IconData(0x4595, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedProfile' icon.
  static const IconData strokeRoundedProfile =
      IconData(0x4596, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedProfit' icon.
  static const IconData strokeRoundedProfit =
      IconData(0x4597, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedProgrammingFlag' icon.
  static const IconData strokeRoundedProgrammingFlag =
      IconData(0x4598, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedProjector01' icon.
  static const IconData strokeRoundedProjector01 =
      IconData(0x4599, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedProjector' icon.
  static const IconData strokeRoundedProjector =
      IconData(0x459a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPromotion' icon.
  static const IconData strokeRoundedPromotion =
      IconData(0x459b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPropertyAdd' icon.
  static const IconData strokeRoundedPropertyAdd =
      IconData(0x459c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPropertyDelete' icon.
  static const IconData strokeRoundedPropertyDelete =
      IconData(0x459d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPropertyEdit' icon.
  static const IconData strokeRoundedPropertyEdit =
      IconData(0x459e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPropertyNew' icon.
  static const IconData strokeRoundedPropertyNew =
      IconData(0x459f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPropertySearch' icon.
  static const IconData strokeRoundedPropertySearch =
      IconData(0x45a0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPropertyView' icon.
  static const IconData strokeRoundedPropertyView =
      IconData(0x45a1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedProtectionMask' icon.
  static const IconData strokeRoundedProtectionMask =
      IconData(0x45a2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPulley' icon.
  static const IconData strokeRoundedPulley =
      IconData(0x45a3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPulse01' icon.
  static const IconData strokeRoundedPulse01 =
      IconData(0x45a4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPulse02' icon.
  static const IconData strokeRoundedPulse02 =
      IconData(0x45a5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPulseRectangle01' icon.
  static const IconData strokeRoundedPulseRectangle01 =
      IconData(0x45a6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPulseRectangle02' icon.
  static const IconData strokeRoundedPulseRectangle02 =
      IconData(0x45a7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPumpkin' icon.
  static const IconData strokeRoundedPumpkin =
      IconData(0x45a8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPunch' icon.
  static const IconData strokeRoundedPunch =
      IconData(0x45a9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPunchingBall01' icon.
  static const IconData strokeRoundedPunchingBall01 =
      IconData(0x45aa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPunchingBall02' icon.
  static const IconData strokeRoundedPunchingBall02 =
      IconData(0x45ab, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPurse01' icon.
  static const IconData strokeRoundedPurse01 =
      IconData(0x45ac, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPurse' icon.
  static const IconData strokeRoundedPurse =
      IconData(0x45ad, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPushUpBar' icon.
  static const IconData strokeRoundedPushUpBar =
      IconData(0x45ae, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPuzzle' icon.
  static const IconData strokeRoundedPuzzle =
      IconData(0x45af, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPyramidMaslowo' icon.
  static const IconData strokeRoundedPyramidMaslowo =
      IconData(0x45b0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPyramidStructure01' icon.
  static const IconData strokeRoundedPyramidStructure01 =
      IconData(0x45b1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPyramidStructure02' icon.
  static const IconData strokeRoundedPyramidStructure02 =
      IconData(0x45b2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedPyramid' icon.
  static const IconData strokeRoundedPyramid =
      IconData(0x45b3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedQqPlot' icon.
  static const IconData strokeRoundedQqPlot =
      IconData(0x45b4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedQrCode01' icon.
  static const IconData strokeRoundedQrCode01 =
      IconData(0x45b5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedQrCode' icon.
  static const IconData strokeRoundedQrCode =
      IconData(0x45b6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedQuestion' icon.
  static const IconData strokeRoundedQuestion =
      IconData(0x45b7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedQueue01' icon.
  static const IconData strokeRoundedQueue01 =
      IconData(0x45b8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedQueue02' icon.
  static const IconData strokeRoundedQueue02 =
      IconData(0x45b9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedQuillWrite01' icon.
  static const IconData strokeRoundedQuillWrite01 =
      IconData(0x45ba, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedQuillWrite02' icon.
  static const IconData strokeRoundedQuillWrite02 =
      IconData(0x45bb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedQuiz01' icon.
  static const IconData strokeRoundedQuiz01 =
      IconData(0x45bc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedQuiz02' icon.
  static const IconData strokeRoundedQuiz02 =
      IconData(0x45bd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedQuiz03' icon.
  static const IconData strokeRoundedQuiz03 =
      IconData(0x45be, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedQuiz04' icon.
  static const IconData strokeRoundedQuiz04 =
      IconData(0x45bf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedQuiz05' icon.
  static const IconData strokeRoundedQuiz05 =
      IconData(0x45c0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedQuora' icon.
  static const IconData strokeRoundedQuora =
      IconData(0x45c1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedQuoteDownCircle' icon.
  static const IconData strokeRoundedQuoteDownCircle =
      IconData(0x45c2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedQuoteDownSquare' icon.
  static const IconData strokeRoundedQuoteDownSquare =
      IconData(0x45c3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedQuoteDown' icon.
  static const IconData strokeRoundedQuoteDown =
      IconData(0x45c4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedQuoteUpCircle' icon.
  static const IconData strokeRoundedQuoteUpCircle =
      IconData(0x45c5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedQuoteUpSquare' icon.
  static const IconData strokeRoundedQuoteUpSquare =
      IconData(0x45c6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedQuoteUp' icon.
  static const IconData strokeRoundedQuoteUp =
      IconData(0x45c7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedQuotes' icon.
  static const IconData strokeRoundedQuotes =
      IconData(0x45c8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedQuran01' icon.
  static const IconData strokeRoundedQuran01 =
      IconData(0x45c9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedQuran02' icon.
  static const IconData strokeRoundedQuran02 =
      IconData(0x45ca, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedQuran03' icon.
  static const IconData strokeRoundedQuran03 =
      IconData(0x45cb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRacingFlag' icon.
  static const IconData strokeRoundedRacingFlag =
      IconData(0x45cc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRadar01' icon.
  static const IconData strokeRoundedRadar01 =
      IconData(0x45cd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRadar02' icon.
  static const IconData strokeRoundedRadar02 =
      IconData(0x45ce, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRadial' icon.
  static const IconData strokeRoundedRadial =
      IconData(0x45cf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRadio01' icon.
  static const IconData strokeRoundedRadio01 =
      IconData(0x45d0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRadio02' icon.
  static const IconData strokeRoundedRadio02 =
      IconData(0x45d1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRadio' icon.
  static const IconData strokeRoundedRadio =
      IconData(0x45d2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRadioactiveAlert' icon.
  static const IconData strokeRoundedRadioactiveAlert =
      IconData(0x45d3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRadius' icon.
  static const IconData strokeRoundedRadius =
      IconData(0x45d4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRainDoubleDrop' icon.
  static const IconData strokeRoundedRainDoubleDrop =
      IconData(0x45d5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRainDrop' icon.
  static const IconData strokeRoundedRainDrop =
      IconData(0x45d6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRain' icon.
  static const IconData strokeRoundedRain =
      IconData(0x45d7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRainbow' icon.
  static const IconData strokeRoundedRainbow =
      IconData(0x45d8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRamadhan01' icon.
  static const IconData strokeRoundedRamadhan01 =
      IconData(0x45d9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRamadhan02' icon.
  static const IconData strokeRoundedRamadhan02 =
      IconData(0x45da, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRamadhanMonth' icon.
  static const IconData strokeRoundedRamadhanMonth =
      IconData(0x45db, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRanking' icon.
  static const IconData strokeRoundedRanking =
      IconData(0x45dc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRaw01' icon.
  static const IconData strokeRoundedRaw01 =
      IconData(0x45dd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRaw02' icon.
  static const IconData strokeRoundedRaw02 =
      IconData(0x45de, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedReact' icon.
  static const IconData strokeRoundedReact =
      IconData(0x45e0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRealEstate01' icon.
  static const IconData strokeRoundedRealEstate01 =
      IconData(0x45e1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRealEstate02' icon.
  static const IconData strokeRoundedRealEstate02 =
      IconData(0x45e2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRecord' icon.
  static const IconData strokeRoundedRecord =
      IconData(0x45e3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRecoveryMail' icon.
  static const IconData strokeRoundedRecoveryMail =
      IconData(0x45e4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRectangular01' icon.
  static const IconData strokeRoundedRectangular01 =
      IconData(0x45e5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRectangular' icon.
  static const IconData strokeRoundedRectangular =
      IconData(0x45e6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRecycle01' icon.
  static const IconData strokeRoundedRecycle01 =
      IconData(0x45e7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRecycle02' icon.
  static const IconData strokeRoundedRecycle02 =
      IconData(0x45e8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRecycle03' icon.
  static const IconData strokeRoundedRecycle03 =
      IconData(0x45e9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedReddit' icon.
  static const IconData strokeRoundedReddit =
      IconData(0x45ea, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedReflex' icon.
  static const IconData strokeRoundedReflex =
      IconData(0x45eb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRefresh' icon.
  static const IconData strokeRoundedRefresh =
      IconData(0x45ec, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRefrigerator' icon.
  static const IconData strokeRoundedRefrigerator =
      IconData(0x45ed, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRegister' icon.
  static const IconData strokeRoundedRegister =
      IconData(0x45ee, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRegistered' icon.
  static const IconData strokeRoundedRegistered =
      IconData(0x45ef, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRelieved01' icon.
  static const IconData strokeRoundedRelieved01 =
      IconData(0x45f0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRelieved02' icon.
  static const IconData strokeRoundedRelieved02 =
      IconData(0x45f1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedReload' icon.
  static const IconData strokeRoundedReload =
      IconData(0x45f2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedReminder' icon.
  static const IconData strokeRoundedReminder =
      IconData(0x45f3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRemoteControl' icon.
  static const IconData strokeRoundedRemoteControl =
      IconData(0x45f4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRemove01' icon.
  static const IconData strokeRoundedRemove01 =
      IconData(0x45f5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRemove02' icon.
  static const IconData strokeRoundedRemove02 =
      IconData(0x45f6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRemoveCircleHalfDot' icon.
  static const IconData strokeRoundedRemoveCircleHalfDot =
      IconData(0x45f7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRemoveCircle' icon.
  static const IconData strokeRoundedRemoveCircle =
      IconData(0x45f8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRemovePi' icon.
  static const IconData strokeRoundedRemovePi =
      IconData(0x45f9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRemoveSquare' icon.
  static const IconData strokeRoundedRemoveSquare =
      IconData(0x45fa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRenewableEnergy01' icon.
  static const IconData strokeRoundedRenewableEnergy01 =
      IconData(0x45fb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRenewableEnergy' icon.
  static const IconData strokeRoundedRenewableEnergy =
      IconData(0x45fc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRepair' icon.
  static const IconData strokeRoundedRepair =
      IconData(0x45fd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRepeatOff' icon.
  static const IconData strokeRoundedRepeatOff =
      IconData(0x45fe, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRepeatOne01' icon.
  static const IconData strokeRoundedRepeatOne01 =
      IconData(0x45ff, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRepeatOne02' icon.
  static const IconData strokeRoundedRepeatOne02 =
      IconData(0x4600, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRepeat' icon.
  static const IconData strokeRoundedRepeat =
      IconData(0x4601, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedReplay' icon.
  static const IconData strokeRoundedReplay =
      IconData(0x4602, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRepository' icon.
  static const IconData strokeRoundedRepository =
      IconData(0x4603, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedResetPassword' icon.
  static const IconData strokeRoundedResetPassword =
      IconData(0x4604, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedResize01' icon.
  static const IconData strokeRoundedResize01 =
      IconData(0x4605, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedResize02' icon.
  static const IconData strokeRoundedResize02 =
      IconData(0x4606, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedResourcesAdd' icon.
  static const IconData strokeRoundedResourcesAdd =
      IconData(0x4607, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedResourcesRemove' icon.
  static const IconData strokeRoundedResourcesRemove =
      IconData(0x4608, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRestaurant01' icon.
  static const IconData strokeRoundedRestaurant01 =
      IconData(0x4609, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRestaurant02' icon.
  static const IconData strokeRoundedRestaurant02 =
      IconData(0x460a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRestaurant03' icon.
  static const IconData strokeRoundedRestaurant03 =
      IconData(0x460b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRestaurantTable' icon.
  static const IconData strokeRoundedRestaurantTable =
      IconData(0x460c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRestoreBin' icon.
  static const IconData strokeRoundedRestoreBin =
      IconData(0x460d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedReturnRequest' icon.
  static const IconData strokeRoundedReturnRequest =
      IconData(0x460e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedReverseWithdrawal01' icon.
  static const IconData strokeRoundedReverseWithdrawal01 =
      IconData(0x460f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedReverseWithdrawal02' icon.
  static const IconData strokeRoundedReverseWithdrawal02 =
      IconData(0x4610, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRhombus01' icon.
  static const IconData strokeRoundedRhombus01 =
      IconData(0x4611, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRhombus' icon.
  static const IconData strokeRoundedRhombus =
      IconData(0x4612, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRiceBowl01' icon.
  static const IconData strokeRoundedRiceBowl01 =
      IconData(0x4613, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRiceBowl02' icon.
  static const IconData strokeRoundedRiceBowl02 =
      IconData(0x4614, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRightAngle' icon.
  static const IconData strokeRoundedRightAngle =
      IconData(0x4615, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRightToLeftBlockQuote' icon.
  static const IconData strokeRoundedRightToLeftBlockQuote =
      IconData(0x4616, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRightToLeftListBullet' icon.
  static const IconData strokeRoundedRightToLeftListBullet =
      IconData(0x4617, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRightToLeftListDash' icon.
  static const IconData strokeRoundedRightToLeftListDash =
      IconData(0x4618, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRightToLeftListNumber' icon.
  static const IconData strokeRoundedRightToLeftListNumber =
      IconData(0x4619, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRightToLeftListTriangle' icon.
  static const IconData strokeRoundedRightToLeftListTriangle =
      IconData(0x461a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRightTriangle' icon.
  static const IconData strokeRoundedRightTriangle =
      IconData(0x461b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRipple' icon.
  static const IconData strokeRoundedRipple =
      IconData(0x461c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRiyalRectangle' icon.
  static const IconData strokeRoundedRiyalRectangle =
      IconData(0x461d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRiyal' icon.
  static const IconData strokeRoundedRiyal =
      IconData(0x461e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRoad01' icon.
  static const IconData strokeRoundedRoad01 =
      IconData(0x461f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRoad02' icon.
  static const IconData strokeRoundedRoad02 =
      IconData(0x4620, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRoadLocation01' icon.
  static const IconData strokeRoundedRoadLocation01 =
      IconData(0x4621, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRoadLocation02' icon.
  static const IconData strokeRoundedRoadLocation02 =
      IconData(0x4622, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRoadWayside' icon.
  static const IconData strokeRoundedRoadWayside =
      IconData(0x4623, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRoad' icon.
  static const IconData strokeRoundedRoad =
      IconData(0x4624, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRobotic' icon.
  static const IconData strokeRoundedRobotic =
      IconData(0x4625, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRocket01' icon.
  static const IconData strokeRoundedRocket01 =
      IconData(0x4626, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRocket02' icon.
  static const IconData strokeRoundedRocket02 =
      IconData(0x4627, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRocket' icon.
  static const IconData strokeRoundedRocket =
      IconData(0x4628, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRockingChair' icon.
  static const IconData strokeRoundedRockingChair =
      IconData(0x4629, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRollerSkate' icon.
  static const IconData strokeRoundedRollerSkate =
      IconData(0x462a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRollingPin' icon.
  static const IconData strokeRoundedRollingPin =
      IconData(0x462b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRoot01' icon.
  static const IconData strokeRoundedRoot01 =
      IconData(0x462c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRoot02' icon.
  static const IconData strokeRoundedRoot02 =
      IconData(0x462d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRootCircle' icon.
  static const IconData strokeRoundedRootCircle =
      IconData(0x462e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRootFirstBracket' icon.
  static const IconData strokeRoundedRootFirstBracket =
      IconData(0x462f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRootSecondBracket' icon.
  static const IconData strokeRoundedRootSecondBracket =
      IconData(0x4630, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRootThirdBracket' icon.
  static const IconData strokeRoundedRootThirdBracket =
      IconData(0x4631, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRotate01' icon.
  static const IconData strokeRoundedRotate01 =
      IconData(0x4632, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRotate02' icon.
  static const IconData strokeRoundedRotate02 =
      IconData(0x4633, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRotate360' icon.
  static const IconData strokeRoundedRotate360 =
      IconData(0x4634, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRotateBottomLeft' icon.
  static const IconData strokeRoundedRotateBottomLeft =
      IconData(0x4635, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRotateBottomRight' icon.
  static const IconData strokeRoundedRotateBottomRight =
      IconData(0x4636, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRotateClockwise' icon.
  static const IconData strokeRoundedRotateClockwise =
      IconData(0x4637, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRotateCrop' icon.
  static const IconData strokeRoundedRotateCrop =
      IconData(0x4638, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRotateLeft01' icon.
  static const IconData strokeRoundedRotateLeft01 =
      IconData(0x4639, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRotateLeft02' icon.
  static const IconData strokeRoundedRotateLeft02 =
      IconData(0x463a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRotateLeft03' icon.
  static const IconData strokeRoundedRotateLeft03 =
      IconData(0x463b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRotateLeft04' icon.
  static const IconData strokeRoundedRotateLeft04 =
      IconData(0x463c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRotateLeft05' icon.
  static const IconData strokeRoundedRotateLeft05 =
      IconData(0x463d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRotateLeft06' icon.
  static const IconData strokeRoundedRotateLeft06 =
      IconData(0x463e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRotateRight01' icon.
  static const IconData strokeRoundedRotateRight01 =
      IconData(0x463f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRotateRight02' icon.
  static const IconData strokeRoundedRotateRight02 =
      IconData(0x4640, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRotateRight03' icon.
  static const IconData strokeRoundedRotateRight03 =
      IconData(0x4641, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRotateRight04' icon.
  static const IconData strokeRoundedRotateRight04 =
      IconData(0x4642, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRotateRight05' icon.
  static const IconData strokeRoundedRotateRight05 =
      IconData(0x4643, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRotateRight06' icon.
  static const IconData strokeRoundedRotateRight06 =
      IconData(0x4644, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRotateSquare' icon.
  static const IconData strokeRoundedRotateSquare =
      IconData(0x4645, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRotateTopLeft' icon.
  static const IconData strokeRoundedRotateTopLeft =
      IconData(0x4646, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRotateTopRight' icon.
  static const IconData strokeRoundedRotateTopRight =
      IconData(0x4647, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRoute01' icon.
  static const IconData strokeRoundedRoute01 =
      IconData(0x4648, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRoute02' icon.
  static const IconData strokeRoundedRoute02 =
      IconData(0x4649, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRoute03' icon.
  static const IconData strokeRoundedRoute03 =
      IconData(0x464a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRouteBlock' icon.
  static const IconData strokeRoundedRouteBlock =
      IconData(0x464b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRouter01' icon.
  static const IconData strokeRoundedRouter01 =
      IconData(0x464c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRouter02' icon.
  static const IconData strokeRoundedRouter02 =
      IconData(0x464d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRouter' icon.
  static const IconData strokeRoundedRouter =
      IconData(0x464e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRowDelete' icon.
  static const IconData strokeRoundedRowDelete =
      IconData(0x464f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRowInsert' icon.
  static const IconData strokeRoundedRowInsert =
      IconData(0x4650, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRssConnected01' icon.
  static const IconData strokeRoundedRssConnected01 =
      IconData(0x4651, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRssConnected02' icon.
  static const IconData strokeRoundedRssConnected02 =
      IconData(0x4652, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRssError' icon.
  static const IconData strokeRoundedRssError =
      IconData(0x4653, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRssLocked' icon.
  static const IconData strokeRoundedRssLocked =
      IconData(0x4654, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRssUnlocked' icon.
  static const IconData strokeRoundedRssUnlocked =
      IconData(0x4655, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRss' icon.
  static const IconData strokeRoundedRss =
      IconData(0x4656, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRubElHizb' icon.
  static const IconData strokeRoundedRubElHizb =
      IconData(0x4657, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRuku' icon.
  static const IconData strokeRoundedRuku =
      IconData(0x4658, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRuler' icon.
  static const IconData strokeRoundedRuler =
      IconData(0x4659, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedRunningShoes' icon.
  static const IconData strokeRoundedRunningShoes =
      IconData(0x465a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSad01' icon.
  static const IconData strokeRoundedSad01 =
      IconData(0x465b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSad02' icon.
  static const IconData strokeRoundedSad02 =
      IconData(0x465c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSadDizzy' icon.
  static const IconData strokeRoundedSadDizzy =
      IconData(0x465d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSafari' icon.
  static const IconData strokeRoundedSafari =
      IconData(0x465e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSafeDelivery01' icon.
  static const IconData strokeRoundedSafeDelivery01 =
      IconData(0x465f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSafeDelivery02' icon.
  static const IconData strokeRoundedSafeDelivery02 =
      IconData(0x4660, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSafe' icon.
  static const IconData strokeRoundedSafe =
      IconData(0x4661, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSafetyPin01' icon.
  static const IconData strokeRoundedSafetyPin01 =
      IconData(0x4662, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSafetyPin02' icon.
  static const IconData strokeRoundedSafetyPin02 =
      IconData(0x4663, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSailboatCoastal' icon.
  static const IconData strokeRoundedSailboatCoastal =
      IconData(0x4664, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSailboatOffshore' icon.
  static const IconData strokeRoundedSailboatOffshore =
      IconData(0x4665, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSakura' icon.
  static const IconData strokeRoundedSakura =
      IconData(0x4666, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSalahTime' icon.
  static const IconData strokeRoundedSalahTime =
      IconData(0x4667, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSalah' icon.
  static const IconData strokeRoundedSalah =
      IconData(0x4668, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSaleTag01' icon.
  static const IconData strokeRoundedSaleTag01 =
      IconData(0x4669, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSaleTag02' icon.
  static const IconData strokeRoundedSaleTag02 =
      IconData(0x466a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSandals' icon.
  static const IconData strokeRoundedSandals =
      IconData(0x466b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSatellite01' icon.
  static const IconData strokeRoundedSatellite01 =
      IconData(0x466c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSatellite02' icon.
  static const IconData strokeRoundedSatellite02 =
      IconData(0x466d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSatellite03' icon.
  static const IconData strokeRoundedSatellite03 =
      IconData(0x466e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSatellite' icon.
  static const IconData strokeRoundedSatellite =
      IconData(0x466f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSaturn01' icon.
  static const IconData strokeRoundedSaturn01 =
      IconData(0x4670, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSaturn02' icon.
  static const IconData strokeRoundedSaturn02 =
      IconData(0x4671, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSaturn' icon.
  static const IconData strokeRoundedSaturn =
      IconData(0x4672, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSausage' icon.
  static const IconData strokeRoundedSausage =
      IconData(0x4673, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSaveEnergy01' icon.
  static const IconData strokeRoundedSaveEnergy01 =
      IconData(0x4674, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSaveEnergy02' icon.
  static const IconData strokeRoundedSaveEnergy02 =
      IconData(0x4675, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSaveMoneyDollar' icon.
  static const IconData strokeRoundedSaveMoneyDollar =
      IconData(0x4676, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSaveMoneyEuro' icon.
  static const IconData strokeRoundedSaveMoneyEuro =
      IconData(0x4677, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSaveMoneyPound' icon.
  static const IconData strokeRoundedSaveMoneyPound =
      IconData(0x4678, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSaveMoneyYen' icon.
  static const IconData strokeRoundedSaveMoneyYen =
      IconData(0x4679, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSavings' icon.
  static const IconData strokeRoundedSavings =
      IconData(0x467a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedScheme' icon.
  static const IconData strokeRoundedScheme =
      IconData(0x467b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSchool01' icon.
  static const IconData strokeRoundedSchool01 =
      IconData(0x467c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSchoolBell01' icon.
  static const IconData strokeRoundedSchoolBell01 =
      IconData(0x467d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSchoolBell02' icon.
  static const IconData strokeRoundedSchoolBell02 =
      IconData(0x467e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSchoolBus' icon.
  static const IconData strokeRoundedSchoolBus =
      IconData(0x467f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSchoolReportCard' icon.
  static const IconData strokeRoundedSchoolReportCard =
      IconData(0x4680, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSchoolTie' icon.
  static const IconData strokeRoundedSchoolTie =
      IconData(0x4681, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSchool' icon.
  static const IconData strokeRoundedSchool =
      IconData(0x4682, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedScissor01' icon.
  static const IconData strokeRoundedScissor01 =
      IconData(0x4683, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedScissorRectangle' icon.
  static const IconData strokeRoundedScissorRectangle =
      IconData(0x4684, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedScissor' icon.
  static const IconData strokeRoundedScissor =
      IconData(0x4685, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedScooter01' icon.
  static const IconData strokeRoundedScooter01 =
      IconData(0x4686, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedScooter02' icon.
  static const IconData strokeRoundedScooter02 =
      IconData(0x4687, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedScooter03' icon.
  static const IconData strokeRoundedScooter03 =
      IconData(0x4688, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedScooter04' icon.
  static const IconData strokeRoundedScooter04 =
      IconData(0x4689, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedScooterElectric' icon.
  static const IconData strokeRoundedScooterElectric =
      IconData(0x468a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedScratchCard' icon.
  static const IconData strokeRoundedScratchCard =
      IconData(0x468b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedScreenAddToHome' icon.
  static const IconData strokeRoundedScreenAddToHome =
      IconData(0x468c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedScreenLockRotation' icon.
  static const IconData strokeRoundedScreenLockRotation =
      IconData(0x468d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedScreenRotation' icon.
  static const IconData strokeRoundedScreenRotation =
      IconData(0x468e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedScribd' icon.
  static const IconData strokeRoundedScribd =
      IconData(0x468f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedScrollHorizontal' icon.
  static const IconData strokeRoundedScrollHorizontal =
      IconData(0x4690, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedScrollVertical' icon.
  static const IconData strokeRoundedScrollVertical =
      IconData(0x4691, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedScroll' icon.
  static const IconData strokeRoundedScroll =
      IconData(0x4692, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSdCard' icon.
  static const IconData strokeRoundedSdCard =
      IconData(0x4693, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSeal' icon.
  static const IconData strokeRoundedSeal =
      IconData(0x4694, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSearch01' icon.
  static const IconData strokeRoundedSearch01 =
      IconData(0x4695, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSearch02' icon.
  static const IconData strokeRoundedSearch02 =
      IconData(0x4696, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSearchAdd' icon.
  static const IconData strokeRoundedSearchAdd =
      IconData(0x4697, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSearchArea' icon.
  static const IconData strokeRoundedSearchArea =
      IconData(0x4698, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSearchCircle' icon.
  static const IconData strokeRoundedSearchCircle =
      IconData(0x4699, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSearchDollar' icon.
  static const IconData strokeRoundedSearchDollar =
      IconData(0x469a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSearchFocus' icon.
  static const IconData strokeRoundedSearchFocus =
      IconData(0x469b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSearchList01' icon.
  static const IconData strokeRoundedSearchList01 =
      IconData(0x469c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSearchList02' icon.
  static const IconData strokeRoundedSearchList02 =
      IconData(0x469d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSearchMinus' icon.
  static const IconData strokeRoundedSearchMinus =
      IconData(0x469e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSearchRemove' icon.
  static const IconData strokeRoundedSearchRemove =
      IconData(0x469f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSearchReplace' icon.
  static const IconData strokeRoundedSearchReplace =
      IconData(0x46a0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSearchSquare' icon.
  static const IconData strokeRoundedSearchSquare =
      IconData(0x46a1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSearchVisual' icon.
  static const IconData strokeRoundedSearchVisual =
      IconData(0x46a2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSearching' icon.
  static const IconData strokeRoundedSearching =
      IconData(0x46a3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSeatSelector' icon.
  static const IconData strokeRoundedSeatSelector =
      IconData(0x46a4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSecondBracketCircle' icon.
  static const IconData strokeRoundedSecondBracketCircle =
      IconData(0x46a5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSecondBracketSquare' icon.
  static const IconData strokeRoundedSecondBracketSquare =
      IconData(0x46a6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSecondBracket' icon.
  static const IconData strokeRoundedSecondBracket =
      IconData(0x46a7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSecuredNetwork' icon.
  static const IconData strokeRoundedSecuredNetwork =
      IconData(0x46a8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSecurityBlock' icon.
  static const IconData strokeRoundedSecurityBlock =
      IconData(0x46a9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSecurityCheck' icon.
  static const IconData strokeRoundedSecurityCheck =
      IconData(0x46aa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSecurityKeyUsb' icon.
  static const IconData strokeRoundedSecurityKeyUsb =
      IconData(0x46ab, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSecurityLock' icon.
  static const IconData strokeRoundedSecurityLock =
      IconData(0x46ac, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSecurityPassword' icon.
  static const IconData strokeRoundedSecurityPassword =
      IconData(0x46ad, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSecurityValidation' icon.
  static const IconData strokeRoundedSecurityValidation =
      IconData(0x46ae, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSecurityWifi' icon.
  static const IconData strokeRoundedSecurityWifi =
      IconData(0x46af, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSecurity' icon.
  static const IconData strokeRoundedSecurity =
      IconData(0x46b0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSegment' icon.
  static const IconData strokeRoundedSegment =
      IconData(0x46b1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSelect01' icon.
  static const IconData strokeRoundedSelect01 =
      IconData(0x46b2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSelect02' icon.
  static const IconData strokeRoundedSelect02 =
      IconData(0x46b3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSendToMobile' icon.
  static const IconData strokeRoundedSendToMobile =
      IconData(0x46b4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSenseless' icon.
  static const IconData strokeRoundedSenseless =
      IconData(0x46b5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSent' icon.
  static const IconData strokeRoundedSent =
      IconData(0x46b6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSeo' icon.
  static const IconData strokeRoundedSeo =
      IconData(0x46b7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedService' icon.
  static const IconData strokeRoundedService =
      IconData(0x46b8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSetting06' icon.
  static const IconData strokeRoundedSetting06 =
      IconData(0x46b9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSetting07' icon.
  static const IconData strokeRoundedSetting07 =
      IconData(0x46ba, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSettingDone01' icon.
  static const IconData strokeRoundedSettingDone01 =
      IconData(0x46bb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSettingDone02' icon.
  static const IconData strokeRoundedSettingDone02 =
      IconData(0x46bc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSettingDone03' icon.
  static const IconData strokeRoundedSettingDone03 =
      IconData(0x46bd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSettingDone04' icon.
  static const IconData strokeRoundedSettingDone04 =
      IconData(0x46be, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSettingError03' icon.
  static const IconData strokeRoundedSettingError03 =
      IconData(0x46bf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSettingError04' icon.
  static const IconData strokeRoundedSettingError04 =
      IconData(0x46c0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSettings01' icon.
  static const IconData strokeRoundedSettings01 =
      IconData(0x46c1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSettings02' icon.
  static const IconData strokeRoundedSettings02 =
      IconData(0x46c2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSettings03' icon.
  static const IconData strokeRoundedSettings03 =
      IconData(0x46c3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSettings04' icon.
  static const IconData strokeRoundedSettings04 =
      IconData(0x46c4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSettings05' icon.
  static const IconData strokeRoundedSettings05 =
      IconData(0x46c5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSettingsError01' icon.
  static const IconData strokeRoundedSettingsError01 =
      IconData(0x46c6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSettingsError02' icon.
  static const IconData strokeRoundedSettingsError02 =
      IconData(0x46c7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSetup01' icon.
  static const IconData strokeRoundedSetup01 =
      IconData(0x46c8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSetup02' icon.
  static const IconData strokeRoundedSetup02 =
      IconData(0x46c9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShaka01' icon.
  static const IconData strokeRoundedShaka01 =
      IconData(0x46ca, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShaka02' icon.
  static const IconData strokeRoundedShaka02 =
      IconData(0x46cb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShaka03' icon.
  static const IconData strokeRoundedShaka03 =
      IconData(0x46cc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShaka04' icon.
  static const IconData strokeRoundedShaka04 =
      IconData(0x46cd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShampoo' icon.
  static const IconData strokeRoundedShampoo =
      IconData(0x46ce, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShapes' icon.
  static const IconData strokeRoundedShapes =
      IconData(0x46cf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShare01' icon.
  static const IconData strokeRoundedShare01 =
      IconData(0x46d0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShare02' icon.
  static const IconData strokeRoundedShare02 =
      IconData(0x46d1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShare03' icon.
  static const IconData strokeRoundedShare03 =
      IconData(0x46d2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShare04' icon.
  static const IconData strokeRoundedShare04 =
      IconData(0x46d3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShare05' icon.
  static const IconData strokeRoundedShare05 =
      IconData(0x46d4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShare06' icon.
  static const IconData strokeRoundedShare06 =
      IconData(0x46d5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShare07' icon.
  static const IconData strokeRoundedShare07 =
      IconData(0x46d6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShare08' icon.
  static const IconData strokeRoundedShare08 =
      IconData(0x46d7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShareKnowledge' icon.
  static const IconData strokeRoundedShareKnowledge =
      IconData(0x46d8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShareLocation01' icon.
  static const IconData strokeRoundedShareLocation01 =
      IconData(0x46d9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShareLocation02' icon.
  static const IconData strokeRoundedShareLocation02 =
      IconData(0x46da, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSharedWifi' icon.
  static const IconData strokeRoundedSharedWifi =
      IconData(0x46db, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSharing' icon.
  static const IconData strokeRoundedSharing =
      IconData(0x46dc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShellfish' icon.
  static const IconData strokeRoundedShellfish =
      IconData(0x46dd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSheriff01' icon.
  static const IconData strokeRoundedSheriff01 =
      IconData(0x46de, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSheriff02' icon.
  static const IconData strokeRoundedSheriff02 =
      IconData(0x46df, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShield01' icon.
  static const IconData strokeRoundedShield01 =
      IconData(0x46e0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShield02' icon.
  static const IconData strokeRoundedShield02 =
      IconData(0x46e1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShieldBlockchain' icon.
  static const IconData strokeRoundedShieldBlockchain =
      IconData(0x46e2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShieldEnergy' icon.
  static const IconData strokeRoundedShieldEnergy =
      IconData(0x46e3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShieldKey' icon.
  static const IconData strokeRoundedShieldKey =
      IconData(0x46e4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShieldUser' icon.
  static const IconData strokeRoundedShieldUser =
      IconData(0x46e5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShipmentTracking' icon.
  static const IconData strokeRoundedShipmentTracking =
      IconData(0x46e6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShippingCenter' icon.
  static const IconData strokeRoundedShippingCenter =
      IconData(0x46e7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShippingLoading' icon.
  static const IconData strokeRoundedShippingLoading =
      IconData(0x46e8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShippingTruck01' icon.
  static const IconData strokeRoundedShippingTruck01 =
      IconData(0x46e9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShippingTruck02' icon.
  static const IconData strokeRoundedShippingTruck02 =
      IconData(0x46ea, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShirt01' icon.
  static const IconData strokeRoundedShirt01 =
      IconData(0x46eb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShocked' icon.
  static const IconData strokeRoundedShocked =
      IconData(0x46ec, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShopSign' icon.
  static const IconData strokeRoundedShopSign =
      IconData(0x46ed, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBag01' icon.
  static const IconData strokeRoundedShoppingBag01 =
      IconData(0x46ee, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBag02' icon.
  static const IconData strokeRoundedShoppingBag02 =
      IconData(0x46ef, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBag03' icon.
  static const IconData strokeRoundedShoppingBag03 =
      IconData(0x46f0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBagAdd' icon.
  static const IconData strokeRoundedShoppingBagAdd =
      IconData(0x46f1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBagCheck' icon.
  static const IconData strokeRoundedShoppingBagCheck =
      IconData(0x46f2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBagFavorite' icon.
  static const IconData strokeRoundedShoppingBagFavorite =
      IconData(0x46f3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBagRemove' icon.
  static const IconData strokeRoundedShoppingBagRemove =
      IconData(0x46f4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBasket01' icon.
  static const IconData strokeRoundedShoppingBasket01 =
      IconData(0x46f5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBasket02' icon.
  static const IconData strokeRoundedShoppingBasket02 =
      IconData(0x46f6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBasket03' icon.
  static const IconData strokeRoundedShoppingBasket03 =
      IconData(0x46f7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBasketAdd01' icon.
  static const IconData strokeRoundedShoppingBasketAdd01 =
      IconData(0x46f8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBasketAdd02' icon.
  static const IconData strokeRoundedShoppingBasketAdd02 =
      IconData(0x46f9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBasketAdd03' icon.
  static const IconData strokeRoundedShoppingBasketAdd03 =
      IconData(0x46fa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBasketCheckIn01' icon.
  static const IconData strokeRoundedShoppingBasketCheckIn01 =
      IconData(0x46fb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBasketCheckIn02' icon.
  static const IconData strokeRoundedShoppingBasketCheckIn02 =
      IconData(0x46fc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBasketCheckIn03' icon.
  static const IconData strokeRoundedShoppingBasketCheckIn03 =
      IconData(0x46fd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBasketCheckOut01' icon.
  static const IconData strokeRoundedShoppingBasketCheckOut01 =
      IconData(0x46fe, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBasketCheckOut02' icon.
  static const IconData strokeRoundedShoppingBasketCheckOut02 =
      IconData(0x46ff, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBasketCheckOut03' icon.
  static const IconData strokeRoundedShoppingBasketCheckOut03 =
      IconData(0x4700, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBasketDone01' icon.
  static const IconData strokeRoundedShoppingBasketDone01 =
      IconData(0x4701, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBasketDone02' icon.
  static const IconData strokeRoundedShoppingBasketDone02 =
      IconData(0x4702, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBasketDone03' icon.
  static const IconData strokeRoundedShoppingBasketDone03 =
      IconData(0x4703, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBasketFavorite01' icon.
  static const IconData strokeRoundedShoppingBasketFavorite01 =
      IconData(0x4704, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBasketFavorite02' icon.
  static const IconData strokeRoundedShoppingBasketFavorite02 =
      IconData(0x4705, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBasketFavorite03' icon.
  static const IconData strokeRoundedShoppingBasketFavorite03 =
      IconData(0x4706, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBasketRemove01' icon.
  static const IconData strokeRoundedShoppingBasketRemove01 =
      IconData(0x4707, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBasketRemove02' icon.
  static const IconData strokeRoundedShoppingBasketRemove02 =
      IconData(0x4708, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBasketRemove03' icon.
  static const IconData strokeRoundedShoppingBasketRemove03 =
      IconData(0x4709, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBasketSecure01' icon.
  static const IconData strokeRoundedShoppingBasketSecure01 =
      IconData(0x470a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBasketSecure02' icon.
  static const IconData strokeRoundedShoppingBasketSecure02 =
      IconData(0x470b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingBasketSecure03' icon.
  static const IconData strokeRoundedShoppingBasketSecure03 =
      IconData(0x470c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingCart01' icon.
  static const IconData strokeRoundedShoppingCart01 =
      IconData(0x470d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingCart02' icon.
  static const IconData strokeRoundedShoppingCart02 =
      IconData(0x470e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingCartAdd01' icon.
  static const IconData strokeRoundedShoppingCartAdd01 =
      IconData(0x470f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingCartAdd02' icon.
  static const IconData strokeRoundedShoppingCartAdd02 =
      IconData(0x4710, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingCartCheck01' icon.
  static const IconData strokeRoundedShoppingCartCheck01 =
      IconData(0x4711, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingCartCheck02' icon.
  static const IconData strokeRoundedShoppingCartCheck02 =
      IconData(0x4712, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingCartCheckIn01' icon.
  static const IconData strokeRoundedShoppingCartCheckIn01 =
      IconData(0x4713, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingCartCheckIn02' icon.
  static const IconData strokeRoundedShoppingCartCheckIn02 =
      IconData(0x4714, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingCartCheckOut01' icon.
  static const IconData strokeRoundedShoppingCartCheckOut01 =
      IconData(0x4715, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingCartCheckOut02' icon.
  static const IconData strokeRoundedShoppingCartCheckOut02 =
      IconData(0x4716, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingCartFavorite01' icon.
  static const IconData strokeRoundedShoppingCartFavorite01 =
      IconData(0x4717, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingCartFavorite02' icon.
  static const IconData strokeRoundedShoppingCartFavorite02 =
      IconData(0x4718, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingCartRemove01' icon.
  static const IconData strokeRoundedShoppingCartRemove01 =
      IconData(0x4719, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShoppingCartRemove02' icon.
  static const IconData strokeRoundedShoppingCartRemove02 =
      IconData(0x471a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShortsPants' icon.
  static const IconData strokeRoundedShortsPants =
      IconData(0x471b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShuffleSquare' icon.
  static const IconData strokeRoundedShuffleSquare =
      IconData(0x471c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShuffle' icon.
  static const IconData strokeRoundedShuffle =
      IconData(0x471d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedShutterstock' icon.
  static const IconData strokeRoundedShutterstock =
      IconData(0x471e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSidebarBottom' icon.
  static const IconData strokeRoundedSidebarBottom =
      IconData(0x471f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSidebarLeft01' icon.
  static const IconData strokeRoundedSidebarLeft01 =
      IconData(0x4720, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSidebarLeft' icon.
  static const IconData strokeRoundedSidebarLeft =
      IconData(0x4721, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSidebarRight01' icon.
  static const IconData strokeRoundedSidebarRight01 =
      IconData(0x4722, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSidebarRight' icon.
  static const IconData strokeRoundedSidebarRight =
      IconData(0x4723, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSidebarTop' icon.
  static const IconData strokeRoundedSidebarTop =
      IconData(0x4724, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSignLanguageC' icon.
  static const IconData strokeRoundedSignLanguageC =
      IconData(0x4725, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSignalFull01' icon.
  static const IconData strokeRoundedSignalFull01 =
      IconData(0x4726, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSignalFull02' icon.
  static const IconData strokeRoundedSignalFull02 =
      IconData(0x4727, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSignalLow01' icon.
  static const IconData strokeRoundedSignalLow01 =
      IconData(0x4728, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSignalLow02' icon.
  static const IconData strokeRoundedSignalLow02 =
      IconData(0x4729, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSignalLowMedium' icon.
  static const IconData strokeRoundedSignalLowMedium =
      IconData(0x472a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSignalMedium01' icon.
  static const IconData strokeRoundedSignalMedium01 =
      IconData(0x472b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSignalMedium02' icon.
  static const IconData strokeRoundedSignalMedium02 =
      IconData(0x472c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSignalNo01' icon.
  static const IconData strokeRoundedSignalNo01 =
      IconData(0x472d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSignalNo02' icon.
  static const IconData strokeRoundedSignalNo02 =
      IconData(0x472e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSignal' icon.
  static const IconData strokeRoundedSignal =
      IconData(0x472f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSignature' icon.
  static const IconData strokeRoundedSignature =
      IconData(0x4730, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSilence' icon.
  static const IconData strokeRoundedSilence =
      IconData(0x4731, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSimcard01' icon.
  static const IconData strokeRoundedSimcard01 =
      IconData(0x4732, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSimcard02' icon.
  static const IconData strokeRoundedSimcard02 =
      IconData(0x4733, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSimcardDual' icon.
  static const IconData strokeRoundedSimcardDual =
      IconData(0x4734, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSin' icon.
  static const IconData strokeRoundedSin =
      IconData(0x4735, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSine01' icon.
  static const IconData strokeRoundedSine01 =
      IconData(0x4736, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSine02' icon.
  static const IconData strokeRoundedSine02 =
      IconData(0x4737, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSingLeft' icon.
  static const IconData strokeRoundedSingLeft =
      IconData(0x4738, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSingRight' icon.
  static const IconData strokeRoundedSingRight =
      IconData(0x4739, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSink01' icon.
  static const IconData strokeRoundedSink01 =
      IconData(0x473a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSink02' icon.
  static const IconData strokeRoundedSink02 =
      IconData(0x473b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSiri' icon.
  static const IconData strokeRoundedSiri =
      IconData(0x473c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSketch' icon.
  static const IconData strokeRoundedSketch =
      IconData(0x473d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSkew' icon.
  static const IconData strokeRoundedSkew =
      IconData(0x473e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSkiDiceFaces01' icon.
  static const IconData strokeRoundedSkiDiceFaces01 =
      IconData(0x473f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSkippingRope' icon.
  static const IconData strokeRoundedSkippingRope =
      IconData(0x4740, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSkull' icon.
  static const IconData strokeRoundedSkull =
      IconData(0x4741, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSkype' icon.
  static const IconData strokeRoundedSkype =
      IconData(0x4742, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSlack' icon.
  static const IconData strokeRoundedSlack =
      IconData(0x4743, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSleeping' icon.
  static const IconData strokeRoundedSleeping =
      IconData(0x4744, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSleeveless' icon.
  static const IconData strokeRoundedSleeveless =
      IconData(0x4745, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSlidersHorizontal' icon.
  static const IconData strokeRoundedSlidersHorizontal =
      IconData(0x4746, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSlidersVertical' icon.
  static const IconData strokeRoundedSlidersVertical =
      IconData(0x4747, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSlideshare' icon.
  static const IconData strokeRoundedSlideshare =
      IconData(0x4748, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSlowWinds' icon.
  static const IconData strokeRoundedSlowWinds =
      IconData(0x4749, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSmartAc' icon.
  static const IconData strokeRoundedSmartAc =
      IconData(0x474a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSmartPhone01' icon.
  static const IconData strokeRoundedSmartPhone01 =
      IconData(0x474b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSmartPhone02' icon.
  static const IconData strokeRoundedSmartPhone02 =
      IconData(0x474c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSmartPhone03' icon.
  static const IconData strokeRoundedSmartPhone03 =
      IconData(0x474d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSmartPhone04' icon.
  static const IconData strokeRoundedSmartPhone04 =
      IconData(0x474e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSmartPhoneLandscape' icon.
  static const IconData strokeRoundedSmartPhoneLandscape =
      IconData(0x474f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSmartWatch01' icon.
  static const IconData strokeRoundedSmartWatch01 =
      IconData(0x4750, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSmartWatch02' icon.
  static const IconData strokeRoundedSmartWatch02 =
      IconData(0x4751, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSmartWatch03' icon.
  static const IconData strokeRoundedSmartWatch03 =
      IconData(0x4752, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSmartWatch04' icon.
  static const IconData strokeRoundedSmartWatch04 =
      IconData(0x4753, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSmart' icon.
  static const IconData strokeRoundedSmart =
      IconData(0x4754, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSmartphoneLostWifi' icon.
  static const IconData strokeRoundedSmartphoneLostWifi =
      IconData(0x4755, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSmartphoneWifi' icon.
  static const IconData strokeRoundedSmartphoneWifi =
      IconData(0x4756, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSmileDizzy' icon.
  static const IconData strokeRoundedSmileDizzy =
      IconData(0x4757, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSmile' icon.
  static const IconData strokeRoundedSmile =
      IconData(0x4758, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSmsCode' icon.
  static const IconData strokeRoundedSmsCode =
      IconData(0x4759, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSnail' icon.
  static const IconData strokeRoundedSnail =
      IconData(0x475a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSnapchat' icon.
  static const IconData strokeRoundedSnapchat =
      IconData(0x475b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSnow' icon.
  static const IconData strokeRoundedSnow =
      IconData(0x475c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSodaCan' icon.
  static const IconData strokeRoundedSodaCan =
      IconData(0x475d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSofa01' icon.
  static const IconData strokeRoundedSofa01 =
      IconData(0x475e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSofa02' icon.
  static const IconData strokeRoundedSofa02 =
      IconData(0x475f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSofa03' icon.
  static const IconData strokeRoundedSofa03 =
      IconData(0x4760, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSofaSingle' icon.
  static const IconData strokeRoundedSofaSingle =
      IconData(0x4761, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSoftDrink01' icon.
  static const IconData strokeRoundedSoftDrink01 =
      IconData(0x4762, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSoftDrink02' icon.
  static const IconData strokeRoundedSoftDrink02 =
      IconData(0x4763, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSoftwareLicense' icon.
  static const IconData strokeRoundedSoftwareLicense =
      IconData(0x4764, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSoftwareUninstall' icon.
  static const IconData strokeRoundedSoftwareUninstall =
      IconData(0x4765, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSoftware' icon.
  static const IconData strokeRoundedSoftware =
      IconData(0x4766, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSoilMoistureField' icon.
  static const IconData strokeRoundedSoilMoistureField =
      IconData(0x4767, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSoilMoistureGlobal' icon.
  static const IconData strokeRoundedSoilMoistureGlobal =
      IconData(0x4768, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSoilTemperatureField' icon.
  static const IconData strokeRoundedSoilTemperatureField =
      IconData(0x4769, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSoilTemperatureGlobal' icon.
  static const IconData strokeRoundedSoilTemperatureGlobal =
      IconData(0x476a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSolarEnergy' icon.
  static const IconData strokeRoundedSolarEnergy =
      IconData(0x476b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSolarPanel01' icon.
  static const IconData strokeRoundedSolarPanel01 =
      IconData(0x476c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSolarPanel02' icon.
  static const IconData strokeRoundedSolarPanel02 =
      IconData(0x476d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSolarPanel03' icon.
  static const IconData strokeRoundedSolarPanel03 =
      IconData(0x476e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSolarPanel04' icon.
  static const IconData strokeRoundedSolarPanel04 =
      IconData(0x476f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSolarPanel05' icon.
  static const IconData strokeRoundedSolarPanel05 =
      IconData(0x4770, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSolarPower' icon.
  static const IconData strokeRoundedSolarPower =
      IconData(0x4771, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSolarSystem01' icon.
  static const IconData strokeRoundedSolarSystem01 =
      IconData(0x4772, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSolarSystem' icon.
  static const IconData strokeRoundedSolarSystem =
      IconData(0x4773, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSolidLine01' icon.
  static const IconData strokeRoundedSolidLine01 =
      IconData(0x4774, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSolidLine02' icon.
  static const IconData strokeRoundedSolidLine02 =
      IconData(0x4775, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSortByDown01' icon.
  static const IconData strokeRoundedSortByDown01 =
      IconData(0x4776, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSortByDown02' icon.
  static const IconData strokeRoundedSortByDown02 =
      IconData(0x4777, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSortByUp01' icon.
  static const IconData strokeRoundedSortByUp01 =
      IconData(0x4778, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSortByUp02' icon.
  static const IconData strokeRoundedSortByUp02 =
      IconData(0x4779, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSorting01' icon.
  static const IconData strokeRoundedSorting01 =
      IconData(0x477a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSorting02' icon.
  static const IconData strokeRoundedSorting02 =
      IconData(0x477b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSorting03' icon.
  static const IconData strokeRoundedSorting03 =
      IconData(0x477c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSorting04' icon.
  static const IconData strokeRoundedSorting04 =
      IconData(0x477d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSorting05' icon.
  static const IconData strokeRoundedSorting05 =
      IconData(0x477e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSorting19' icon.
  static const IconData strokeRoundedSorting19 =
      IconData(0x477f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSorting91' icon.
  static const IconData strokeRoundedSorting91 =
      IconData(0x4780, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSortingAZ01' icon.
  static const IconData strokeRoundedSortingAZ01 =
      IconData(0x4781, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSortingAZ02' icon.
  static const IconData strokeRoundedSortingAZ02 =
      IconData(0x4782, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSortingDown' icon.
  static const IconData strokeRoundedSortingDown =
      IconData(0x4783, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSortingUp' icon.
  static const IconData strokeRoundedSortingUp =
      IconData(0x4784, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSortingZA01' icon.
  static const IconData strokeRoundedSortingZA01 =
      IconData(0x4785, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSoundcloud' icon.
  static const IconData strokeRoundedSoundcloud =
      IconData(0x4786, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSourceCodeCircle' icon.
  static const IconData strokeRoundedSourceCodeCircle =
      IconData(0x4787, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSourceCodeSquare' icon.
  static const IconData strokeRoundedSourceCodeSquare =
      IconData(0x4788, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSourceCode' icon.
  static const IconData strokeRoundedSourceCode =
      IconData(0x4789, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSpaceship' icon.
  static const IconData strokeRoundedSpaceship =
      IconData(0x478a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSpades' icon.
  static const IconData strokeRoundedSpades =
      IconData(0x478b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSpaghetti' icon.
  static const IconData strokeRoundedSpaghetti =
      IconData(0x478c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSpam' icon.
  static const IconData strokeRoundedSpam =
      IconData(0x478d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSparkles' icon.
  static const IconData strokeRoundedSparkles =
      IconData(0x478e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSpartanHelmet' icon.
  static const IconData strokeRoundedSpartanHelmet =
      IconData(0x478f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSpatula' icon.
  static const IconData strokeRoundedSpatula =
      IconData(0x4790, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSpeaker01' icon.
  static const IconData strokeRoundedSpeaker01 =
      IconData(0x4791, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSpeaker' icon.
  static const IconData strokeRoundedSpeaker =
      IconData(0x4792, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSpeechToText' icon.
  static const IconData strokeRoundedSpeechToText =
      IconData(0x4793, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSpeedTrain01' icon.
  static const IconData strokeRoundedSpeedTrain01 =
      IconData(0x4794, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSpeedTrain02' icon.
  static const IconData strokeRoundedSpeedTrain02 =
      IconData(0x4795, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSperm' icon.
  static const IconData strokeRoundedSperm =
      IconData(0x4796, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSphere' icon.
  static const IconData strokeRoundedSphere =
      IconData(0x4797, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSpirals' icon.
  static const IconData strokeRoundedSpirals =
      IconData(0x4798, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSpoonAndFork' icon.
  static const IconData strokeRoundedSpoonAndFork =
      IconData(0x4799, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSpoonAndKnife' icon.
  static const IconData strokeRoundedSpoonAndKnife =
      IconData(0x479a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSpoon' icon.
  static const IconData strokeRoundedSpoon =
      IconData(0x479b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSpotify' icon.
  static const IconData strokeRoundedSpotify =
      IconData(0x479c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSql' icon.
  static const IconData strokeRoundedSql =
      IconData(0x479d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquare01' icon.
  static const IconData strokeRoundedSquare01 =
      IconData(0x479e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowDataTransferDiagonal' icon.
  static const IconData strokeRoundedSquareArrowDataTransferDiagonal =
      IconData(0x479f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowDataTransferHorizontal' icon.
  static const IconData strokeRoundedSquareArrowDataTransferHorizontal =
      IconData(0x47a0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowDataTransferVertical' icon.
  static const IconData strokeRoundedSquareArrowDataTransferVertical =
      IconData(0x47a1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowDiagonal01' icon.
  static const IconData strokeRoundedSquareArrowDiagonal01 =
      IconData(0x47a2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowDiagonal02' icon.
  static const IconData strokeRoundedSquareArrowDiagonal02 =
      IconData(0x47a3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowDown01' icon.
  static const IconData strokeRoundedSquareArrowDown01 =
      IconData(0x47a4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowDown02' icon.
  static const IconData strokeRoundedSquareArrowDown02 =
      IconData(0x47a5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowDown03' icon.
  static const IconData strokeRoundedSquareArrowDown03 =
      IconData(0x47a6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowDownDouble' icon.
  static const IconData strokeRoundedSquareArrowDownDouble =
      IconData(0x47a7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowDownLeft' icon.
  static const IconData strokeRoundedSquareArrowDownLeft =
      IconData(0x47a8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowDownRight' icon.
  static const IconData strokeRoundedSquareArrowDownRight =
      IconData(0x47a9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowExpand01' icon.
  static const IconData strokeRoundedSquareArrowExpand01 =
      IconData(0x47aa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowExpand02' icon.
  static const IconData strokeRoundedSquareArrowExpand02 =
      IconData(0x47ab, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowHorizontal' icon.
  static const IconData strokeRoundedSquareArrowHorizontal =
      IconData(0x47ac, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowLeft01' icon.
  static const IconData strokeRoundedSquareArrowLeft01 =
      IconData(0x47ad, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowLeft02' icon.
  static const IconData strokeRoundedSquareArrowLeft02 =
      IconData(0x47ae, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowLeft03' icon.
  static const IconData strokeRoundedSquareArrowLeft03 =
      IconData(0x47af, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowLeftDouble' icon.
  static const IconData strokeRoundedSquareArrowLeftDouble =
      IconData(0x47b0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowLeftRight' icon.
  static const IconData strokeRoundedSquareArrowLeftRight =
      IconData(0x47b1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowMoveDownLeft' icon.
  static const IconData strokeRoundedSquareArrowMoveDownLeft =
      IconData(0x47b2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowMoveDownRight' icon.
  static const IconData strokeRoundedSquareArrowMoveDownRight =
      IconData(0x47b3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowMoveLeftDown' icon.
  static const IconData strokeRoundedSquareArrowMoveLeftDown =
      IconData(0x47b4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowMoveLeftUp' icon.
  static const IconData strokeRoundedSquareArrowMoveLeftUp =
      IconData(0x47b5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowMoveRightDown' icon.
  static const IconData strokeRoundedSquareArrowMoveRightDown =
      IconData(0x47b6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowMoveRightUp' icon.
  static const IconData strokeRoundedSquareArrowMoveRightUp =
      IconData(0x47b7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowReload01' icon.
  static const IconData strokeRoundedSquareArrowReload01 =
      IconData(0x47b8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowReload02' icon.
  static const IconData strokeRoundedSquareArrowReload02 =
      IconData(0x47b9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowRight01' icon.
  static const IconData strokeRoundedSquareArrowRight01 =
      IconData(0x47ba, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowRight02' icon.
  static const IconData strokeRoundedSquareArrowRight02 =
      IconData(0x47bb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowRight03' icon.
  static const IconData strokeRoundedSquareArrowRight03 =
      IconData(0x47bc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowRightDouble' icon.
  static const IconData strokeRoundedSquareArrowRightDouble =
      IconData(0x47bd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowShrink01' icon.
  static const IconData strokeRoundedSquareArrowShrink01 =
      IconData(0x47be, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowShrink02' icon.
  static const IconData strokeRoundedSquareArrowShrink02 =
      IconData(0x47bf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowUp01' icon.
  static const IconData strokeRoundedSquareArrowUp01 =
      IconData(0x47c0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowUp02' icon.
  static const IconData strokeRoundedSquareArrowUp02 =
      IconData(0x47c1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowUp03' icon.
  static const IconData strokeRoundedSquareArrowUp03 =
      IconData(0x47c2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowUpDouble' icon.
  static const IconData strokeRoundedSquareArrowUpDouble =
      IconData(0x47c3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowUpDown' icon.
  static const IconData strokeRoundedSquareArrowUpDown =
      IconData(0x47c4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowUpLeft' icon.
  static const IconData strokeRoundedSquareArrowUpLeft =
      IconData(0x47c5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowUpRight' icon.
  static const IconData strokeRoundedSquareArrowUpRight =
      IconData(0x47c6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareArrowVertical' icon.
  static const IconData strokeRoundedSquareArrowVertical =
      IconData(0x47c7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareCircle' icon.
  static const IconData strokeRoundedSquareCircle =
      IconData(0x47c8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareLock01' icon.
  static const IconData strokeRoundedSquareLock01 =
      IconData(0x47c9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareLock02' icon.
  static const IconData strokeRoundedSquareLock02 =
      IconData(0x47ca, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareLockAdd01' icon.
  static const IconData strokeRoundedSquareLockAdd01 =
      IconData(0x47cb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareLockAdd02' icon.
  static const IconData strokeRoundedSquareLockAdd02 =
      IconData(0x47cc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareLockCheck01' icon.
  static const IconData strokeRoundedSquareLockCheck01 =
      IconData(0x47cd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareLockCheck02' icon.
  static const IconData strokeRoundedSquareLockCheck02 =
      IconData(0x47ce, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareLockMinus01' icon.
  static const IconData strokeRoundedSquareLockMinus01 =
      IconData(0x47cf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareLockMinus02' icon.
  static const IconData strokeRoundedSquareLockMinus02 =
      IconData(0x47d0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareLockPassword' icon.
  static const IconData strokeRoundedSquareLockPassword =
      IconData(0x47d1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareLockRemove01' icon.
  static const IconData strokeRoundedSquareLockRemove01 =
      IconData(0x47d2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareLockRemove02' icon.
  static const IconData strokeRoundedSquareLockRemove02 =
      IconData(0x47d3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareRootSquare' icon.
  static const IconData strokeRoundedSquareRootSquare =
      IconData(0x47d4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareSquare' icon.
  static const IconData strokeRoundedSquareSquare =
      IconData(0x47d5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareUnlock01' icon.
  static const IconData strokeRoundedSquareUnlock01 =
      IconData(0x47d6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquareUnlock02' icon.
  static const IconData strokeRoundedSquareUnlock02 =
      IconData(0x47d7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSquare' icon.
  static const IconData strokeRoundedSquare =
      IconData(0x47d8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStackStar' icon.
  static const IconData strokeRoundedStackStar =
      IconData(0x47d9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStake' icon.
  static const IconData strokeRoundedStake =
      IconData(0x47da, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStamp01' icon.
  static const IconData strokeRoundedStamp01 =
      IconData(0x47db, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStamp02' icon.
  static const IconData strokeRoundedStamp02 =
      IconData(0x47dc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStamp' icon.
  static const IconData strokeRoundedStamp =
      IconData(0x47dd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStarCircle' icon.
  static const IconData strokeRoundedStarCircle =
      IconData(0x47de, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStarFace' icon.
  static const IconData strokeRoundedStarFace =
      IconData(0x47df, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStarHalf' icon.
  static const IconData strokeRoundedStarHalf =
      IconData(0x47e0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStarOff' icon.
  static const IconData strokeRoundedStarOff =
      IconData(0x47e1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStarSquare' icon.
  static const IconData strokeRoundedStarSquare =
      IconData(0x47e2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStar' icon.
  static const IconData strokeRoundedStar =
      IconData(0x47e3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStars' icon.
  static const IconData strokeRoundedStars =
      IconData(0x47e4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStartUp01' icon.
  static const IconData strokeRoundedStartUp01 =
      IconData(0x47e5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStartUp02' icon.
  static const IconData strokeRoundedStartUp02 =
      IconData(0x47e6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStationery' icon.
  static const IconData strokeRoundedStationery =
      IconData(0x47e7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSteak' icon.
  static const IconData strokeRoundedSteak =
      IconData(0x47e8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSteering' icon.
  static const IconData strokeRoundedSteering =
      IconData(0x47e9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStepInto' icon.
  static const IconData strokeRoundedStepInto =
      IconData(0x47ea, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStepOut' icon.
  static const IconData strokeRoundedStepOut =
      IconData(0x47eb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStepOver' icon.
  static const IconData strokeRoundedStepOver =
      IconData(0x47ec, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStethoscope02' icon.
  static const IconData strokeRoundedStethoscope02 =
      IconData(0x47ed, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStethoscope' icon.
  static const IconData strokeRoundedStethoscope =
      IconData(0x47ee, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStickyNote01' icon.
  static const IconData strokeRoundedStickyNote01 =
      IconData(0x47ef, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStickyNote02' icon.
  static const IconData strokeRoundedStickyNote02 =
      IconData(0x47f0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStopWatch' icon.
  static const IconData strokeRoundedStopWatch =
      IconData(0x47f1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStop' icon.
  static const IconData strokeRoundedStop =
      IconData(0x47f2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStore01' icon.
  static const IconData strokeRoundedStore01 =
      IconData(0x47f3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStore02' icon.
  static const IconData strokeRoundedStore02 =
      IconData(0x47f4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStore03' icon.
  static const IconData strokeRoundedStore03 =
      IconData(0x47f5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStore04' icon.
  static const IconData strokeRoundedStore04 =
      IconData(0x47f6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStoreAdd01' icon.
  static const IconData strokeRoundedStoreAdd01 =
      IconData(0x47f7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStoreAdd02' icon.
  static const IconData strokeRoundedStoreAdd02 =
      IconData(0x47f8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStoreLocation01' icon.
  static const IconData strokeRoundedStoreLocation01 =
      IconData(0x47f9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStoreLocation02' icon.
  static const IconData strokeRoundedStoreLocation02 =
      IconData(0x47fa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStoreRemove01' icon.
  static const IconData strokeRoundedStoreRemove01 =
      IconData(0x47fb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStoreRemove02' icon.
  static const IconData strokeRoundedStoreRemove02 =
      IconData(0x47fc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStoreVerified01' icon.
  static const IconData strokeRoundedStoreVerified01 =
      IconData(0x47fd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStoreVerified02' icon.
  static const IconData strokeRoundedStoreVerified02 =
      IconData(0x47fe, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStraightEdge' icon.
  static const IconData strokeRoundedStraightEdge =
      IconData(0x47ff, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStrategy' icon.
  static const IconData strokeRoundedStrategy =
      IconData(0x4800, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStrokeBottom' icon.
  static const IconData strokeRoundedStrokeBottom =
      IconData(0x4801, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStrokeCenter' icon.
  static const IconData strokeRoundedStrokeCenter =
      IconData(0x4802, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStrokeInside' icon.
  static const IconData strokeRoundedStrokeInside =
      IconData(0x4803, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStrokeLeft' icon.
  static const IconData strokeRoundedStrokeLeft =
      IconData(0x4804, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStrokeOutside' icon.
  static const IconData strokeRoundedStrokeOutside =
      IconData(0x4805, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStrokeRight' icon.
  static const IconData strokeRoundedStrokeRight =
      IconData(0x4806, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStrokeTop' icon.
  static const IconData strokeRoundedStrokeTop =
      IconData(0x4807, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStructure01' icon.
  static const IconData strokeRoundedStructure01 =
      IconData(0x4808, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStructure02' icon.
  static const IconData strokeRoundedStructure02 =
      IconData(0x4809, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStructure03' icon.
  static const IconData strokeRoundedStructure03 =
      IconData(0x480a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStructure04' icon.
  static const IconData strokeRoundedStructure04 =
      IconData(0x480b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStructure05' icon.
  static const IconData strokeRoundedStructure05 =
      IconData(0x480c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStructureAdd' icon.
  static const IconData strokeRoundedStructureAdd =
      IconData(0x480d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStructureCheck' icon.
  static const IconData strokeRoundedStructureCheck =
      IconData(0x480e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStructureFail' icon.
  static const IconData strokeRoundedStructureFail =
      IconData(0x480f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStructureFolderCircle' icon.
  static const IconData strokeRoundedStructureFolderCircle =
      IconData(0x4810, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStructureFolder' icon.
  static const IconData strokeRoundedStructureFolder =
      IconData(0x4811, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStudentCard' icon.
  static const IconData strokeRoundedStudentCard =
      IconData(0x4812, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStudent' icon.
  static const IconData strokeRoundedStudent =
      IconData(0x4813, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStudents' icon.
  static const IconData strokeRoundedStudents =
      IconData(0x4814, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStudyDesk' icon.
  static const IconData strokeRoundedStudyDesk =
      IconData(0x4815, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStudyLamp' icon.
  static const IconData strokeRoundedStudyLamp =
      IconData(0x4816, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedStumbleupon' icon.
  static const IconData strokeRoundedStumbleupon =
      IconData(0x4817, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSubmarine' icon.
  static const IconData strokeRoundedSubmarine =
      IconData(0x4818, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSubmerge' icon.
  static const IconData strokeRoundedSubmerge =
      IconData(0x4819, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSubnodeAdd' icon.
  static const IconData strokeRoundedSubnodeAdd =
      IconData(0x481a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSubnodeDelete' icon.
  static const IconData strokeRoundedSubnodeDelete =
      IconData(0x481b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSubpoena' icon.
  static const IconData strokeRoundedSubpoena =
      IconData(0x481c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSubtitle' icon.
  static const IconData strokeRoundedSubtitle =
      IconData(0x481d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSuit01' icon.
  static const IconData strokeRoundedSuit01 =
      IconData(0x481e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSuit02' icon.
  static const IconData strokeRoundedSuit02 =
      IconData(0x481f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSujood' icon.
  static const IconData strokeRoundedSujood =
      IconData(0x4820, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSummation01' icon.
  static const IconData strokeRoundedSummation01 =
      IconData(0x4821, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSummation02' icon.
  static const IconData strokeRoundedSummation02 =
      IconData(0x4822, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSummationCircle' icon.
  static const IconData strokeRoundedSummationCircle =
      IconData(0x4823, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSummationSquare' icon.
  static const IconData strokeRoundedSummationSquare =
      IconData(0x4824, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSun01' icon.
  static const IconData strokeRoundedSun01 =
      IconData(0x4825, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSun02' icon.
  static const IconData strokeRoundedSun02 =
      IconData(0x4826, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSun03' icon.
  static const IconData strokeRoundedSun03 =
      IconData(0x4827, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloud01' icon.
  static const IconData strokeRoundedSunCloud01 =
      IconData(0x4828, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloud02' icon.
  static const IconData strokeRoundedSunCloud02 =
      IconData(0x4829, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloudAngledRain01' icon.
  static const IconData strokeRoundedSunCloudAngledRain01 =
      IconData(0x482a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloudAngledRain02' icon.
  static const IconData strokeRoundedSunCloudAngledRain02 =
      IconData(0x482b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloudAngledRainZap01' icon.
  static const IconData strokeRoundedSunCloudAngledRainZap01 =
      IconData(0x482c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloudAngledRainZap02' icon.
  static const IconData strokeRoundedSunCloudAngledRainZap02 =
      IconData(0x482d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloudAngledZap01' icon.
  static const IconData strokeRoundedSunCloudAngledZap01 =
      IconData(0x482e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloudAngledZap02' icon.
  static const IconData strokeRoundedSunCloudAngledZap02 =
      IconData(0x482f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloudBigRain01' icon.
  static const IconData strokeRoundedSunCloudBigRain01 =
      IconData(0x4830, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloudBigRain02' icon.
  static const IconData strokeRoundedSunCloudBigRain02 =
      IconData(0x4831, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloudFastWind01' icon.
  static const IconData strokeRoundedSunCloudFastWind01 =
      IconData(0x4832, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloudFastWind02' icon.
  static const IconData strokeRoundedSunCloudFastWind02 =
      IconData(0x4833, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloudHailstone01' icon.
  static const IconData strokeRoundedSunCloudHailstone01 =
      IconData(0x4834, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloudHailstone02' icon.
  static const IconData strokeRoundedSunCloudHailstone02 =
      IconData(0x4835, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloudLittleRain01' icon.
  static const IconData strokeRoundedSunCloudLittleRain01 =
      IconData(0x4836, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloudLittleRain02' icon.
  static const IconData strokeRoundedSunCloudLittleRain02 =
      IconData(0x4837, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloudLittleSnow01' icon.
  static const IconData strokeRoundedSunCloudLittleSnow01 =
      IconData(0x4838, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloudLittleSnow02' icon.
  static const IconData strokeRoundedSunCloudLittleSnow02 =
      IconData(0x4839, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloudMidRain01' icon.
  static const IconData strokeRoundedSunCloudMidRain01 =
      IconData(0x483a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloudMidRain02' icon.
  static const IconData strokeRoundedSunCloudMidRain02 =
      IconData(0x483b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloudMidSnow01' icon.
  static const IconData strokeRoundedSunCloudMidSnow01 =
      IconData(0x483c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloudMidSnow02' icon.
  static const IconData strokeRoundedSunCloudMidSnow02 =
      IconData(0x483d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloudSlowWind01' icon.
  static const IconData strokeRoundedSunCloudSlowWind01 =
      IconData(0x483e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloudSlowWind02' icon.
  static const IconData strokeRoundedSunCloudSlowWind02 =
      IconData(0x483f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloudSnow01' icon.
  static const IconData strokeRoundedSunCloudSnow01 =
      IconData(0x4840, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunCloudSnow02' icon.
  static const IconData strokeRoundedSunCloudSnow02 =
      IconData(0x4841, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunglasses' icon.
  static const IconData strokeRoundedSunglasses =
      IconData(0x4842, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunrise' icon.
  static const IconData strokeRoundedSunrise =
      IconData(0x4843, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSunset' icon.
  static const IconData strokeRoundedSunset =
      IconData(0x4844, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSuperMarioToad' icon.
  static const IconData strokeRoundedSuperMarioToad =
      IconData(0x4845, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSuperMario' icon.
  static const IconData strokeRoundedSuperMario =
      IconData(0x4846, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSurfboard' icon.
  static const IconData strokeRoundedSurfboard =
      IconData(0x4847, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSurprise' icon.
  static const IconData strokeRoundedSurprise =
      IconData(0x4848, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSushi01' icon.
  static const IconData strokeRoundedSushi01 =
      IconData(0x4849, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSushi02' icon.
  static const IconData strokeRoundedSushi02 =
      IconData(0x484a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSushi03' icon.
  static const IconData strokeRoundedSushi03 =
      IconData(0x484b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSuspicious' icon.
  static const IconData strokeRoundedSuspicious =
      IconData(0x484c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSustainableEnergy' icon.
  static const IconData strokeRoundedSustainableEnergy =
      IconData(0x484d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSvg01' icon.
  static const IconData strokeRoundedSvg01 =
      IconData(0x484e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSvg02' icon.
  static const IconData strokeRoundedSvg02 =
      IconData(0x484f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwarm' icon.
  static const IconData strokeRoundedSwarm =
      IconData(0x4850, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwatch' icon.
  static const IconData strokeRoundedSwatch =
      IconData(0x4851, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwimmingCap' icon.
  static const IconData strokeRoundedSwimmingCap =
      IconData(0x4852, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwimming' icon.
  static const IconData strokeRoundedSwimming =
      IconData(0x4853, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeDown01' icon.
  static const IconData strokeRoundedSwipeDown01 =
      IconData(0x4854, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeDown02' icon.
  static const IconData strokeRoundedSwipeDown02 =
      IconData(0x4855, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeDown03' icon.
  static const IconData strokeRoundedSwipeDown03 =
      IconData(0x4856, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeDown04' icon.
  static const IconData strokeRoundedSwipeDown04 =
      IconData(0x4857, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeDown05' icon.
  static const IconData strokeRoundedSwipeDown05 =
      IconData(0x4858, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeDown06' icon.
  static const IconData strokeRoundedSwipeDown06 =
      IconData(0x4859, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeDown07' icon.
  static const IconData strokeRoundedSwipeDown07 =
      IconData(0x485a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeDown08' icon.
  static const IconData strokeRoundedSwipeDown08 =
      IconData(0x485b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeLeft01' icon.
  static const IconData strokeRoundedSwipeLeft01 =
      IconData(0x485c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeLeft02' icon.
  static const IconData strokeRoundedSwipeLeft02 =
      IconData(0x485d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeLeft03' icon.
  static const IconData strokeRoundedSwipeLeft03 =
      IconData(0x485e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeLeft04' icon.
  static const IconData strokeRoundedSwipeLeft04 =
      IconData(0x485f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeLeft05' icon.
  static const IconData strokeRoundedSwipeLeft05 =
      IconData(0x4860, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeLeft06' icon.
  static const IconData strokeRoundedSwipeLeft06 =
      IconData(0x4861, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeLeft07' icon.
  static const IconData strokeRoundedSwipeLeft07 =
      IconData(0x4862, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeLeft08' icon.
  static const IconData strokeRoundedSwipeLeft08 =
      IconData(0x4863, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeLeft09' icon.
  static const IconData strokeRoundedSwipeLeft09 =
      IconData(0x4864, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeRight01' icon.
  static const IconData strokeRoundedSwipeRight01 =
      IconData(0x4865, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeRight02' icon.
  static const IconData strokeRoundedSwipeRight02 =
      IconData(0x4866, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeRight03' icon.
  static const IconData strokeRoundedSwipeRight03 =
      IconData(0x4867, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeRight04' icon.
  static const IconData strokeRoundedSwipeRight04 =
      IconData(0x4868, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeRight05' icon.
  static const IconData strokeRoundedSwipeRight05 =
      IconData(0x4869, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeRight06' icon.
  static const IconData strokeRoundedSwipeRight06 =
      IconData(0x486a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeRight07' icon.
  static const IconData strokeRoundedSwipeRight07 =
      IconData(0x486b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeRight08' icon.
  static const IconData strokeRoundedSwipeRight08 =
      IconData(0x486c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeRight09' icon.
  static const IconData strokeRoundedSwipeRight09 =
      IconData(0x486d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeUp01' icon.
  static const IconData strokeRoundedSwipeUp01 =
      IconData(0x486e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeUp02' icon.
  static const IconData strokeRoundedSwipeUp02 =
      IconData(0x486f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeUp03' icon.
  static const IconData strokeRoundedSwipeUp03 =
      IconData(0x4870, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeUp04' icon.
  static const IconData strokeRoundedSwipeUp04 =
      IconData(0x4871, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeUp05' icon.
  static const IconData strokeRoundedSwipeUp05 =
      IconData(0x4872, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeUp06' icon.
  static const IconData strokeRoundedSwipeUp06 =
      IconData(0x4873, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeUp07' icon.
  static const IconData strokeRoundedSwipeUp07 =
      IconData(0x4874, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSwipeUp08' icon.
  static const IconData strokeRoundedSwipeUp08 =
      IconData(0x4875, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSword01' icon.
  static const IconData strokeRoundedSword01 =
      IconData(0x4876, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSword02' icon.
  static const IconData strokeRoundedSword02 =
      IconData(0x4877, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSword03' icon.
  static const IconData strokeRoundedSword03 =
      IconData(0x4878, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSystemUpdate01' icon.
  static const IconData strokeRoundedSystemUpdate01 =
      IconData(0x4879, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedSystemUpdate02' icon.
  static const IconData strokeRoundedSystemUpdate02 =
      IconData(0x487a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTShirt' icon.
  static const IconData strokeRoundedTShirt =
      IconData(0x487b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTable01' icon.
  static const IconData strokeRoundedTable01 =
      IconData(0x487c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTable02' icon.
  static const IconData strokeRoundedTable02 =
      IconData(0x487d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTable03' icon.
  static const IconData strokeRoundedTable03 =
      IconData(0x487e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTableLamp01' icon.
  static const IconData strokeRoundedTableLamp01 =
      IconData(0x487f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTableLamp02' icon.
  static const IconData strokeRoundedTableLamp02 =
      IconData(0x4880, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTableRound' icon.
  static const IconData strokeRoundedTableRound =
      IconData(0x4881, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTableTennisBat' icon.
  static const IconData strokeRoundedTableTennisBat =
      IconData(0x4882, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTable' icon.
  static const IconData strokeRoundedTable =
      IconData(0x4883, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTablet01' icon.
  static const IconData strokeRoundedTablet01 =
      IconData(0x4884, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTablet02' icon.
  static const IconData strokeRoundedTablet02 =
      IconData(0x4885, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTabletConnectedBluetooth' icon.
  static const IconData strokeRoundedTabletConnectedBluetooth =
      IconData(0x4886, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTabletConnectedUsb' icon.
  static const IconData strokeRoundedTabletConnectedUsb =
      IconData(0x4887, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTabletConnectedWifi' icon.
  static const IconData strokeRoundedTabletConnectedWifi =
      IconData(0x4888, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTabletPen' icon.
  static const IconData strokeRoundedTabletPen =
      IconData(0x4889, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTaco01' icon.
  static const IconData strokeRoundedTaco01 =
      IconData(0x488a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTaco02' icon.
  static const IconData strokeRoundedTaco02 =
      IconData(0x488b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTag01' icon.
  static const IconData strokeRoundedTag01 =
      IconData(0x488c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTag02' icon.
  static const IconData strokeRoundedTag02 =
      IconData(0x488d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTags' icon.
  static const IconData strokeRoundedTags =
      IconData(0x488e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTajMahal' icon.
  static const IconData strokeRoundedTajMahal =
      IconData(0x488f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTan' icon.
  static const IconData strokeRoundedTan =
      IconData(0x4890, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTankTop' icon.
  static const IconData strokeRoundedTankTop =
      IconData(0x4891, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTap01' icon.
  static const IconData strokeRoundedTap01 =
      IconData(0x4892, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTap02' icon.
  static const IconData strokeRoundedTap02 =
      IconData(0x4893, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTap03' icon.
  static const IconData strokeRoundedTap03 =
      IconData(0x4894, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTap04' icon.
  static const IconData strokeRoundedTap04 =
      IconData(0x4895, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTap05' icon.
  static const IconData strokeRoundedTap05 =
      IconData(0x4896, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTap06' icon.
  static const IconData strokeRoundedTap06 =
      IconData(0x4897, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTap07' icon.
  static const IconData strokeRoundedTap07 =
      IconData(0x4898, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTap08' icon.
  static const IconData strokeRoundedTap08 =
      IconData(0x4899, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTapeMeasure' icon.
  static const IconData strokeRoundedTapeMeasure =
      IconData(0x489a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTarget01' icon.
  static const IconData strokeRoundedTarget01 =
      IconData(0x489b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTarget02' icon.
  static const IconData strokeRoundedTarget02 =
      IconData(0x489c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTarget03' icon.
  static const IconData strokeRoundedTarget03 =
      IconData(0x489d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTargetDollar' icon.
  static const IconData strokeRoundedTargetDollar =
      IconData(0x489e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTasbih' icon.
  static const IconData strokeRoundedTasbih =
      IconData(0x489f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTask01' icon.
  static const IconData strokeRoundedTask01 =
      IconData(0x48a0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTask02' icon.
  static const IconData strokeRoundedTask02 =
      IconData(0x48a1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTaskAdd01' icon.
  static const IconData strokeRoundedTaskAdd01 =
      IconData(0x48a2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTaskAdd02' icon.
  static const IconData strokeRoundedTaskAdd02 =
      IconData(0x48a3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTaskDaily01' icon.
  static const IconData strokeRoundedTaskDaily01 =
      IconData(0x48a4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTaskDaily02' icon.
  static const IconData strokeRoundedTaskDaily02 =
      IconData(0x48a5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTaskDone01' icon.
  static const IconData strokeRoundedTaskDone01 =
      IconData(0x48a6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTaskDone02' icon.
  static const IconData strokeRoundedTaskDone02 =
      IconData(0x48a7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTaskEdit01' icon.
  static const IconData strokeRoundedTaskEdit01 =
      IconData(0x48a8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTaskEdit02' icon.
  static const IconData strokeRoundedTaskEdit02 =
      IconData(0x48a9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTaskRemove01' icon.
  static const IconData strokeRoundedTaskRemove01 =
      IconData(0x48aa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTaskRemove02' icon.
  static const IconData strokeRoundedTaskRemove02 =
      IconData(0x48ab, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTaxes' icon.
  static const IconData strokeRoundedTaxes =
      IconData(0x48ac, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTaxi' icon.
  static const IconData strokeRoundedTaxi =
      IconData(0x48ad, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTeaPod' icon.
  static const IconData strokeRoundedTeaPod =
      IconData(0x48ae, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTea' icon.
  static const IconData strokeRoundedTea =
      IconData(0x48af, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTeacher' icon.
  static const IconData strokeRoundedTeacher =
      IconData(0x48b0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTeaching' icon.
  static const IconData strokeRoundedTeaching =
      IconData(0x48b1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTeamviewer' icon.
  static const IconData strokeRoundedTeamviewer =
      IconData(0x48b2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTelegram' icon.
  static const IconData strokeRoundedTelegram =
      IconData(0x48b3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTelephone' icon.
  static const IconData strokeRoundedTelephone =
      IconData(0x48b4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTelescope01' icon.
  static const IconData strokeRoundedTelescope01 =
      IconData(0x48b5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTelescope02' icon.
  static const IconData strokeRoundedTelescope02 =
      IconData(0x48b6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTelevisionTable' icon.
  static const IconData strokeRoundedTelevisionTable =
      IconData(0x48b7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTemperature' icon.
  static const IconData strokeRoundedTemperature =
      IconData(0x48b8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTennisBall' icon.
  static const IconData strokeRoundedTennisBall =
      IconData(0x48b9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTerrace' icon.
  static const IconData strokeRoundedTerrace =
      IconData(0x48ba, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTestTube01' icon.
  static const IconData strokeRoundedTestTube01 =
      IconData(0x48bb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTestTube02' icon.
  static const IconData strokeRoundedTestTube02 =
      IconData(0x48bc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTestTube03' icon.
  static const IconData strokeRoundedTestTube03 =
      IconData(0x48bd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTestTube' icon.
  static const IconData strokeRoundedTestTube =
      IconData(0x48be, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTetris' icon.
  static const IconData strokeRoundedTetris =
      IconData(0x48bf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextAlignCenter' icon.
  static const IconData strokeRoundedTextAlignCenter =
      IconData(0x48c0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextAlignJustifyCenter' icon.
  static const IconData strokeRoundedTextAlignJustifyCenter =
      IconData(0x48c1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextAlignJustifyLeft' icon.
  static const IconData strokeRoundedTextAlignJustifyLeft =
      IconData(0x48c2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextAlignJustifyRight' icon.
  static const IconData strokeRoundedTextAlignJustifyRight =
      IconData(0x48c3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextAlignLeft01' icon.
  static const IconData strokeRoundedTextAlignLeft01 =
      IconData(0x48c4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextAlignLeft' icon.
  static const IconData strokeRoundedTextAlignLeft =
      IconData(0x48c5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextAlignRight01' icon.
  static const IconData strokeRoundedTextAlignRight01 =
      IconData(0x48c6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextAlignRight' icon.
  static const IconData strokeRoundedTextAlignRight =
      IconData(0x48c7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextAllCaps' icon.
  static const IconData strokeRoundedTextAllCaps =
      IconData(0x48c8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextBold' icon.
  static const IconData strokeRoundedTextBold =
      IconData(0x48c9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextCenterlineCenterTop' icon.
  static const IconData strokeRoundedTextCenterlineCenterTop =
      IconData(0x48ca, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextCenterlineLeft' icon.
  static const IconData strokeRoundedTextCenterlineLeft =
      IconData(0x48cb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextCenterlineMiddle' icon.
  static const IconData strokeRoundedTextCenterlineMiddle =
      IconData(0x48cc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextCenterlineRight' icon.
  static const IconData strokeRoundedTextCenterlineRight =
      IconData(0x48cd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextCheck' icon.
  static const IconData strokeRoundedTextCheck =
      IconData(0x48ce, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextCircle' icon.
  static const IconData strokeRoundedTextCircle =
      IconData(0x48cf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextClear' icon.
  static const IconData strokeRoundedTextClear =
      IconData(0x48d0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextColor' icon.
  static const IconData strokeRoundedTextColor =
      IconData(0x48d1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextCreation' icon.
  static const IconData strokeRoundedTextCreation =
      IconData(0x48d2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextFirstlineLeft' icon.
  static const IconData strokeRoundedTextFirstlineLeft =
      IconData(0x48d3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextFirstlineRight' icon.
  static const IconData strokeRoundedTextFirstlineRight =
      IconData(0x48d4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextFont' icon.
  static const IconData strokeRoundedTextFont =
      IconData(0x48d5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextFootnote' icon.
  static const IconData strokeRoundedTextFootnote =
      IconData(0x48d6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextIndent01' icon.
  static const IconData strokeRoundedTextIndent01 =
      IconData(0x48d7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextIndentLess' icon.
  static const IconData strokeRoundedTextIndentLess =
      IconData(0x48d8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextIndentMore' icon.
  static const IconData strokeRoundedTextIndentMore =
      IconData(0x48d9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextIndent' icon.
  static const IconData strokeRoundedTextIndent =
      IconData(0x48da, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextItalicSlash' icon.
  static const IconData strokeRoundedTextItalicSlash =
      IconData(0x48db, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextItalic' icon.
  static const IconData strokeRoundedTextItalic =
      IconData(0x48dc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextKerning' icon.
  static const IconData strokeRoundedTextKerning =
      IconData(0x48dd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextNumberSign' icon.
  static const IconData strokeRoundedTextNumberSign =
      IconData(0x48de, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextSelection' icon.
  static const IconData strokeRoundedTextSelection =
      IconData(0x48df, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextSmallcaps' icon.
  static const IconData strokeRoundedTextSmallcaps =
      IconData(0x48e0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextSquare' icon.
  static const IconData strokeRoundedTextSquare =
      IconData(0x48e1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextStrikethrough' icon.
  static const IconData strokeRoundedTextStrikethrough =
      IconData(0x48e2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextSubscript' icon.
  static const IconData strokeRoundedTextSubscript =
      IconData(0x48e3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextSuperscript' icon.
  static const IconData strokeRoundedTextSuperscript =
      IconData(0x48e4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextTracking' icon.
  static const IconData strokeRoundedTextTracking =
      IconData(0x48e5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextUnderline' icon.
  static const IconData strokeRoundedTextUnderline =
      IconData(0x48e6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextVariableFront' icon.
  static const IconData strokeRoundedTextVariableFront =
      IconData(0x48e7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextVerticalAlignment' icon.
  static const IconData strokeRoundedTextVerticalAlignment =
      IconData(0x48e8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTextWrap' icon.
  static const IconData strokeRoundedTextWrap =
      IconData(0x48e9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedText' icon.
  static const IconData strokeRoundedText =
      IconData(0x48ea, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTheProphetsMosque' icon.
  static const IconData strokeRoundedTheProphetsMosque =
      IconData(0x48eb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThermometerCold' icon.
  static const IconData strokeRoundedThermometerCold =
      IconData(0x48ec, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThermometerWarm' icon.
  static const IconData strokeRoundedThermometerWarm =
      IconData(0x48ed, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThermometer' icon.
  static const IconData strokeRoundedThermometer =
      IconData(0x48ee, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThirdBracketCircle' icon.
  static const IconData strokeRoundedThirdBracketCircle =
      IconData(0x48ef, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThirdBracketSquare' icon.
  static const IconData strokeRoundedThirdBracketSquare =
      IconData(0x48f0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThirdBracket' icon.
  static const IconData strokeRoundedThirdBracket =
      IconData(0x48f1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThread' icon.
  static const IconData strokeRoundedThread =
      IconData(0x48f2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThreadsEllipse' icon.
  static const IconData strokeRoundedThreadsEllipse =
      IconData(0x48f3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThreadsRectangle' icon.
  static const IconData strokeRoundedThreadsRectangle =
      IconData(0x48f4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThreads' icon.
  static const IconData strokeRoundedThreads =
      IconData(0x48f5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThreeDMove' icon.
  static const IconData strokeRoundedThreeDMove =
      IconData(0x48f6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThreeDRotate' icon.
  static const IconData strokeRoundedThreeDRotate =
      IconData(0x48f7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThreeDScale' icon.
  static const IconData strokeRoundedThreeDScale =
      IconData(0x48f8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThreeDView' icon.
  static const IconData strokeRoundedThreeDView =
      IconData(0x48f9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThreeFinger01' icon.
  static const IconData strokeRoundedThreeFinger01 =
      IconData(0x48fa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThreeFinger02' icon.
  static const IconData strokeRoundedThreeFinger02 =
      IconData(0x48fb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThreeFinger03' icon.
  static const IconData strokeRoundedThreeFinger03 =
      IconData(0x48fc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThreeFinger04' icon.
  static const IconData strokeRoundedThreeFinger04 =
      IconData(0x48fd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThreeFinger05' icon.
  static const IconData strokeRoundedThreeFinger05 =
      IconData(0x48fe, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThumbsDownEllipse' icon.
  static const IconData strokeRoundedThumbsDownEllipse =
      IconData(0x48ff, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThumbsDownRectangle' icon.
  static const IconData strokeRoundedThumbsDownRectangle =
      IconData(0x4900, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThumbsDown' icon.
  static const IconData strokeRoundedThumbsDown =
      IconData(0x4901, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThumbsUpDown' icon.
  static const IconData strokeRoundedThumbsUpDown =
      IconData(0x4902, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThumbsUpEllipse' icon.
  static const IconData strokeRoundedThumbsUpEllipse =
      IconData(0x4903, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThumbsUpRectangle' icon.
  static const IconData strokeRoundedThumbsUpRectangle =
      IconData(0x4904, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedThumbsUp' icon.
  static const IconData strokeRoundedThumbsUp =
      IconData(0x4905, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTicTacToe' icon.
  static const IconData strokeRoundedTicTacToe =
      IconData(0x4906, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTick01' icon.
  static const IconData strokeRoundedTick01 =
      IconData(0x4907, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTick02' icon.
  static const IconData strokeRoundedTick02 =
      IconData(0x4908, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTick03' icon.
  static const IconData strokeRoundedTick03 =
      IconData(0x4909, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTick04' icon.
  static const IconData strokeRoundedTick04 =
      IconData(0x490a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTickDouble01' icon.
  static const IconData strokeRoundedTickDouble01 =
      IconData(0x490b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTickDouble02' icon.
  static const IconData strokeRoundedTickDouble02 =
      IconData(0x490c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTickDouble03' icon.
  static const IconData strokeRoundedTickDouble03 =
      IconData(0x490d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTickDouble04' icon.
  static const IconData strokeRoundedTickDouble04 =
      IconData(0x490e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTicket01' icon.
  static const IconData strokeRoundedTicket01 =
      IconData(0x490f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTicket02' icon.
  static const IconData strokeRoundedTicket02 =
      IconData(0x4910, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTicket03' icon.
  static const IconData strokeRoundedTicket03 =
      IconData(0x4911, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTicketStar' icon.
  static const IconData strokeRoundedTicketStar =
      IconData(0x4912, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTie' icon.
  static const IconData strokeRoundedTie =
      IconData(0x4913, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTiktok' icon.
  static const IconData strokeRoundedTiktok =
      IconData(0x4914, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTime01' icon.
  static const IconData strokeRoundedTime01 =
      IconData(0x4915, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTime02' icon.
  static const IconData strokeRoundedTime02 =
      IconData(0x4916, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTime03' icon.
  static const IconData strokeRoundedTime03 =
      IconData(0x4917, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTime04' icon.
  static const IconData strokeRoundedTime04 =
      IconData(0x4918, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTimeHalfPass' icon.
  static const IconData strokeRoundedTimeHalfPass =
      IconData(0x4919, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTimeManagementCircle' icon.
  static const IconData strokeRoundedTimeManagementCircle =
      IconData(0x491a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTimeManagement' icon.
  static const IconData strokeRoundedTimeManagement =
      IconData(0x491b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTimeQuarterPass' icon.
  static const IconData strokeRoundedTimeQuarterPass =
      IconData(0x491c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTimeQuarter' icon.
  static const IconData strokeRoundedTimeQuarter =
      IconData(0x491d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTimeSchedule' icon.
  static const IconData strokeRoundedTimeSchedule =
      IconData(0x491e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTimeSetting01' icon.
  static const IconData strokeRoundedTimeSetting01 =
      IconData(0x491f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTimeSetting02' icon.
  static const IconData strokeRoundedTimeSetting02 =
      IconData(0x4920, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTimeSetting03' icon.
  static const IconData strokeRoundedTimeSetting03 =
      IconData(0x4921, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTimer01' icon.
  static const IconData strokeRoundedTimer01 =
      IconData(0x4922, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTimer02' icon.
  static const IconData strokeRoundedTimer02 =
      IconData(0x4923, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTips' icon.
  static const IconData strokeRoundedTips =
      IconData(0x4924, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTired01' icon.
  static const IconData strokeRoundedTired01 =
      IconData(0x4925, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTired02' icon.
  static const IconData strokeRoundedTired02 =
      IconData(0x4926, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTissuePaper' icon.
  static const IconData strokeRoundedTissuePaper =
      IconData(0x4927, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedToggleOff' icon.
  static const IconData strokeRoundedToggleOff =
      IconData(0x4928, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedToggleOn' icon.
  static const IconData strokeRoundedToggleOn =
      IconData(0x4929, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedToilet01' icon.
  static const IconData strokeRoundedToilet01 =
      IconData(0x492a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedToilet02' icon.
  static const IconData strokeRoundedToilet02 =
      IconData(0x492b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTongue01' icon.
  static const IconData strokeRoundedTongue01 =
      IconData(0x492c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTongueWinkLeft' icon.
  static const IconData strokeRoundedTongueWinkLeft =
      IconData(0x492d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTongueWinkRight' icon.
  static const IconData strokeRoundedTongueWinkRight =
      IconData(0x492e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTongue' icon.
  static const IconData strokeRoundedTongue =
      IconData(0x492f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTools' icon.
  static const IconData strokeRoundedTools =
      IconData(0x4930, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTornado01' icon.
  static const IconData strokeRoundedTornado01 =
      IconData(0x4931, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTornado02' icon.
  static const IconData strokeRoundedTornado02 =
      IconData(0x4932, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTorriGate' icon.
  static const IconData strokeRoundedTorriGate =
      IconData(0x4933, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTouch01' icon.
  static const IconData strokeRoundedTouch01 =
      IconData(0x4934, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTouch02' icon.
  static const IconData strokeRoundedTouch02 =
      IconData(0x4935, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTouch03' icon.
  static const IconData strokeRoundedTouch03 =
      IconData(0x4936, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTouch04' icon.
  static const IconData strokeRoundedTouch04 =
      IconData(0x4937, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTouch05' icon.
  static const IconData strokeRoundedTouch05 =
      IconData(0x4938, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTouch06' icon.
  static const IconData strokeRoundedTouch06 =
      IconData(0x4939, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTouch07' icon.
  static const IconData strokeRoundedTouch07 =
      IconData(0x493a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTouch08' icon.
  static const IconData strokeRoundedTouch08 =
      IconData(0x493b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTouch09' icon.
  static const IconData strokeRoundedTouch09 =
      IconData(0x493c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTouch10' icon.
  static const IconData strokeRoundedTouch10 =
      IconData(0x493d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTouchInteraction01' icon.
  static const IconData strokeRoundedTouchInteraction01 =
      IconData(0x493e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTouchInteraction02' icon.
  static const IconData strokeRoundedTouchInteraction02 =
      IconData(0x493f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTouchInteraction03' icon.
  static const IconData strokeRoundedTouchInteraction03 =
      IconData(0x4940, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTouchInteraction04' icon.
  static const IconData strokeRoundedTouchInteraction04 =
      IconData(0x4941, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTouchLocked01' icon.
  static const IconData strokeRoundedTouchLocked01 =
      IconData(0x4942, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTouchLocked02' icon.
  static const IconData strokeRoundedTouchLocked02 =
      IconData(0x4943, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTouchLocked03' icon.
  static const IconData strokeRoundedTouchLocked03 =
      IconData(0x4944, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTouchLocked04' icon.
  static const IconData strokeRoundedTouchLocked04 =
      IconData(0x4945, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTouchpad01' icon.
  static const IconData strokeRoundedTouchpad01 =
      IconData(0x4946, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTouchpad02' icon.
  static const IconData strokeRoundedTouchpad02 =
      IconData(0x4947, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTouchpad03' icon.
  static const IconData strokeRoundedTouchpad03 =
      IconData(0x4948, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTouchpad04' icon.
  static const IconData strokeRoundedTouchpad04 =
      IconData(0x4949, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTowTruck' icon.
  static const IconData strokeRoundedTowTruck =
      IconData(0x494a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTowels' icon.
  static const IconData strokeRoundedTowels =
      IconData(0x494b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedToyTrain' icon.
  static const IconData strokeRoundedToyTrain =
      IconData(0x494c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTractor' icon.
  static const IconData strokeRoundedTractor =
      IconData(0x494d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTradeDown' icon.
  static const IconData strokeRoundedTradeDown =
      IconData(0x494e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTradeMark' icon.
  static const IconData strokeRoundedTradeMark =
      IconData(0x494f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTradeUp' icon.
  static const IconData strokeRoundedTradeUp =
      IconData(0x4950, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTrademark' icon.
  static const IconData strokeRoundedTrademark =
      IconData(0x4951, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTrafficIncident' icon.
  static const IconData strokeRoundedTrafficIncident =
      IconData(0x4952, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTrafficLight' icon.
  static const IconData strokeRoundedTrafficLight =
      IconData(0x4953, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTrain01' icon.
  static const IconData strokeRoundedTrain01 =
      IconData(0x4954, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTrain02' icon.
  static const IconData strokeRoundedTrain02 =
      IconData(0x4955, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTram' icon.
  static const IconData strokeRoundedTram =
      IconData(0x4956, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTrampoline' icon.
  static const IconData strokeRoundedTrampoline =
      IconData(0x4957, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTransaction' icon.
  static const IconData strokeRoundedTransaction =
      IconData(0x4958, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTransitionBottom' icon.
  static const IconData strokeRoundedTransitionBottom =
      IconData(0x4959, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTransitionLeft' icon.
  static const IconData strokeRoundedTransitionLeft =
      IconData(0x495a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTransitionRight' icon.
  static const IconData strokeRoundedTransitionRight =
      IconData(0x495b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTransitionTop' icon.
  static const IconData strokeRoundedTransitionTop =
      IconData(0x495c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTranslate' icon.
  static const IconData strokeRoundedTranslate =
      IconData(0x495d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTranslation' icon.
  static const IconData strokeRoundedTranslation =
      IconData(0x495e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTransmission' icon.
  static const IconData strokeRoundedTransmission =
      IconData(0x495f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTransparency' icon.
  static const IconData strokeRoundedTransparency =
      IconData(0x4960, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTrapezoidLineHorizontal' icon.
  static const IconData strokeRoundedTrapezoidLineHorizontal =
      IconData(0x4961, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTrapezoidLineVertical' icon.
  static const IconData strokeRoundedTrapezoidLineVertical =
      IconData(0x4962, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTravelBag' icon.
  static const IconData strokeRoundedTravelBag =
      IconData(0x4963, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTreadmill01' icon.
  static const IconData strokeRoundedTreadmill01 =
      IconData(0x4964, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTreadmill02' icon.
  static const IconData strokeRoundedTreadmill02 =
      IconData(0x4965, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTreatment' icon.
  static const IconData strokeRoundedTreatment =
      IconData(0x4966, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTree01' icon.
  static const IconData strokeRoundedTree01 =
      IconData(0x4967, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTree02' icon.
  static const IconData strokeRoundedTree02 =
      IconData(0x4968, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTree03' icon.
  static const IconData strokeRoundedTree03 =
      IconData(0x4969, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTree04' icon.
  static const IconData strokeRoundedTree04 =
      IconData(0x496a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTree05' icon.
  static const IconData strokeRoundedTree05 =
      IconData(0x496b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTree06' icon.
  static const IconData strokeRoundedTree06 =
      IconData(0x496c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTree07' icon.
  static const IconData strokeRoundedTree07 =
      IconData(0x496d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTrello' icon.
  static const IconData strokeRoundedTrello =
      IconData(0x496e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTriangle01' icon.
  static const IconData strokeRoundedTriangle01 =
      IconData(0x496f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTriangle02' icon.
  static const IconData strokeRoundedTriangle02 =
      IconData(0x4970, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTriangle03' icon.
  static const IconData strokeRoundedTriangle03 =
      IconData(0x4971, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTriangle' icon.
  static const IconData strokeRoundedTriangle =
      IconData(0x4972, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTrolley01' icon.
  static const IconData strokeRoundedTrolley01 =
      IconData(0x4973, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTrolley02' icon.
  static const IconData strokeRoundedTrolley02 =
      IconData(0x4974, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTropicalStormTracks01' icon.
  static const IconData strokeRoundedTropicalStormTracks01 =
      IconData(0x4975, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTropicalStormTracks02' icon.
  static const IconData strokeRoundedTropicalStormTracks02 =
      IconData(0x4976, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTropicalStorm' icon.
  static const IconData strokeRoundedTropicalStorm =
      IconData(0x4977, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTruckDelivery' icon.
  static const IconData strokeRoundedTruckDelivery =
      IconData(0x4978, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTruckMonster' icon.
  static const IconData strokeRoundedTruckMonster =
      IconData(0x4979, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTruckReturn' icon.
  static const IconData strokeRoundedTruckReturn =
      IconData(0x497a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTruck' icon.
  static const IconData strokeRoundedTruck =
      IconData(0x497b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTrulli' icon.
  static const IconData strokeRoundedTrulli =
      IconData(0x497c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTsunami' icon.
  static const IconData strokeRoundedTsunami =
      IconData(0x497d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTulip' icon.
  static const IconData strokeRoundedTulip =
      IconData(0x497e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTumblr' icon.
  static const IconData strokeRoundedTumblr =
      IconData(0x497f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTurtleNeck' icon.
  static const IconData strokeRoundedTurtleNeck =
      IconData(0x4980, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTv01' icon.
  static const IconData strokeRoundedTv01 =
      IconData(0x4981, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTv02' icon.
  static const IconData strokeRoundedTv02 =
      IconData(0x4982, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTvFix' icon.
  static const IconData strokeRoundedTvFix =
      IconData(0x4983, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTvIssue' icon.
  static const IconData strokeRoundedTvIssue =
      IconData(0x4984, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTvSmart' icon.
  static const IconData strokeRoundedTvSmart =
      IconData(0x4985, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTwinTower' icon.
  static const IconData strokeRoundedTwinTower =
      IconData(0x4986, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTwitch' icon.
  static const IconData strokeRoundedTwitch =
      IconData(0x4987, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTwitterSquare' icon.
  static const IconData strokeRoundedTwitterSquare =
      IconData(0x4988, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTwitter' icon.
  static const IconData strokeRoundedTwitter =
      IconData(0x4989, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTwoFactorAccess' icon.
  static const IconData strokeRoundedTwoFactorAccess =
      IconData(0x498a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTwoFinger01' icon.
  static const IconData strokeRoundedTwoFinger01 =
      IconData(0x498b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTwoFinger02' icon.
  static const IconData strokeRoundedTwoFinger02 =
      IconData(0x498c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTwoFinger03' icon.
  static const IconData strokeRoundedTwoFinger03 =
      IconData(0x498d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTwoFinger04' icon.
  static const IconData strokeRoundedTwoFinger04 =
      IconData(0x498e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTwoFinger05' icon.
  static const IconData strokeRoundedTwoFinger05 =
      IconData(0x498f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTxt01' icon.
  static const IconData strokeRoundedTxt01 =
      IconData(0x4990, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTxt02' icon.
  static const IconData strokeRoundedTxt02 =
      IconData(0x4991, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTypeCursor' icon.
  static const IconData strokeRoundedTypeCursor =
      IconData(0x4992, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTypescript01' icon.
  static const IconData strokeRoundedTypescript01 =
      IconData(0x4993, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTypescript02' icon.
  static const IconData strokeRoundedTypescript02 =
      IconData(0x4994, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedTypescript03' icon.
  static const IconData strokeRoundedTypescript03 =
      IconData(0x4995, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUber' icon.
  static const IconData strokeRoundedUber =
      IconData(0x4996, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUfo01' icon.
  static const IconData strokeRoundedUfo01 =
      IconData(0x4997, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUfo' icon.
  static const IconData strokeRoundedUfo =
      IconData(0x4998, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUmbrellaDollar' icon.
  static const IconData strokeRoundedUmbrellaDollar =
      IconData(0x4999, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUmbrella' icon.
  static const IconData strokeRoundedUmbrella =
      IconData(0x499a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUnamused' icon.
  static const IconData strokeRoundedUnamused =
      IconData(0x499b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUnavailable' icon.
  static const IconData strokeRoundedUnavailable =
      IconData(0x499c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUnderpants01' icon.
  static const IconData strokeRoundedUnderpants01 =
      IconData(0x499d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUnderpants02' icon.
  static const IconData strokeRoundedUnderpants02 =
      IconData(0x499e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUnderpants03' icon.
  static const IconData strokeRoundedUnderpants03 =
      IconData(0x499f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUnfoldLess' icon.
  static const IconData strokeRoundedUnfoldLess =
      IconData(0x49a0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUnfoldMore' icon.
  static const IconData strokeRoundedUnfoldMore =
      IconData(0x49a1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUngroupItems' icon.
  static const IconData strokeRoundedUngroupItems =
      IconData(0x49a2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUngroupLayers' icon.
  static const IconData strokeRoundedUngroupLayers =
      IconData(0x49a3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUnhappy' icon.
  static const IconData strokeRoundedUnhappy =
      IconData(0x49a4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUniversity' icon.
  static const IconData strokeRoundedUniversity =
      IconData(0x49a5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUnlink01' icon.
  static const IconData strokeRoundedUnlink01 =
      IconData(0x49a6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUnlink02' icon.
  static const IconData strokeRoundedUnlink02 =
      IconData(0x49a7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUnlink03' icon.
  static const IconData strokeRoundedUnlink03 =
      IconData(0x49a8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUnlink04' icon.
  static const IconData strokeRoundedUnlink04 =
      IconData(0x49a9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUnlink05' icon.
  static const IconData strokeRoundedUnlink05 =
      IconData(0x49aa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUnlink06' icon.
  static const IconData strokeRoundedUnlink06 =
      IconData(0x49ab, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUnsplash' icon.
  static const IconData strokeRoundedUnsplash =
      IconData(0x49ac, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUpload01' icon.
  static const IconData strokeRoundedUpload01 =
      IconData(0x49ad, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUpload02' icon.
  static const IconData strokeRoundedUpload02 =
      IconData(0x49ae, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUpload03' icon.
  static const IconData strokeRoundedUpload03 =
      IconData(0x49af, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUpload04' icon.
  static const IconData strokeRoundedUpload04 =
      IconData(0x49b0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUpload05' icon.
  static const IconData strokeRoundedUpload05 =
      IconData(0x49b1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUploadCircle01' icon.
  static const IconData strokeRoundedUploadCircle01 =
      IconData(0x49b2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUploadCircle02' icon.
  static const IconData strokeRoundedUploadCircle02 =
      IconData(0x49b3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUploadSquare01' icon.
  static const IconData strokeRoundedUploadSquare01 =
      IconData(0x49b4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUploadSquare02' icon.
  static const IconData strokeRoundedUploadSquare02 =
      IconData(0x49b5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUpwork' icon.
  static const IconData strokeRoundedUpwork =
      IconData(0x49b6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUsbBugs' icon.
  static const IconData strokeRoundedUsbBugs =
      IconData(0x49b7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUsbConnected01' icon.
  static const IconData strokeRoundedUsbConnected01 =
      IconData(0x49b8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUsbConnected02' icon.
  static const IconData strokeRoundedUsbConnected02 =
      IconData(0x49b9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUsbConnected03' icon.
  static const IconData strokeRoundedUsbConnected03 =
      IconData(0x49ba, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUsbError' icon.
  static const IconData strokeRoundedUsbError =
      IconData(0x49bb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUsbMemory01' icon.
  static const IconData strokeRoundedUsbMemory01 =
      IconData(0x49bc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUsbMemory02' icon.
  static const IconData strokeRoundedUsbMemory02 =
      IconData(0x49bd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUsbNotConnected01' icon.
  static const IconData strokeRoundedUsbNotConnected01 =
      IconData(0x49be, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUsbNotConnected02' icon.
  static const IconData strokeRoundedUsbNotConnected02 =
      IconData(0x49bf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUsb' icon.
  static const IconData strokeRoundedUsb =
      IconData(0x49c0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserAccount' icon.
  static const IconData strokeRoundedUserAccount =
      IconData(0x49c1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserAdd01' icon.
  static const IconData strokeRoundedUserAdd01 =
      IconData(0x49c2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserAdd02' icon.
  static const IconData strokeRoundedUserAdd02 =
      IconData(0x49c3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserArrowLeftRight' icon.
  static const IconData strokeRoundedUserArrowLeftRight =
      IconData(0x49c4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserBlock01' icon.
  static const IconData strokeRoundedUserBlock01 =
      IconData(0x49c5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserBlock02' icon.
  static const IconData strokeRoundedUserBlock02 =
      IconData(0x49c6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserCheck01' icon.
  static const IconData strokeRoundedUserCheck01 =
      IconData(0x49c7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserCheck02' icon.
  static const IconData strokeRoundedUserCheck02 =
      IconData(0x49c8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserCircle02' icon.
  static const IconData strokeRoundedUserCircle02 =
      IconData(0x49c9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserCircle' icon.
  static const IconData strokeRoundedUserCircle =
      IconData(0x49ca, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserEdit01' icon.
  static const IconData strokeRoundedUserEdit01 =
      IconData(0x49cb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserFullView' icon.
  static const IconData strokeRoundedUserFullView =
      IconData(0x49cc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserGroup' icon.
  static const IconData strokeRoundedUserGroup =
      IconData(0x49cd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserIdVerification' icon.
  static const IconData strokeRoundedUserIdVerification =
      IconData(0x49ce, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserList' icon.
  static const IconData strokeRoundedUserList =
      IconData(0x49cf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserLock01' icon.
  static const IconData strokeRoundedUserLock01 =
      IconData(0x49d0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserLock02' icon.
  static const IconData strokeRoundedUserLock02 =
      IconData(0x49d1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserLove01' icon.
  static const IconData strokeRoundedUserLove01 =
      IconData(0x49d2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserLove02' icon.
  static const IconData strokeRoundedUserLove02 =
      IconData(0x49d3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserMinus01' icon.
  static const IconData strokeRoundedUserMinus01 =
      IconData(0x49d4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserMinus02' icon.
  static const IconData strokeRoundedUserMinus02 =
      IconData(0x49d5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserMultiple02' icon.
  static const IconData strokeRoundedUserMultiple02 =
      IconData(0x49d6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserMultiple' icon.
  static const IconData strokeRoundedUserMultiple =
      IconData(0x49d7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserQuestion01' icon.
  static const IconData strokeRoundedUserQuestion01 =
      IconData(0x49d8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserQuestion02' icon.
  static const IconData strokeRoundedUserQuestion02 =
      IconData(0x49d9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserRemove01' icon.
  static const IconData strokeRoundedUserRemove01 =
      IconData(0x49da, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserRemove02' icon.
  static const IconData strokeRoundedUserRemove02 =
      IconData(0x49db, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserRoadside' icon.
  static const IconData strokeRoundedUserRoadside =
      IconData(0x49dc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserSearch01' icon.
  static const IconData strokeRoundedUserSearch01 =
      IconData(0x49dd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserSearch02' icon.
  static const IconData strokeRoundedUserSearch02 =
      IconData(0x49de, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserSettings01' icon.
  static const IconData strokeRoundedUserSettings01 =
      IconData(0x49df, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserSettings02' icon.
  static const IconData strokeRoundedUserSettings02 =
      IconData(0x49e0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserSharing' icon.
  static const IconData strokeRoundedUserSharing =
      IconData(0x49e1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserShield01' icon.
  static const IconData strokeRoundedUserShield01 =
      IconData(0x49e2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserShield02' icon.
  static const IconData strokeRoundedUserShield02 =
      IconData(0x49e3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserSquare' icon.
  static const IconData strokeRoundedUserSquare =
      IconData(0x49e4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserStar01' icon.
  static const IconData strokeRoundedUserStar01 =
      IconData(0x49e5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserStar02' icon.
  static const IconData strokeRoundedUserStar02 =
      IconData(0x49e6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserStatus' icon.
  static const IconData strokeRoundedUserStatus =
      IconData(0x49e7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserStory' icon.
  static const IconData strokeRoundedUserStory =
      IconData(0x49e8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserSwitch' icon.
  static const IconData strokeRoundedUserSwitch =
      IconData(0x49e9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserUnlock01' icon.
  static const IconData strokeRoundedUserUnlock01 =
      IconData(0x49ea, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUserUnlock02' icon.
  static const IconData strokeRoundedUserUnlock02 =
      IconData(0x49eb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUser' icon.
  static const IconData strokeRoundedUser =
      IconData(0x49ec, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUv01' icon.
  static const IconData strokeRoundedUv01 =
      IconData(0x49ed, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUv02' icon.
  static const IconData strokeRoundedUv02 =
      IconData(0x49ee, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedUv03' icon.
  static const IconData strokeRoundedUv03 =
      IconData(0x49ef, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVaccine' icon.
  static const IconData strokeRoundedVaccine =
      IconData(0x49f0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedValidationApproval' icon.
  static const IconData strokeRoundedValidationApproval =
      IconData(0x49f1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedValidation' icon.
  static const IconData strokeRoundedValidation =
      IconData(0x49f2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVan' icon.
  static const IconData strokeRoundedVan =
      IconData(0x49f3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVariable' icon.
  static const IconData strokeRoundedVariable =
      IconData(0x49f4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVegetarianFood' icon.
  static const IconData strokeRoundedVegetarianFood =
      IconData(0x49f5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVerticalResize' icon.
  static const IconData strokeRoundedVerticalResize =
      IconData(0x49f6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVerticalScrollPoint' icon.
  static const IconData strokeRoundedVerticalScrollPoint =
      IconData(0x49f7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVest' icon.
  static const IconData strokeRoundedVest =
      IconData(0x49f8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVictoryFinger01' icon.
  static const IconData strokeRoundedVictoryFinger01 =
      IconData(0x49f9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVictoryFinger02' icon.
  static const IconData strokeRoundedVictoryFinger02 =
      IconData(0x49fa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVictoryFinger03' icon.
  static const IconData strokeRoundedVictoryFinger03 =
      IconData(0x49fb, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVideo01' icon.
  static const IconData strokeRoundedVideo01 =
      IconData(0x49fc, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVideo02' icon.
  static const IconData strokeRoundedVideo02 =
      IconData(0x49fd, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVideoConsole' icon.
  static const IconData strokeRoundedVideoConsole =
      IconData(0x49fe, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVideoOff' icon.
  static const IconData strokeRoundedVideoOff =
      IconData(0x49ff, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVideoReplay' icon.
  static const IconData strokeRoundedVideoReplay =
      IconData(0x4a00, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedViewOffSlash' icon.
  static const IconData strokeRoundedViewOffSlash =
      IconData(0x4a01, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedViewOff' icon.
  static const IconData strokeRoundedViewOff =
      IconData(0x4a02, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedView' icon.
  static const IconData strokeRoundedView =
      IconData(0x4a03, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVimeo' icon.
  static const IconData strokeRoundedVimeo =
      IconData(0x4a04, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVineSquare' icon.
  static const IconData strokeRoundedVineSquare =
      IconData(0x4a05, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVine' icon.
  static const IconData strokeRoundedVine =
      IconData(0x4a06, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVintageClock' icon.
  static const IconData strokeRoundedVintageClock =
      IconData(0x4a07, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVirtualRealityVr01' icon.
  static const IconData strokeRoundedVirtualRealityVr01 =
      IconData(0x4a08, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVirtualRealityVr02' icon.
  static const IconData strokeRoundedVirtualRealityVr02 =
      IconData(0x4a09, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVision' icon.
  static const IconData strokeRoundedVision =
      IconData(0x4a0a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVkSquare' icon.
  static const IconData strokeRoundedVkSquare =
      IconData(0x4a0b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVk' icon.
  static const IconData strokeRoundedVk =
      IconData(0x4a0c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVoiceId' icon.
  static const IconData strokeRoundedVoiceId =
      IconData(0x4a0d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVoice' icon.
  static const IconData strokeRoundedVoice =
      IconData(0x4a0e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVolleyball' icon.
  static const IconData strokeRoundedVolleyball =
      IconData(0x4a0f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVolumeHigh' icon.
  static const IconData strokeRoundedVolumeHigh =
      IconData(0x4a10, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVolumeLow' icon.
  static const IconData strokeRoundedVolumeLow =
      IconData(0x4a11, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVolumeMinus' icon.
  static const IconData strokeRoundedVolumeMinus =
      IconData(0x4a12, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVolumeMute01' icon.
  static const IconData strokeRoundedVolumeMute01 =
      IconData(0x4a13, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVolumeMute02' icon.
  static const IconData strokeRoundedVolumeMute02 =
      IconData(0x4a14, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVolumeOff' icon.
  static const IconData strokeRoundedVolumeOff =
      IconData(0x4a15, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVolumeUp' icon.
  static const IconData strokeRoundedVolumeUp =
      IconData(0x4a16, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVomiting' icon.
  static const IconData strokeRoundedVomiting =
      IconData(0x4a17, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVoucher' icon.
  static const IconData strokeRoundedVoucher =
      IconData(0x4a18, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVrGlasses' icon.
  static const IconData strokeRoundedVrGlasses =
      IconData(0x4a19, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVr' icon.
  static const IconData strokeRoundedVr =
      IconData(0x4a1a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVynil01' icon.
  static const IconData strokeRoundedVynil01 =
      IconData(0x4a1b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVynil02' icon.
  static const IconData strokeRoundedVynil02 =
      IconData(0x4a1c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedVynil03' icon.
  static const IconData strokeRoundedVynil03 =
      IconData(0x4a1d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWaiter' icon.
  static const IconData strokeRoundedWaiter =
      IconData(0x4a1e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWaiters' icon.
  static const IconData strokeRoundedWaiters =
      IconData(0x4a1f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWallLamp' icon.
  static const IconData strokeRoundedWallLamp =
      IconData(0x4a20, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWallet01' icon.
  static const IconData strokeRoundedWallet01 =
      IconData(0x4a21, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWallet02' icon.
  static const IconData strokeRoundedWallet02 =
      IconData(0x4a22, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWallet03' icon.
  static const IconData strokeRoundedWallet03 =
      IconData(0x4a23, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWalletAdd01' icon.
  static const IconData strokeRoundedWalletAdd01 =
      IconData(0x4a24, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWalletAdd02' icon.
  static const IconData strokeRoundedWalletAdd02 =
      IconData(0x4a25, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWalletDone01' icon.
  static const IconData strokeRoundedWalletDone01 =
      IconData(0x4a26, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWalletDone02' icon.
  static const IconData strokeRoundedWalletDone02 =
      IconData(0x4a27, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWalletNotFound01' icon.
  static const IconData strokeRoundedWalletNotFound01 =
      IconData(0x4a28, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWalletNotFound02' icon.
  static const IconData strokeRoundedWalletNotFound02 =
      IconData(0x4a29, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWalletRemove01' icon.
  static const IconData strokeRoundedWalletRemove01 =
      IconData(0x4a2a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWalletRemove02' icon.
  static const IconData strokeRoundedWalletRemove02 =
      IconData(0x4a2b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWanted' icon.
  static const IconData strokeRoundedWanted =
      IconData(0x4a2c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWardrobe01' icon.
  static const IconData strokeRoundedWardrobe01 =
      IconData(0x4a2d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWardrobe02' icon.
  static const IconData strokeRoundedWardrobe02 =
      IconData(0x4a2e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWardrobe03' icon.
  static const IconData strokeRoundedWardrobe03 =
      IconData(0x4a2f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWardrobe04' icon.
  static const IconData strokeRoundedWardrobe04 =
      IconData(0x4a30, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWarehouse' icon.
  static const IconData strokeRoundedWarehouse =
      IconData(0x4a31, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWashingtonMonument' icon.
  static const IconData strokeRoundedWashingtonMonument =
      IconData(0x4a32, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWasteRestore' icon.
  static const IconData strokeRoundedWasteRestore =
      IconData(0x4a33, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWaste' icon.
  static const IconData strokeRoundedWaste =
      IconData(0x4a34, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWatch01' icon.
  static const IconData strokeRoundedWatch01 =
      IconData(0x4a35, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWatch02' icon.
  static const IconData strokeRoundedWatch02 =
      IconData(0x4a36, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWaterEnergy' icon.
  static const IconData strokeRoundedWaterEnergy =
      IconData(0x4a37, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWaterPolo' icon.
  static const IconData strokeRoundedWaterPolo =
      IconData(0x4a38, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWaterPump' icon.
  static const IconData strokeRoundedWaterPump =
      IconData(0x4a39, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWaterfallDown01' icon.
  static const IconData strokeRoundedWaterfallDown01 =
      IconData(0x4a3a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWaterfallDown03' icon.
  static const IconData strokeRoundedWaterfallDown03 =
      IconData(0x4a3b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWaterfallUp01' icon.
  static const IconData strokeRoundedWaterfallUp01 =
      IconData(0x4a3c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWaterfallUp02' icon.
  static const IconData strokeRoundedWaterfallUp02 =
      IconData(0x4a3d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWatermelon' icon.
  static const IconData strokeRoundedWatermelon =
      IconData(0x4a3e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWattpadSquare' icon.
  static const IconData strokeRoundedWattpadSquare =
      IconData(0x4a3f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWattpad' icon.
  static const IconData strokeRoundedWattpad =
      IconData(0x4a40, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWavingHand01' icon.
  static const IconData strokeRoundedWavingHand01 =
      IconData(0x4a41, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWavingHand02' icon.
  static const IconData strokeRoundedWavingHand02 =
      IconData(0x4a42, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWaze' icon.
  static const IconData strokeRoundedWaze =
      IconData(0x4a43, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWebDesign01' icon.
  static const IconData strokeRoundedWebDesign01 =
      IconData(0x4a44, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWebDesign02' icon.
  static const IconData strokeRoundedWebDesign02 =
      IconData(0x4a45, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWebProgramming' icon.
  static const IconData strokeRoundedWebProgramming =
      IconData(0x4a46, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWebProtection' icon.
  static const IconData strokeRoundedWebProtection =
      IconData(0x4a47, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWebSecurity' icon.
  static const IconData strokeRoundedWebSecurity =
      IconData(0x4a48, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWebValidation' icon.
  static const IconData strokeRoundedWebValidation =
      IconData(0x4a49, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWebflow' icon.
  static const IconData strokeRoundedWebflow =
      IconData(0x4a4a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWechat' icon.
  static const IconData strokeRoundedWechat =
      IconData(0x4a4b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWeightScale01' icon.
  static const IconData strokeRoundedWeightScale01 =
      IconData(0x4a4c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWeightScale' icon.
  static const IconData strokeRoundedWeightScale =
      IconData(0x4a4d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWellness' icon.
  static const IconData strokeRoundedWellness =
      IconData(0x4a4e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWhatsappBusiness' icon.
  static const IconData strokeRoundedWhatsappBusiness =
      IconData(0x4a4f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWhatsapp' icon.
  static const IconData strokeRoundedWhatsapp =
      IconData(0x4a50, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWheelchair' icon.
  static const IconData strokeRoundedWheelchair =
      IconData(0x4a51, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWhisk' icon.
  static const IconData strokeRoundedWhisk =
      IconData(0x4a52, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWhistle' icon.
  static const IconData strokeRoundedWhistle =
      IconData(0x4a53, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWifi01' icon.
  static const IconData strokeRoundedWifi01 =
      IconData(0x4a54, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWifi02' icon.
  static const IconData strokeRoundedWifi02 =
      IconData(0x4a55, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWifiCircle' icon.
  static const IconData strokeRoundedWifiCircle =
      IconData(0x4a56, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWifiConnected01' icon.
  static const IconData strokeRoundedWifiConnected01 =
      IconData(0x4a57, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWifiConnected02' icon.
  static const IconData strokeRoundedWifiConnected02 =
      IconData(0x4a58, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWifiConnected03' icon.
  static const IconData strokeRoundedWifiConnected03 =
      IconData(0x4a59, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWifiDisconnected01' icon.
  static const IconData strokeRoundedWifiDisconnected01 =
      IconData(0x4a5a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWifiDisconnected02' icon.
  static const IconData strokeRoundedWifiDisconnected02 =
      IconData(0x4a5b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWifiDisconnected03' icon.
  static const IconData strokeRoundedWifiDisconnected03 =
      IconData(0x4a5c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWifiDisconnected04' icon.
  static const IconData strokeRoundedWifiDisconnected04 =
      IconData(0x4a5d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWifiError01' icon.
  static const IconData strokeRoundedWifiError01 =
      IconData(0x4a5e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWifiError02' icon.
  static const IconData strokeRoundedWifiError02 =
      IconData(0x4a5f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWifiFullSignal' icon.
  static const IconData strokeRoundedWifiFullSignal =
      IconData(0x4a60, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWifiLocation' icon.
  static const IconData strokeRoundedWifiLocation =
      IconData(0x4a61, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWifiLock' icon.
  static const IconData strokeRoundedWifiLock =
      IconData(0x4a62, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWifiLowSignal' icon.
  static const IconData strokeRoundedWifiLowSignal =
      IconData(0x4a63, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWifiMediumSignal' icon.
  static const IconData strokeRoundedWifiMediumSignal =
      IconData(0x4a64, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWifiNoSignal' icon.
  static const IconData strokeRoundedWifiNoSignal =
      IconData(0x4a65, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWifiOff01' icon.
  static const IconData strokeRoundedWifiOff01 =
      IconData(0x4a66, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWifiOff02' icon.
  static const IconData strokeRoundedWifiOff02 =
      IconData(0x4a67, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWifiSquare' icon.
  static const IconData strokeRoundedWifiSquare =
      IconData(0x4a68, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWifiUnlock' icon.
  static const IconData strokeRoundedWifiUnlock =
      IconData(0x4a69, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWikipedia' icon.
  static const IconData strokeRoundedWikipedia =
      IconData(0x4a6a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWindPower01' icon.
  static const IconData strokeRoundedWindPower01 =
      IconData(0x4a6b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWindPower02' icon.
  static const IconData strokeRoundedWindPower02 =
      IconData(0x4a6c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWindPower03' icon.
  static const IconData strokeRoundedWindPower03 =
      IconData(0x4a6d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWindPower' icon.
  static const IconData strokeRoundedWindPower =
      IconData(0x4a6e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWindSurf' icon.
  static const IconData strokeRoundedWindSurf =
      IconData(0x4a6f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWindTurbine' icon.
  static const IconData strokeRoundedWindTurbine =
      IconData(0x4a70, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWink' icon.
  static const IconData strokeRoundedWink =
      IconData(0x4a71, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWinking' icon.
  static const IconData strokeRoundedWinking =
      IconData(0x4a72, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWirelessCloudAccess' icon.
  static const IconData strokeRoundedWirelessCloudAccess =
      IconData(0x4a73, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWireless' icon.
  static const IconData strokeRoundedWireless =
      IconData(0x4a74, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWise' icon.
  static const IconData strokeRoundedWise =
      IconData(0x4a75, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWordpress' icon.
  static const IconData strokeRoundedWordpress =
      IconData(0x4a76, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkAlert' icon.
  static const IconData strokeRoundedWorkAlert =
      IconData(0x4a77, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkHistory' icon.
  static const IconData strokeRoundedWorkHistory =
      IconData(0x4a78, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkUpdate' icon.
  static const IconData strokeRoundedWorkUpdate =
      IconData(0x4a79, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkflowCircle01' icon.
  static const IconData strokeRoundedWorkflowCircle01 =
      IconData(0x4a7a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkflowCircle02' icon.
  static const IconData strokeRoundedWorkflowCircle02 =
      IconData(0x4a7b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkflowCircle03' icon.
  static const IconData strokeRoundedWorkflowCircle03 =
      IconData(0x4a7c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkflowCircle04' icon.
  static const IconData strokeRoundedWorkflowCircle04 =
      IconData(0x4a7d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkflowCircle05' icon.
  static const IconData strokeRoundedWorkflowCircle05 =
      IconData(0x4a7e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkflowCircle06' icon.
  static const IconData strokeRoundedWorkflowCircle06 =
      IconData(0x4a7f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkflowSquare01' icon.
  static const IconData strokeRoundedWorkflowSquare01 =
      IconData(0x4a80, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkflowSquare02' icon.
  static const IconData strokeRoundedWorkflowSquare02 =
      IconData(0x4a81, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkflowSquare03' icon.
  static const IconData strokeRoundedWorkflowSquare03 =
      IconData(0x4a82, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkflowSquare04' icon.
  static const IconData strokeRoundedWorkflowSquare04 =
      IconData(0x4a83, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkflowSquare05' icon.
  static const IconData strokeRoundedWorkflowSquare05 =
      IconData(0x4a84, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkflowSquare06' icon.
  static const IconData strokeRoundedWorkflowSquare06 =
      IconData(0x4a85, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkflowSquare07' icon.
  static const IconData strokeRoundedWorkflowSquare07 =
      IconData(0x4a86, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkflowSquare08' icon.
  static const IconData strokeRoundedWorkflowSquare08 =
      IconData(0x4a87, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkflowSquare09' icon.
  static const IconData strokeRoundedWorkflowSquare09 =
      IconData(0x4a88, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkflowSquare10' icon.
  static const IconData strokeRoundedWorkflowSquare10 =
      IconData(0x4a89, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkoutBattleRopes' icon.
  static const IconData strokeRoundedWorkoutBattleRopes =
      IconData(0x4a8a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkoutGymnastics' icon.
  static const IconData strokeRoundedWorkoutGymnastics =
      IconData(0x4a8b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkoutKicking' icon.
  static const IconData strokeRoundedWorkoutKicking =
      IconData(0x4a8c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkoutRun' icon.
  static const IconData strokeRoundedWorkoutRun =
      IconData(0x4a8d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkoutSport' icon.
  static const IconData strokeRoundedWorkoutSport =
      IconData(0x4a8e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkoutSquats' icon.
  static const IconData strokeRoundedWorkoutSquats =
      IconData(0x4a8f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkoutStretching' icon.
  static const IconData strokeRoundedWorkoutStretching =
      IconData(0x4a90, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorkoutWarmUp' icon.
  static const IconData strokeRoundedWorkoutWarmUp =
      IconData(0x4a91, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWorry' icon.
  static const IconData strokeRoundedWorry =
      IconData(0x4a92, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWpsOfficeRectangle' icon.
  static const IconData strokeRoundedWpsOfficeRectangle =
      IconData(0x4a93, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWpsOffice' icon.
  static const IconData strokeRoundedWpsOffice =
      IconData(0x4a94, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWrench01' icon.
  static const IconData strokeRoundedWrench01 =
      IconData(0x4a95, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWrench02' icon.
  static const IconData strokeRoundedWrench02 =
      IconData(0x4a96, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedWudu' icon.
  static const IconData strokeRoundedWudu =
      IconData(0x4a97, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedXRay' icon.
  static const IconData strokeRoundedXRay =
      IconData(0x4a98, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedXVariableCircle' icon.
  static const IconData strokeRoundedXVariableCircle =
      IconData(0x4a99, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedXVariableSquare' icon.
  static const IconData strokeRoundedXVariableSquare =
      IconData(0x4a9a, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedXVariable' icon.
  static const IconData strokeRoundedXVariable =
      IconData(0x4a9b, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedXing' icon.
  static const IconData strokeRoundedXing =
      IconData(0x4a9c, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedXls01' icon.
  static const IconData strokeRoundedXls01 =
      IconData(0x4a9d, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedXls02' icon.
  static const IconData strokeRoundedXls02 =
      IconData(0x4a9e, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedXml01' icon.
  static const IconData strokeRoundedXml01 =
      IconData(0x4a9f, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedXml02' icon.
  static const IconData strokeRoundedXml02 =
      IconData(0x4aa0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedXsl01' icon.
  static const IconData strokeRoundedXsl01 =
      IconData(0x4aa1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedXsl02' icon.
  static const IconData strokeRoundedXsl02 =
      IconData(0x4aa2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedYelp' icon.
  static const IconData strokeRoundedYelp =
      IconData(0x4aa3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedYenCircle' icon.
  static const IconData strokeRoundedYenCircle =
      IconData(0x4aa4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedYenReceive' icon.
  static const IconData strokeRoundedYenReceive =
      IconData(0x4aa5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedYenSend' icon.
  static const IconData strokeRoundedYenSend =
      IconData(0x4aa6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedYenSquare' icon.
  static const IconData strokeRoundedYenSquare =
      IconData(0x4aa7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedYen' icon.
  static const IconData strokeRoundedYen =
      IconData(0x4aa8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedYoga01' icon.
  static const IconData strokeRoundedYoga01 =
      IconData(0x4aa9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedYoga02' icon.
  static const IconData strokeRoundedYoga02 =
      IconData(0x4aaa, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedYoga03' icon.
  static const IconData strokeRoundedYoga03 =
      IconData(0x4aab, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedYogaBall' icon.
  static const IconData strokeRoundedYogaBall =
      IconData(0x4aac, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedYogaMat' icon.
  static const IconData strokeRoundedYogaMat =
      IconData(0x4aad, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedYogurt' icon.
  static const IconData strokeRoundedYogurt =
      IconData(0x4aae, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedYoutube' icon.
  static const IconData strokeRoundedYoutube =
      IconData(0x4aaf, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedYurt' icon.
  static const IconData strokeRoundedYurt =
      IconData(0x4ab0, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedZakat' icon.
  static const IconData strokeRoundedZakat =
      IconData(0x4ab1, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedZap' icon.
  static const IconData strokeRoundedZap =
      IconData(0x4ab2, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedZeppelin' icon.
  static const IconData strokeRoundedZeppelin =
      IconData(0x4ab3, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedZip01' icon.
  static const IconData strokeRoundedZip01 =
      IconData(0x4ab4, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedZip02' icon.
  static const IconData strokeRoundedZip02 =
      IconData(0x4ab5, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedZoomCircle' icon.
  static const IconData strokeRoundedZoomCircle =
      IconData(0x4ab6, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedZoomInArea' icon.
  static const IconData strokeRoundedZoomInArea =
      IconData(0x4ab7, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedZoomOutArea' icon.
  static const IconData strokeRoundedZoomOutArea =
      IconData(0x4ab8, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedZoomSquare' icon.
  static const IconData strokeRoundedZoomSquare =
      IconData(0x4ab9, fontFamily: 'HgiStrokeRounded');

  /// IconData for the 'strokeRoundedZoom' icon.
  static const IconData strokeRoundedZoom =
      IconData(0x4aba, fontFamily: 'HgiStrokeRounded');
}
