---
title: "Двуфакторна автентикация"
slug: "двуфакторна автентикация"
date: 2018-04-15T11:00:00+02:00
draft: false
---

Термина "двуфакторна автентикация" ("two-factor authentication") често се съкращава до "2FA". Това описва широк набор от начини за допълнително подсигуряване на акаунта ви в някои сайтове. Някъде може да го срещнете и като "двуфакторно удостоверяване" или "двуфакторна идентификация".

Обикновено, сайтовете изискват потребителско име или мейл адрес и парола. Ако сайта поддържа 2FA, може *освен* тези идентификатори да се изисква нещо допълнително. Това означава, че дори някой да се сдобие с паролата ви, това няма да му е достатъчно да влезе в сайта с вашата идентичност.

## Защо "двуфакторна"?

Начина една система да бъде отворена само за нас е като забраним достъпа за всички, които не могат да предоставят някакъв ключ. Това се отнася както за вратата на апартамент, за сейфовете в банка, също и за сайтове, които държат вашата информация.

"Ключа" може да влиза в една от три категории:

* Нещо, което **знаеш**: парола, ПИН код, специален жест.
* Нещо, което **притежаваш**: физически ключ, токен устройство, телефон.
* Нещо, което **си**: пръстов отпечатък, формите в ретината, формата на лицето.

Тези методи за автентикация имат различни характеристики. Физически ключ може да се изгуби или открадне, докато парола, която е в главата ни, няма как. За сметка на това, изгубен ключ може да се намери, но парола, която вече е запомнена от някой друг, няма как да се "върне обратно", понеже е просто знание. Биометричните данни като пръстови отпечатъци не могат да се откраднат лесно, но за сметка на това, ако някой намери отпечатъците ни и ги копира, няма как да ги сменим, за разлика от една парола.

Автентикацията, която използва два **различни** фактора, е доста по-сигурна, понеже изисква успех в две напълно отделни атаки за да бъде разбита. Ако за онлайн банкиране има нужда от парола и от токен устройство, тогава дори някой да го открадне, само с него не може да направи нищо лошо. А ако някой прихване паролата ни, чрез, например, [фишинг]({{< ref "phishing.md">}}) атака, тя няма да му е достатъчна, за да източи пари, без да има устройството.

Важно е обаче факторите да са различни. Ако си запишете тази банкова парола на бележка, която оставите *до* физическото устройство, това свежда и двете неща до "нещо, което притежавате", и то дори на едно и също място. Това е изключително удобно, но много увеличава риска ако някой крадец разбие дома ви -- би имал пълен достъп до всичките ви финанси.

## Често срещани комбинации

Банките редовно използват "токен устройства". Ето един пример за такова:

![token device](/images/two-factor-authentication/token-device.jpg)

Когато искате да направите транзакция, първо трябва да влезете в сайта за онлайн банкиране, който е защитен с парола (нещо, което знаем). След това, описвате транзакцията, и сайта пита за код от устройството (нещо, което притежавате). Натискате бутонче, и то показва кода, който ще е валиден няколко секунди. Банката има подобно устройство от "другата страна" на сайта, което генерира същия код по същото време. Ако някой няма това устройство, няма как да познае кода.

В някои банки, а също и ако активирате 2FA за фейсбук, вариант е кода да се изпрати по SMS или чрез специално мобилно приложение. Механизма е същия -- телефона е "нещо, което притежавате". По-удобно е, понеже няма нужда да купувате и поддържате отделно устройство. SMS-ите обаче може да са несигурни в случай на Man-in-the-middle атака (за която вероятно ще напишем отделна статия). Това обаче е ситуация, която е сравнително малко вероятна за повечето хора.

*Странична бележка: Ако не сте активирали 2FA за фейсбук, ето статия по въпроса: https://www.facebook.com/help/148233965247823. Може да смените езика на български в долния ляв ъгъл на страницата.*

Кредитната или дебитната карта са интересни примери за обратното -- една карта е нещо, което притежавате. Ако някой я открадне, би могъл да прави покупки през нея вместо вас. Затова разнообразни карти използват системата "3-D-Secure". Когато тя е активирана за картата, онлайн плащанията ще ви питат за допълнителна парола (нещо, което знаете).

## Недостатъци

Двуфакторната автентикация е изключително полезен инструмент за подсигуряване на акаунта ви където и да е. В някои случаи, е задължителна -- едва ли ще намерите банка, която да ви позволява да правите плащания без втори метод за автентикация освен паролата. Когато обаче имате избор, както например при автентикация с фейсбук или с електронна поща, идва въпроса: Заслужава ли си?

Отговора се свежда до размяна на удобство срещу допълнителна сигурност. Въвеждането на код, изпратен по SMS или електронна поща, е още една стъпка, която трябва да направите. Това е досадно, особено ако е нужно често, или ако е на телефон, където е по-тромаво превключването напред-назад между приложения. Или ако се налага всеки път като влизате в сайт, да си търсите телефона за код. За сметка на това, ако паролата ви бъде позната или открадната, тя няма да е достатъчна на нападател да достъпи нищо ваше.

Има и смекчаващи средства. Фейсбук няма да ви пращат повторно SMS код за определено устройство, ако отбележите, че му имате доверие. Така, домашния компютър може да е доверен, но пък никой, сдобил се с паролата отвън, няма да може да достъпи сайта с вашата самоличност. Могат да ви откраднат лаптопа, но това е доста по-голям проблем и изисква различна защита (затова се погрижете да имате добра парола на въпросния лаптоп).

## Обобщение и свързани теми

Когато имате опцията да включите двуфакторна автентикация за каквато и да е важна за вас услуга, силно ви препоръчваме да го направите. Добавеното неудобство често се намалява като маркирате собствения си (грижливо пазен компютър) като "доверен". Добавената сигурност значи, че при следващия скандал с източени пароли, ще се чувствате уверени, че никой не може да влезе в акаунтите ви и да тегли пари, изпраща мейли от ваше име или да продава данни на разнообразни сенчести агенции.

Разбира се, ако просто използвате временен мейл адрес за някаква експериментална услуга, не е голям проблем да си останете само с парола. Хвърлете едно око на статията ни за [моделиране на заплахи]({{< ref "threat-modeling.md">}}) и помислете сами за баланса между удобство и сигурност.
