---
title: "Социална манипулация"
slug: "социална манипулация"
date: 2018-09-06T14:00:00+02:00
draft: false
---

Оригиналния термин, който ще се опитаме да обясним, е "Social Engineering". Това е трудно да се преведе на български, затова в повечето случаи се използва като чуждица. В тази статия, ще използваме "социална манипулация", въпреки че е малко по-широко понятие. Ще обясним ролята на социалната манипулация конкретно в контекста на онлайн сигурността.

Този подход е може би най-успешното средство за достъп до определена система. По филмите, хакерите използват вируси и дупки в сигурността, но в реални ситуации е много по-лесно да се обадят по телефона на правилния човек с хитра история и манипулативни трикове.

Това рядко би било проблем за частни лица, но често може да се използва като средство за достъп до системите на една фирма. Затова си заслужава в професионален контекст да сме внимателни, и да сме сигурни, че имаме ясни правила за това на кого можем да дадем пароли или кодове. А нищо не пречи да бъдем нащрек и докато пазим собствените си акаунти от манипулативни съобщения или телефонни обаждания.

## По телефона

Обаждането по телефона е често срещан начин за социална манипулация. Когато получите телефонно обаждане, обаждащия номер може да бъде фалшифициран. Подхода се казва "caller ID spoofing" (повече информация, на английски, има в [Wikipedia](https://en.wikipedia.org/wiki/Caller_ID_spoofing)) и е лесно постижим с правилния софтуер. Възможно е да се видите номера на телефонната си компания, на колега от работа, или на някой приятел, а всъщност да е непознат, който се опитва да изкопчи информация. В някои държави това е нелегално, поне в случая на опит за заблуждаване, но не е добра идея да се разчита на това.

Независимо от обаждащия номер, заслужава си да сме нащрек. Хитрият измамник рядко ще каже веднага нещо съмнително. В повечето случаи, има сценарий, в който се набляга на нуждата от *бърз* отговор, за нещо изключително спешно. Изгражда се атмосфера на стрес, в която единствено вие можете да "спасите" измамника. Искането се прави между другото, и се разчита на желанието ви да помогнете на човек, изпаднал в беда.

Чудесен пример може да се намери в това видео (на английски): {{<youtube lc7scxvKQOo>}}

Дамата във видеото прави следните неща:

- Обажда се на телефонна компания.
- Фалшифицира номера, от който се обажда, да изглежда като номера на целта си.
- Пуска запис на плачещо бебе, за да генерира чувство на спешност и беда.
- Говори бързо, описва колко ѝ е трудно, как не знае какво да направи.
- Моли отсрещния човек да ѝ даде достъп до акаунта на "съпруга" ѝ, което веднага се случва, понеже служителя се опитва да помогне на дама в привидна беда.

В този момент, тя има акаунт, свързан с акаунта на целта си, може да смени паролата, и да блокира целта си от него. Това се случва бързо и ефективно, и единственото, което се изисква, е нападателя да звучи достатъчно убедително, а служителя да не прави по-сериозна проверка на идентичността ѝ.

## По Facebook Messenger

Един много опасен потенциален източник на нападатели може да бъде фейсбук. Представете си, че някой направи фейсбук акаунт с името на шефа ви, и негова публична профилна снимка. След което започне да иска приятелство от хора във фирмата, един по един. Бихте ли приели? А ако вече има други хора от фирмата, които са приели?

В професионален контекст, когато човек на сравнително висока позиция поиска контакт в социална мрежа, не е странно да приемете, дори и да не контактувате с него директно. Нещо повече, колкото по-високо е от вас в професионалната йерархия, толкова по-голям е шанса да не си говорите директно, но да приемете, било то за да не го обидите, или просто защото нямате добра причина да откажете.

Оттам нататък, този фалшив профил може да се свърже директно и да поиска някоя парола или достъп до нещо, или фирмена информация. Същите правила като телефонната измама по-горе важат: описва се ситуация на криза, беда, "намирам се във важна бизнес среща и не мога да намеря важен документ, прати ми го".

Решението в случая е да имаме много ясни протоколи, на фирмено ниво, за позволените канали, по които може да се изпраща такава информация. Фейсбук не е добър такъв канал за професионални цели, дори и само защото може да се случи такава измама. Това не значи, че трябва да развалите фейсбук-приятелството си с шефа, но за важни документи и информация, задължително валидирайте дали ситуацията е истина по различни канали (имейл, телефон, лично потвърждение с други хора). Не е лоша идея и да направите бърза проверка още когато приемате приятелството -- това ли е наистина човека, който си мисля, че е?

## Заобикаляне на двуфакторна автентикация

В случай, че не сте чели статията ни за  [двуфакторна автентикация]({{< relref "two-factor-authentication.md" >}}), краткото обяснение е: Освен, че имате парола за да влезете (примерно) в електронната си поща, ви се праща и SMS с кратък код, валиден само веднъж и за малко време. Така, дори някой да се сдобие с паролата ви, няма как да я използват -- нямат вашия телефон.

Но да речем, че са се сдобили с паролата, по един или друг начин (случват се "изтичания" на информация). Да речем, че знаят телефонния ви номер, но, разбира се, няма как да "прихванат" кода. Все още сте защитени!

Но биха могли да ви пишат SMS, в който казват следното:

> Здравей! Извинявай, не ме познаваш, но преди години имах този телефонен номер. Сега се опитвам да се логна в един много стар сайт, където съм сложил тоя номер, и не ме пуска, щото иска да ми прати код :/. Можеш ли да ми помогнеш и да ми дадеш кода? Ако не, няма проблеми, разбирам.

Нормално е човек да си каже "ех, гадно, чакай да му помогна". Нормално е той да се опита да влезе във *вашия* акаунт с вашата парола, да получите код, и да му го напишете. И той вече има достъп до пощата ви!

Тази история е измислена, но подобна е описана тук: https://twitter.com/RachelTobac/status/996556819886583808

Предвид, че двуфакторната автентикация с SMS понякога се използва за доста сериозни неща, като банкови транзакции, такъв трик е плашещ. Единственото, което може да се направи, е да бъдем малко по-съмнителни към непознати, както бихме били с такива хора на улицата. В случая, бихме могли да питаме:

- Преди колко време е имал номера? Ако каже "преди 3 години", а вие имате този номер от 10 години, изглежда като да лъже. По-вероятно може да се опита да заобиколи въпроса някак.
- Коя е услугата, в която се опитва да влезе? Ако каже "MySpace", а вие получите SMS "Ето вашия код за Gmail", отговора е ясен.

Мъничко допълнително съмнение ще ви помогне да развалите хлабавата история и да хванете мошеника в крачка. Или да откриете, че му е чиста работата, и да му помогнете.

## Обобщение и свързани теми

Социалната манипулация е изключително опасен подход за разбиване на сигурността. Обикновено като мислим за нападатели, си представяме сложни програми, опасни вируси, но истината е, че най-слабото звено често е човешкото. Повечето от нас сме "програмирани" да помагаме на непознати в беда, и, за нещастие, това е благороден инстинкт, който може да бъде използван срещу нас.

Това, в много отношения, е подобно на [фишинга]({{< relref "phishing.md" >}}), но разликата е, че този подход е концентриран върху един-единствен ключов човек, който има правилния достъп и може да го даде. Може нападателите да са вкарали доста усилия да се доберат до вас, стига да имате този достъп.

Спасението, както при фишинга, е повишено внимание. Ако някой спешно има нужда от нещо, което заобикаля обичайните канали, или просто иска мъничка услуга, трябва да си зададем въпроси:

- Това наистина ли е човека, който твърди, че е? Как мога да проверя, и как мога да съм сигурен?
- За какво му трябва този достъп? Кого мога да питам за потвърждение?
- Какви са последствията ако сбъркам? Колко важно е да съм сигурен, че това е правилния човек?

Бъдете нащрек, задавайте си въпроси, и не забравяйте: "Доверявай, но проверявай!"
