---
title: "Мобилни телефони"
slug: "мобилни телефони"
date: 2018-02-25
draft: false
---

Повечето хора в някакъв смисъл са зависими от мобилните си телефони. И не става
въпрос за възможността да имаме телефон в себе си по всяко време, телефонните
разговори са все по-рядко използвана възможност на устройството, което почти
всеки има в джоба си.

За много хора мобилния телефон е основно средство за достъп до електронна поща и
социални мрежи, където се случва повечето ни комуникацията с други хора. Все
по-често телефонът е инструмент за финансови операции или достъп до услуги на
държавната администрация.

---

Без значение дали е напълно осъзнато -- и дали ни харесва -- мобилните ни
телефони са изключително важна част от живота ни.

---

При тях, както при повечето устройства, потенциалните опасности за сигурността
растат заедно с количеството възможни функции и удобства. Колкото по-умни и
по-можещи са мобилните ни устройства, толкова повече възможни, макар и често
нетривиални за откриване и възползване, са начините да бъдат компрометирани.

## От какво да предпазваме телефона си

В текста за [моделиране на заплахи]({{< relref "threat-modeling.md" >}})
разгледахме няколко потенциални заплахи що се отнася до мобилни телефони и
възможните лоши последствия:

 * нападател да получи **физически достъп** до телефона
   * да може да прочете всичката ни лична кореспонденция
   * да получи достъп до файловете (снимки, документи, и други) на устройството
   * да се представя за нас пред приятели и познати онлайн
   * да прави финансови операции от наше име
   * да инсталира зловреден софтуер на телефона
 * **зловреден софтуер** да получи възможност да се изпълнява на телефона
   * всички от предната точка
   * постоянно изпращане на информация от телефона: местоположение, с кого и
     какво си говорим, пароли за различни услуги и приложения, дистанционно
     включване на микрофона или камерата
   * включване на устройството в така наречените
     [botnets](https://en.wikipedia.org/wiki/Botnet) с цел изпълняване на други
     атаки, „копаене“ на криптовалути или изпращане на спам.

Всяка функция на телефоните ни, която ни дава удобство и спестява време, прави
необходимостта да бъдат адекватно защитавани още по-голяма. Ако управлението на
банковата ни сметка изисква само няколко цъкания в едно приложение, то точно
толкова е нужно и на недоброжелател, който получи достъп до устройството ни.

Производителите на мобилни телефони и операционни системи за тях са наясно с
това и са положили немалко усилия да позволят на потребителите си да получат
добри нива на сигурност, без да се налага да жертват кой знае какво от гледна
точка на удобство.

## Заключване на екрана

Що се отнася до мобилни телефони, може да приемем, че заключването на екрана е
„санитарния минимум“ на сигурност, който би било редно всеки да прилага. Дори
тази **проста мярка** е достатъчна за предпазване от **небрежни опити** за
посегателство.

За всеки с няколко минути физически достъп до устройството ни не би било проблем
да разгледа всичките ни съобщения/мейли/снимки или да инсталира различни
зловредни приложения на него. От такива, които използват изчислителната мощ на
устройството за „копаене“ на криптовалути, до такива позволяващи дистанционното
включване на камерата и микрофона или преглеждане на всички действия, които
правим с телефона си. Това е проблем, който заключването на екрана до голяма
степен решава.

Както iOS, така и Android поддържат функции за заключване на екрана на телефона,
било то с цифров код, „фигура“ за заключване (pattern) или биометрични данни,
които поддържа телефона (пръстов отпечатък или лицево разпознаване).

**Основен недостатък на заключването на екрана като мярка за сигурност** обаче е, че
при липса на други мерки за сигурност с малко повече време и не твърде много
техническа грамотност, недоброжелател все пак може да получи достъп до
информацията на телефона.

## Шифроване на запаметяващото устройство

Далеч по-добра сигурност ни дава шифроване на цялото запаметяващо устройство
на телефона. Това е функция, която съвременните мобилни операционни системи
предлагат. За активирането ѝ е нужна еднократна операция, която може да
отнеме около час, но **не изисква никакви специални умения** от страна на
потребителя. Обикновено може да бъде активирана от настройките за сигурност на
устройството.

 * за устройства с Android следвайте [инструкциите за шифроване на
   данни](https://support.google.com/pixelphone/answer/2844831?hl=bg&ref_topic=7083218)
   в страницата за помощ на Google

 * при iOS е следвайте [инструкциите за настройка на
   парола](https://support.apple.com/bg-bg/HT204060)(текстът е на английски).
   При iOS устройствата, задаването на парола води и до шифроване на
   запаметяващото устройство

---

 * при стартиране на устройството за дешифриране на информацията е нужен код,
   който сте избрали

 * както при заключването на екрана, освен цифров код може да използвате фигура
   или биометрични данни, в зависимост от възможностите на телефона

 * налучкване на кода е непрактична и безполезна атака, тъй като телефона не
   позволява голям брой бързи последователни опити

 * поради специфики в хардуерния дизайн на телефоните, отделянето на
   запаметяващото устройство от телефона с цел по-бързо налучкване на кода също
   не е валидна атака, тъй като част от ключа се държи в специален компонент на
   устройството, достъпът до който е изключително сложен

---

## Зловреден софтуер

Зловредния софтуер най-често има някоя от следните цели:

 * контрол над голямо количество устройства, за използването им за различни
   видове атаки или за изпращане на спам, така наречените
   [botnets](https://en.wikipedia.org/wiki/Botnet)
 * получаване на информация от устройствата, с цел **събиране на номера на
   кредитни карти** или **потребителски имена и пароли** за различни онлайн услуги

Най-често, поради голямата инвестиция нужна за успешното му създаване и
разпространение, **зловредния софтуер не е насочен към конкретен човек**.
Обикновено такъв тип атаки разчитат на голям брой потенциални жертви, така че
дори и при ниска успеваемост, крайния резултат да си струва усилията.

## Използване само на доверени източници на приложения

Съвременните мобилни операционни системи имат свои хранилища с приложения за
съответните платформи (App Store за iOS, Google Play за Android). По
подразбиране, всяко устройство може да инсталира софтуер **само от съответния
доверен източник**. Приложенията в съответните официални хранилища минават
определено ниво на проверки и публикувалите ги разработчици са известни.

Различни инструкции онлайн за инсталиране на конкретни приложения или за
достъп до определени функционалности на устройството съветват да се
премахнат тези ограничения. Използването на не верифицирани източници обаче крие
сериозен риск инсталираните от тях приложения да са всъщност зловреден софтуер.

Без значение колко внимателен, технически умел и добре информиран е един
потребител, най-добрия начин да се защити от зловреден софтуер е като се довери
само на услугите **създадени с цел да решат този проблем.**

## Оценка на исканите от приложенията права

Всяко приложение има нужда от **достъп до определена функционалност** на
устройството, за да работи. Операционните системи на съвременните мобилни
устройства се грижат да знаете за този достъп и да имате контрол над него. При
инсталиране, или при първо използване на съответната функционалност, всяко
приложение изисква разрешение за достъп.

---

 * достъп до **камерата** за правене снимки и/или видео
 * достъп до **микрофона** на устройството, за правене на аудио записи
 * достъп до **документите в устройството** (снимки, видеа и всякакъв друг тип
   файлове)
 * достъп до **информация за физическото местоположение** на устройството, често
   пъти разделена в отделни нива от грубо местоположение (т.е. такова с ниска
   точност) до много прецизно (т.е. такова с грешка до няколко метра).
 * както и още много други според устройството и версията на операционната
   система

---

Макар че преди качването им в съответните хранилища приложенията биват
проверявани, съществуват **различни техники за прикриване на функционалност**,
чрез които понякога недобронамерени приложения може да бъдат публикувани. Никое
приложение обаче **няма техническата възможност** да получи достъп до определени
възможности на устройството **без изрично позволение**.

Винаги преглеждайте какви права изисква едно приложение и оценявайте дали искате
да ги дадете.

---

 * ако приложение за правене на снимки иска достъп до камерата и файловете, в
   това има смисъл
 * ако приложение за четене на новини иска достъп до микрофона и детайли за
   физическо местоположение, това е голям червен флаг за нещата, които може би
   се случват в това приложение

---

Често пъти приложения могат да работят и без да им бъдат дадени всички права,
които изискат, стига това да не прави работата им невъзможна.

---

 * приложение за правене на снимки няма как да работи без права за достъп до
   камерата
 * приложение за четене на новини, най-вероятно ще върши това, което искате и
   без достъп до микрофона

---

Възползвайте се от това като **не давате права** на приложенията, **които не са
нужни** за целите, за които искате да ги използвате. Тъй като правата могат да
бъдат давани и отнемани в произволни моменти, имате възможност, ако считате за
нужно, да сте и по-педантични към приложенията инсталирани на телефона. Например
ако ползвате приложение, което добавя филтри към снимки, което обаче не
използвате често, можете да не дадете нужните права (за достъп до камерата и
файловете на устройството). Приложението ще ги поиска следващия път, когато го
пуснете, а след като приключите с употребата му може да ги отмените от
настройките за сигурност.
