---
title: "Фишинг"
slug: "фишинг"
date: 2018-02-25T11:08:00+02:00
draft: false
---

"[Фишинг](https://bg.wikipedia.org/wiki/Фишинг)" ("[Phishing](https://en.wikipedia.org/wiki/Phishing)") е опита на някой да ви излъже, че представя легитимна услуга, с цел да вземе ваши лични данни. Като пример, може да получите мейл от банката си, който ви казва, че задължително трябва да въведете паролата си за онлайн банкиране на някакъв конкретен сайт, иначе ще стане нещо ужасно лошо! Само че мейла не е от банката, а от някое друго лице, което иска да се сдобие с въпросната парола.

Процедурата е подобна на телефонните измамници, които се обаждат със "сина ти е в болница, веднага прати пари". Стига човека отсреща да е достатъчно умел, може да стресира и заблуди поне част от жертвите си.

Какви са **рисковете**? Може да изгубите:

---

- Паролата си за мейл, фейсбук, туитър, скайп.
- Номера на кредитната си карта.
- Паролата си за онлайн банкиране (макар че в този случай може да има други средства за защита).

---

Какви са **мерките за защита**? Като цяло се свеждат до:

---

- Повишено внимание когато четем мейли или сайтове, които изискват лична информация
- Оглеждане за индикатори, че сайта или мейла не е легитимен.

---

Нека да започнем от въпроса с повишеното внимание.

## Кога трябва да сме нащрек онлайн?

Идеалният отговор е "винаги", но той не е много реалистичен. Една от главните цели да разглеждаме неща в интернет е забавление и е нормално да сме отпуснати и спокойни, докато си браузваме страници и играем игри. Ето защо, удачно е да повишаваме вниманието си конкретно в някои ключови моменти:

---

- Когато един сайт очаква въвеждане на ключови данни: парола за каквото и да е, номер на кредитна карта, или лични данни като телефонен номер или адрес.
- Ако един сайт или мейл ви предлага да изтеглите приложение и да го пуснете.
- В случай, че приятел ви изпрати линк по скайп/фейсбук/мейл, без да ви дава детайли за какво става въпрос.

---

Това да сте с "повишено внимание" не означава да затворите веднага сайта и да угасите компютъра. Просто означава, че има смисъл да изпитате някакво съвсем леко съмнение и да помислите два-три пъти преди да цъкнете на каквото и да е или да въведете някакви данни. Това е (донякъде) еквивалента да ви бутне някой на улицата, и да сложите ръце в джобовете, за да проверите дали не ви липсва нещо.

А за какво всъщност да се оглеждаме?

## Индикатори, че един сайт не е легитимен

В случай, че един сайт изисква въвеждане на парола или кредитна карта, задължително трябва да се подсигурите, че *искате* да им дадете тези неща.

Първия въпрос е: **използва ли страницата HTTPS?** Ако отговора е "не", може проблема да не е фишинг, а просто нехайност от страна на собствениците на страницата. Все пак, никога не въвеждайте важни за вас данни, ако страницата не е защитена с HTTPS (причини за това ще разгледаме в друга статия, която говори за атаката man-in-the-middle)

Какво значи това? Това значи, че адреса задължително започва с `https://` вместо с `http://`. Разликата е мъничка, но повечето браузъри се опитват да я правят максимално ясна:

<table>
  <tr>
    <td><strong>Chrome</strong> показва катинарче и информация за издателя на сертификата за сигурност. HTTP сайта е маркиран като "Not secure".</td>
    <td width="350px"><img src="/images/phishing/https_chrome.png" alt="HTTP и HTTPS в Chrome" /></td>
  </tr>

  <tr>
    <td><strong>Firefox</strong> показва само катинарче за HTTPS страница. HTTP страницата обаче е различна с това, че изобщо не се вижда етикет "http://". Модерни версии на този браузър ще ви предупреждават и ако въвеждате пароли на не-HTTPS страница.</td>
    <td><img src="/images/phishing/https_firefox.png" alt="HTTP и HTTPS във Firefox" /></td>
  </tr>

  <tr>
    <td><strong>Internet Explorer</strong> не е толкова очевиден. Ако ползвате него, трябва внимателно да се загледате в текста -- или "http://" или "https://".</td>
    <td><img src="/images/phishing/https_ie.png" alt="HTTP и HTTPS в Internet Explorer" /></td>
  </tr>
</table>

Втори въпрос: **това ли е наистина сайта, който твърди, че е?** Ако сайта има логото на Google, но адреса на страницата е `https://www.goodle.com`, това е огромен червен флаг! Забележете, там пише "goodle", а не "google". По същия начин, както марки като "Adibas" са забавни ментета, имитиращи популярни продукти, лесно е някой да си регистрира сайт, който има подобно име на голяма компания. След това могат да направят сайт, който прилича почти 1:1 на оригиналния, с разликата, че паролите които въвеждате не отиват при истинската компания, а при собствениците на сайта.

Други примери за (възможни) сайтове-ментета:

- `https://facebook.net` -- Истинския сайт завършва на ".com", а не на ".net"
- `https://facebook.dsjfkl.com` -- Започва с "facebook", и завършва на ".com", но това по средата е различно. Нещо повече, името веднага отляво на ".com" е името на самия сайт, така че това е сайта "dsjfkl.com", който има под-секция с името "facebook".

Третия въпрос е най-мъгляв, но и доста важен: **има ли истинска нужда да даваме данни на този сайт?** Ако един сайт иска телефонния ви номер, за да минете през онлайн въпросник, за какво им е? Единствената причина да го искат, е за да го използват за контакт с вас, и ако не желаете този контакт, по-добре не им давайте истинския си номер.

И тук не е задължително проблема да е фишинг, възможно е просто компанията да се опитва да ви търси за да ви продава нещо или праща реклами. Но е напълно възможно и един сайт да иска информация от вас, която не би била нужда на **истинския** сайт, защото **не е** истинския сайт.

При всички положения, какво точно даваме като данни онлайн е нещо, което е добре да обмисляме внимателно, и за всеки отделен случай решението ни може да е различно. Споделянето на данни в интернет е широка тема, която сигурно ще покрием в друга статия.

## Последствия от успешна фишинг атака -- какво да направим?

Да речем, че сте въвели паролата си за фейсбук, и изведнъж осъзнаете, че това не е правилния сайт. Може би сте видели, че логото е малко различно, или адреса не е правилен, може би след вход в сайта сте били пратени на странно място.

С други думи, осъзнали сте, че сте станали жертва на фишинг. Някой се е сдобил с данните за логин във (примерно) фейсбук. Сега какво?

1. Първо, и най-важно правило: **Без паника!**

    В повечето случаи, подобни фишинг атаки се правят на доста широк обхват от хора. Може би се пращат мейли на 10,000 човека, чиито адреси са купени или откраднати отнякъде. При това положение, няма човек, който да стои на компютъра си и да чака някой да се върже. По-скоро собствениците на фалшивия сайт събират всички пароли с цел да ги разгледат по-късно и използват за нещо полезно за тях.

    Това значи, че имате време да вземете мерки. Помислете внимателно за това каква парола сте дали, и какви са рисковете. Решете каква е следващата стъпка. Примерно...

    <p></p>

2. **Сменете си паролата**

    Почти всички сайтове имат функционалност за "забравена парола" (forgotten password). Просто въвеждате мейл адреса си, и ще ви изпратят линк към страница, където да я смените. В момента, в който успешно промените паролата си, старата, която сте въвели във фалшивия сайт, е невалидна.

    Но ако сте използвали същата тази парола на други места, работата не е свършена! Нападателите могат да изпробват паролата на всички социални мрежи и други сайтове, на които сте регистрирани, докато не нацелят друго място, където работи. Така че сменете я и там.

    В случай, че са взели паролата за електронната ви поща, нещата са малко по-сериозни -- точно защото мейл адреса ви се използва за получаване на линкове за смяна на парола. Със сигурност обаче самата услуга има предвиден някакъв начин да ви изпрати нова парола, било то през резервен мейл адрес или телефонен номер.

    <p></p>

3. В случай, че сте си въвели номер на кредитна карта: **Обадете се на банката си и я блокирайте**

    Дори да закъснеете, и кредитната или дебитната ви карта са били използвани, банките ще възстановят парите ви в случай, че номера ви е откраднат. (Процедурата се нарича "chargeback", и повечето карти би трябвало да поддържат.) Картата ви ще бъде блокирана и ще трябва да се издаде нова, но по-добре това, отколкото да се чудите кога някой ще си купи нещо с ваши пари, и дали ще го забележите навреме.

## Обобщение и свързани теми

Винаги, когато един сайт иска нещо от вас, било то адрес, телефон, или парола, си заслужава да помислите "защо му трябва на този сайт тази информация?", и "отива ли информацията при истинския сайт, или някой ме лъже?" Може да има доста добра причина (сайта иска мейл и парола, за да ви регистрира, напълно нормално), но е важно да свикнете да си задавате въпроса на **всяка** такава страница, за да може, ако се озовете на facedook.com, да не си наберете паролата по инерция, а да забележите адреса и да предприемете мерки.

Това повишено внимание ще ви помогне и за други неща. Подобни други атаки са "social engineering" и "identity theft" (кражба на идентичност), които ще обсъдим в собствени статии.
