---
title: "Пароли"
slug: "Пароли"
date: 2022-01-23T15:00:00+02:00
draft: false
---

Днешно време всички имаме страшно много пароли за страшно много сайтове: за банкиране, за поща, за социални мрежи. Те са основния начин, по който защитаваме тайните си и идентичността си. Ако някой има паролата Ви за фейсбук, лесно може да се представи за Вас. Ако някой се сдобие с парола за поща, може да успеят да получат достъп до още много други сайтове с функционалността "забравена парола".

Как да изберем и запомним всичките си пароли? Най-краткия съвет е да използвате мениджър за пароли като:

- [1Password](https://1password.com/)
- [LastPass](https://www.lastpass.com/)
- [NordPass](https://nordpass.com/)

Но дори и тези "контейнери" за парола искат парола -- просто имате само една за запомняне. Как да я изберете?

## Как се разбива парола с автоматизирана атака?

За да обясним как да изберете парола, първо е добра идея да обясним как някой може да я "разбие". Така ще разберем какво **не** трябва да правим, и какви са рисковете.

### Защо не "12345678"?

Често срещани пароли са "password", "12345678", "qwerty123", "admin123" и подобни. Немалко хора си казват "аз няма да използвам password, ще ползвам password1" примерно. Но в глобален план, много, много други хора са имали същата мисъл.

Някой, който иска да влезе в акаунта ви, първо ще пробва списък от пароли, които често се ползват. В уикипедия може да намерим [няколко такива списъка](https://en.wikipedia.org/wiki/List_of_the_most_common_passwords), но те са ограничени до топ 20 или топ 25. Нищо не пречи човек да намери списък с хиляди такива пароли, които може за части от секундата да бъдат изпробвани от компютър. Възможно е точно вашия избор на лесна парола да е уникален, но е малко вероятно.

Тези пароли са удобни, защото са лесни за запомняне. Но, за нещастие, много други хора са се сетили за същите лесни последователности от символи, и това ги прави лесни за разбиване.

### Защо не някоя странна дума?

Стига една дума да е в речника, дори да е дълга и сложна, пак е твърде лесно да се разбие. Компютъра е достатъчно бърз, за да пробва абсолютно всички валидни думи в речника, дори и с някой и друг пунктуационен символ накрая. Техниката даже си има име -- "[речникова атака](https://en.wikipedia.org/wiki/Dictionary_attack)".

### Защо трябва да е дълга паролата?

Повечето сайтове днешно време ще Ви изискват парола с поне 8 символа. Причината е, че компютрите са достатъчно бързи да пробват абсолютно всяка комбинация от символи за парола. Отнема много време, но ако паролата Ви е кратка, може да бъде разбита по този метод -- метода на "[грубата сила](https://en.wikipedia.org/wiki/Brute-force_attack)".

Може да си представите, че компютъра ще пробва първо паролата "а", после "б", после "в"... като свърши азбуката, може да опита "аа", "аб", "ав"... Това може да ви звучи ужасно бавно, но според статия на [NordPass](https://nordpass.com/blog/brute-force-attack/), парола от 9 символа може да бъде разбита за 2 часа.

## Какви са предпазните средства от автоматична проверка на пароли?

Тук е добре да се отбележи, че повечето сайтове няма да позволят да се пробват милиарди пароли веднага една след друга. Самото пробване отнема време, и доста сайтове нарочно забавят проверката на парола, за да избегнат такива повторни опити.

Много сайтове и услуги ще ви блокират при твърде много на брой опити за известно време. Блокиране дори само за 10 секунди на всеки 3 проби на парола ще Ви позволят да влезете евентуално, дори да объркате паролата, но ще предотвратят "груба сила" от страна на нападател.

Все пак е добра идея да не разчитате на сайта да се погрижи за такива неща. Не винаги можете да имате доверие на разработчиците да са помислили за това -- по-добра идея е да си имате по-дълга и трудна за познаване парола, за да се подсигурите срещу подобни опити.

[Двуфакторна автентикация]({{< ref "two-factor-authentication.md">}}) също ще ви предпази -- ако всяко въвеждане на парола изисква и вторичен код, няма да има възможност за безкрайна проба и грешка.

## Лични атаки

За случаите, в които нападателя Ви познава лично, има и други видове пароли, които е добре да избягвате.

### Защо не дата на раждане?

Лични данни са често срещан шаблон за парола. Рождения ден на дете, име на домашен любимец, телефонен номер... Но тези данни лесно могат да бъдат намерени, и лесно могат да бъдат пробвани. Това е често срещано дори във филми -- "хакерите" винаги пробват нещо, което знаят за целта си като парола, и след няколко опита налучкват правилната информация.

Малко предимство пред досегашните примери е, че само някой с информация конкретно за вас би могъл да се досети, но не е невъзможно някой да ви избере като конкретна цел. Предпазени сте от нападатели, които правят "масови" атаки, но ако по една или друга причина някой Ви е набелязал, такава парола е лоша идея.

### Парола, запазена в браузъра?

Всички примери досега описват сценария, в който нападател се опитва да влезе в сайт с вашето име от собствения си компютър... Но какво става, ако си оставите компютъра отключен в кафене или в офиса?

Ако браузъра Ви помни пароли, лесно може някой да го отвори, да намери паролата, която му трябва, и да се изниже.

Отвъд това, браузъра **може** да ви пази сложни пароли, и даже да ви предложи такива, когато се регистрирате, така че потенциално е полезен инструмент. Но задължително се погрижете:

- Да заключвате компютъра си винаги, когато станете от него, в офиса или на публично място.
- Да сложите парола на акаунта си на самия компютър, така че никой да не може просто да го пусне и да влезе в него.
- Стига да е възможно, добра идея е да шифровате цялото си устройство. Така дори и в случай на кражба, няма как някой да се добере до паролите. Ето статия, която описва как да се настрои това в Windows 10: [Шифроване на устройства](https://support.microsoft.com/bg-bg/windows/%D1%88%D0%B8%D1%84%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B5-%D0%BD%D0%B0-%D1%83%D1%81%D1%82%D1%80%D0%BE%D0%B9%D1%81%D1%82%D0%B2%D0%B0-%D0%B2-windows-ad5dcf4b-dbe0-2331-228f-7925c2a3012d#ID0EBBD=Windows_10).

### Парола, написана на листче?

Парола, написана на хартия до компютъра, я обезсмисля напълно за някой, който има физически достъп до него. Разбира се, няма да имате проблеми с нападатели от интернет, но е възможно, колкото и неприятно да звучи, някой да разбие дома Ви и да открадне компютъра. При това положение, ако *освен това* имат достъп до хартийка с пароли, към загубата на физическата Ви собственост ще добавите и възможността някой да се възползва от онлайн присъствието Ви.

А в офиса, пароли на хартия може да се видят от всеки, който минава покрай бюрото, било то колега или доставчик на колети. Някой по-нахален външен човек може смело да отвори един-два шкафа, да намери някоя интересна бележка и да си замине преди някой да забележи.

Не е немислимо да си пазите паролите на хартия, но е важно да не ги държите близо до компютъра си и винаги да бъдат на сигурно място. Тефтер в чанта или портфейл може да е достатъчно добре, но се погрижете да се затваря. Не искате да извадите листче на публично място и седящия наблизо човек в кафенето да види паролата, докато си плащате сметката.

Допълнително, със сигурност се погрижете да имате план за ситуацията, в която загубите паролите, или компютъра. Каква е първата стъпка? Кои пароли ще трябва да обновите и как?

### Защо да не преизползваме пароли?

В случай, че една парола бъде открита, било то защото е била твърде слаба, и е налучкана с "груба сила", било то защото е била написана някъде и прочетена, в идеалния случай тази парола ще има ограничен ефект. Само една услуга ще бъде компрометирана, и можете бързо да решите проблема като смените паролата си.

Но стига да се знае, че паролата е била валидна, нападателите веднага ще я пробват за всички сайтове, които може да използвате. Ако сте ползвали същата парола на друго място, ще е много лесно да се сдобият с достъп до него.

## Какви пароли са "добри"?

Има два вида пароли, които се приемат за "добри":

- Пароли с много вариация и специални символи
- Пароли-фрази

Първия вид може да изглежда така: `DeS_5gYPbI$fchmd`. Такава парола:

- е достатъчно дълга, за да не може да бъде позната с груба сила
- не е валидна дума от речника или създадена по някакъв познат шаблон
- има специални символи, така че не е възможно да бъде позната просто с комбинация от азбуката

Проблема ѝ е, че е напълно невъзможна за запомняне. Добър вариант е за парола, която ще бъде пазена от мениджър за пароли или от браузър -- в интерес на истината, браузърите предлагат пароли с подобна форма. Но трябва да имате парола за самия мениджър или браузър.

Втория вариант е фраза от думи, например: "pass-slope-royal-boring". Тази конкретна парола е генерирана от този сайт: https://www.randompassphrasegenerator.com. Предимствата са:

- достатъчно е дълга
- не е валидна дума от речник -- няколко думи подред е, което усложнява нещата
- има специални символи -- може да са интервали между думите, може да са тиренца, точки...
- е потенциално по-лесна за запомняне

Това е често срещана препоръка заради последното -- може да използвате асоциации, за да запомните дори и дълга парола, стига да се състои от познати думи. Това прави този метод добър за главна парола на мениджър за пароли или за главна парола на компютъра. Не е нужно да ползвате сайт да ви я генерира -- може да си измислите фраза с произволни думи или цяло изречение, я на английски, я на български.

## Обобщение

Запознайте се с начините някой да ви познае паролата, и ще разберете как да си изберете такава, която е трудна за разбиване:

- Достатъчно дълга: поне 8 символа, но в идеалния случай дори повече
- Достатъчно трудна за познаване: без неща като "12345678" и за предпочитане без връзка с лични данни
- Лесна за използване: съхранена в мениджър за пароли или запомнена като фраза

Не забравяйте и че обикновено е напълно възможно да използвате кирилица за паролите си. Ако някаква услуга не Ви го позволява, много е вероятно да имат други проблеми със сигурността.
