---
title: "HTTPS"
date: 2018-07-01T11:35:28+03:00
slug: "https"
tags: ["криптиране"]
draft: true
---

Тази статия е част от група статии за <a href="/tags/криптиране">криптиране</a>.
За по-общо обяснение на концепцията за криптиране може да видите [статията по
темата]( {{< ref "posts/encryption.md" >}} ).

---

Най-често използваните методи на комуникация в интернет обикновено почиват на
HTTP протокола. Това е определен формат за обмяна на информация, който използват
повечето съвременни приложения, когато имат нужда да изпращат и получават
информация в някаква компютърна мрежа.

Най-популярния пример за такива приложения са уеб браузърите. Когато отворите
някой сайт в браузъра си в полето за адреса, може да видите, че преди адреса,
който сте изписали (или към който е сочел линк, на който сте цъкнали) има
добавен текст, който обикновено е едно от `http://` или `https://`.

Тъй като огромна част от нещата, които правим онлайн правим през браузър
(особено когато използваме компютър, а не телефон), ще разглеждаме всичко в
контекста на браузъра.

## HTTP (без S)

Вече споменахме, че при комуникацията между компютри в мрежа [всичко е
текст]({{< relref "encryption.md#всичко-е-текст" >}}). Това включва и въпросната
комуникация, която осъществява браузъра когато го използваме, за да достъпим
някой сайт. HTTP е текстов протокол, описващ как браузъра да укаже на сървъра, с
който се свързва какво съдържание иска от него и в какъв формат сървъра да върне
отговор, така че браузъра да го разбере и да покаже правилно съдържанието, което
получи като отговор.

Тъй като HTTP е протокол за текстов обмен между два компютъра в мрежа, това
означава, че при използването му, [всеки от посредниците]({{< ref
"encryption.md#по-пътя-между-две-устройства-почти-винаги-има-други-устройства"
>}}) в комуникацията може да прочете всичко изпратено като заявка и като отговор
на тази заявка. Нещо повече, тъй като липсва автентикация на която и да е от
страните, всеки от посредниците може да промени както заявката, така и получения
отговор.

## HTTPS

За комуникация, която трябва да се осъществява по HTTP, решението е използването
на HTTPS, който просто подсигурява криптиране на всички обменяни данни, така че
информацията нужна за осъществяване на HTTP комуникация е [криптирана]({{< ref
"encryption.md#нужен-е-ключ-за-прочитане-на-информацията" >}}) и [подписана]({{<
ref "encryption.md#гарантира-се-автентичността-на-съобщението" >}}).

Това ни гарантира две много важни неща:

 * комуникацията ни със сървъра не може да бъде прочетена, т.е. пароли, адреси и
   всякаква друга потенциално чувствителна информация, не може да бъде прочетена
   от посредниците в комуникацията
 * и двете страни в комуникацията имат уверение, че получават точно това, което
   другата страна им е изпратила

## Защо автентичността на информацията е важна

Дори един сайт да не изисква изпращане на каквато и да било чувствителна
информация и да третира всичкото си съдържание като публично, т.е. не се
изискват регистрации или пароли за достъп до каквото ида било в сайта,
използването на HTTP, вместо HTTPS все още носи немалка опасност.

Основния проблем в случая е липсата на гаранция за автентичността на полученото
съдържание от сървъра. Като тук опасността е не толкова за съдържанието, което
консумираме пряко (текст, изображения или видео, които са достъпни от сайта), а
за съдържанието предназначено като един вид служебна информация за браузъра ни,
включително изпълним код, който ще бъде пуснат в браузъра ни.

Това означава, че при липса на автентикация на полученото съдържание, на
практика е тривиално за всеки от посредниците в комуникацията, да промени
съдържанието. Например да добави злонамерен код, който ще се изпълни в браузъра
при зареждане на страницата и потенциално може да доведе до лоши последствия,
като сваляне на по-сериозен злонамерен софтуер, който може дългосрочно да следи
дейността на устройството и потенциално да изпраща пароли и/или чувствителна
комуникация на трети лица.

Подобни механизми на добавяне на съдържание към несигурни HTTP връзки са сред
похватите, с които често се разпространяват крипто вируси, тъй като при тях няма
конкретна цел на атаката, а се цели възможно най-голямо разпространение.

## Как да разберем дали един сайт използва HTTPS

Най-елементарния (но не най-удобен) начин е да видим дали URL-а (адреса изписан
в адрес бара на браузъра) започва с `https://`. Ако да, то браузъра знае, че
трябва да говори със сървъра само по сигурния протокол HTTPS и няма да приеме
отговор, който не спазва този протокол.

Ако адресът започва с `http://`, това означава, че сайта използва HTTP, т.е.
всичката информация, която се обменя между нашия компютър и сайта преминава през
посредниците в мрежата като [открит текст]({{< ref
"encryption.md#открит-и-шифрован-текст" >}}).

Разликата между `http://` и `https://` е съвсем малка и не много лесна за
долавяне. За това браузърите обикновено се стараят да показват доста очевидно
дали отворения сайт използва HTTP или HTTPS.


<table>
  <tr>
    <td><strong>Chrome</strong> показва катинарче и информация за издателя на сертификата за сигурност. HTTP сайта е маркиран като "Not secure".</td>
    <td width="350px"><img src="/images/phishing/https_chrome.png" alt="HTTP и HTTPS в Chrome" /></td>
  </tr>

  <tr>
    <td><strong>Firefox</strong> показва само катинарче за HTTPS страница. HTTP страницата обаче е различна с това, че изобщо не се вижда етикет "http://". Модерни версии на този браузър ще ви предупреждават и ако въвеждате пароли на не-HTTPS страница.</td>
    <td><img src="/images/phishing/https_firefox.png" alt="HTTP и HTTPS във Firefox" /></td>
  </tr>

  <tr>
    <td><strong>Internet Explorer</strong> не е толкова очевиден. Ако ползвате него, трябва внимателно да се загледате в текста -- или "http://" или "https://".</td>
    <td><img src="/images/phishing/https_ie.png" alt="HTTP и HTTPS в Internet Explorer" /></td>
  </tr>
</table>

Подобни индикации има и в мобилните версии на браузърите

<table>
  <tr>
    <td><strong>Мобилната версия на Firefox</strong> показва зелено катинарче и изписва "https://" като част от адреса</td>
    <td><img src="/images/https/android_ff.png" alt="HTTP и HTTPS във мобилната версия на Firefox" /></td>
  </tr>
  <tr>
    <td><strong>Мобилната версия на Chrome</strong> също показва зелено
    катинарче и протокола, когато сайта е сервиран по HTTPS</td>
    <td><img src="/images/https/android_chrome.png" alt="HTTP и HTTPS във мобилната версия на Firefox" /></td>
  </tr>
  <tr>
    <td><strong>Мобилната версия на Safari</strong> показва катинарче, когато
    сайта е сервиран по HTTPS</td>
    <td><img src="/images/https/iOS_safari.png" alt="HTTP и HTTPS във мобилната версия на Firefox" /></td>
  </tr>
</table>

В момента повечето сайтове вече използват HTTPS по подразбиране. В последните
години, начинания като [letsencrypt](https://letsencrypt.org/) направиха
конфигурирането на HTTPS изключително евтино и буквално безплатно. Уви, все още се
намират сайтове, чиито собственици настояват, че нямат нужда от HTTPS или поне,
че има смисъл от това да сервират съдържанието си и по HTTP и по HTTPS, тъй като
някои части от сайтовете им „не съдържат никаква чувствителна информация“.

Добрата новина обаче е, че създателите на уеб браузъри въвеждат все повече и повече промени в продуктите си, които правят сервирането на сайтове по HTTP, най-малкото непрактично за поддържащите сайта и крайно неприятно за потребителите му. В някакъв момент в бъдещето, най-вероятно сервирането на съдържание по HTTP ще изчезне окончателно, в полза на HTTPS. До тогава неща като [HTTPS Everywhere](https://www.eff.org/https-everywhere) са добър инструмент, с който да си подсигурите, че поне една добра част от информацията, която пращате и получавате през браузъра си минава по HTTPS. Тази приставка подсигурява, че за списък от добре известни сайтове комуникацията винаги се извършва по HTTPS, дори ако самите сайтове поддържат HTTP комуникация по подразбиране.
