---
title: "Криптиране"
date: 2019-05-20
slug: "криптиране"
tags: ["криптиране", "базова-информация"]
draft: false
---

_(Този текст е **базова информация**: Няма да ви даде практически съвети, а фундаментално разбиране за това как работи нещо. Ще бъде полезен за бъдещи статии)_.

"Криптиране" е дума, която сигурно е позната, поне от холивудските филми с хакери и "декриптиране" на пароли. Както винаги, Холивуд може да е малко подвеждащ, но основната идея е, че "криптиране" или "шифриране" е опит за скриване на някаква информация, така че да е само достъпна за хора, които имат ключ или парола за нея.

Паролите, които въвеждате в сайтове, се пазят в криптиран (по-точно "хеширан") вид -- така дори собствениците на сайтовете не знаят каква е паролата ви. Кредитните карти дадени на онлайн магазини също се съхраняват така. Можете да криптирате цялото съдържание на лаптопа си или телефона си ("Full-disk encryption"), и така никой няма да може да прочете какво има на него, освен ако не им кажете каква парола сте използвали за процеса.

## Тайни съобщения

Най-простия вид криптиране, или "шифър", е "[Шифъра на Цезар](https://bg.wikipedia.org/wiki/%D0%A8%D0%B8%D1%84%D1%8A%D1%80_%D0%BD%D0%B0_%D0%A6%D0%B5%D0%B7%D0%B0%D1%80)". Идеята е проста: вземате всяка буква от входа, и я превръщате в следващата буква в азбуката. Или в по-следващата, или в буквата на разстояние 5. Ето едно примерно съобщение:

> Сигурността онлайн не е само за хората със специални шапки!

Отмествайки всяка буква със следващата в азбуката:

> Тйдфсоптууб помбко ож ж тбнп иб цпсбуб тьт тржчйбмой щбрлй!

Единственото, което трябва да направим за да дешифрираме този текст, е превърнем всяка буква в предната -- първото "Т" отива в "С", а преди "й" имаме "и". Но как бихте дешифрирали този текст?

> Ьчлй лово цо о ьчфучлй фоъцч рй ногсящсщйцо.

Ако опитаме пак да мръднем буквите с едно назад, няма да получим нищо смислено ("Ъцки кнбн ..."?) Това е защото съм отместил буквите с някакво друго число позиции. Тъй като знам какво е числото, много лесно мога да се справя с декриптирането на това съобщение. Но ако някой го намери на листче хартия в междучасието, има да се почесва по главата. Това число е "паролата" за дешифриране на този текст.

Разбира се, има го проблема, че възможностите за отместването са само 29. Ако отместим буквите с 30, все едно сме ги оставили на място. А ако сме чели достатъчно истории за [Шерлок Холмс](https://bg.wikipedia.org/wiki/%D0%A1%D0%BC%D1%8A%D1%80%D1%82%D0%BE%D0%BD%D0%BE%D1%81%D0%BD%D0%B8%D1%82%D0%B5_%D1%84%D0%B8%D0%B3%D1%83%D1%80%D0%B8) и имаме достатъчно дълго послание, може и да успеем да налучкаме отместването като мислим за това кои букви са най-често срещани в българския език. За щастие, модерните компютърни системи използват доста по-сложни схеми за криптиране.

## Криптиране, трудно даже за компютри

Броя букви в азбуката е доста малък на фона на всички възможни данни, които един компютър може да съдържа. Вътре в паметта, всяка буква, число, или даже пиксел на екрана може да се представи като някаква комбинация от числа. Емоджито 🙂, например, се представя на моя компютър с числото 128578. Защо точно това число зависи от много фактори, но важното е, че абсолютно всичко, което се пази в дигитален вид може да се представи с комбинация от числа.

Горния шифър превръща, примерно, буквата "А" в буквата "Ж". Това е просто една трансформация на едно число в друго. Такава трансформация може да се направи за кое да е число, и то с много по-сложна формула. Така може да превърнем всеки текст, картинка, или каквото и да е друго в поредица от числа, които не могат да се разберат от никой, освен този, който знае *как* са били шифровани данните, за да обърне операцията.

Нека да използваме метода за шифроване "blowfish" върху този текст:

> Здравейте, читатели на "Разумна Сигурност"

Паролата, която ще използваме, е `foxpro-pension-reform-excluded-plea`. Резултата е поредица от числа, които можем да превърнем в четими символи с метода [Base64](https://en.wikipedia.org/wiki/Base64):

```
dXu5oJXtW7on9ADbgG0DBL17NAjnQgB1dYY54mFqIDm+1stOJ0R6kkHQt1vmYYB0
```

Тази поредица от символи изобщо не изглежда като оригиналния текст и няма как човек да го разгадае без да знае каква е използваната парола. Букви и символи се свеждат до числа и биват трансформирани до други числа, без очевидна връзка с оригинала. Дори и да се използва компютър, който да пробва пароли на случаен принцип, избраната ни парола е достатъчно дълга, за да отнеме милиони години опити за да се налучка (колкото и невероятно да звучи).

Може да експериментирате с алгоритъма (метода) за криптиране blowfish онлайн: http://sladex.org/blowfish.js/.

## Странична бележка: еднопосочно криптиране

Криптирането, за което говорихме досега, позволява да шифрирате или дешифрирате някакви данни, стига да знаете паролата. Един друг тип скриване на информация, който се нарича "хеширане" работи само в едната посока -- едно парче данни може да се разбърка до такава степен, че да е (практически) невъзможно да се открие каква е била оригиналната му стойност.

Примерно, може да използваме алгоритъма "MD5", за да трансформираме този текст:

> Здравейте, читатели на "Разумна Сигурност"

И да го превърнем в този резултат:

```
246b143d354e59e8a1a5c7990cf2dac2
```

Ако дори и само добавим един символ отзад, "!", получаваме нещо съвсем различно:

> Здравейте, читатели на "Разумна Сигурност"!

...се превръща във:

```
c4cac72365de4e82bfb6cf3050de369f
```

Двата входа са почти едни и същи, но изходите са напълно различни. Математическите формули, които се използват, са подбрани по такъв начин, че да генерират много различни резултати за много близки парчета текст. Операциите се прилагат лесно в едната посока, но много трудно в обратната. Обикновено се използва факта, че е лесно да умножим две прости числа (примерно, 13 по 17 дава 221), но е много по-трудно да разберем на какви прости числа се дели едно число (нямаме лесен метод да разберем какви са делителите на 221). Компютъра може да пробва всички възможности, но ако числата са *много* големи, това би отнело, пак, милиони години.

Но какъв е смисъла от трансформиране на текст, ако няма как да го възстановим? Така се съхраняват пароли в повечето сайтове -- използва се хеширащ алгоритъм (един от най-популярните тези дни се казва "[bcrypt](https://en.wikipedia.org/wiki/Bcrypt)"), комбиниран с още данни, скрити на различни места, за да се превърне паролата в "хеш", чийто източник дори и собствениците на сайта не знаят. След това, когато въведете паролата си за да влезете в сайта, паролата се хешира *отново*, по същия начин, и се сравнява с това, което сайта пази за вас. Ако двата хеша пасват, това е гаранция, че сте въвели правилната парола.

Това е важната причина повечето сайтове да не могат да ви "напомнят" каква ви е паролата -- и те няма как да я знаят. Освен, разбира се, ако не я пазят без хеширане, което е изключително лоша идея. Но вероятно ще имаме отделна статия, в която ще говорим в повече детайли за пароли.

## Криптирани съобщения между два компютъра

При комуникацията между два компютъра в интернет, не е никак лесно да сме сигурни кой е изпратил съобщението, дали получателя го е получил непроменено и дали върнатия отговор не е бил променен по трасето. Всяка комуникация минава през някакви посредници и те имат възможността да подменят данните както си решат -- вашия интернет доставчик би могъл, на теория, да подслуша чата ви с някого, и даже да му прати лъжливи съобщения. Google редовно обработват електронните ви писма, за да могат да разберат интересите ви и да ви предлагат реклами.

Как помага криптирането в този случай? Всяко съобщение, което пращаме и всеки сайт, който гледаме, може да се шифрира с ключ, който е известен само на нас. Така, дори и някой по пътя да прихване части от информацията, те не биха могли да я разберат. В доста модерни браузъри, мейл клиенти и т.н., това често се случва автоматично (стига сайта да започва с "https://" вместо с "http://").

От друга страна, чатове, скайп, или фейсбук съобщения, не се криптират по този начин, но може сами да добавим криптиране с програма като [PGP](https://en.wikipedia.org/wiki/Pretty_Good_Privacy). Това може да усложни нещата, но ако се притесняваме, че примерно фейсбук четат съобщенията ни и ги използват за да пробутват реклами, може би си заслужава допълнителното усилие да ги скрием от тях и да държим личната си комуникация наистина лична. Съществуват чат клиенти като [Signal](https://signal.org/), които са устроени с криптиране без нужда от допълнителна работа.

## Накратко

- "Криптиране" или "шифриране" са методи за скриване на информация с определена парола или ключ.
- Декриптиране/дешифриране може да се направи само от човек (или компютър), който знае този ключ.
- Съществува "еднопосочно" криптиране, или "хеширане", което обикновено се използва за скриване на пароли.

Дори и ние самите да не използваме криптиращи програми, целия интернет е изграден върху тях. Неприкосновеността на личната ни комуникация може да се гарантира само и единствено по този начин. Физическите писма могат да се опаковат в непрозрачни пликове, но в интернет, единствения начин да не бъдем подслушвани, е да шифрираме електронната си поща, чатовете и съобщенията си.

Разбирането на този процес е важно, за да можем да правим информирани избори за програмите и сайтовете, които ползваме в ежедневното си онлайн присъствие.
