/*
LaunchyQt
Copyright (C) 2018 Samson Wang

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "UnicodeTable.h"
#include <cstring>

const ushort zhCN_min = 19968;
const ushort zhCN_max = static_cast<ushort>(zhCN_min + std::strlen(zhCN_table));
const char*  zhCN_table =
"ydyqsxmwzssxjbymgcczqpssqbycdscdqldylybssjgyzzjjfkcclzdhwdwzjljpfyynwjjtmyhzwzhflzppqhgscyyynjqyxxgj"
"hhsdsjnkktmomlcrxypsnqseccqzggllyjlmyzzsecykyyhqwjssggyxyzyjwwkdjhychmyxjtlxjyqbyxzldwrdjrwysrldzjpc"
"bzjjbrcftleczstzfxxzhtrqhybdlyczssymmrfmyqzpwwjjyfcrwfdfzqpyddwyxkyjawjffxypsftzyhhyzyswcjyxsclcxxwz"
"zxnbgnnxbxlzszsbsgpysyzdhmdzbqbzcwdzzyytzhbtsyybzgntnxqywqskbphhlxgybfmjebjhhgqtjcysxstkzhlyckglysmz"
"xyalmeldccxgzyrjxsdltyzcqkcnnjwhjtzzcqljststbnxbtyxceqxgkwjyflzqlyhyxspsfxlmpbysxxxydjczylllsjxfhjxp"
"jbtffyabyxbhzzbjyzlwlczggbtssmdtjzxpthyqtgljscqfzkjzjqnlzwlslhdzbwjncjzyzsqqycqyrzcjjwybrtwpyftwexcs"
"kdzctbzhyzzyyjxzcffzzmjyxxsdzzottbzlqwfckszsxfyrlnyjmbdthjxsqqccsbxyytsyfbxdztgbcnslcyzzpsazyzzscjcs"
"hzqydxlbpjllmqxtydzxsqjtzpxlcglqtzwjbhctsyjsfxyejjtlbgxsxjmyjqqpfzasyjntydjxkjcdjszcbartdclyjqmwnqnc"
"lllkbybzzsyhqqltwlccxtxllzntylnewyzyxczxxgrkrmtcndnjtsyyssdqdghsdbjghrwrqlybglxhlgtgxbqjdzpyjsjyjctm"
"rnymgrzjczgjmzmgxmpryxkjnymsgmzjymkmfxmldtgfbhcjhkylpfmdxlqjjsmtqgzsjlqdldgjycalcmzcsdjllnxdjffffjcz"
"fmzffpfkhkgdpsxktacjdhhzddcrrcfqyjkqccwjdxhwjlyllzgcfcqdsmlzpbjjplsbcjggdckkdezsqcckjgcgkdjtjdlzycxk"
"lqscgjcltfpcqczgwpjdqyzjjbyjhsjdzwgfsjgzkqcczllpspkjgqjhzzljplgjgjjthjjyjzczmlzlyqbgjwmljkxzdznjqsyz"
"mljlljkywxmkjlhskjgbmclyymkxjqlbmllkmdxxkwyxyslmlpsjqqjqxyxfjtjdxmxxllcxqbsyjbgwymbggbcyxpjygpepfgdj"
"gbhbnsqjyzjkjkhxqfgqzkfhygkhdkllsdjqxpqykybnqsxqnszswhbsxwhxwbzzxdmnsjbsbkbbzklylxgwxdrwyqzmywsjqlcj"
"xxjxkjeqxscyetlzhlyyysdzpaqyzcmtlshtzcfyzyxyljsdcjqagyslcqlyyyshmrqqkldxzscsssydycjysfsjbfrsszqsbxxp"
"xjysdrckgjlgdkzjzbdktcsyqpyhstcldjdhmxmcgxyzhjddtmhltxzxylymohyjcltyfbqqxpfbdfhhtksqhzyywcnxxcrwhowg"
"yjlegwdqcwgfjycsntmytolbygwqwesjpwnmlrydzsztxyqpzgcwxhngpyxshmyqjxztdppbfyhzhtjyfdzwkgkzbldntsxhqeeg"
"zzylzmmzyjzgxzxkhkstxnxxwylyapsthxdwhzympxagkydxbhnhxkdpjnmyhylpmgocslnzhkxxlpzzlbmlsfbhhgygyyggbhsc"
"yaqtywlxtzqcezydqdqmmhtkllszhlsjzwfyhqswscwlqazynytlsxthaznkzzszzlaxxzwwctgqqtddyztcchyqzflxpslzygpz"
"sznglndqtbdlxgtctajdkywnsyzljhhzzcwnyyzywmhychhyxhjkzwsxhzyxlyskqyspslyzwmyppkbyglkzhtyxaxqsyshxasmc"
"hkdscrswjpwxsgzjlwwschsjhsqnhcsegndaqtbaalzzmsstdqjcjktscjaxplggxhhgxxzcxpdmmhldgtybysjmxhmrcpxxjzck"
"zxshmlqxxtthxwzfkhcczdytcjyxqhlxdhypjqxylsyydzozjnyxqezysqyayxwypdgxddxsppyzndltwrhxydxzzjhtcxmczlhp"
"yyyymhzllhnxmylllmdcppxhmxdkycyrdltxjchhzzxzlcclylnzshzjzzlnnrlwhyqsnjhxyntttkyjpychhyegkcttwlgqrlgg"
"tgtygyhpyhylqyqgcwyqkpyyyttttlhyhlltyttsplkyzxgzwgpydsszzdqxskcqnmjjzzbxyqmjrtffbtkhzkbxljjkdxjtlbwf"
"zpptkqtztgpdgntpjyfalqmkgxbdclzfhzclllladpmxdjhlcclgyhdzfgyddgcyyfgydxkssebdhykdkdkhnaxxybpbyyhxzqga"
"ffqyjxdmljcsqzllpchbsxgjyndybyqspzwjlzksddtactbxzdyzypjzqsjnkktknjdjgyypgtlfyqkasdntcyhblwdzhbbydwjr"
"ygkzyheyyfjmsdtyfzjjhgcxplxhldwxxjkytcyksssmtwcttqzlpbszdzwzxgzagyktywxlhlspbclloqmmzsslcmbjcszzkydc"
"zjgqqdsmcytzqqlwzqzxssfpttfqmddzdshdtdwfhtdyzjyqjqkypbdjyyxtljhdrqxxxhaydhrjlklytwhllrllrcxylbwsrszz"
"symkzzhhkyhxksmdsydycjpbzbsqlfcxxxnxkxwywsdzyqoggqmmyhcdzttfjyybgstttybykjdhkyxbelhtypjqnfxfdykzhqkz"
"byjtzbxhfdxkdaswtawajldyjsfhbldnntnqjtjnchxfjsrfwhzfmdryjyjwzpdjkzyjympcyznynxfbytfyfwygdbnzzzdnytxz"
"emmqbsqehxfzmbmflzzsrxymjgsxwzjsprydjsjgxhjjgljjynzzjxhgxkymlpyyycxytwqzswhwlyrjlpxslsxmfswwklctnxny"
"npsjszhdzeptxmyywxyysywlxjqzqxzdcleeelmcpjpclwbxsqhfwwtffjtnqjhjqdxhwlbyznfjlalkyyjldxhhycstyywnrjyx"
"ywtrmdrqhwqcmfjdyzmhmyyxjwmyzqzxtlmrspwwchaqbxygzypxyyrrclmpymgksjszysrmyjsnxtplnbappypylxyyzkynldzy"
"jzcznnlmzhharqmpgwqtzmxxmllhgdzxyhxkyxycjmffyyhjfsbssqlxxndycannmtcjcyprrnytyqnyymbmsxndlylysljrlxys"
"xqmllyzlzjjjkyzzcsfbzxxmstbjgnxyzhlxnmcwscyzyfzlxbrnnnylbnrtgzqysatswryhyjzmzdhzgzdwybsscskxsyhytxxg"
"cqgxzzshyxjscrhmkkbxczjyjymkqhzjfnbhmqhysnjnzybknqmclgqhwlznzswxkhljhyybqlbfcdsxdldspfzpskjyzwzxzddx"
"jsmmegjscssmgclxxkyyylnypwwwgydkzjgggzggsycknjwnjpcxbjjtqtjwdsspjxzxnzxumelpxfsxtllxcljxjjljzxctpswx"
"lydhlyqrwhsycsqyybyaywjjjqfwqcqqcjqgxaldbzzyjgkgxpltzyfxjltpadkyqhpmatlcpdckbmtxybhklenxdleegqdymsaw"
"hzmljtwygxlyqzljeeyybqqffnlyxrdsctgjgxyynkllyqkcctlhjlqmkkzgcyygllljdzgydhzwxpysjbzkdzgyzzhywyfqytyz"
"szyezzlymhjjhtsmqwyzlkyywzcsrkqytltdxwctyjklwsqzwbdcqyncjsrszjlkcdcdtlzzzacqqzzddxyplxzbqjylzlllqddz"
"qjyjyjzyxnyyynyjxkxdazwyrdljyyyrjlxlldyxjcywywnqcclddnyyynyckczhxxcclgzqjgkwppcqqjysbzzxyjsqpxjpzbsb"
"dsfnsfpzxhdwztdwpptflzzbzdmyypqjrsdzsqzsqxbdgcpzswdwcsqzgmdhzxmwwfybpdgphtmjthzsmmbgzmbzjcfzwfzbbzmq"
"cfmbdmcjxlgpnjbbxgyhyyjgptzgzmqbqtcgyxjxlwzkydpdymgcftpfxyztzxdzxtgkmtybbclbjaskytssqyymszxfjewlxlls"
"zbqjjjaklylxlycctsxmcwfkkkbsxlllljyxtyltjyytdpjhnhnnkbyqnfqyyzbyyessessgdyhfhwtcjbsdzztfdmxhcnjzymqw"
"sryjdzjqpdqbbstjggfbkjbxtgqhngwjxjgdllthzhhyyyyyysxwtyyyccbdbpypzycczyjpzywcbdlfwzcwjdxxhyhlhwzzxjtc"
"zlcdpxujczzzlyxjjtxphfxwpywxzptdzzbdzcyhjhmlxbqxsbylrdtgjrrcttthytczwmxfytwwzcwjwxjywcskybzscctzqnhx"
"nwxxkhkfhtswoccjybcmpzzykbnnzpbzhhzdlsyddytyfjpxyngfxbyqxcbhxcpsxtyzdmkysnxsxlhkmzxlyhdhkwhxxsskqyhh"
"cjyxglhzxcsnhekdtgzxqypkdhextykcnymyyypkqyyykxzlthjqtbyqhxbmyhsqckwwyllhcyylnneqxqwmcfbdccmljggxdqkt"
"lxkgnqcdgzjwyjjlyhhqtttnwchmxcxwhwszjydjccdbqcdgdnyxzthcqrxcbhztqcbxwgqwyybxhmbymyqtyexmqkyaqyrgyzsl"
"fykkqhyssqyshjgjcnxkzycxsbxyxhyylstycxqthysmgscpmmgcccccmtztasmgqzjhklosqylswtmxsyqkdzljqqyplsycztcq"
"qpbbqjzclpkhqzyyxxdtddtsjcxffllchqxmjlwcjcxtspycxndtjshjwxdqqjskxyamylsjhmlalykxcyydmnmdqmxmcznncybz"
"kkyflmchcmlhxrcjjhsylnmtjzgzgywjxsrxcwjgjqhqzdqjdcjjzkjkgdzqgjjyjylxzxxcdqhhheytmhlfsbdjsyyshfystczq"
"lpbdrfrztzykywhszyqkwdqzrkmsynbcrxqbjyfazpzzedzcjywbcjwhyjbqszywryszptdkzpfpbnztklqyhbbzpnpptyzzybqn"
"ydcpjmmcycqmcyfzzdcmnlfpbplngqjtbttnjzpzbbznjkljqylnbzqhksjznggqszzkyxshpzsnbcgzkddzqanzhjkdrtlzlswj"
"ljzlywtjndjzjhxyayncbgtzcssqmnjpjytyswxzfkwjqtkhtzplbhsnjzsyzbwzzzzlsylsbjhdwwqpslmmfbjdwaqyztcjtbnn"
"wzxqxcdslqgdsdpdzhjtqqpswlyyjzlgyxyzlctcbjtktyczjtqkbsjlgmgzdmcsgpynjzyqyyknxrpwszxmtncszzyxybyhyzax"
"ywqcjtllckjjtjhgdxdxyqyzzbywdlwqcglzgjgqrqzczssbcrpcskydznxjsqgxssjmydnstztpbdltkzwxqwqtzexnqczgwezk"
"ssbybrtssslccgbpszqszlccglllzxhzqthczmqgyzqznmcocszjmmzsqpjygqljyjppldxrgzyxccsxhshgtznlzwzkjcxtcfcj"
"xlbmqbczzwpqdnhxljcthyzlgylnlszzpcxdscqqhjqksxzpbajyemsmjtzdxlcjyryynwjbngzztmjxltbslyrzpylsscnxphll"
"hyllqqzqlxymrsycxzlmmczltzsdwtjjllnzggqxpfskygyghbfzpdkmwghcxmsgdxjmcjzdycabxjdlnbcdqygskydqtxdjjyxm"
"szqazdzfslqxyjsjzylbtxxwxqqzbjzufbblylwdsljhxjyzjwtdjczfqzqzzdzsxzzqlzcdzfjhyspympqzmlpplffxjjnzzyls"
"jeyqzfpfzksywjjjhrdjzzxtxxglghydxcskyswmmzcwybazbjkshfhjcxmhfqhyxxyzftsjyzfxyxpzlchmzmbxhzzsxyfymncw"
"dabazlxktcshhxkxjjzjsthygxsxyyhhhjwxkzxssbzzwhhhcwtzzzpjxsnxqqjgzyzywllcwxzfxxyxyhxmkyyswsqmnlnaycys"
"pmjkhwcqhylajjmzxhmmcnzhbhxclxtjpltxyjhdyylttxfszhyxxsjbjyayrsmxyplckduyhlxrlnllstyzyyqygyhhsccsmzct"
"zqxkyqfpyyrpfflkquntszllzmwwtcqqyzwtllmlmpwmbzsstzrbpddtlqjjbxzcsrzqqygwcsxfwzlxccrszdzmcyggdzqsgtjs"
"wljmymmzyhfbjdgyxccpshxnzcsbsjyjgjmppwaffyfnxhyzxzylremzgzcyzsszdlljcsqfnxzkptxzgxjjgfmyyysnbtylbnlh"
"pfzdcyfbmgqrrssszxysgtzrnydzzcdgpjafjfzknzblczszpsgcycjszlmlrszbzzldlsllysxsqzqlyxzlskkbrxbrbzcycxzz"
"zeeyfgklzlyyhgzsgzlfjhgtgwkraajyzkzqtsshjjxdcyzuyjlzyrzdqqhgjzxsszbykjpbfrtjxllfqwjhylqtymblpzdxtzyg"
"bdhzzrbgxhwnjtjxlkscfsmwlsdqysjtxkzscfwjlbxftzlljzllqblsqmqqcgczfpbphzczjlpyyggdtgwdcfczqyyyqyssclxz"
"sklzzzgffcqnwglhqyzjjczlqzzyjpjzzbpdccmhjgxdqdgdlzqmfgpsytsdyfwwdjzjysxyyczcyhzwpbykxrylybhkjksfxtzj"
"mmckhlltnyymsyxyzpyjqycsycwmtjjkqyrhllqxpsgtlyycljscpxjyzfnmlrgjjtyzbxyzmsjyjhhfzqmsyxrszcwtlrtqzsst"
"kxgqkgsptgcznjsjcqcxhmxggztqydjkzdlbzsxjlhyqgggthqszpyhjhhgyygkggcwjzzylczlxqsftgzslllmljskctbllzzsz"
"mmnytpzsxqhjcjyqxyzxzqzcpshkzzysxcdfgmwqrllqxrfztlystctmjcxjjxhjnxtnrztzfqyhqgllgcxszsjdjljcydsjtlny"
"xhszxcgjzyqpylfhdjsbpcczhjjjqzjqdybssllcmyttmqtbhjqnnygkyrqyqmzgcjkpdcgmyzhqllsllclmholzgdyyfzsljcqz"
"lylzqjeshnylljxgjxlysyyyxnbzljsszcqqcjyllzltjyllzllbnylgqchxyyxoxcxqkyjxxxyklxsxxyqxcykqxqcsgyxxyqxy"
"gytqohxhxpyxxxulcyeychzzcbwqbbwjqzscszsslzylkdesjzwmymcytsdsxxscjpqqsqylyyzycmdjdzywcbtjsydjkcyddjlb"
"djjsodzysyxqqyxdhhgqqyqhdyxwgmmmajdybbbppbcmuupljzsmtxerxjmhqnutpjdcbssmssstkjtssmmtrcplzszmlqdsdmjm"
"qpnqdxcfynbfsdqxyxhyaykqyddlqyyysszbydslntfqtzqpzmchdhczcwfdxtmyqsphqyyxsrgjcwtjtzzqmgwjjtjhtqjbbhwz"
"pxxhyqfxxqywyyhyscdydhhqmnmtmwcpbszppzzglmzfollcfwhmmsjzttdhzzyffytzzgzyskyjxqyjzqbhmbzzlyghgfmshpzf"
"zsnclpbqsnjxzslxxfpmtyjygbxlldlxpzjyzjyhhzcywhjylsjexfszzywxkzjluydtmlymqjpwxyhxsktqjezrpxxzhhmhwqpw"
"qlyjjqjjzszcphjlchhnxjlqwzjhbmzyxbdhhypzlhlhlgfwlchyytlhjxcjmscpxstkpnhqxsrtyxxtesyjctlsslstdlllwwyh"
"dhrjzsfgxtsyczynyhtdhwjslhtzdqdjzxxqhgyltzphcsqfclnjtclzpfstpdynylgmjllycqhysshchylhqyqtmzypbywrfqyk"
"qsyslzdqjmpxyyssrhzjnywtqdfzbwwtwwrxcwhgyhxmkmyyyqmsmzhngcepmlqqmtcwctmmpxjpjjhfxyyzsxzhtybmstsyjttq"
"qqyylhynpyqzlcyzhzwsmylkfjxlwgxypjytysyxymzckttwlksmzsylmpwlzwxwqzssaqsyxyrhssntsrapxcpwcmgdxhxzdzyf"
"jhgzttsbjhgyzszysmyclllxbtyxhbbzjkssdmalxhycfygmqypjycqxjllljgslzgqlycjcczotyxmtmttllwtgpxymzmklpszz"
"zxhkqysxctyjzyhxshyxzkxlzwpsqpyhjwpjpwxqqylxsdhmrslzzyzwttcyxyszzshbsccstplwsscjchnlcgchssphylhfhhxj"
"sxyllnylszdhzxylsxlwzykcldyaxzcmddyspjtqjzlnwqpssswctstszlblnxsmnyymjqbqhrzwtyydchqlxkpzwbgqybkfcmzw"
"pzllyylszydwhxpsbcmljbscgbhxlqhyrljxyswxwxzsldfhlslynjlzyflyjycdrjlfsyzfsllcqyqfgjyhyxzlylmstdjcyhbz"
"llnwlxxygyyhsmgdhxxhhlzzjzxczzzcyqzfngwpylcpkpyypmclqkdgxzggwqbdxzzkzfbxxlzxjtpjpttbytszzdwslchzhslt"
"yxhqlhyxxxyyzyswtxzkhlxzxzpyhgchkcfsyhutjrlxfjxptztwhplyxfcrhxshxkyxxyhzqdxqwulhyhmjtbflkhtxcwhjfwjc"
"fpqryqxcyyyqygrpywsgsungwchkzdxyflxxhjjbyzwtsxxncyjjymswzjqrmhxzwfqsylzjzgbhynslbgttcsybyxxwxyhxyyxn"
"sqyxmqywrgyqlxbbzljsylpsytjzyhyzawlrorjmksczjxxxyxchdyxryxxjdtsqfxlyltsffyxlmtyjmjuyyyxltzcsxqzqhzxl"
"yyxzhdnbrxxxjctyhlbrlmbrllaxkyllljlyxxlycrylcjtgjcmtlzllcyzzpzpcyawhjjfybdyyzsmpckzdqyqpbpcjpdcyzmdp"
"bcyydycnnplmtmlrmfmmgwyzbsjgygsmzqqqztxmkqwgxllpjgzbqcdjjjfpkjkcxbljmswmdtqjxldlppbxcwrcqfbfqjczahzg"
"mykphyyhzykndkzmbpjyxpxyhlfpnyygxjdbkxnxhjmzjxstrstldxskzysybzxjlxyslbzyslhxjpfxpqnbylljqkygzmcyzzym"
"ccslclhzfwfwyxzmwsxtynxjhpyymcyspmhysmydyshqyzchmjjmzcaagcfjbbhplyzylxxsdjgxdhkxxtxxnbhrmlyjsltxmrhn"
"lxqjxyzllyswqgdlbjhdcgjyqycmhwfmjybmbyjyjwymdpwhxqldygpdfxxbcgjspckrssyzjmslbzzjfljjjlgxzgyxyxlszqyx"
"bexyxhgcxbpldyhwettwwcjmbtxchxyqxllxflyxlljlssfwdpzsmyjclmwytczpchqekcqbwlcqydplqppqzqfjqdjhymmcxtxd"
"rmjwrhxcjzylqxdyynhyyhrslsrsywwzjymtltllgtqcjzyabtckzcjyccqljzqxalmzyhywlwdxzxqdllqshgpjfjljhjabcqzd"
"jgtkhsstcyjlpswzlxzxrwgldlzrlzxtgsllllzlyxxwgdzygbdphzpbrlwsxqbpfdwofmwhlypcbjccldmbzpbzzlcyqxldomzb"
"lzwpdwyygdstthcsqsccrsssyslfybfntyjszdfndpdhdzzmbblslcmyffgtjjqwftmtpjwfnlbzcmmjtgbdzlqlpyfhyymjylsd"
"chdzjwjcctljcldtljjcpddsqdsszybndbjlggjzxsxnlycybjxqycbylzcfzppgkcxzdzfztjjfjsjxzbnzyjqttyjyhtyczhym"
"djxttmpxsplzcdwslshxypzgtfmlcjtycbpmgdkwycyzcdszzyhflyctygwhkjyylsjcxgywjcbllcsnddbtzbsclyzczzssqdll"
"mqyyhfslqllxftyhabxgwnywyypllsdldllbjcyxjzmlhljdxyyqytdlllbugbfdfbbqjzzmdpjhgclgmjjpgaehhbwcqxaxhhhz"
"chxyphjaxhlphjpgpzjqcqzgjjzzuzdmqyybzzphyhybwhazyjhykfgdpfqsdlzmljxkxgalxzdaglmdgxmwzqyxxdxxpfdmmssy"
"mpfmdmmkxksyzyshdzkxsysmmzzzmsydnzzczxfplstmzdnmxckjmztyymzmzzmsxhhdczjemxxkljstlwlsqlyjzllzjssdppmh"
"nlzjczyhmxxhgzcjmdhxtkgrmxfwmcgmwkdtksxqmmmfzzydkmsclcmpcgmhspxqpzdsslcxkyxtwlwjyahzjgzqmcsnxyymmpml"
"kjxmhlmlqmxctkzmjqyszjsyszhsyjzjcdajzybsdqjzgwzqqxfkdmsdjlfwehkzqkjpeypzyszcdwyjffmzzylttdzzefmzlbnp"
"plplpepszalltylkckqzkgenqlwagyxydpxlhsxqqwqcqxqclhyxxmlyccwlymqyskgchlcjnszkpyzkcqzqljpdmdzhlasxlbyd"
"wqlwdnbqcryddztjybkbwszdxdtnpjdtctqdfxqqmgnxeclttbkpwslctyqlpwyzzklpygzcqqpllkccylpqmzczqcljslqzdjxl"
"ddhpzqdljjxzqdxyzqkzljcyqdyjppypqykjyrmpcbymcxkllzllfqpylllmbsglcysslrsysqtmxyxzqzfdzuysyztffmzzsmzq"
"hzssccmlyxwtpzgxzjgzgsjsgkddhtqggzllbjdzlcbchyxyzhzfywxyzymsdbzzyjgtsmtfxqyxqstdgslnxdlryzzlryylxqht"
"xsrtzngzxbnqqzfmykmzjbzymkbpnlyzpblmcnqyzzzsjzhjctzkhyzzjrdyzhnpxglfztlkgjtctssyllgzrzbbqzzklpklczys"
"suyxbjfpnjzzxcdwxzyjxzzdjjkggrsrjkmsmzjlsjywqskyhqjsxpjzzzlsnshrnypztwchklpsrzlzxyjqxqkysjycztlqzybb"
"ybwzpqdwwyzcytjcjxckcwdkkzxsgkdzxwwyyjqyytcytdllxwkczkklcclzcqqdzlqlcsfqchqhsfsmqzzlnbjjzbsjhtszdysj"
"qjpdlzcdcwjkjzzlpycgmzwdjjbsjqzsyzyhhxjpbjydssxdzncglqmbtsfsbpdzdlznfgfjgfsmpxjqlmblgqcyyxbqkdjjqyrf"
"kztjdhczklbsdzcfjtplljgxhyxzcsszzxstjygkgckgyoqxjplzpbpgtgyjzghzqzzlbjlsqfzgkqqjzgyczbzqtldxrjxbsxxp"
"zxhyzyclwdxjjhxmfdzpfzhqhqmqgkslyhtycgfrzgnqxclpdlbzcsczqlljblhbzcypzzppdymzzsgyhckcpzjgsljlnscdsldl"
"xbmstlddfjmkdjdhzlzxlszqpqpgjllybdszgqlbzlslkyyhzttntjyqtzzpszqztlljtyyllqllqyzqlbdzlslyyzymdfszsnhl"
"xznczqzpbwskrfbsyzmthblgjpmczzlstlxshtcsyzlzblfeqhlxflcjlyljqcbzlzjhhsstbrmhxzhjzclxfnbgxgtqjcztmsfz"
"kjmssnxljkbhsjxntnlzdntlmsjxgzjyjczxyjyjwrwwqnztnfjszpzshzjfyrdjsfszjzbjfzqzzhzlxfysbzqlzsgyftzdcszx"
"zjbqmszkjrhyjzckmjkhchgtxkxqglxpxfxtrtylxjxhdtsjxhjzjxzwzlcqsbtxwxgxtxxhxftsdkfjhzyjfjxrzsdllltqsqqz"
"qwzxsyqtwgwbzcgzllyzbclmqqtzhzxzxljfrmyzflxysqxxjkxrmqdzdmmyybsqbhgzmwfwxgmxlzpyytgzyccdxyzxywgsyjyz"
"nbhpzjsqsyxsxrtfyzgrhztxszzthcbfclsyxzlzqmzlmplmxzjxsflbyzmyqhxjsxrxsqzzzsslyfrczjrcrxhhzxqydyhxsjjh"
"zcxzbtynsysxjbqlpxzqpymlxzkyxlxcjlcysxxzzlxdllljjyhzxgyjwkjrwyhcpsgnrzlfzwfzznsxgxflzsxzzzbfcsyjdbrj"
"krdhhgxjljjtgxjxxstjtjxlyxqfcsgswmsbctlqzzwlzzkxjmltmjyhsddbxgzhdlbmyjfrzfsgclyjbpmlysmsxlszjqqhjzfx"
"gfqfqbpxzgyyqxgztcqwyltlgwsgwhrlfsfgzjmgmgbgtjfsyzzgzyzaflsspmlpflcwbjzcljjmzlpjjlymqdmyyyfbgygyzmly"
"zdxqyxrqqqhsyyyqxyljtyxfsfsllgnqcyhycwfhcccfxpylypllzyxxxxxkqhhxshjzcfzsczjxcpzwhhhhhapylqalpqafyhxd"
"ylukmzqgggddesrnnzltzgchyppysqjjhclljtolnjpzljlhymheydydsqycddhgzundzclzyzllzntnyzgslhslpjjbdgwxpcdu"
"tjcklkclwkllcasstkzzdnqnttlyyzssysszzryljqkcqdhhcrxrzydgrgcwcgzqfffppjfzynakrgywyqpqxxfkjtszzxswzddf"
"bbxtbgtzkznpzzpzxzpjszbmqhkcyxyldkljnypkyghgdzjxxeahpnzkztzcmxcxmmjxnkszqnmnlwbwwxjkyhcpstmcsqtzjyxt"
"pctpdtnnpglllzsjlspblplqhdtnjnlyyrszffjfqwdphzdwmrzcclodaxnssnyzrestyjwjyjdbcfxnmwttbylwstszgybljpxg"
"lboclhpcbjltmxzljylzxcltpnclckxtpzjswcyxsfyszdkntlbyjcyjllstgqcbxryzxbxklylhzlqzlnzcxwjzljzjncjhxmnz"
"zgjzzxtzjxycyycxxjyyxjjxsssjstssttppgqtcsxwzdcsyfptfbfhfbblzjclzzdbxgcxlqpxkfzflsyltuwbmqjhszbmddbcy"
"sccldxycddqlyjjwmqllcsgljjsyfpyyccyltjantjjpwycmmgqyysxdxqmzhszxpftwwzqswqrfkjlzjqqyfbrxjhhfwjjzyqaz"
"myfrhcyybyqwlpexcczstyrlttdmqlykmbbgmyyjprkznpbsxyxbhyzdjdnghpmfsgmwfzmfqmmbcmzzcjjlcnuxyqlmlrygqzcy"
"xzlwjgcjcggmcjnfyzzjhycprrcmtzqzxhfqgtjxccjeaqcrjyhplqlszdjrbcqhqdyrhylyxjsymhzydwldfryhbpydtsscnwbx"
"glpzmlzztqsscpjmxxycsjytycghycjwyrxxlfemwjnmkllswtxhyyyncmmcwjdqdjzglljwjrkhpzggflccsczmcbltbhbqjxqd"
"spdjzzgkglfqywbzyzjltstdhqhctcbchflqmpwdshyytqwcnzzjtlbymbpdyyyxsqkxwyyflxxncwcxypmaelykkjmzzzbrxyyq"
"jfljpfhhhytzzxsgqqmhspgdzqwbwpjhzjdyscqwzktxxsqlzyymysdzgrxckkujlwpysyscsyzlrmlqsyljxbcxtlwdqzpcycyk"
"pppnsxfyzjjrcemhszmsxlxglrwgcstlrsxbzgbzgztcplujlslylymtxmtzpalzxpxjtjwtcyyzlblxbzlqmylxpghdslssdmxm"
"bdzzsxwhamlczcpjmcnhjysnsygchskqmzzqdllkablwjxsfmocdxjrrlyqzkjmybyqlyhetfjzfrfksryxfjtwdsxxsysqjysly"
"xwjhsnlxyyxhbhawhhjzxwmyljcsslkydztxbzsyfdxgxzjkhsxxybssxdpynzwrptqzczenygcxqfjykjbzmljcmqqxuoxslyxx"
"lylljdzbtymhpfsttqqwlhokyblzzalzxqlhzwrrqhlstmypyxjjxmqsjfnbxyxyjxxyqylthylqyfmlkljtmllhszwkzhljmlhl"
"jkljstlqxylmbhhlnlzxqjhxcfxxlhyhjjgbyzzkbxscqdjqdsujzyyhzhhmgsxcsymxfebcqwwrbpyyjqtyzcyqyqqzyhmwffhg"
"zfrjfcdpxntqyzpdykhjlfrzxppxzdbbgzqstlgdgylcqmlchhmfywlzyxkjlypqhsywmqqgqzmlzjnsqxjqsyjycbehsxfszpxz"
"wfllbcyyjdytdthwzsfjmqqyjlmqxxlldttkhhybfpwtyysqqwnqwlgwdebzwcmygculkjxtmxmyjsxhybrwfymwfrxyqmxysztz"
"ztfykmldhqdxwyynlcryjblpsxcxywlsprrjwxhqyphtydnxhhmmywytzcsqmtssccdalwztcpqpyjllqzyjswxmzzmmylmxclmx"
"czmxmzsqtzppqqblpgxqzhfljjhytjsrxwzxsccdlxtyjdcqjxslqyclzxlzzxmxqrjmhrhzjbhmfljlmlclqnldxzlllpypsyjy"
"sxcqqdcmqjzzxhnpnxzmekmxhykyqlxsxtxjyyhwdcwdzhqyybgybcyscfgpsjnzdyzzjzxrzrqjjymcanyrjtldppyzbstjkxxz"
"ypfdwfgzzrpymtngxzqbyxnbufnqkrjqzmjegrzgyclkxzdskknsxkcljspjyyzlqqjybzssqlllkjxtbktylccddblsppfylgyd"
"tzjyqggkqttfzxbdktyyhybbfytyybclpdytgdhryrnjsptcsnyjqhklllzslydxxwbcjqspxbpjzjcjdzffxxbrmlazhcsndlbj"
"dszblprztswsbxbcllxxlzdjzsjpylyxxyftfffbhjjxgbyxjpmmmpssjzjmtlyzjxswxtyledqpjmygqzjgdjlqjwjqllsjgjgy"
"gmscljjxdtygjqjqjcjzcjgdzzsxqgsjggcxhqxsnqlzzbxhsgzxcxyljxyxyydfqqjhjfxdhctxjyrxysqtjxyefyyssyyjxncy"
"zxfxmsyszxyyschshxzzzgzzzgfjdltylnpzgyjyzyyqzpbxqbdztzczyxxyhhsqxshdhgqhjhgywsztmzmlhyxgebtylzkqwytj"
"zrclekystdbcykqqsayxcjxwwgsbhjyzydhcsjkqcxswxfltynyzpzcczjqtzwjqdzzzqzljjxlsbhpyxxpsxshheztxfptlqyzz"
"xhytxncfzyyhxgnxmywxtzsjpthhgymxmxqzxtsbczyjyxxtyyzypcqlmmszmjzzllzxgxzaajzyxjmzxwdxzsxzdzxleyjjzqbh"
"zwzzzqtzpsxztdsxjjjznyazphxyysrnqdthzhyykyjhdzxzlswclybzyecwcycrylcxnhzydzydyjdfrjjhtrsqtxyxjrjhojyn"
"xelxsfsfjzghpzsxzszdzcqzbyyklsgsjhczshdgqgxyzgxchxzjwyqwgyhksseqzzndzfkwysstclzstsymcdhjxxyweyxczayd"
"mpxmdsxybsqmjmzjmtzqlpjyqzcgqhxjhhlxxhlhdldjqcldwbsxfzzyyschtytyybhecxhykgjpxhhyzjfxhwhbdzfyzbcapnpg"
"nydmsxhmmmmamynbyjtmpxyymcthjbzyfcgtyhwphftwzzezsbzegpfmtskftycmhfllhgpzjxzjgzjyxzsbbqsczzlzccstpgxm"
"jsftcczjzdjxcybzlfcjsyzfgszlybcwzzbyzdzypswyjzxzbdsyuxlzzbzfygczxbzhzftpbgzgejbstgkdmfhyzzjhzllzzgjq"
"zlsfdjsscbzgpdlfzfzszyzyzsygcxsnxxchczxtzzljfzgqsqyxzjqdccztqcdxzjyqjqchxztdlgscxzsyqjqtzwlqdqztqchq"
"qjzyezzzpbwkdjfcjpztypqyqttynlmbdktjzpqzqzzfpzsbnjlgyjdxjdzzkzgqkxdlpzjtcjdqbxdjqjstcknxbxzmslyjcqmt"
"jqwwcjqnjnlllhjcwqtbzqydzczpzzdzyddcyzzzccjttjfzdprrtztjdcqtqzdtjnplzbcllctzsxkjzqzpzlbzrbtjdcxfczdb"
"ccjjltqqpldcgzdbbzjcqdcjwynllzyzccdwllxwzlxrxntqqczxkqlsgdfqtddglrlajjtkuymkqlltzytdyyczgjwyxdxfrsks"
"tqtenqmrkqzhhqkdldazfkypbggpzrebzzykzzspegjxgykqzzzslysyyyzwfqzylzzlzhwchkypqgnpgblplrrjyxccsyyhsfzf"
"ybzyytgzxylxczwxxzjzblfflgskhyjzeyjhlpllllczgxdrzelrhgklzzyhzlyqszzjzqljzflnbhgwlczcfjyspyxzlzlxgccp"
"zbllcybbbbubbcbpcrnnzczyrbfsrldcgqyyqxygmqzwtzytyjxyfwtehzzjywlccntzyjjzdedpzdztsyqjhdymbjnyjzlxtsst"
"phndjxxbyxqtzqddtjtdyytgwscszqflshlglbczphdlyzjyckwtytylbnytsdsycctyszyyebhexhqdtwnygyclxtszystqmygz"
"azccszzdslzclzrqxyyeljsbymxsxztembbllyyllytdqyshymrqwkfkbfxnxsbychxbwjyhtqbpbsbwdzylkgzskyhxqzjxhxjx"
"gnljkzlyycdxlfyfghljgjybxqlybxqpqgztzplncypxdjyqydymrbesjyyhkxxstmxrczzywxyqybmcllyzhqyzwqxdbxbzwzms"
"lpdmyskfmzklzcyqyczlqxfzzydqzpzygyjyzmzxdzfyfyttqtzhgspczmlccytzxjcytjmkslpzhysnzllytpzctzzcktxdhxxt"
"qcyfksmqccyyazhtjpcylzlyjbjxtpnyljyynrxsylmmnxjsmybcsysylzylxjjqyldzlpqbfzzblfndxqkczfywhgqmrdsxycyt"
"xnqqjzyypfzxdyzfprxejdgyqbxrcnfyyqpghyjdyzxgrhtkylnwdzntsmpklbthbpyszbztjzszzjtyyxzphsszzbzczptqfzmy"
"flypybbjqxzmxxdjmtsyskkbjzxhjcklpsmkyjzcxtmljyxrzzqslxxqpyzxmkyxxxjcljprmyygadyskqlsndhyzkqxzyztcghz"
"tlmlwzybwsyctbhjhjfcwztxwytkzlxqshlyjzjxtmplpycgltbzztlzjcyjgdtclklpllqpjmzpapxyzlkktkdzczzbnzdydyqz"
"jyjgmctxltgxszlmlhbglkfwnwzhdxuhlfmkyslgxdtwwfrjejztzhydxykshwfzcqshktmqqhtzhymjdjskhxzjzbzzxympagqm"
"stpxlsklzynwrtsqlszbpspsgzwyhtlkssswhzzlyytnxjgmjszsufwnlsoztxgxlsammlbwldszylakqcqctmycfjbslxclzzcl"
"xxksbzqclhjpsqplsxxckslnhpsfqqytxyjzlqldxzqjzdyydjnzptuzdskjfsljhylzsqzlbtxydgtqfdbyazxdzhzjnhhqbykn"
"xjjqczmlljzkspldyclbblxklelxjlbqycxjxgcnlcqplzlzyjtzljgyzdzpltqcsxfdmnycxgbtjdcznbgbqyqjwgkfhtnpyqzq"
"gbkpbbyzmtjdytblsqmpsxtbnpdxklemyycjynzctldykzzxddxhqshdgmzsjycctayrzlpyltlkxslzcggexclfxlkjrtlqjaqz"
"ncmbydkkcxglczjzxjhptdjjmzqykqsecqzdshhadmlzfmmzbgntjnnlgbyjbrbtmlbyjdzxlcjlpldlpcqdhlxzlycblcxzzjad"
"jlnzmmsssmybhbsqkbhrsxxjmxsdznzpxlgbrhwggfcxgmsklltsjyycqltskywyyhywxbxqywpywykqlsqptntkhqcwdqktwpxx"
"hcpthtwumssyhbwcrwxhjmkmzngwtmlkfghkjylsyycxwhyeclqhkqhttqkhfzldxqwyzyydesbpkyrzpjfyyzjceqdzzdlatzbb"
"fjllcxdlmjssxegygsjqxcwbxsszpdyzcxdnyxppzydlyjczpltxlsxyzyrxcyyydylwwnzsahjsyqyhgywwaxtjzdaxysrltdps"
"syyfnejdxyzhlxlllzqzsjnyqyqqxyjghzgzcyjchzlycdshwshjzyjxcllnxzjjyyxnfxmwfpylcyllabwddhwdxjmcxztzpmlq"
"zhsfhzynztlldywlslxhymmylmbwwkyxyadtxylldjpybpwuxjmwmllsafdllyflbhhhbqqltzjcqjldjtffkmmmbythygdcqrdd"
"wrqjxnbysnwzdbyytbjhpybyttjxaahgqdqtmystqxkbtzpkjlzrbeqqssmjjbdjotgtbxpgbktlhqxjjjcthxqdwjlwrfwqgwsh"
"ckryswgftgygbxsdwdwrfhwytjjxxxjyzyslpyyypayxhydqkxshxyxgskqhywfdddpplcjlqqeewxksyykdypltjthkjltcyyhh"
"jttpltzzcdlthqkzxqysteeywyyzyxxyysttjkllpzmcyhqgxyhsrmbxpllnqydqhxsxxwgdqbshyllpjjjthyjkyppthyyktyez"
"yenmdshlcrpqfdgfxzpsftljxxjbswyysksflxlpplbbblbsfxfyzbsjssylpbbffffsscjdstzsxzryysyffsyzyzbjtbctsbsd"
"hrtjjbytcxyjeylxcbnebjdsyxykgsjzbxbytfzwgenyhhthzhhxfwgcstbgxklsxywmtmbyxjstzscdyqrcytwxzfhmymcxlzns"
"djtttxrycfyjsbsdyerxjljxbbdeynjghxgckgscymblxjmsznskgxfbnbpthfjaafxyxfpxmypqdtzcxzzpxrsywzdlybbktyqp"
"qjpzypzjznjpzjlzzfysbttslmptzrtdxqsjehbzylzdhljsqmlhtxtjecxslzzspktlzkqqyfsygywpcpqfhqhytqxzkrsgttsq"
"czlptxcdyyzxsqzslxlzmycpcqbzyxhbsxlzdltcdxtylzjyyzpzyzltxjsjxhlpmytxcqrblzssfjzztnjytxmyjhlhpplcyxqj"
"qqkzzscpzkswalqsblcczjsxgwwwygyktjbbztdkhxhkgtgpbkqyslpxpjckbmllxdzstbklggqkqlsbkktfxrmdkbftpzfrtbbr"
"ferqgxyjpzsstlbztpszqzsjdhljqlzbpmsmmsxlqqnhknblrddnxxdhddjcyygylxgzlxsygmqqgkhbpmxyxlytqwlwgcpbmqxc"
"yzydrjbhtdjyhqshtmjsbyplwhlzffnypmhxxhpltbqpfbjwqdbygpnztpfzjgsddtqshzeawzzylltyybwjkxxghlfkxdjtmszs"
"qynzggswqsphtlsskmclzxyszqzxncjdqgzdlfnykljcjllzlmzznhydsshthzzlzzbbhqzwwycrzhlyqqjbeyfxxxwhsrxwqhwp"
"slmsskzttygyqqwrslalhmjtqjsmxqbjjzjxzyzkxbyqxbjxshztsfjlxmxzxfghkzszggylclsarjyhslllmzxelglxydjytlfb"
"hbpnlyzfbbhptgjkwetzhkjjxzxxglljlstgshjjyqlqzfkcgnndjsszfdbctwwseqfhqjbsaqtgypqlbxbmmywxgslzhglzgqyf"
"lzbyfzjfrysfmbyzhqgfwzsyfyjjphzbyyzffwodgrlmftwlbzgycqxcdjygzyyyytytydwegazyhxjlzyyhlrmgrxxzclhneljj"
"tjtpwjybjjbxjjtjteekhwsljplpsfyzpqqbdlqjjtyyqlyzkdksqjyyqzldqtgjqyzjsucmryqthtejmfctyhypkmhyzwjdqfhy"
"yxwshctxrljhqxhccyyyjltkttytmxgtcjtzayyoczlylbszywjytsjyhbyshfjlygjxxtmzyyltxxypzlxyjzyzyypnhmymdyyl"
"blhlsyyqqllnjjymsoyqbzgdlyxylcqyxtszegxhzglhwbljheyxtwqmakbpqcgyshhegqcmwyywljyjhyyzlljjylhzyhmgsljl"
"jxcjjyclycjpcpzjzjmmylcqlnqljqjsxyjmlszljqlycmmhcfmmfpqqmfylqmcffqmmmmhmznfhhjgtthhkhslnchhyqdxtmmqd"
"cyzyxyqmyqyltdcyyyzazzcymzydlzfffmmycqzwzzmabtbyztdmnzzggdftypcgqyttssffwfdtzqssystwxjhxytsxxylbyqhw"
"wkxhzxwznnzzjzjjqjccchyyxbzxzcyztllcqxynjycyycynzzqyyyewyczdcjycchyjlbtzyycqwmpwpymlgkdldlgkqqbgychj"
"xy";
