import { ragChat } from "@/lib/rag-chat";
import { aiUseChatAdapter } from "@upstash/rag-chat/nextjs";
import { NextRequest } from "next/server";

export const POST = async (req: NextRequest) => {
  try {
    const { messages, sessionId } = await req.json();

    const lastMessage = messages[messages.length - 1].content;

    const response = await ragChat.chat(lastMessage, {
      streaming: true,
      sessionId,
    });

    console.log(
      "====================================================================================================================================================================="
    );
    return aiUseChatAdapter(response);
  } catch (err) {
    console.log(err);
    console.log(
      "====================================================================================================================================================================="
    );
  }
};
