### Conclusions (1/4)
- How do LPWAN complement traditional cellular and short-range wireless technologies?
    - LPWAN devices function for many years on a single battery charge
    - LPWAN devices communicate from locations where shadowing and path loss would limit the usefulness of more traditional cellular technologies
- What are the fundamental mechanisms that enable to meet the LPWAN requirements?
    - Short messages, low complexity codes and modulations
    - Low receiver sensitivity
    - Optimized reachability and low signaling
    - Multiple transmissions on the same channel
    - Simplified architecture

### Conclusions (2/4)
- What are the major design choices made in the LoRaWAN specification?

|                   |        LoRaWAN        |
|-------------------|:---------------------:|
| Reliability       |     CSS-based LoRa    |
| Power consumption | Short receive windows |
| Capacity          |      Multiple SFs     |
| Deployment        |  Simple architecture  |

### Conclusions (3/4)
- How do we evaluate the performance of a LoRaWAN deployment in terms of coverage and capacity?
    - Combination of simulation, mathematical modeling and measurement campaigns
    - Performance evaluations should take into account collisions and duty cycle in LoRaWAN

#### Global performance
- LoRaWAN shows coverage limitations especially in indoor dense urban environments
- Collisions hinder the performance of LoRaWAN in heavy loaded networks

### Conclusions (4/4)
- What are the recent research directions for radio resource management in LoRaWAN?
    - Adaptation of the radio propagation models
    - Interference mitigation
    - Support for quality of service such as delay bounded transmission
    - Maximization of the energy efficiency
    - Providing IPv6 connectivity to the device (IETF lpwan working group)

### Feedback and Tutorial Material
- We made the tutorial sources available under Creative Common license CC BY-NC-SA 4.0
\begin{center}
\color{blue}
https://github.com/samerlahoud/tutorial-lpwan-iot
\end{center}
- This is a human-readable summary of the license: https://creativecommons.org/licenses/by-nc-sa/4.0/
