# Low Power Wide Area Networks for the Internet of Things
## Framework, Optimization, and Challenges of LoRaWAN and NB-IoT

### Licence
The authors made the tutorial sources available under Creative Common license CC BY-NC-SA 4.0. This is a human-readable summary of the license: https://creativecommons.org/licenses/by-nc-sa/4.0/

### Funding
This project has been jointly funded with the support of the National Council for Scientific Research in Lebanon CNRS-L and Saint Joseph University of Beirut.

### Abstract
Low-Power Wide Area Networks (LPWAN) have recently gained considerable attention in the Internet of Things (IoT). The key objective of these wireless technologies is to connect low-power devices over very large areas, with low data rates. LPWANs are promising for various emerging IoT applications, complementing the traditional cellular and short-range technologies.

In this tutorial, we present the recent advances of LPWAN technologies with focus on LoRaWAN and NB-IoT. We analyze the link level and system level design aspects. We further focus on link budget analysis and radio network dimensioning for both LoRaWAN and NB-IoT. Precisely, we present best practices in the network design and deployment of these technologies. Acquiring such best practices is of paramount importance for the engineering and optimization of LPWANs. We also provide a comparative scientific analysis of the performance of LoRaWAN and NB-IoT in terms of coverage and capacity.

Finally, we cover the research directions and scientific challenges in these technologies. Particularly, we present research directions for radio resource management in both LoRaWAN and NB-IoT.

### Biographies:
[Samer Lahoud](http://samer.lahoud.fr) is an Associate Professor at the Saint-Joseph University of Beirut where he lectures computer networking courses at the Faculty of engineering (ESIB). His research activities focus on routing and resource allocation algorithms for wired and wireless communication networks. He has co-authored more than 80 papers published in international journals and conference proceedings. Mr. Lahoud received the Ph.D. degree in communication networks from Telecom Bretagne, Rennes, in 2006. After his Ph.D. degree, he spent one year at Alcatel-Lucent Bell Labs Europe. From 2007 to 2016, he was with the University of Rennes 1 and with IRISA Rennes as an Associate Professor.

[Melhem El Helou](https://cimti.usj.edu.lb/doku.php?id=members:melhem_el_helou) received the engineer’s degree and master’s degree in telecommunications and networking engineering from the Ecole Supérieure d’Ingénieurs de Beyrouth (ESIB), Faculty of Engineering at the Saint Joseph University of Beirut, Beirut, Lebanon, in 2009 and 2010, respectively and the Ph.D. degree in computer and telecommunications engineering from IRISA Research Institute, University of Rennes 1, Rennes, France and Saint Joseph University of Beirut, in 2014. He joined ESIB in September 2013 where he is currently an Assistant Professor (fr: Maître de conférences). His research interests include wireless networks, radio and energy resource management, Internet of Things, and quality of service.
