# My solutions to [CS385](https://www.cs.uic.edu/bin/view/CS385/Homeworks) OS development course at UIC. <br>
This is a mirror repo based on [xv6.git](http://bits.cs.uic.edu/git/xv6.git)
<br>
Hacking on the [xv6](https://en.wikipedia.org/wiki/Xv6) operating system

### PROGRESS

- [x] Simple program (divide) running in xv6. [Branch 1](https://github.com/sam46/xv6/tree/hw1)
- [x] Custom bootsector with custom splash screen. [Branch 2](https://github.com/sam46/xv6/tree/hw2)
- [x] Device drivers for console and display. [Branch 3](https://github.com/sam46/xv6/tree/hw3)
- [x] mmap: eager and lazy. [Branch 4](https://github.com/sam46/xv6/tree/hw4)
- [ ] Page table magic: deduplication and copy-on-write. [Branch 5](https://github.com/sam46/xv6/tree/hw5)
- [ ] Adding threading support to xv6. [Branch 6](https://github.com/sam46/xv6/tree/hw6)
- [ ] Implementing signals in xv6. [Branch 7](https://github.com/sam46/xv6/tree/hw7)

<br>
xv6 is a re-implementation of Dennis Ritchie's and Ken Thompson's Unix
Version 6 (v6).  xv6 loosely follows the structure and style of v6,
but is implemented for a modern x86-based multiprocessor using ANSI C.
<br>
ACKNOWLEDGMENTS

xv6 is inspired by John Lions's Commentary on UNIX 6th Edition (Peer
to Peer Communications; ISBN: 1-57398-013-7; 1st edition (June 14,
2000)). See also http://pdos.csail.mit.edu/6.828/2012/v6.html, which
provides pointers to on-line resources for v6.

xv6 borrows code from the following sources:
    JOS (asm.h, elf.h, mmu.h, bootasm.S, ide.c, console.c, and others)
    Plan 9 (entryother.S, mp.h, mp.c, lapic.c)
    FreeBSD (ioapic.c)
    NetBSD (console.c)

The following people have made contributions:
    Russ Cox (context switching, locking)
    Cliff Frey (MP)
    Xiao Yu (MP)
    Nickolai Zeldovich
    Austin Clements

In addition, we are grateful for the bug reports and patches contributed by
Silas Boyd-Wickizer, Peter Froehlich, Shivam Handa, Anders Kaseorg, Eddie
Kohler, Yandong Mao, Hitoshi Mitake, Carmi Merimovich, Joel Nider, Greg Price,
Eldar Sehayek, Yongming Shen, Stephen Tu, and Zouchangwei.

The code in the files that constitute xv6 is
Copyright 2006-2014 Frans Kaashoek, Robert Morris, and Russ Cox.

ERROR REPORTS

If you spot errors or have suggestions for improvement, please send
email to Frans Kaashoek and Robert Morris (kaashoek,rtm@csail.mit.edu). 

BUILDING AND RUNNING XV6

To build xv6 on an x86 ELF machine (like Linux or FreeBSD), run "make".
On non-x86 or non-ELF machines (like OS X, even on x86), you will
need to install a cross-compiler gcc suite capable of producing x86 ELF
binaries.  See http://pdos.csail.mit.edu/6.828/2014/tools.html.
Then run "make TOOLPREFIX=i386-jos-elf-".

To run xv6, install the QEMU PC simulators.  To run in QEMU, run "make qemu".

To create a typeset version of the code, run "make xv6.pdf".  This
requires the "mpage" utility.  See http://www.mesa.nl/pub/mpage/.
