unit uCEFCompletionCallback;

{$IFDEF FPC}
  {$MODE OBJFPC}{$H+}
{$ENDIF}

{$I cef.inc}

{$IFNDEF TARGET_64BITS}{$ALIGN ON}{$ENDIF}
{$MINENUMSIZE 4}

interface

uses
  uCEFBaseRefCounted, uCEFInterfaces, uCEFWaitableEvent;

type
  TCefCompletionCallbackOwn = class(TCefBaseRefCountedOwn, ICefCompletionCallback)
    protected
      procedure OnComplete; virtual;

    public
      constructor Create; virtual;
  end;

  TCefFastCompletionCallback = class(TCefCompletionCallbackOwn)
    protected
      FProc: TCefCompletionCallbackProc;

      procedure OnComplete; override;

    public
      constructor Create(const proc: TCefCompletionCallbackProc); reintroduce;
  end;

  TCefEventCompletionCallback = class(TCefCompletionCallbackOwn)
    protected
      FEvent : ICefWaitableEvent;

      procedure OnComplete; override;

    public
      constructor Create(const event : ICefWaitableEvent); reintroduce;
      destructor  Destroy; override;
  end;

  TCefCustomCompletionCallback = class(TCefCompletionCallbackOwn)
    protected
      FEvents : Pointer;

    public
      constructor Create(const aEvents : IChromiumEvents); reintroduce;
      destructor  Destroy; override;
  end;

implementation

uses
  uCEFMiscFunctions, uCEFLibFunctions, uCEFTypes;

procedure cef_completion_callback_on_complete(self: PCefCompletionCallback); stdcall;
var
  TempObject : TObject;
begin
  TempObject := CefGetObject(self);

  if (TempObject <> nil) and (TempObject is TCefCompletionCallbackOwn) then
    TCefCompletionCallbackOwn(TempObject).OnComplete;
end;

// TCefCompletionHandlerOwn

constructor TCefCompletionCallbackOwn.Create;
begin
  inherited CreateData(SizeOf(TCefCompletionCallback));

  PCefCompletionCallback(FData)^.on_complete := {$IFDEF FPC}@{$ENDIF}cef_completion_callback_on_complete;
end;

procedure TCefCompletionCallbackOwn.OnComplete;
begin
  //
end;

// TCefFastCompletionHandler

constructor TCefFastCompletionCallback.Create(const proc: TCefCompletionCallbackProc);
begin
  inherited Create;

  FProc := proc;
end;

procedure TCefFastCompletionCallback.OnComplete;
begin
  FProc();
end;


// TCefEventCompletionCallback


constructor TCefEventCompletionCallback.Create(const event : ICefWaitableEvent);
begin
  inherited Create;

  FEvent := event;
end;

destructor TCefEventCompletionCallback.Destroy;
begin
  FEvent := nil;

  inherited Destroy;
end;

procedure TCefEventCompletionCallback.OnComplete;
begin
  if (FEvent <> nil) then FEvent.Signal;
end;


// TCefCustomCompletionCallback

constructor TCefCustomCompletionCallback.Create(const aEvents : IChromiumEvents);
begin
  inherited Create;

  FEvents := Pointer(aEvents);
end;

destructor TCefCustomCompletionCallback.Destroy;
begin
  FEvents := nil;

  inherited Destroy;
end;

end.
