// ************************************************************************
// ***************************** CEF4Delphi *******************************
// ************************************************************************
//
// CEF4Delphi is based on DCEF3 which uses CEF to embed a chromium-based
// browser in Delphi applications.
//
// The original license of DCEF3 still applies to CEF4Delphi.
//
// For more information about CEF4Delphi visit :
//         https://www.briskbard.com/index.php?lang=en&pageid=cef
//
//        Copyright  2023 Salvador Diaz Fau. All rights reserved.
//
// ************************************************************************
// ************ vvvv Original license and comments below vvvv *************
// ************************************************************************
(*
 *                       Delphi Chromium Embedded 3
 *
 * Usage allowed under the restrictions of the Lesser GNU General Public License
 * or alternatively the restrictions of the Mozilla Public License 1.1
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 *
 * Unit owner : Henri Gourvest <hgourvest@gmail.com>
 * Web site   : http://www.progdigy.com
 * Repository : http://code.google.com/p/delphichromiumembedded/
 * Group      : http://groups.google.com/group/delphichromiumembedded
 *
 * Embarcadero Technologies, Inc is not permitted to use or redistribute
 * this source code without explicit permission.
 *
 *)

unit CEF4DelphiVCLFMX_Register;

{$R res\chromium.dcr}

{$I ..\source\cef.inc}

// Disable this DEFINE if your Delphi installation can't find ToolsAPI.pas or designide.dcp
{$DEFINE ADDSPLASHSCREENLOGO}

interface

procedure Register;

implementation

uses
  System.Classes, Winapi.Windows, System.SysUtils, {$IFDEF ADDSPLASHSCREENLOGO}ToolsApi,{$ENDIF}
  uCEFChromium, uCEFWindowParent, uCEFChromiumWindow, uCEFBufferPanel,
  uCEFWorkScheduler, uCEFFMXBufferPanel, uCEFFMXChromium, uCEFFMXWorkScheduler,
  uCEFServerComponent, uCEFLinkedWindowParent, uCEFUrlRequestClientComponent,
  uCEFSentinel, uCEFBrowserViewComponent, uCEFLabelButtonComponent,
  uCEFMenuButtonComponent, uCEFPanelComponent, uCEFTextfieldComponent,
  uCEFScrollViewComponent, uCEFWindowComponent;

{$IFDEF ADDSPLASHSCREENLOGO}
procedure AddBitmapToSplashScreen;
const
  {$I ..\source\uCEFVersion.inc}
var
  TempBitmap : HBITMAP;
  TempVersion : string;
begin
  if assigned(SplashScreenServices) then
    begin
      TempBitmap := LoadBitmap(FindResourceHInstance(HInstance), 'TChromium');
      try
        TempVersion := IntToStr(CEF_SUPPORTED_VERSION_MAJOR) + '.' +
                       IntToStr(CEF_SUPPORTED_VERSION_MINOR) + '.' +
                       IntToStr(CEF_SUPPORTED_VERSION_RELEASE) + '.' +
                       IntToStr(CEF_SUPPORTED_VERSION_BUILD);

        SplashScreenServices.AddPluginBitmap('CEF4Delphi ' + TempVersion, TempBitmap, False, 'MPL 1.1 license');
      finally
        DeleteObject(TempBitmap);
      end;
    end;
end;
{$ENDIF}

procedure Register;
begin
  RegisterComponents('Chromium',
                     [TChromium, TCEFWindowParent, TChromiumWindow,
                      TBufferPanel, TFMXBufferPanel, TFMXChromium,
                      TFMXWorkScheduler, TCEFWorkScheduler,
                      TCEFServerComponent, TCEFLinkedWindowParent,
                      TCEFUrlRequestClientComponent,
                      TCEFSentinel]);

  RegisterComponents('Chromium Views Framework',
                     [TCEFBrowserViewComponent, TCEFLabelButtonComponent,
                      TCEFMenuButtonComponent, TCEFPanelComponent,
                      TCEFTextfieldComponent, TCEFScrollViewComponent,
                      TCEFWindowComponent]);

  {$IFDEF ADDSPLASHSCREENLOGO}
  AddBitmapToSplashScreen;
  {$ENDIF}
end;

end.
