# CEF4Delphi [![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)](https://twitter.com/intent/tweet?text=Use%20CEF4Delphi%20to%20embed%20Chromium-based%20browsers%20in%20your%20application&url=https://github.com/salvadordf/CEF4Delphi&via=briskbard&hashtags=cef4delphi,delphi,lazarus,fpc)
CEF4Delphi is an open source project created by Salvador Díaz Fau to embed Chromium-based browsers in applications made with [Delphi](https://www.embarcadero.com/products/delphi/starter) or [Lazarus/FPC](https://www.lazarus-ide.org/) for Windows, Linux and MacOS.

CEF4Delphi is based on DCEF3 and fpCEF3. The original license of those projects still applies to CEF4Delphi. Read the license terms in the LICENSE.md file.

CEF4Delphi uses CEF 131.3.5 which includes Chromium 131.0.6778.205. 

The CEF binaries used by CEF4Delphi are available for download at Spotify :
* [Windows   32 bits](https://cef-builds.spotifycdn.com/cef_binary_131.3.5%2Bg573cec5%2Bchromium-131.0.6778.205_windows32.tar.bz2)
* [Windows   64 bits](https://cef-builds.spotifycdn.com/cef_binary_131.3.5%2Bg573cec5%2Bchromium-131.0.6778.205_windows64.tar.bz2)
* [Linux x86 64 bits](https://cef-builds.spotifycdn.com/cef_binary_131.3.5%2Bg573cec5%2Bchromium-131.0.6778.205_linux64.tar.bz2)
* [Linux ARM 32 bits](https://cef-builds.spotifycdn.com/cef_binary_131.3.5%2Bg573cec5%2Bchromium-131.0.6778.205_linuxarm.tar.bz2)
* [Linux ARM 64 bits](https://cef-builds.spotifycdn.com/cef_binary_131.3.5%2Bg573cec5%2Bchromium-131.0.6778.205_linuxarm64.tar.bz2)
* [MacOS x86 64 bits](https://cef-builds.spotifycdn.com/cef_binary_131.3.5%2Bg573cec5%2Bchromium-131.0.6778.205_macosx64.tar.bz2)

CEF4Delphi was developed and tested on Delphi 12.2 and it has been tested in Delphi 6, Delphi XE, Delphi 10, Delphi 11 and Lazarus 3.6/FPC 3.2.2. CEF4Delphi includes VCL, FireMonkey (FMX) and Lazarus components.

CEF4Delphi demos have been tested in Windows 10, Windows 11, Linux Mint 22 and Raspberry Pi OS.

## Links
* [Installation instructions and more information about CEF4Delphi](https://www.briskbard.com/index.php?lang=en&pageid=cef)
* [Developer Forums](https://www.briskbard.com/forum)
* The Windows components need Windows 10, 11 or newer to run. If you need Windows XP and Vista support use [OldCEF4Delphi](https://github.com/salvadordf/OldCEF4Delphi). If you need Windows 7, 8/8.1 support use [this CEF4Delphi release](https://github.com/salvadordf/CEF4Delphi/releases/tag/109.0.5414.120).

## Stable releases 
This is the development branch and it may have issues. Use the [latest release](https://github.com/salvadordf/CEF4Delphi/releases/latest) if you need a stable component.

## Support
If you find this project useful, please consider making a donation.

[![paypal](https://www.paypalobjects.com/en_US/i/btn/btn_donateCC_LG.gif)](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=FTSD2CCGXTD86)

You can also support this project with Patreon.

<a href="https://patreon.com/salvadordf"><img src="https://c5.patreon.com/external/logo/become_a_patron_button.png" alt="Patreon donate button" /></a>

You can also support this project with Liberapay.

<a href="https://liberapay.com/salvadordf/donate"><img alt="Donate using Liberapay" src="https://liberapay.com/assets/widgets/donate.svg"></a>

Additional:
Delphinus-Support

## Related projects
* [WebView4Delphi](https://github.com/salvadordf/WebView4Delphi)
* [WebUI4Delphi](https://github.com/salvadordf/WebUI4Delphi)
* [WebUI4CSharp](https://github.com/salvadordf/WebUI4CSharp)
* [DCEF3](https://github.com/hgourvest/dcef3) 
* [fpCEF3](https://github.com/dliw/fpCEF3)
* [CEF](https://bitbucket.org/chromiumembedded/cef/)
* [DCPcrypt](https://sourceforge.net/projects/lazarus-ccr/files/DCPcrypt/)
* [PasDoc](https://pasdoc.github.io/)
* [Chromium](https://chromium.googlesource.com/chromium/src/)
* [CefSharp](https://github.com/cefsharp/CefSharp)
* [CefGlue](https://gitlab.com/xiliumhq/chromiumembedded/cefglue)
* [Cef2Go](https://github.com/cztomczak/cef2go)
* [Energy](https://github.com/energye/energy)
* [java-cef](https://bitbucket.org/chromiumembedded/java-cef)
* [cefpython](https://github.com/cztomczak/cefpython)

## Other resources
* [Learn Delphi](https://learndelphi.org/)
* [Essential Pascal by Marco Cantù](https://www.marcocantu.com/epascal/)
* [Free Pascal Reference guide](https://www.freepascal.org/docs-html/ref/ref.html)
* [Modern Object Pascal Introduction for Programmers](https://castle-engine.io/modern_pascal)
* [FreePascal from Square One by Jeff Duntemann](http://www.copperwood.com/pub/FreePascalFromSquareOne.pdf)
* [Pascal and Lazarus Books and Magazines](https://wiki.freepascal.org/Pascal_and_Lazarus_Books_and_Magazines)
* [Lazarus Documentation](https://wiki.freepascal.org/Lazarus_Documentation)
* [Delphi Succinctly](https://www.syncfusion.com/succinctly-free-ebooks/delphi)
* [Start Programming using Object Pascal](https://code.sd/startprog/StartProgUsingPascal.pdf)

## Attribution
* [Fugue & Diagona icons](http://yusukekamiyamane.com/)
* [FatCow Farm-Fresh Web Icons](https://github.com/gammasoft/fatcow)
* [Material Design Icons](https://github.com/google/material-design-icons) 
