/*
 * Copyright (c) 2019, salesforce.com, inc.
 * All rights reserved.
 * SPDX-License-Identifier: MIT
 * For full license text, see the LICENSE file in the repo root or https://opensource.org/licenses/MIT
 */

export const picklistRepresentation = {
    Bad_Guy__c: {
        '012000000000000AAA': {
            MultiCity__c: {
                controllerValues: {
                    'United States': 0,
                    Canada: 1,
                    'United Kingdom': 2
                },

                defaultValue: null,
                url:
                    '/services/data/v41.0/ui-api/object-info/Bad_Guy__c/picklist-values/012000000000000AAA/MultiCity__c',
                values: [
                    {
                        attributes: null,
                        label: 'Montreal',
                        validFor: [1],
                        value: 'Montreal'
                    },

                    {
                        attributes: null,
                        label: 'Vancouver',
                        validFor: [1],
                        value: 'Vancouver'
                    },

                    {
                        attributes: null,
                        label: 'Toronto',
                        validFor: [1],
                        value: 'Toronto'
                    },

                    {
                        attributes: null,
                        label: 'Manchester',
                        validFor: [2],
                        value: 'Manchester'
                    },

                    {
                        attributes: null,
                        label: 'Birmingham',
                        validFor: [2],
                        value: 'Birmingham'
                    },

                    {
                        attributes: null,
                        label: 'London',
                        validFor: [2],
                        value: 'London'
                    }
                ]
            },

            Weakness__c: {
                controllerValues: {
                    false: 0,
                    true: 1
                },

                defaultValue: null,
                url:
                    '/services/data/v41.0/ui-api/object-info/Bad_Guy__c/picklist-values/012000000000000AAA/Weakness__c',
                values: [
                    {
                        attributes: null,
                        label: 'Silver Bullet',
                        validFor: [1],
                        value: 'Silver Bullet'
                    },

                    {
                        attributes: null,
                        label: 'Water',
                        validFor: [1],
                        value: 'Water'
                    },

                    {
                        attributes: null,
                        label: 'Poison',
                        validFor: [1],
                        value: 'Poison'
                    },

                    {
                        attributes: null,
                        label: 'Emotional Blackmail',
                        validFor: [1],
                        value: 'Emotional Blackmail'
                    }
                ]
            },

            Territories_Covered__c: {
                controllerValues: {},
                defaultValue: null,
                url:
                    '/services/data/v41.0/ui-api/object-info/Bad_Guy__c/picklist-values/012000000000000AAA/Territories_Covered__c',
                values: [
                    {
                        attributes: null,
                        label: 'East',
                        validFor: [],
                        value: 'East'
                    },

                    {
                        attributes: null,
                        label: 'North',
                        validFor: [],
                        value: 'North'
                    },

                    {
                        attributes: null,
                        label: 'West',
                        validFor: [],
                        value: 'West'
                    },

                    {
                        attributes: null,
                        label: 'South',
                        validFor: [],
                        value: 'South'
                    }
                ]
            },

            City__c: {
                controllerValues: {
                    'New York': 0,
                    California: 1,
                    Ontario: 2,
                    'British Columbia': 3
                },

                defaultValue: null,
                url:
                    '/services/data/v41.0/ui-api/object-info/Bad_Guy__c/picklist-values/012000000000000AAA/City__c',
                values: [
                    {
                        attributes: null,
                        label: 'New York City',
                        validFor: [0],
                        value: 'New York City'
                    },

                    {
                        attributes: null,
                        label: 'Buffalo',
                        validFor: [0],
                        value: 'Buffalo'
                    },

                    {
                        attributes: null,
                        label: 'San Francisco',
                        validFor: [1],
                        value: 'San Francisco'
                    },

                    {
                        attributes: null,
                        label: 'Los Angeles',
                        validFor: [1],
                        value: 'Los Angeles'
                    },

                    {
                        attributes: null,
                        label: 'Toronto',
                        validFor: [2],
                        value: 'Toronto'
                    },

                    {
                        attributes: null,
                        label: 'Ottawa',
                        validFor: [2],
                        value: 'Ottawa'
                    },

                    {
                        attributes: null,
                        label: 'Vancouver',
                        validFor: [3],
                        value: 'Vancouver'
                    }
                ]
            },

            Country__c: {
                controllerValues: {},
                defaultValue: null,
                url:
                    '/services/data/v41.0/ui-api/object-info/Bad_Guy__c/picklist-values/012000000000000AAA/Country__c',
                values: [
                    {
                        attributes: null,
                        label: 'United States',
                        validFor: [],
                        value: 'United States'
                    },

                    {
                        attributes: null,
                        label: 'Canada',
                        validFor: [],
                        value: 'Canada'
                    },

                    {
                        attributes: null,
                        label: 'United Kingdom',
                        validFor: [],
                        value: 'United Kingdom'
                    }
                ]
            },

            States_Provinces__c: {
                controllerValues: {
                    'United States': 0,
                    Canada: 1,
                    'United Kingdom': 2
                },

                defaultValue: null,
                url:
                    '/services/data/v41.0/ui-api/object-info/Bad_Guy__c/picklist-values/012000000000000AAA/States_Provinces__c',
                values: [
                    {
                        attributes: null,
                        label: 'New York',
                        validFor: [0],
                        value: 'New York'
                    },

                    {
                        attributes: null,
                        label: 'California',
                        validFor: [0],
                        value: 'California'
                    },

                    {
                        attributes: null,
                        label: 'Ontario',
                        validFor: [1],
                        value: 'Ontario'
                    },

                    {
                        attributes: null,
                        label: 'British Columbia',
                        validFor: [1],
                        value: 'British Columbia'
                    }
                ]
            }
        },

        '012xx0000000011': {
            MultiCity__c: {
                controllerValues: {
                    'United States': 0,
                    Canada: 1,
                    'United Kingdom': 2
                },

                defaultValue: null,
                url:
                    '/services/data/v41.0/ui-api/object-info/Bad_Guy__c/picklist-values/012000000000000AAA/MultiCity__c',
                values: [
                    {
                        attributes: null,
                        label: 'Montreal',
                        validFor: [1],
                        value: 'Montreal'
                    },

                    {
                        attributes: null,
                        label: 'Vancouver',
                        validFor: [1],
                        value: 'Vancouver'
                    },

                    {
                        attributes: null,
                        label: 'Toronto',
                        validFor: [1],
                        value: 'Toronto'
                    }
                ]
            },

            Weakness__c: {
                controllerValues: {
                    false: 0,
                    true: 1
                },

                defaultValue: null,
                url:
                    '/services/data/v41.0/ui-api/object-info/Bad_Guy__c/picklist-values/012000000000000AAA/Weakness__c',
                values: [
                    {
                        attributes: null,
                        label: 'Silver Bullet',
                        validFor: [1],
                        value: 'Silver Bullet'
                    },

                    {
                        attributes: null,
                        label: 'Water',
                        validFor: [1],
                        value: 'Water'
                    }
                ]
            },

            Territories_Covered__c: {
                controllerValues: {},
                defaultValue: null,
                url:
                    '/services/data/v41.0/ui-api/object-info/Bad_Guy__c/picklist-values/012000000000000AAA/Territories_Covered__c',
                values: [
                    {
                        attributes: null,
                        label: 'East',
                        validFor: [],
                        value: 'East'
                    },

                    {
                        attributes: null,
                        label: 'North',
                        validFor: [],
                        value: 'North'
                    },

                    {
                        attributes: null,
                        label: 'West',
                        validFor: [],
                        value: 'West'
                    },

                    {
                        attributes: null,
                        label: 'South',
                        validFor: [],
                        value: 'South'
                    }
                ]
            },

            City__c: {
                controllerValues: {
                    'New York': 0,
                    California: 1,
                    Ontario: 2,
                    'British Columbia': 3
                },

                defaultValue: null,
                url:
                    '/services/data/v41.0/ui-api/object-info/Bad_Guy__c/picklist-values/012000000000000AAA/City__c',
                values: [
                    {
                        attributes: null,
                        label: 'New York City',
                        validFor: [0],
                        value: 'New York City'
                    },

                    {
                        attributes: null,
                        label: 'Buffalo',
                        validFor: [0],
                        value: 'Buffalo'
                    },

                    {
                        attributes: null,
                        label: 'San Francisco',
                        validFor: [1],
                        value: 'San Francisco'
                    },

                    {
                        attributes: null,
                        label: 'Los Angeles',
                        validFor: [1],
                        value: 'Los Angeles'
                    },

                    {
                        attributes: null,
                        label: 'Toronto',
                        validFor: [2],
                        value: 'Toronto'
                    },

                    {
                        attributes: null,
                        label: 'Ottawa',
                        validFor: [2],
                        value: 'Ottawa'
                    },

                    {
                        attributes: null,
                        label: 'Vancouver',
                        validFor: [3],
                        value: 'Vancouver'
                    }
                ]
            },

            Country__c: {
                controllerValues: {},
                defaultValue: null,
                url:
                    '/services/data/v41.0/ui-api/object-info/Bad_Guy__c/picklist-values/012000000000000AAA/Country__c',
                values: [
                    {
                        attributes: null,
                        label: 'United States',
                        validFor: [],
                        value: 'United States'
                    },

                    {
                        attributes: null,
                        label: 'Canada',
                        validFor: [],
                        value: 'Canada'
                    }
                ]
            },

            States_Provinces__c: {
                controllerValues: {
                    'United States': 0,
                    Canada: 1,
                    'United Kingdom': 2
                },

                defaultValue: null,
                url:
                    '/services/data/v41.0/ui-api/object-info/Bad_Guy__c/picklist-values/012000000000000AAA/States_Provinces__c',
                values: [
                    {
                        attributes: null,
                        label: 'New York',
                        validFor: [0],
                        value: 'New York'
                    },

                    {
                        attributes: null,
                        label: 'California',
                        validFor: [0],
                        value: 'California'
                    },

                    {
                        attributes: null,
                        label: 'Ontario',
                        validFor: [1],
                        value: 'Ontario'
                    },

                    {
                        attributes: null,
                        label: 'British Columbia',
                        validFor: [1],
                        value: 'British Columbia'
                    }
                ]
            }
        }
    },

    Everything__c: {
        '012R00000000lNORTH': {
            Picklist__c: {
                controllerValues: {},
                defaultValue: null,
                values: [
                    {
                        attributes: null,
                        label: 'Nord',
                        validFor: [],
                        value: 'North'
                    },

                    {
                        attributes: null,
                        label: 'Sud',
                        validFor: [],
                        value: 'South'
                    }
                ]
            }
        },

        '012R00000000lEEAST': {
            Picklist__c: {
                controllerValues: {},
                defaultValue: null,
                values: [
                    {
                        attributes: null,
                        label: 'Est',
                        validFor: [],
                        value: 'East'
                    },

                    {
                        attributes: null,
                        label: 'Ouest',
                        validFor: [],
                        value: 'West'
                    }
                ]
            }
        },

        '012000000000000AAA': {
            Picklist__c: {
                controllerValues: {},
                defaultValue: null,
                values: [
                    {
                        attributes: null,
                        label: 'Est',
                        validFor: [],
                        value: 'East'
                    },

                    {
                        attributes: null,
                        label: 'Nord',
                        validFor: [],
                        value: 'North'
                    },

                    {
                        attributes: null,
                        label: 'Ouest',
                        validFor: [],
                        value: 'West'
                    },

                    {
                        attributes: null,
                        label: 'Sud',
                        validFor: [],
                        value: 'South'
                    }
                ]
            }
        }
    },

    Lead: {
        '012000000000000AAA': {
            Salutation: {
                controllerValues: {},
                defaultValue: 'Dr.',
                url:
                    '/services/data/v42.0/ui-api/object-info/Lead/picklist-values/012000000000000AAA/Salutation',
                values: [
                    {
                        attributes: null,
                        label: 'Mr.',
                        validFor: [],
                        value: 'Mr.'
                    },

                    {
                        attributes: null,
                        label: 'Ms.',
                        validFor: [],
                        value: 'Ms.'
                    },

                    {
                        attributes: null,
                        label: 'Mrs.',
                        validFor: [],
                        value: 'Mrs.'
                    },

                    {
                        attributes: null,
                        label: 'Dr.',
                        validFor: [],
                        value: 'Dr.'
                    },

                    {
                        attributes: null,
                        label: 'Prof.',
                        validFor: [],
                        value: 'Prof.'
                    }
                ]
            },

            CountryCode: {
                controllerValues: {},
                defaultValue: 'CA',
                url:
                    '/services/data/v42.0/ui-api/object-info/Account/picklist-values/012000000000000AAA/BillingCountryCode',
                values: [
                    {
                        attributes: null,
                        label: 'Afghanistan',
                        validFor: [],
                        value: 'AF'
                    },

                    {
                        attributes: null,
                        label: 'Aland Islands',
                        validFor: [],
                        value: 'AX'
                    },

                    {
                        attributes: null,
                        label: 'Albania',
                        validFor: [],
                        value: 'AL'
                    },

                    {
                        attributes: null,
                        label: 'Algeria',
                        validFor: [],
                        value: 'DZ'
                    },

                    {
                        attributes: null,
                        label: 'Andorra',
                        validFor: [],
                        value: 'AD'
                    },

                    {
                        attributes: null,
                        label: 'Angola',
                        validFor: [],
                        value: 'AO'
                    },

                    {
                        attributes: null,
                        label: 'Anguilla',
                        validFor: [],
                        value: 'AI'
                    },

                    {
                        attributes: null,
                        label: 'Antarctica',
                        validFor: [],
                        value: 'AQ'
                    },

                    {
                        attributes: null,
                        label: 'Antigua and Barbuda',
                        validFor: [],
                        value: 'AG'
                    },

                    {
                        attributes: null,
                        label: 'Argentina',
                        validFor: [],
                        value: 'AR'
                    },

                    {
                        attributes: null,
                        label: 'Armenia',
                        validFor: [],
                        value: 'AM'
                    },

                    {
                        attributes: null,
                        label: 'Aruba',
                        validFor: [],
                        value: 'AW'
                    },

                    {
                        attributes: null,
                        label: 'Australia',
                        validFor: [],
                        value: 'AU'
                    },

                    {
                        attributes: null,
                        label: 'Austria',
                        validFor: [],
                        value: 'AT'
                    },

                    {
                        attributes: null,
                        label: 'Azerbaijan',
                        validFor: [],
                        value: 'AZ'
                    },

                    {
                        attributes: null,
                        label: 'Bahamas',
                        validFor: [],
                        value: 'BS'
                    },

                    {
                        attributes: null,
                        label: 'Bahrain',
                        validFor: [],
                        value: 'BH'
                    },

                    {
                        attributes: null,
                        label: 'Bangladesh',
                        validFor: [],
                        value: 'BD'
                    },

                    {
                        attributes: null,
                        label: 'Barbados',
                        validFor: [],
                        value: 'BB'
                    },

                    {
                        attributes: null,
                        label: 'Belarus',
                        validFor: [],
                        value: 'BY'
                    },

                    {
                        attributes: null,
                        label: 'Belgium',
                        validFor: [],
                        value: 'BE'
                    },

                    {
                        attributes: null,
                        label: 'Belize',
                        validFor: [],
                        value: 'BZ'
                    },

                    {
                        attributes: null,
                        label: 'Benin',
                        validFor: [],
                        value: 'BJ'
                    },

                    {
                        attributes: null,
                        label: 'Bermuda',
                        validFor: [],
                        value: 'BM'
                    },

                    {
                        attributes: null,
                        label: 'Bhutan',
                        validFor: [],
                        value: 'BT'
                    },

                    {
                        attributes: null,
                        label: 'Bolivia, Plurinational State of',
                        validFor: [],
                        value: 'BO'
                    },

                    {
                        attributes: null,
                        label: 'Bonaire, Sint Eustatius and Saba',
                        validFor: [],
                        value: 'BQ'
                    },

                    {
                        attributes: null,
                        label: 'Bosnia and Herzegovina',
                        validFor: [],
                        value: 'BA'
                    },

                    {
                        attributes: null,
                        label: 'Botswana',
                        validFor: [],
                        value: 'BW'
                    },

                    {
                        attributes: null,
                        label: 'Bouvet Island',
                        validFor: [],
                        value: 'BV'
                    },

                    {
                        attributes: null,
                        label: 'Brazil',
                        validFor: [],
                        value: 'BR'
                    },

                    {
                        attributes: null,
                        label: 'British Indian Ocean Territory',
                        validFor: [],
                        value: 'IO'
                    },

                    {
                        attributes: null,
                        label: 'Brunei Darussalam',
                        validFor: [],
                        value: 'BN'
                    },

                    {
                        attributes: null,
                        label: 'Bulgaria',
                        validFor: [],
                        value: 'BG'
                    },

                    {
                        attributes: null,
                        label: 'Burkina Faso',
                        validFor: [],
                        value: 'BF'
                    },

                    {
                        attributes: null,
                        label: 'Burundi',
                        validFor: [],
                        value: 'BI'
                    },

                    {
                        attributes: null,
                        label: 'Cambodia',
                        validFor: [],
                        value: 'KH'
                    },

                    {
                        attributes: null,
                        label: 'Cameroon',
                        validFor: [],
                        value: 'CM'
                    },

                    {
                        attributes: null,
                        label: 'Canada',
                        validFor: [],
                        value: 'CA'
                    },

                    {
                        attributes: null,
                        label: 'Cape Verde',
                        validFor: [],
                        value: 'CV'
                    },

                    {
                        attributes: null,
                        label: 'Cayman Islands',
                        validFor: [],
                        value: 'KY'
                    },

                    {
                        attributes: null,
                        label: 'Central African Republic',
                        validFor: [],
                        value: 'CF'
                    },

                    {
                        attributes: null,
                        label: 'Chad',
                        validFor: [],
                        value: 'TD'
                    },

                    {
                        attributes: null,
                        label: 'Chile',
                        validFor: [],
                        value: 'CL'
                    },

                    {
                        attributes: null,
                        label: 'China',
                        validFor: [],
                        value: 'CN'
                    },

                    {
                        attributes: null,
                        label: 'Christmas Island',
                        validFor: [],
                        value: 'CX'
                    },

                    {
                        attributes: null,
                        label: 'Cocos (Keeling) Islands',
                        validFor: [],
                        value: 'CC'
                    },

                    {
                        attributes: null,
                        label: 'Colombia',
                        validFor: [],
                        value: 'CO'
                    },

                    {
                        attributes: null,
                        label: 'Comoros',
                        validFor: [],
                        value: 'KM'
                    },

                    {
                        attributes: null,
                        label: 'Congo',
                        validFor: [],
                        value: 'CG'
                    },

                    {
                        attributes: null,
                        label: 'Congo, the Democratic Republic of the',
                        validFor: [],
                        value: 'CD'
                    },

                    {
                        attributes: null,
                        label: 'Cook Islands',
                        validFor: [],
                        value: 'CK'
                    },

                    {
                        attributes: null,
                        label: 'Costa Rica',
                        validFor: [],
                        value: 'CR'
                    },

                    {
                        attributes: null,
                        label: 'Cote d&#39;Ivoire',
                        validFor: [],
                        value: 'CI'
                    },

                    {
                        attributes: null,
                        label: 'Croatia',
                        validFor: [],
                        value: 'HR'
                    },

                    {
                        attributes: null,
                        label: 'Cuba',
                        validFor: [],
                        value: 'CU'
                    },

                    {
                        attributes: null,
                        label: 'Curaçao',
                        validFor: [],
                        value: 'CW'
                    },

                    {
                        attributes: null,
                        label: 'Cyprus',
                        validFor: [],
                        value: 'CY'
                    },

                    {
                        attributes: null,
                        label: 'Czech Republic',
                        validFor: [],
                        value: 'CZ'
                    },

                    {
                        attributes: null,
                        label: 'Denmark',
                        validFor: [],
                        value: 'DK'
                    },

                    {
                        attributes: null,
                        label: 'Djibouti',
                        validFor: [],
                        value: 'DJ'
                    },

                    {
                        attributes: null,
                        label: 'Dominica',
                        validFor: [],
                        value: 'DM'
                    },

                    {
                        attributes: null,
                        label: 'Dominican Republic',
                        validFor: [],
                        value: 'DO'
                    },

                    {
                        attributes: null,
                        label: 'Ecuador',
                        validFor: [],
                        value: 'EC'
                    },

                    {
                        attributes: null,
                        label: 'Egypt',
                        validFor: [],
                        value: 'EG'
                    },

                    {
                        attributes: null,
                        label: 'El Salvador',
                        validFor: [],
                        value: 'SV'
                    },

                    {
                        attributes: null,
                        label: 'Equatorial Guinea',
                        validFor: [],
                        value: 'GQ'
                    },

                    {
                        attributes: null,
                        label: 'Eritrea',
                        validFor: [],
                        value: 'ER'
                    },

                    {
                        attributes: null,
                        label: 'Estonia',
                        validFor: [],
                        value: 'EE'
                    },

                    {
                        attributes: null,
                        label: 'Ethiopia',
                        validFor: [],
                        value: 'ET'
                    },

                    {
                        attributes: null,
                        label: 'Falkland Islands (Malvinas)',
                        validFor: [],
                        value: 'FK'
                    },

                    {
                        attributes: null,
                        label: 'Faroe Islands',
                        validFor: [],
                        value: 'FO'
                    },

                    {
                        attributes: null,
                        label: 'Fiji',
                        validFor: [],
                        value: 'FJ'
                    },

                    {
                        attributes: null,
                        label: 'Finland',
                        validFor: [],
                        value: 'FI'
                    },

                    {
                        attributes: null,
                        label: 'France',
                        validFor: [],
                        value: 'FR'
                    },

                    {
                        attributes: null,
                        label: 'French Guiana',
                        validFor: [],
                        value: 'GF'
                    },

                    {
                        attributes: null,
                        label: 'French Polynesia',
                        validFor: [],
                        value: 'PF'
                    },

                    {
                        attributes: null,
                        label: 'French Southern Territories',
                        validFor: [],
                        value: 'TF'
                    },

                    {
                        attributes: null,
                        label: 'Gabon',
                        validFor: [],
                        value: 'GA'
                    },

                    {
                        attributes: null,
                        label: 'Gambia',
                        validFor: [],
                        value: 'GM'
                    },

                    {
                        attributes: null,
                        label: 'Georgia',
                        validFor: [],
                        value: 'GE'
                    },

                    {
                        attributes: null,
                        label: 'Germany',
                        validFor: [],
                        value: 'DE'
                    },

                    {
                        attributes: null,
                        label: 'Ghana',
                        validFor: [],
                        value: 'GH'
                    },

                    {
                        attributes: null,
                        label: 'Gibraltar',
                        validFor: [],
                        value: 'GI'
                    },

                    {
                        attributes: null,
                        label: 'Greece',
                        validFor: [],
                        value: 'GR'
                    },

                    {
                        attributes: null,
                        label: 'Greenland',
                        validFor: [],
                        value: 'GL'
                    },

                    {
                        attributes: null,
                        label: 'Grenada',
                        validFor: [],
                        value: 'GD'
                    },

                    {
                        attributes: null,
                        label: 'Guadeloupe',
                        validFor: [],
                        value: 'GP'
                    },

                    {
                        attributes: null,
                        label: 'Guatemala',
                        validFor: [],
                        value: 'GT'
                    },

                    {
                        attributes: null,
                        label: 'Guernsey',
                        validFor: [],
                        value: 'GG'
                    },

                    {
                        attributes: null,
                        label: 'Guinea',
                        validFor: [],
                        value: 'GN'
                    },

                    {
                        attributes: null,
                        label: 'Guinea-Bissau',
                        validFor: [],
                        value: 'GW'
                    },

                    {
                        attributes: null,
                        label: 'Guyana',
                        validFor: [],
                        value: 'GY'
                    },

                    {
                        attributes: null,
                        label: 'Haiti',
                        validFor: [],
                        value: 'HT'
                    },

                    {
                        attributes: null,
                        label: 'Heard Island and McDonald Islands',
                        validFor: [],
                        value: 'HM'
                    },

                    {
                        attributes: null,
                        label: 'Holy See (Vatican City State)',
                        validFor: [],
                        value: 'VA'
                    },

                    {
                        attributes: null,
                        label: 'Honduras',
                        validFor: [],
                        value: 'HN'
                    },

                    {
                        attributes: null,
                        label: 'Hungary',
                        validFor: [],
                        value: 'HU'
                    },

                    {
                        attributes: null,
                        label: 'Iceland',
                        validFor: [],
                        value: 'IS'
                    },

                    {
                        attributes: null,
                        label: 'India',
                        validFor: [],
                        value: 'IN'
                    },

                    {
                        attributes: null,
                        label: 'Indonesia',
                        validFor: [],
                        value: 'ID'
                    },

                    {
                        attributes: null,
                        label: 'Iran, Islamic Republic of',
                        validFor: [],
                        value: 'IR'
                    },

                    {
                        attributes: null,
                        label: 'Iraq',
                        validFor: [],
                        value: 'IQ'
                    },

                    {
                        attributes: null,
                        label: 'Ireland',
                        validFor: [],
                        value: 'IE'
                    },

                    {
                        attributes: null,
                        label: 'Isle of Man',
                        validFor: [],
                        value: 'IM'
                    },

                    {
                        attributes: null,
                        label: 'Israel',
                        validFor: [],
                        value: 'IL'
                    },

                    {
                        attributes: null,
                        label: 'Italy',
                        validFor: [],
                        value: 'IT'
                    },

                    {
                        attributes: null,
                        label: 'Jamaica',
                        validFor: [],
                        value: 'JM'
                    },

                    {
                        attributes: null,
                        label: 'Japan',
                        validFor: [],
                        value: 'JP'
                    },

                    {
                        attributes: null,
                        label: 'Jersey',
                        validFor: [],
                        value: 'JE'
                    },

                    {
                        attributes: null,
                        label: 'Jordan',
                        validFor: [],
                        value: 'JO'
                    },

                    {
                        attributes: null,
                        label: 'Kazakhstan',
                        validFor: [],
                        value: 'KZ'
                    },

                    {
                        attributes: null,
                        label: 'Kenya',
                        validFor: [],
                        value: 'KE'
                    },

                    {
                        attributes: null,
                        label: 'Kiribati',
                        validFor: [],
                        value: 'KI'
                    },

                    {
                        attributes: null,
                        label: 'Korea, Democratic People&#39;s Republic of',
                        validFor: [],
                        value: 'KP'
                    },

                    {
                        attributes: null,
                        label: 'Korea, Republic of',
                        validFor: [],
                        value: 'KR'
                    },

                    {
                        attributes: null,
                        label: 'Kuwait',
                        validFor: [],
                        value: 'KW'
                    },

                    {
                        attributes: null,
                        label: 'Kyrgyzstan',
                        validFor: [],
                        value: 'KG'
                    },

                    {
                        attributes: null,
                        label: 'Lao People&#39;s Democratic Republic',
                        validFor: [],
                        value: 'LA'
                    },

                    {
                        attributes: null,
                        label: 'Latvia',
                        validFor: [],
                        value: 'LV'
                    },

                    {
                        attributes: null,
                        label: 'Lebanon',
                        validFor: [],
                        value: 'LB'
                    },

                    {
                        attributes: null,
                        label: 'Lesotho',
                        validFor: [],
                        value: 'LS'
                    },

                    {
                        attributes: null,
                        label: 'Liberia',
                        validFor: [],
                        value: 'LR'
                    },

                    {
                        attributes: null,
                        label: 'Libya',
                        validFor: [],
                        value: 'LY'
                    },

                    {
                        attributes: null,
                        label: 'Liechtenstein',
                        validFor: [],
                        value: 'LI'
                    },

                    {
                        attributes: null,
                        label: 'Lithuania',
                        validFor: [],
                        value: 'LT'
                    },

                    {
                        attributes: null,
                        label: 'Luxembourg',
                        validFor: [],
                        value: 'LU'
                    },

                    {
                        attributes: null,
                        label: 'Macao',
                        validFor: [],
                        value: 'MO'
                    },

                    {
                        attributes: null,
                        label: 'Macedonia, the former Yugoslav Republic of',
                        validFor: [],
                        value: 'MK'
                    },

                    {
                        attributes: null,
                        label: 'Madagascar',
                        validFor: [],
                        value: 'MG'
                    },

                    {
                        attributes: null,
                        label: 'Malawi',
                        validFor: [],
                        value: 'MW'
                    },

                    {
                        attributes: null,
                        label: 'Malaysia',
                        validFor: [],
                        value: 'MY'
                    },

                    {
                        attributes: null,
                        label: 'Maldives',
                        validFor: [],
                        value: 'MV'
                    },

                    {
                        attributes: null,
                        label: 'Mali',
                        validFor: [],
                        value: 'ML'
                    },

                    {
                        attributes: null,
                        label: 'Malta',
                        validFor: [],
                        value: 'MT'
                    },

                    {
                        attributes: null,
                        label: 'Martinique',
                        validFor: [],
                        value: 'MQ'
                    },

                    {
                        attributes: null,
                        label: 'Mauritania',
                        validFor: [],
                        value: 'MR'
                    },

                    {
                        attributes: null,
                        label: 'Mauritius',
                        validFor: [],
                        value: 'MU'
                    },

                    {
                        attributes: null,
                        label: 'Mayotte',
                        validFor: [],
                        value: 'YT'
                    },

                    {
                        attributes: null,
                        label: 'Mexico',
                        validFor: [],
                        value: 'MX'
                    },

                    {
                        attributes: null,
                        label: 'Moldova, Republic of',
                        validFor: [],
                        value: 'MD'
                    },

                    {
                        attributes: null,
                        label: 'Monaco',
                        validFor: [],
                        value: 'MC'
                    },

                    {
                        attributes: null,
                        label: 'Mongolia',
                        validFor: [],
                        value: 'MN'
                    },

                    {
                        attributes: null,
                        label: 'Montenegro',
                        validFor: [],
                        value: 'ME'
                    },

                    {
                        attributes: null,
                        label: 'Montserrat',
                        validFor: [],
                        value: 'MS'
                    },

                    {
                        attributes: null,
                        label: 'Morocco',
                        validFor: [],
                        value: 'MA'
                    },

                    {
                        attributes: null,
                        label: 'Mozambique',
                        validFor: [],
                        value: 'MZ'
                    },

                    {
                        attributes: null,
                        label: 'Myanmar',
                        validFor: [],
                        value: 'MM'
                    },

                    {
                        attributes: null,
                        label: 'Namibia',
                        validFor: [],
                        value: 'NA'
                    },

                    {
                        attributes: null,
                        label: 'Nauru',
                        validFor: [],
                        value: 'NR'
                    },

                    {
                        attributes: null,
                        label: 'Nepal',
                        validFor: [],
                        value: 'NP'
                    },

                    {
                        attributes: null,
                        label: 'Netherlands',
                        validFor: [],
                        value: 'NL'
                    },

                    {
                        attributes: null,
                        label: 'New Caledonia',
                        validFor: [],
                        value: 'NC'
                    },

                    {
                        attributes: null,
                        label: 'New Zealand',
                        validFor: [],
                        value: 'NZ'
                    },

                    {
                        attributes: null,
                        label: 'Nicaragua',
                        validFor: [],
                        value: 'NI'
                    },

                    {
                        attributes: null,
                        label: 'Niger',
                        validFor: [],
                        value: 'NE'
                    },

                    {
                        attributes: null,
                        label: 'Nigeria',
                        validFor: [],
                        value: 'NG'
                    },

                    {
                        attributes: null,
                        label: 'Niue',
                        validFor: [],
                        value: 'NU'
                    },

                    {
                        attributes: null,
                        label: 'Norfolk Island',
                        validFor: [],
                        value: 'NF'
                    },

                    {
                        attributes: null,
                        label: 'Norway',
                        validFor: [],
                        value: 'NO'
                    },

                    {
                        attributes: null,
                        label: 'Oman',
                        validFor: [],
                        value: 'OM'
                    },

                    {
                        attributes: null,
                        label: 'Pakistan',
                        validFor: [],
                        value: 'PK'
                    },

                    {
                        attributes: null,
                        label: 'Palestine',
                        validFor: [],
                        value: 'PS'
                    },

                    {
                        attributes: null,
                        label: 'Panama',
                        validFor: [],
                        value: 'PA'
                    },

                    {
                        attributes: null,
                        label: 'Papua New Guinea',
                        validFor: [],
                        value: 'PG'
                    },

                    {
                        attributes: null,
                        label: 'Paraguay',
                        validFor: [],
                        value: 'PY'
                    },

                    {
                        attributes: null,
                        label: 'Peru',
                        validFor: [],
                        value: 'PE'
                    },

                    {
                        attributes: null,
                        label: 'Philippines',
                        validFor: [],
                        value: 'PH'
                    },

                    {
                        attributes: null,
                        label: 'Pitcairn',
                        validFor: [],
                        value: 'PN'
                    },

                    {
                        attributes: null,
                        label: 'Poland',
                        validFor: [],
                        value: 'PL'
                    },

                    {
                        attributes: null,
                        label: 'Portugal',
                        validFor: [],
                        value: 'PT'
                    },

                    {
                        attributes: null,
                        label: 'Qatar',
                        validFor: [],
                        value: 'QA'
                    },

                    {
                        attributes: null,
                        label: 'Reunion',
                        validFor: [],
                        value: 'RE'
                    },

                    {
                        attributes: null,
                        label: 'Romania',
                        validFor: [],
                        value: 'RO'
                    },

                    {
                        attributes: null,
                        label: 'Russian Federation',
                        validFor: [],
                        value: 'RU'
                    },

                    {
                        attributes: null,
                        label: 'Rwanda',
                        validFor: [],
                        value: 'RW'
                    },

                    {
                        attributes: null,
                        label: 'Saint Barthélemy',
                        validFor: [],
                        value: 'BL'
                    },

                    {
                        attributes: null,
                        label: 'Saint Helena, Ascension and Tristan da Cunha',
                        validFor: [],
                        value: 'SH'
                    },

                    {
                        attributes: null,
                        label: 'Saint Kitts and Nevis',
                        validFor: [],
                        value: 'KN'
                    },

                    {
                        attributes: null,
                        label: 'Saint Lucia',
                        validFor: [],
                        value: 'LC'
                    },

                    {
                        attributes: null,
                        label: 'Saint Martin (French part)',
                        validFor: [],
                        value: 'MF'
                    },

                    {
                        attributes: null,
                        label: 'Saint Pierre and Miquelon',
                        validFor: [],
                        value: 'PM'
                    },

                    {
                        attributes: null,
                        label: 'Saint Vincent and the Grenadines',
                        validFor: [],
                        value: 'VC'
                    },

                    {
                        attributes: null,
                        label: 'Samoa',
                        validFor: [],
                        value: 'WS'
                    },

                    {
                        attributes: null,
                        label: 'San Marino',
                        validFor: [],
                        value: 'SM'
                    },

                    {
                        attributes: null,
                        label: 'Sao Tome and Principe',
                        validFor: [],
                        value: 'ST'
                    },

                    {
                        attributes: null,
                        label: 'Saudi Arabia',
                        validFor: [],
                        value: 'SA'
                    },

                    {
                        attributes: null,
                        label: 'Senegal',
                        validFor: [],
                        value: 'SN'
                    },

                    {
                        attributes: null,
                        label: 'Serbia',
                        validFor: [],
                        value: 'RS'
                    },

                    {
                        attributes: null,
                        label: 'Seychelles',
                        validFor: [],
                        value: 'SC'
                    },

                    {
                        attributes: null,
                        label: 'Sierra Leone',
                        validFor: [],
                        value: 'SL'
                    },

                    {
                        attributes: null,
                        label: 'Singapore',
                        validFor: [],
                        value: 'SG'
                    },

                    {
                        attributes: null,
                        label: 'Sint Maarten (Dutch part)',
                        validFor: [],
                        value: 'SX'
                    },

                    {
                        attributes: null,
                        label: 'Slovakia',
                        validFor: [],
                        value: 'SK'
                    },

                    {
                        attributes: null,
                        label: 'Slovenia',
                        validFor: [],
                        value: 'SI'
                    },

                    {
                        attributes: null,
                        label: 'Solomon Islands',
                        validFor: [],
                        value: 'SB'
                    },

                    {
                        attributes: null,
                        label: 'Somalia',
                        validFor: [],
                        value: 'SO'
                    },

                    {
                        attributes: null,
                        label: 'South Africa',
                        validFor: [],
                        value: 'ZA'
                    },

                    {
                        attributes: null,
                        label: 'South Georgia and the South Sandwich Islands',
                        validFor: [],
                        value: 'GS'
                    },

                    {
                        attributes: null,
                        label: 'South Sudan',
                        validFor: [],
                        value: 'SS'
                    },

                    {
                        attributes: null,
                        label: 'Spain',
                        validFor: [],
                        value: 'ES'
                    },

                    {
                        attributes: null,
                        label: 'Sri Lanka',
                        validFor: [],
                        value: 'LK'
                    },

                    {
                        attributes: null,
                        label: 'Sudan',
                        validFor: [],
                        value: 'SD'
                    },

                    {
                        attributes: null,
                        label: 'Suriname',
                        validFor: [],
                        value: 'SR'
                    },

                    {
                        attributes: null,
                        label: 'Svalbard and Jan Mayen',
                        validFor: [],
                        value: 'SJ'
                    },

                    {
                        attributes: null,
                        label: 'Swaziland',
                        validFor: [],
                        value: 'SZ'
                    },

                    {
                        attributes: null,
                        label: 'Sweden',
                        validFor: [],
                        value: 'SE'
                    },

                    {
                        attributes: null,
                        label: 'Switzerland',
                        validFor: [],
                        value: 'CH'
                    },

                    {
                        attributes: null,
                        label: 'Syrian Arab Republic',
                        validFor: [],
                        value: 'SY'
                    },

                    {
                        attributes: null,
                        label: 'Taiwan',
                        validFor: [],
                        value: 'TW'
                    },

                    {
                        attributes: null,
                        label: 'Tajikistan',
                        validFor: [],
                        value: 'TJ'
                    },

                    {
                        attributes: null,
                        label: 'Tanzania, United Republic of',
                        validFor: [],
                        value: 'TZ'
                    },

                    {
                        attributes: null,
                        label: 'Thailand',
                        validFor: [],
                        value: 'TH'
                    },

                    {
                        attributes: null,
                        label: 'Timor-Leste',
                        validFor: [],
                        value: 'TL'
                    },

                    {
                        attributes: null,
                        label: 'Togo',
                        validFor: [],
                        value: 'TG'
                    },

                    {
                        attributes: null,
                        label: 'Tokelau',
                        validFor: [],
                        value: 'TK'
                    },

                    {
                        attributes: null,
                        label: 'Tonga',
                        validFor: [],
                        value: 'TO'
                    },

                    {
                        attributes: null,
                        label: 'Trinidad and Tobago',
                        validFor: [],
                        value: 'TT'
                    },

                    {
                        attributes: null,
                        label: 'Tunisia',
                        validFor: [],
                        value: 'TN'
                    },

                    {
                        attributes: null,
                        label: 'Turkey',
                        validFor: [],
                        value: 'TR'
                    },

                    {
                        attributes: null,
                        label: 'Turkmenistan',
                        validFor: [],
                        value: 'TM'
                    },

                    {
                        attributes: null,
                        label: 'Turks and Caicos Islands',
                        validFor: [],
                        value: 'TC'
                    },

                    {
                        attributes: null,
                        label: 'Tuvalu',
                        validFor: [],
                        value: 'TV'
                    },

                    {
                        attributes: null,
                        label: 'Uganda',
                        validFor: [],
                        value: 'UG'
                    },

                    {
                        attributes: null,
                        label: 'Ukraine',
                        validFor: [],
                        value: 'UA'
                    },

                    {
                        attributes: null,
                        label: 'United Arab Emirates',
                        validFor: [],
                        value: 'AE'
                    },

                    {
                        attributes: null,
                        label: 'United Kingdom',
                        validFor: [],
                        value: 'GB'
                    },

                    {
                        attributes: null,
                        label: 'United States',
                        validFor: [],
                        value: 'US'
                    },

                    {
                        attributes: null,
                        label: 'Uruguay',
                        validFor: [],
                        value: 'UY'
                    },

                    {
                        attributes: null,
                        label: 'Uzbekistan',
                        validFor: [],
                        value: 'UZ'
                    },

                    {
                        attributes: null,
                        label: 'Vanuatu',
                        validFor: [],
                        value: 'VU'
                    },

                    {
                        attributes: null,
                        label: 'Venezuela, Bolivarian Republic of',
                        validFor: [],
                        value: 'VE'
                    },

                    {
                        attributes: null,
                        label: 'Vietnam',
                        validFor: [],
                        value: 'VN'
                    },

                    {
                        attributes: null,
                        label: 'Virgin Islands, British',
                        validFor: [],
                        value: 'VG'
                    },

                    {
                        attributes: null,
                        label: 'Wallis and Futuna',
                        validFor: [],
                        value: 'WF'
                    },

                    {
                        attributes: null,
                        label: 'Western Sahara',
                        validFor: [],
                        value: 'EH'
                    },

                    {
                        attributes: null,
                        label: 'Yemen',
                        validFor: [],
                        value: 'YE'
                    },

                    {
                        attributes: null,
                        label: 'Zambia',
                        validFor: [],
                        value: 'ZM'
                    },

                    {
                        attributes: null,
                        label: 'Zimbabwe',
                        validFor: [],
                        value: 'ZW'
                    }
                ]
            },

            StateCode: {
                controllerValues: {
                    AF: 0,
                    AX: 1,
                    AL: 2,
                    DZ: 3,
                    AD: 4,
                    AO: 5,
                    AI: 6,
                    AQ: 7,
                    AG: 8,
                    AR: 9,
                    AM: 10,
                    AW: 11,
                    AU: 12,
                    AT: 13,
                    AZ: 14,
                    BS: 15,
                    BH: 16,
                    BD: 17,
                    BB: 18,
                    BY: 19,
                    BE: 20,
                    BZ: 21,
                    BJ: 22,
                    BM: 23,
                    BT: 24,
                    BO: 25,
                    BQ: 26,
                    BA: 27,
                    BW: 28,
                    BV: 29,
                    BR: 30,
                    IO: 31,
                    BN: 32,
                    BG: 33,
                    BF: 34,
                    BI: 35,
                    KH: 36,
                    CM: 37,
                    CA: 38,
                    CV: 39,
                    KY: 40,
                    CF: 41,
                    TD: 42,
                    CL: 43,
                    CN: 44,
                    CX: 45,
                    CC: 46,
                    CO: 47,
                    KM: 48,
                    CG: 49,
                    CD: 50,
                    CK: 51,
                    CR: 52,
                    CI: 53,
                    HR: 54,
                    CU: 55,
                    CW: 56,
                    CY: 57,
                    CZ: 58,
                    DK: 59,
                    DJ: 60,
                    DM: 61,
                    DO: 62,
                    EC: 63,
                    EG: 64,
                    SV: 65,
                    GQ: 66,
                    ER: 67,
                    EE: 68,
                    ET: 69,
                    FK: 70,
                    FO: 71,
                    FJ: 72,
                    FI: 73,
                    FR: 74,
                    GF: 75,
                    PF: 76,
                    TF: 77,
                    GA: 78,
                    GM: 79,
                    GE: 80,
                    DE: 81,
                    GH: 82,
                    GI: 83,
                    GR: 84,
                    GL: 85,
                    GD: 86,
                    GP: 87,
                    GT: 88,
                    GG: 89,
                    GN: 90,
                    GW: 91,
                    GY: 92,
                    HT: 93,
                    HM: 94,
                    VA: 95,
                    HN: 96,
                    HU: 97,
                    IS: 98,
                    IN: 99,
                    ID: 100,
                    IR: 101,
                    IQ: 102,
                    IE: 103,
                    IM: 104,
                    IL: 105,
                    IT: 106,
                    JM: 107,
                    JP: 108,
                    JE: 109,
                    JO: 110,
                    KZ: 111,
                    KE: 112,
                    KI: 113,
                    KP: 114,
                    KR: 115,
                    KW: 116,
                    KG: 117,
                    LA: 118,
                    LV: 119,
                    LB: 120,
                    LS: 121,
                    LR: 122,
                    LY: 123,
                    LI: 124,
                    LT: 125,
                    LU: 126,
                    MO: 127,
                    MK: 128,
                    MG: 129,
                    MW: 130,
                    MY: 131,
                    MV: 132,
                    ML: 133,
                    MT: 134,
                    MQ: 135,
                    MR: 136,
                    MU: 137,
                    YT: 138,
                    MX: 139,
                    MD: 140,
                    MC: 141,
                    MN: 142,
                    ME: 143,
                    MS: 144,
                    MA: 145,
                    MZ: 146,
                    MM: 147,
                    NA: 148,
                    NR: 149,
                    NP: 150,
                    NL: 151,
                    NC: 152,
                    NZ: 153,
                    NI: 154,
                    NE: 155,
                    NG: 156,
                    NU: 157,
                    NF: 158,
                    NO: 159,
                    OM: 160,
                    PK: 161,
                    PS: 162,
                    PA: 163,
                    PG: 164,
                    PY: 165,
                    PE: 166,
                    PH: 167,
                    PN: 168,
                    PL: 169,
                    PT: 170,
                    QA: 171,
                    RE: 172,
                    RO: 173,
                    RU: 174,
                    RW: 175,
                    BL: 176,
                    SH: 177,
                    KN: 178,
                    LC: 179,
                    MF: 180,
                    PM: 181,
                    VC: 182,
                    WS: 183,
                    SM: 184,
                    ST: 185,
                    SA: 186,
                    SN: 187,
                    RS: 188,
                    SC: 189,
                    SL: 190,
                    SG: 191,
                    SX: 192,
                    SK: 193,
                    SI: 194,
                    SB: 195,
                    SO: 196,
                    ZA: 197,
                    GS: 198,
                    SS: 199,
                    ES: 200,
                    LK: 201,
                    SD: 202,
                    SR: 203,
                    SJ: 204,
                    SZ: 205,
                    SE: 206,
                    CH: 207,
                    SY: 208,
                    TW: 209,
                    TJ: 210,
                    TZ: 211,
                    TH: 212,
                    TL: 213,
                    TG: 214,
                    TK: 215,
                    TO: 216,
                    TT: 217,
                    TN: 218,
                    TR: 219,
                    TM: 220,
                    TC: 221,
                    TV: 222,
                    UG: 223,
                    UA: 224,
                    AE: 225,
                    GB: 226,
                    US: 227,
                    UY: 228,
                    UZ: 229,
                    VU: 230,
                    VE: 231,
                    VN: 232,
                    VG: 233,
                    WF: 234,
                    EH: 235,
                    YE: 236,
                    ZM: 237,
                    ZW: 238
                },

                defaultValue: null,
                url:
                    '/services/data/v42.0/ui-api/object-info/Account/picklist-values/012000000000000AAA/BillingStateCode',
                values: [
                    {
                        attributes: null,
                        label: 'Acre',
                        validFor: [30],
                        value: 'AC'
                    },

                    {
                        attributes: null,
                        label: 'Agrigento',
                        validFor: [106],
                        value: 'AG'
                    },

                    {
                        attributes: null,
                        label: 'Aguascalientes',
                        validFor: [139],
                        value: 'AG'
                    },

                    {
                        attributes: null,
                        label: 'Alabama',
                        validFor: [227],
                        value: 'AL'
                    },

                    {
                        attributes: null,
                        label: 'Alagoas',
                        validFor: [30],
                        value: 'AL'
                    },

                    {
                        attributes: null,
                        label: 'Alaska',
                        validFor: [227],
                        value: 'AK'
                    },

                    {
                        attributes: null,
                        label: 'Alberta',
                        validFor: [38],
                        value: 'AB'
                    },

                    {
                        attributes: null,
                        label: 'Alessandria',
                        validFor: [106],
                        value: 'AL'
                    },

                    {
                        attributes: null,
                        label: 'Amapá',
                        validFor: [30],
                        value: 'AP'
                    },

                    {
                        attributes: null,
                        label: 'Amazonas',
                        validFor: [30],
                        value: 'AM'
                    },

                    {
                        attributes: null,
                        label: 'Ancona',
                        validFor: [106],
                        value: 'AN'
                    },

                    {
                        attributes: null,
                        label: 'Andaman and Nicobar Islands',
                        validFor: [99],
                        value: 'AN'
                    },

                    {
                        attributes: null,
                        label: 'Andhra Pradesh',
                        validFor: [99],
                        value: 'AP'
                    },

                    {
                        attributes: null,
                        label: 'Anhui',
                        validFor: [44],
                        value: '34'
                    },

                    {
                        attributes: null,
                        label: 'Aosta',
                        validFor: [106],
                        value: 'AO'
                    },

                    {
                        attributes: null,
                        label: 'Arezzo',
                        validFor: [106],
                        value: 'AR'
                    },

                    {
                        attributes: null,
                        label: 'Arizona',
                        validFor: [227],
                        value: 'AZ'
                    },

                    {
                        attributes: null,
                        label: 'Arkansas',
                        validFor: [227],
                        value: 'AR'
                    },

                    {
                        attributes: null,
                        label: 'Arunachal Pradesh',
                        validFor: [99],
                        value: 'AR'
                    },

                    {
                        attributes: null,
                        label: 'Ascoli Piceno',
                        validFor: [106],
                        value: 'AP'
                    },

                    {
                        attributes: null,
                        label: 'Assam',
                        validFor: [99],
                        value: 'AS'
                    },

                    {
                        attributes: null,
                        label: 'Asti',
                        validFor: [106],
                        value: 'AT'
                    },

                    {
                        attributes: null,
                        label: 'Australian Capital Territory',
                        validFor: [12],
                        value: 'ACT'
                    },

                    {
                        attributes: null,
                        label: 'Avellino',
                        validFor: [106],
                        value: 'AV'
                    },

                    {
                        attributes: null,
                        label: 'Bahia',
                        validFor: [30],
                        value: 'BA'
                    },

                    {
                        attributes: null,
                        label: 'Baja California',
                        validFor: [139],
                        value: 'BC'
                    },

                    {
                        attributes: null,
                        label: 'Baja California Sur',
                        validFor: [139],
                        value: 'BS'
                    },

                    {
                        attributes: null,
                        label: 'Bari',
                        validFor: [106],
                        value: 'BA'
                    },

                    {
                        attributes: null,
                        label: 'Barletta-Andria-Trani',
                        validFor: [106],
                        value: 'BT'
                    },

                    {
                        attributes: null,
                        label: 'Beijing',
                        validFor: [44],
                        value: '11'
                    },

                    {
                        attributes: null,
                        label: 'Belluno',
                        validFor: [106],
                        value: 'BL'
                    },

                    {
                        attributes: null,
                        label: 'Benevento',
                        validFor: [106],
                        value: 'BN'
                    },

                    {
                        attributes: null,
                        label: 'Bergamo',
                        validFor: [106],
                        value: 'BG'
                    },

                    {
                        attributes: null,
                        label: 'Biella',
                        validFor: [106],
                        value: 'BI'
                    },

                    {
                        attributes: null,
                        label: 'Bihar',
                        validFor: [99],
                        value: 'BR'
                    },

                    {
                        attributes: null,
                        label: 'Bologna',
                        validFor: [106],
                        value: 'BO'
                    },

                    {
                        attributes: null,
                        label: 'Bolzano',
                        validFor: [106],
                        value: 'BZ'
                    },

                    {
                        attributes: null,
                        label: 'Brescia',
                        validFor: [106],
                        value: 'BS'
                    },

                    {
                        attributes: null,
                        label: 'Brindisi',
                        validFor: [106],
                        value: 'BR'
                    },

                    {
                        attributes: null,
                        label: 'British Columbia',
                        validFor: [38],
                        value: 'BC'
                    },

                    {
                        attributes: null,
                        label: 'Cagliari',
                        validFor: [106],
                        value: 'CA'
                    },

                    {
                        attributes: null,
                        label: 'California',
                        validFor: [227],
                        value: 'CA'
                    },

                    {
                        attributes: null,
                        label: 'Caltanissetta',
                        validFor: [106],
                        value: 'CL'
                    },

                    {
                        attributes: null,
                        label: 'Campeche',
                        validFor: [139],
                        value: 'CM'
                    },

                    {
                        attributes: null,
                        label: 'Campobasso',
                        validFor: [106],
                        value: 'CB'
                    },

                    {
                        attributes: null,
                        label: 'Carbonia-Iglesias',
                        validFor: [106],
                        value: 'CI'
                    },

                    {
                        attributes: null,
                        label: 'Carlow',
                        validFor: [103],
                        value: 'CW'
                    },

                    {
                        attributes: null,
                        label: 'Caserta',
                        validFor: [106],
                        value: 'CE'
                    },

                    {
                        attributes: null,
                        label: 'Catania',
                        validFor: [106],
                        value: 'CT'
                    },

                    {
                        attributes: null,
                        label: 'Catanzaro',
                        validFor: [106],
                        value: 'CZ'
                    },

                    {
                        attributes: null,
                        label: 'Cavan',
                        validFor: [103],
                        value: 'CN'
                    },

                    {
                        attributes: null,
                        label: 'Ceará',
                        validFor: [30],
                        value: 'CE'
                    },

                    {
                        attributes: null,
                        label: 'Chandigarh',
                        validFor: [99],
                        value: 'CH'
                    },

                    {
                        attributes: null,
                        label: 'Chhattisgarh',
                        validFor: [99],
                        value: 'CT'
                    },

                    {
                        attributes: null,
                        label: 'Chiapas',
                        validFor: [139],
                        value: 'CS'
                    },

                    {
                        attributes: null,
                        label: 'Chieti',
                        validFor: [106],
                        value: 'CH'
                    },

                    {
                        attributes: null,
                        label: 'Chihuahua',
                        validFor: [139],
                        value: 'CH'
                    },

                    {
                        attributes: null,
                        label: 'Chongqing',
                        validFor: [44],
                        value: '50'
                    },

                    {
                        attributes: null,
                        label: 'Clare',
                        validFor: [103],
                        value: 'CE'
                    },

                    {
                        attributes: null,
                        label: 'Coahuila',
                        validFor: [139],
                        value: 'CO'
                    },

                    {
                        attributes: null,
                        label: 'Colima',
                        validFor: [139],
                        value: 'CL'
                    },

                    {
                        attributes: null,
                        label: 'Colorado',
                        validFor: [227],
                        value: 'CO'
                    },

                    {
                        attributes: null,
                        label: 'Como',
                        validFor: [106],
                        value: 'CO'
                    },

                    {
                        attributes: null,
                        label: 'Connecticut',
                        validFor: [227],
                        value: 'CT'
                    },

                    {
                        attributes: null,
                        label: 'Cork',
                        validFor: [103],
                        value: 'CO'
                    },

                    {
                        attributes: null,
                        label: 'Cosenza',
                        validFor: [106],
                        value: 'CS'
                    },

                    {
                        attributes: null,
                        label: 'Cremona',
                        validFor: [106],
                        value: 'CR'
                    },

                    {
                        attributes: null,
                        label: 'Crotone',
                        validFor: [106],
                        value: 'KR'
                    },

                    {
                        attributes: null,
                        label: 'Cuneo',
                        validFor: [106],
                        value: 'CN'
                    },

                    {
                        attributes: null,
                        label: 'Dadra and Nagar Haveli',
                        validFor: [99],
                        value: 'DN'
                    },

                    {
                        attributes: null,
                        label: 'Daman and Diu',
                        validFor: [99],
                        value: 'DD'
                    },

                    {
                        attributes: null,
                        label: 'Delaware',
                        validFor: [227],
                        value: 'DE'
                    },

                    {
                        attributes: null,
                        label: 'Delhi',
                        validFor: [99],
                        value: 'DL'
                    },

                    {
                        attributes: null,
                        label: 'District of Columbia',
                        validFor: [227],
                        value: 'DC'
                    },

                    {
                        attributes: null,
                        label: 'Distrito Federal',
                        validFor: [30],
                        value: 'DF'
                    },

                    {
                        attributes: null,
                        label: 'Donegal',
                        validFor: [103],
                        value: 'DL'
                    },

                    {
                        attributes: null,
                        label: 'Dublin',
                        validFor: [103],
                        value: 'D'
                    },

                    {
                        attributes: null,
                        label: 'Durango',
                        validFor: [139],
                        value: 'DG'
                    },

                    {
                        attributes: null,
                        label: 'Enna',
                        validFor: [106],
                        value: 'EN'
                    },

                    {
                        attributes: null,
                        label: 'Espírito Santo',
                        validFor: [30],
                        value: 'ES'
                    },

                    {
                        attributes: null,
                        label: 'Federal District',
                        validFor: [139],
                        value: 'DF'
                    },

                    {
                        attributes: null,
                        label: 'Fermo',
                        validFor: [106],
                        value: 'FM'
                    },

                    {
                        attributes: null,
                        label: 'Ferrara',
                        validFor: [106],
                        value: 'FE'
                    },

                    {
                        attributes: null,
                        label: 'Florence',
                        validFor: [106],
                        value: 'FI'
                    },

                    {
                        attributes: null,
                        label: 'Florida',
                        validFor: [227],
                        value: 'FL'
                    },

                    {
                        attributes: null,
                        label: 'Foggia',
                        validFor: [106],
                        value: 'FG'
                    },

                    {
                        attributes: null,
                        label: 'Forlì-Cesena',
                        validFor: [106],
                        value: 'FC'
                    },

                    {
                        attributes: null,
                        label: 'Frosinone',
                        validFor: [106],
                        value: 'FR'
                    },

                    {
                        attributes: null,
                        label: 'Fujian',
                        validFor: [44],
                        value: '35'
                    },

                    {
                        attributes: null,
                        label: 'Galway',
                        validFor: [103],
                        value: 'G'
                    },

                    {
                        attributes: null,
                        label: 'Gansu',
                        validFor: [44],
                        value: '62'
                    },

                    {
                        attributes: null,
                        label: 'Genoa',
                        validFor: [106],
                        value: 'GE'
                    },

                    {
                        attributes: null,
                        label: 'Georgia',
                        validFor: [227],
                        value: 'GA'
                    },

                    {
                        attributes: null,
                        label: 'Goa',
                        validFor: [99],
                        value: 'GA'
                    },

                    {
                        attributes: null,
                        label: 'Goiás',
                        validFor: [30],
                        value: 'GO'
                    },

                    {
                        attributes: null,
                        label: 'Gorizia',
                        validFor: [106],
                        value: 'GO'
                    },

                    {
                        attributes: null,
                        label: 'Grosseto',
                        validFor: [106],
                        value: 'GR'
                    },

                    {
                        attributes: null,
                        label: 'Guanajuato',
                        validFor: [139],
                        value: 'GT'
                    },

                    {
                        attributes: null,
                        label: 'Guangdong',
                        validFor: [44],
                        value: '44'
                    },

                    {
                        attributes: null,
                        label: 'Guangxi',
                        validFor: [44],
                        value: '45'
                    },

                    {
                        attributes: null,
                        label: 'Guerrero',
                        validFor: [139],
                        value: 'GR'
                    },

                    {
                        attributes: null,
                        label: 'Guizhou',
                        validFor: [44],
                        value: '52'
                    },

                    {
                        attributes: null,
                        label: 'Gujarat',
                        validFor: [99],
                        value: 'GJ'
                    },

                    {
                        attributes: null,
                        label: 'Hainan',
                        validFor: [44],
                        value: '46'
                    },

                    {
                        attributes: null,
                        label: 'Haryana',
                        validFor: [99],
                        value: 'HR'
                    },

                    {
                        attributes: null,
                        label: 'Hawaii',
                        validFor: [227],
                        value: 'HI'
                    },

                    {
                        attributes: null,
                        label: 'Hebei',
                        validFor: [44],
                        value: '13'
                    },

                    {
                        attributes: null,
                        label: 'Heilongjiang',
                        validFor: [44],
                        value: '23'
                    },

                    {
                        attributes: null,
                        label: 'Henan',
                        validFor: [44],
                        value: '41'
                    },

                    {
                        attributes: null,
                        label: 'Hidalgo',
                        validFor: [139],
                        value: 'HG'
                    },

                    {
                        attributes: null,
                        label: 'Himachal Pradesh',
                        validFor: [99],
                        value: 'HP'
                    },

                    {
                        attributes: null,
                        label: 'Hong Kong',
                        validFor: [44],
                        value: '91'
                    },

                    {
                        attributes: null,
                        label: 'Hubei',
                        validFor: [44],
                        value: '42'
                    },

                    {
                        attributes: null,
                        label: 'Hunan',
                        validFor: [44],
                        value: '43'
                    },

                    {
                        attributes: null,
                        label: 'Idaho',
                        validFor: [227],
                        value: 'ID'
                    },

                    {
                        attributes: null,
                        label: 'Illinois',
                        validFor: [227],
                        value: 'IL'
                    },

                    {
                        attributes: null,
                        label: 'Imperia',
                        validFor: [106],
                        value: 'IM'
                    },

                    {
                        attributes: null,
                        label: 'Indiana',
                        validFor: [227],
                        value: 'IN'
                    },

                    {
                        attributes: null,
                        label: 'Iowa',
                        validFor: [227],
                        value: 'IA'
                    },

                    {
                        attributes: null,
                        label: 'Isernia',
                        validFor: [106],
                        value: 'IS'
                    },

                    {
                        attributes: null,
                        label: 'Jalisco',
                        validFor: [139],
                        value: 'JA'
                    },

                    {
                        attributes: null,
                        label: 'Jammu and Kashmir',
                        validFor: [99],
                        value: 'JK'
                    },

                    {
                        attributes: null,
                        label: 'Jharkhand',
                        validFor: [99],
                        value: 'JH'
                    },

                    {
                        attributes: null,
                        label: 'Jiangsu',
                        validFor: [44],
                        value: '32'
                    },

                    {
                        attributes: null,
                        label: 'Jiangxi',
                        validFor: [44],
                        value: '36'
                    },

                    {
                        attributes: null,
                        label: 'Jilin',
                        validFor: [44],
                        value: '22'
                    },

                    {
                        attributes: null,
                        label: 'Kansas',
                        validFor: [227],
                        value: 'KS'
                    },

                    {
                        attributes: null,
                        label: 'Karnataka',
                        validFor: [99],
                        value: 'KA'
                    },

                    {
                        attributes: null,
                        label: 'Kentucky',
                        validFor: [227],
                        value: 'KY'
                    },

                    {
                        attributes: null,
                        label: 'Kerala',
                        validFor: [99],
                        value: 'KL'
                    },

                    {
                        attributes: null,
                        label: 'Kerry',
                        validFor: [103],
                        value: 'KY'
                    },

                    {
                        attributes: null,
                        label: 'Kildare',
                        validFor: [103],
                        value: 'KE'
                    },

                    {
                        attributes: null,
                        label: 'Kilkenny',
                        validFor: [103],
                        value: 'KK'
                    },

                    {
                        attributes: null,
                        label: 'L&#39;Aquila',
                        validFor: [106],
                        value: 'AQ'
                    },

                    {
                        attributes: null,
                        label: 'Lakshadweep',
                        validFor: [99],
                        value: 'LD'
                    },

                    {
                        attributes: null,
                        label: 'Laois',
                        validFor: [103],
                        value: 'LS'
                    },

                    {
                        attributes: null,
                        label: 'La Spezia',
                        validFor: [106],
                        value: 'SP'
                    },

                    {
                        attributes: null,
                        label: 'Latina',
                        validFor: [106],
                        value: 'LT'
                    },

                    {
                        attributes: null,
                        label: 'Lecce',
                        validFor: [106],
                        value: 'LE'
                    },

                    {
                        attributes: null,
                        label: 'Lecco',
                        validFor: [106],
                        value: 'LC'
                    },

                    {
                        attributes: null,
                        label: 'Leitrim',
                        validFor: [103],
                        value: 'LM'
                    },

                    {
                        attributes: null,
                        label: 'Liaoning',
                        validFor: [44],
                        value: '21'
                    },

                    {
                        attributes: null,
                        label: 'Limerick',
                        validFor: [103],
                        value: 'LK'
                    },

                    {
                        attributes: null,
                        label: 'Livorno',
                        validFor: [106],
                        value: 'LI'
                    },

                    {
                        attributes: null,
                        label: 'Lodi',
                        validFor: [106],
                        value: 'LO'
                    },

                    {
                        attributes: null,
                        label: 'Longford',
                        validFor: [103],
                        value: 'LD'
                    },

                    {
                        attributes: null,
                        label: 'Louisiana',
                        validFor: [227],
                        value: 'LA'
                    },

                    {
                        attributes: null,
                        label: 'Louth',
                        validFor: [103],
                        value: 'LH'
                    },

                    {
                        attributes: null,
                        label: 'Lucca',
                        validFor: [106],
                        value: 'LU'
                    },

                    {
                        attributes: null,
                        label: 'Macao',
                        validFor: [44],
                        value: '92'
                    },

                    {
                        attributes: null,
                        label: 'Macerata',
                        validFor: [106],
                        value: 'MC'
                    },

                    {
                        attributes: null,
                        label: 'Madhya Pradesh',
                        validFor: [99],
                        value: 'MP'
                    },

                    {
                        attributes: null,
                        label: 'Maharashtra',
                        validFor: [99],
                        value: 'MH'
                    },

                    {
                        attributes: null,
                        label: 'Maine',
                        validFor: [227],
                        value: 'ME'
                    },

                    {
                        attributes: null,
                        label: 'Manipur',
                        validFor: [99],
                        value: 'MN'
                    },

                    {
                        attributes: null,
                        label: 'Manitoba',
                        validFor: [38],
                        value: 'MB'
                    },

                    {
                        attributes: null,
                        label: 'Mantua',
                        validFor: [106],
                        value: 'MN'
                    },

                    {
                        attributes: null,
                        label: 'Maranhão',
                        validFor: [30],
                        value: 'MA'
                    },

                    {
                        attributes: null,
                        label: 'Maryland',
                        validFor: [227],
                        value: 'MD'
                    },

                    {
                        attributes: null,
                        label: 'Massa and Carrara',
                        validFor: [106],
                        value: 'MS'
                    },

                    {
                        attributes: null,
                        label: 'Massachusetts',
                        validFor: [227],
                        value: 'MA'
                    },

                    {
                        attributes: null,
                        label: 'Matera',
                        validFor: [106],
                        value: 'MT'
                    },

                    {
                        attributes: null,
                        label: 'Mato Grosso',
                        validFor: [30],
                        value: 'MT'
                    },

                    {
                        attributes: null,
                        label: 'Mato Grosso do Sul',
                        validFor: [30],
                        value: 'MS'
                    },

                    {
                        attributes: null,
                        label: 'Mayo',
                        validFor: [103],
                        value: 'MO'
                    },

                    {
                        attributes: null,
                        label: 'Meath',
                        validFor: [103],
                        value: 'MH'
                    },

                    {
                        attributes: null,
                        label: 'Medio Campidano',
                        validFor: [106],
                        value: 'VS'
                    },

                    {
                        attributes: null,
                        label: 'Meghalaya',
                        validFor: [99],
                        value: 'ML'
                    },

                    {
                        attributes: null,
                        label: 'Messina',
                        validFor: [106],
                        value: 'ME'
                    },

                    {
                        attributes: null,
                        label: 'Mexico State',
                        validFor: [139],
                        value: 'ME'
                    },

                    {
                        attributes: null,
                        label: 'Michigan',
                        validFor: [227],
                        value: 'MI'
                    },

                    {
                        attributes: null,
                        label: 'Michoacán',
                        validFor: [139],
                        value: 'MI'
                    },

                    {
                        attributes: null,
                        label: 'Milan',
                        validFor: [106],
                        value: 'MI'
                    },

                    {
                        attributes: null,
                        label: 'Minas Gerais',
                        validFor: [30],
                        value: 'MG'
                    },

                    {
                        attributes: null,
                        label: 'Minnesota',
                        validFor: [227],
                        value: 'MN'
                    },

                    {
                        attributes: null,
                        label: 'Mississippi',
                        validFor: [227],
                        value: 'MS'
                    },

                    {
                        attributes: null,
                        label: 'Missouri',
                        validFor: [227],
                        value: 'MO'
                    },

                    {
                        attributes: null,
                        label: 'Mizoram',
                        validFor: [99],
                        value: 'MZ'
                    },

                    {
                        attributes: null,
                        label: 'Modena',
                        validFor: [106],
                        value: 'MO'
                    },

                    {
                        attributes: null,
                        label: 'Monaghan',
                        validFor: [103],
                        value: 'MN'
                    },

                    {
                        attributes: null,
                        label: 'Montana',
                        validFor: [227],
                        value: 'MT'
                    },

                    {
                        attributes: null,
                        label: 'Monza and Brianza',
                        validFor: [106],
                        value: 'MB'
                    },

                    {
                        attributes: null,
                        label: 'Morelos',
                        validFor: [139],
                        value: 'MO'
                    },

                    {
                        attributes: null,
                        label: 'Nagaland',
                        validFor: [99],
                        value: 'NL'
                    },

                    {
                        attributes: null,
                        label: 'Naples',
                        validFor: [106],
                        value: 'NA'
                    },

                    {
                        attributes: null,
                        label: 'Nayarit',
                        validFor: [139],
                        value: 'NA'
                    },

                    {
                        attributes: null,
                        label: 'Nebraska',
                        validFor: [227],
                        value: 'NE'
                    },

                    {
                        attributes: null,
                        label: 'Nei Mongol',
                        validFor: [44],
                        value: '15'
                    },

                    {
                        attributes: null,
                        label: 'Nevada',
                        validFor: [227],
                        value: 'NV'
                    },

                    {
                        attributes: null,
                        label: 'New Brunswick',
                        validFor: [38],
                        value: 'NB'
                    },

                    {
                        attributes: null,
                        label: 'Newfoundland and Labrador',
                        validFor: [38],
                        value: 'NL'
                    },

                    {
                        attributes: null,
                        label: 'New Hampshire',
                        validFor: [227],
                        value: 'NH'
                    },

                    {
                        attributes: null,
                        label: 'New Jersey',
                        validFor: [227],
                        value: 'NJ'
                    },

                    {
                        attributes: null,
                        label: 'New Mexico',
                        validFor: [227],
                        value: 'NM'
                    },

                    {
                        attributes: null,
                        label: 'New South Wales',
                        validFor: [12],
                        value: 'NSW'
                    },

                    {
                        attributes: null,
                        label: 'New York',
                        validFor: [227],
                        value: 'NY'
                    },

                    {
                        attributes: null,
                        label: 'Ningxia',
                        validFor: [44],
                        value: '64'
                    },

                    {
                        attributes: null,
                        label: 'North Carolina',
                        validFor: [227],
                        value: 'NC'
                    },

                    {
                        attributes: null,
                        label: 'North Dakota',
                        validFor: [227],
                        value: 'ND'
                    },

                    {
                        attributes: null,
                        label: 'Northern Territory',
                        validFor: [12],
                        value: 'NT'
                    },

                    {
                        attributes: null,
                        label: 'Northwest Territories',
                        validFor: [38],
                        value: 'NT'
                    },

                    {
                        attributes: null,
                        label: 'Novara',
                        validFor: [106],
                        value: 'NO'
                    },

                    {
                        attributes: null,
                        label: 'Nova Scotia',
                        validFor: [38],
                        value: 'NS'
                    },

                    {
                        attributes: null,
                        label: 'Nuevo León',
                        validFor: [139],
                        value: 'NL'
                    },

                    {
                        attributes: null,
                        label: 'Nunavut',
                        validFor: [38],
                        value: 'NU'
                    },

                    {
                        attributes: null,
                        label: 'Nuoro',
                        validFor: [106],
                        value: 'NU'
                    },

                    {
                        attributes: null,
                        label: 'Oaxaca',
                        validFor: [139],
                        value: 'OA'
                    },

                    {
                        attributes: null,
                        label: 'Odisha',
                        validFor: [99],
                        value: 'OR'
                    },

                    {
                        attributes: null,
                        label: 'Offaly',
                        validFor: [103],
                        value: 'OY'
                    },

                    {
                        attributes: null,
                        label: 'Ogliastra',
                        validFor: [106],
                        value: 'OG'
                    },

                    {
                        attributes: null,
                        label: 'Ohio',
                        validFor: [227],
                        value: 'OH'
                    },

                    {
                        attributes: null,
                        label: 'Oklahoma',
                        validFor: [227],
                        value: 'OK'
                    },

                    {
                        attributes: null,
                        label: 'Olbia-Tempio',
                        validFor: [106],
                        value: 'OT'
                    },

                    {
                        attributes: null,
                        label: 'Ontario',
                        validFor: [38],
                        value: 'ON'
                    },

                    {
                        attributes: null,
                        label: 'Oregon',
                        validFor: [227],
                        value: 'OR'
                    },

                    {
                        attributes: null,
                        label: 'Oristano',
                        validFor: [106],
                        value: 'OR'
                    },

                    {
                        attributes: null,
                        label: 'Padua',
                        validFor: [106],
                        value: 'PD'
                    },

                    {
                        attributes: null,
                        label: 'Palermo',
                        validFor: [106],
                        value: 'PA'
                    },

                    {
                        attributes: null,
                        label: 'Pará',
                        validFor: [30],
                        value: 'PA'
                    },

                    {
                        attributes: null,
                        label: 'Paraíba',
                        validFor: [30],
                        value: 'PB'
                    },

                    {
                        attributes: null,
                        label: 'Paraná',
                        validFor: [30],
                        value: 'PR'
                    },

                    {
                        attributes: null,
                        label: 'Parma',
                        validFor: [106],
                        value: 'PR'
                    },

                    {
                        attributes: null,
                        label: 'Pavia',
                        validFor: [106],
                        value: 'PV'
                    },

                    {
                        attributes: null,
                        label: 'Pennsylvania',
                        validFor: [227],
                        value: 'PA'
                    },

                    {
                        attributes: null,
                        label: 'Pernambuco',
                        validFor: [30],
                        value: 'PE'
                    },

                    {
                        attributes: null,
                        label: 'Perugia',
                        validFor: [106],
                        value: 'PG'
                    },

                    {
                        attributes: null,
                        label: 'Pesaro and Urbino',
                        validFor: [106],
                        value: 'PU'
                    },

                    {
                        attributes: null,
                        label: 'Pescara',
                        validFor: [106],
                        value: 'PE'
                    },

                    {
                        attributes: null,
                        label: 'Piacenza',
                        validFor: [106],
                        value: 'PC'
                    },

                    {
                        attributes: null,
                        label: 'Piauí',
                        validFor: [30],
                        value: 'PI'
                    },

                    {
                        attributes: null,
                        label: 'Pisa',
                        validFor: [106],
                        value: 'PI'
                    },

                    {
                        attributes: null,
                        label: 'Pistoia',
                        validFor: [106],
                        value: 'PT'
                    },

                    {
                        attributes: null,
                        label: 'Pordenone',
                        validFor: [106],
                        value: 'PN'
                    },

                    {
                        attributes: null,
                        label: 'Potenza',
                        validFor: [106],
                        value: 'PZ'
                    },

                    {
                        attributes: null,
                        label: 'Prato',
                        validFor: [106],
                        value: 'PO'
                    },

                    {
                        attributes: null,
                        label: 'Prince Edward Island',
                        validFor: [38],
                        value: 'PE'
                    },

                    {
                        attributes: null,
                        label: 'Puducherry',
                        validFor: [99],
                        value: 'PY'
                    },

                    {
                        attributes: null,
                        label: 'Puebla',
                        validFor: [139],
                        value: 'PB'
                    },

                    {
                        attributes: null,
                        label: 'Punjab',
                        validFor: [99],
                        value: 'PB'
                    },

                    {
                        attributes: null,
                        label: 'Qinghai',
                        validFor: [44],
                        value: '63'
                    },

                    {
                        attributes: null,
                        label: 'Quebec',
                        validFor: [38],
                        value: 'QC'
                    },

                    {
                        attributes: null,
                        label: 'Queensland',
                        validFor: [12],
                        value: 'QLD'
                    },

                    {
                        attributes: null,
                        label: 'Querétaro',
                        validFor: [139],
                        value: 'QE'
                    },

                    {
                        attributes: null,
                        label: 'Quintana Roo',
                        validFor: [139],
                        value: 'QR'
                    },

                    {
                        attributes: null,
                        label: 'Ragusa',
                        validFor: [106],
                        value: 'RG'
                    },

                    {
                        attributes: null,
                        label: 'Rajasthan',
                        validFor: [99],
                        value: 'RJ'
                    },

                    {
                        attributes: null,
                        label: 'Ravenna',
                        validFor: [106],
                        value: 'RA'
                    },

                    {
                        attributes: null,
                        label: 'Reggio Calabria',
                        validFor: [106],
                        value: 'RC'
                    },

                    {
                        attributes: null,
                        label: 'Reggio Emilia',
                        validFor: [106],
                        value: 'RE'
                    },

                    {
                        attributes: null,
                        label: 'Rhode Island',
                        validFor: [227],
                        value: 'RI'
                    },

                    {
                        attributes: null,
                        label: 'Rieti',
                        validFor: [106],
                        value: 'RI'
                    },

                    {
                        attributes: null,
                        label: 'Rimini',
                        validFor: [106],
                        value: 'RN'
                    },

                    {
                        attributes: null,
                        label: 'Rio de Janeiro',
                        validFor: [30],
                        value: 'RJ'
                    },

                    {
                        attributes: null,
                        label: 'Rio Grande do Norte',
                        validFor: [30],
                        value: 'RN'
                    },

                    {
                        attributes: null,
                        label: 'Rio Grande do Sul',
                        validFor: [30],
                        value: 'RS'
                    },

                    {
                        attributes: null,
                        label: 'Rome',
                        validFor: [106],
                        value: 'RM'
                    },

                    {
                        attributes: null,
                        label: 'Rondônia',
                        validFor: [30],
                        value: 'RO'
                    },

                    {
                        attributes: null,
                        label: 'Roraima',
                        validFor: [30],
                        value: 'RR'
                    },

                    {
                        attributes: null,
                        label: 'Roscommon',
                        validFor: [103],
                        value: 'RN'
                    },

                    {
                        attributes: null,
                        label: 'Rovigo',
                        validFor: [106],
                        value: 'RO'
                    },

                    {
                        attributes: null,
                        label: 'Salerno',
                        validFor: [106],
                        value: 'SA'
                    },

                    {
                        attributes: null,
                        label: 'San Luis Potosí',
                        validFor: [139],
                        value: 'SL'
                    },

                    {
                        attributes: null,
                        label: 'Santa Catarina',
                        validFor: [30],
                        value: 'SC'
                    },

                    {
                        attributes: null,
                        label: 'São Paulo',
                        validFor: [30],
                        value: 'SP'
                    },

                    {
                        attributes: null,
                        label: 'Saskatchewan',
                        validFor: [38],
                        value: 'SK'
                    },

                    {
                        attributes: null,
                        label: 'Sassari',
                        validFor: [106],
                        value: 'SS'
                    },

                    {
                        attributes: null,
                        label: 'Savona',
                        validFor: [106],
                        value: 'SV'
                    },

                    {
                        attributes: null,
                        label: 'Sergipe',
                        validFor: [30],
                        value: 'SE'
                    },

                    {
                        attributes: null,
                        label: 'Shaanxi',
                        validFor: [44],
                        value: '61'
                    },

                    {
                        attributes: null,
                        label: 'Shandong',
                        validFor: [44],
                        value: '37'
                    },

                    {
                        attributes: null,
                        label: 'Shanghai',
                        validFor: [44],
                        value: '31'
                    },

                    {
                        attributes: null,
                        label: 'Shanxi',
                        validFor: [44],
                        value: '14'
                    },

                    {
                        attributes: null,
                        label: 'Sichuan',
                        validFor: [44],
                        value: '51'
                    },

                    {
                        attributes: null,
                        label: 'Siena',
                        validFor: [106],
                        value: 'SI'
                    },

                    {
                        attributes: null,
                        label: 'Sikkim',
                        validFor: [99],
                        value: 'SK'
                    },

                    {
                        attributes: null,
                        label: 'Sinaloa',
                        validFor: [139],
                        value: 'SI'
                    },

                    {
                        attributes: null,
                        label: 'Sligo',
                        validFor: [103],
                        value: 'SO'
                    },

                    {
                        attributes: null,
                        label: 'Sondrio',
                        validFor: [106],
                        value: 'SO'
                    },

                    {
                        attributes: null,
                        label: 'Sonora',
                        validFor: [139],
                        value: 'SO'
                    },

                    {
                        attributes: null,
                        label: 'South Australia',
                        validFor: [12],
                        value: 'SA'
                    },

                    {
                        attributes: null,
                        label: 'South Carolina',
                        validFor: [227],
                        value: 'SC'
                    },

                    {
                        attributes: null,
                        label: 'South Dakota',
                        validFor: [227],
                        value: 'SD'
                    },

                    {
                        attributes: null,
                        label: 'Syracuse',
                        validFor: [106],
                        value: 'SR'
                    },

                    {
                        attributes: null,
                        label: 'Tabasco',
                        validFor: [139],
                        value: 'TB'
                    },

                    {
                        attributes: null,
                        label: 'Taiwan',
                        validFor: [44],
                        value: '71'
                    },

                    {
                        attributes: null,
                        label: 'Tamaulipas',
                        validFor: [139],
                        value: 'TM'
                    },

                    {
                        attributes: null,
                        label: 'Tamil Nadu',
                        validFor: [99],
                        value: 'TN'
                    },

                    {
                        attributes: null,
                        label: 'Taranto',
                        validFor: [106],
                        value: 'TA'
                    },

                    {
                        attributes: null,
                        label: 'Tasmania',
                        validFor: [12],
                        value: 'TAS'
                    },

                    {
                        attributes: null,
                        label: 'Tennessee',
                        validFor: [227],
                        value: 'TN'
                    },

                    {
                        attributes: null,
                        label: 'Teramo',
                        validFor: [106],
                        value: 'TE'
                    },

                    {
                        attributes: null,
                        label: 'Terni',
                        validFor: [106],
                        value: 'TR'
                    },

                    {
                        attributes: null,
                        label: 'Texas',
                        validFor: [227],
                        value: 'TX'
                    },

                    {
                        attributes: null,
                        label: 'Tianjin',
                        validFor: [44],
                        value: '12'
                    },

                    {
                        attributes: null,
                        label: 'Tipperary',
                        validFor: [103],
                        value: 'TA'
                    },

                    {
                        attributes: null,
                        label: 'Tlaxcala',
                        validFor: [139],
                        value: 'TL'
                    },

                    {
                        attributes: null,
                        label: 'Tocantins',
                        validFor: [30],
                        value: 'TO'
                    },

                    {
                        attributes: null,
                        label: 'Trapani',
                        validFor: [106],
                        value: 'TP'
                    },

                    {
                        attributes: null,
                        label: 'Trento',
                        validFor: [106],
                        value: 'TN'
                    },

                    {
                        attributes: null,
                        label: 'Treviso',
                        validFor: [106],
                        value: 'TV'
                    },

                    {
                        attributes: null,
                        label: 'Trieste',
                        validFor: [106],
                        value: 'TS'
                    },

                    {
                        attributes: null,
                        label: 'Tripura',
                        validFor: [99],
                        value: 'TR'
                    },

                    {
                        attributes: null,
                        label: 'Turin',
                        validFor: [106],
                        value: 'TO'
                    },

                    {
                        attributes: null,
                        label: 'Udine',
                        validFor: [106],
                        value: 'UD'
                    },

                    {
                        attributes: null,
                        label: 'Utah',
                        validFor: [227],
                        value: 'UT'
                    },

                    {
                        attributes: null,
                        label: 'Uttarakhand',
                        validFor: [99],
                        value: 'UT'
                    },

                    {
                        attributes: null,
                        label: 'Uttar Pradesh',
                        validFor: [99],
                        value: 'UP'
                    },

                    {
                        attributes: null,
                        label: 'Varese',
                        validFor: [106],
                        value: 'VA'
                    },

                    {
                        attributes: null,
                        label: 'Venice',
                        validFor: [106],
                        value: 'VE'
                    },

                    {
                        attributes: null,
                        label: 'Veracruz',
                        validFor: [139],
                        value: 'VE'
                    },

                    {
                        attributes: null,
                        label: 'Verbano-Cusio-Ossola',
                        validFor: [106],
                        value: 'VB'
                    },

                    {
                        attributes: null,
                        label: 'Vercelli',
                        validFor: [106],
                        value: 'VC'
                    },

                    {
                        attributes: null,
                        label: 'Vermont',
                        validFor: [227],
                        value: 'VT'
                    },

                    {
                        attributes: null,
                        label: 'Verona',
                        validFor: [106],
                        value: 'VR'
                    },

                    {
                        attributes: null,
                        label: 'Vibo Valentia',
                        validFor: [106],
                        value: 'VV'
                    },

                    {
                        attributes: null,
                        label: 'Vicenza',
                        validFor: [106],
                        value: 'VI'
                    },

                    {
                        attributes: null,
                        label: 'Victoria',
                        validFor: [12],
                        value: 'VIC'
                    },

                    {
                        attributes: null,
                        label: 'Virginia',
                        validFor: [227],
                        value: 'VA'
                    },

                    {
                        attributes: null,
                        label: 'Viterbo',
                        validFor: [106],
                        value: 'VT'
                    },

                    {
                        attributes: null,
                        label: 'Washington',
                        validFor: [227],
                        value: 'WA'
                    },

                    {
                        attributes: null,
                        label: 'Waterford',
                        validFor: [103],
                        value: 'WD'
                    },

                    {
                        attributes: null,
                        label: 'West Bengal',
                        validFor: [99],
                        value: 'WB'
                    },

                    {
                        attributes: null,
                        label: 'Western Australia',
                        validFor: [12],
                        value: 'WA'
                    },

                    {
                        attributes: null,
                        label: 'Westmeath',
                        validFor: [103],
                        value: 'WH'
                    },

                    {
                        attributes: null,
                        label: 'West Virginia',
                        validFor: [227],
                        value: 'WV'
                    },

                    {
                        attributes: null,
                        label: 'Wexford',
                        validFor: [103],
                        value: 'WX'
                    },

                    {
                        attributes: null,
                        label: 'Wicklow',
                        validFor: [103],
                        value: 'WW'
                    },

                    {
                        attributes: null,
                        label: 'Wisconsin',
                        validFor: [227],
                        value: 'WI'
                    },

                    {
                        attributes: null,
                        label: 'Wyoming',
                        validFor: [227],
                        value: 'WY'
                    },

                    {
                        attributes: null,
                        label: 'Xinjiang',
                        validFor: [44],
                        value: '65'
                    },

                    {
                        attributes: null,
                        label: 'Xizang',
                        validFor: [44],
                        value: '54'
                    },

                    {
                        attributes: null,
                        label: 'Yucatán',
                        validFor: [139],
                        value: 'YU'
                    },

                    {
                        attributes: null,
                        label: 'Yukon Territories',
                        validFor: [38],
                        value: 'YT'
                    },

                    {
                        attributes: null,
                        label: 'Yunnan',
                        validFor: [44],
                        value: '53'
                    },

                    {
                        attributes: null,
                        label: 'Zacatecas',
                        validFor: [139],
                        value: 'ZA'
                    },

                    {
                        attributes: null,
                        label: 'Zhejiang',
                        validFor: [44],
                        value: '33'
                    }
                ]
            },

            GeocodeAccuracy: {
                controllerValues: {},
                defaultValue: null,
                url:
                    '/services/data/v42.0/ui-api/object-info/Account/picklist-values/012000000000000AAA/BillingGeocodeAccuracy',
                values: [
                    {
                        attributes: null,
                        label: 'Address',
                        validFor: [],
                        value: 'Address'
                    },

                    {
                        attributes: null,
                        label: 'NearAddress',
                        validFor: [],
                        value: 'NearAddress'
                    },

                    {
                        attributes: null,
                        label: 'Block',
                        validFor: [],
                        value: 'Block'
                    },

                    {
                        attributes: null,
                        label: 'Street',
                        validFor: [],
                        value: 'Street'
                    },

                    {
                        attributes: null,
                        label: 'ExtendedZip',
                        validFor: [],
                        value: 'ExtendedZip'
                    },

                    {
                        attributes: null,
                        label: 'Zip',
                        validFor: [],
                        value: 'Zip'
                    },

                    {
                        attributes: null,
                        label: 'Neighborhood',
                        validFor: [],
                        value: 'Neighborhood'
                    },

                    {
                        attributes: null,
                        label: 'City',
                        validFor: [],
                        value: 'City'
                    },

                    {
                        attributes: null,
                        label: 'County',
                        validFor: [],
                        value: 'County'
                    },

                    {
                        attributes: null,
                        label: 'State',
                        validFor: [],
                        value: 'State'
                    },

                    {
                        attributes: null,
                        label: 'Unknown',
                        validFor: [],
                        value: 'Unknown'
                    }
                ]
            }
        }
    }
};
