/*
 * Copyright (c) 2019, salesforce.com, inc.
 * All rights reserved.
 * SPDX-License-Identifier: MIT
 * For full license text, see the LICENSE file in the repo root or https://opensource.org/licenses/MIT
 */

export const ACTIONS_GLOBAL = {
    actions: {
        Global: {
            actions: [
                {
                    actionListContext: 'Dockable',
                    actionTarget:
                        '/services/data/v41.0/quickActions/NewEvent/describe',
                    actionTargetType: 'Describe',
                    apiName: 'NewEvent',
                    externalId:
                        '00Dxx0000001gGI:Global::Dockable:Desktop:09Dxx0000000070',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_event_120.png',
                    id: '0JVxx0000000241GAA',
                    isMassAction: 'false',
                    label: 'New Event',
                    primaryColor: 'EB7092',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: null,
                    sourceObject: 'Global',
                    subtype: 'Create',
                    targetObject: 'Event',
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Dockable',
                    actionTarget:
                        '/services/data/v41.0/quickActions/NewTask/describe',
                    actionTargetType: 'Describe',
                    apiName: 'NewTask',
                    externalId:
                        '00Dxx0000001gGI:Global::Dockable:Desktop:09Dxx000000006y',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_task_120.png',
                    id: '0JVxx0000000242GAA',
                    isMassAction: 'false',
                    label: 'New Task',
                    primaryColor: '4BC076',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: null,
                    sourceObject: 'Global',
                    subtype: 'Create',
                    targetObject: 'Task',
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Dockable',
                    actionTarget:
                        '/services/data/v41.0/quickActions/NewContact/describe',
                    actionTargetType: 'Describe',
                    apiName: 'NewContact',
                    externalId:
                        '00Dxx0000001gGI:Global::Dockable:Desktop:09Dxx000000006b',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_contact_120.png',
                    id: '0JVxx0000000243GAA',
                    isMassAction: 'false',
                    label: 'New Contact',
                    primaryColor: 'A094ED',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: null,
                    sourceObject: 'Global',
                    subtype: 'Create',
                    targetObject: 'Contact',
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Dockable',
                    actionTarget:
                        '/services/data/v41.0/quickActions/LogACall/describe',
                    actionTargetType: 'Describe',
                    apiName: 'LogACall',
                    externalId:
                        '00Dxx0000001gGI:Global::Dockable:Desktop:09Dxx000000006z',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/log_a_call_120.png',
                    id: '0JVxx0000000244GAA',
                    isMassAction: 'false',
                    label: 'Log a Call',
                    primaryColor: '48C3CC',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: null,
                    sourceObject: 'Global',
                    subtype: 'LogACall',
                    targetObject: 'Task',
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Dockable',
                    actionTarget:
                        '/services/data/v41.0/quickActions/NewOpportunity/describe',
                    actionTargetType: 'Describe',
                    apiName: 'NewOpportunity',
                    externalId:
                        '00Dxx0000001gGI:Global::Dockable:Desktop:09Dxx000000006d',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_opportunity_120.png',
                    id: '0JVxx0000000245GAA',
                    isMassAction: 'false',
                    label: 'New Opportunity',
                    primaryColor: 'FCB95B',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: null,
                    sourceObject: 'Global',
                    subtype: 'Create',
                    targetObject: 'Opportunity',
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Dockable',
                    actionTarget:
                        '/services/data/v41.0/quickActions/NewCase/describe',
                    actionTargetType: 'Describe',
                    apiName: 'NewCase',
                    externalId:
                        '00Dxx0000001gGI:Global::Dockable:Desktop:09Dxx000000006s',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_case_120.png',
                    id: '0JVxx0000000246GAA',
                    isMassAction: 'false',
                    label: 'New Case',
                    primaryColor: 'F2CF5B',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: null,
                    sourceObject: 'Global',
                    subtype: 'Create',
                    targetObject: 'Case',
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Dockable',
                    actionTarget:
                        '/services/data/v41.0/quickActions/NewLead/describe',
                    actionTargetType: 'Describe',
                    apiName: 'NewLead',
                    externalId:
                        '00Dxx0000001gGI:Global::Dockable:Desktop:09Dxx000000006c',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_lead_120.png',
                    id: '0JVxx0000000247GAA',
                    isMassAction: 'false',
                    label: 'New Lead',
                    primaryColor: 'F88962',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: null,
                    sourceObject: 'Global',
                    subtype: 'Create',
                    targetObject: 'Lead',
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Dockable',
                    actionTarget: null,
                    actionTargetType: null,
                    apiName: 'FeedItem.ContentNote',
                    externalId:
                        '00Dxx0000001gGI:Global::Dockable:Desktop:FeedItem.ContentNote',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_note_120.png',
                    id: '0JVxx0000000248GAA',
                    isMassAction: 'false',
                    label: 'New Note',
                    primaryColor: 'E6D478',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: null,
                    sourceObject: 'Global',
                    subtype: 'Post',
                    targetObject: null,
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Dockable',
                    actionTarget:
                        '/services/data/v41.0/quickActions/SendEmail/describe',
                    actionTargetType: 'Describe',
                    apiName: 'SendEmail',
                    externalId:
                        '00Dxx0000001gGI:Global::Dockable:Desktop:09Dxx0000000071',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/email_120.png',
                    id: '0JVxx0000000249GAA',
                    isMassAction: 'false',
                    label: 'Email',
                    primaryColor: '95AEC5',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: null,
                    sourceObject: 'Global',
                    subtype: 'SendEmail',
                    targetObject: 'OutgoingEmail',
                    targetUrl: null,
                    type: 'QuickAction'
                }
            ],

            links: [],
            url: '/services/data/v41.0/ui-api/actions/global'
        }
    },

    url: '/services/data/v41.0/ui-api/actions/global'
};

export const ACTIONS_LISTVIEWCHARTINSTANCE = {
    actions: {
        ListViewChartInstance: {
            actions: [
                {
                    actionListContext: 'ObjectHomeChart',
                    actionTarget: null,
                    actionTargetType: null,
                    apiName: 'NewObjectHomeChartAction',
                    externalId:
                        '00Dxx0000001gGI:ListViewChartInstance::ObjectHomeChart:Desktop:StandardButton:NewObjectHomeChartAction',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_custom19_120.png',
                    id: '0JVxx0000000308GAA',
                    isMassAction: 'false',
                    label: 'New Chart',
                    primaryColor: null,
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: 'ListViewChartInstance',
                    subtype: null,
                    targetObject: 'ListViewChart',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'ObjectHomeChart',
                    actionTarget: null,
                    actionTargetType: null,
                    apiName: 'EditObjectHomeChartAction',
                    externalId:
                        '00Dxx0000001gGI:ListViewChartInstance::ObjectHomeChart:Desktop:StandardButton:EditObjectHomeChartAction',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_custom19_120.png',
                    id: '0JVxx0000000309GAA',
                    isMassAction: 'false',
                    label: 'Edit Chart',
                    primaryColor: null,
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: 'ListViewChartInstance',
                    subtype: null,
                    targetObject: 'ListViewChart',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'ObjectHomeChart',
                    actionTarget: null,
                    actionTargetType: null,
                    apiName: 'DeleteObjectHomeChartAction',
                    externalId:
                        '00Dxx0000001gGI:ListViewChartInstance::ObjectHomeChart:Desktop:StandardButton:DeleteObjectHomeChartAction',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_custom19_120.png',
                    id: '0JVxx0000000310GAA',
                    isMassAction: 'false',
                    label: 'Delete Chart',
                    primaryColor: null,
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: 'ListViewChartInstance',
                    subtype: null,
                    targetObject: 'ListViewChart',
                    targetUrl: null,
                    type: 'StandardButton'
                }
            ],

            links: [],
            url:
                '/services/data/v41.0/ui-api/actions/list-view-chart/ListViewChartInstance'
        }
    },

    url:
        '/services/data/v41.0/ui-api/actions/list-view-chart/ListViewChartInstance'
};

export const ACTIONS_LISTVIEW = {
    actions: {
        '00Bxx0000024qHzEAI': {
            actions: [
                {
                    actionListContext: 'ListView',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'EditFilter',
                    externalId:
                        '00Dxx0000001gGI:00Bxx0000024qHzEAI::ListView:Desktop:StandardButton:EditFilter',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/filter_120.png',
                    id: '0JVxx0000000286GAA',
                    isMassAction: 'false',
                    label: 'Filter',
                    primaryColor: '54698d',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: '00Bxx0000024qHzEAI',
                    subtype: null,
                    targetObject: 'Campaign',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'ListView',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'ListSort',
                    externalId:
                        '00Dxx0000001gGI:00Bxx0000024qHzEAI::ListView:Desktop:StandardButton:ListSort',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/sort_120.png',
                    id: '0JVxx0000000287GAA',
                    isMassAction: 'false',
                    label: 'Sort',
                    primaryColor: 'FAB9A5',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: '00Bxx0000024qHzEAI',
                    subtype: null,
                    targetObject: 'Campaign',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'ListView',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'New',
                    externalId:
                        '00Dxx0000001gGI:00Bxx0000024qHzEAI::ListView:Desktop:StandardButton:New',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_120.png',
                    id: '0JVxx0000000288GAA',
                    isMassAction: 'false',
                    label: 'New',
                    primaryColor: '33BCE7',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: '00Bxx0000024qHzEAI',
                    subtype: null,
                    targetObject: 'Campaign',
                    targetUrl: null,
                    type: 'StandardButton'
                }
            ],

            links: [],
            url:
                '/services/data/v41.0/ui-api/actions/list-view/00Bxx0000024qHzEAI'
        }
    },

    url: '/services/data/v41.0/ui-api/actions/list-view/00Bxx0000024qHzEAI'
};

export const ACTIONS_LISTVIEWRECORD = {
    actions: {
        '001xx000003DGZnAAO': {
            actions: [
                {
                    actionListContext: 'ListViewRecord',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'Edit',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::ListViewRecord:Desktop:StandardButton:Edit',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/edit_120.png',
                    id: '0JVxx0000000306GAA',
                    isMassAction: 'false',
                    label: 'Edit',
                    primaryColor: '1DCCBF',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'Account',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'ListViewRecord',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'Delete',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::ListViewRecord:Desktop:StandardButton:Delete',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/delete_120.png',
                    id: '0JVxx0000000307GAA',
                    isMassAction: 'false',
                    label: 'Delete',
                    primaryColor: 'E6717C',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'Account',
                    targetUrl: null,
                    type: 'StandardButton'
                }
            ],

            links: [],
            url:
                '/services/data/v41.0/ui-api/actions/list-view-record/001xx000003DGZnAAO'
        }
    },

    url:
        '/services/data/v41.0/ui-api/actions/list-view-record/001xx000003DGZnAAO'
};

export const ACTIONS_LOOKUP = {
    actions: {
        Weapon__c: {
            actions: [
                {
                    actionListContext: 'Lookup',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'CreateFromLookup',
                    externalId:
                        '00DR00000009G5b:Weapon__c::Lookup:Desktop:StandardButton:CreateFromLookup',
                    iconUrl:
                        'https://mobile1.t.salesforce.com/img/icon/t4v35/action/new_120.png',
                    id: '0JVR00000010272OAA',
                    isMassAction: 'false',
                    label: 'New',
                    primaryColor: '33BCE7',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: 'Weapon__c',
                    subtype: null,
                    targetObject: 'Weapon__c',
                    targetUrl: null,
                    type: 'StandardButton'
                }
            ],

            links: [],
            url: '/services/data/v41.0/ui-api/actions/lookup/Weapon__c'
        },

        Bad_Guy__c: {
            actions: [
                {
                    actionListContext: 'Lookup',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'CreateFromLookup',
                    externalId:
                        '00DR00000009G5b:Bad_Guy__c::Lookup:Desktop:StandardButton:CreateFromLookup',
                    iconUrl:
                        'https://mobile1.t.salesforce.com/img/icon/t4v35/action/new_120.png',
                    id: '0JVR00000010273OAA',
                    isMassAction: 'false',
                    label: 'New',
                    primaryColor: '33BCE7',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: 'Bad_Guy__c',
                    subtype: null,
                    targetObject: 'Bad_Guy__c',
                    targetUrl: null,
                    type: 'StandardButton'
                }
            ],

            links: [],
            url: '/services/data/v41.0/ui-api/actions/lookup/Bad_Guy__c'
        }
    },

    url: '/services/data/v41.0/ui-api/actions/lookup/Bad_Guy__c,Weapon__c,Group'
};

export const ACTIONS_MRULIST = {
    actions: {
        Account: {
            actions: [
                {
                    actionListContext: 'MruList',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'New',
                    externalId:
                        '00Dxx0000001gGI:Account::MruList:Desktop:StandardButton:New',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_120.png',
                    id: '0JVxx0000000312GAA',
                    isMassAction: 'false',
                    label: 'New',
                    primaryColor: '33BCE7',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: 'Account',
                    subtype: null,
                    targetObject: 'Account',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'MruList',
                    actionTarget: null,
                    actionTargetType: null,
                    apiName: 'MruListSort',
                    externalId:
                        '00Dxx0000001gGI:Account::MruList:Desktop:StandardButton:MruListSort',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/sort_120.png',
                    id: '0JVxx0000000313GAA',
                    isMassAction: 'false',
                    label: 'Sort',
                    primaryColor: 'FAB9A5',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: 'Account',
                    subtype: null,
                    targetObject: 'Account',
                    targetUrl: null,
                    type: 'StandardButton'
                }
            ],

            links: [],
            url: '/services/data/v41.0/ui-api/actions/mru-list/Account'
        }
    },

    url: '/services/data/v41.0/ui-api/actions/mru-list/Account'
};

export const ACTIONS_RECORDDETAIL = {
    actions: {
        '001xx000003DGZnAAO': {
            actions: [
                {
                    actionListContext: 'Chatter',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'Follow',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::Chatter:Desktop:StandardButton:Follow',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/follow_120.png',
                    id: '0JVxx0000000250GAA',
                    isMassAction: 'false',
                    label: 'Follow',
                    primaryColor: '31B9F8',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'SingleActionLinks',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'Account',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'Chatter',
                    actionTarget: null,
                    actionTargetType: null,
                    apiName: 'FollowInStream',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::Chatter:Desktop:StandardButton:FollowInStream',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/follow_120.png',
                    id: '0JVxx0000000251GAA',
                    isMassAction: 'false',
                    label: 'Follow in Stream',
                    primaryColor: '31B9F8',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'SingleActionLinks',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'Account',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'Record',
                    actionTarget:
                        '/services/data/v41.0/quickActions/NewTask/describe',
                    actionTargetType: 'Describe',
                    apiName: 'NewTask',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::Record:Desktop:09Dxx000000006y',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_task_120.png',
                    id: '0JVxx0000000252GAA',
                    isMassAction: 'false',
                    label: 'New Task',
                    primaryColor: '4BC076',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'ActivityComposer',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: 'Create',
                    targetObject: 'Task',
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Record',
                    actionTarget:
                        '/services/data/v41.0/quickActions/NewEvent/describe',
                    actionTargetType: 'Describe',
                    apiName: 'NewEvent',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::Record:Desktop:09Dxx0000000070',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_event_120.png',
                    id: '0JVxx0000000253GAA',
                    isMassAction: 'false',
                    label: 'New Event',
                    primaryColor: 'EB7092',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'ActivityComposer',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: 'Create',
                    targetObject: 'Event',
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Record',
                    actionTarget: null,
                    actionTargetType: null,
                    apiName: 'FeedItem.TextPost',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::Record:Desktop:FeedItem.TextPost',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/share_post_120.png',
                    id: '0JVxx0000000254GAA',
                    isMassAction: 'false',
                    label: 'Post',
                    primaryColor: '65CAE4',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'CollaborateComposer',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: 'Post',
                    targetObject: null,
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Record',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'Edit',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::Record:Desktop:StandardButton:Edit',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/edit_120.png',
                    id: '0JVxx0000000255GAA',
                    isMassAction: 'false',
                    label: 'Edit',
                    primaryColor: '1DCCBF',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'Account',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'Record',
                    actionTarget: null,
                    actionTargetType: null,
                    apiName: 'FeedItem.ContentPost',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::Record:Desktop:FeedItem.ContentPost',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/share_file_120.png',
                    id: '0JVxx0000000256GAA',
                    isMassAction: 'false',
                    label: 'File',
                    primaryColor: 'BAAC93',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: null,
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: 'Post',
                    targetObject: null,
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Record',
                    actionTarget:
                        '/services/data/v41.0/quickActions/SendEmail/describe',
                    actionTargetType: 'Describe',
                    apiName: 'SendEmail',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::Record:Desktop:09Dxx0000000071',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/email_120.png',
                    id: '0JVxx0000000257GAA',
                    isMassAction: 'false',
                    label: 'Email',
                    primaryColor: '95AEC5',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'ActivityComposer',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: 'SendEmail',
                    targetObject: 'OutgoingEmail',
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Record',
                    actionTarget:
                        '/services/data/v41.0/quickActions/NewContact/describe',
                    actionTargetType: 'Describe',
                    apiName: 'NewContact',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::Record:Desktop:09Dxx000000006b',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_contact_120.png',
                    id: '0JVxx0000000258GAA',
                    isMassAction: 'false',
                    label: 'New Contact',
                    primaryColor: 'A094ED',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: 'Create',
                    targetObject: 'Contact',
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Record',
                    actionTarget:
                        '/services/data/v41.0/quickActions/NewCase/describe',
                    actionTargetType: 'Describe',
                    apiName: 'NewCase',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::Record:Desktop:09Dxx000000006s',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_case_120.png',
                    id: '0JVxx0000000259GAA',
                    isMassAction: 'false',
                    label: 'New Case',
                    primaryColor: 'F2CF5B',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: 'Create',
                    targetObject: 'Case',
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Record',
                    actionTarget:
                        '/services/data/v41.0/quickActions/LogACall/describe',
                    actionTargetType: 'Describe',
                    apiName: 'LogACall',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::Record:Desktop:09Dxx000000006z',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/log_a_call_120.png',
                    id: '0JVxx0000000260GAA',
                    isMassAction: 'false',
                    label: 'Log a Call',
                    primaryColor: '48C3CC',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'ActivityComposer',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: 'LogACall',
                    targetObject: 'Task',
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Record',
                    actionTarget:
                        '/services/data/v41.0/quickActions/NewOpportunity/describe',
                    actionTargetType: 'Describe',
                    apiName: 'NewOpportunity',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::Record:Desktop:09Dxx000000006d',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_opportunity_120.png',
                    id: '0JVxx0000000261GAA',
                    isMassAction: 'false',
                    label: 'New Opportunity',
                    primaryColor: 'FCB95B',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: 'Create',
                    targetObject: 'Opportunity',
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Record',
                    actionTarget: null,
                    actionTargetType: null,
                    apiName: 'FeedItem.ContentNote',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::Record:Desktop:FeedItem.ContentNote',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_note_120.png',
                    id: '0JVxx0000000262GAA',
                    isMassAction: 'false',
                    label: 'New Note',
                    primaryColor: 'E6D478',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: 'Post',
                    targetObject: null,
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Record',
                    actionTarget: null,
                    actionTargetType: null,
                    apiName: 'FeedItem.RypplePost',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::Record:Desktop:FeedItem.RypplePost',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/share_thanks_120.png',
                    id: '0JVxx0000000263GAA',
                    isMassAction: 'false',
                    label: 'Thanks',
                    primaryColor: 'E9696E',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: null,
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: 'Post',
                    targetObject: null,
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Record',
                    actionTarget: null,
                    actionTargetType: null,
                    apiName: 'FeedItem.LinkPost',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::Record:Desktop:FeedItem.LinkPost',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/share_link_120.png',
                    id: '0JVxx0000000264GAA',
                    isMassAction: 'false',
                    label: 'Link',
                    primaryColor: '7A9AE6',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: null,
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: 'Post',
                    targetObject: null,
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Record',
                    actionTarget: null,
                    actionTargetType: null,
                    apiName: 'FeedItem.PollPost',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::Record:Desktop:FeedItem.PollPost',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/share_poll_120.png',
                    id: '0JVxx0000000265GAA',
                    isMassAction: 'false',
                    label: 'Poll',
                    primaryColor: '699BE1',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'CollaborateComposer',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: 'Post',
                    targetObject: null,
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Record',
                    actionTarget: null,
                    actionTargetType: null,
                    apiName: 'FeedItem.QuestionPost',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::Record:Desktop:FeedItem.QuestionPost',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/question_post_action_120.png',
                    id: '0JVxx0000000266GAA',
                    isMassAction: 'false',
                    label: 'Question',
                    primaryColor: '32AF5C',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'CollaborateComposer',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: 'Post',
                    targetObject: null,
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Record',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'ChangeOwnerOne',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::Record:Desktop:StandardButton:ChangeOwnerOne',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/change_owner_120.png',
                    id: '0JVxx0000000267GAA',
                    isMassAction: 'false',
                    label: 'Change Owner',
                    primaryColor: '0070d2',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'Account',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'Record',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'Delete',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::Record:Desktop:StandardButton:Delete',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/delete_120.png',
                    id: '0JVxx0000000268GAA',
                    isMassAction: 'false',
                    label: 'Delete',
                    primaryColor: 'E6717C',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'Account',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'Record',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'AccountHierarchy',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::Record:Desktop:StandardButton:AccountHierarchy',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_custom19_120.png',
                    id: '0JVxx0000000269GAA',
                    isMassAction: 'false',
                    label: 'View Account Hierarchy',
                    primaryColor: null,
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'Account',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'Record',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'Share',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::Record:Desktop:StandardButton:Share',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_custom19_120.png',
                    id: '0JVxx0000000270GAA',
                    isMassAction: 'false',
                    label: 'Sharing',
                    primaryColor: null,
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'Account',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'Record',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'SendEmail',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::Record:Desktop:StandardButton:SendEmail',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/email_120.png',
                    id: '0JVxx0000000271GAA',
                    isMassAction: 'false',
                    label: 'Send an Email',
                    primaryColor: '95AEC5',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'ActivityComposer',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'EmailMessage',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'Record',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'XClean',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::Record:Desktop:StandardButton:XClean',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_custom19_120.png',
                    id: '0JVxx0000000272GAA',
                    isMassAction: 'false',
                    label: 'Check Integration Status',
                    primaryColor: null,
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'Account',
                    targetUrl: null,
                    type: 'StandardButton'
                }
            ],

            links: [
                '/services/data/v41.0/ui-api/actions/record/001xx000003DGZnAAO/record-edit',
                '/services/data/v41.0/ui-api/actions/record/001xx000003DGZnAAO/related-list',
                '/services/data/v41.0/ui-api/actions/record/001xx000003DGZnAAO/related-list-record/${relatedRecordId}'
            ],

            url: '/services/data/v41.0/ui-api/actions/record/001xx000003DGZnAAO'
        }
    },

    url: '/services/data/v41.0/ui-api/actions/record/001xx000003DGZnAAO'
};

export const ACTIONS_RECORDEDIT = {
    actions: {
        '001xx000003DGZnAAO': {
            actions: [
                {
                    actionListContext: 'RecordEdit',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'SaveEdit',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::RecordEdit:Desktop:StandardButton:SaveEdit',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_custom19_120.png',
                    id: '0JVxx0000000273GAA',
                    isMassAction: 'false',
                    label: 'Save',
                    primaryColor: null,
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'Account',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'RecordEdit',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'SaveAndNew',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::RecordEdit:Desktop:StandardButton:SaveAndNew',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_custom19_120.png',
                    id: '0JVxx0000000274GAA',
                    isMassAction: 'false',
                    label: 'Save &amp; New',
                    primaryColor: null,
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'Account',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'RecordEdit',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'CancelEdit',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::RecordEdit:Desktop:StandardButton:CancelEdit',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_custom19_120.png',
                    id: '0JVxx0000000275GAA',
                    isMassAction: 'false',
                    label: 'Cancel',
                    primaryColor: null,
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'Account',
                    targetUrl: null,
                    type: 'StandardButton'
                }
            ],

            links: [],
            url:
                '/services/data/v41.0/ui-api/actions/record/001xx000003DGZnAAO/record-edit'
        }
    },

    url:
        '/services/data/v41.0/ui-api/actions/record/001xx000003DGZnAAO/record-edit'
};

export const ACTIONS_RELATEDLIST = {
    actions: {
        '001xx000003DGZnAAO': {
            actions: [
                {
                    actionListContext: 'RelatedList',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'NewTask',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::RelatedList:Desktop:StandardButton:NewTask',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_task_120.png',
                    id: '0JVxx0000000276GAA',
                    isMassAction: 'false',
                    label: 'New Task',
                    primaryColor: '4BC076',
                    relatedListRecordId: null,
                    relatedSourceObject: 'OpenActivities',
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'Task',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'RelatedList',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'NewEvent',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::RelatedList:Desktop:StandardButton:NewEvent',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_event_120.png',
                    id: '0JVxx0000000277GAA',
                    isMassAction: 'false',
                    label: 'New Event',
                    primaryColor: 'EB7092',
                    relatedListRecordId: null,
                    relatedSourceObject: 'OpenActivities',
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'Event',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'RelatedList',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'NewContact',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::RelatedList:Desktop:StandardButton:NewContact',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_contact_120.png',
                    id: '0JVxx0000000278GAA',
                    isMassAction: 'false',
                    label: 'New',
                    primaryColor: 'A094ED',
                    relatedListRecordId: null,
                    relatedSourceObject: 'Contacts',
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'Contact',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'RelatedList',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'Merge',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::RelatedList:Desktop:StandardButton:Merge',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_custom19_120.png',
                    id: '0JVxx0000000279GAA',
                    isMassAction: 'false',
                    label: 'Merge Contacts',
                    primaryColor: null,
                    relatedListRecordId: null,
                    relatedSourceObject: 'Contacts',
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'Contact',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'RelatedList',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'MassAddToCampaign',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::RelatedList:Desktop:StandardButton:MassAddToCampaign',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_custom19_120.png',
                    id: '0JVxx0000000280GAA',
                    isMassAction: 'true',
                    label: 'Add to Campaign',
                    primaryColor: null,
                    relatedListRecordId: null,
                    relatedSourceObject: 'Contacts',
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'CampaignMember',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'RelatedList',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'LogCall',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::RelatedList:Desktop:StandardButton:LogCall',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/standard/log_a_call_120.png',
                    id: '0JVxx0000000281GAA',
                    isMassAction: 'false',
                    label: 'Log a Call',
                    primaryColor: '48C3CC',
                    relatedListRecordId: null,
                    relatedSourceObject: 'ActivityHistories',
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'Task',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'RelatedList',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'SendEmail',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::RelatedList:Desktop:StandardButton:SendEmail',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/email_120.png',
                    id: '0JVxx0000000282GAA',
                    isMassAction: 'false',
                    label: 'Send an Email',
                    primaryColor: '95AEC5',
                    relatedListRecordId: null,
                    relatedSourceObject: 'ActivityHistories',
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'EmailMessage',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'RelatedList',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'New',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::RelatedList:Desktop:StandardButton:New',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_opportunity_120.png',
                    id: '0JVxx0000000283GAA',
                    isMassAction: 'false',
                    label: 'New',
                    primaryColor: 'FCB95B',
                    relatedListRecordId: null,
                    relatedSourceObject: 'Opportunities',
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'Opportunity',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'RelatedList',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'NewCase',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::RelatedList:Desktop:StandardButton:NewCase',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_case_120.png',
                    id: '0JVxx0000000284GAA',
                    isMassAction: 'false',
                    label: 'New',
                    primaryColor: 'F2CF5B',
                    relatedListRecordId: null,
                    relatedSourceObject: 'Cases',
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'Case',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'RelatedList',
                    actionTarget: null,
                    actionTargetType: null,
                    apiName: 'AttachFileFromDevice',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::RelatedList:Desktop:StandardButton:AttachFileFromDevice',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_120.png',
                    id: '0JVxx0000000285GAA',
                    isMassAction: 'false',
                    label: 'Upload Files',
                    primaryColor: '33BCE7',
                    relatedListRecordId: null,
                    relatedSourceObject: 'CombinedAttachments',
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'CombinedAttachment',
                    targetUrl: null,
                    type: 'StandardButton'
                }
            ],

            links: [],
            url:
                '/services/data/v41.0/ui-api/actions/record/001xx000003DGZnAAO/related-list'
        }
    },

    url:
        '/services/data/v41.0/ui-api/actions/record/001xx000003DGZnAAO/related-list'
};

export const ACTIONS_RELATEDLISTRECORD = {
    actions: {
        '001xx000003DGZnAAO': {
            actions: [
                {
                    actionListContext: 'RelatedListRecord',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'Edit',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::RelatedListRecord:Desktop:StandardButton:Edit',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/edit_120.png',
                    id: '0JVxx0000000380GAA',
                    isMassAction: 'false',
                    label: 'Edit',
                    primaryColor: '1DCCBF',
                    relatedListRecordId: '003xx000004TmERAA0',
                    relatedSourceObject: 'Contacts',
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'Contact',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'RelatedListRecord',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'Delete',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::RelatedListRecord:Desktop:StandardButton:Delete',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/delete_120.png',
                    id: '0JVxx0000000381GAA',
                    isMassAction: 'false',
                    label: 'Delete',
                    primaryColor: 'E6717C',
                    relatedListRecordId: '003xx000004TmERAA0',
                    relatedSourceObject: 'Contacts',
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'Contact',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'RelatedListRecord',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'AddCampaign',
                    externalId:
                        '00Dxx0000001gGI:001xx000003DGZnAAO::RelatedListRecord:Desktop:StandardButton:AddCampaign',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_campaign_120.png',
                    id: '0JVxx0000000382GAA',
                    isMassAction: 'false',
                    label: 'Add to Campaign',
                    primaryColor: 'f49756',
                    relatedListRecordId: '003xx000004TmERAA0',
                    relatedSourceObject: 'Contacts',
                    section: 'Page',
                    sourceObject: '001xx000003DGZnAAO',
                    subtype: null,
                    targetObject: 'CampaignMember',
                    targetUrl: null,
                    type: 'StandardButton'
                }
            ],

            links: [],
            url:
                '/services/data/v41.0/ui-api/actions/record/001xx000003DGZnAAO/related-list-record/003xx000004TmERAA0'
        }
    },

    url:
        '/services/data/v41.0/ui-api/actions/record/001xx000003DGZnAAO/related-list-record/003xx000004TmERAA0'
};

export const ACTIONS_FLEXIPAGE = {
    actions: {
        Opportunity: {
            actions: [
                {
                    actionListContext: 'Flexipage',
                    actionTarget:
                        '/services/data/v41.0/quickActions/LogACall/describe',
                    actionTargetType: 'Describe',
                    apiName: 'LogACall',
                    externalId:
                        '00Dxx0000001gGI:Opportunity::Flexipage:Desktop:09Dxx000000006z',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/log_a_call_120.png',
                    id: '0JVxx0000000174GAA',
                    isMassAction: 'false',
                    label: 'Log a Call',
                    primaryColor: '48C3CC',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: null,
                    sourceObject: 'Opportunity',
                    subtype: 'LogACall',
                    targetObject: 'Task',
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Flexipage',
                    actionTarget:
                        '/services/data/v41.0/quickActions/NewTask/describe',
                    actionTargetType: 'Describe',
                    apiName: 'NewTask',
                    externalId:
                        '00Dxx0000001gGI:Opportunity::Flexipage:Desktop:09Dxx000000006y',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_task_120.png',
                    id: '0JVxx0000000175GAA',
                    isMassAction: 'false',
                    label: 'New Task',
                    primaryColor: '4BC076',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: null,
                    sourceObject: 'Opportunity',
                    subtype: 'Create',
                    targetObject: 'Task',
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Flexipage',
                    actionTarget:
                        '/services/data/v41.0/quickActions/NewEvent/describe',
                    actionTargetType: 'Describe',
                    apiName: 'NewEvent',
                    externalId:
                        '00Dxx0000001gGI:Opportunity::Flexipage:Desktop:09Dxx0000000070',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_event_120.png',
                    id: '0JVxx0000000176GAA',
                    isMassAction: 'false',
                    label: 'New Event',
                    primaryColor: 'EB7092',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: null,
                    sourceObject: 'Opportunity',
                    subtype: 'Create',
                    targetObject: 'Event',
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Flexipage',
                    actionTarget: null,
                    actionTargetType: null,
                    apiName: 'FeedItem.TextPost',
                    externalId:
                        '00Dxx0000001gGI:Opportunity::Flexipage:Desktop:FeedItem.TextPost',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/share_post_120.png',
                    id: '0JVxx0000000177GAA',
                    isMassAction: 'false',
                    label: 'Post',
                    primaryColor: '65CAE4',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: null,
                    sourceObject: 'Opportunity',
                    subtype: 'Post',
                    targetObject: null,
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Flexipage',
                    actionTarget: null,
                    actionTargetType: null,
                    apiName: 'FeedItem.ContentPost',
                    externalId:
                        '00Dxx0000001gGI:Opportunity::Flexipage:Desktop:FeedItem.ContentPost',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/share_file_120.png',
                    id: '0JVxx0000000178GAA',
                    isMassAction: 'false',
                    label: 'File',
                    primaryColor: 'BAAC93',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: null,
                    sourceObject: 'Opportunity',
                    subtype: 'Post',
                    targetObject: null,
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Flexipage',
                    actionTarget:
                        '/services/data/v41.0/quickActions/SendEmail/describe',
                    actionTargetType: 'Describe',
                    apiName: 'SendEmail',
                    externalId:
                        '00Dxx0000001gGI:Opportunity::Flexipage:Desktop:09Dxx0000000071',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/email_120.png',
                    id: '0JVxx0000000179GAA',
                    isMassAction: 'false',
                    label: 'Email',
                    primaryColor: '95AEC5',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: null,
                    sourceObject: 'Opportunity',
                    subtype: 'SendEmail',
                    targetObject: 'OutgoingEmail',
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Flexipage',
                    actionTarget:
                        '/services/data/v41.0/quickActions/NewCase/describe',
                    actionTargetType: 'Describe',
                    apiName: 'NewCase',
                    externalId:
                        '00Dxx0000001gGI:Opportunity::Flexipage:Desktop:09Dxx000000006s',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_case_120.png',
                    id: '0JVxx0000000180GAA',
                    isMassAction: 'false',
                    label: 'New Case',
                    primaryColor: 'F2CF5B',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: null,
                    sourceObject: 'Opportunity',
                    subtype: 'Create',
                    targetObject: 'Case',
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Flexipage',
                    actionTarget: null,
                    actionTargetType: null,
                    apiName: 'FeedItem.ContentNote',
                    externalId:
                        '00Dxx0000001gGI:Opportunity::Flexipage:Desktop:FeedItem.ContentNote',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/new_note_120.png',
                    id: '0JVxx0000000181GAA',
                    isMassAction: 'false',
                    label: 'New Note',
                    primaryColor: 'E6D478',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: null,
                    sourceObject: 'Opportunity',
                    subtype: 'Post',
                    targetObject: null,
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Flexipage',
                    actionTarget: null,
                    actionTargetType: null,
                    apiName: 'FeedItem.RypplePost',
                    externalId:
                        '00Dxx0000001gGI:Opportunity::Flexipage:Desktop:FeedItem.RypplePost',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/share_thanks_120.png',
                    id: '0JVxx0000000182GAA',
                    isMassAction: 'false',
                    label: 'Thanks',
                    primaryColor: 'E9696E',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: null,
                    sourceObject: 'Opportunity',
                    subtype: 'Post',
                    targetObject: null,
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Flexipage',
                    actionTarget: null,
                    actionTargetType: null,
                    apiName: 'FeedItem.LinkPost',
                    externalId:
                        '00Dxx0000001gGI:Opportunity::Flexipage:Desktop:FeedItem.LinkPost',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/share_link_120.png',
                    id: '0JVxx0000000183GAA',
                    isMassAction: 'false',
                    label: 'Link',
                    primaryColor: '7A9AE6',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: null,
                    sourceObject: 'Opportunity',
                    subtype: 'Post',
                    targetObject: null,
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Flexipage',
                    actionTarget: null,
                    actionTargetType: null,
                    apiName: 'FeedItem.PollPost',
                    externalId:
                        '00Dxx0000001gGI:Opportunity::Flexipage:Desktop:FeedItem.PollPost',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/share_poll_120.png',
                    id: '0JVxx0000000184GAA',
                    isMassAction: 'false',
                    label: 'Poll',
                    primaryColor: '699BE1',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: null,
                    sourceObject: 'Opportunity',
                    subtype: 'Post',
                    targetObject: null,
                    targetUrl: null,
                    type: 'QuickAction'
                },

                {
                    actionListContext: 'Flexipage',
                    actionTarget: null,
                    actionTargetType: null,
                    apiName: 'FeedItem.QuestionPost',
                    externalId:
                        '00Dxx0000001gGI:Opportunity::Flexipage:Desktop:FeedItem.QuestionPost',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/question_post_action_120.png',
                    id: '0JVxx0000000185GAA',
                    isMassAction: 'false',
                    label: 'Question',
                    primaryColor: '32AF5C',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: null,
                    sourceObject: 'Opportunity',
                    subtype: 'Post',
                    targetObject: null,
                    targetUrl: null,
                    type: 'QuickAction'
                }
            ],

            links: [],
            url: '/services/data/v41.0/ui-api/actions/flexipage/Opportunity'
        }
    },

    url: '/services/data/v41.0/ui-api/actions/flexipage/Opportunity'
};

export const ACTIONS_PHOTO = {
    actions: {
        '005xx000001SvmHAAS': {
            actions: [
                {
                    actionListContext: 'Photo',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'ViewPhotoAction',
                    externalId:
                        '00Dxx0000001gGI:005xx000001SvmHAAS::Photo:Desktop:StandardButton:ViewPhotoAction',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/email_120.png',
                    id: '0JVxx0000000069GAA',
                    isMassAction: 'false',
                    label: 'View Photo',
                    primaryColor: '95AEC5',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: '005xx000001SvmHAAS',
                    subtype: null,
                    targetObject: 'User',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'Photo',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'UpdatePhotoAction',
                    externalId:
                        '00Dxx0000001gGI:005xx000001SvmHAAS::Photo:Desktop:StandardButton:UpdatePhotoAction',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/email_120.png',
                    id: '0JVxx0000000070GAA',
                    isMassAction: 'false',
                    label: 'Update Photo',
                    primaryColor: '95AEC5',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: '005xx000001SvmHAAS',
                    subtype: null,
                    targetObject: 'User',
                    targetUrl: null,
                    type: 'StandardButton'
                },

                {
                    actionListContext: 'Photo',
                    actionTarget: null,
                    actionTargetType: 'Invoke',
                    apiName: 'DeletePhotoAction',
                    externalId:
                        '00Dxx0000001gGI:005xx000001SvmHAAS::Photo:Desktop:StandardButton:DeletePhotoAction',
                    iconUrl:
                        'http://yungcheng-ltm2:6109/img/icon/t4v35/action/email_120.png',
                    id: '0JVxx0000000071GAA',
                    isMassAction: 'false',
                    label: 'Delete Photo',
                    primaryColor: '95AEC5',
                    relatedListRecordId: null,
                    relatedSourceObject: null,
                    section: 'Page',
                    sourceObject: '005xx000001SvmHAAS',
                    subtype: null,
                    targetObject: 'User',
                    targetUrl: null,
                    type: 'StandardButton'
                }
            ],

            links: [],
            url: '/services/data/v41.0/ui-api/actions/photo/005xx000001SvmHAAS'
        }
    },

    url: '/services/data/v41.0/ui-api/actions/photo/005xx000001SvmHAAS'
};
