/*
 * Copyright (c) 2019, salesforce.com, inc.
 * All rights reserved.
 * SPDX-License-Identifier: MIT
 * For full license text, see the LICENSE file in the repo root or https://opensource.org/licenses/MIT
 */

/* eslint-disable */

export const RECORD_ID = 'a00R0000000x5hnIAA';

export const VIEW_RECORD_UI_REPRESENTATION = {
    objectInfos: {
        Everything__c: {
            apiName: 'Everything__c',
            fields: {
                Auto_Number__c: {
                    apiName: 'Auto_Number__c',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: false,
                    custom: true,
                    dataType: 'String',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Auto Number',
                    length: 30,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: true,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: false
                },

                Checkbox__c: {
                    apiName: 'Checkbox__c',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: true,
                    custom: true,
                    dataType: 'Boolean',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: 'Help Text for Checkbox',
                    label: 'Checkbox',
                    length: 0,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: true,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: true
                },

                Contact_Phone__c: {
                    apiName: 'Contact_Phone__c',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: true,
                    custom: true,
                    dataType: 'Phone',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Contact Phone',
                    length: 40,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: true
                },

                CreatedById: {
                    apiName: 'CreatedById',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: false,
                    custom: false,
                    dataType: 'Reference',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Created By ID',
                    length: 18,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: true,
                    referenceTargetField: null,
                    referenceToInfos: [
                        {
                            apiName: 'User',
                            nameFields: ['Name']
                        }
                    ],

                    relationshipName: 'CreatedBy',
                    required: true,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: false
                },

                CreatedDate: {
                    apiName: 'CreatedDate',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: false,
                    custom: false,
                    dataType: 'DateTime',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Created Date',
                    length: 0,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: true,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: false
                },

                DateTime__c: {
                    apiName: 'DateTime__c',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: true,
                    custom: true,
                    dataType: 'DateTime',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'DateTime',
                    length: 0,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: true
                },

                Date__c: {
                    apiName: 'Date__c',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: true,
                    custom: true,
                    dataType: 'Date',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Date',
                    length: 0,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: true
                },

                Double__c: {
                    apiName: 'Double__c',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: true,
                    custom: true,
                    dataType: 'Double',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Double',
                    length: 0,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 18,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 4,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: true
                },

                Email__c: {
                    apiName: 'Email__c',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: true,
                    custom: true,
                    dataType: 'Email',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Email',
                    length: 80,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: true
                },

                Formula_Checkbox__c: {
                    apiName: 'Formula_Checkbox__c',
                    calculated: true,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: false,
                    custom: true,
                    dataType: 'Boolean',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Formula Checkbox',
                    length: 0,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: true,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: false
                },

                Formula_Currency__c: {
                    apiName: 'Formula_Currency__c',
                    calculated: true,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: false,
                    custom: true,
                    dataType: 'Currency',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Formula Currency',
                    length: 0,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 18,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 2,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: false
                },

                Formula_DateTime__c: {
                    apiName: 'Formula_DateTime__c',
                    calculated: true,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: false,
                    custom: true,
                    dataType: 'DateTime',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Formula DateTime',
                    length: 0,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: false
                },

                Formula_Date__c: {
                    apiName: 'Formula_Date__c',
                    calculated: true,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: false,
                    custom: true,
                    dataType: 'Date',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Formula Date',
                    length: 0,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: false
                },

                Formula_HTML__c: {
                    apiName: 'Formula_HTML__c',
                    calculated: true,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: false,
                    custom: true,
                    dataType: 'String',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: true,
                    inlineHelpText: null,
                    label: 'Formula HTML',
                    length: 1300,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: false
                },

                Formula_Number__c: {
                    apiName: 'Formula_Number__c',
                    calculated: true,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: false,
                    custom: true,
                    dataType: 'Double',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Formula Number',
                    length: 0,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 18,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 2,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: false
                },

                Formula_Percent__c: {
                    apiName: 'Formula_Percent__c',
                    calculated: true,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: false,
                    custom: true,
                    dataType: 'Percent',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Formula Percent',
                    length: 0,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 18,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 2,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: false
                },

                Formula_Text__c: {
                    apiName: 'Formula_Text__c',
                    calculated: true,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: false,
                    custom: true,
                    dataType: 'String',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Formula Text',
                    length: 1300,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: false
                },

                GeoLoc__Latitude__s: {
                    apiName: 'GeoLoc__Latitude__s',
                    calculated: false,
                    compound: false,
                    compoundComponentName: 'Latitude',
                    compoundFieldName: 'GeoLoc__c',
                    controllerName: null,
                    createable: true,
                    custom: true,
                    dataType: 'Double',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'GeoLoc (Latitude)',
                    length: 0,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 5,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 2,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: true
                },

                GeoLoc__Longitude__s: {
                    apiName: 'GeoLoc__Longitude__s',
                    calculated: false,
                    compound: false,
                    compoundComponentName: 'Longitude',
                    compoundFieldName: 'GeoLoc__c',
                    controllerName: null,
                    createable: true,
                    custom: true,
                    dataType: 'Double',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'GeoLoc (Longitude)',
                    length: 0,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 5,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 2,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: true
                },

                GeoLoc__c: {
                    apiName: 'GeoLoc__c',
                    calculated: false,
                    compound: true,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: false,
                    custom: true,
                    dataType: 'Location',
                    extraTypeInfo: null,
                    filterable: false,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: 'Location of some random place.',
                    label: 'GeoLoc',
                    length: 0,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: false,
                    unique: false,
                    updateable: false
                },

                Id: {
                    apiName: 'Id',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: false,
                    custom: false,
                    dataType: 'String',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Record ID',
                    length: 18,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: true,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: false
                },

                IsDeleted: {
                    apiName: 'IsDeleted',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: false,
                    custom: false,
                    dataType: 'Boolean',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Deleted',
                    length: 0,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: true,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: false
                },

                Javascript__c: {
                    apiName: 'Javascript__c',
                    calculated: true,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: false,
                    custom: true,
                    dataType: 'String',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: true,
                    inlineHelpText: null,
                    label: 'Javascript',
                    length: 1300,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: false
                },

                LastModifiedById: {
                    apiName: 'LastModifiedById',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: false,
                    custom: false,
                    dataType: 'Reference',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Last Modified By ID',
                    length: 18,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: true,
                    referenceTargetField: null,
                    referenceToInfos: [
                        {
                            apiName: 'User',
                            nameFields: ['Name']
                        }
                    ],

                    relationshipName: 'LastModifiedBy',
                    required: true,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: false
                },

                LastModifiedDate: {
                    apiName: 'LastModifiedDate',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: false,
                    custom: false,
                    dataType: 'DateTime',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Last Modified Date',
                    length: 0,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: true,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: false
                },

                LastReferencedDate: {
                    apiName: 'LastReferencedDate',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: false,
                    custom: false,
                    dataType: 'DateTime',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Last Referenced Date',
                    length: 0,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: false
                },

                LastViewedDate: {
                    apiName: 'LastViewedDate',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: false,
                    custom: false,
                    dataType: 'DateTime',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Last Viewed Date',
                    length: 0,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: false
                },

                Moneys__c: {
                    apiName: 'Moneys__c',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: true,
                    custom: true,
                    dataType: 'Currency',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Moneys',
                    length: 0,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 18,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 2,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: true
                },

                MultiPicklist__c: {
                    apiName: 'MultiPicklist__c',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: true,
                    custom: true,
                    dataType: 'MultiPicklist',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'MultiPicklist',
                    length: 4099,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 4,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: false,
                    unique: false,
                    updateable: true
                },

                Name: {
                    apiName: 'Name',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: true,
                    custom: false,
                    dataType: 'String',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Everything Name',
                    length: 80,
                    nameField: true,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: true
                },

                OwnerId: {
                    apiName: 'OwnerId',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: true,
                    custom: false,
                    dataType: 'Reference',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Owner ID',
                    length: 18,
                    nameField: false,
                    polymorphicForeignKey: true,
                    precision: 0,
                    reference: true,
                    referenceTargetField: null,
                    referenceToInfos: [
                        {
                            apiName: 'Group',
                            nameFields: ['Name']
                        },

                        {
                            apiName: 'User',
                            nameFields: ['Name']
                        }
                    ],

                    relationshipName: 'Owner',
                    required: true,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: true
                },

                Percentage__c: {
                    apiName: 'Percentage__c',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: true,
                    custom: true,
                    dataType: 'Percent',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Percentage',
                    length: 0,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 18,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: true
                },

                Picklist__c: {
                    apiName: 'Picklist__c',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: true,
                    custom: true,
                    dataType: 'Picklist',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Picklist',
                    length: 255,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: true
                },

                Quantity__c: {
                    apiName: 'Quantity__c',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: true,
                    custom: true,
                    dataType: 'Double',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Quantity',
                    length: 0,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 18,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: true
                },

                Rich_Description__c: {
                    apiName: 'Rich_Description__c',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: true,
                    custom: true,
                    dataType: 'TextArea',
                    extraTypeInfo: 'RichTextArea',
                    filterable: false,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: true,
                    inlineHelpText: null,
                    label: 'Rich Description',
                    length: 32768,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: false,
                    unique: false,
                    updateable: true
                },

                Secret__c: {
                    apiName: 'Secret__c',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: true,
                    custom: true,
                    dataType: 'EncryptedString',
                    extraTypeInfo: null,
                    filterable: false,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Secret',
                    length: 25,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: false,
                    unique: false,
                    updateable: true
                },

                SystemModstamp: {
                    apiName: 'SystemModstamp',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: false,
                    custom: false,
                    dataType: 'DateTime',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'System Modstamp',
                    length: 0,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: true,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: false
                },

                Text_Area_Long__c: {
                    apiName: 'Text_Area_Long__c',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: true,
                    custom: true,
                    dataType: 'TextArea',
                    extraTypeInfo: 'PlainTextArea',
                    filterable: false,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Text Area Long',
                    length: 32768,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: false,
                    unique: false,
                    updateable: true
                },

                Text_Area__c: {
                    apiName: 'Text_Area__c',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: true,
                    custom: true,
                    dataType: 'TextArea',
                    extraTypeInfo: 'PlainTextArea',
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: 'This is a text area',
                    label: 'Text Area',
                    length: 255,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: true
                },

                Text_Content__c: {
                    apiName: 'Text_Content__c',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: true,
                    custom: true,
                    dataType: 'String',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Text Content',
                    length: 255,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: true
                },

                Time__c: {
                    apiName: 'Time__c',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: true,
                    custom: true,
                    dataType: 'DateTime',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Time',
                    length: 0,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: true
                },

                Website__c: {
                    apiName: 'Website__c',
                    calculated: false,
                    compound: false,
                    compoundComponentName: null,
                    compoundFieldName: null,
                    controllerName: null,
                    createable: true,
                    custom: true,
                    dataType: 'Url',
                    extraTypeInfo: null,
                    filterable: true,
                    filteredLookupInfo: null,
                    highScaleNumber: false,
                    htmlFormatted: false,
                    inlineHelpText: null,
                    label: 'Website',
                    length: 255,
                    nameField: false,
                    polymorphicForeignKey: false,
                    precision: 0,
                    reference: false,
                    referenceTargetField: null,
                    referenceToInfos: [],
                    relationshipName: null,
                    required: false,
                    scale: 0,
                    searchPrefilterable: false,
                    sortable: true,
                    unique: false,
                    updateable: true
                }
            }
        }
    },

    records: {
        a00R0000000x5hnIAA: {
            apiName: 'Everything__c',
            childRelationships: {},
            fields: {
                Auto_Number__c: {
                    displayValue: null,
                    value: 'A-17/05-0100'
                },

                Checkbox__c: {
                    displayValue: null,
                    value: true
                },

                Contact_Phone__c: {
                    displayValue: null,
                    value: '403-203-1048'
                },

                CreatedBy: {
                    displayValue: 'Admin User',
                    value: {
                        apiName: 'User',
                        childRelationships: {},
                        fields: {
                            Id: {
                                displayValue: null,
                                value: '005R0000000J2lMIAS'
                            },

                            Name: {
                                displayValue: null,
                                value: 'Admin User'
                            }
                        },

                        id: '005R0000000J2lMIAS',
                        recordTypeInfo: null
                    }
                },

                CreatedById: {
                    displayValue: null,
                    value: '005R0000000J2lMIAS'
                },

                CreatedDate: {
                    displayValue: '7/5/2017 2:54 PM',
                    value: '2017-07-05T21:54:32.000Z'
                },

                DateTime__c: {
                    displayValue: '7/11/2017 1:00 PM',
                    value: '2017-07-11T20:00:00.000Z'
                },

                Date__c: {
                    displayValue: '7/13/2017',
                    value: '2017-07-13'
                },

                Double__c: {
                    displayValue: null,
                    value: 24.3542
                },

                Email__c: {
                    displayValue: null,
                    value: 'the@email.something'
                },

                Formula_Checkbox__c: {
                    displayValue: null,
                    value: true
                },

                Formula_Currency__c: {
                    displayValue: '$48.00',
                    value: 48.0
                },

                Formula_DateTime__c: {
                    displayValue: '9/9/2017 11:34 AM',
                    value: '2017-09-09T18:34:18.000Z'
                },

                Formula_Date__c: {
                    displayValue: '7/6/2017',
                    value: '2017-07-06'
                },

                Formula_HTML__c: {
                    displayValue: null,
                    value:
                        '\u003Cimg src="/servlet/servlet.FileDownload?file=01570000000Q6Ep" alt="Red" border="0"/\u003E'
                },

                Formula_Number__c: {
                    displayValue: null,
                    value: 33.6
                },

                Formula_Percent__c: {
                    displayValue: null,
                    value: 1272.0
                },

                Formula_Text__c: {
                    displayValue: null,
                    value: 'the@email.something - Everything Object 1'
                },

                GeoLoc__Latitude__s: {
                    displayValue: null,
                    value: 40.7128
                },

                GeoLoc__Longitude__s: {
                    displayValue: null,
                    value: -74.0059
                },

                Javascript__c: {
                    displayValue: null,
                    value:
                        '\u003Ca href="javascript:alert(\'Hello%20BOOM!\')" target="_blank"\u003EClick Me\u003C/a\u003E'
                },

                LastModifiedBy: {
                    displayValue: 'Admin User',
                    value: {
                        apiName: 'User',
                        childRelationships: {},
                        fields: {
                            Id: {
                                displayValue: null,
                                value: '005R0000000J2lMIAS'
                            },

                            Name: {
                                displayValue: null,
                                value: 'Admin User'
                            }
                        },

                        id: '005R0000000J2lMIAS',
                        recordTypeInfo: null
                    }
                },

                LastModifiedById: {
                    displayValue: null,
                    value: '005R0000000J2lMIAS'
                },

                LastModifiedDate: {
                    displayValue: '8/22/2017 4:44 PM',
                    value: '2017-08-22T23:44:27.000Z'
                },

                Moneys__c: {
                    displayValue: '$2.00',
                    value: 2.0
                },

                MultiPicklist__c: {
                    displayValue: 'Alpha;Gamma',
                    value: 'Alpha;Gamma'
                },

                Name: {
                    displayValue: null,
                    value: 'Everything Object 1'
                },

                Owner: {
                    displayValue: 'Admin User',
                    value: {
                        apiName: 'Name',
                        childRelationships: {},
                        fields: {
                            Id: {
                                displayValue: null,
                                value: '005R0000000J2lMIAS'
                            },

                            Name: {
                                displayValue: null,
                                value: 'Admin User'
                            }
                        },

                        id: '005R0000000J2lMIAS',
                        recordTypeInfo: null
                    }
                },

                OwnerId: {
                    displayValue: null,
                    value: '005R0000000J2lMIAS'
                },

                Percentage__c: {
                    displayValue: null,
                    value: 53.0
                },

                Picklist__c: {
                    displayValue: 'D',
                    value: 'D'
                },

                Quantity__c: {
                    displayValue: null,
                    value: 24.0
                },

                Rich_Description__c: {
                    displayValue: null,
                    value:
                        '\u003Cp\u003E\u003Cb\u003EHello\u003C/b\u003E \u003Ci\u003Ethere\u003C/i\u003E! I \u003Cu\u003Ewould\u003C/u\u003E like to paste a table here.\u003C/p\u003E\u003Cp class="ql-indent-1"\u003Esomething\u003C/p\u003E\u003Cp class="ql-indent-1"\u003Esomething else\u003C/p\u003E\u003Cp class="ql-indent-1"\u003Esomething else something\u003C/p\u003E\u003Cp class="ql-indent-1"\u003Esomething else something else\u003C/p\u003E\u003Cp\u003Ehttps://prefix.section.domain.suffix.net/x/abcde/file.jpg?ab=firstAttr&amp;bc=secondAttr\u003C/p\u003E\u003Cp\u003Eprefix.section.domain.suffix.net/x/abcde/file.jpg?ab=firstAttr&amp;bc=secondAttr\u003C/p\u003E'
                },

                Secret__c: {
                    displayValue: null,
                    value: 'XXXX-XXXX-XXXX-3029'
                },

                Text_Area_Long__c: {
                    displayValue: null,
                    value:
                        "This is some text in a text area\r\nLine 2\r\nLine 3 starts scrolling\r\nLine 4 is cut off in edit panel\r\nLet's make this one a bit longer since it's supposed to be a long text area"
                },

                Text_Area__c: {
                    displayValue: null,
                    value:
                        'This is some text in a text area\r\nLine 2\r\nLine 3 starts scrolling\r\nLine 4 is cut off normally in edit panel\r\nwww.salesforce.com'
                },

                Text_Content__c: {
                    displayValue: null,
                    value: 'This is some text'
                },

                Time__c: {
                    displayValue: null,
                    value: null
                },

                Website__c: {
                    displayValue: null,
                    value: 'www.google.com'
                }
            },

            id: 'a00R0000000x5hnIAA',
            recordTypeInfo: null
        }
    }
};
