# Resource Links to Learn Software Development 
These are the best learning resources I've found to date.

Selection criteria - resource has at least one of the following aspects:
Either:
- **For absolute beginners:** - ease of understanding/accessibility
- **For professionals** - fast upskill in a section
- **For growing junior and intermediate developers** - comprehensive learning.

Also:
- Prioritising **free** resources.
- Aiming for **multiple formats** for learning (video, tutorial, etc).
- **Simple explanations** with **demonstrations** (for <ins>written formats</ins>: this means **readability** and use of **examples**).

See review notes for brief summary of the teaching methodologies.

<br>

## Computer Science:
### Video Courses:
* **Crash Course Computer Science**

    [Youtube Playlist](https://www.youtube.com/playlist?list=PL8dPuuaLjXtNlUrzyH5r6jN9ulIgZBpdo)
    
    _Crash Course aims to be easy and accessible way to learn fast - they even use cute animations and story examples to illustrate tricky concepts. Often a great starting point for understanding contexts before you get more specific. It's also good material to fill basic foundational knowledge gaps._
    
    <br>Format: **Youtube video course**

    Availability: **Free**

<br>

### Books:
* **Code Complete, Second Edition**

    [Book Link](https://www.oreilly.com/library/view/code-complete-second/0735619670/)
    
    _Considered the "Bible" of software development- despite this book being published in 2004 the principles and practices are still considered highly relevant fundamentals of the industry today. It is comprehensive but written in a humorously relatable and easy to understand format._
    
    <br>Format: **Book**

    Availability: **Free 1 week trial in Oreily link**

<br>

## Web Development:
### How-To Resource Lists:
* **How I Learned Front-end Web Development for Free in Five Days**

    [Article](https://medium.com/@davesuperman/how-to-learn-front-end-web-development-for-free-in-5-days-25aa6021aa3b)

    _A useful list of guides the author employed to learn the different aspects of front-end web development in 5 days._
    
    <br>Format: **How-To Resource Lists**

    Availability: **Free**    

<br>

### Video Courses:

* **jQuery Tutorial for Beginners** at **LearnCode.academy**
    
    [Youtube Playlist](https://www.youtube.com/playlist?list=PLoYCgNOIyGABdI2V8I_SWo22tFpgh2s6_)
    
    _Learn Jquery really fast, easy to follow._

    <br>Format: **Youtube video course**

    Availability: **Free**

<br>

## Javascript 

* **Learn to Program in Javascript: Beginner to Pro**
  <br>[Udemy Course](https://www.udemy.com/course/programming-in-javascript/)
  <br>Useful as it goes sufficiently in-depth on a lot of foundational concepts like the differences between programming languages. Also has a quiz after many of the lessons so you can test yourself.
  
  _**Important Notes**: this course was created in [2014](https://www.udemy.com/api-2.0/courses/217000/?fields[course]=title,url,created) so it pre-dates the release of ES6. Therefore **it doesn't incorporate some important changes** like now-recommended block-level `let` and `const` variables (it uses the unrecommended `var`), `promises` and ES8's introduction of `async`/`await`._
  
  _**However I STRONGLY recommend you <ins>do this course FIRST</ins>** (it's only 4 1/2 hours) before tackling a brief 1-2 hour refresher course on ES 6-8 improvements on Javascript, and simply put a pin in this fact while you do this course. This is one of those crawl-before-you-can-walk scenarios as Javascript is quite unique among programming languages. From my own struggles with Javascript I found it necessary to go back to the basics of Javascript **first** in order to appreciate the changes and the contexts in which they were made._
<br><br>_Explaining this **important context** for Javascript and specifically **how it differs from other languages** is something this course does *excellently*, and thus **lays crucially important foundations for understanding**. You can then easily build apon these with the updated syntax when you **understand what is going on under the hood, how Javascript works and WHY these additions were needed**._
<br><br>_Remember, despite tech being a fast-changing industry, when it comes to understanding foundations and fundamentals, the most recent resources may not always be the best, (which is why [*Code Complete (Second Edition)*](https://www.oreilly.com/library/view/code-complete-2nd/0735619670/) is still widely considered one of the most crucially important resources of learning proper software development, despite it being written in 2004.)_


  <br>Format: **Udemy video course**
  
  Duration: **4 1/2 hours**
  
  Availability: **Free**

<br>

## Artificial Intelligence:
### Video Courses:
* **Crash Course Artificial Intelligence**

    [Youtube Playlist](https://www.youtube.com/playlist?list=PL8dPuuaLjXtO65LeD2p4_Sb5XQ51par_b)
    
    _Crash Course aims to be easy and accessible way to learn fast - they even use cute animations and story examples to illustrate tricky concepts. Often a great starting point for understanding contexts before you get more specific. It's also good material to fill basic foundational knowledge gaps._
    
    <br>Format: **Youtube video course**

    Availability: **Free**<br><br>


* **Machine Learning Andrew Ng Courses**

    [Youtube Playlist](https://www.youtube.com/playlist?list=PL8dPuuaLjXtO65LeD2p4_Sb5XQ51par_b)
    
    _Goes in-depth and quite technical for when you want to start digging into machine learning. I was able to follow the **[free] Introduction to Machine Learning** course - it is quite mathematical - managing with a high school mathematics level understanding though it might take some repetition. Has quizzes to test yourself after lectures and soft "deadline" weekly submissions._
    
    <br>Format: **Youtube/Coursera Video courses with quizzes and weekly submissions**

    Availability: **Free/Paid**

<br>

## Video Game Development:
### Video Courses:
* **Make Unity Games** with **Brackeys**

    [Youtube Playlist](https://www.youtube.com/channel/UCYbK_tjZ2OrIZFBvU6CCMiA)
    
    _Learn fast - start from their basic **Make A Game** course, easy to understand, goes step by step.
    Gets more in depth with specific topic courses as well eg FPS, 2D Platformer, C# game development, etc building up to advanced._
    
    <br>Format: **Youtube video course**

    Availability: **Free**

<br>

## Python

 ### Books:
 * **Automate the Boring Stuff with Python**
    
    [Free Book](https://automatetheboringstuff.com/2e/chapter0/)
    
    _Easy to understand introduction for programmers and non-programmers alike.  
    Going through the book helps ensure you have a solid grasp of fundamentals. This book is highly recommended for foundational knowledge._
    
    <br>Format: **Book** 
    
    Availability: **Free**

    **Also Available:** in a Udemy course (see below).

<br>
  
### Video Courses:
 * **Automate the Boring Stuff with Python Programming**
    
    A [Udemy video Course](https://www.udemy.com/course/automate/) based off the books. This is unfortunately not free, but Udemy do have frequent discount sales to look out for.
    
    _Easy to understand, follows the book pretty closely. For programmers and non-programmers. 
    Going through the course helps ensure you have a solid grasp of fundamentals. Recommended for foundational knowledge particularly if you find video an easier medium than books for learning._

    <br>Format: **Udemy video course**

    Availability: **Paid** (often discounted)

    Duration: 9.5h

<br>

## Django:
#### Starting Out With Django:

* This Free Udemy Course **'Try Django 2.2 - Web Development with Python 3.6+' is very clear for beginners and easy to follow, and you get to build a fun blog site in the process!
I found there wasn't much difference at all using Django 4.2.7 and Python 3.12, so the course, which seems to have been created in 2019, has aged well!
You can find it [here](https://www.udemy.com/course/try-django-2-2-python-web-development/)

    <br>Format: **Udemy Course**

    Availability: **Free**
<br>


* **The Official Django docs** and Django tutorial are great and very beginner-friendly! 
The Django site has all different levels of explanation, from a quick start to a tutorial to topic explanations to more in-depth and detailed documentation. They have links to the different section and an explanation of each [here](https://docs.djangoproject.com/en/4.2/#how-the-documentation-is-organized).

    <br>Format: **Official Docs** - But very user-friendly!

    Availability: **Free**
<br>

#### Getting Production-Ready: 
When you get comfortable enough with Django that you want to set up a production-ready (ie live) site you'll want to take a look at these:
* **Setting up a Postgres DB as your Django DB**: See this [guide](https://www.digitalocean.com/community/tutorials/how-to-set-up-django-with-postgres-nginx-and-gunicorn-on-ubuntu-22-04).

    <br>Format: **Online Guide**

    Availability: **Free**
<br>

* **Setting up Environment variables in Django:**  so you don't commit sensitive data! Here's a handy explainer [article](https://alicecampkin.medium.com/how-to-set-up-environment-variables-in-django-f3c4db78c55f).
  
    <br>Format: **Short Article/Guide**

    Availability: **Free**

   <u>Note</u>: **Templates Available Here:** I made a Django settings.py example showing a configuration for PostgresSQL DB and the integration of environment variables. You can find it in the Django folder in [this repo](https://github.com/salemandreus/salem-setup).

   <br>Format: **Github Code Repo**

   Availability: **Free**

<br>

## Cloud and DevSecOps/DevOps
### Basic Cloud Fundamentals:

**For Complete Beginners:**

* [Oracle Cloud Infrastructure- Part 1 ( Fundamentals of Cloud)](https://www.udemy.com/course/cloud-fundamentals/) - This course describes IAAS, PAAS, SAAS and compares Oracle vs AWS basic concepts at a complete beginner level.
It's therefore useful even if you're not planning to use Oracle or AWS but just want to understand Cloud at a high level.

    <br>Format: **Udemy video course**

    Availability: **Free**

    Duration: 1.5h
