"""
Django settings for chatbot project.

Generated by 'django-admin startproject' using Django 5.0.4.

For more information on this file, see
https://docs.djangoproject.com/en/5.0/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/5.0/ref/settings/
"""

from pathlib import Path
import os
from dotenv import load_dotenv
load_dotenv()
# Build paths inside the project like this: BASE_DIR / 'subdir'.
BASE_DIR = Path(__file__).resolve().parent.parent


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/5.0/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = ''

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = ['*']


# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'chatting',
    # two factor authentication
    'django_otp',
    'django_otp.plugins.otp_static',
    'django_otp.plugins.otp_totp',
    'two_factor',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django_otp.middleware.OTPMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'chatbot.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'chatbot.wsgi.application'


# Database
# https://docs.djangoproject.com/en/5.0/ref/settings/#databases

# DATABASES = {
#     'default': {
#         'ENGINE': 'django.db.backends.sqlite3',
#         'NAME': BASE_DIR / 'db.sqlite3',
#     }
# }



DATABASES = {
    'default': {
        'ENGINE': os.getenv('ENGINE'),
        'NAME': os.getenv('DB_NAME'),
        'USER': os.getenv('DB_USER'),
        'PASSWORD': os.getenv('DB_PASSWORD'),
        'HOST': os.getenv('DB_HOST'),
        'PORT': os.getenv('DB_PORT'),
        'OPTIONS': {
            'driver': str(os.getenv('DRIVER')),
            'extra_params': str(os.getenv('EXTRA_PARAMS')),
        },
    }
}

# Password validation
# https://docs.djangoproject.com/en/5.0/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/5.0/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/5.0/howto/static-files/

STATIC_URL = 'static/'

# Default primary key field type
# https://docs.djangoproject.com/en/5.0/ref/settings/#default-auto-field

DEFAULT_AUTO_FIELD = 'django.db.models.BigAutoField'
CSRF_TRUSTED_ORIGINS = [
    
]
ACCOUNT_DEFAULT_HTTP_PROTOCOL = "https"
# settings.py
SECURE_SSL_REDIRECT = True
SECURE_PROXY_SSL_HEADER = ('HTTP_X_FORWARDED_PROTO', 'https')


CLIENT_ID = os.getenv('XERO_CLIENT_ID')
CLIENT_SECRET = os.getenv('XERO_CLIENT_SECRET')
AUTHORIZATION_URL = os.getenv('AUTHORIZATION_URL')
ACCESS_TOKEN_URL = os.getenv('ACCESS_TOKEN_URL')
REFRESH_TOKEN_URL = os.getenv('REFRESH_TOKEN_URL')
REDIRECT_URI=os.getenv('REDIRECT_URI')
SCOPE= [
    "offline_access",
    "files.read",
    "email",
    "assets",
    "profile",
    "payroll.timesheets",
    "payroll.employees",
    "projects",
    "projects.read",
    "accounting.contacts",
    "accounting.journals.read",
    "accounting.contacts.read",
    "openid",
    "accounting.reports.read",
    "payroll.settings",
    "accounting.transactions",
    "accounting.settings",
    "files",
    "accounting.settings.read",
    "assets.read",
    "payroll.payslip",
    "payroll.payruns",
    "accounting.budgets.read",
    "accounting.attachments.read",
    "accounting.attachments",
    "accounting.transactions.read"
    
]
# SCOPE = "accounting.contacts projects accounting.settings.read accounting.transactions.read openid accounting.transactions offline_access profile accounting.settings accounting.reports.read email assets accounting.journals.read accounting.attachments"
USERINFO_URL = os.getenv('USERINFO_URL')

STATICFILES_DIRS = [BASE_DIR / "static",]


STRIPE_PUBLISHABLE_KEY = os.getenv('')
STRIPE_SECRET_KEY = os.getenv('')

# settings.py
EMAIL_BACKEND = ''
EMAIL_HOST = ''
EMAIL_USE_TLS = True
EMAIL_PORT = 587
EMAIL_HOST_USER = ''
EMAIL_HOST_PASSWORD = ''
DEFAULT_FROM_EMAIL = ''

LOGIN_URL = 'two_factor:login'
LOGIN_REDIRECT_URL = '/account/two_factor/setup'
