## Empower Your Business with Data-Driven Insights

Medial-AI seamlessly connects with your Xero data, enabling smarter decision-making through AI-powered analysis and an intuitive chatbot interface.


## Project Industry

*Finance & Accounting Software*


## Media & Links:

*Project Link:* https://medial-webapp-dev.azurewebsites.net/

*Loom Video:* https://medial-webapp-dev.azurewebsites.net/

*Overview Image:*

<img width="500" alt="medial-ai-flow-digram" src="https://github.com/user-attachments/assets/8f2d3eda-e4d4-4d4c-b73e-1cbfb7ba000c">


## High-Level Architecture
The solution integrates OpenAI's ChatGPT-4 with Azure AI Search to interact with Xero Data. Data is sourced from Files, Xero, and processed through AI models and SQL Server for seamless data integration, with Django Web App providing an intuitive interface for end-users.

<img width="500" alt="accounting-data-medial-ai" src="https://github.com/user-attachments/assets/4e9eba9d-2b33-4814-9aa2-bbcd0c11a7c6">


## Project Overview

**Challenge**
Managing and analyzing large volumes of financial data from Xero can be complex and time-consuming, especially when trying to gain actionable insights quickly.

**Solution**
Medial-AI automates the retrieval and processing of your Xero data, providing real-time insights and simplifying data management through a user-friendly platform.


## Key Features

- **AI-Powered Insights:** Utilize OpenAI’s GPT-4o model to ask questions and receive instant answers based on your Xero data.
- **Seamless Data Integration:** Automatically fetch and process data from Xero, including Accounts, Invoices, Payments, and more.
- **Effortless Payments:** Integrated with Stripe for smooth and secure transactions.
- **Comprehensive Reporting:** Access detailed financial reports like Profit and Loss, Balance Sheet, and more.


## Tech Stack

- *Data Engineering & Pipeline*
  - Python & Azure Serverless Architecture
  - Azure Data Factory: terabytes of file data and millions of Xero records

- *Web Application*
  - Azure Web App
  - SQL Server
  - Azure Application Insights

- *AI & Data Integration*
  - Azure AI Search (Semantic Search, Vector Search, Hybrid Search)
  - Azure OpenAI (adda-text002, GPT-4o)

- *Deployment & CI/CD*
  - Azure Containerized Web App
  - GitHub
  - GitHub Actions


## Screenshots

- **Medial AI Landing Page:** User can see the main landing page of Medial AI, providing an overview of its features and functionalities.
<img width="500" alt="media-ai-landing-page" src="https://github.com/user-attachments/assets/965e26b3-c9be-48f3-9e54-840b8c8b4180">

---
- **Medial AI Accounting Setting:** User can access and configure accounting settings specific to Xero integration.
<img width="500" alt="medial-ai-account-settings" src="https://github.com/user-attachments/assets/fb0584a4-9a8c-4068-bb1f-1f3429c44909">


---
- **Medial Chat with Xero Content:** User can engage with the Medial AI chatbot, interacting with Xero data for insights and analysis.
<img width="500" alt="medial-ai-chat-content" src="https://github.com/user-attachments/assets/ea565662-d83d-4220-b791-312ca131fa64">


---
- **Medial AI Chat Default without selecting any connector:** User can view the default chat interface, awaiting connector selection.
<img width="500" alt="medial-ai-chatbot-default" src="https://github.com/user-attachments/assets/19965114-4146-46d5-8351-182d5713bdfc">


---
- **Medial Connectors:** User can manage and configure various connectors available within Medial AI for seamless data integration.
<img width="500" alt="medial-ai-connectors" src="https://github.com/user-attachments/assets/62395f48-17ff-46c5-834d-2e5d9f7bdd92">




---

*Empower your business with Medial-AI—your partner in data-driven financial management.*

