# Top GitHub repositories everyone should look at!

GitHub hosts countless repositories that are invaluable to developers, students, researchers, and tech enthusiasts. Unfortunately, many of these repositories remain under the radar, despite the significant efforts of their authors.This repository aims to bridge that gap by curating a list of crucial and impactful GitHub repositories.

Whether you're a student, coder, researcher, or a budding tech enthusiast, these repositories can be game-changers for your projects and learning journey. Explore our list to uncover tools and resources that can elevate your skills and knowledge.

## Table of contents

1. [Roadmap](#roadmap)
2. [Awesome](#awesome)
3. [Coding interview university](#coding-interview-university)
4. [System design primer](#system-design-primer)
5. [Free code camp](#freecodecamp)
6. [Gitignore](#gitignore)
7. [Free for Dev](#free-for-dev)
8. [Every programmer should know](#every-programmer-should-know)
9. [Tensorflow](#tensorflow)
10. [Public APIs](#public-apis)
11. [Javascript questions](#javascript-questions)
12. [Best websites a programmer should visit](#best-websites-a-programmer-should-visit)
13. [React Native Apps](#react-native-apps)
14. [Build your own X](#build-your-own-x)
15. [Tech interview handbook](#tech-interview-handbook)
16. [Javascript Algorithms and Data Structures](#javascript-algorithms-and-data-structures)
17. [Design Resources for Developers](#design-resources-for-developers)
18. [Project based learning](#project-based-learning)
19. [Tech jobs with relocation](#tech-jobs-with-relocation)
20. [The Algorithms](#the-algorithms)
21. [You don't know js](#you-dont-know-js)
22. [Curated List of DevOps Tools](#curated-List-of-devops-tools)
23. [Interviews](#interviews)
24. [What happens when](#what-happens-when)
25. [30 seconds of code](#30-seconds-of-code)
26. [System design](#system-design)
27. [Devops exercises](#devops-exercises)
28. [System Design Resources](#system-design-resources)
29. [Data Structures Algorithms with Low and High Level Designs](#data-structures-algorithms-with-low-and-high-level-designs)
30. [Engineering Blogs](#engineering-blogs)
31. [System Design 101](#system-design-101)
32. [Resources to Become a Great Engineering Leader](#resources-to-become-a-great-engineering-leader)
33. [DevOps Roadmap](#DevOps-Roadmap)
34. [Awesome System Design Sources](#Awesome-system-design-resources)
35. [Design Patterns For Humans](#design-patterns-for-humans)


## Roadmap
Many codies often say that they don’t have an exact idea of the roadmap to what they want to become.
I was frequently being asked questions regarding the roadmaps to full-stack development, data science, machine learning, etc… And to all of them, look at here buddy!

The repository includes a set of well-structured roadmaps that outline the necessary skills and technologies to learn in each path of software development. Each roadmap is divided into different levels, such as beginner, intermediate, and advanced, and includes a list of tools, technologies, and resources to learn at each level.

The roadmaps in the repository are designed to help developers navigate the overwhelming amount of information and resources available in the software development world. By following the roadmaps, developers can have a clear direction on what to learn next and how to progress in their career or personal projects.

Repo link : https://github.com/kamranahmedse/developer-roadmap  
Website : https://roadmap.sh/

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

## Awesome
This repository seems like a Wikipedia page of a hell lot of things.  

This repository contains awesome lists of all kinds of interesting topics. Especially provides a curated list of high-quality resources in various fields of software development.  

The repository includes lists of resources on topics such as programming languages, frameworks, libraries, tools, design patterns, and more.  

The repository is organized into multiple categories, and each category contains a list of resources related to that category. For example, the "JavaScript" category includes a list of resources related to JavaScript programming, such as libraries, frameworks, and articles.  

Looking at this repo will just make you say… awesome!

Repo link: https://github.com/sindresorhus/awesome

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

## Coding interview university

There are many students around the world who are interested in becoming software developers but have no idea of what to study and how to crack the interviews!  

Boom!! Here’s the boon.  

This repo provides a comprehensive list of topics and resources for preparing for coding interviews. The repository covers various topics such as data structures, algorithms, system design, databases, and more.

The repository is organized into a well-structured curriculum that follows a step-by-step approach to preparing for coding interviews. Each topic includes a list of resources, including books, articles, videos, and practice problems, to help learners master the concept.

Repo link: https://github.com/jwasham/coding-interview-university

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

##  System design primer
This is an open-source collection of resources to help software engineers prepare for technical interviews related to system design. The repo includes:

A comprehensive set of study materials covering system design topics such as scalability, reliability, availability, performance, and security.  

Step-by-step guides to design different types of systems such as a URL shortening service, a web crawler, a social network, a chat application, and more.  

A list of commonly asked interview questions and answers related to system design, along with detailed explanations.  

Case studies of real-world system design examples from companies such as Netflix, Amazon, Uber, and Facebook.  

Recommended books, articles, and videos for further learning.  

Repo link: https://github.com/donnemartin/system-design-primer  

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

## Freecodecamp
Freecodecamp is an open-source project aimed at helping people learn to code for free. The project consists of a comprehensive curriculum of coding challenges and projects that cover a wide range of topics, including HTML, CSS, JavaScript, React, Node.js, Databases, and more. The repository includes:  
- The codebase for the freeCodeCamp curriculum, which is organized into a series of certifications that cover different aspects of web development.
- A web-based platform where users can access the curriculum and complete coding challenges and projects.
- A community of learners and volunteers who help to maintain the curriculum, provide support to learners, and contribute to the project in various ways.

The freeCodeCamp curriculum is designed to be accessible to learners of all levels, from beginners to advanced coders. It is self-paced, interactive, and project-based, which means that learners can learn by doing and get hands-on experience building real-world projects.

This project is entirely free and open-source, which means that anyone can contribute to the project and use the curriculum to learn to code. The project has helped millions of people around the world to learn to code and has become one of the most popular resources for learning web development.

Repo link : https://github.com/freeCodeCamp/freeCodeCamp  

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

## Gitignore

This repo provides a collection of `.gitignore` templates for various programming languages, frameworks, and tools. The `.gitignore` file is a configuration file that tells Git which files and directories to ignore when tracking changes in a project.

The repository includes a comprehensive set of `.gitignore` templates that can be used in different projects. These templates are organized by programming language or framework and include common files and directories that should be ignored in those projects.

Using a `.gitignore` file is essential in maintaining a clean and organized repository. By ignoring unnecessary files, developers can keep their repositories small, avoid accidentally committing sensitive information, and prevent merge conflicts caused by different file versions.

Repo link : https://github.com/github/gitignore  

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

## Free For Dev

This repo provides a curated list of free services, software, and resources for developers.  
It also  includes a list of various tools and services that developers can use for free, such as cloud hosting, domain registration, databases, email services, and more.

The repository is organized into multiple categories, and each category contains a list of resources related to that category. For example, the "Hosting" category includes a list of free cloud hosting services, while the "Analytics" category includes a list of free analytics and tracking tools.

Repo link : https://github.com/ripienaar/free-for-dev  
Website link : https://free-for.dev/

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

## Every programmer should know

This repository has a  list of resources that every programmer should know. The repository covers a wide range of topics related to software development, including programming languages, algorithms, databases, security, and more.

The repository is organized into multiple categories, and each category contains a list of resources related to that category. For example, the "Distributed Systems" category includes resources related to distributed systems, such as articles, books, and videos.

Repo link : https://github.com/mtdvio/every-programmer-should-know

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

## Tensorflow

Tensorflow provides a comprehensive platform for developing and deploying machine learning models.  

TensorFlow is one of the most popular machine learning libraries in the world, with a vast user community and an extensive range of applications.

The repository contains the complete source code for TensorFlow, including its core libraries, tools, and examples.  

TensorFlow supports a wide range of machine learning algorithms, including deep neural networks, convolutional neural networks, recurrent neural networks, and more.  

It also supports distributed computing, which enables developers to scale their machine learning models across multiple devices and machines.

The TensorFlow platform provides a high-level API that allows developers to build and train machine learning models quickly and easily.  

The platform supports multiple programming languages, including Python, C++, Java, and Go, which makes it accessible to a wide range of developers.

Repo Link : https://github.com/tensorflow/tensorflow

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

## Public APIs

This repository contains a great list of apis to play around them from various domains including sports, news and entertainment.

The repository is organized into multiple categories, and each category contains a list of APIs related to that category. For example, the "Weather" category includes a list of APIs related to weather, such as OpenWeatherMap and Weatherbit.

The repository also includes documentation on how to use the APIs and examples of how to integrate them into various programming languages, such as Python, Java, and JavaScript.

The repository is widely used by developers around the world and is considered one of the go-to resources for finding high-quality and free APIs to use in their applications.

Repo Link : https://github.com/public-apis/public-apis

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

## JavaScript questions

The repository is intended to help developers prepare for technical interviews, especially those that focus on JavaScript.

The repository contains a vast collection of JavaScript questions, ranging from beginner-level to advanced-level. The questions cover a wide range of topics, including data types, functions, arrays, objects, prototypes, closures, and more.

Each question in the repository includes a detailed explanation of the problem, followed by one or more solutions with explanations.

The solutions provided in the repository are well-documented and follow best practices, making them an excellent learning resource for developers looking to improve their JavaScript skills.

Repo Link : https://github.com/lydiahallie/javascript-questions

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

## Best Websites a programmer should visit

This repo provides a curated list of websites that programmers can use to improve their skills, learn new programming languages, and stay up-to-date with the latest industry trends.

The repository is organized into multiple categories, and each category contains a list of websites related to that category.  
For example, the "Online Learning" category includes a list of websites that offer online courses and tutorials, such as Codecademy, Coursera, and Udacity.

Repo Link : https://github.com/sdmg15/Best-websites-a-programmer-should-visit/

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

## React Native apps

This repo contains curated list of open-source React Native apps that developers can use as examples or as a starting point for their own projects.

The repository contains a wide range of apps, from simple to complex, and covers a variety of categories, such as productivity, social networking, e-commerce, health and fitness, and more. Each app listed in the repository includes a brief description of its features and functionality.

This repository provides an excellent way for developers to find high-quality, open-source React Native apps, and use them as a reference for their own projects.

Repo Link : https://github.com/ReactNativeNews/React-Native-Apps

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

## Build Your own X

This repo helps you understand and build your own clones of many projects from code editor to your own database.

This provides a curated list of tutorials and resources for building your own version of popular software tools and applications.

The repository is organized into categories, each of which contains a list of resources related to that category. For example, the "Build your own Text Editor" category includes tutorials and resources for building a text editor from scratch.

The repository also includes a brief description of each resource and why it is useful for developers. This makes it easier for users to find the resources that are relevant to their needs.

Repo Link : https://github.com/codecrafters-io/build-your-own-x

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

## Tech Interview Handbook

This repo contains a comprehensive guide for anyone preparing for technical job interviews, particularly in the field of software engineering. The repository was created by Yangshun Tay, a software engineer based in Singapore, and is available to the public for free.

The handbook is organized into several sections, covering a range of topics related to technical interviews. Some of the main sections include data structures and algorithms, system design, behavior questions, and coding questions. Each section includes detailed explanations, sample questions, and tips on how to approach different types of questions.

In addition to the main content, the repository also includes additional resources such as links to online coding challenges, mock interview platforms, and recommended books for further study.

Repo Link : https://github.com/yangshun/tech-interview-handbook

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

## JavaScript Algorithms and Data Structures

The "JavaScript Algorithms and Data Structures" repository on GitHub is a collection of various computer science algorithms and data structures implemented in the JavaScript programming language.

The repository includes various algorithms and data structures implemented in JavaScript, including sorting algorithms, searching algorithms, graph algorithms, and many more.

Each algorithm or data structure has its own directory in the repository, which includes a JavaScript implementation of the algorithm or data structure, as well as a detailed explanation of how it works and how it can be used.

In addition to the main content, the repository also includes additional resources such as links to online courses, tutorials, and books for further study.

There are also solutions to various coding challenges implemented in the JavaScript language, which can be useful for anyone looking to improve their coding skills.

Repo Link : https://github.com/trekhleb/javascript-algorithms

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

## Design Resources for Developers

The "Design Resources for Developers" repository on GitHub is a curated list of various design-related tools and resources that are useful for developers.

The repository was created by Brad Traversy, a web developer and online instructor, and is available to the public for free.

The repository includes a wide range of design resources, such as color palettes, fonts, icons, stock photos, design inspiration, and many more.

Each resource has its own directory in the repository, which includes a brief description of what it is and how it can be used.

In addition to the main content, the repository also includes links to various design-related tutorials, courses, and tools, which can be useful for developers who want to improve their design skills.
There are also resources specifically for web design, such as responsive design frameworks, CSS libraries, and web design inspiration sites.

Repo Link : https://github.com/bradtraversy/design-resources-for-developers

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

## Project Based Learning

This repository contains a collection of project ideas that are designed to help individuals learn and practice different programming and technology skills.

These projects cover a wide range of topics, including web development, data science, machine learning, computer vision, game development, and more.

Each project includes a detailed description of the skills involved, the tools and technologies required, and step-by-step instructions for building the project.

This resource can be helpful for beginners who are looking to improve their programming skills, as well as for experienced developers who are looking for new challenges and opportunities to learn.

The projects are designed to be hands-on and engaging, and they encourage learners to experiment and explore new ideas.

Repo Link : https://github.com/practical-tutorials/project-based-learning

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

## Tech Jobs with Relocation

This repo maintains a great list of tech job opportunities from various companies across the world that offer relocation packages for new employees. The repository was created by Andrew Stetsenko, a software developer and entrepreneur based in Ukraine, and is available to the public for free.

The repository includes job opportunities for a wide range of tech-related positions, including software developers, data scientists, designers, project managers, and many more. Each job listing includes information about the company, the position, the location, and the relocation package offered, making it easy for job seekers to find relevant opportunities.

In addition to the main job listings, the repository also includes resources and tips for job seekers looking to relocate for work, such as information about visa requirements, tips for preparing for interviews, and links to articles and resources about living and working in various countries.

Repo Link : https://github.com/AndrewStetsenko/tech-jobs-with-relocation/

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

## The Algorithms

This repository aims to provide a collection of algorithms implemented in various programming languages. It covers a wide range of algorithms, including sorting algorithms, searching algorithms, graph algorithms, mathematical algorithms, and more.

By visiting the repository, you can browse through the available algorithms, explore the different programming language implementations, and even contribute to the project if you're interested. The repository typically includes code samples, explanations, and documentation to help users understand and utilize the algorithms effectively.

The best part is, you can get the algorithms in many different popular languages.

Repo Link : https://github.com/TheAlgorithms

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

## You Don't Know JS

The repository contains multiple books that cover various aspects of JavaScript, ranging from the fundamentals to more advanced topics. The book series is designed to help developers gain a deeper understanding of JavaScript and overcome common misconceptions and pitfalls.

Each book in the series has its directory in the repository and is accompanied by code examples and exercises to reinforce the concepts covered. The books are organized logically and progressively, making it easier for readers to grasp complex JavaScript concepts.

In addition to the book content, the repository also includes additional resources, such as links to related articles, videos, and online discussions. These resources provide supplementary information and further exploration of the topics covered in the book series.

Repo Link : https://github.com/getify/You-Dont-Know-JS/

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

## Curated List of DevOps Tools

This repository contains a curated collection of DevOps tools. including descriptions, installation instructions, configurations, documentation, usage examples, and community resources. Users can explore and contribute to the repository to enhance their DevOps practices.

One can refer to this repository as a started guide and a good reference book for a DevOps career.

Repo Link : https://github.com/techiescamp/devops-tools/

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

##  Interviews

This repository is a comprehensive resource for technical interview preparation in software engineering.

It covers topics like data structures, algorithms, system design, and coding challenges.

Organized with clear sections, it offers a structured approach for studying.

Contributors can enhance its content, and also includes additional resources and contact information for inquiries.

Repo link: https://github.com/kdn251/interviews  

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>


##  What happens when

This repository is dedicated to providing a detailed answer to the common interview question: "What happens when you type google.com into your browser's address box and press enter?"

Rather than offering a brief overview, this project aims to delve into every aspect of the process, leaving no detail unexplored.
It invites collaboration from the community, encouraging contributors to add missing details and improve the comprehensiveness of the explanation.

If you're interested in understanding the intricate workings behind web browsing, this repository offers an opportunity to contribute to and learn from a comprehensive exploration of the topic.

Repo link: https://github.com/alex/what-happens-when

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

##  30 seconds of code

This is a repository housing a curated collection of useful JavaScript snippets, each designed to perform a specific task in 30 seconds or less.

Organized into categories such as string manipulation, array manipulation, and math-related functions, these snippets aim to provide quick solutions to common programming challenges.

Contributors are encouraged to submit their own snippets or improvements via pull requests, fostering a collaborative environment for sharing knowledge and enhancing the repository's utility.

With its focus on brevity and practicality, "30-seconds-of-code" serves as a valuable resource for JavaScript developers seeking concise yet effective code solutions.

Repo link: https://github.com/Chalarangelo/30-seconds-of-code

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

##  System design

The repository is a comprehensive resource covering system design principles and practical applications.

Organized into chapters, it explores fundamental concepts such as networking protocols, databases, and scalability techniques.

Advanced topics like microservices architecture, security protocols, and disaster recovery strategies are also addressed.

With real-world examples like WhatsApp and Netflix, the repository offers valuable insights and solutions for designing scalable and reliable software systems.

Repo link: https://github.com/karanpratapsingh/system-design   
Website : https://www.karanpratapsingh.com/courses/system-design

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

##  Devops exercises

The "devops-exercises" repository is a rich collection of technical questions and exercises, covering various topics, with a focus on DevOps and SRE (Site Reliability Engineering).

Currently boasting 2600+ exercises, it serves as a valuable resource for interview preparation, though many questions may not reflect actual interview scenarios.

While beneficial for aspiring DevOps engineers, it's important to note that mastering all topics isn't necessary, and understanding key concepts is more critical.

The repository also includes a FAQ page for further guidance.

Repo link: https://github.com/bregman-arie/devops-exercises

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

## System Design Resources

This offers an extensive collection of resources for mastering system design concepts.

Covering a wide array of topics, it includes detailed guides, articles, and videos on video processing, cluster management, messaging systems, databases, network protocols, API design, and more.

From practical system design to advanced topics like distributed consensus and authorization, this repository serves as a comprehensive guide for engineers aiming to enhance their system design skills.

Whether you're preparing for interviews or seeking to deepen your understanding of scalable architectures, these resources provide invaluable insights and knowledge.

Repo link: https://github.com/InterviewReady/system-design-resources

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

## Data Structures Algorithms with Low and High Level Designs

The "Data-Structure-Algorithms-LLD-HLD" repository offers a comprehensive collection of theory, practice problems, and resources for mastering data structures, algorithms, and system design concepts.

It includes theoretical explanations coupled with practical problems for readers to reinforce their understanding.

Competitive programming enthusiasts will find curated lists from top platforms like Topcoder, CodeForces, HackerEarth, and InterviewBit, along with dynamic programming patterns, bit manipulation tricks, and binary search patterns categorized on LeetCode.

Additionally, the repository features guides on system design, interview question lists based on company, and a compilation of top university courses.

With its wealth of resources, this repository serves as a valuable toolkit for anyone seeking to excel in data structures, algorithms, and system design.

Repo link: https://github.com/arpit20adlakha/Data-Structure-Algorithms-LLD-HLD

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

## Engineering Blogs

This provides a curated list of engineering blogs categorized by companies, individual/group contributors, and products/technologies.

With alphabetical organization, users can easily navigate through the extensive collection of blogs from various sources.

Whether you're interested in learning about specific companies' engineering practices, insights from individual contributors, or updates on products and technologies, this repository serves as a valuable resource for staying informed about the latest developments in the tech industry.

Repo link: https://github.com/kilimchoi/engineering-blogs

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>


## System Design 101

The "system-design-101" repository on GitHub serves as a comprehensive guide covering various aspects of system design, software architecture, and technology concepts.

From communication protocols like REST API vs GraphQL to microservice architecture and cloud services, it delves into topics such as CI/CD pipelines, database structures, caching strategies, and security mechanisms.

Additionally, it provides real-world case studies from renowned companies like Netflix, Twitter, Airbnb, and Amazon Prime Video, offering insights into their architecture evolution and technical challenges.

With practical explanations and examples, this repository is a valuable resource for both beginners and experienced developers looking to enhance their understanding of system design principles and industry practices.

Repo link: https://github.com/ByteByteGoHq/system-design-101

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>


## Resources To Become A Great Engineering Leader

This repository is a curated list of over 100 resources aimed at aspiring engineering leaders.

It covers a wide range of topics including software engineering, system design, data engineering, leadership, management, product, and business.

With books, newsletters, influential people, and more, the repository offers valuable resources for personal and professional growth in 2024.

The creator emphasizes the importance of investing time wisely by selecting resources based on specific needs and conducting deep dives into chosen topics.

Additionally, they encourage individuals to assess their current skills to prioritize learning areas for maximum impact.

Whether you're seeking to enhance your technical expertise or develop leadership skills, this repository provides a wealth of resources to help you on your journey.

Repo link: https://github.com/gregorojstersek/resources-to-become-a-great-engineering-leader

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

## DevOps Roadmap

The "DevOps-Roadmap" repository on GitHub provides a structured roadmap and learning resources for aspiring DevOps engineers, predominantly offering free resources.

The roadmap covers essential areas such as GIT, programming languages, Linux and scripting, networking and security, server management, containers, container orchestration, infrastructure as code, CI/CD, monitoring and observability, cloud providers, and software engineering practices.

Additionally, the repository includes additional resources, tools, and recommended books to further support learning and development in the DevOps field.

With its comprehensive approach, this repository serves as a valuable guide for individuals looking to build expertise in DevOps practices and technologies.

Repo link: https://github.com/milanm/DevOps-Roadmap

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>


## Awesome System Design Resources

This repository contains the resources for most important design concepts to prepare for the interview.

This also covers important Design tradeoffs and throws light on building blocks such as heartbeats, circuit broker, proxy server and etc.

The repository also explains about some of the useful architectural patterns and covers a list of interview questions tagged as Easy, medium and Hard.

Overall, this is a repo which should be considered as one of the important and useful material to prepare for the system design interviews.

Repo link: https://github.com/ashishps1/awesome-system-design-resources  
Website : https://blog.algomaster.io

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>

## Design Patterns for Humans

This is an effortful approach of making design patterns easy to everyone to understand and practice.

The author systematically explains the Design Patterns and break them into respective categories and explain each of them in easy terms along with the sample code added.

Repo link : https://github.com/kamranahmedse/design-patterns-for-humans

<div align="right">
  <b><a href="#table-of-contents">↥ Back To Top</a></b>
</div>