# [dew](https://s9a.github.io/dew) <br> [fresh](../../releases/latest)


## [html](index.html) <br> [sample](sample.html) <br> [template](../../../diy)

```html
<html class="dew-media dew-wet">
```

## [meta](https://web.dev/color-scheme/#the-color-scheme-meta-tag)

```html
<meta name="color-scheme" content="dark light">
<meta name="theme-color" content="hotpink">
```

## [stylesheet](dew.css)

```html
<link rel="stylesheet" href="dew.css" media="(color)">
```

## [element](https://s9a.github.io/dew) [surface](surface.css)

```html
<link rel="stylesheet" href="surface.css">
```

## [icon](https://s9a.github.io/dew/icon.svg) [switch](icon.svg)

```html
<link rel="icon" href="icon.svg">
```

## [classes](https://s9a.github.io/dew#cascade)

```html
<samp class="dew-media">
  <a href="dew-polar" href="#hello">hello</a>
  <a href="dew-polar" href="#world">world</a>
</samp>
```

## [customize](diy.css)

```html
<html class="dew-media dew-wet dew-diy">
<!-- ... -->
<link rel="stylesheet" href="dew.css">
<link rel="stylesheet" href="diy.css">
```

```css
--dew-shift: color 0ms;
--dew-slick: mistyrose;
--dew-slime: deeppink;
--dew-solar: orchid;
--dew-lunar: #111;
--dew-locus: currentColor;
--dew-focus: invert(100%);
--dew-hover: hue-rotate(0deg);
--dew-vapor: opacity(60%);
```

## [technology](https://developer.mozilla.org)

- [html](https://mdn.io/html-elements-reference)
- [css](https://mdn.io/css)
- [prefers-color-scheme](https://mdn.io/prefers-color-scheme)
- [background](https://mdn.io/css-background)
- [transition](https://mdn.io/css-transition)
- [outline](https://mdn.io/css-outline)
- [filter](https://mdn.io/css-filter)
- [fill](https://mdn.io/css-fill)
- [color](https://mdn.io/css-color)
- [var](https://mdn.io/css-var)

## [license](LICENSE.md)

[`Zlib`](https://s9a.github.io/license#zlib)
