# Landing Page for AIS Web with Admin Panel

Welcome to this repository for the landing page of AIS Web, a fictional company. The landing page is built with PHP and the Codeigniter 3 framework, and features a fresh and minimalist design. The page also includes an admin panel that allows administrators to manage the content and users of the landing page.

## Features

- Registration for admins
- Login for admins
- CRUD (create, read, update, delete) for content on the landing page
- Minimalist and fresh design for the landing page

## Technologies Used

- PHP: a popular server-side scripting language
- Codeigniter 3: a framework for building web applications with PHP
- Bootstrap 4: a front-end framework for designing responsive and mobile-first websites

## Prerequisites

To use this repository, you will need a local development environment set up with PHP and the Codeigniter 4 framework. You should also be familiar with basic web development concepts and technologies, such as HTML, CSS, and JavaScript.

## How to use this repository

1. Clone or download the repository to your local development environment.
2. Set up the database by importing the provided `aisweb.sql` file.
3. Configure the database connection settings in the `.env` file.
4. Run the application in your local development server.
5. Use the provided admin credentials (username: `admin`, password: `password`) to log in to the admin panel and manage the content and users of the landing page.

We hope you find this repository useful as you develop your own landing page for AIS Web or a similar project!
