#ifndef DINPUT_H
#define DINPUT_H

#include <SDL.h>
#ifdef __SWITCH__
#include <switch.h>
#endif

namespace fallout {
#ifdef __SWITCH__
extern double cursorSpeedup;
#endif

typedef struct MouseData {
    int x;
    int y;
    unsigned char buttons[2];
    int wheelX;
    int wheelY;
} MouseData;

typedef struct KeyboardData {
    int key;
    char down;
} KeyboardData;

bool directInputInit();
void directInputFree();
bool mouseDeviceAcquire();
bool mouseDeviceUnacquire();
bool mouseDeviceGetData(MouseData* mouseData);
bool keyboardDeviceAcquire();
bool keyboardDeviceUnacquire();
bool keyboardDeviceReset();
bool keyboardDeviceGetData(KeyboardData* keyboardData);
bool mouseDeviceInit();
void mouseDeviceFree();
bool keyboardDeviceInit();
void keyboardDeviceFree();

void handleMouseEvent(SDL_Event* event);
void handleTouchEvent(SDL_Event* event);
void handleLeftStickMovement(MouseData* mouseState);
void handleControllerButtons(MouseData* mouseState);

} // namespace fallout

#endif /* DINPUT_H */
