// https://fffuel.co/nnnoise/

export function getNoiseSVG(noise: number): string {
  return `<svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink"
  xmlns:svgjs="http://svgjs.dev/svgjs" viewBox="0 0 700 700" width="700" height="700">
  <defs>
      <filter id="nnnoise-filter" x="-20%" y="-20%" width="140%" height="140%" filterUnits="objectBoundingBox"
          primitiveUnits="userSpaceOnUse" color-interpolation-filters="linearRGB">
          <feTurbulence type="fractalNoise" baseFrequency="0.102" numOctaves="4" seed="15" stitchTiles="stitch" x="0%"
              y="0%" width="100%" height="100%" result="turbulence"></feTurbulence>
          <feSpecularLighting surfaceScale="15" specularConstant="${
            noise * 3
          }" specularExponent="20" lighting-color="#7957A8"
              x="0%" y="0%" width="100%" height="100%" in="turbulence" result="specularLighting">
              <feDistantLight azimuth="3" elevation="100"></feDistantLight>
          </feSpecularLighting>
          <feColorMatrix type="saturate" values="0" x="0%" y="0%" width="100%" height="100%" in="specularLighting"
              result="colormatrix"></feColorMatrix>
      </filter>
  </defs>
  <rect width="700" height="700" fill="transparent"></rect>
  <rect width="700" height="700" fill="#7957a8" filter="url(#nnnoise-filter)"></rect>
</svg>`
}
