# UI Components for Rustic AI

The UI Components for Rustic AI is a comprehensive collection of reusable components designed specifically to empower developers in constructing interactive multimodal chat interfaces. With a focus on versatility and ease of integration, our library offers a wide range of components tailored to accommodate various chat functionalities. Whether you're building a chatbot, virtual assistant, or communication platform, Rustic UI Components provides the building blocks necessary to create engaging and dynamic user experiences.

Additionally, our Rustic UI Component Library is available on Figma, enabling you to delve into the intricacies of our designs. Explore the [Figma file](https://www.figma.com/community/file/1340378790384732080) to gain insights into our innovative approach to UI design.

To learn more about Rustic AI, visit our [website](https://rustic.ai).

[![Commitizen friendly](https://img.shields.io/badge/commitizen-friendly-brightgreen.svg)](http://commitizen.github.io/cz-cli/)

## Getting Started

To get started, visit the [Quick Start](https://rustic-ai.github.io/ui-components/?path=/docs/documentation-quick-start--docs) page on our Storybook.

## Storybook

Visit our [Storybook](https://rustic-ai.github.io/ui-components) for all documentation regarding components, as well as our [Theme and Styling](https://rustic-ai.github.io/ui-components/?path=/docs/documentation-theme-and-styling--docs) guide.

## Building From Source

If you want to build the UI components locally and use it for your projects, refer to [CONTRIBUTING.md](CONTRIBUTING.md#building-from-source-and-using-it-locally).

## Contributing

Contributions are welcome! Please read our [CONTRIBUTING.md](CONTRIBUTING.md) for details on how to contribute as well as the process for submitting pull requests.

## License

This project is licensed under the terms of the [MIT License](LICENSE).
