// Code generated by pegomock. DO NOT EDIT.
// Source: github.com/runatlantis/atlantis/server/core/locking (interfaces: Backend)

package mocks

import (
	pegomock "github.com/petergtz/pegomock/v4"
	command "github.com/runatlantis/atlantis/server/events/command"
	models "github.com/runatlantis/atlantis/server/events/models"
	"reflect"
	"time"
)

type MockBackend struct {
	fail func(message string, callerSkip ...int)
}

func NewMockBackend(options ...pegomock.Option) *MockBackend {
	mock := &MockBackend{}
	for _, option := range options {
		option.Apply(mock)
	}
	return mock
}

func (mock *MockBackend) SetFailHandler(fh pegomock.FailHandler) { mock.fail = fh }
func (mock *MockBackend) FailHandler() pegomock.FailHandler      { return mock.fail }

func (mock *MockBackend) CheckCommandLock(cmdName command.Name) (*command.Lock, error) {
	if mock == nil {
		panic("mock must not be nil. Use myMock := NewMockBackend().")
	}
	_params := []pegomock.Param{cmdName}
	_result := pegomock.GetGenericMockFrom(mock).Invoke("CheckCommandLock", _params, []reflect.Type{reflect.TypeOf((**command.Lock)(nil)).Elem(), reflect.TypeOf((*error)(nil)).Elem()})
	var _ret0 *command.Lock
	var _ret1 error
	if len(_result) != 0 {
		if _result[0] != nil {
			_ret0 = _result[0].(*command.Lock)
		}
		if _result[1] != nil {
			_ret1 = _result[1].(error)
		}
	}
	return _ret0, _ret1
}

func (mock *MockBackend) DeletePullStatus(pull models.PullRequest) error {
	if mock == nil {
		panic("mock must not be nil. Use myMock := NewMockBackend().")
	}
	_params := []pegomock.Param{pull}
	_result := pegomock.GetGenericMockFrom(mock).Invoke("DeletePullStatus", _params, []reflect.Type{reflect.TypeOf((*error)(nil)).Elem()})
	var _ret0 error
	if len(_result) != 0 {
		if _result[0] != nil {
			_ret0 = _result[0].(error)
		}
	}
	return _ret0
}

func (mock *MockBackend) GetLock(project models.Project, workspace string) (*models.ProjectLock, error) {
	if mock == nil {
		panic("mock must not be nil. Use myMock := NewMockBackend().")
	}
	_params := []pegomock.Param{project, workspace}
	_result := pegomock.GetGenericMockFrom(mock).Invoke("GetLock", _params, []reflect.Type{reflect.TypeOf((**models.ProjectLock)(nil)).Elem(), reflect.TypeOf((*error)(nil)).Elem()})
	var _ret0 *models.ProjectLock
	var _ret1 error
	if len(_result) != 0 {
		if _result[0] != nil {
			_ret0 = _result[0].(*models.ProjectLock)
		}
		if _result[1] != nil {
			_ret1 = _result[1].(error)
		}
	}
	return _ret0, _ret1
}

func (mock *MockBackend) GetPullStatus(pull models.PullRequest) (*models.PullStatus, error) {
	if mock == nil {
		panic("mock must not be nil. Use myMock := NewMockBackend().")
	}
	_params := []pegomock.Param{pull}
	_result := pegomock.GetGenericMockFrom(mock).Invoke("GetPullStatus", _params, []reflect.Type{reflect.TypeOf((**models.PullStatus)(nil)).Elem(), reflect.TypeOf((*error)(nil)).Elem()})
	var _ret0 *models.PullStatus
	var _ret1 error
	if len(_result) != 0 {
		if _result[0] != nil {
			_ret0 = _result[0].(*models.PullStatus)
		}
		if _result[1] != nil {
			_ret1 = _result[1].(error)
		}
	}
	return _ret0, _ret1
}

func (mock *MockBackend) List() ([]models.ProjectLock, error) {
	if mock == nil {
		panic("mock must not be nil. Use myMock := NewMockBackend().")
	}
	_params := []pegomock.Param{}
	_result := pegomock.GetGenericMockFrom(mock).Invoke("List", _params, []reflect.Type{reflect.TypeOf((*[]models.ProjectLock)(nil)).Elem(), reflect.TypeOf((*error)(nil)).Elem()})
	var _ret0 []models.ProjectLock
	var _ret1 error
	if len(_result) != 0 {
		if _result[0] != nil {
			_ret0 = _result[0].([]models.ProjectLock)
		}
		if _result[1] != nil {
			_ret1 = _result[1].(error)
		}
	}
	return _ret0, _ret1
}

func (mock *MockBackend) LockCommand(cmdName command.Name, lockTime time.Time) (*command.Lock, error) {
	if mock == nil {
		panic("mock must not be nil. Use myMock := NewMockBackend().")
	}
	_params := []pegomock.Param{cmdName, lockTime}
	_result := pegomock.GetGenericMockFrom(mock).Invoke("LockCommand", _params, []reflect.Type{reflect.TypeOf((**command.Lock)(nil)).Elem(), reflect.TypeOf((*error)(nil)).Elem()})
	var _ret0 *command.Lock
	var _ret1 error
	if len(_result) != 0 {
		if _result[0] != nil {
			_ret0 = _result[0].(*command.Lock)
		}
		if _result[1] != nil {
			_ret1 = _result[1].(error)
		}
	}
	return _ret0, _ret1
}

func (mock *MockBackend) TryLock(lock models.ProjectLock) (bool, models.ProjectLock, error) {
	if mock == nil {
		panic("mock must not be nil. Use myMock := NewMockBackend().")
	}
	_params := []pegomock.Param{lock}
	_result := pegomock.GetGenericMockFrom(mock).Invoke("TryLock", _params, []reflect.Type{reflect.TypeOf((*bool)(nil)).Elem(), reflect.TypeOf((*models.ProjectLock)(nil)).Elem(), reflect.TypeOf((*error)(nil)).Elem()})
	var _ret0 bool
	var _ret1 models.ProjectLock
	var _ret2 error
	if len(_result) != 0 {
		if _result[0] != nil {
			_ret0 = _result[0].(bool)
		}
		if _result[1] != nil {
			_ret1 = _result[1].(models.ProjectLock)
		}
		if _result[2] != nil {
			_ret2 = _result[2].(error)
		}
	}
	return _ret0, _ret1, _ret2
}

func (mock *MockBackend) Unlock(project models.Project, workspace string) (*models.ProjectLock, error) {
	if mock == nil {
		panic("mock must not be nil. Use myMock := NewMockBackend().")
	}
	_params := []pegomock.Param{project, workspace}
	_result := pegomock.GetGenericMockFrom(mock).Invoke("Unlock", _params, []reflect.Type{reflect.TypeOf((**models.ProjectLock)(nil)).Elem(), reflect.TypeOf((*error)(nil)).Elem()})
	var _ret0 *models.ProjectLock
	var _ret1 error
	if len(_result) != 0 {
		if _result[0] != nil {
			_ret0 = _result[0].(*models.ProjectLock)
		}
		if _result[1] != nil {
			_ret1 = _result[1].(error)
		}
	}
	return _ret0, _ret1
}

func (mock *MockBackend) UnlockByPull(repoFullName string, pullNum int) ([]models.ProjectLock, error) {
	if mock == nil {
		panic("mock must not be nil. Use myMock := NewMockBackend().")
	}
	_params := []pegomock.Param{repoFullName, pullNum}
	_result := pegomock.GetGenericMockFrom(mock).Invoke("UnlockByPull", _params, []reflect.Type{reflect.TypeOf((*[]models.ProjectLock)(nil)).Elem(), reflect.TypeOf((*error)(nil)).Elem()})
	var _ret0 []models.ProjectLock
	var _ret1 error
	if len(_result) != 0 {
		if _result[0] != nil {
			_ret0 = _result[0].([]models.ProjectLock)
		}
		if _result[1] != nil {
			_ret1 = _result[1].(error)
		}
	}
	return _ret0, _ret1
}

func (mock *MockBackend) UnlockCommand(cmdName command.Name) error {
	if mock == nil {
		panic("mock must not be nil. Use myMock := NewMockBackend().")
	}
	_params := []pegomock.Param{cmdName}
	_result := pegomock.GetGenericMockFrom(mock).Invoke("UnlockCommand", _params, []reflect.Type{reflect.TypeOf((*error)(nil)).Elem()})
	var _ret0 error
	if len(_result) != 0 {
		if _result[0] != nil {
			_ret0 = _result[0].(error)
		}
	}
	return _ret0
}

func (mock *MockBackend) UpdateProjectStatus(pull models.PullRequest, workspace string, repoRelDir string, newStatus models.ProjectPlanStatus) error {
	if mock == nil {
		panic("mock must not be nil. Use myMock := NewMockBackend().")
	}
	_params := []pegomock.Param{pull, workspace, repoRelDir, newStatus}
	_result := pegomock.GetGenericMockFrom(mock).Invoke("UpdateProjectStatus", _params, []reflect.Type{reflect.TypeOf((*error)(nil)).Elem()})
	var _ret0 error
	if len(_result) != 0 {
		if _result[0] != nil {
			_ret0 = _result[0].(error)
		}
	}
	return _ret0
}

func (mock *MockBackend) UpdatePullWithResults(pull models.PullRequest, newResults []command.ProjectResult) (models.PullStatus, error) {
	if mock == nil {
		panic("mock must not be nil. Use myMock := NewMockBackend().")
	}
	_params := []pegomock.Param{pull, newResults}
	_result := pegomock.GetGenericMockFrom(mock).Invoke("UpdatePullWithResults", _params, []reflect.Type{reflect.TypeOf((*models.PullStatus)(nil)).Elem(), reflect.TypeOf((*error)(nil)).Elem()})
	var _ret0 models.PullStatus
	var _ret1 error
	if len(_result) != 0 {
		if _result[0] != nil {
			_ret0 = _result[0].(models.PullStatus)
		}
		if _result[1] != nil {
			_ret1 = _result[1].(error)
		}
	}
	return _ret0, _ret1
}

func (mock *MockBackend) VerifyWasCalledOnce() *VerifierMockBackend {
	return &VerifierMockBackend{
		mock:                   mock,
		invocationCountMatcher: pegomock.Times(1),
	}
}

func (mock *MockBackend) VerifyWasCalled(invocationCountMatcher pegomock.InvocationCountMatcher) *VerifierMockBackend {
	return &VerifierMockBackend{
		mock:                   mock,
		invocationCountMatcher: invocationCountMatcher,
	}
}

func (mock *MockBackend) VerifyWasCalledInOrder(invocationCountMatcher pegomock.InvocationCountMatcher, inOrderContext *pegomock.InOrderContext) *VerifierMockBackend {
	return &VerifierMockBackend{
		mock:                   mock,
		invocationCountMatcher: invocationCountMatcher,
		inOrderContext:         inOrderContext,
	}
}

func (mock *MockBackend) VerifyWasCalledEventually(invocationCountMatcher pegomock.InvocationCountMatcher, timeout time.Duration) *VerifierMockBackend {
	return &VerifierMockBackend{
		mock:                   mock,
		invocationCountMatcher: invocationCountMatcher,
		timeout:                timeout,
	}
}

type VerifierMockBackend struct {
	mock                   *MockBackend
	invocationCountMatcher pegomock.InvocationCountMatcher
	inOrderContext         *pegomock.InOrderContext
	timeout                time.Duration
}

func (verifier *VerifierMockBackend) CheckCommandLock(cmdName command.Name) *MockBackend_CheckCommandLock_OngoingVerification {
	_params := []pegomock.Param{cmdName}
	methodInvocations := pegomock.GetGenericMockFrom(verifier.mock).Verify(verifier.inOrderContext, verifier.invocationCountMatcher, "CheckCommandLock", _params, verifier.timeout)
	return &MockBackend_CheckCommandLock_OngoingVerification{mock: verifier.mock, methodInvocations: methodInvocations}
}

type MockBackend_CheckCommandLock_OngoingVerification struct {
	mock              *MockBackend
	methodInvocations []pegomock.MethodInvocation
}

func (c *MockBackend_CheckCommandLock_OngoingVerification) GetCapturedArguments() command.Name {
	cmdName := c.GetAllCapturedArguments()
	return cmdName[len(cmdName)-1]
}

func (c *MockBackend_CheckCommandLock_OngoingVerification) GetAllCapturedArguments() (_param0 []command.Name) {
	_params := pegomock.GetGenericMockFrom(c.mock).GetInvocationParams(c.methodInvocations)
	if len(_params) > 0 {
		if len(_params) > 0 {
			_param0 = make([]command.Name, len(c.methodInvocations))
			for u, param := range _params[0] {
				_param0[u] = param.(command.Name)
			}
		}
	}
	return
}

func (verifier *VerifierMockBackend) DeletePullStatus(pull models.PullRequest) *MockBackend_DeletePullStatus_OngoingVerification {
	_params := []pegomock.Param{pull}
	methodInvocations := pegomock.GetGenericMockFrom(verifier.mock).Verify(verifier.inOrderContext, verifier.invocationCountMatcher, "DeletePullStatus", _params, verifier.timeout)
	return &MockBackend_DeletePullStatus_OngoingVerification{mock: verifier.mock, methodInvocations: methodInvocations}
}

type MockBackend_DeletePullStatus_OngoingVerification struct {
	mock              *MockBackend
	methodInvocations []pegomock.MethodInvocation
}

func (c *MockBackend_DeletePullStatus_OngoingVerification) GetCapturedArguments() models.PullRequest {
	pull := c.GetAllCapturedArguments()
	return pull[len(pull)-1]
}

func (c *MockBackend_DeletePullStatus_OngoingVerification) GetAllCapturedArguments() (_param0 []models.PullRequest) {
	_params := pegomock.GetGenericMockFrom(c.mock).GetInvocationParams(c.methodInvocations)
	if len(_params) > 0 {
		if len(_params) > 0 {
			_param0 = make([]models.PullRequest, len(c.methodInvocations))
			for u, param := range _params[0] {
				_param0[u] = param.(models.PullRequest)
			}
		}
	}
	return
}

func (verifier *VerifierMockBackend) GetLock(project models.Project, workspace string) *MockBackend_GetLock_OngoingVerification {
	_params := []pegomock.Param{project, workspace}
	methodInvocations := pegomock.GetGenericMockFrom(verifier.mock).Verify(verifier.inOrderContext, verifier.invocationCountMatcher, "GetLock", _params, verifier.timeout)
	return &MockBackend_GetLock_OngoingVerification{mock: verifier.mock, methodInvocations: methodInvocations}
}

type MockBackend_GetLock_OngoingVerification struct {
	mock              *MockBackend
	methodInvocations []pegomock.MethodInvocation
}

func (c *MockBackend_GetLock_OngoingVerification) GetCapturedArguments() (models.Project, string) {
	project, workspace := c.GetAllCapturedArguments()
	return project[len(project)-1], workspace[len(workspace)-1]
}

func (c *MockBackend_GetLock_OngoingVerification) GetAllCapturedArguments() (_param0 []models.Project, _param1 []string) {
	_params := pegomock.GetGenericMockFrom(c.mock).GetInvocationParams(c.methodInvocations)
	if len(_params) > 0 {
		if len(_params) > 0 {
			_param0 = make([]models.Project, len(c.methodInvocations))
			for u, param := range _params[0] {
				_param0[u] = param.(models.Project)
			}
		}
		if len(_params) > 1 {
			_param1 = make([]string, len(c.methodInvocations))
			for u, param := range _params[1] {
				_param1[u] = param.(string)
			}
		}
	}
	return
}

func (verifier *VerifierMockBackend) GetPullStatus(pull models.PullRequest) *MockBackend_GetPullStatus_OngoingVerification {
	_params := []pegomock.Param{pull}
	methodInvocations := pegomock.GetGenericMockFrom(verifier.mock).Verify(verifier.inOrderContext, verifier.invocationCountMatcher, "GetPullStatus", _params, verifier.timeout)
	return &MockBackend_GetPullStatus_OngoingVerification{mock: verifier.mock, methodInvocations: methodInvocations}
}

type MockBackend_GetPullStatus_OngoingVerification struct {
	mock              *MockBackend
	methodInvocations []pegomock.MethodInvocation
}

func (c *MockBackend_GetPullStatus_OngoingVerification) GetCapturedArguments() models.PullRequest {
	pull := c.GetAllCapturedArguments()
	return pull[len(pull)-1]
}

func (c *MockBackend_GetPullStatus_OngoingVerification) GetAllCapturedArguments() (_param0 []models.PullRequest) {
	_params := pegomock.GetGenericMockFrom(c.mock).GetInvocationParams(c.methodInvocations)
	if len(_params) > 0 {
		if len(_params) > 0 {
			_param0 = make([]models.PullRequest, len(c.methodInvocations))
			for u, param := range _params[0] {
				_param0[u] = param.(models.PullRequest)
			}
		}
	}
	return
}

func (verifier *VerifierMockBackend) List() *MockBackend_List_OngoingVerification {
	_params := []pegomock.Param{}
	methodInvocations := pegomock.GetGenericMockFrom(verifier.mock).Verify(verifier.inOrderContext, verifier.invocationCountMatcher, "List", _params, verifier.timeout)
	return &MockBackend_List_OngoingVerification{mock: verifier.mock, methodInvocations: methodInvocations}
}

type MockBackend_List_OngoingVerification struct {
	mock              *MockBackend
	methodInvocations []pegomock.MethodInvocation
}

func (c *MockBackend_List_OngoingVerification) GetCapturedArguments() {
}

func (c *MockBackend_List_OngoingVerification) GetAllCapturedArguments() {
}

func (verifier *VerifierMockBackend) LockCommand(cmdName command.Name, lockTime time.Time) *MockBackend_LockCommand_OngoingVerification {
	_params := []pegomock.Param{cmdName, lockTime}
	methodInvocations := pegomock.GetGenericMockFrom(verifier.mock).Verify(verifier.inOrderContext, verifier.invocationCountMatcher, "LockCommand", _params, verifier.timeout)
	return &MockBackend_LockCommand_OngoingVerification{mock: verifier.mock, methodInvocations: methodInvocations}
}

type MockBackend_LockCommand_OngoingVerification struct {
	mock              *MockBackend
	methodInvocations []pegomock.MethodInvocation
}

func (c *MockBackend_LockCommand_OngoingVerification) GetCapturedArguments() (command.Name, time.Time) {
	cmdName, lockTime := c.GetAllCapturedArguments()
	return cmdName[len(cmdName)-1], lockTime[len(lockTime)-1]
}

func (c *MockBackend_LockCommand_OngoingVerification) GetAllCapturedArguments() (_param0 []command.Name, _param1 []time.Time) {
	_params := pegomock.GetGenericMockFrom(c.mock).GetInvocationParams(c.methodInvocations)
	if len(_params) > 0 {
		if len(_params) > 0 {
			_param0 = make([]command.Name, len(c.methodInvocations))
			for u, param := range _params[0] {
				_param0[u] = param.(command.Name)
			}
		}
		if len(_params) > 1 {
			_param1 = make([]time.Time, len(c.methodInvocations))
			for u, param := range _params[1] {
				_param1[u] = param.(time.Time)
			}
		}
	}
	return
}

func (verifier *VerifierMockBackend) TryLock(lock models.ProjectLock) *MockBackend_TryLock_OngoingVerification {
	_params := []pegomock.Param{lock}
	methodInvocations := pegomock.GetGenericMockFrom(verifier.mock).Verify(verifier.inOrderContext, verifier.invocationCountMatcher, "TryLock", _params, verifier.timeout)
	return &MockBackend_TryLock_OngoingVerification{mock: verifier.mock, methodInvocations: methodInvocations}
}

type MockBackend_TryLock_OngoingVerification struct {
	mock              *MockBackend
	methodInvocations []pegomock.MethodInvocation
}

func (c *MockBackend_TryLock_OngoingVerification) GetCapturedArguments() models.ProjectLock {
	lock := c.GetAllCapturedArguments()
	return lock[len(lock)-1]
}

func (c *MockBackend_TryLock_OngoingVerification) GetAllCapturedArguments() (_param0 []models.ProjectLock) {
	_params := pegomock.GetGenericMockFrom(c.mock).GetInvocationParams(c.methodInvocations)
	if len(_params) > 0 {
		if len(_params) > 0 {
			_param0 = make([]models.ProjectLock, len(c.methodInvocations))
			for u, param := range _params[0] {
				_param0[u] = param.(models.ProjectLock)
			}
		}
	}
	return
}

func (verifier *VerifierMockBackend) Unlock(project models.Project, workspace string) *MockBackend_Unlock_OngoingVerification {
	_params := []pegomock.Param{project, workspace}
	methodInvocations := pegomock.GetGenericMockFrom(verifier.mock).Verify(verifier.inOrderContext, verifier.invocationCountMatcher, "Unlock", _params, verifier.timeout)
	return &MockBackend_Unlock_OngoingVerification{mock: verifier.mock, methodInvocations: methodInvocations}
}

type MockBackend_Unlock_OngoingVerification struct {
	mock              *MockBackend
	methodInvocations []pegomock.MethodInvocation
}

func (c *MockBackend_Unlock_OngoingVerification) GetCapturedArguments() (models.Project, string) {
	project, workspace := c.GetAllCapturedArguments()
	return project[len(project)-1], workspace[len(workspace)-1]
}

func (c *MockBackend_Unlock_OngoingVerification) GetAllCapturedArguments() (_param0 []models.Project, _param1 []string) {
	_params := pegomock.GetGenericMockFrom(c.mock).GetInvocationParams(c.methodInvocations)
	if len(_params) > 0 {
		if len(_params) > 0 {
			_param0 = make([]models.Project, len(c.methodInvocations))
			for u, param := range _params[0] {
				_param0[u] = param.(models.Project)
			}
		}
		if len(_params) > 1 {
			_param1 = make([]string, len(c.methodInvocations))
			for u, param := range _params[1] {
				_param1[u] = param.(string)
			}
		}
	}
	return
}

func (verifier *VerifierMockBackend) UnlockByPull(repoFullName string, pullNum int) *MockBackend_UnlockByPull_OngoingVerification {
	_params := []pegomock.Param{repoFullName, pullNum}
	methodInvocations := pegomock.GetGenericMockFrom(verifier.mock).Verify(verifier.inOrderContext, verifier.invocationCountMatcher, "UnlockByPull", _params, verifier.timeout)
	return &MockBackend_UnlockByPull_OngoingVerification{mock: verifier.mock, methodInvocations: methodInvocations}
}

type MockBackend_UnlockByPull_OngoingVerification struct {
	mock              *MockBackend
	methodInvocations []pegomock.MethodInvocation
}

func (c *MockBackend_UnlockByPull_OngoingVerification) GetCapturedArguments() (string, int) {
	repoFullName, pullNum := c.GetAllCapturedArguments()
	return repoFullName[len(repoFullName)-1], pullNum[len(pullNum)-1]
}

func (c *MockBackend_UnlockByPull_OngoingVerification) GetAllCapturedArguments() (_param0 []string, _param1 []int) {
	_params := pegomock.GetGenericMockFrom(c.mock).GetInvocationParams(c.methodInvocations)
	if len(_params) > 0 {
		if len(_params) > 0 {
			_param0 = make([]string, len(c.methodInvocations))
			for u, param := range _params[0] {
				_param0[u] = param.(string)
			}
		}
		if len(_params) > 1 {
			_param1 = make([]int, len(c.methodInvocations))
			for u, param := range _params[1] {
				_param1[u] = param.(int)
			}
		}
	}
	return
}

func (verifier *VerifierMockBackend) UnlockCommand(cmdName command.Name) *MockBackend_UnlockCommand_OngoingVerification {
	_params := []pegomock.Param{cmdName}
	methodInvocations := pegomock.GetGenericMockFrom(verifier.mock).Verify(verifier.inOrderContext, verifier.invocationCountMatcher, "UnlockCommand", _params, verifier.timeout)
	return &MockBackend_UnlockCommand_OngoingVerification{mock: verifier.mock, methodInvocations: methodInvocations}
}

type MockBackend_UnlockCommand_OngoingVerification struct {
	mock              *MockBackend
	methodInvocations []pegomock.MethodInvocation
}

func (c *MockBackend_UnlockCommand_OngoingVerification) GetCapturedArguments() command.Name {
	cmdName := c.GetAllCapturedArguments()
	return cmdName[len(cmdName)-1]
}

func (c *MockBackend_UnlockCommand_OngoingVerification) GetAllCapturedArguments() (_param0 []command.Name) {
	_params := pegomock.GetGenericMockFrom(c.mock).GetInvocationParams(c.methodInvocations)
	if len(_params) > 0 {
		if len(_params) > 0 {
			_param0 = make([]command.Name, len(c.methodInvocations))
			for u, param := range _params[0] {
				_param0[u] = param.(command.Name)
			}
		}
	}
	return
}

func (verifier *VerifierMockBackend) UpdateProjectStatus(pull models.PullRequest, workspace string, repoRelDir string, newStatus models.ProjectPlanStatus) *MockBackend_UpdateProjectStatus_OngoingVerification {
	_params := []pegomock.Param{pull, workspace, repoRelDir, newStatus}
	methodInvocations := pegomock.GetGenericMockFrom(verifier.mock).Verify(verifier.inOrderContext, verifier.invocationCountMatcher, "UpdateProjectStatus", _params, verifier.timeout)
	return &MockBackend_UpdateProjectStatus_OngoingVerification{mock: verifier.mock, methodInvocations: methodInvocations}
}

type MockBackend_UpdateProjectStatus_OngoingVerification struct {
	mock              *MockBackend
	methodInvocations []pegomock.MethodInvocation
}

func (c *MockBackend_UpdateProjectStatus_OngoingVerification) GetCapturedArguments() (models.PullRequest, string, string, models.ProjectPlanStatus) {
	pull, workspace, repoRelDir, newStatus := c.GetAllCapturedArguments()
	return pull[len(pull)-1], workspace[len(workspace)-1], repoRelDir[len(repoRelDir)-1], newStatus[len(newStatus)-1]
}

func (c *MockBackend_UpdateProjectStatus_OngoingVerification) GetAllCapturedArguments() (_param0 []models.PullRequest, _param1 []string, _param2 []string, _param3 []models.ProjectPlanStatus) {
	_params := pegomock.GetGenericMockFrom(c.mock).GetInvocationParams(c.methodInvocations)
	if len(_params) > 0 {
		if len(_params) > 0 {
			_param0 = make([]models.PullRequest, len(c.methodInvocations))
			for u, param := range _params[0] {
				_param0[u] = param.(models.PullRequest)
			}
		}
		if len(_params) > 1 {
			_param1 = make([]string, len(c.methodInvocations))
			for u, param := range _params[1] {
				_param1[u] = param.(string)
			}
		}
		if len(_params) > 2 {
			_param2 = make([]string, len(c.methodInvocations))
			for u, param := range _params[2] {
				_param2[u] = param.(string)
			}
		}
		if len(_params) > 3 {
			_param3 = make([]models.ProjectPlanStatus, len(c.methodInvocations))
			for u, param := range _params[3] {
				_param3[u] = param.(models.ProjectPlanStatus)
			}
		}
	}
	return
}

func (verifier *VerifierMockBackend) UpdatePullWithResults(pull models.PullRequest, newResults []command.ProjectResult) *MockBackend_UpdatePullWithResults_OngoingVerification {
	_params := []pegomock.Param{pull, newResults}
	methodInvocations := pegomock.GetGenericMockFrom(verifier.mock).Verify(verifier.inOrderContext, verifier.invocationCountMatcher, "UpdatePullWithResults", _params, verifier.timeout)
	return &MockBackend_UpdatePullWithResults_OngoingVerification{mock: verifier.mock, methodInvocations: methodInvocations}
}

type MockBackend_UpdatePullWithResults_OngoingVerification struct {
	mock              *MockBackend
	methodInvocations []pegomock.MethodInvocation
}

func (c *MockBackend_UpdatePullWithResults_OngoingVerification) GetCapturedArguments() (models.PullRequest, []command.ProjectResult) {
	pull, newResults := c.GetAllCapturedArguments()
	return pull[len(pull)-1], newResults[len(newResults)-1]
}

func (c *MockBackend_UpdatePullWithResults_OngoingVerification) GetAllCapturedArguments() (_param0 []models.PullRequest, _param1 [][]command.ProjectResult) {
	_params := pegomock.GetGenericMockFrom(c.mock).GetInvocationParams(c.methodInvocations)
	if len(_params) > 0 {
		if len(_params) > 0 {
			_param0 = make([]models.PullRequest, len(c.methodInvocations))
			for u, param := range _params[0] {
				_param0[u] = param.(models.PullRequest)
			}
		}
		if len(_params) > 1 {
			_param1 = make([][]command.ProjectResult, len(c.methodInvocations))
			for u, param := range _params[1] {
				_param1[u] = param.([]command.ProjectResult)
			}
		}
	}
	return
}
