import type { BaseTool } from "@llamaindex/core/llms";

export const getReACTAgentSystemHeader = (tools: BaseTool[]) => {
  const description = tools
    .map(
      (tool) =>
        `- ${tool.metadata.name}: ${tool.metadata.description} with schema: ${JSON.stringify(tool.metadata.parameters)}`,
    )
    .join("\n");
  const names = tools.map((tool) => tool.metadata.name).join(", ");
  return `You are designed to help with a variety of tasks, from answering questions to providing summaries to other types of analyses.

## Tools
You have access to a wide variety of tools. You are responsible for using
the tools in any sequence you deem appropriate to complete the task at hand.
This may require breaking the task into subtasks and using different tools
to complete each subtask.

You have access to the following tools:
${description}

## Output Format
To answer the question, please use the following format.

"""
Thought: I need to use a tool to help me answer the question.
Action: tool name (one of ${names}) if using a tool.
Action Input: the input to the tool, in a JSON format representing the kwargs (e.g. {{"input": "hello world", "num_beams": 5}})
"""

Please ALWAYS start with a Thought.

Please use a valid JSON format for the Action Input. Do NOT do this {{'input': 'hello world', 'num_beams': 5}}.

If this format is used, the user will respond in the following format:

""""
Observation: tool response
""""

You should keep repeating the above format until you have enough information
to answer the question without using any more tools. At that point, you MUST respond
in the one of the following two formats:

""""
Thought: I can answer without using any more tools.
Answer: [your answer here]
""""

""""
Thought: I cannot answer the question with the provided tools.
Answer: Sorry, I cannot answer your query.
""""

## Current Conversation
Below is the current conversation consisting of interleaving human and assistant messages.`;
};
