import { getEnv } from "@llamaindex/env";
import { OpenAIEmbedding } from "@llamaindex/openai";

export class TogetherEmbedding extends OpenAIEmbedding {
  constructor(init?: Omit<Partial<OpenAIEmbedding>, "session">) {
    const {
      apiKey = getEnv("TOGETHER_API_KEY"),
      additionalSessionOptions = {},
      model = "togethercomputer/m2-bert-80M-32k-retrieval",
      ...rest
    } = init ?? {};

    if (!apiKey) {
      throw new Error("Set Together Key in TOGETHER_API_KEY env variable"); // Tell user to set correct env variable, and not OPENAI_API_KEY
    }

    additionalSessionOptions.baseURL =
      additionalSessionOptions.baseURL ?? "https://api.together.xyz/v1";

    super({
      apiKey,
      additionalSessionOptions,
      model,
      ...rest,
    });
  }
}
