import {
  createExecutionContext,
  env,
  waitOnExecutionContext,
} from "cloudflare:test";
import { describe, expect, it } from "vitest";
import worker from "../src/index";

const IncomingRequest = Request<unknown, IncomingRequestCfProperties>;

describe("Hello World worker", () => {
  // FIXME: https://github.com/cloudflare/workers-sdk/issues/5646
  it.fails("responds with Hello World! (unit style)", async () => {
    const request = new IncomingRequest("http://example.com");
    // Create an empty context to pass to `worker.fetch()`.
    const ctx = createExecutionContext();
    const response = await worker.fetch(
      request,
      { ...env, OPENAI_API_KEY: "sk-1234" },
      ctx,
    );
    // Wait for all `Promise`s passed to `ctx.waitUntil()` to settle before running test assertions
    await waitOnExecutionContext(ctx);
    // fixme: should be not "Hello World!"
    expect(await response.text()).toMatchInlineSnapshot(`"Hello World!"`);
  });
});
