# https://registry.terraform.io/providers/hashicorp/google/latest/docs/resources/compute_subnetwork
resource "google_compute_subnetwork" "private" {
  name                     = "private"
  ip_cidr_range            = "10.0.0.0/18"
  region                   = "us-east1"
  network                  = google_compute_network.main.id
  private_ip_google_access = true

  secondary_ip_range {  # CIDR for pods
    range_name    = "k8s-pod-range"
    ip_cidr_range = "10.48.0.0/14"
  }
  secondary_ip_range { # CIDR for services
    range_name    = "k8s-service-range"
    ip_cidr_range = "10.52.0.0/20"
  }
}
