% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valueBoxOutput.R
\name{renderValueBox}
\alias{renderValueBox}
\alias{renderInfoBox}
\title{Create an info or value box output (server side)}
\usage{
renderValueBox(expr, env = parent.frame(), quoted = FALSE)

renderInfoBox(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{expr}{An expression that returns a Shiny tag object, \code{\link[shiny:reexports]{HTML()}},
or a list of such objects.}

\item{env}{The parent environment for the reactive expression. By default,
this is the calling environment, the same as when defining an ordinary
non-reactive expression. If \code{expr} is a quosure and \code{quoted} is \code{TRUE},
then \code{env} is ignored.}

\item{quoted}{If it is \code{TRUE}, then the \code{\link[=quote]{quote()}}ed value of \code{expr}
will be used when \code{expr} is evaluated. If \code{expr} is a quosure and you
would like to use its expression as a value for \code{expr}, then you must set
\code{quoted} to \code{TRUE}.}
}
\description{
This is the server-side function for creating a dynamic
\code{\link{valueBox}} or \code{\link{infoBox}}.
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {
library(shiny)

ui <- dashboardPage(
  dashboardHeader(title = "Dynamic boxes"),
  dashboardSidebar(),
  dashboardBody(
    fluidRow(
      box(width = 2, actionButton("count", "Count")),
      infoBoxOutput("ibox"),
      valueBoxOutput("vbox")
    )
  )
)

server <- function(input, output) {
  output$ibox <- renderInfoBox({
    infoBox(
      "Title",
      input$count,
      icon = icon("credit-card")
    )
  })
  output$vbox <- renderValueBox({
    valueBox(
      "Title",
      input$count,
      icon = icon("credit-card")
    )
  })
}

shinyApp(ui, server)
}
}
\seealso{
\code{\link{valueBoxOutput}} for the corresponding UI-side function.
}
