-- ----------------------------------------
-- RRZCMS MySQL Data Transfer 
-- 
-- Server         : 127.0.0.1_3306
-- Server Version : 5.7.26
-- Database       : rrzcms
-- 
-- Part : #1
-- Version : #v1.3.7
-- Date : 2022-02-10 11:26:06
-- -----------------------------------------

SET FOREIGN_KEY_CHECKS = 0;


-- ----------------------------
-- Table structure for `rrz_admin`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin`;
CREATE TABLE `rrz_admin` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `user_name` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `pen_name` varchar(50) DEFAULT '' COMMENT '笔名（发布文章后显示责任编辑的名字）',
  `true_name` varchar(50) DEFAULT '' COMMENT '真实姓名',
  `mobile` varchar(50) DEFAULT '' COMMENT '手机号码',
  `email` varchar(60) DEFAULT '' COMMENT 'email',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT '密码',
  `head_pic` varchar(255) DEFAULT '' COMMENT '头像',
  `last_login` int(11) unsigned DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_cnt` int(11) unsigned DEFAULT '0' COMMENT '登录次数',
  `session_id` varchar(50) DEFAULT '' COMMENT 'session_id',
  `parent_id` int(10) unsigned DEFAULT '0' COMMENT '父管理员ID',
  `role_id` int(10) NOT NULL DEFAULT '-1' COMMENT '角色组ID（-1表示超级管理员）',
  `mark_lang` varchar(50) DEFAULT 'cn' COMMENT '当前语言标识',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `syn_users_id` int(10) unsigned DEFAULT '0' COMMENT '同步注册到会员表',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_name` (`user_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员表';

-- -----------------------------
-- Records of `rrz_admin`
-- -----------------------------
INSERT INTO `rrz_admin` VALUES ('1', 'admin', '', 'admin', '', '', '21232f297a57a5a743894a0e4a801fc3', '/static/images/dfboy.png', '1644462330', '127.0.0.1', '47', '', '0', '1', 'cn', '1', '1', '1586479354', '1588751715');

-- ----------------------------
-- Table structure for `rrz_admin_log`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_log`;
CREATE TABLE `rrz_admin_log` (
  `id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `admin_id` int(10) NOT NULL DEFAULT '-1' COMMENT '管理员id',
  `log_info` text COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT '' COMMENT 'ip地址',
  `log_url` varchar(255) DEFAULT '' COMMENT 'url',
  `log_time` int(11) DEFAULT '0' COMMENT '日志时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员日志表';


-- ----------------------------
-- Table structure for `rrz_admin_role`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_role`;
CREATE TABLE `rrz_admin_role` (
  `role_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `role_name` varchar(30) DEFAULT NULL COMMENT '角色名称',
  `act_list` text COMMENT '权限列表',
  `role_desc` varchar(255) DEFAULT NULL COMMENT '角色描述',
  PRIMARY KEY (`role_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='用户角色表';

-- -----------------------------
-- Records of `rrz_admin_role`
-- -----------------------------
INSERT INTO `rrz_admin_role` VALUES ('1', '超级管理员', 'all', '管理全站');

-- ----------------------------
-- Table structure for `rrz_article_nodes`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_article_nodes`;
CREATE TABLE `rrz_article_nodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目名称',
  `en_title` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目英文名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '栏目图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '栏目深度',
  `sort` smallint(6) unsigned DEFAULT '50' COMMENT '排序',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `view_route` varchar(255) NOT NULL DEFAULT '{typedir}/{aid}.html' COMMENT '详情页路由',
  `list_route` varchar(255) NOT NULL DEFAULT '{typedir}/list_{tid}_{page}.html' COMMENT '列表页路由',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '发布',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章类目';

-- -----------------------------
-- Records of `rrz_article_nodes`
-- -----------------------------
INSERT INTO `rrz_article_nodes` VALUES ('1', '0', '景点介绍', 'ATTRACTIONS', 'jdjs', '0', '', '1', '1', '1', '1001', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '景点介绍', '四川省茶业集团股份有限公司(以下简称“川茶集团”)于2013年10月成立，是以原四川省叙府茶业有限公司为主体联合省内多家茶叶企业共同发起组建的四川首家集茶树良种繁育、种植示范、茶叶初精深加工、品牌营销、科技研发与推广、茶文化应用与茶旅游发展以及其他茶', '', '<p>&nbsp;四川省茶业集团股份有限公司(以下简称“川茶集团”)于2013年10月成立，是以原四川省叙府茶业有限公司为主体联合省内多家茶叶企业共同发起组建的四川首家集茶树良种繁育、种植示范、茶叶初精深加工、品牌营销、科技研发与推广、茶文化应用与茶旅游发展以及其他茶叶关联产业等为一体的现代茶产业集群。</p><p>\r\n	川茶集团是省、市、区各级党委政府重点扶持打造的“农业产业化国家重点龙头企业”、“全国农业产业化优秀龙头企业”、川茶千亿产业发展的排头兵企业。近年来，集团在翠屏区邱场、明威、金坪三个乡镇与茶农共同建设打造的十万亩优质早茶基地效果显著，得到省委省政府、相关部门和茶界同仁的高度肯定，在宜宾县打造的黄山有机茶基地现在已是全国连片规模最大的高山有机茶基地，同时也是全国唯一一个连续十年通过国内国际双认证的有机茶生产基地，集团创新产品“天府龙芽”更是获得一个世纪以来中国茶产业的顶级奖项——百年世博中国名茶金骆驼奖。</p><p>\r\n	集团公司坚持以科技创新支撑全茶产业链发展，在川茶产业转型升级发展中走出了一条科技支撑、创新驱动的道路，引领全国茶行业科技创新。2014年2月26日，“川茶产业商学院”挂牌成立；2014年3月19日，“川茶产业技术研究院”授牌，与川茶集团拥有的全国茶行业目前唯一的“国家认定企业技术中心”和全省唯一的“四川省茶业工程技术研究中心”，合称为四川省茶业集团“两院两中心”。2015年3月，根据四川省委组织部、省经济和信息化委、省国资委等七部门印发的《四川省院士（专家）工作站实施办法》，川茶集团成为四川省首家获批成立院士工作站的茶叶企业，进站院士（专家）由陈宗懋先生担任。自此，川茶集团最终形成了“一站两院两中心”的科技创新支持体系，实现了川茶集团在以科技创新为支撑引领四川、乃至全国茶产业发展道路上又一里程碑式的跨越。</p><p>\r\n	集团始终以推动川茶产业崛起振兴为己任，充分发挥千亿川茶产业排头兵作用，奋力领舞川茶产业整体转型升级。2013年，四川省委省政府明确提出了“组建川茶集团，实施抱团发展，打造川茶千亿大产业”的战略目标，作为“川茶集团联盟”的发起单位，集团秉承“资源共享、优势互补、抱团发展、联合共赢”的理念，联合峨眉雪芽、米仓山、早白尖等30多家茶企，共同促进川茶全产业链发展的体制机制创新、管理体系创新、品牌与营销体系创新，推进川茶产业转型升级。同时，作为四川省川茶品牌促进会会长单位，严格贯彻落实省委省政府一号文件《关于加快川茶产业转型升级建设茶业强省的意见》关于打造川茶大区域品牌重要指示精神，联合省内100多家茶企共同打造川茶大区域品牌，提升川茶品牌整体竞争力。2015年5月26日，省川茶产业发展联席会议办公室组织召开了“加快推进川茶品牌建设工作座谈会”，会议广泛讨论，再次征求意见，一致同意推选“天府龙芽”作为川茶大区域品牌。2015年6月7日，史哈副省长作出重要批示，同意将“天府龙芽”作为川茶大区域品牌来打造。目前，作为全国茶行业科技创新的引领者和川茶产业发展排头兵，川茶集团正肩负新的历史使命昂首前行。</p>', '', 'true', '1644389942');
INSERT INTO `rrz_article_nodes` VALUES ('3', '1', '客房展示', 'GUEST ROOM', 'kfzs', '0', '', '3', '1', '2', '1002', 'image', 'image', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '客房展示', '', '', '', '', 'true', '1644389198');
INSERT INTO `rrz_article_nodes` VALUES ('4', '1', '标准间', '', 'kfzs/bzj', '3', '', '3,4', '2', '1', '10021001', 'image', 'image', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '标准间', '', '', '&nbsp;', '', 'true', '1644386286');
INSERT INTO `rrz_article_nodes` VALUES ('5', '1', '多人间', '', 'kfzs/drj', '3', '', '3,5', '2', '2', '10021002', 'image', 'image', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '多人间', '', '', '&nbsp;', '', 'true', '1644386287');
INSERT INTO `rrz_article_nodes` VALUES ('6', '1', '双人间', '', 'kfzs/srj', '3', '', '3,6', '2', '3', '10021003', 'image', 'image', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '双人间', '', '', '&nbsp;', '', 'true', '1644386287');
INSERT INTO `rrz_article_nodes` VALUES ('7', '1', '商务间', '', 'kfzs/swj', '3', '', '3,7', '2', '4', '10021004', 'image', 'image', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '商务间', '', '', '&nbsp;', '', 'true', '1644386287');
INSERT INTO `rrz_article_nodes` VALUES ('9', '0', '景点新闻', '', 'news', '0', '', '9', '1', '3', '1003', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '景点新闻', '', '', '&nbsp;', '', 'true', '1644386287');
INSERT INTO `rrz_article_nodes` VALUES ('2', '0', '路线推荐', '', 'lxtj', '0', '', '2', '1', '4', '1004', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '路线推荐', '', '', '<br />\r\n', '', 'true', '1644386287');
INSERT INTO `rrz_article_nodes` VALUES ('10', '0', '农家大院', 'FARMHOUSE', 'njdy', '0', '', '10', '1', '5', '1005', 'news', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '农家大院', '四川省茶业集团股份有限公司(以下简称“川茶集团”)于2013年10月成立，是以原四川省叙府茶业有限公司为主体联合省内多家茶叶企业共同发起组建的四川首家集茶树良种繁育、种植示范、茶叶初精深加工、品牌营销、科技研发与推广、茶文化应用与茶旅游发展以及其他茶', '', '<p>&nbsp;四川省茶业集团股份有限公司(以下简称“川茶集团”)于2013年10月成立，是以原四川省叙府茶业有限公司为主体联合省内多家茶叶企业共同发起组建的四川首家集茶树良种繁育、种植示范、茶叶初精深加工、品牌营销、科技研发与推广、茶文化应用与茶旅游发展以及其他茶叶关联产业等为一体的现代茶产业集群。</p><p>\r\n	川茶集团是省、市、区各级党委政府重点扶持打造的“农业产业化国家重点龙头企业”、“全国农业产业化优秀龙头企业”、川茶千亿产业发展的排头兵企业。近年来，集团在翠屏区邱场、明威、金坪三个乡镇与茶农共同建设打造的十万亩优质早茶基地效果显著，得到省委省政府、相关部门和茶界同仁的高度肯定，在宜宾县打造的黄山有机茶基地现在已是全国连片规模最大的高山有机茶基地，同时也是全国唯一一个连续十年通过国内国际双认证的有机茶生产基地，集团创新产品“天府龙芽”更是获得一个世纪以来中国茶产业的顶级奖项——百年世博中国名茶金骆驼奖。</p><p>\r\n	集团公司坚持以科技创新支撑全茶产业链发展，在川茶产业转型升级发展中走出了一条科技支撑、创新驱动的道路，引领全国茶行业科技创新。2014年2月26日，“川茶产业商学院”挂牌成立；2014年3月19日，“川茶产业技术研究院”授牌，与川茶集团拥有的全国茶行业目前唯一的“国家认定企业技术中心”和全省唯一的“四川省茶业工程技术研究中心”，合称为四川省茶业集团“两院两中心”。2015年3月，根据四川省委组织部、省经济和信息化委、省国资委等七部门印发的《四川省院士（专家）工作站实施办法》，川茶集团成为四川省首家获批成立院士工作站的茶叶企业，进站院士（专家）由陈宗懋先生担任。自此，川茶集团最终形成了“一站两院两中心”的科技创新支持体系，实现了川茶集团在以科技创新为支撑引领四川、乃至全国茶产业发展道路上又一里程碑式的跨越。</p><p>\r\n	集团始终以推动川茶产业崛起振兴为己任，充分发挥千亿川茶产业排头兵作用，奋力领舞川茶产业整体转型升级。2013年，四川省委省政府明确提出了“组建川茶集团，实施抱团发展，打造川茶千亿大产业”的战略目标，作为“川茶集团联盟”的发起单位，集团秉承“资源共享、优势互补、抱团发展、联合共赢”的理念，联合峨眉雪芽、米仓山、早白尖等30多家茶企，共同促进川茶全产业链发展的体制机制创新、管理体系创新、品牌与营销体系创新，推进川茶产业转型升级。同时，作为四川省川茶品牌促进会会长单位，严格贯彻落实省委省政府一号文件《关于加快川茶产业转型升级建设茶业强省的意见》关于打造川茶大区域品牌重要指示精神，联合省内100多家茶企共同打造川茶大区域品牌，提升川茶品牌整体竞争力。2015年5月26日，省川茶产业发展联席会议办公室组织召开了“加快推进川茶品牌建设工作座谈会”，会议广泛讨论，再次征求意见，一致同意推选“天府龙芽”作为川茶大区域品牌。2015年6月7日，史哈副省长作出重要批示，同意将“天府龙芽”作为川茶大区域品牌来打造。目前，作为全国茶行业科技创新的引领者和川茶产业发展排头兵，川茶集团正肩负新的历史使命昂首前行。</p>', '', 'true', '1644389800');
INSERT INTO `rrz_article_nodes` VALUES ('8', '0', '特色美食', 'SPECIALTIES', 'tsms', '0', '', '8', '1', '6', '1006', 'image', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '特色美食', '', '', '', '', 'true', '1644389239');
INSERT INTO `rrz_article_nodes` VALUES ('28', '0', '活动专题', '', 'huodongzhuanti', '0', '', '28', '1', '7', '1007', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '&nbsp;', '', 'true', '1644386287');
INSERT INTO `rrz_article_nodes` VALUES ('11', '0', '在线留言', '', 'zaixianliuyan', '0', '', '11', '1', '8', '1008', 'single_liuyan', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', 'FEEDBACK', '', '', '&nbsp;', '', 'true', '1644386287');
INSERT INTO `rrz_article_nodes` VALUES ('12', '0', '联系我们', '', 'lianxiwomen', '0', '', '12', '1', '9', '1009', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', 'CONTACT US', '', '', '<p>\r\n	地址：这里是您的公司地址<br />\r\n	电话：+86-0000-96877<br />\r\n	传真：+86-0000-96877<br />\r\n	邮编：000000<br />\r\n	邮箱：这里是您公司的邮箱地址 &nbsp;</p>\r\n', '', 'true', '1644386287');

-- ----------------------------
-- Table structure for `rrz_articles`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_articles`;
CREATE TABLE `rrz_articles` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `node_id` mediumint(8) NOT NULL DEFAULT '0' COMMENT '类别ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '文章标题',
  `subtitle` varchar(255) DEFAULT '' COMMENT '副标题',
  `img` varchar(255) NOT NULL DEFAULT '' COMMENT '文章配图',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `author` varchar(100) NOT NULL DEFAULT '' COMMENT '文章作者',
  `author_email` varchar(60) NOT NULL DEFAULT '' COMMENT '作者邮箱',
  `uptime` int(10) unsigned DEFAULT '0' COMMENT '更新时间',
  `pubtime` int(10) unsigned DEFAULT '0' COMMENT '文章发布时间',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '发布',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '文章创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  `source` varchar(100) NOT NULL DEFAULT '' COMMENT '来源',
  `source_url` varchar(255) NOT NULL DEFAULT '' COMMENT '来源URL',
  `tb1_imgurls` text COMMENT '图片集合',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_node_id` (`node_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章';

-- -----------------------------
-- Records of `rrz_articles`
-- -----------------------------
INSERT INTO `rrz_articles` VALUES ('1', '4', '产品展示标题', '', '/storage/images/20220209/1-160FQ64532221.jpg', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！<br />\r\n愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！<br />\r\n记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”<br />\r\n为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。<br />\r\n传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。<br />\r\n记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”', '', 'admin', '', '1466828245', '1466828245', 'true', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '', '172', '1467967529', '0', '0', '0', '100', '未知', '', '/storage/images/20220209/1-160625121627.jpg,/storage/images/20220209/1-160625121628.jpg,/storage/images/20220209/1-160625121629.jpg,/storage/images/20220209/1-160625121630.jpg,/storage/images/20220209/1-160625121631.jpg,/storage/images/20220209/1-160625121634.jpg,/storage/images/20220209/1-160625121637.jpg,/storage/images/20220209/1-160625121640.jpg');
INSERT INTO `rrz_articles` VALUES ('2', '4', '产品展示标题', '', '/storage/images/20220209/1-160Q113202Q14.jpg', '', '<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”</span>', '', 'admin', '', '1466833065', '1466833065', 'true', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '', '97', '1470892824', '0', '0', '0', '100', '未知', '', '/storage/images/20220209/1-160625133I3.jpg,/storage/images/20220209/1-160625133I5.jpg,/storage/images/20220209/1-160625133I6.jpg,/storage/images/20220209/1-160625133I7.jpg,/storage/images/20220209/1-160625133I8.jpg,/storage/images/20220209/1-160625133I9.jpg,/storage/images/20220209/1-160625133J0.jpg,/storage/images/20220209/1-160625133J1.jpg');
INSERT INTO `rrz_articles` VALUES ('3', '4', '产品展示标题', '', '/storage/images/20220209/1-160FQ64532221.jpg', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！<br />\r\n愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！<br />\r\n记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”<br />\r\n为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。<br />\r\n传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。<br />\r\n记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”', '', 'admin', '', '1466828245', '1466828245', 'true', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '', '172', '1467967529', '0', '0', '0', '100', '未知', '', '/storage/images/20220209/1-160625121627.jpg,/storage/images/20220209/1-160625121628.jpg,/storage/images/20220209/1-160625121629.jpg,/storage/images/20220209/1-160625121630.jpg,/storage/images/20220209/1-160625121631.jpg,/storage/images/20220209/1-160625121634.jpg,/storage/images/20220209/1-160625121637.jpg,/storage/images/20220209/1-160625121640.jpg');
INSERT INTO `rrz_articles` VALUES ('4', '4', '产品展示标题', '', '/storage/images/20220209/1-160Q113202Q14.jpg', '', '<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”</span>', '', 'admin', '', '1466833065', '1466833065', 'true', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '', '97', '1470892824', '0', '0', '0', '100', '未知', '', '/storage/images/20220209/1-160625133I3.jpg,/storage/images/20220209/1-160625133I5.jpg,/storage/images/20220209/1-160625133I6.jpg,/storage/images/20220209/1-160625133I7.jpg,/storage/images/20220209/1-160625133I8.jpg,/storage/images/20220209/1-160625133I9.jpg,/storage/images/20220209/1-160625133J0.jpg,/storage/images/20220209/1-160625133J1.jpg');
INSERT INTO `rrz_articles` VALUES ('5', '4', '产品展示标题', '', '/storage/images/20220209/1-160FQ64532221.jpg', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！<br />\r\n愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！<br />\r\n记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”<br />\r\n为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。<br />\r\n传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。<br />\r\n记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”', '', 'admin', '', '1466828245', '1466828245', 'true', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '', '172', '1467967529', '0', '0', '0', '100', '未知', '', '/storage/images/20220209/1-160625121627.jpg,/storage/images/20220209/1-160625121628.jpg,/storage/images/20220209/1-160625121629.jpg,/storage/images/20220209/1-160625121630.jpg,/storage/images/20220209/1-160625121631.jpg,/storage/images/20220209/1-160625121634.jpg,/storage/images/20220209/1-160625121637.jpg,/storage/images/20220209/1-160625121640.jpg');
INSERT INTO `rrz_articles` VALUES ('6', '4', '产品展示标题', '', '/storage/images/20220209/1-160Q113202Q14.jpg', '', '<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”</span>', '', 'admin', '', '1466833065', '1466833065', 'true', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '', '97', '1470892824', '0', '0', '0', '100', '未知', '', '/storage/images/20220209/1-160625133I3.jpg,/storage/images/20220209/1-160625133I5.jpg,/storage/images/20220209/1-160625133I6.jpg,/storage/images/20220209/1-160625133I7.jpg,/storage/images/20220209/1-160625133I8.jpg,/storage/images/20220209/1-160625133I9.jpg,/storage/images/20220209/1-160625133J0.jpg,/storage/images/20220209/1-160625133J1.jpg');
INSERT INTO `rrz_articles` VALUES ('7', '4', '产品展示标题', '', '/storage/images/20220209/1-160FQ64532221.jpg', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！<br />\r\n愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！<br />\r\n记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”<br />\r\n为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。<br />\r\n传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。<br />\r\n记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”', '', 'admin', '', '1466828245', '1466828245', 'true', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '', '172', '1467967529', '0', '0', '0', '100', '未知', '', '/storage/images/20220209/1-160625121627.jpg,/storage/images/20220209/1-160625121628.jpg,/storage/images/20220209/1-160625121629.jpg,/storage/images/20220209/1-160625121630.jpg,/storage/images/20220209/1-160625121631.jpg,/storage/images/20220209/1-160625121634.jpg,/storage/images/20220209/1-160625121637.jpg,/storage/images/20220209/1-160625121640.jpg');
INSERT INTO `rrz_articles` VALUES ('8', '4', '产品展示标题', '', '/storage/images/20220209/1-160Q113202Q14.jpg', '', '<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”</span>', '', 'admin', '', '1466833065', '1466833065', 'true', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '', '97', '1470892824', '0', '0', '0', '100', '未知', '', '/storage/images/20220209/1-160625133I3.jpg,/storage/images/20220209/1-160625133I5.jpg,/storage/images/20220209/1-160625133I6.jpg,/storage/images/20220209/1-160625133I7.jpg,/storage/images/20220209/1-160625133I8.jpg,/storage/images/20220209/1-160625133I9.jpg,/storage/images/20220209/1-160625133J0.jpg,/storage/images/20220209/1-160625133J1.jpg');
INSERT INTO `rrz_articles` VALUES ('9', '4', '产品展示标题', '', '/storage/images/20220209/1-160FQ64532221.jpg', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！<br />\r\n愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！<br />\r\n记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”<br />\r\n为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。<br />\r\n传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。<br />\r\n记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”', '', 'admin', '', '1466828245', '1466828245', 'true', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '', '172', '1467967529', '0', '0', '0', '100', '未知', '', '/storage/images/20220209/1-160625121627.jpg,/storage/images/20220209/1-160625121628.jpg,/storage/images/20220209/1-160625121629.jpg,/storage/images/20220209/1-160625121630.jpg,/storage/images/20220209/1-160625121631.jpg,/storage/images/20220209/1-160625121634.jpg,/storage/images/20220209/1-160625121637.jpg,/storage/images/20220209/1-160625121640.jpg');
INSERT INTO `rrz_articles` VALUES ('10', '4', '产品展示标题', '', '/storage/images/20220209/1-160Q113202Q14.jpg', '', '<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”</span>', '', 'admin', '', '1466833065', '1466833065', 'true', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '', '97', '1470892824', '0', '0', '0', '100', '未知', '', '/storage/images/20220209/1-160625133I3.jpg,/storage/images/20220209/1-160625133I5.jpg,/storage/images/20220209/1-160625133I6.jpg,/storage/images/20220209/1-160625133I7.jpg,/storage/images/20220209/1-160625133I8.jpg,/storage/images/20220209/1-160625133I9.jpg,/storage/images/20220209/1-160625133J0.jpg,/storage/images/20220209/1-160625133J1.jpg');
INSERT INTO `rrz_articles` VALUES ('11', '4', '产品展示标题', '', '/storage/images/20220209/1-160FQ64532221.jpg', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！<br />\r\n愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！<br />\r\n记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”<br />\r\n为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。<br />\r\n传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。<br />\r\n记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”', '', 'admin', '', '1466828245', '1466828245', 'true', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '', '172', '1467967529', '0', '0', '0', '100', '未知', '', '/storage/images/20220209/1-160625121627.jpg,/storage/images/20220209/1-160625121628.jpg,/storage/images/20220209/1-160625121629.jpg,/storage/images/20220209/1-160625121630.jpg,/storage/images/20220209/1-160625121631.jpg,/storage/images/20220209/1-160625121634.jpg,/storage/images/20220209/1-160625121637.jpg,/storage/images/20220209/1-160625121640.jpg');
INSERT INTO `rrz_articles` VALUES ('12', '4', '产品展示标题', '', '/storage/images/20220209/1-160Q113202Q14.jpg', '', '<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”</span>', '', 'admin', '', '1466833065', '1466833065', 'true', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '', '98', '1470892824', '0', '0', '0', '100', '未知', '', '/storage/images/20220209/1-160625133I3.jpg,/storage/images/20220209/1-160625133I5.jpg,/storage/images/20220209/1-160625133I6.jpg,/storage/images/20220209/1-160625133I7.jpg,/storage/images/20220209/1-160625133I8.jpg,/storage/images/20220209/1-160625133I9.jpg,/storage/images/20220209/1-160625133J0.jpg,/storage/images/20220209/1-160625133J1.jpg');
INSERT INTO `rrz_articles` VALUES ('13', '9', '什么叫万能钥匙，怎么才能开万把锁？', '', '/storage/images/20220209/1-160FQ64532221.jpg', '', '俗话说，“一把钥匙开一把锁”，它不仅是指钥匙与锁之间的专一性，更表明晰锁的安全性。但记者近来在商场上查询发现，一把通常的钥匙能翻开多把锁的状况并不罕见，特别是在那些同一类型的锁之间。<br />\r\n业内人士表明，目前商场上有部分价低质劣的锁，其出产工艺底子不符合标准，防盗功能极差。它们的存在现已危害了全部锁具职业的开展。<br />\r\n有关部门也提示消费者，在采购锁具时，应挑选闻名和正规公司的产品。一起，如因锁具质量疑问造成财产损失的，受害者可凭有用依据，经过法令路径，追查经销商或出产公司的职责。<br />\r\n“万能钥匙”为何能开万把锁<br />\r\n锁具商场产品质量堪忧亟待进步准入门槛<br />\r\n一把旧钥匙开了4把新锁<br />\r\n家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！<br />\r\n愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！<br />\r\n记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”<br />\r\n为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。<br />\r\n传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。<br />\r\n记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”<br />\r\n记者提出想试试这些锁牢不牢靠，老板赞同了。当着老板的面，记者随意取出其中一把锁的钥匙，试开其他的锁。开到第三把时，只听“咔吧”一声，本来不相匹配的钥匙轻轻松松地把锁翻开了。老板气色略变，自个拿过钥匙连开几下，每次都能翻开。<br />\r\n“巧了，肯定是巧了。”老板情急之下说：“我半个月前进了一批锁，那批锁是真的有疑问，18把锁都能相互翻开，全被我退了。这一批是新进的，应当不至于啊。”<br />\r\n网上有人售卖“万能钥匙”<br />\r\n市民小张则在杭州某论坛里看到了一个“出售正宗万能钥匙”的帖子。这马上让他联想起了自个丢的两辆自行车。小张坚持以为，“一定是小偷用万能钥匙开的锁。”<br />\r\n依据小张提示，记者找到了这个帖子。帖子里有个“图样”，有十几件形状各异的东西，大多身形细长，有钩有齿。卖家在帖子里确保，用这些东西，“通常的锁都能翻开”。', '', 'admin', '', '1466829158', '1466829158', 'true', '', '俗话说，一把钥匙开一把锁，它不仅是指钥匙与锁之间的专一性，更表明晰锁的安全性。但记者近来在商场上查询发现，一把通常的钥匙能翻开多把锁的状况并不罕见，特别是在那些同', '什么,叫,万能,钥匙,怎么,才,能开,万把,锁,', '168', '1466829147', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('14', '9', '\'十二五\'发展目标任务打造世界锁具强国', '', '/storage/images/20220209/1-160FQ64532221.jpg', '', '<p>\r\n	随着锁具行业的发展趋势急剧上升，市场需求量也逐渐增大，中国已成为全球锁具的制造和消费大国。近年来欧美、德国、日本等发达国家经济回暖，我国经济持续高速发展，出口竞争力增强，外贸出口也成倍增长。我国多类锁具市场需求不断增加，更多优秀企业不断发展，锁具行业开始进入了品牌化之路。</p>\r\n<p>\r\n	　 　全球锁具产品及技术日新月异，锁具市场已成为一个众人来掘的&#39;超级金矿&#39;。由于住宅和汽车等支柱产业的发展、人们生活水平的提高及家居装潢增多，对锁具 的需求越来越多，极大带动了锁具市场的消费需求，也促使了锁具行业突飞猛进的发展。广州锁博会顺势而下，及时满足了全球经济的应时之需。</p>\r\n<p>\r\n	　 　依靠科技进步，提高装备水平，积极采用新工艺、新材料。加大自主研发力度，加强制锁企业和设备企业的合作，确定重点，联合攻关；加大投入，特别是一些大 企业要积极引进和消化国际一流水平的加工中心，带动全行业上档次，上水平；要在表面处理和加工工艺上做文章，提高产品的耐用度和装饰性；要开发和应用新技 术、新材料，在提高产品安全性、耐用性和装饰性的同时，节能降耗，减少污染并提高效率。以市场为导向，加大调整产品结构力度，选准切入点，把高科技、高附 加值的门锁及商用锁作为研发重点，加大材料工艺、技术上与国际标准相接轨的力度。实施名牌战略。进一步提高品牌意识，狠抓质量 管理，严格质量标准，培育出一批品质过硬，推出在国内外市场具有一定影响力的锁具品牌。面对经济全球化，国内国外两个市场一起抓。不断扩大住宅、汽车、酒 店等支柱型产业和国防、安全、金融等系统对高防范性安保产品的需求应用。开创锁具市场的新局面，把小产品做成大行业，把世界锁具大国发展成为世界锁具强 国。在此大环境之下，基于上届广州锁博会的成功举办对行业的极大推动，此展会已成为发展锁具产业的有力助手，2012年广州锁博会更是得到了政府的大力扶 持，本届展会企业参展将得到高达65%的参展补贴，鼓励行业企业参展，为加快行业快速发展提供了契机。</p>\r\n', '', 'admin', '', '1466832095', '1466832095', 'true', '', '随着锁具行业的发展趋势急剧上升，市场需求量也逐渐增大，中国已成为全球锁具的制造和消费大国。近年来欧美、德国、日本等发达国家经济回暖，我国经济持续高速发展，出口竞争', '十,二五,发展目标,任务,打造,世界,锁具,强国,', '129', '1466832086', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('15', '9', '什么叫万能钥匙，怎么才能开万把锁？', '', '/storage/images/20220209/1-160FQ64532221.jpg', '', '俗话说，“一把钥匙开一把锁”，它不仅是指钥匙与锁之间的专一性，更表明晰锁的安全性。但记者近来在商场上查询发现，一把通常的钥匙能翻开多把锁的状况并不罕见，特别是在那些同一类型的锁之间。<br />\r\n业内人士表明，目前商场上有部分价低质劣的锁，其出产工艺底子不符合标准，防盗功能极差。它们的存在现已危害了全部锁具职业的开展。<br />\r\n有关部门也提示消费者，在采购锁具时，应挑选闻名和正规公司的产品。一起，如因锁具质量疑问造成财产损失的，受害者可凭有用依据，经过法令路径，追查经销商或出产公司的职责。<br />\r\n“万能钥匙”为何能开万把锁<br />\r\n锁具商场产品质量堪忧亟待进步准入门槛<br />\r\n一把旧钥匙开了4把新锁<br />\r\n家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！<br />\r\n愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！<br />\r\n记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”<br />\r\n为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。<br />\r\n传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。<br />\r\n记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”<br />\r\n记者提出想试试这些锁牢不牢靠，老板赞同了。当着老板的面，记者随意取出其中一把锁的钥匙，试开其他的锁。开到第三把时，只听“咔吧”一声，本来不相匹配的钥匙轻轻松松地把锁翻开了。老板气色略变，自个拿过钥匙连开几下，每次都能翻开。<br />\r\n“巧了，肯定是巧了。”老板情急之下说：“我半个月前进了一批锁，那批锁是真的有疑问，18把锁都能相互翻开，全被我退了。这一批是新进的，应当不至于啊。”<br />\r\n网上有人售卖“万能钥匙”<br />\r\n市民小张则在杭州某论坛里看到了一个“出售正宗万能钥匙”的帖子。这马上让他联想起了自个丢的两辆自行车。小张坚持以为，“一定是小偷用万能钥匙开的锁。”<br />\r\n依据小张提示，记者找到了这个帖子。帖子里有个“图样”，有十几件形状各异的东西，大多身形细长，有钩有齿。卖家在帖子里确保，用这些东西，“通常的锁都能翻开”。', '', 'admin', '', '1466829158', '1466829158', 'true', '', '俗话说，一把钥匙开一把锁，它不仅是指钥匙与锁之间的专一性，更表明晰锁的安全性。但记者近来在商场上查询发现，一把通常的钥匙能翻开多把锁的状况并不罕见，特别是在那些同', '什么,叫,万能,钥匙,怎么,才,能开,万把,锁,', '168', '1466829147', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('16', '9', '\'十二五\'发展目标任务打造世界锁具强国', '', '/storage/images/20220209/1-160FQ64532221.jpg', '', '<p>\r\n	随着锁具行业的发展趋势急剧上升，市场需求量也逐渐增大，中国已成为全球锁具的制造和消费大国。近年来欧美、德国、日本等发达国家经济回暖，我国经济持续高速发展，出口竞争力增强，外贸出口也成倍增长。我国多类锁具市场需求不断增加，更多优秀企业不断发展，锁具行业开始进入了品牌化之路。</p>\r\n<p>\r\n	　 　全球锁具产品及技术日新月异，锁具市场已成为一个众人来掘的&#39;超级金矿&#39;。由于住宅和汽车等支柱产业的发展、人们生活水平的提高及家居装潢增多，对锁具 的需求越来越多，极大带动了锁具市场的消费需求，也促使了锁具行业突飞猛进的发展。广州锁博会顺势而下，及时满足了全球经济的应时之需。</p>\r\n<p>\r\n	　 　依靠科技进步，提高装备水平，积极采用新工艺、新材料。加大自主研发力度，加强制锁企业和设备企业的合作，确定重点，联合攻关；加大投入，特别是一些大 企业要积极引进和消化国际一流水平的加工中心，带动全行业上档次，上水平；要在表面处理和加工工艺上做文章，提高产品的耐用度和装饰性；要开发和应用新技 术、新材料，在提高产品安全性、耐用性和装饰性的同时，节能降耗，减少污染并提高效率。以市场为导向，加大调整产品结构力度，选准切入点，把高科技、高附 加值的门锁及商用锁作为研发重点，加大材料工艺、技术上与国际标准相接轨的力度。实施名牌战略。进一步提高品牌意识，狠抓质量 管理，严格质量标准，培育出一批品质过硬，推出在国内外市场具有一定影响力的锁具品牌。面对经济全球化，国内国外两个市场一起抓。不断扩大住宅、汽车、酒 店等支柱型产业和国防、安全、金融等系统对高防范性安保产品的需求应用。开创锁具市场的新局面，把小产品做成大行业，把世界锁具大国发展成为世界锁具强 国。在此大环境之下，基于上届广州锁博会的成功举办对行业的极大推动，此展会已成为发展锁具产业的有力助手，2012年广州锁博会更是得到了政府的大力扶 持，本届展会企业参展将得到高达65%的参展补贴，鼓励行业企业参展，为加快行业快速发展提供了契机。</p>\r\n', '', 'admin', '', '1466832095', '1466832095', 'true', '', '随着锁具行业的发展趋势急剧上升，市场需求量也逐渐增大，中国已成为全球锁具的制造和消费大国。近年来欧美、德国、日本等发达国家经济回暖，我国经济持续高速发展，出口竞争', '十,二五,发展目标,任务,打造,世界,锁具,强国,', '129', '1466832086', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('17', '9', '什么叫万能钥匙，怎么才能开万把锁？', '', '/storage/images/20220209/1-160FQ64532221.jpg', '', '俗话说，“一把钥匙开一把锁”，它不仅是指钥匙与锁之间的专一性，更表明晰锁的安全性。但记者近来在商场上查询发现，一把通常的钥匙能翻开多把锁的状况并不罕见，特别是在那些同一类型的锁之间。<br />\r\n业内人士表明，目前商场上有部分价低质劣的锁，其出产工艺底子不符合标准，防盗功能极差。它们的存在现已危害了全部锁具职业的开展。<br />\r\n有关部门也提示消费者，在采购锁具时，应挑选闻名和正规公司的产品。一起，如因锁具质量疑问造成财产损失的，受害者可凭有用依据，经过法令路径，追查经销商或出产公司的职责。<br />\r\n“万能钥匙”为何能开万把锁<br />\r\n锁具商场产品质量堪忧亟待进步准入门槛<br />\r\n一把旧钥匙开了4把新锁<br />\r\n家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！<br />\r\n愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！<br />\r\n记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”<br />\r\n为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。<br />\r\n传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。<br />\r\n记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”<br />\r\n记者提出想试试这些锁牢不牢靠，老板赞同了。当着老板的面，记者随意取出其中一把锁的钥匙，试开其他的锁。开到第三把时，只听“咔吧”一声，本来不相匹配的钥匙轻轻松松地把锁翻开了。老板气色略变，自个拿过钥匙连开几下，每次都能翻开。<br />\r\n“巧了，肯定是巧了。”老板情急之下说：“我半个月前进了一批锁，那批锁是真的有疑问，18把锁都能相互翻开，全被我退了。这一批是新进的，应当不至于啊。”<br />\r\n网上有人售卖“万能钥匙”<br />\r\n市民小张则在杭州某论坛里看到了一个“出售正宗万能钥匙”的帖子。这马上让他联想起了自个丢的两辆自行车。小张坚持以为，“一定是小偷用万能钥匙开的锁。”<br />\r\n依据小张提示，记者找到了这个帖子。帖子里有个“图样”，有十几件形状各异的东西，大多身形细长，有钩有齿。卖家在帖子里确保，用这些东西，“通常的锁都能翻开”。', '', 'admin', '', '1466829158', '1466829158', 'true', '', '俗话说，一把钥匙开一把锁，它不仅是指钥匙与锁之间的专一性，更表明晰锁的安全性。但记者近来在商场上查询发现，一把通常的钥匙能翻开多把锁的状况并不罕见，特别是在那些同', '什么,叫,万能,钥匙,怎么,才,能开,万把,锁,', '168', '1466829147', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('18', '9', '\'十二五\'发展目标任务打造世界锁具强国', '', '/storage/images/20220209/1-160FQ64532221.jpg', '', '<p>\r\n	随着锁具行业的发展趋势急剧上升，市场需求量也逐渐增大，中国已成为全球锁具的制造和消费大国。近年来欧美、德国、日本等发达国家经济回暖，我国经济持续高速发展，出口竞争力增强，外贸出口也成倍增长。我国多类锁具市场需求不断增加，更多优秀企业不断发展，锁具行业开始进入了品牌化之路。</p>\r\n<p>\r\n	　 　全球锁具产品及技术日新月异，锁具市场已成为一个众人来掘的&#39;超级金矿&#39;。由于住宅和汽车等支柱产业的发展、人们生活水平的提高及家居装潢增多，对锁具 的需求越来越多，极大带动了锁具市场的消费需求，也促使了锁具行业突飞猛进的发展。广州锁博会顺势而下，及时满足了全球经济的应时之需。</p>\r\n<p>\r\n	　 　依靠科技进步，提高装备水平，积极采用新工艺、新材料。加大自主研发力度，加强制锁企业和设备企业的合作，确定重点，联合攻关；加大投入，特别是一些大 企业要积极引进和消化国际一流水平的加工中心，带动全行业上档次，上水平；要在表面处理和加工工艺上做文章，提高产品的耐用度和装饰性；要开发和应用新技 术、新材料，在提高产品安全性、耐用性和装饰性的同时，节能降耗，减少污染并提高效率。以市场为导向，加大调整产品结构力度，选准切入点，把高科技、高附 加值的门锁及商用锁作为研发重点，加大材料工艺、技术上与国际标准相接轨的力度。实施名牌战略。进一步提高品牌意识，狠抓质量 管理，严格质量标准，培育出一批品质过硬，推出在国内外市场具有一定影响力的锁具品牌。面对经济全球化，国内国外两个市场一起抓。不断扩大住宅、汽车、酒 店等支柱型产业和国防、安全、金融等系统对高防范性安保产品的需求应用。开创锁具市场的新局面，把小产品做成大行业，把世界锁具大国发展成为世界锁具强 国。在此大环境之下，基于上届广州锁博会的成功举办对行业的极大推动，此展会已成为发展锁具产业的有力助手，2012年广州锁博会更是得到了政府的大力扶 持，本届展会企业参展将得到高达65%的参展补贴，鼓励行业企业参展，为加快行业快速发展提供了契机。</p>\r\n', '', 'admin', '', '1466832095', '1466832095', 'true', '', '随着锁具行业的发展趋势急剧上升，市场需求量也逐渐增大，中国已成为全球锁具的制造和消费大国。近年来欧美、德国、日本等发达国家经济回暖，我国经济持续高速发展，出口竞争', '十,二五,发展目标,任务,打造,世界,锁具,强国,', '129', '1466832086', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('19', '9', '什么叫万能钥匙，怎么才能开万把锁？', '', '/storage/images/20220209/1-160FQ64532221.jpg', '', '俗话说，“一把钥匙开一把锁”，它不仅是指钥匙与锁之间的专一性，更表明晰锁的安全性。但记者近来在商场上查询发现，一把通常的钥匙能翻开多把锁的状况并不罕见，特别是在那些同一类型的锁之间。<br />\r\n业内人士表明，目前商场上有部分价低质劣的锁，其出产工艺底子不符合标准，防盗功能极差。它们的存在现已危害了全部锁具职业的开展。<br />\r\n有关部门也提示消费者，在采购锁具时，应挑选闻名和正规公司的产品。一起，如因锁具质量疑问造成财产损失的，受害者可凭有用依据，经过法令路径，追查经销商或出产公司的职责。<br />\r\n“万能钥匙”为何能开万把锁<br />\r\n锁具商场产品质量堪忧亟待进步准入门槛<br />\r\n一把旧钥匙开了4把新锁<br />\r\n家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！<br />\r\n愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！<br />\r\n记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”<br />\r\n为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。<br />\r\n传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。<br />\r\n记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”<br />\r\n记者提出想试试这些锁牢不牢靠，老板赞同了。当着老板的面，记者随意取出其中一把锁的钥匙，试开其他的锁。开到第三把时，只听“咔吧”一声，本来不相匹配的钥匙轻轻松松地把锁翻开了。老板气色略变，自个拿过钥匙连开几下，每次都能翻开。<br />\r\n“巧了，肯定是巧了。”老板情急之下说：“我半个月前进了一批锁，那批锁是真的有疑问，18把锁都能相互翻开，全被我退了。这一批是新进的，应当不至于啊。”<br />\r\n网上有人售卖“万能钥匙”<br />\r\n市民小张则在杭州某论坛里看到了一个“出售正宗万能钥匙”的帖子。这马上让他联想起了自个丢的两辆自行车。小张坚持以为，“一定是小偷用万能钥匙开的锁。”<br />\r\n依据小张提示，记者找到了这个帖子。帖子里有个“图样”，有十几件形状各异的东西，大多身形细长，有钩有齿。卖家在帖子里确保，用这些东西，“通常的锁都能翻开”。', '', 'admin', '', '1466829158', '1466829158', 'true', '', '俗话说，一把钥匙开一把锁，它不仅是指钥匙与锁之间的专一性，更表明晰锁的安全性。但记者近来在商场上查询发现，一把通常的钥匙能翻开多把锁的状况并不罕见，特别是在那些同', '什么,叫,万能,钥匙,怎么,才,能开,万把,锁,', '168', '1466829147', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('20', '9', '\'十二五\'发展目标任务打造世界锁具强国', '', '/storage/images/20220209/1-160FQ64532221.jpg', '', '<p>\r\n	随着锁具行业的发展趋势急剧上升，市场需求量也逐渐增大，中国已成为全球锁具的制造和消费大国。近年来欧美、德国、日本等发达国家经济回暖，我国经济持续高速发展，出口竞争力增强，外贸出口也成倍增长。我国多类锁具市场需求不断增加，更多优秀企业不断发展，锁具行业开始进入了品牌化之路。</p>\r\n<p>\r\n	　 　全球锁具产品及技术日新月异，锁具市场已成为一个众人来掘的&#39;超级金矿&#39;。由于住宅和汽车等支柱产业的发展、人们生活水平的提高及家居装潢增多，对锁具 的需求越来越多，极大带动了锁具市场的消费需求，也促使了锁具行业突飞猛进的发展。广州锁博会顺势而下，及时满足了全球经济的应时之需。</p>\r\n<p>\r\n	　 　依靠科技进步，提高装备水平，积极采用新工艺、新材料。加大自主研发力度，加强制锁企业和设备企业的合作，确定重点，联合攻关；加大投入，特别是一些大 企业要积极引进和消化国际一流水平的加工中心，带动全行业上档次，上水平；要在表面处理和加工工艺上做文章，提高产品的耐用度和装饰性；要开发和应用新技 术、新材料，在提高产品安全性、耐用性和装饰性的同时，节能降耗，减少污染并提高效率。以市场为导向，加大调整产品结构力度，选准切入点，把高科技、高附 加值的门锁及商用锁作为研发重点，加大材料工艺、技术上与国际标准相接轨的力度。实施名牌战略。进一步提高品牌意识，狠抓质量 管理，严格质量标准，培育出一批品质过硬，推出在国内外市场具有一定影响力的锁具品牌。面对经济全球化，国内国外两个市场一起抓。不断扩大住宅、汽车、酒 店等支柱型产业和国防、安全、金融等系统对高防范性安保产品的需求应用。开创锁具市场的新局面，把小产品做成大行业，把世界锁具大国发展成为世界锁具强 国。在此大环境之下，基于上届广州锁博会的成功举办对行业的极大推动，此展会已成为发展锁具产业的有力助手，2012年广州锁博会更是得到了政府的大力扶 持，本届展会企业参展将得到高达65%的参展补贴，鼓励行业企业参展，为加快行业快速发展提供了契机。</p>\r\n', '', 'admin', '', '1466832095', '1466832095', 'true', '', '随着锁具行业的发展趋势急剧上升，市场需求量也逐渐增大，中国已成为全球锁具的制造和消费大国。近年来欧美、德国、日本等发达国家经济回暖，我国经济持续高速发展，出口竞争', '十,二五,发展目标,任务,打造,世界,锁具,强国,', '129', '1466832086', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('21', '9', '什么叫万能钥匙，怎么才能开万把锁？', '', '/storage/images/20220209/1-160FQ64532221.jpg', '', '俗话说，“一把钥匙开一把锁”，它不仅是指钥匙与锁之间的专一性，更表明晰锁的安全性。但记者近来在商场上查询发现，一把通常的钥匙能翻开多把锁的状况并不罕见，特别是在那些同一类型的锁之间。<br />\r\n业内人士表明，目前商场上有部分价低质劣的锁，其出产工艺底子不符合标准，防盗功能极差。它们的存在现已危害了全部锁具职业的开展。<br />\r\n有关部门也提示消费者，在采购锁具时，应挑选闻名和正规公司的产品。一起，如因锁具质量疑问造成财产损失的，受害者可凭有用依据，经过法令路径，追查经销商或出产公司的职责。<br />\r\n“万能钥匙”为何能开万把锁<br />\r\n锁具商场产品质量堪忧亟待进步准入门槛<br />\r\n一把旧钥匙开了4把新锁<br />\r\n家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！<br />\r\n愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！<br />\r\n记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”<br />\r\n为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。<br />\r\n传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。<br />\r\n记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”<br />\r\n记者提出想试试这些锁牢不牢靠，老板赞同了。当着老板的面，记者随意取出其中一把锁的钥匙，试开其他的锁。开到第三把时，只听“咔吧”一声，本来不相匹配的钥匙轻轻松松地把锁翻开了。老板气色略变，自个拿过钥匙连开几下，每次都能翻开。<br />\r\n“巧了，肯定是巧了。”老板情急之下说：“我半个月前进了一批锁，那批锁是真的有疑问，18把锁都能相互翻开，全被我退了。这一批是新进的，应当不至于啊。”<br />\r\n网上有人售卖“万能钥匙”<br />\r\n市民小张则在杭州某论坛里看到了一个“出售正宗万能钥匙”的帖子。这马上让他联想起了自个丢的两辆自行车。小张坚持以为，“一定是小偷用万能钥匙开的锁。”<br />\r\n依据小张提示，记者找到了这个帖子。帖子里有个“图样”，有十几件形状各异的东西，大多身形细长，有钩有齿。卖家在帖子里确保，用这些东西，“通常的锁都能翻开”。', '', 'admin', '', '1466829158', '1466829158', 'true', '', '俗话说，一把钥匙开一把锁，它不仅是指钥匙与锁之间的专一性，更表明晰锁的安全性。但记者近来在商场上查询发现，一把通常的钥匙能翻开多把锁的状况并不罕见，特别是在那些同', '什么,叫,万能,钥匙,怎么,才,能开,万把,锁,', '168', '1466829147', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('22', '9', '\'十二五\'发展目标任务打造世界锁具强国', '', '/storage/images/20220209/1-160FQ64532221.jpg', '', '<p>\r\n	随着锁具行业的发展趋势急剧上升，市场需求量也逐渐增大，中国已成为全球锁具的制造和消费大国。近年来欧美、德国、日本等发达国家经济回暖，我国经济持续高速发展，出口竞争力增强，外贸出口也成倍增长。我国多类锁具市场需求不断增加，更多优秀企业不断发展，锁具行业开始进入了品牌化之路。</p>\r\n<p>\r\n	　 　全球锁具产品及技术日新月异，锁具市场已成为一个众人来掘的&#39;超级金矿&#39;。由于住宅和汽车等支柱产业的发展、人们生活水平的提高及家居装潢增多，对锁具 的需求越来越多，极大带动了锁具市场的消费需求，也促使了锁具行业突飞猛进的发展。广州锁博会顺势而下，及时满足了全球经济的应时之需。</p>\r\n<p>\r\n	　 　依靠科技进步，提高装备水平，积极采用新工艺、新材料。加大自主研发力度，加强制锁企业和设备企业的合作，确定重点，联合攻关；加大投入，特别是一些大 企业要积极引进和消化国际一流水平的加工中心，带动全行业上档次，上水平；要在表面处理和加工工艺上做文章，提高产品的耐用度和装饰性；要开发和应用新技 术、新材料，在提高产品安全性、耐用性和装饰性的同时，节能降耗，减少污染并提高效率。以市场为导向，加大调整产品结构力度，选准切入点，把高科技、高附 加值的门锁及商用锁作为研发重点，加大材料工艺、技术上与国际标准相接轨的力度。实施名牌战略。进一步提高品牌意识，狠抓质量 管理，严格质量标准，培育出一批品质过硬，推出在国内外市场具有一定影响力的锁具品牌。面对经济全球化，国内国外两个市场一起抓。不断扩大住宅、汽车、酒 店等支柱型产业和国防、安全、金融等系统对高防范性安保产品的需求应用。开创锁具市场的新局面，把小产品做成大行业，把世界锁具大国发展成为世界锁具强 国。在此大环境之下，基于上届广州锁博会的成功举办对行业的极大推动，此展会已成为发展锁具产业的有力助手，2012年广州锁博会更是得到了政府的大力扶 持，本届展会企业参展将得到高达65%的参展补贴，鼓励行业企业参展，为加快行业快速发展提供了契机。</p>\r\n', '', 'admin', '', '1466832095', '1466832095', 'true', '', '随着锁具行业的发展趋势急剧上升，市场需求量也逐渐增大，中国已成为全球锁具的制造和消费大国。近年来欧美、德国、日本等发达国家经济回暖，我国经济持续高速发展，出口竞争', '十,二五,发展目标,任务,打造,世界,锁具,强国,', '130', '1466832086', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('23', '9', '什么叫万能钥匙，怎么才能开万把锁？', '', '/storage/images/20220209/1-160FQ64532221.jpg', '', '俗话说，“一把钥匙开一把锁”，它不仅是指钥匙与锁之间的专一性，更表明晰锁的安全性。但记者近来在商场上查询发现，一把通常的钥匙能翻开多把锁的状况并不罕见，特别是在那些同一类型的锁之间。<br />\r\n业内人士表明，目前商场上有部分价低质劣的锁，其出产工艺底子不符合标准，防盗功能极差。它们的存在现已危害了全部锁具职业的开展。<br />\r\n有关部门也提示消费者，在采购锁具时，应挑选闻名和正规公司的产品。一起，如因锁具质量疑问造成财产损失的，受害者可凭有用依据，经过法令路径，追查经销商或出产公司的职责。<br />\r\n“万能钥匙”为何能开万把锁<br />\r\n锁具商场产品质量堪忧亟待进步准入门槛<br />\r\n一把旧钥匙开了4把新锁<br />\r\n家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！<br />\r\n愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！<br />\r\n记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”<br />\r\n为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。<br />\r\n传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。<br />\r\n记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”<br />\r\n记者提出想试试这些锁牢不牢靠，老板赞同了。当着老板的面，记者随意取出其中一把锁的钥匙，试开其他的锁。开到第三把时，只听“咔吧”一声，本来不相匹配的钥匙轻轻松松地把锁翻开了。老板气色略变，自个拿过钥匙连开几下，每次都能翻开。<br />\r\n“巧了，肯定是巧了。”老板情急之下说：“我半个月前进了一批锁，那批锁是真的有疑问，18把锁都能相互翻开，全被我退了。这一批是新进的，应当不至于啊。”<br />\r\n网上有人售卖“万能钥匙”<br />\r\n市民小张则在杭州某论坛里看到了一个“出售正宗万能钥匙”的帖子。这马上让他联想起了自个丢的两辆自行车。小张坚持以为，“一定是小偷用万能钥匙开的锁。”<br />\r\n依据小张提示，记者找到了这个帖子。帖子里有个“图样”，有十几件形状各异的东西，大多身形细长，有钩有齿。卖家在帖子里确保，用这些东西，“通常的锁都能翻开”。', '', 'admin', '', '1466829158', '1466829158', 'true', '', '俗话说，一把钥匙开一把锁，它不仅是指钥匙与锁之间的专一性，更表明晰锁的安全性。但记者近来在商场上查询发现，一把通常的钥匙能翻开多把锁的状况并不罕见，特别是在那些同', '什么,叫,万能,钥匙,怎么,才,能开,万把,锁,', '168', '1466829147', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('24', '9', '\'十二五\'发展目标任务打造世界锁具强国', '', '/storage/images/20220209/1-160FQ64532221.jpg', '', '<p>\r\n	随着锁具行业的发展趋势急剧上升，市场需求量也逐渐增大，中国已成为全球锁具的制造和消费大国。近年来欧美、德国、日本等发达国家经济回暖，我国经济持续高速发展，出口竞争力增强，外贸出口也成倍增长。我国多类锁具市场需求不断增加，更多优秀企业不断发展，锁具行业开始进入了品牌化之路。</p>\r\n<p>\r\n	　 　全球锁具产品及技术日新月异，锁具市场已成为一个众人来掘的&#39;超级金矿&#39;。由于住宅和汽车等支柱产业的发展、人们生活水平的提高及家居装潢增多，对锁具 的需求越来越多，极大带动了锁具市场的消费需求，也促使了锁具行业突飞猛进的发展。广州锁博会顺势而下，及时满足了全球经济的应时之需。</p>\r\n<p>\r\n	　 　依靠科技进步，提高装备水平，积极采用新工艺、新材料。加大自主研发力度，加强制锁企业和设备企业的合作，确定重点，联合攻关；加大投入，特别是一些大 企业要积极引进和消化国际一流水平的加工中心，带动全行业上档次，上水平；要在表面处理和加工工艺上做文章，提高产品的耐用度和装饰性；要开发和应用新技 术、新材料，在提高产品安全性、耐用性和装饰性的同时，节能降耗，减少污染并提高效率。以市场为导向，加大调整产品结构力度，选准切入点，把高科技、高附 加值的门锁及商用锁作为研发重点，加大材料工艺、技术上与国际标准相接轨的力度。实施名牌战略。进一步提高品牌意识，狠抓质量 管理，严格质量标准，培育出一批品质过硬，推出在国内外市场具有一定影响力的锁具品牌。面对经济全球化，国内国外两个市场一起抓。不断扩大住宅、汽车、酒 店等支柱型产业和国防、安全、金融等系统对高防范性安保产品的需求应用。开创锁具市场的新局面，把小产品做成大行业，把世界锁具大国发展成为世界锁具强 国。在此大环境之下，基于上届广州锁博会的成功举办对行业的极大推动，此展会已成为发展锁具产业的有力助手，2012年广州锁博会更是得到了政府的大力扶 持，本届展会企业参展将得到高达65%的参展补贴，鼓励行业企业参展，为加快行业快速发展提供了契机。</p>\r\n', '', 'admin', '', '1466832095', '1466832095', 'true', '', '随着锁具行业的发展趋势急剧上升，市场需求量也逐渐增大，中国已成为全球锁具的制造和消费大国。近年来欧美、德国、日本等发达国家经济回暖，我国经济持续高速发展，出口竞争', '十,二五,发展目标,任务,打造,世界,锁具,强国,', '129', '1466832086', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('25', '2', '科技攻关带“火”冷凉蔬菜', '', '/storage/images/20220209/12514L320-0-lp.jpg', '', '　　　<img alt=\"\" src=\"/storage/images/20220209/12514L320-0.jpg\" />&nbsp;<br />\r\n　　8月，全国大部分地区从南到北，正经历着盛夏的“烧烤”模式，而在内蒙古的乌兰察布市，已经凉风习习，大有初秋的味道。由于海拔和纬度的原因，这里即便是7~9月，平均气温也不会超过25℃。气候也是一种资源，比如近几年来内蒙古乌兰察布的冷凉蔬菜种植，就是利用这里在同期与全国的温湿度的差别而迅速发展起来的。&nbsp;<br />\r\n　　创新集成技术，攻克冷凉蔬菜种植难题&nbsp;<br />\r\n　　所谓冷凉蔬菜，是指适宜在气候冷凉地区夏季生产的蔬菜，主要包括甘蓝、大白菜、胡萝卜、洋葱、马铃薯等。由于7~9月全国普遍高温，而在高海拔、高纬度地区，此时正好生长冷凉蔬菜，与南方的蔬菜错季上市，市场优势不言而喻。&nbsp;<br />\r\n　　乌兰察布市是近几年发展起来的北方夏季冷凉蔬菜基地之一，尤其是2012年由中国农科院蔬菜花卉研究所方智远院士领衔的专家团队在这里建立了全国首个以冷凉蔬菜产业为研究方向的院士专家工作站后，以甘蓝种植为主的冷凉蔬菜发展有了质的飞跃。&nbsp;<br />\r\n　　“我国的甘蓝种植主要存在三大问题，一是抗病、抗逆品种的推广，二是虫害防治效率低、化学<a>农药</a>用量大，三是水肥利用率低，用工成本高。这几年来我们的科研攻关和技术示范主要就围绕着这三个方面展开。”中国农科院蔬菜花卉研究所、“甘蓝绿色增产增效技术集成”项目主持人杨丽梅介绍。&nbsp;<br />\r\n　　在乌兰察布市兴和县曹四夭村，这里有百亩甘蓝绿色增产增效技术示范田，三个甘蓝品种：中甘21、中甘628、中甘192进行示范展示，而其中长势最好的还是方智远院士的“得意之作”——中甘21。4月20日播种，5月10日定植，大约三个月，就能看到一片绿油油的甘蓝铺在眼前，一颗颗包球紧实，而且颜色漂亮。&nbsp;<br />\r\n　　乌兰察布市科技局研究员，也是院士专家工作站在当地的科技特派员关慧明告诉我们，这片示范田的成功之处首先是品种好，中甘系列甘蓝品种抗裂、耐贮运，已经超过了韩国品种铁头系列。其次是采用了一系列绿色增产增效栽培技术，如太阳能杀虫灯、性诱剂、生物农药，以及膜下滴灌、合理密植等。“通过集成技术打出组合拳，在我们的示范田里，减少了30%的化学农药用量，减少灌溉用水30%以上，减少人工20%以上，示范品种比对照品种（铁头4号）增产8~10%，每亩增值300~500元。”关慧明说。&nbsp;<br />\r\n　　由于“甘蓝绿色高产高效技术集成模式研究与示范”的带动，仅乌兰察布一地甘蓝种植就超过4万亩。周边农户大面积示范区5个，每个农户示范区面积约100亩，并进一步辐射到河北张家口及承德地区，辐射带动总面积8~10万亩。&nbsp;<br />\r\n　　产量高品质好，农民增收有了新途径&nbsp;<br />\r\n　　甘蓝，也就是我们日常餐桌上的圆白菜，经常是以凉拌的做法为主，这就对甘蓝的口感要求很高。在冷凉蔬菜院士工作站基地，工作人员把刚摘下的“中甘21”和当地原来的主栽品种韩国的“铁头4号”分别切开让大家品尝，“铁头4号”有一种微微的辛辣口感，而“中甘21”则更加脆嫩、鲜甜，中国农业科学院副院长王汉中笑着说：“可以当水果吃了。”也许正因为这种口感上的细微差别，让我国自己选育的甘蓝品种近几年在市场上大受欢迎。&nbsp;<br />\r\n　　46岁的河北承德人赵林，原先是蔬菜销售商。2003年他开始在曹四夭村承包流转地2500亩种菜。三年前他拿出100亩地试种甘蓝，当时他种的是“中甘11”，去年他又种了“中甘21”，结果非常喜人。&nbsp;<br />\r\n　　“产量特别高，亩产达到了每亩近9000斤，品质也特别好，去年的收购价每斤达到了1.2元，别的品种最多到0.6元。收购商大多数是从京津来，远的也有苏杭甚至广东，到了地头直接问有没有&lsquo;中甘21&rsquo;，无论多少，照单全收。用膜包好了装上冷藏车就直接运走了。”&nbsp;<br />\r\n　　去年是甘蓝市场的“大年”，农民增产又增收，随着甘蓝种植面积的扩大，加上今年雨水丰沛，地里的甘蓝又是一次大丰收，但甘蓝的价格却像是坐了过山车，赵林告诉记者：“两年暴赚、一年小赚、一年持平、一年赔本赚吆喝。”这基本就是甘蓝的价格周期。据了解，今年甘蓝的地头收购价跌到了谷底，从去年的1.2元到现在的0.2元，对于这种暴跌，赵林倒显得很平静，“0.2元的价格，对&lsquo;中甘21&rsquo;这种好的品种来说，刚刚够成本，今年不行明年再来，我对这种产量高、品质好的品种还是很有信心的。”&nbsp;<br />\r\n　　加强技术支撑，让产业走的更远&nbsp;<br />\r\n　　发展优势产业，是近几年来各地经济发展，开展扶贫的主要思路，而科技对产业发展的支撑作用功不可没。除了建立院士专家工作站，在当地设立科技特派员的岗位，中国农科院蔬菜所也利用自己的专业优势，围绕农户、农场、种植大户的需求，提供远程诊断、技术培训、现场指导和试验示范。从推广新品种到科学的栽培管理，对产业的提质增效帮助很大。但是生产是一方面，而市场又是另一方面。“我们一直在思考，是技术引导产业还是市场引导产业，事实上，这两者都不能忽略，我们的农业科技给农民带来了丰收，而且还要帮助他们丰收后再增收。”中国农科院科技管理局副局长陆建忠说。&nbsp;<br />\r\n　　位于河北张家口市的崇礼区，是我国着名的滑雪胜地，由于地形地势呈现为狭长的山区，夏季凉爽而短促，也特别适合种植冷凉蔬菜。驱车沿山路走，路两旁种植的都是甘蓝，张家口市农科院蔬菜所所长苏浴源很自豪地说：“我们这里是万亩甘蓝种植带，这里的气候种什么蔬菜都长不好，除了甘蓝。老百姓也是靠种甘蓝提高收入的。”&nbsp;<br />\r\n　　马丈子村也属于这个万亩甘蓝带中，今年甘蓝价格不好，当地科技人员组织农户延期定植，5月中旬播种，到采收的时候甘蓝的收购价已经从0.2元到了0.5元，保证了不亏损。&nbsp;<br />\r\n　　“考虑到蔬菜价格在市场上的波动情况，我们在育种中会发展不同品种的不同特征，让农民们有多种选择。中甘21的品质好，我们还有最新育成的中甘588和中甘590，它们的特点是采摘时间长，长达25天，这样农民可以根据市场的变化，调整供应。”杨丽梅说。此外，由于市场比较喜欢1~2斤重左右、可以单手握住大小的甘蓝，科技人员在指导农户种植的时候，也会教他们控制水肥，不让甘蓝长得太大。&nbsp;<br />\r\n　　“冷凉蔬菜”是我国特有的概念，也面临着蔬菜产业转型升级过程中所遇到的机遇与挑战，在市场面前，科研要尊重市场规律，同时也要利用市场规律，才能发挥科技的支撑作用。 （何烨）', '', 'admin', '', '1472014307', '1472014307', 'true', '', '8月，全国大部分地区从南到北，正经历着盛夏的烧烤模式，而在内蒙古的乌兰察布市，已经凉风习习，大有初秋的味道。由于海拔和纬度的原因，这里即便是7~9月，平均气温也不会超过', '科技,攻关,带,“,火,”,冷凉,蔬菜,8月,全国,', '104', '1472014294', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('26', '2', '大蒜开始响起“涨声”　“蒜你狠”卷土重来', '', '/storage/images/20220209/12521045V-0-lp.jpg', '', '　　<img alt=\"\" src=\"/storage/images/20220209/12521045V-0.jpg\" />&nbsp;<br />\r\n　　最近，不少市民发现大蒜越来越贵了，“蒜你狠”再度回归。记者调查发现，受市场供应量减少等因素影响，眼下辽宁鞍山市场大蒜的价格比一个月前上涨三成多，最高卖到9元/500克，蒜薹也跟风涨到6元/500克左右。&nbsp;<br />\r\n　　昨日，记者走访我市一些农贸市场了解到，大蒜最贵的已经卖到9元/500克了，而一个月前还只要7元/500克。一些市民听到价格不禁咋舌：“一块钱一头，做菜省着点用吧”。为此，一些烧烤店也不舍得“随便”给顾客免费吃大蒜了。不仅如此，蒜薹价格也由一个月前的3元—4元/500克左右，涨至眼下的6元/500克左右。&nbsp;<br />\r\n　　据了解，今年1月份开始，大蒜就开始响起“涨声”，3月份大蒜最贵的时候达到过9元/500克的“历史最高点”，五六月份时新蒜上市，给大蒜价格“降温”，不过之后几个月也一直在6元—7元/500克左右的高位运行，眼下再度冲高。对于大蒜价格上涨的原因，有菜贩介绍，由于大蒜原产地减产，大蒜价格被“炒”贵，另外一些批发商“惜售”大蒜不舍得出手，也使得本就供不应求的市场再陷窘境。 （于秀琪）', '', 'admin', '', '1472014330', '1472014330', 'true', '', '最近，不少市民发现大蒜越来越贵了，蒜你狠再度回归。记者调查发现，受市场供应量减少等因素影响，眼下辽宁鞍山市场大蒜的价格比一个月前上涨三成多，最高卖到9元/500克，蒜薹', '大蒜,开始,响起,“,涨声,”,蒜你狠,卷土重来,', '148', '1472014321', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('27', '2', '科技攻关带“火”冷凉蔬菜', '', '/storage/images/20220209/12514L320-0-lp.jpg', '', '　　　<img alt=\"\" src=\"/storage/images/20220209/12514L320-0.jpg\" />&nbsp;<br />\r\n　　8月，全国大部分地区从南到北，正经历着盛夏的“烧烤”模式，而在内蒙古的乌兰察布市，已经凉风习习，大有初秋的味道。由于海拔和纬度的原因，这里即便是7~9月，平均气温也不会超过25℃。气候也是一种资源，比如近几年来内蒙古乌兰察布的冷凉蔬菜种植，就是利用这里在同期与全国的温湿度的差别而迅速发展起来的。&nbsp;<br />\r\n　　创新集成技术，攻克冷凉蔬菜种植难题&nbsp;<br />\r\n　　所谓冷凉蔬菜，是指适宜在气候冷凉地区夏季生产的蔬菜，主要包括甘蓝、大白菜、胡萝卜、洋葱、马铃薯等。由于7~9月全国普遍高温，而在高海拔、高纬度地区，此时正好生长冷凉蔬菜，与南方的蔬菜错季上市，市场优势不言而喻。&nbsp;<br />\r\n　　乌兰察布市是近几年发展起来的北方夏季冷凉蔬菜基地之一，尤其是2012年由中国农科院蔬菜花卉研究所方智远院士领衔的专家团队在这里建立了全国首个以冷凉蔬菜产业为研究方向的院士专家工作站后，以甘蓝种植为主的冷凉蔬菜发展有了质的飞跃。&nbsp;<br />\r\n　　“我国的甘蓝种植主要存在三大问题，一是抗病、抗逆品种的推广，二是虫害防治效率低、化学<a>农药</a>用量大，三是水肥利用率低，用工成本高。这几年来我们的科研攻关和技术示范主要就围绕着这三个方面展开。”中国农科院蔬菜花卉研究所、“甘蓝绿色增产增效技术集成”项目主持人杨丽梅介绍。&nbsp;<br />\r\n　　在乌兰察布市兴和县曹四夭村，这里有百亩甘蓝绿色增产增效技术示范田，三个甘蓝品种：中甘21、中甘628、中甘192进行示范展示，而其中长势最好的还是方智远院士的“得意之作”——中甘21。4月20日播种，5月10日定植，大约三个月，就能看到一片绿油油的甘蓝铺在眼前，一颗颗包球紧实，而且颜色漂亮。&nbsp;<br />\r\n　　乌兰察布市科技局研究员，也是院士专家工作站在当地的科技特派员关慧明告诉我们，这片示范田的成功之处首先是品种好，中甘系列甘蓝品种抗裂、耐贮运，已经超过了韩国品种铁头系列。其次是采用了一系列绿色增产增效栽培技术，如太阳能杀虫灯、性诱剂、生物农药，以及膜下滴灌、合理密植等。“通过集成技术打出组合拳，在我们的示范田里，减少了30%的化学农药用量，减少灌溉用水30%以上，减少人工20%以上，示范品种比对照品种（铁头4号）增产8~10%，每亩增值300~500元。”关慧明说。&nbsp;<br />\r\n　　由于“甘蓝绿色高产高效技术集成模式研究与示范”的带动，仅乌兰察布一地甘蓝种植就超过4万亩。周边农户大面积示范区5个，每个农户示范区面积约100亩，并进一步辐射到河北张家口及承德地区，辐射带动总面积8~10万亩。&nbsp;<br />\r\n　　产量高品质好，农民增收有了新途径&nbsp;<br />\r\n　　甘蓝，也就是我们日常餐桌上的圆白菜，经常是以凉拌的做法为主，这就对甘蓝的口感要求很高。在冷凉蔬菜院士工作站基地，工作人员把刚摘下的“中甘21”和当地原来的主栽品种韩国的“铁头4号”分别切开让大家品尝，“铁头4号”有一种微微的辛辣口感，而“中甘21”则更加脆嫩、鲜甜，中国农业科学院副院长王汉中笑着说：“可以当水果吃了。”也许正因为这种口感上的细微差别，让我国自己选育的甘蓝品种近几年在市场上大受欢迎。&nbsp;<br />\r\n　　46岁的河北承德人赵林，原先是蔬菜销售商。2003年他开始在曹四夭村承包流转地2500亩种菜。三年前他拿出100亩地试种甘蓝，当时他种的是“中甘11”，去年他又种了“中甘21”，结果非常喜人。&nbsp;<br />\r\n　　“产量特别高，亩产达到了每亩近9000斤，品质也特别好，去年的收购价每斤达到了1.2元，别的品种最多到0.6元。收购商大多数是从京津来，远的也有苏杭甚至广东，到了地头直接问有没有&lsquo;中甘21&rsquo;，无论多少，照单全收。用膜包好了装上冷藏车就直接运走了。”&nbsp;<br />\r\n　　去年是甘蓝市场的“大年”，农民增产又增收，随着甘蓝种植面积的扩大，加上今年雨水丰沛，地里的甘蓝又是一次大丰收，但甘蓝的价格却像是坐了过山车，赵林告诉记者：“两年暴赚、一年小赚、一年持平、一年赔本赚吆喝。”这基本就是甘蓝的价格周期。据了解，今年甘蓝的地头收购价跌到了谷底，从去年的1.2元到现在的0.2元，对于这种暴跌，赵林倒显得很平静，“0.2元的价格，对&lsquo;中甘21&rsquo;这种好的品种来说，刚刚够成本，今年不行明年再来，我对这种产量高、品质好的品种还是很有信心的。”&nbsp;<br />\r\n　　加强技术支撑，让产业走的更远&nbsp;<br />\r\n　　发展优势产业，是近几年来各地经济发展，开展扶贫的主要思路，而科技对产业发展的支撑作用功不可没。除了建立院士专家工作站，在当地设立科技特派员的岗位，中国农科院蔬菜所也利用自己的专业优势，围绕农户、农场、种植大户的需求，提供远程诊断、技术培训、现场指导和试验示范。从推广新品种到科学的栽培管理，对产业的提质增效帮助很大。但是生产是一方面，而市场又是另一方面。“我们一直在思考，是技术引导产业还是市场引导产业，事实上，这两者都不能忽略，我们的农业科技给农民带来了丰收，而且还要帮助他们丰收后再增收。”中国农科院科技管理局副局长陆建忠说。&nbsp;<br />\r\n　　位于河北张家口市的崇礼区，是我国着名的滑雪胜地，由于地形地势呈现为狭长的山区，夏季凉爽而短促，也特别适合种植冷凉蔬菜。驱车沿山路走，路两旁种植的都是甘蓝，张家口市农科院蔬菜所所长苏浴源很自豪地说：“我们这里是万亩甘蓝种植带，这里的气候种什么蔬菜都长不好，除了甘蓝。老百姓也是靠种甘蓝提高收入的。”&nbsp;<br />\r\n　　马丈子村也属于这个万亩甘蓝带中，今年甘蓝价格不好，当地科技人员组织农户延期定植，5月中旬播种，到采收的时候甘蓝的收购价已经从0.2元到了0.5元，保证了不亏损。&nbsp;<br />\r\n　　“考虑到蔬菜价格在市场上的波动情况，我们在育种中会发展不同品种的不同特征，让农民们有多种选择。中甘21的品质好，我们还有最新育成的中甘588和中甘590，它们的特点是采摘时间长，长达25天，这样农民可以根据市场的变化，调整供应。”杨丽梅说。此外，由于市场比较喜欢1~2斤重左右、可以单手握住大小的甘蓝，科技人员在指导农户种植的时候，也会教他们控制水肥，不让甘蓝长得太大。&nbsp;<br />\r\n　　“冷凉蔬菜”是我国特有的概念，也面临着蔬菜产业转型升级过程中所遇到的机遇与挑战，在市场面前，科研要尊重市场规律，同时也要利用市场规律，才能发挥科技的支撑作用。 （何烨）', '', 'admin', '', '1472014307', '1472014307', 'true', '', '8月，全国大部分地区从南到北，正经历着盛夏的烧烤模式，而在内蒙古的乌兰察布市，已经凉风习习，大有初秋的味道。由于海拔和纬度的原因，这里即便是7~9月，平均气温也不会超过', '科技,攻关,带,“,火,”,冷凉,蔬菜,8月,全国,', '104', '1472014294', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('28', '2', '大蒜开始响起“涨声”　“蒜你狠”卷土重来', '', '/storage/images/20220209/12521045V-0-lp.jpg', '', '　　<img alt=\"\" src=\"/storage/images/20220209/12521045V-0.jpg\" />&nbsp;<br />\r\n　　最近，不少市民发现大蒜越来越贵了，“蒜你狠”再度回归。记者调查发现，受市场供应量减少等因素影响，眼下辽宁鞍山市场大蒜的价格比一个月前上涨三成多，最高卖到9元/500克，蒜薹也跟风涨到6元/500克左右。&nbsp;<br />\r\n　　昨日，记者走访我市一些农贸市场了解到，大蒜最贵的已经卖到9元/500克了，而一个月前还只要7元/500克。一些市民听到价格不禁咋舌：“一块钱一头，做菜省着点用吧”。为此，一些烧烤店也不舍得“随便”给顾客免费吃大蒜了。不仅如此，蒜薹价格也由一个月前的3元—4元/500克左右，涨至眼下的6元/500克左右。&nbsp;<br />\r\n　　据了解，今年1月份开始，大蒜就开始响起“涨声”，3月份大蒜最贵的时候达到过9元/500克的“历史最高点”，五六月份时新蒜上市，给大蒜价格“降温”，不过之后几个月也一直在6元—7元/500克左右的高位运行，眼下再度冲高。对于大蒜价格上涨的原因，有菜贩介绍，由于大蒜原产地减产，大蒜价格被“炒”贵，另外一些批发商“惜售”大蒜不舍得出手，也使得本就供不应求的市场再陷窘境。 （于秀琪）', '', 'admin', '', '1472014330', '1472014330', 'true', '', '最近，不少市民发现大蒜越来越贵了，蒜你狠再度回归。记者调查发现，受市场供应量减少等因素影响，眼下辽宁鞍山市场大蒜的价格比一个月前上涨三成多，最高卖到9元/500克，蒜薹', '大蒜,开始,响起,“,涨声,”,蒜你狠,卷土重来,', '148', '1472014321', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('29', '2', '科技攻关带“火”冷凉蔬菜', '', '/storage/images/20220209/12514L320-0-lp.jpg', '', '　　　<img alt=\"\" src=\"/storage/images/20220209/12514L320-0.jpg\" />&nbsp;<br />\r\n　　8月，全国大部分地区从南到北，正经历着盛夏的“烧烤”模式，而在内蒙古的乌兰察布市，已经凉风习习，大有初秋的味道。由于海拔和纬度的原因，这里即便是7~9月，平均气温也不会超过25℃。气候也是一种资源，比如近几年来内蒙古乌兰察布的冷凉蔬菜种植，就是利用这里在同期与全国的温湿度的差别而迅速发展起来的。&nbsp;<br />\r\n　　创新集成技术，攻克冷凉蔬菜种植难题&nbsp;<br />\r\n　　所谓冷凉蔬菜，是指适宜在气候冷凉地区夏季生产的蔬菜，主要包括甘蓝、大白菜、胡萝卜、洋葱、马铃薯等。由于7~9月全国普遍高温，而在高海拔、高纬度地区，此时正好生长冷凉蔬菜，与南方的蔬菜错季上市，市场优势不言而喻。&nbsp;<br />\r\n　　乌兰察布市是近几年发展起来的北方夏季冷凉蔬菜基地之一，尤其是2012年由中国农科院蔬菜花卉研究所方智远院士领衔的专家团队在这里建立了全国首个以冷凉蔬菜产业为研究方向的院士专家工作站后，以甘蓝种植为主的冷凉蔬菜发展有了质的飞跃。&nbsp;<br />\r\n　　“我国的甘蓝种植主要存在三大问题，一是抗病、抗逆品种的推广，二是虫害防治效率低、化学<a>农药</a>用量大，三是水肥利用率低，用工成本高。这几年来我们的科研攻关和技术示范主要就围绕着这三个方面展开。”中国农科院蔬菜花卉研究所、“甘蓝绿色增产增效技术集成”项目主持人杨丽梅介绍。&nbsp;<br />\r\n　　在乌兰察布市兴和县曹四夭村，这里有百亩甘蓝绿色增产增效技术示范田，三个甘蓝品种：中甘21、中甘628、中甘192进行示范展示，而其中长势最好的还是方智远院士的“得意之作”——中甘21。4月20日播种，5月10日定植，大约三个月，就能看到一片绿油油的甘蓝铺在眼前，一颗颗包球紧实，而且颜色漂亮。&nbsp;<br />\r\n　　乌兰察布市科技局研究员，也是院士专家工作站在当地的科技特派员关慧明告诉我们，这片示范田的成功之处首先是品种好，中甘系列甘蓝品种抗裂、耐贮运，已经超过了韩国品种铁头系列。其次是采用了一系列绿色增产增效栽培技术，如太阳能杀虫灯、性诱剂、生物农药，以及膜下滴灌、合理密植等。“通过集成技术打出组合拳，在我们的示范田里，减少了30%的化学农药用量，减少灌溉用水30%以上，减少人工20%以上，示范品种比对照品种（铁头4号）增产8~10%，每亩增值300~500元。”关慧明说。&nbsp;<br />\r\n　　由于“甘蓝绿色高产高效技术集成模式研究与示范”的带动，仅乌兰察布一地甘蓝种植就超过4万亩。周边农户大面积示范区5个，每个农户示范区面积约100亩，并进一步辐射到河北张家口及承德地区，辐射带动总面积8~10万亩。&nbsp;<br />\r\n　　产量高品质好，农民增收有了新途径&nbsp;<br />\r\n　　甘蓝，也就是我们日常餐桌上的圆白菜，经常是以凉拌的做法为主，这就对甘蓝的口感要求很高。在冷凉蔬菜院士工作站基地，工作人员把刚摘下的“中甘21”和当地原来的主栽品种韩国的“铁头4号”分别切开让大家品尝，“铁头4号”有一种微微的辛辣口感，而“中甘21”则更加脆嫩、鲜甜，中国农业科学院副院长王汉中笑着说：“可以当水果吃了。”也许正因为这种口感上的细微差别，让我国自己选育的甘蓝品种近几年在市场上大受欢迎。&nbsp;<br />\r\n　　46岁的河北承德人赵林，原先是蔬菜销售商。2003年他开始在曹四夭村承包流转地2500亩种菜。三年前他拿出100亩地试种甘蓝，当时他种的是“中甘11”，去年他又种了“中甘21”，结果非常喜人。&nbsp;<br />\r\n　　“产量特别高，亩产达到了每亩近9000斤，品质也特别好，去年的收购价每斤达到了1.2元，别的品种最多到0.6元。收购商大多数是从京津来，远的也有苏杭甚至广东，到了地头直接问有没有&lsquo;中甘21&rsquo;，无论多少，照单全收。用膜包好了装上冷藏车就直接运走了。”&nbsp;<br />\r\n　　去年是甘蓝市场的“大年”，农民增产又增收，随着甘蓝种植面积的扩大，加上今年雨水丰沛，地里的甘蓝又是一次大丰收，但甘蓝的价格却像是坐了过山车，赵林告诉记者：“两年暴赚、一年小赚、一年持平、一年赔本赚吆喝。”这基本就是甘蓝的价格周期。据了解，今年甘蓝的地头收购价跌到了谷底，从去年的1.2元到现在的0.2元，对于这种暴跌，赵林倒显得很平静，“0.2元的价格，对&lsquo;中甘21&rsquo;这种好的品种来说，刚刚够成本，今年不行明年再来，我对这种产量高、品质好的品种还是很有信心的。”&nbsp;<br />\r\n　　加强技术支撑，让产业走的更远&nbsp;<br />\r\n　　发展优势产业，是近几年来各地经济发展，开展扶贫的主要思路，而科技对产业发展的支撑作用功不可没。除了建立院士专家工作站，在当地设立科技特派员的岗位，中国农科院蔬菜所也利用自己的专业优势，围绕农户、农场、种植大户的需求，提供远程诊断、技术培训、现场指导和试验示范。从推广新品种到科学的栽培管理，对产业的提质增效帮助很大。但是生产是一方面，而市场又是另一方面。“我们一直在思考，是技术引导产业还是市场引导产业，事实上，这两者都不能忽略，我们的农业科技给农民带来了丰收，而且还要帮助他们丰收后再增收。”中国农科院科技管理局副局长陆建忠说。&nbsp;<br />\r\n　　位于河北张家口市的崇礼区，是我国着名的滑雪胜地，由于地形地势呈现为狭长的山区，夏季凉爽而短促，也特别适合种植冷凉蔬菜。驱车沿山路走，路两旁种植的都是甘蓝，张家口市农科院蔬菜所所长苏浴源很自豪地说：“我们这里是万亩甘蓝种植带，这里的气候种什么蔬菜都长不好，除了甘蓝。老百姓也是靠种甘蓝提高收入的。”&nbsp;<br />\r\n　　马丈子村也属于这个万亩甘蓝带中，今年甘蓝价格不好，当地科技人员组织农户延期定植，5月中旬播种，到采收的时候甘蓝的收购价已经从0.2元到了0.5元，保证了不亏损。&nbsp;<br />\r\n　　“考虑到蔬菜价格在市场上的波动情况，我们在育种中会发展不同品种的不同特征，让农民们有多种选择。中甘21的品质好，我们还有最新育成的中甘588和中甘590，它们的特点是采摘时间长，长达25天，这样农民可以根据市场的变化，调整供应。”杨丽梅说。此外，由于市场比较喜欢1~2斤重左右、可以单手握住大小的甘蓝，科技人员在指导农户种植的时候，也会教他们控制水肥，不让甘蓝长得太大。&nbsp;<br />\r\n　　“冷凉蔬菜”是我国特有的概念，也面临着蔬菜产业转型升级过程中所遇到的机遇与挑战，在市场面前，科研要尊重市场规律，同时也要利用市场规律，才能发挥科技的支撑作用。 （何烨）', '', 'admin', '', '1472014307', '1472014307', 'true', '', '8月，全国大部分地区从南到北，正经历着盛夏的烧烤模式，而在内蒙古的乌兰察布市，已经凉风习习，大有初秋的味道。由于海拔和纬度的原因，这里即便是7~9月，平均气温也不会超过', '科技,攻关,带,“,火,”,冷凉,蔬菜,8月,全国,', '104', '1472014294', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('30', '2', '大蒜开始响起“涨声”　“蒜你狠”卷土重来', '', '/storage/images/20220209/12521045V-0-lp.jpg', '', '　　<img alt=\"\" src=\"/storage/images/20220209/12521045V-0.jpg\" />&nbsp;<br />\r\n　　最近，不少市民发现大蒜越来越贵了，“蒜你狠”再度回归。记者调查发现，受市场供应量减少等因素影响，眼下辽宁鞍山市场大蒜的价格比一个月前上涨三成多，最高卖到9元/500克，蒜薹也跟风涨到6元/500克左右。&nbsp;<br />\r\n　　昨日，记者走访我市一些农贸市场了解到，大蒜最贵的已经卖到9元/500克了，而一个月前还只要7元/500克。一些市民听到价格不禁咋舌：“一块钱一头，做菜省着点用吧”。为此，一些烧烤店也不舍得“随便”给顾客免费吃大蒜了。不仅如此，蒜薹价格也由一个月前的3元—4元/500克左右，涨至眼下的6元/500克左右。&nbsp;<br />\r\n　　据了解，今年1月份开始，大蒜就开始响起“涨声”，3月份大蒜最贵的时候达到过9元/500克的“历史最高点”，五六月份时新蒜上市，给大蒜价格“降温”，不过之后几个月也一直在6元—7元/500克左右的高位运行，眼下再度冲高。对于大蒜价格上涨的原因，有菜贩介绍，由于大蒜原产地减产，大蒜价格被“炒”贵，另外一些批发商“惜售”大蒜不舍得出手，也使得本就供不应求的市场再陷窘境。 （于秀琪）', '', 'admin', '', '1472014330', '1472014330', 'true', '', '最近，不少市民发现大蒜越来越贵了，蒜你狠再度回归。记者调查发现，受市场供应量减少等因素影响，眼下辽宁鞍山市场大蒜的价格比一个月前上涨三成多，最高卖到9元/500克，蒜薹', '大蒜,开始,响起,“,涨声,”,蒜你狠,卷土重来,', '148', '1472014321', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('31', '2', '科技攻关带“火”冷凉蔬菜', '', '/storage/images/20220209/12514L320-0-lp.jpg', '', '　　　<img alt=\"\" src=\"/storage/images/20220209/12514L320-0.jpg\" />&nbsp;<br />\r\n　　8月，全国大部分地区从南到北，正经历着盛夏的“烧烤”模式，而在内蒙古的乌兰察布市，已经凉风习习，大有初秋的味道。由于海拔和纬度的原因，这里即便是7~9月，平均气温也不会超过25℃。气候也是一种资源，比如近几年来内蒙古乌兰察布的冷凉蔬菜种植，就是利用这里在同期与全国的温湿度的差别而迅速发展起来的。&nbsp;<br />\r\n　　创新集成技术，攻克冷凉蔬菜种植难题&nbsp;<br />\r\n　　所谓冷凉蔬菜，是指适宜在气候冷凉地区夏季生产的蔬菜，主要包括甘蓝、大白菜、胡萝卜、洋葱、马铃薯等。由于7~9月全国普遍高温，而在高海拔、高纬度地区，此时正好生长冷凉蔬菜，与南方的蔬菜错季上市，市场优势不言而喻。&nbsp;<br />\r\n　　乌兰察布市是近几年发展起来的北方夏季冷凉蔬菜基地之一，尤其是2012年由中国农科院蔬菜花卉研究所方智远院士领衔的专家团队在这里建立了全国首个以冷凉蔬菜产业为研究方向的院士专家工作站后，以甘蓝种植为主的冷凉蔬菜发展有了质的飞跃。&nbsp;<br />\r\n　　“我国的甘蓝种植主要存在三大问题，一是抗病、抗逆品种的推广，二是虫害防治效率低、化学<a>农药</a>用量大，三是水肥利用率低，用工成本高。这几年来我们的科研攻关和技术示范主要就围绕着这三个方面展开。”中国农科院蔬菜花卉研究所、“甘蓝绿色增产增效技术集成”项目主持人杨丽梅介绍。&nbsp;<br />\r\n　　在乌兰察布市兴和县曹四夭村，这里有百亩甘蓝绿色增产增效技术示范田，三个甘蓝品种：中甘21、中甘628、中甘192进行示范展示，而其中长势最好的还是方智远院士的“得意之作”——中甘21。4月20日播种，5月10日定植，大约三个月，就能看到一片绿油油的甘蓝铺在眼前，一颗颗包球紧实，而且颜色漂亮。&nbsp;<br />\r\n　　乌兰察布市科技局研究员，也是院士专家工作站在当地的科技特派员关慧明告诉我们，这片示范田的成功之处首先是品种好，中甘系列甘蓝品种抗裂、耐贮运，已经超过了韩国品种铁头系列。其次是采用了一系列绿色增产增效栽培技术，如太阳能杀虫灯、性诱剂、生物农药，以及膜下滴灌、合理密植等。“通过集成技术打出组合拳，在我们的示范田里，减少了30%的化学农药用量，减少灌溉用水30%以上，减少人工20%以上，示范品种比对照品种（铁头4号）增产8~10%，每亩增值300~500元。”关慧明说。&nbsp;<br />\r\n　　由于“甘蓝绿色高产高效技术集成模式研究与示范”的带动，仅乌兰察布一地甘蓝种植就超过4万亩。周边农户大面积示范区5个，每个农户示范区面积约100亩，并进一步辐射到河北张家口及承德地区，辐射带动总面积8~10万亩。&nbsp;<br />\r\n　　产量高品质好，农民增收有了新途径&nbsp;<br />\r\n　　甘蓝，也就是我们日常餐桌上的圆白菜，经常是以凉拌的做法为主，这就对甘蓝的口感要求很高。在冷凉蔬菜院士工作站基地，工作人员把刚摘下的“中甘21”和当地原来的主栽品种韩国的“铁头4号”分别切开让大家品尝，“铁头4号”有一种微微的辛辣口感，而“中甘21”则更加脆嫩、鲜甜，中国农业科学院副院长王汉中笑着说：“可以当水果吃了。”也许正因为这种口感上的细微差别，让我国自己选育的甘蓝品种近几年在市场上大受欢迎。&nbsp;<br />\r\n　　46岁的河北承德人赵林，原先是蔬菜销售商。2003年他开始在曹四夭村承包流转地2500亩种菜。三年前他拿出100亩地试种甘蓝，当时他种的是“中甘11”，去年他又种了“中甘21”，结果非常喜人。&nbsp;<br />\r\n　　“产量特别高，亩产达到了每亩近9000斤，品质也特别好，去年的收购价每斤达到了1.2元，别的品种最多到0.6元。收购商大多数是从京津来，远的也有苏杭甚至广东，到了地头直接问有没有&lsquo;中甘21&rsquo;，无论多少，照单全收。用膜包好了装上冷藏车就直接运走了。”&nbsp;<br />\r\n　　去年是甘蓝市场的“大年”，农民增产又增收，随着甘蓝种植面积的扩大，加上今年雨水丰沛，地里的甘蓝又是一次大丰收，但甘蓝的价格却像是坐了过山车，赵林告诉记者：“两年暴赚、一年小赚、一年持平、一年赔本赚吆喝。”这基本就是甘蓝的价格周期。据了解，今年甘蓝的地头收购价跌到了谷底，从去年的1.2元到现在的0.2元，对于这种暴跌，赵林倒显得很平静，“0.2元的价格，对&lsquo;中甘21&rsquo;这种好的品种来说，刚刚够成本，今年不行明年再来，我对这种产量高、品质好的品种还是很有信心的。”&nbsp;<br />\r\n　　加强技术支撑，让产业走的更远&nbsp;<br />\r\n　　发展优势产业，是近几年来各地经济发展，开展扶贫的主要思路，而科技对产业发展的支撑作用功不可没。除了建立院士专家工作站，在当地设立科技特派员的岗位，中国农科院蔬菜所也利用自己的专业优势，围绕农户、农场、种植大户的需求，提供远程诊断、技术培训、现场指导和试验示范。从推广新品种到科学的栽培管理，对产业的提质增效帮助很大。但是生产是一方面，而市场又是另一方面。“我们一直在思考，是技术引导产业还是市场引导产业，事实上，这两者都不能忽略，我们的农业科技给农民带来了丰收，而且还要帮助他们丰收后再增收。”中国农科院科技管理局副局长陆建忠说。&nbsp;<br />\r\n　　位于河北张家口市的崇礼区，是我国着名的滑雪胜地，由于地形地势呈现为狭长的山区，夏季凉爽而短促，也特别适合种植冷凉蔬菜。驱车沿山路走，路两旁种植的都是甘蓝，张家口市农科院蔬菜所所长苏浴源很自豪地说：“我们这里是万亩甘蓝种植带，这里的气候种什么蔬菜都长不好，除了甘蓝。老百姓也是靠种甘蓝提高收入的。”&nbsp;<br />\r\n　　马丈子村也属于这个万亩甘蓝带中，今年甘蓝价格不好，当地科技人员组织农户延期定植，5月中旬播种，到采收的时候甘蓝的收购价已经从0.2元到了0.5元，保证了不亏损。&nbsp;<br />\r\n　　“考虑到蔬菜价格在市场上的波动情况，我们在育种中会发展不同品种的不同特征，让农民们有多种选择。中甘21的品质好，我们还有最新育成的中甘588和中甘590，它们的特点是采摘时间长，长达25天，这样农民可以根据市场的变化，调整供应。”杨丽梅说。此外，由于市场比较喜欢1~2斤重左右、可以单手握住大小的甘蓝，科技人员在指导农户种植的时候，也会教他们控制水肥，不让甘蓝长得太大。&nbsp;<br />\r\n　　“冷凉蔬菜”是我国特有的概念，也面临着蔬菜产业转型升级过程中所遇到的机遇与挑战，在市场面前，科研要尊重市场规律，同时也要利用市场规律，才能发挥科技的支撑作用。 （何烨）', '', 'admin', '', '1472014307', '1472014307', 'true', '', '8月，全国大部分地区从南到北，正经历着盛夏的烧烤模式，而在内蒙古的乌兰察布市，已经凉风习习，大有初秋的味道。由于海拔和纬度的原因，这里即便是7~9月，平均气温也不会超过', '科技,攻关,带,“,火,”,冷凉,蔬菜,8月,全国,', '104', '1472014294', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('32', '2', '大蒜开始响起“涨声”　“蒜你狠”卷土重来', '', '/storage/images/20220209/12521045V-0-lp.jpg', '', '　　<img alt=\"\" src=\"/storage/images/20220209/12521045V-0.jpg\" />&nbsp;<br />\r\n　　最近，不少市民发现大蒜越来越贵了，“蒜你狠”再度回归。记者调查发现，受市场供应量减少等因素影响，眼下辽宁鞍山市场大蒜的价格比一个月前上涨三成多，最高卖到9元/500克，蒜薹也跟风涨到6元/500克左右。&nbsp;<br />\r\n　　昨日，记者走访我市一些农贸市场了解到，大蒜最贵的已经卖到9元/500克了，而一个月前还只要7元/500克。一些市民听到价格不禁咋舌：“一块钱一头，做菜省着点用吧”。为此，一些烧烤店也不舍得“随便”给顾客免费吃大蒜了。不仅如此，蒜薹价格也由一个月前的3元—4元/500克左右，涨至眼下的6元/500克左右。&nbsp;<br />\r\n　　据了解，今年1月份开始，大蒜就开始响起“涨声”，3月份大蒜最贵的时候达到过9元/500克的“历史最高点”，五六月份时新蒜上市，给大蒜价格“降温”，不过之后几个月也一直在6元—7元/500克左右的高位运行，眼下再度冲高。对于大蒜价格上涨的原因，有菜贩介绍，由于大蒜原产地减产，大蒜价格被“炒”贵，另外一些批发商“惜售”大蒜不舍得出手，也使得本就供不应求的市场再陷窘境。 （于秀琪）', '', 'admin', '', '1472014330', '1472014330', 'true', '', '最近，不少市民发现大蒜越来越贵了，蒜你狠再度回归。记者调查发现，受市场供应量减少等因素影响，眼下辽宁鞍山市场大蒜的价格比一个月前上涨三成多，最高卖到9元/500克，蒜薹', '大蒜,开始,响起,“,涨声,”,蒜你狠,卷土重来,', '148', '1472014321', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('33', '2', '科技攻关带“火”冷凉蔬菜', '', '/storage/images/20220209/12514L320-0-lp.jpg', '', '　　　<img alt=\"\" src=\"/storage/images/20220209/12514L320-0.jpg\" />&nbsp;<br />\r\n　　8月，全国大部分地区从南到北，正经历着盛夏的“烧烤”模式，而在内蒙古的乌兰察布市，已经凉风习习，大有初秋的味道。由于海拔和纬度的原因，这里即便是7~9月，平均气温也不会超过25℃。气候也是一种资源，比如近几年来内蒙古乌兰察布的冷凉蔬菜种植，就是利用这里在同期与全国的温湿度的差别而迅速发展起来的。&nbsp;<br />\r\n　　创新集成技术，攻克冷凉蔬菜种植难题&nbsp;<br />\r\n　　所谓冷凉蔬菜，是指适宜在气候冷凉地区夏季生产的蔬菜，主要包括甘蓝、大白菜、胡萝卜、洋葱、马铃薯等。由于7~9月全国普遍高温，而在高海拔、高纬度地区，此时正好生长冷凉蔬菜，与南方的蔬菜错季上市，市场优势不言而喻。&nbsp;<br />\r\n　　乌兰察布市是近几年发展起来的北方夏季冷凉蔬菜基地之一，尤其是2012年由中国农科院蔬菜花卉研究所方智远院士领衔的专家团队在这里建立了全国首个以冷凉蔬菜产业为研究方向的院士专家工作站后，以甘蓝种植为主的冷凉蔬菜发展有了质的飞跃。&nbsp;<br />\r\n　　“我国的甘蓝种植主要存在三大问题，一是抗病、抗逆品种的推广，二是虫害防治效率低、化学<a>农药</a>用量大，三是水肥利用率低，用工成本高。这几年来我们的科研攻关和技术示范主要就围绕着这三个方面展开。”中国农科院蔬菜花卉研究所、“甘蓝绿色增产增效技术集成”项目主持人杨丽梅介绍。&nbsp;<br />\r\n　　在乌兰察布市兴和县曹四夭村，这里有百亩甘蓝绿色增产增效技术示范田，三个甘蓝品种：中甘21、中甘628、中甘192进行示范展示，而其中长势最好的还是方智远院士的“得意之作”——中甘21。4月20日播种，5月10日定植，大约三个月，就能看到一片绿油油的甘蓝铺在眼前，一颗颗包球紧实，而且颜色漂亮。&nbsp;<br />\r\n　　乌兰察布市科技局研究员，也是院士专家工作站在当地的科技特派员关慧明告诉我们，这片示范田的成功之处首先是品种好，中甘系列甘蓝品种抗裂、耐贮运，已经超过了韩国品种铁头系列。其次是采用了一系列绿色增产增效栽培技术，如太阳能杀虫灯、性诱剂、生物农药，以及膜下滴灌、合理密植等。“通过集成技术打出组合拳，在我们的示范田里，减少了30%的化学农药用量，减少灌溉用水30%以上，减少人工20%以上，示范品种比对照品种（铁头4号）增产8~10%，每亩增值300~500元。”关慧明说。&nbsp;<br />\r\n　　由于“甘蓝绿色高产高效技术集成模式研究与示范”的带动，仅乌兰察布一地甘蓝种植就超过4万亩。周边农户大面积示范区5个，每个农户示范区面积约100亩，并进一步辐射到河北张家口及承德地区，辐射带动总面积8~10万亩。&nbsp;<br />\r\n　　产量高品质好，农民增收有了新途径&nbsp;<br />\r\n　　甘蓝，也就是我们日常餐桌上的圆白菜，经常是以凉拌的做法为主，这就对甘蓝的口感要求很高。在冷凉蔬菜院士工作站基地，工作人员把刚摘下的“中甘21”和当地原来的主栽品种韩国的“铁头4号”分别切开让大家品尝，“铁头4号”有一种微微的辛辣口感，而“中甘21”则更加脆嫩、鲜甜，中国农业科学院副院长王汉中笑着说：“可以当水果吃了。”也许正因为这种口感上的细微差别，让我国自己选育的甘蓝品种近几年在市场上大受欢迎。&nbsp;<br />\r\n　　46岁的河北承德人赵林，原先是蔬菜销售商。2003年他开始在曹四夭村承包流转地2500亩种菜。三年前他拿出100亩地试种甘蓝，当时他种的是“中甘11”，去年他又种了“中甘21”，结果非常喜人。&nbsp;<br />\r\n　　“产量特别高，亩产达到了每亩近9000斤，品质也特别好，去年的收购价每斤达到了1.2元，别的品种最多到0.6元。收购商大多数是从京津来，远的也有苏杭甚至广东，到了地头直接问有没有&lsquo;中甘21&rsquo;，无论多少，照单全收。用膜包好了装上冷藏车就直接运走了。”&nbsp;<br />\r\n　　去年是甘蓝市场的“大年”，农民增产又增收，随着甘蓝种植面积的扩大，加上今年雨水丰沛，地里的甘蓝又是一次大丰收，但甘蓝的价格却像是坐了过山车，赵林告诉记者：“两年暴赚、一年小赚、一年持平、一年赔本赚吆喝。”这基本就是甘蓝的价格周期。据了解，今年甘蓝的地头收购价跌到了谷底，从去年的1.2元到现在的0.2元，对于这种暴跌，赵林倒显得很平静，“0.2元的价格，对&lsquo;中甘21&rsquo;这种好的品种来说，刚刚够成本，今年不行明年再来，我对这种产量高、品质好的品种还是很有信心的。”&nbsp;<br />\r\n　　加强技术支撑，让产业走的更远&nbsp;<br />\r\n　　发展优势产业，是近几年来各地经济发展，开展扶贫的主要思路，而科技对产业发展的支撑作用功不可没。除了建立院士专家工作站，在当地设立科技特派员的岗位，中国农科院蔬菜所也利用自己的专业优势，围绕农户、农场、种植大户的需求，提供远程诊断、技术培训、现场指导和试验示范。从推广新品种到科学的栽培管理，对产业的提质增效帮助很大。但是生产是一方面，而市场又是另一方面。“我们一直在思考，是技术引导产业还是市场引导产业，事实上，这两者都不能忽略，我们的农业科技给农民带来了丰收，而且还要帮助他们丰收后再增收。”中国农科院科技管理局副局长陆建忠说。&nbsp;<br />\r\n　　位于河北张家口市的崇礼区，是我国着名的滑雪胜地，由于地形地势呈现为狭长的山区，夏季凉爽而短促，也特别适合种植冷凉蔬菜。驱车沿山路走，路两旁种植的都是甘蓝，张家口市农科院蔬菜所所长苏浴源很自豪地说：“我们这里是万亩甘蓝种植带，这里的气候种什么蔬菜都长不好，除了甘蓝。老百姓也是靠种甘蓝提高收入的。”&nbsp;<br />\r\n　　马丈子村也属于这个万亩甘蓝带中，今年甘蓝价格不好，当地科技人员组织农户延期定植，5月中旬播种，到采收的时候甘蓝的收购价已经从0.2元到了0.5元，保证了不亏损。&nbsp;<br />\r\n　　“考虑到蔬菜价格在市场上的波动情况，我们在育种中会发展不同品种的不同特征，让农民们有多种选择。中甘21的品质好，我们还有最新育成的中甘588和中甘590，它们的特点是采摘时间长，长达25天，这样农民可以根据市场的变化，调整供应。”杨丽梅说。此外，由于市场比较喜欢1~2斤重左右、可以单手握住大小的甘蓝，科技人员在指导农户种植的时候，也会教他们控制水肥，不让甘蓝长得太大。&nbsp;<br />\r\n　　“冷凉蔬菜”是我国特有的概念，也面临着蔬菜产业转型升级过程中所遇到的机遇与挑战，在市场面前，科研要尊重市场规律，同时也要利用市场规律，才能发挥科技的支撑作用。 （何烨）', '', 'admin', '', '1472014307', '1472014307', 'true', '', '8月，全国大部分地区从南到北，正经历着盛夏的烧烤模式，而在内蒙古的乌兰察布市，已经凉风习习，大有初秋的味道。由于海拔和纬度的原因，这里即便是7~9月，平均气温也不会超过', '科技,攻关,带,“,火,”,冷凉,蔬菜,8月,全国,', '104', '1472014294', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('34', '2', '大蒜开始响起“涨声”　“蒜你狠”卷土重来', '', '/storage/images/20220209/12521045V-0-lp.jpg', '', '　　<img alt=\"\" src=\"/storage/images/20220209/12521045V-0.jpg\" />&nbsp;<br />\r\n　　最近，不少市民发现大蒜越来越贵了，“蒜你狠”再度回归。记者调查发现，受市场供应量减少等因素影响，眼下辽宁鞍山市场大蒜的价格比一个月前上涨三成多，最高卖到9元/500克，蒜薹也跟风涨到6元/500克左右。&nbsp;<br />\r\n　　昨日，记者走访我市一些农贸市场了解到，大蒜最贵的已经卖到9元/500克了，而一个月前还只要7元/500克。一些市民听到价格不禁咋舌：“一块钱一头，做菜省着点用吧”。为此，一些烧烤店也不舍得“随便”给顾客免费吃大蒜了。不仅如此，蒜薹价格也由一个月前的3元—4元/500克左右，涨至眼下的6元/500克左右。&nbsp;<br />\r\n　　据了解，今年1月份开始，大蒜就开始响起“涨声”，3月份大蒜最贵的时候达到过9元/500克的“历史最高点”，五六月份时新蒜上市，给大蒜价格“降温”，不过之后几个月也一直在6元—7元/500克左右的高位运行，眼下再度冲高。对于大蒜价格上涨的原因，有菜贩介绍，由于大蒜原产地减产，大蒜价格被“炒”贵，另外一些批发商“惜售”大蒜不舍得出手，也使得本就供不应求的市场再陷窘境。 （于秀琪）', '', 'admin', '', '1472014330', '1472014330', 'true', '', '最近，不少市民发现大蒜越来越贵了，蒜你狠再度回归。记者调查发现，受市场供应量减少等因素影响，眼下辽宁鞍山市场大蒜的价格比一个月前上涨三成多，最高卖到9元/500克，蒜薹', '大蒜,开始,响起,“,涨声,”,蒜你狠,卷土重来,', '148', '1472014321', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('35', '2', '科技攻关带“火”冷凉蔬菜', '', '/storage/images/20220209/12514L320-0-lp.jpg', '', '　　　<img alt=\"\" src=\"/storage/images/20220209/12514L320-0.jpg\" />&nbsp;<br />\r\n　　8月，全国大部分地区从南到北，正经历着盛夏的“烧烤”模式，而在内蒙古的乌兰察布市，已经凉风习习，大有初秋的味道。由于海拔和纬度的原因，这里即便是7~9月，平均气温也不会超过25℃。气候也是一种资源，比如近几年来内蒙古乌兰察布的冷凉蔬菜种植，就是利用这里在同期与全国的温湿度的差别而迅速发展起来的。&nbsp;<br />\r\n　　创新集成技术，攻克冷凉蔬菜种植难题&nbsp;<br />\r\n　　所谓冷凉蔬菜，是指适宜在气候冷凉地区夏季生产的蔬菜，主要包括甘蓝、大白菜、胡萝卜、洋葱、马铃薯等。由于7~9月全国普遍高温，而在高海拔、高纬度地区，此时正好生长冷凉蔬菜，与南方的蔬菜错季上市，市场优势不言而喻。&nbsp;<br />\r\n　　乌兰察布市是近几年发展起来的北方夏季冷凉蔬菜基地之一，尤其是2012年由中国农科院蔬菜花卉研究所方智远院士领衔的专家团队在这里建立了全国首个以冷凉蔬菜产业为研究方向的院士专家工作站后，以甘蓝种植为主的冷凉蔬菜发展有了质的飞跃。&nbsp;<br />\r\n　　“我国的甘蓝种植主要存在三大问题，一是抗病、抗逆品种的推广，二是虫害防治效率低、化学<a>农药</a>用量大，三是水肥利用率低，用工成本高。这几年来我们的科研攻关和技术示范主要就围绕着这三个方面展开。”中国农科院蔬菜花卉研究所、“甘蓝绿色增产增效技术集成”项目主持人杨丽梅介绍。&nbsp;<br />\r\n　　在乌兰察布市兴和县曹四夭村，这里有百亩甘蓝绿色增产增效技术示范田，三个甘蓝品种：中甘21、中甘628、中甘192进行示范展示，而其中长势最好的还是方智远院士的“得意之作”——中甘21。4月20日播种，5月10日定植，大约三个月，就能看到一片绿油油的甘蓝铺在眼前，一颗颗包球紧实，而且颜色漂亮。&nbsp;<br />\r\n　　乌兰察布市科技局研究员，也是院士专家工作站在当地的科技特派员关慧明告诉我们，这片示范田的成功之处首先是品种好，中甘系列甘蓝品种抗裂、耐贮运，已经超过了韩国品种铁头系列。其次是采用了一系列绿色增产增效栽培技术，如太阳能杀虫灯、性诱剂、生物农药，以及膜下滴灌、合理密植等。“通过集成技术打出组合拳，在我们的示范田里，减少了30%的化学农药用量，减少灌溉用水30%以上，减少人工20%以上，示范品种比对照品种（铁头4号）增产8~10%，每亩增值300~500元。”关慧明说。&nbsp;<br />\r\n　　由于“甘蓝绿色高产高效技术集成模式研究与示范”的带动，仅乌兰察布一地甘蓝种植就超过4万亩。周边农户大面积示范区5个，每个农户示范区面积约100亩，并进一步辐射到河北张家口及承德地区，辐射带动总面积8~10万亩。&nbsp;<br />\r\n　　产量高品质好，农民增收有了新途径&nbsp;<br />\r\n　　甘蓝，也就是我们日常餐桌上的圆白菜，经常是以凉拌的做法为主，这就对甘蓝的口感要求很高。在冷凉蔬菜院士工作站基地，工作人员把刚摘下的“中甘21”和当地原来的主栽品种韩国的“铁头4号”分别切开让大家品尝，“铁头4号”有一种微微的辛辣口感，而“中甘21”则更加脆嫩、鲜甜，中国农业科学院副院长王汉中笑着说：“可以当水果吃了。”也许正因为这种口感上的细微差别，让我国自己选育的甘蓝品种近几年在市场上大受欢迎。&nbsp;<br />\r\n　　46岁的河北承德人赵林，原先是蔬菜销售商。2003年他开始在曹四夭村承包流转地2500亩种菜。三年前他拿出100亩地试种甘蓝，当时他种的是“中甘11”，去年他又种了“中甘21”，结果非常喜人。&nbsp;<br />\r\n　　“产量特别高，亩产达到了每亩近9000斤，品质也特别好，去年的收购价每斤达到了1.2元，别的品种最多到0.6元。收购商大多数是从京津来，远的也有苏杭甚至广东，到了地头直接问有没有&lsquo;中甘21&rsquo;，无论多少，照单全收。用膜包好了装上冷藏车就直接运走了。”&nbsp;<br />\r\n　　去年是甘蓝市场的“大年”，农民增产又增收，随着甘蓝种植面积的扩大，加上今年雨水丰沛，地里的甘蓝又是一次大丰收，但甘蓝的价格却像是坐了过山车，赵林告诉记者：“两年暴赚、一年小赚、一年持平、一年赔本赚吆喝。”这基本就是甘蓝的价格周期。据了解，今年甘蓝的地头收购价跌到了谷底，从去年的1.2元到现在的0.2元，对于这种暴跌，赵林倒显得很平静，“0.2元的价格，对&lsquo;中甘21&rsquo;这种好的品种来说，刚刚够成本，今年不行明年再来，我对这种产量高、品质好的品种还是很有信心的。”&nbsp;<br />\r\n　　加强技术支撑，让产业走的更远&nbsp;<br />\r\n　　发展优势产业，是近几年来各地经济发展，开展扶贫的主要思路，而科技对产业发展的支撑作用功不可没。除了建立院士专家工作站，在当地设立科技特派员的岗位，中国农科院蔬菜所也利用自己的专业优势，围绕农户、农场、种植大户的需求，提供远程诊断、技术培训、现场指导和试验示范。从推广新品种到科学的栽培管理，对产业的提质增效帮助很大。但是生产是一方面，而市场又是另一方面。“我们一直在思考，是技术引导产业还是市场引导产业，事实上，这两者都不能忽略，我们的农业科技给农民带来了丰收，而且还要帮助他们丰收后再增收。”中国农科院科技管理局副局长陆建忠说。&nbsp;<br />\r\n　　位于河北张家口市的崇礼区，是我国着名的滑雪胜地，由于地形地势呈现为狭长的山区，夏季凉爽而短促，也特别适合种植冷凉蔬菜。驱车沿山路走，路两旁种植的都是甘蓝，张家口市农科院蔬菜所所长苏浴源很自豪地说：“我们这里是万亩甘蓝种植带，这里的气候种什么蔬菜都长不好，除了甘蓝。老百姓也是靠种甘蓝提高收入的。”&nbsp;<br />\r\n　　马丈子村也属于这个万亩甘蓝带中，今年甘蓝价格不好，当地科技人员组织农户延期定植，5月中旬播种，到采收的时候甘蓝的收购价已经从0.2元到了0.5元，保证了不亏损。&nbsp;<br />\r\n　　“考虑到蔬菜价格在市场上的波动情况，我们在育种中会发展不同品种的不同特征，让农民们有多种选择。中甘21的品质好，我们还有最新育成的中甘588和中甘590，它们的特点是采摘时间长，长达25天，这样农民可以根据市场的变化，调整供应。”杨丽梅说。此外，由于市场比较喜欢1~2斤重左右、可以单手握住大小的甘蓝，科技人员在指导农户种植的时候，也会教他们控制水肥，不让甘蓝长得太大。&nbsp;<br />\r\n　　“冷凉蔬菜”是我国特有的概念，也面临着蔬菜产业转型升级过程中所遇到的机遇与挑战，在市场面前，科研要尊重市场规律，同时也要利用市场规律，才能发挥科技的支撑作用。 （何烨）', '', 'admin', '', '1472014307', '1472014307', 'true', '', '8月，全国大部分地区从南到北，正经历着盛夏的烧烤模式，而在内蒙古的乌兰察布市，已经凉风习习，大有初秋的味道。由于海拔和纬度的原因，这里即便是7~9月，平均气温也不会超过', '科技,攻关,带,“,火,”,冷凉,蔬菜,8月,全国,', '104', '1472014294', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('36', '2', '大蒜开始响起“涨声”　“蒜你狠”卷土重来', '', '/storage/images/20220209/12521045V-0-lp.jpg', '', '　　<img alt=\"\" src=\"/storage/images/20220209/12521045V-0.jpg\" />&nbsp;<br />\r\n　　最近，不少市民发现大蒜越来越贵了，“蒜你狠”再度回归。记者调查发现，受市场供应量减少等因素影响，眼下辽宁鞍山市场大蒜的价格比一个月前上涨三成多，最高卖到9元/500克，蒜薹也跟风涨到6元/500克左右。&nbsp;<br />\r\n　　昨日，记者走访我市一些农贸市场了解到，大蒜最贵的已经卖到9元/500克了，而一个月前还只要7元/500克。一些市民听到价格不禁咋舌：“一块钱一头，做菜省着点用吧”。为此，一些烧烤店也不舍得“随便”给顾客免费吃大蒜了。不仅如此，蒜薹价格也由一个月前的3元—4元/500克左右，涨至眼下的6元/500克左右。&nbsp;<br />\r\n　　据了解，今年1月份开始，大蒜就开始响起“涨声”，3月份大蒜最贵的时候达到过9元/500克的“历史最高点”，五六月份时新蒜上市，给大蒜价格“降温”，不过之后几个月也一直在6元—7元/500克左右的高位运行，眼下再度冲高。对于大蒜价格上涨的原因，有菜贩介绍，由于大蒜原产地减产，大蒜价格被“炒”贵，另外一些批发商“惜售”大蒜不舍得出手，也使得本就供不应求的市场再陷窘境。 （于秀琪）', '', 'admin', '', '1472014330', '1472014330', 'true', '', '最近，不少市民发现大蒜越来越贵了，蒜你狠再度回归。记者调查发现，受市场供应量减少等因素影响，眼下辽宁鞍山市场大蒜的价格比一个月前上涨三成多，最高卖到9元/500克，蒜薹', '大蒜,开始,响起,“,涨声,”,蒜你狠,卷土重来,', '148', '1472014321', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('37', '10', '农家院标题', '', '/storage/images/20220209/1-161126233F70-L.jpg', '', '<p>\r\n	　长岛大钦岛海天渔家乐座落于大钦岛北村西海口码头，是一家集住宿，餐饮，旅游，为一体的综合性渔家乐，渔家乐建设在离海边10米处，依山傍海，海景房，在家就能够看到湛蓝大海，海上风光秀媚，蓝天，绿岛，碧海混为一体，鸟鸣，渔歌，涛声此起彼伏，奇石与浪花起舞，海鸥为渔夫伴行。</p>\r\n<p>\r\n	　　大钦岛海天渔家乐海产品资源丰富，老板娘做饭特别好吃，螃蟹，片口鱼，老板鱼，黑鱼，安康鱼，扇贝，海胆，老板都不另外收费只要顾客有需求，全部海鲜，均能吃到，也可帮顾客代购。晚上渔家还提供了自助烧烤，这是渔家的一大优点 ，夜幕下，看着漂亮的大海，吃着烧烤的海鲜，喝点小酒，呵呵多么惬意的假期。</p>\r\n<p>\r\n	　　为游客提供了相当多旅游项目，诸如：唐王山，山神庙，龙王庙，妈祖庙参观拜庙，驾船环岛游、深海浅海垂钓、鹅卵石采集、也能够乘车游览全岛风光，还有，自我家有海区，可赶海，游泳，</p>\r\n<p>\r\n	　　渔家客房设有标准间、双人间、三人间、四人间等，设有独立卫生间浴室，客房干净、卫生保证你住得舒心，吃得中意、玩的开心，真正体会渔家风情。海天渔家乐有专车接送，还有家有面包，皮卡，轿车，可自行驾车游览岛上风光，满足你的不同的需求。</p>\r\n<p>\r\n	　　海天渔家乐愿为来岛游客提供中意的吃住行购一条龙服务，让你踏上这个漂亮的海岛就会开始一段地地道道的渔家乐之旅。让来岛的顾客无后顾之忧。高高兴兴的游玩。正是这样热情周到的服务 ，许多顾客中意而归然后推荐亲朋与好友光顾这个朴实的渔家。</p>\r\n', '', 'admin', '', '1480174686', '1480174686', 'true', '', '长岛大钦岛海天渔家乐座落于大钦岛北村西海口码头，是一家集住宿，餐饮，旅游，为一体的综合性渔家乐，渔家乐建设在离海边10米处，依山傍海，海景房，在家就能够看到湛蓝大海', '农家院,标题,长岛,大钦,岛,海天,渔,家乐,座,', '196', '1480174620', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('38', '10', '农家院标题', '', '/storage/images/20220209/1-161126233R30-L.jpg', '', '<p>\r\n	长岛大钦岛海天渔家乐座落于大钦岛北村西海口码头，是一家集住宿，餐饮，旅游，为一体的综合性渔家乐，渔家乐建设在离海边10米处，依山傍海，海景房，在家就能够看到湛蓝大海，海上风光秀媚，蓝天，绿岛，碧海混为一体，鸟鸣，渔歌，涛声此起彼伏，奇石与浪花起舞，海鸥为渔夫伴行。</p>\r\n<p>\r\n	　　大钦岛海天渔家乐海产品资源丰富，老板娘做饭特别好吃，螃蟹，片口鱼，老板鱼，黑鱼，安康鱼，扇贝，海胆，老板都不另外收费只要顾客有需求，全部海鲜，均能吃到，也可帮顾客代购。晚上渔家还提供了自助烧烤，这是渔家的一大优点 ，夜幕下，看着漂亮的大海，吃着烧烤的海鲜，喝点小酒，呵呵多么惬意的假期。</p>\r\n<p>\r\n	　　为游客提供了相当多旅游项目，诸如：唐王山，山神庙，龙王庙，妈祖庙参观拜庙，驾船环岛游、深海浅海垂钓、鹅卵石采集、也能够乘车游览全岛风光，还有，自我家有海区，可赶海，游泳，</p>\r\n<p>\r\n	　　渔家客房设有标准间、双人间、三人间、四人间等，设有独立卫生间浴室，客房干净、卫生保证你住得舒心，吃得中意、玩的开心，真正体会渔家风情。海天渔家乐有专车接送，还有家有面包，皮卡，轿车，可自行驾车游览岛上风光，满足你的不同的需求。</p>\r\n<p>\r\n	　　海天渔家乐愿为来岛游客提供中意的吃住行购一条龙服务，让你踏上这个漂亮的海岛就会开始一段地地道道的渔家乐之旅。让来岛的顾客无后顾之忧。高高兴兴的游玩。正是这样热情周到的服务 ，许多顾客中意而归然后推荐亲朋与好友光顾这个朴实的渔家。</p>\r\n', '', 'admin', '', '1480174712', '1480174712', 'true', '', '长岛大钦岛海天渔家乐座落于大钦岛北村西海口码头，是一家集住宿，餐饮，旅游，为一体的综合性渔家乐，渔家乐建设在离海边10米处，依山傍海，海景房，在家就能够看到湛蓝大海', '农家院,标题,长岛,大钦,岛,海天,渔,家乐,座,', '159', '1480174696', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('39', '10', '农家院标题', '', '/storage/images/20220209/1-161126233F70-L.jpg', '', '<p>\r\n	　长岛大钦岛海天渔家乐座落于大钦岛北村西海口码头，是一家集住宿，餐饮，旅游，为一体的综合性渔家乐，渔家乐建设在离海边10米处，依山傍海，海景房，在家就能够看到湛蓝大海，海上风光秀媚，蓝天，绿岛，碧海混为一体，鸟鸣，渔歌，涛声此起彼伏，奇石与浪花起舞，海鸥为渔夫伴行。</p>\r\n<p>\r\n	　　大钦岛海天渔家乐海产品资源丰富，老板娘做饭特别好吃，螃蟹，片口鱼，老板鱼，黑鱼，安康鱼，扇贝，海胆，老板都不另外收费只要顾客有需求，全部海鲜，均能吃到，也可帮顾客代购。晚上渔家还提供了自助烧烤，这是渔家的一大优点 ，夜幕下，看着漂亮的大海，吃着烧烤的海鲜，喝点小酒，呵呵多么惬意的假期。</p>\r\n<p>\r\n	　　为游客提供了相当多旅游项目，诸如：唐王山，山神庙，龙王庙，妈祖庙参观拜庙，驾船环岛游、深海浅海垂钓、鹅卵石采集、也能够乘车游览全岛风光，还有，自我家有海区，可赶海，游泳，</p>\r\n<p>\r\n	　　渔家客房设有标准间、双人间、三人间、四人间等，设有独立卫生间浴室，客房干净、卫生保证你住得舒心，吃得中意、玩的开心，真正体会渔家风情。海天渔家乐有专车接送，还有家有面包，皮卡，轿车，可自行驾车游览岛上风光，满足你的不同的需求。</p>\r\n<p>\r\n	　　海天渔家乐愿为来岛游客提供中意的吃住行购一条龙服务，让你踏上这个漂亮的海岛就会开始一段地地道道的渔家乐之旅。让来岛的顾客无后顾之忧。高高兴兴的游玩。正是这样热情周到的服务 ，许多顾客中意而归然后推荐亲朋与好友光顾这个朴实的渔家。</p>\r\n', '', 'admin', '', '1480174686', '1480174686', 'true', '', '长岛大钦岛海天渔家乐座落于大钦岛北村西海口码头，是一家集住宿，餐饮，旅游，为一体的综合性渔家乐，渔家乐建设在离海边10米处，依山傍海，海景房，在家就能够看到湛蓝大海', '农家院,标题,长岛,大钦,岛,海天,渔,家乐,座,', '196', '1480174620', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('40', '10', '农家院标题', '', '/storage/images/20220209/1-161126233R30-L.jpg', '', '<p>\r\n	长岛大钦岛海天渔家乐座落于大钦岛北村西海口码头，是一家集住宿，餐饮，旅游，为一体的综合性渔家乐，渔家乐建设在离海边10米处，依山傍海，海景房，在家就能够看到湛蓝大海，海上风光秀媚，蓝天，绿岛，碧海混为一体，鸟鸣，渔歌，涛声此起彼伏，奇石与浪花起舞，海鸥为渔夫伴行。</p>\r\n<p>\r\n	　　大钦岛海天渔家乐海产品资源丰富，老板娘做饭特别好吃，螃蟹，片口鱼，老板鱼，黑鱼，安康鱼，扇贝，海胆，老板都不另外收费只要顾客有需求，全部海鲜，均能吃到，也可帮顾客代购。晚上渔家还提供了自助烧烤，这是渔家的一大优点 ，夜幕下，看着漂亮的大海，吃着烧烤的海鲜，喝点小酒，呵呵多么惬意的假期。</p>\r\n<p>\r\n	　　为游客提供了相当多旅游项目，诸如：唐王山，山神庙，龙王庙，妈祖庙参观拜庙，驾船环岛游、深海浅海垂钓、鹅卵石采集、也能够乘车游览全岛风光，还有，自我家有海区，可赶海，游泳，</p>\r\n<p>\r\n	　　渔家客房设有标准间、双人间、三人间、四人间等，设有独立卫生间浴室，客房干净、卫生保证你住得舒心，吃得中意、玩的开心，真正体会渔家风情。海天渔家乐有专车接送，还有家有面包，皮卡，轿车，可自行驾车游览岛上风光，满足你的不同的需求。</p>\r\n<p>\r\n	　　海天渔家乐愿为来岛游客提供中意的吃住行购一条龙服务，让你踏上这个漂亮的海岛就会开始一段地地道道的渔家乐之旅。让来岛的顾客无后顾之忧。高高兴兴的游玩。正是这样热情周到的服务 ，许多顾客中意而归然后推荐亲朋与好友光顾这个朴实的渔家。</p>\r\n', '', 'admin', '', '1480174712', '1480174712', 'true', '', '长岛大钦岛海天渔家乐座落于大钦岛北村西海口码头，是一家集住宿，餐饮，旅游，为一体的综合性渔家乐，渔家乐建设在离海边10米处，依山傍海，海景房，在家就能够看到湛蓝大海', '农家院,标题,长岛,大钦,岛,海天,渔,家乐,座,', '159', '1480174696', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('41', '10', '农家院标题', '', '/storage/images/20220209/1-161126233F70-L.jpg', '', '<p>\r\n	　长岛大钦岛海天渔家乐座落于大钦岛北村西海口码头，是一家集住宿，餐饮，旅游，为一体的综合性渔家乐，渔家乐建设在离海边10米处，依山傍海，海景房，在家就能够看到湛蓝大海，海上风光秀媚，蓝天，绿岛，碧海混为一体，鸟鸣，渔歌，涛声此起彼伏，奇石与浪花起舞，海鸥为渔夫伴行。</p>\r\n<p>\r\n	　　大钦岛海天渔家乐海产品资源丰富，老板娘做饭特别好吃，螃蟹，片口鱼，老板鱼，黑鱼，安康鱼，扇贝，海胆，老板都不另外收费只要顾客有需求，全部海鲜，均能吃到，也可帮顾客代购。晚上渔家还提供了自助烧烤，这是渔家的一大优点 ，夜幕下，看着漂亮的大海，吃着烧烤的海鲜，喝点小酒，呵呵多么惬意的假期。</p>\r\n<p>\r\n	　　为游客提供了相当多旅游项目，诸如：唐王山，山神庙，龙王庙，妈祖庙参观拜庙，驾船环岛游、深海浅海垂钓、鹅卵石采集、也能够乘车游览全岛风光，还有，自我家有海区，可赶海，游泳，</p>\r\n<p>\r\n	　　渔家客房设有标准间、双人间、三人间、四人间等，设有独立卫生间浴室，客房干净、卫生保证你住得舒心，吃得中意、玩的开心，真正体会渔家风情。海天渔家乐有专车接送，还有家有面包，皮卡，轿车，可自行驾车游览岛上风光，满足你的不同的需求。</p>\r\n<p>\r\n	　　海天渔家乐愿为来岛游客提供中意的吃住行购一条龙服务，让你踏上这个漂亮的海岛就会开始一段地地道道的渔家乐之旅。让来岛的顾客无后顾之忧。高高兴兴的游玩。正是这样热情周到的服务 ，许多顾客中意而归然后推荐亲朋与好友光顾这个朴实的渔家。</p>\r\n', '', 'admin', '', '1480174686', '1480174686', 'true', '', '长岛大钦岛海天渔家乐座落于大钦岛北村西海口码头，是一家集住宿，餐饮，旅游，为一体的综合性渔家乐，渔家乐建设在离海边10米处，依山傍海，海景房，在家就能够看到湛蓝大海', '农家院,标题,长岛,大钦,岛,海天,渔,家乐,座,', '196', '1480174620', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('42', '10', '农家院标题', '', '/storage/images/20220209/1-161126233R30-L.jpg', '', '<p>\r\n	长岛大钦岛海天渔家乐座落于大钦岛北村西海口码头，是一家集住宿，餐饮，旅游，为一体的综合性渔家乐，渔家乐建设在离海边10米处，依山傍海，海景房，在家就能够看到湛蓝大海，海上风光秀媚，蓝天，绿岛，碧海混为一体，鸟鸣，渔歌，涛声此起彼伏，奇石与浪花起舞，海鸥为渔夫伴行。</p>\r\n<p>\r\n	　　大钦岛海天渔家乐海产品资源丰富，老板娘做饭特别好吃，螃蟹，片口鱼，老板鱼，黑鱼，安康鱼，扇贝，海胆，老板都不另外收费只要顾客有需求，全部海鲜，均能吃到，也可帮顾客代购。晚上渔家还提供了自助烧烤，这是渔家的一大优点 ，夜幕下，看着漂亮的大海，吃着烧烤的海鲜，喝点小酒，呵呵多么惬意的假期。</p>\r\n<p>\r\n	　　为游客提供了相当多旅游项目，诸如：唐王山，山神庙，龙王庙，妈祖庙参观拜庙，驾船环岛游、深海浅海垂钓、鹅卵石采集、也能够乘车游览全岛风光，还有，自我家有海区，可赶海，游泳，</p>\r\n<p>\r\n	　　渔家客房设有标准间、双人间、三人间、四人间等，设有独立卫生间浴室，客房干净、卫生保证你住得舒心，吃得中意、玩的开心，真正体会渔家风情。海天渔家乐有专车接送，还有家有面包，皮卡，轿车，可自行驾车游览岛上风光，满足你的不同的需求。</p>\r\n<p>\r\n	　　海天渔家乐愿为来岛游客提供中意的吃住行购一条龙服务，让你踏上这个漂亮的海岛就会开始一段地地道道的渔家乐之旅。让来岛的顾客无后顾之忧。高高兴兴的游玩。正是这样热情周到的服务 ，许多顾客中意而归然后推荐亲朋与好友光顾这个朴实的渔家。</p>\r\n', '', 'admin', '', '1480174712', '1480174712', 'true', '', '长岛大钦岛海天渔家乐座落于大钦岛北村西海口码头，是一家集住宿，餐饮，旅游，为一体的综合性渔家乐，渔家乐建设在离海边10米处，依山傍海，海景房，在家就能够看到湛蓝大海', '农家院,标题,长岛,大钦,岛,海天,渔,家乐,座,', '159', '1480174696', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('43', '10', '农家院标题', '', '/storage/images/20220209/1-161126233F70-L.jpg', '', '<p>\r\n	　长岛大钦岛海天渔家乐座落于大钦岛北村西海口码头，是一家集住宿，餐饮，旅游，为一体的综合性渔家乐，渔家乐建设在离海边10米处，依山傍海，海景房，在家就能够看到湛蓝大海，海上风光秀媚，蓝天，绿岛，碧海混为一体，鸟鸣，渔歌，涛声此起彼伏，奇石与浪花起舞，海鸥为渔夫伴行。</p>\r\n<p>\r\n	　　大钦岛海天渔家乐海产品资源丰富，老板娘做饭特别好吃，螃蟹，片口鱼，老板鱼，黑鱼，安康鱼，扇贝，海胆，老板都不另外收费只要顾客有需求，全部海鲜，均能吃到，也可帮顾客代购。晚上渔家还提供了自助烧烤，这是渔家的一大优点 ，夜幕下，看着漂亮的大海，吃着烧烤的海鲜，喝点小酒，呵呵多么惬意的假期。</p>\r\n<p>\r\n	　　为游客提供了相当多旅游项目，诸如：唐王山，山神庙，龙王庙，妈祖庙参观拜庙，驾船环岛游、深海浅海垂钓、鹅卵石采集、也能够乘车游览全岛风光，还有，自我家有海区，可赶海，游泳，</p>\r\n<p>\r\n	　　渔家客房设有标准间、双人间、三人间、四人间等，设有独立卫生间浴室，客房干净、卫生保证你住得舒心，吃得中意、玩的开心，真正体会渔家风情。海天渔家乐有专车接送，还有家有面包，皮卡，轿车，可自行驾车游览岛上风光，满足你的不同的需求。</p>\r\n<p>\r\n	　　海天渔家乐愿为来岛游客提供中意的吃住行购一条龙服务，让你踏上这个漂亮的海岛就会开始一段地地道道的渔家乐之旅。让来岛的顾客无后顾之忧。高高兴兴的游玩。正是这样热情周到的服务 ，许多顾客中意而归然后推荐亲朋与好友光顾这个朴实的渔家。</p>\r\n', '', 'admin', '', '1480174686', '1480174686', 'true', '', '长岛大钦岛海天渔家乐座落于大钦岛北村西海口码头，是一家集住宿，餐饮，旅游，为一体的综合性渔家乐，渔家乐建设在离海边10米处，依山傍海，海景房，在家就能够看到湛蓝大海', '农家院,标题,长岛,大钦,岛,海天,渔,家乐,座,', '196', '1480174620', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('44', '10', '农家院标题', '', '/storage/images/20220209/1-161126233R30-L.jpg', '', '<p>\r\n	长岛大钦岛海天渔家乐座落于大钦岛北村西海口码头，是一家集住宿，餐饮，旅游，为一体的综合性渔家乐，渔家乐建设在离海边10米处，依山傍海，海景房，在家就能够看到湛蓝大海，海上风光秀媚，蓝天，绿岛，碧海混为一体，鸟鸣，渔歌，涛声此起彼伏，奇石与浪花起舞，海鸥为渔夫伴行。</p>\r\n<p>\r\n	　　大钦岛海天渔家乐海产品资源丰富，老板娘做饭特别好吃，螃蟹，片口鱼，老板鱼，黑鱼，安康鱼，扇贝，海胆，老板都不另外收费只要顾客有需求，全部海鲜，均能吃到，也可帮顾客代购。晚上渔家还提供了自助烧烤，这是渔家的一大优点 ，夜幕下，看着漂亮的大海，吃着烧烤的海鲜，喝点小酒，呵呵多么惬意的假期。</p>\r\n<p>\r\n	　　为游客提供了相当多旅游项目，诸如：唐王山，山神庙，龙王庙，妈祖庙参观拜庙，驾船环岛游、深海浅海垂钓、鹅卵石采集、也能够乘车游览全岛风光，还有，自我家有海区，可赶海，游泳，</p>\r\n<p>\r\n	　　渔家客房设有标准间、双人间、三人间、四人间等，设有独立卫生间浴室，客房干净、卫生保证你住得舒心，吃得中意、玩的开心，真正体会渔家风情。海天渔家乐有专车接送，还有家有面包，皮卡，轿车，可自行驾车游览岛上风光，满足你的不同的需求。</p>\r\n<p>\r\n	　　海天渔家乐愿为来岛游客提供中意的吃住行购一条龙服务，让你踏上这个漂亮的海岛就会开始一段地地道道的渔家乐之旅。让来岛的顾客无后顾之忧。高高兴兴的游玩。正是这样热情周到的服务 ，许多顾客中意而归然后推荐亲朋与好友光顾这个朴实的渔家。</p>\r\n', '', 'admin', '', '1480174712', '1480174712', 'true', '', '长岛大钦岛海天渔家乐座落于大钦岛北村西海口码头，是一家集住宿，餐饮，旅游，为一体的综合性渔家乐，渔家乐建设在离海边10米处，依山傍海，海景房，在家就能够看到湛蓝大海', '农家院,标题,长岛,大钦,岛,海天,渔,家乐,座,', '159', '1480174696', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('45', '10', '农家院标题', '', '/storage/images/20220209/1-161126233F70-L.jpg', '', '<p>\r\n	　长岛大钦岛海天渔家乐座落于大钦岛北村西海口码头，是一家集住宿，餐饮，旅游，为一体的综合性渔家乐，渔家乐建设在离海边10米处，依山傍海，海景房，在家就能够看到湛蓝大海，海上风光秀媚，蓝天，绿岛，碧海混为一体，鸟鸣，渔歌，涛声此起彼伏，奇石与浪花起舞，海鸥为渔夫伴行。</p>\r\n<p>\r\n	　　大钦岛海天渔家乐海产品资源丰富，老板娘做饭特别好吃，螃蟹，片口鱼，老板鱼，黑鱼，安康鱼，扇贝，海胆，老板都不另外收费只要顾客有需求，全部海鲜，均能吃到，也可帮顾客代购。晚上渔家还提供了自助烧烤，这是渔家的一大优点 ，夜幕下，看着漂亮的大海，吃着烧烤的海鲜，喝点小酒，呵呵多么惬意的假期。</p>\r\n<p>\r\n	　　为游客提供了相当多旅游项目，诸如：唐王山，山神庙，龙王庙，妈祖庙参观拜庙，驾船环岛游、深海浅海垂钓、鹅卵石采集、也能够乘车游览全岛风光，还有，自我家有海区，可赶海，游泳，</p>\r\n<p>\r\n	　　渔家客房设有标准间、双人间、三人间、四人间等，设有独立卫生间浴室，客房干净、卫生保证你住得舒心，吃得中意、玩的开心，真正体会渔家风情。海天渔家乐有专车接送，还有家有面包，皮卡，轿车，可自行驾车游览岛上风光，满足你的不同的需求。</p>\r\n<p>\r\n	　　海天渔家乐愿为来岛游客提供中意的吃住行购一条龙服务，让你踏上这个漂亮的海岛就会开始一段地地道道的渔家乐之旅。让来岛的顾客无后顾之忧。高高兴兴的游玩。正是这样热情周到的服务 ，许多顾客中意而归然后推荐亲朋与好友光顾这个朴实的渔家。</p>\r\n', '', 'admin', '', '1480174686', '1480174686', 'true', '', '长岛大钦岛海天渔家乐座落于大钦岛北村西海口码头，是一家集住宿，餐饮，旅游，为一体的综合性渔家乐，渔家乐建设在离海边10米处，依山傍海，海景房，在家就能够看到湛蓝大海', '农家院,标题,长岛,大钦,岛,海天,渔,家乐,座,', '196', '1480174620', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('46', '10', '农家院标题', '', '/storage/images/20220209/1-161126233R30-L.jpg', '', '<p>\r\n	长岛大钦岛海天渔家乐座落于大钦岛北村西海口码头，是一家集住宿，餐饮，旅游，为一体的综合性渔家乐，渔家乐建设在离海边10米处，依山傍海，海景房，在家就能够看到湛蓝大海，海上风光秀媚，蓝天，绿岛，碧海混为一体，鸟鸣，渔歌，涛声此起彼伏，奇石与浪花起舞，海鸥为渔夫伴行。</p>\r\n<p>\r\n	　　大钦岛海天渔家乐海产品资源丰富，老板娘做饭特别好吃，螃蟹，片口鱼，老板鱼，黑鱼，安康鱼，扇贝，海胆，老板都不另外收费只要顾客有需求，全部海鲜，均能吃到，也可帮顾客代购。晚上渔家还提供了自助烧烤，这是渔家的一大优点 ，夜幕下，看着漂亮的大海，吃着烧烤的海鲜，喝点小酒，呵呵多么惬意的假期。</p>\r\n<p>\r\n	　　为游客提供了相当多旅游项目，诸如：唐王山，山神庙，龙王庙，妈祖庙参观拜庙，驾船环岛游、深海浅海垂钓、鹅卵石采集、也能够乘车游览全岛风光，还有，自我家有海区，可赶海，游泳，</p>\r\n<p>\r\n	　　渔家客房设有标准间、双人间、三人间、四人间等，设有独立卫生间浴室，客房干净、卫生保证你住得舒心，吃得中意、玩的开心，真正体会渔家风情。海天渔家乐有专车接送，还有家有面包，皮卡，轿车，可自行驾车游览岛上风光，满足你的不同的需求。</p>\r\n<p>\r\n	　　海天渔家乐愿为来岛游客提供中意的吃住行购一条龙服务，让你踏上这个漂亮的海岛就会开始一段地地道道的渔家乐之旅。让来岛的顾客无后顾之忧。高高兴兴的游玩。正是这样热情周到的服务 ，许多顾客中意而归然后推荐亲朋与好友光顾这个朴实的渔家。</p>\r\n', '', 'admin', '', '1480174712', '1480174712', 'true', '', '长岛大钦岛海天渔家乐座落于大钦岛北村西海口码头，是一家集住宿，餐饮，旅游，为一体的综合性渔家乐，渔家乐建设在离海边10米处，依山傍海，海景房，在家就能够看到湛蓝大海', '农家院,标题,长岛,大钦,岛,海天,渔,家乐,座,', '159', '1480174696', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('47', '10', '农家院标题', '', '/storage/images/20220209/1-161126233F70-L.jpg', '', '<p>\r\n	　长岛大钦岛海天渔家乐座落于大钦岛北村西海口码头，是一家集住宿，餐饮，旅游，为一体的综合性渔家乐，渔家乐建设在离海边10米处，依山傍海，海景房，在家就能够看到湛蓝大海，海上风光秀媚，蓝天，绿岛，碧海混为一体，鸟鸣，渔歌，涛声此起彼伏，奇石与浪花起舞，海鸥为渔夫伴行。</p>\r\n<p>\r\n	　　大钦岛海天渔家乐海产品资源丰富，老板娘做饭特别好吃，螃蟹，片口鱼，老板鱼，黑鱼，安康鱼，扇贝，海胆，老板都不另外收费只要顾客有需求，全部海鲜，均能吃到，也可帮顾客代购。晚上渔家还提供了自助烧烤，这是渔家的一大优点 ，夜幕下，看着漂亮的大海，吃着烧烤的海鲜，喝点小酒，呵呵多么惬意的假期。</p>\r\n<p>\r\n	　　为游客提供了相当多旅游项目，诸如：唐王山，山神庙，龙王庙，妈祖庙参观拜庙，驾船环岛游、深海浅海垂钓、鹅卵石采集、也能够乘车游览全岛风光，还有，自我家有海区，可赶海，游泳，</p>\r\n<p>\r\n	　　渔家客房设有标准间、双人间、三人间、四人间等，设有独立卫生间浴室，客房干净、卫生保证你住得舒心，吃得中意、玩的开心，真正体会渔家风情。海天渔家乐有专车接送，还有家有面包，皮卡，轿车，可自行驾车游览岛上风光，满足你的不同的需求。</p>\r\n<p>\r\n	　　海天渔家乐愿为来岛游客提供中意的吃住行购一条龙服务，让你踏上这个漂亮的海岛就会开始一段地地道道的渔家乐之旅。让来岛的顾客无后顾之忧。高高兴兴的游玩。正是这样热情周到的服务 ，许多顾客中意而归然后推荐亲朋与好友光顾这个朴实的渔家。</p>\r\n', '', 'admin', '', '1480174686', '1480174686', 'true', '', '长岛大钦岛海天渔家乐座落于大钦岛北村西海口码头，是一家集住宿，餐饮，旅游，为一体的综合性渔家乐，渔家乐建设在离海边10米处，依山傍海，海景房，在家就能够看到湛蓝大海', '农家院,标题,长岛,大钦,岛,海天,渔,家乐,座,', '196', '1480174620', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('48', '10', '农家院标题', '', '/storage/images/20220209/1-161126233R30-L.jpg', '', '<p>\r\n	长岛大钦岛海天渔家乐座落于大钦岛北村西海口码头，是一家集住宿，餐饮，旅游，为一体的综合性渔家乐，渔家乐建设在离海边10米处，依山傍海，海景房，在家就能够看到湛蓝大海，海上风光秀媚，蓝天，绿岛，碧海混为一体，鸟鸣，渔歌，涛声此起彼伏，奇石与浪花起舞，海鸥为渔夫伴行。</p>\r\n<p>\r\n	　　大钦岛海天渔家乐海产品资源丰富，老板娘做饭特别好吃，螃蟹，片口鱼，老板鱼，黑鱼，安康鱼，扇贝，海胆，老板都不另外收费只要顾客有需求，全部海鲜，均能吃到，也可帮顾客代购。晚上渔家还提供了自助烧烤，这是渔家的一大优点 ，夜幕下，看着漂亮的大海，吃着烧烤的海鲜，喝点小酒，呵呵多么惬意的假期。</p>\r\n<p>\r\n	　　为游客提供了相当多旅游项目，诸如：唐王山，山神庙，龙王庙，妈祖庙参观拜庙，驾船环岛游、深海浅海垂钓、鹅卵石采集、也能够乘车游览全岛风光，还有，自我家有海区，可赶海，游泳，</p>\r\n<p>\r\n	　　渔家客房设有标准间、双人间、三人间、四人间等，设有独立卫生间浴室，客房干净、卫生保证你住得舒心，吃得中意、玩的开心，真正体会渔家风情。海天渔家乐有专车接送，还有家有面包，皮卡，轿车，可自行驾车游览岛上风光，满足你的不同的需求。</p>\r\n<p>\r\n	　　海天渔家乐愿为来岛游客提供中意的吃住行购一条龙服务，让你踏上这个漂亮的海岛就会开始一段地地道道的渔家乐之旅。让来岛的顾客无后顾之忧。高高兴兴的游玩。正是这样热情周到的服务 ，许多顾客中意而归然后推荐亲朋与好友光顾这个朴实的渔家。</p>\r\n', '', 'admin', '', '1480174712', '1480174712', 'true', '', '长岛大钦岛海天渔家乐座落于大钦岛北村西海口码头，是一家集住宿，餐饮，旅游，为一体的综合性渔家乐，渔家乐建设在离海边10米处，依山傍海，海景房，在家就能够看到湛蓝大海', '农家院,标题,长岛,大钦,岛,海天,渔,家乐,座,', '159', '1480174696', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('49', '8', '成功案例', '', '/storage/images/20220209/1-160FQ64Q5537.jpg', '', '<div style=\"text-align: center;\">\r\n	<img src=\"/storage/images/20220209/1331134F0-0.jpg\" /></div>\r\n', '', 'admin', '', '1466832673', '1466832673', 'true', '', '', '成功案例,', '122', '1467967691', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('50', '8', '成功案例', '', '/storage/images/20220209/1-160FQ64P02X.jpg', '', '<div style=\"text-align: center;\">\r\n	<img src=\"/storage/images/20220209/13312a133-0.jpg\" style=\"margin: 0px auto; padding: 0px; border: 0px; max-width: 100%; color: rgb(75, 75, 75); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: center;\" /></div>\r\n', '', 'admin', '', '1466832689', '1466832689', 'true', '', '', '成功案例,', '108', '1467967676', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('51', '8', '成功案例', '', '/storage/images/20220209/1-160FQ64Q5537.jpg', '', '<div style=\"text-align: center;\">\r\n	<img src=\"/storage/images/20220209/1331134F0-0.jpg\" /></div>\r\n', '', 'admin', '', '1466832673', '1466832673', 'true', '', '', '成功案例,', '122', '1467967691', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('52', '8', '成功案例', '', '/storage/images/20220209/1-160FQ64P02X.jpg', '', '<div style=\"text-align: center;\">\r\n	<img src=\"/storage/images/20220209/13312a133-0.jpg\" style=\"margin: 0px auto; padding: 0px; border: 0px; max-width: 100%; color: rgb(75, 75, 75); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: center;\" /></div>\r\n', '', 'admin', '', '1466832689', '1466832689', 'true', '', '', '成功案例,', '108', '1467967676', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('53', '8', '成功案例', '', '/storage/images/20220209/1-160FQ64Q5537.jpg', '', '<div style=\"text-align: center;\">\r\n	<img src=\"/storage/images/20220209/1331134F0-0.jpg\" /></div>\r\n', '', 'admin', '', '1466832673', '1466832673', 'true', '', '', '成功案例,', '122', '1467967691', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('54', '8', '成功案例', '', '/storage/images/20220209/1-160FQ64P02X.jpg', '', '<div style=\"text-align: center;\">\r\n	<img src=\"/storage/images/20220209/13312a133-0.jpg\" style=\"margin: 0px auto; padding: 0px; border: 0px; max-width: 100%; color: rgb(75, 75, 75); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: center;\" /></div>\r\n', '', 'admin', '', '1466832689', '1466832689', 'true', '', '', '成功案例,', '108', '1467967676', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('55', '8', '成功案例', '', '/storage/images/20220209/1-160FQ64Q5537.jpg', '', '<div style=\"text-align: center;\">\r\n	<img src=\"/storage/images/20220209/1331134F0-0.jpg\" /></div>\r\n', '', 'admin', '', '1466832673', '1466832673', 'true', '', '', '成功案例,', '122', '1467967691', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('56', '8', '成功案例', '', '/storage/images/20220209/1-160FQ64P02X.jpg', '', '<div style=\"text-align: center;\">\r\n	<img src=\"/storage/images/20220209/13312a133-0.jpg\" style=\"margin: 0px auto; padding: 0px; border: 0px; max-width: 100%; color: rgb(75, 75, 75); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: center;\" /></div>\r\n', '', 'admin', '', '1466832689', '1466832689', 'true', '', '', '成功案例,', '108', '1467967676', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('57', '8', '成功案例', '', '/storage/images/20220209/1-160FQ64Q5537.jpg', '', '<div style=\"text-align: center;\">\r\n	<img src=\"/storage/images/20220209/1331134F0-0.jpg\" /></div>\r\n', '', 'admin', '', '1466832673', '1466832673', 'true', '', '', '成功案例,', '122', '1467967691', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('58', '8', '成功案例', '', '/storage/images/20220209/1-160FQ64P02X.jpg', '', '<div style=\"text-align: center;\">\r\n	<img src=\"/storage/images/20220209/13312a133-0.jpg\" style=\"margin: 0px auto; padding: 0px; border: 0px; max-width: 100%; color: rgb(75, 75, 75); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: center;\" /></div>\r\n', '', 'admin', '', '1466832689', '1466832689', 'true', '', '', '成功案例,', '108', '1467967676', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('59', '8', '成功案例', '', '/storage/images/20220209/1-160FQ64Q5537.jpg', '', '<div style=\"text-align: center;\">\r\n	<img src=\"/storage/images/20220209/1331134F0-0.jpg\" /></div>\r\n', '', 'admin', '', '1466832673', '1466832673', 'true', '', '', '成功案例,', '122', '1467967691', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('60', '8', '成功案例', '', '/storage/images/20220209/1-160FQ64P02X.jpg', '', '<div style=\"text-align: center;\">\r\n	<img src=\"/storage/images/20220209/13312a133-0.jpg\" style=\"margin: 0px auto; padding: 0px; border: 0px; max-width: 100%; color: rgb(75, 75, 75); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: center;\" /></div>\r\n', '', 'admin', '', '1466832689', '1466832689', 'true', '', '', '成功案例,', '108', '1467967676', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('61', '28', '农家乐的采摘可以启蒙孩子的劳动意识', '', '/storage/images/20220209/1-160FQ64532221.jpg', '', '<p>\r\n	孩子已经成为一个家庭的最重要的成员，孩子总是的到所有人的疼爱，但是现在很多小孩不懂得分享，甚至很多孩子总是沉浸在电子产品中，很少去融入于自然。</p>\r\n<p>\r\n	&nbsp; &nbsp; &nbsp;如果你作为家长不知道该带你孩子去哪里玩，不如就听听深圳农家乐的建议，带上您孩子去采摘园吧，在采摘园里孩子可以与自然接触，尽情的享受阳光的沐浴，并且孩子可以与父母共同采摘瓜果，这不但有利于家庭关系的和睦，更有利于让孩子通过自己的劳动，在采摘园内可以采摘到自己想要采摘的东西，孩子们可以在玩耍中增长知识，增加童年乐趣，在活动中得到收获。</p>\r\n', '', 'admin', '', '1480174879', '1480174879', 'true', '', '孩子已经成为一个家庭的最重要的成员，孩子总是的到所有人的疼爱，但是现在很多小孩不懂得分享，甚至很多孩子总是沉浸在电子产品中，很少去融入于自然。 如果你作为家长不知道', '农家,乐的,采摘,可以,启蒙,孩子,的,劳动,意识,', '188', '1480174865', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('62', '28', '深圳农家乐游玩卡丁车攻略', '', '/storage/images/20220209/2341463149-0-lp.jpg', '', '<p>\r\n	1.上车前，佩戴好头盔，手套这些基本安全装备。<br />\r\n	2.左侧上车，左脚先踏入左侧车身，右脚跟进。<br />\r\n	3.身体前倾，双手握住方向盘上方，以保持身体重心。<br />\r\n	4.双腿伸直成自然弯曲，同时双脚踏入两边的踏板。<br />\r\n	5.左脚位置刹车踏板，右脚位置油门踏板，不要弄混乱了喔。<br />\r\n	6.在坐车进车内后，赛道的工作人员会帮你系好安全带<br />\r\n	7.卡丁车握方向盘的最佳位置是9点和3点的位置<br />\r\n	8.下车时双手握住方向盘上方，将身体拉起。<br />\r\n	9.入弯前贴近赛道外侧，同时刹车减速，保持直线行驶最北入弯。<br />\r\n	10.入弯时减速到合适的速度，然后松开油门过弯<br />\r\n	11.弯中不要加油，避免是去平衡，影响出弯和过弯速度。<br />\r\n	12.油门和刹车的配合很重要，经常驾驶才能积攒经验。<br />\r\n	13.驾驶中一定要保持高度的精神集中</p>\r\n<p>\r\n	<img alt=\"深圳农家乐摘菜\" src=\"/storage/images/20220209/2341463149-0.jpg\" /></p>\r\n', '', 'admin', '', '1480174906', '1480174906', 'true', '', '1.上车前，佩戴好头盔，手套这些基本安全装备。 2.左侧上车，左脚先踏入左侧车身，右脚跟进。 3.身体前倾，双手握住方向盘上方，以保持身体重心。 4.双腿伸直成自然弯曲，同时双', '深圳,农家乐,游玩,卡丁车,攻略,上,车前,佩,', '178', '1480174890', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('63', '28', '农家乐的采摘可以启蒙孩子的劳动意识', '', '/storage/images/20220209/1-160FQ64532221.jpg', '', '<p>\r\n	孩子已经成为一个家庭的最重要的成员，孩子总是的到所有人的疼爱，但是现在很多小孩不懂得分享，甚至很多孩子总是沉浸在电子产品中，很少去融入于自然。</p>\r\n<p>\r\n	&nbsp; &nbsp; &nbsp;如果你作为家长不知道该带你孩子去哪里玩，不如就听听深圳农家乐的建议，带上您孩子去采摘园吧，在采摘园里孩子可以与自然接触，尽情的享受阳光的沐浴，并且孩子可以与父母共同采摘瓜果，这不但有利于家庭关系的和睦，更有利于让孩子通过自己的劳动，在采摘园内可以采摘到自己想要采摘的东西，孩子们可以在玩耍中增长知识，增加童年乐趣，在活动中得到收获。</p>\r\n', '', 'admin', '', '1480174879', '1480174879', 'true', '', '孩子已经成为一个家庭的最重要的成员，孩子总是的到所有人的疼爱，但是现在很多小孩不懂得分享，甚至很多孩子总是沉浸在电子产品中，很少去融入于自然。 如果你作为家长不知道', '农家,乐的,采摘,可以,启蒙,孩子,的,劳动,意识,', '188', '1480174865', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('64', '28', '深圳农家乐游玩卡丁车攻略', '', '/storage/images/20220209/2341463149-0-lp.jpg', '', '<p>\r\n	1.上车前，佩戴好头盔，手套这些基本安全装备。<br />\r\n	2.左侧上车，左脚先踏入左侧车身，右脚跟进。<br />\r\n	3.身体前倾，双手握住方向盘上方，以保持身体重心。<br />\r\n	4.双腿伸直成自然弯曲，同时双脚踏入两边的踏板。<br />\r\n	5.左脚位置刹车踏板，右脚位置油门踏板，不要弄混乱了喔。<br />\r\n	6.在坐车进车内后，赛道的工作人员会帮你系好安全带<br />\r\n	7.卡丁车握方向盘的最佳位置是9点和3点的位置<br />\r\n	8.下车时双手握住方向盘上方，将身体拉起。<br />\r\n	9.入弯前贴近赛道外侧，同时刹车减速，保持直线行驶最北入弯。<br />\r\n	10.入弯时减速到合适的速度，然后松开油门过弯<br />\r\n	11.弯中不要加油，避免是去平衡，影响出弯和过弯速度。<br />\r\n	12.油门和刹车的配合很重要，经常驾驶才能积攒经验。<br />\r\n	13.驾驶中一定要保持高度的精神集中</p>\r\n<p>\r\n	<img alt=\"深圳农家乐摘菜\" src=\"/storage/images/20220209/2341463149-0.jpg\" /></p>\r\n', '', 'admin', '', '1480174906', '1480174906', 'true', '', '1.上车前，佩戴好头盔，手套这些基本安全装备。 2.左侧上车，左脚先踏入左侧车身，右脚跟进。 3.身体前倾，双手握住方向盘上方，以保持身体重心。 4.双腿伸直成自然弯曲，同时双', '深圳,农家乐,游玩,卡丁车,攻略,上,车前,佩,', '178', '1480174890', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('65', '28', '农家乐的采摘可以启蒙孩子的劳动意识', '', '/storage/images/20220209/1-160FQ64532221.jpg', '', '<p>\r\n	孩子已经成为一个家庭的最重要的成员，孩子总是的到所有人的疼爱，但是现在很多小孩不懂得分享，甚至很多孩子总是沉浸在电子产品中，很少去融入于自然。</p>\r\n<p>\r\n	&nbsp; &nbsp; &nbsp;如果你作为家长不知道该带你孩子去哪里玩，不如就听听深圳农家乐的建议，带上您孩子去采摘园吧，在采摘园里孩子可以与自然接触，尽情的享受阳光的沐浴，并且孩子可以与父母共同采摘瓜果，这不但有利于家庭关系的和睦，更有利于让孩子通过自己的劳动，在采摘园内可以采摘到自己想要采摘的东西，孩子们可以在玩耍中增长知识，增加童年乐趣，在活动中得到收获。</p>\r\n', '', 'admin', '', '1480174879', '1480174879', 'true', '', '孩子已经成为一个家庭的最重要的成员，孩子总是的到所有人的疼爱，但是现在很多小孩不懂得分享，甚至很多孩子总是沉浸在电子产品中，很少去融入于自然。 如果你作为家长不知道', '农家,乐的,采摘,可以,启蒙,孩子,的,劳动,意识,', '188', '1480174865', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('66', '28', '深圳农家乐游玩卡丁车攻略', '', '/storage/images/20220209/2341463149-0-lp.jpg', '', '<p>\r\n	1.上车前，佩戴好头盔，手套这些基本安全装备。<br />\r\n	2.左侧上车，左脚先踏入左侧车身，右脚跟进。<br />\r\n	3.身体前倾，双手握住方向盘上方，以保持身体重心。<br />\r\n	4.双腿伸直成自然弯曲，同时双脚踏入两边的踏板。<br />\r\n	5.左脚位置刹车踏板，右脚位置油门踏板，不要弄混乱了喔。<br />\r\n	6.在坐车进车内后，赛道的工作人员会帮你系好安全带<br />\r\n	7.卡丁车握方向盘的最佳位置是9点和3点的位置<br />\r\n	8.下车时双手握住方向盘上方，将身体拉起。<br />\r\n	9.入弯前贴近赛道外侧，同时刹车减速，保持直线行驶最北入弯。<br />\r\n	10.入弯时减速到合适的速度，然后松开油门过弯<br />\r\n	11.弯中不要加油，避免是去平衡，影响出弯和过弯速度。<br />\r\n	12.油门和刹车的配合很重要，经常驾驶才能积攒经验。<br />\r\n	13.驾驶中一定要保持高度的精神集中</p>\r\n<p>\r\n	<img alt=\"深圳农家乐摘菜\" src=\"/storage/images/20220209/2341463149-0.jpg\" /></p>\r\n', '', 'admin', '', '1480174906', '1480174906', 'true', '', '1.上车前，佩戴好头盔，手套这些基本安全装备。 2.左侧上车，左脚先踏入左侧车身，右脚跟进。 3.身体前倾，双手握住方向盘上方，以保持身体重心。 4.双腿伸直成自然弯曲，同时双', '深圳,农家乐,游玩,卡丁车,攻略,上,车前,佩,', '178', '1480174890', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('67', '28', '农家乐的采摘可以启蒙孩子的劳动意识', '', '/storage/images/20220209/1-160FQ64532221.jpg', '', '<p>\r\n	孩子已经成为一个家庭的最重要的成员，孩子总是的到所有人的疼爱，但是现在很多小孩不懂得分享，甚至很多孩子总是沉浸在电子产品中，很少去融入于自然。</p>\r\n<p>\r\n	&nbsp; &nbsp; &nbsp;如果你作为家长不知道该带你孩子去哪里玩，不如就听听深圳农家乐的建议，带上您孩子去采摘园吧，在采摘园里孩子可以与自然接触，尽情的享受阳光的沐浴，并且孩子可以与父母共同采摘瓜果，这不但有利于家庭关系的和睦，更有利于让孩子通过自己的劳动，在采摘园内可以采摘到自己想要采摘的东西，孩子们可以在玩耍中增长知识，增加童年乐趣，在活动中得到收获。</p>\r\n', '', 'admin', '', '1480174879', '1480174879', 'true', '', '孩子已经成为一个家庭的最重要的成员，孩子总是的到所有人的疼爱，但是现在很多小孩不懂得分享，甚至很多孩子总是沉浸在电子产品中，很少去融入于自然。 如果你作为家长不知道', '农家,乐的,采摘,可以,启蒙,孩子,的,劳动,意识,', '188', '1480174865', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('68', '28', '深圳农家乐游玩卡丁车攻略', '', '/storage/images/20220209/2341463149-0-lp.jpg', '', '<p>\r\n	1.上车前，佩戴好头盔，手套这些基本安全装备。<br />\r\n	2.左侧上车，左脚先踏入左侧车身，右脚跟进。<br />\r\n	3.身体前倾，双手握住方向盘上方，以保持身体重心。<br />\r\n	4.双腿伸直成自然弯曲，同时双脚踏入两边的踏板。<br />\r\n	5.左脚位置刹车踏板，右脚位置油门踏板，不要弄混乱了喔。<br />\r\n	6.在坐车进车内后，赛道的工作人员会帮你系好安全带<br />\r\n	7.卡丁车握方向盘的最佳位置是9点和3点的位置<br />\r\n	8.下车时双手握住方向盘上方，将身体拉起。<br />\r\n	9.入弯前贴近赛道外侧，同时刹车减速，保持直线行驶最北入弯。<br />\r\n	10.入弯时减速到合适的速度，然后松开油门过弯<br />\r\n	11.弯中不要加油，避免是去平衡，影响出弯和过弯速度。<br />\r\n	12.油门和刹车的配合很重要，经常驾驶才能积攒经验。<br />\r\n	13.驾驶中一定要保持高度的精神集中</p>\r\n<p>\r\n	<img alt=\"深圳农家乐摘菜\" src=\"/storage/images/20220209/2341463149-0.jpg\" /></p>\r\n', '', 'admin', '', '1480174906', '1480174906', 'true', '', '1.上车前，佩戴好头盔，手套这些基本安全装备。 2.左侧上车，左脚先踏入左侧车身，右脚跟进。 3.身体前倾，双手握住方向盘上方，以保持身体重心。 4.双腿伸直成自然弯曲，同时双', '深圳,农家乐,游玩,卡丁车,攻略,上,车前,佩,', '178', '1480174890', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('69', '28', '农家乐的采摘可以启蒙孩子的劳动意识', '', '/storage/images/20220209/1-160FQ64532221.jpg', '', '<p>\r\n	孩子已经成为一个家庭的最重要的成员，孩子总是的到所有人的疼爱，但是现在很多小孩不懂得分享，甚至很多孩子总是沉浸在电子产品中，很少去融入于自然。</p>\r\n<p>\r\n	&nbsp; &nbsp; &nbsp;如果你作为家长不知道该带你孩子去哪里玩，不如就听听深圳农家乐的建议，带上您孩子去采摘园吧，在采摘园里孩子可以与自然接触，尽情的享受阳光的沐浴，并且孩子可以与父母共同采摘瓜果，这不但有利于家庭关系的和睦，更有利于让孩子通过自己的劳动，在采摘园内可以采摘到自己想要采摘的东西，孩子们可以在玩耍中增长知识，增加童年乐趣，在活动中得到收获。</p>\r\n', '', 'admin', '', '1480174879', '1480174879', 'true', '', '孩子已经成为一个家庭的最重要的成员，孩子总是的到所有人的疼爱，但是现在很多小孩不懂得分享，甚至很多孩子总是沉浸在电子产品中，很少去融入于自然。 如果你作为家长不知道', '农家,乐的,采摘,可以,启蒙,孩子,的,劳动,意识,', '188', '1480174865', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('70', '28', '深圳农家乐游玩卡丁车攻略', '', '/storage/images/20220209/2341463149-0-lp.jpg', '', '<p>\r\n	1.上车前，佩戴好头盔，手套这些基本安全装备。<br />\r\n	2.左侧上车，左脚先踏入左侧车身，右脚跟进。<br />\r\n	3.身体前倾，双手握住方向盘上方，以保持身体重心。<br />\r\n	4.双腿伸直成自然弯曲，同时双脚踏入两边的踏板。<br />\r\n	5.左脚位置刹车踏板，右脚位置油门踏板，不要弄混乱了喔。<br />\r\n	6.在坐车进车内后，赛道的工作人员会帮你系好安全带<br />\r\n	7.卡丁车握方向盘的最佳位置是9点和3点的位置<br />\r\n	8.下车时双手握住方向盘上方，将身体拉起。<br />\r\n	9.入弯前贴近赛道外侧，同时刹车减速，保持直线行驶最北入弯。<br />\r\n	10.入弯时减速到合适的速度，然后松开油门过弯<br />\r\n	11.弯中不要加油，避免是去平衡，影响出弯和过弯速度。<br />\r\n	12.油门和刹车的配合很重要，经常驾驶才能积攒经验。<br />\r\n	13.驾驶中一定要保持高度的精神集中</p>\r\n<p>\r\n	<img alt=\"深圳农家乐摘菜\" src=\"/storage/images/20220209/2341463149-0.jpg\" /></p>\r\n', '', 'admin', '', '1480174906', '1480174906', 'true', '', '1.上车前，佩戴好头盔，手套这些基本安全装备。 2.左侧上车，左脚先踏入左侧车身，右脚跟进。 3.身体前倾，双手握住方向盘上方，以保持身体重心。 4.双腿伸直成自然弯曲，同时双', '深圳,农家乐,游玩,卡丁车,攻略,上,车前,佩,', '178', '1480174890', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('71', '28', '农家乐的采摘可以启蒙孩子的劳动意识', '', '/storage/images/20220209/1-160FQ64532221.jpg', '', '<p>\r\n	孩子已经成为一个家庭的最重要的成员，孩子总是的到所有人的疼爱，但是现在很多小孩不懂得分享，甚至很多孩子总是沉浸在电子产品中，很少去融入于自然。</p>\r\n<p>\r\n	&nbsp; &nbsp; &nbsp;如果你作为家长不知道该带你孩子去哪里玩，不如就听听深圳农家乐的建议，带上您孩子去采摘园吧，在采摘园里孩子可以与自然接触，尽情的享受阳光的沐浴，并且孩子可以与父母共同采摘瓜果，这不但有利于家庭关系的和睦，更有利于让孩子通过自己的劳动，在采摘园内可以采摘到自己想要采摘的东西，孩子们可以在玩耍中增长知识，增加童年乐趣，在活动中得到收获。</p>\r\n', '', 'admin', '', '1480174879', '1480174879', 'true', '', '孩子已经成为一个家庭的最重要的成员，孩子总是的到所有人的疼爱，但是现在很多小孩不懂得分享，甚至很多孩子总是沉浸在电子产品中，很少去融入于自然。 如果你作为家长不知道', '农家,乐的,采摘,可以,启蒙,孩子,的,劳动,意识,', '188', '1480174865', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('72', '28', '深圳农家乐游玩卡丁车攻略', '', '/storage/images/20220209/2341463149-0-lp.jpg', '', '<p>\r\n	1.上车前，佩戴好头盔，手套这些基本安全装备。<br />\r\n	2.左侧上车，左脚先踏入左侧车身，右脚跟进。<br />\r\n	3.身体前倾，双手握住方向盘上方，以保持身体重心。<br />\r\n	4.双腿伸直成自然弯曲，同时双脚踏入两边的踏板。<br />\r\n	5.左脚位置刹车踏板，右脚位置油门踏板，不要弄混乱了喔。<br />\r\n	6.在坐车进车内后，赛道的工作人员会帮你系好安全带<br />\r\n	7.卡丁车握方向盘的最佳位置是9点和3点的位置<br />\r\n	8.下车时双手握住方向盘上方，将身体拉起。<br />\r\n	9.入弯前贴近赛道外侧，同时刹车减速，保持直线行驶最北入弯。<br />\r\n	10.入弯时减速到合适的速度，然后松开油门过弯<br />\r\n	11.弯中不要加油，避免是去平衡，影响出弯和过弯速度。<br />\r\n	12.油门和刹车的配合很重要，经常驾驶才能积攒经验。<br />\r\n	13.驾驶中一定要保持高度的精神集中</p>\r\n<p>\r\n	<img alt=\"深圳农家乐摘菜\" src=\"/storage/images/20220209/2341463149-0.jpg\" /></p>\r\n', '', 'admin', '', '1480174906', '1480174906', 'true', '', '1.上车前，佩戴好头盔，手套这些基本安全装备。 2.左侧上车，左脚先踏入左侧车身，右脚跟进。 3.身体前倾，双手握住方向盘上方，以保持身体重心。 4.双腿伸直成自然弯曲，同时双', '深圳,农家乐,游玩,卡丁车,攻略,上,车前,佩,', '178', '1480174890', '0', '0', '0', '100', '未知', '', '');

-- ----------------------------
-- Table structure for `rrz_channelfield`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channelfield`;
CREATE TABLE `rrz_channelfield` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `channel_type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `title` varchar(32) NOT NULL DEFAULT '' COMMENT '字段标题',
  `dtype` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `define` text NOT NULL COMMENT '字段定义',
  `maxlength` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最大长度，文本数据必须填写，大于255为text类型',
  `dfvalue` longtext COMMENT '默认值',
  `dfvalue_unit` varchar(50) NOT NULL DEFAULT '' COMMENT '数值单位',
  `remark` varchar(256) NOT NULL DEFAULT '' COMMENT '提示说明',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `ifrequire` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否必填',
  `sort` int(5) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='自定义字段表';

-- -----------------------------
-- Records of `rrz_channelfield`
-- -----------------------------
INSERT INTO `rrz_channelfield` VALUES ('1', 'tb1_imgurls', '1', 'articles', '图片集合', 'imgs', 'text', '0', '', '', '', '0', '0', '100', '1644386286', '1644386286');

-- ----------------------------
-- Table structure for `rrz_channeltype`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channeltype`;
CREATE TABLE `rrz_channeltype` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='文章（产品）类型';

-- -----------------------------
-- Records of `rrz_channeltype`
-- -----------------------------
INSERT INTO `rrz_channeltype` VALUES ('1', '图片集', 'articles', '1644386286', '0');

-- ----------------------------
-- Table structure for `rrz_config`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_config`;
CREATE TABLE `rrz_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text COMMENT '配置内容',
  `type` varchar(64) DEFAULT '' COMMENT '类型',
  `desc` varchar(50) DEFAULT '' COMMENT '描述',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已删除（0：否，1：是）',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_name` (`name`) USING BTREE,
  KEY `idx_type` (`type`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='系统配置表';

-- -----------------------------
-- Records of `rrz_config`
-- -----------------------------
INSERT INTO `rrz_config` VALUES ('1', 'status', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('2', 'name', '某某网络科技有限公司', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('3', 'logo', '/storage/images/20220209/4180f60f90a3c16e7d938b5c9a03c26b.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('4', 'wap_logo', '/storage/images/20220209/35bb8a8c0189507766e0f22b2f6e55c8.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('5', 'favicon', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('6', 'copyright', 'Copyright © 2012-2018 某某公司 版权所有', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('7', 'recordnum', '琼ICP备xxxxxxxx号', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('8', 'title', '旅游住宿农家乐类人人站模板(带手机端)', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('9', 'keywords', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('10', 'description', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('11', 'is_authorization', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('12', 'authortoken_code', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('13', 'popup_upgrade', '0', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('14', 'wap_domain', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('15', 'is_https', '0', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('16', 'logo', '/static/images/logo.png', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('17', 'sqldatapath', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('18', 'expiretime', '3600', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('19', 'name', '广州某某公司', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('20', 'telephone', '400-123-4567', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('21', 'fax', '020-99999999', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('22', 'qq', '88888888', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('23', 'email', 'admin@youweb.com', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('24', 'addr', '广东省广州市天河区88号', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('25', 'coord', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('26', 'thirdcode_pc', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('27', 'thirdcode_wap', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('28', 'inlet', '0', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('29', 'auto', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('30', 'filter_isurl', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('31', 'type', 'xml', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('32', 'index_changefreq', 'always', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('33', 'list_changefreq', 'hourly', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('34', 'view_changefreq', 'daily', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('35', 'index_priority', '1.0', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('36', 'list_priority', '0.8', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('37', 'view_priority', '0.5', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('38', 'articles_num', '100', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('39', 'zzbaidutoken', '', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('40', 'app_map', 'admin', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('41', 'status', '1', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('42', 'replace', '国家级|国际级|世界级|宇宙级|千万级|百万级|星级|甲级|超甲级|完美|唯一|一流|精确|顶级|顶尖|尖端|最|国际级产品|填补国内空白|带头|首个|首次|首发|首款|首家|首选|品牌|正品|金牌|名牌|优秀|顶级|独家|唯独|独有|独创|独据|开发者|缔造者|创始|发明者|领先|领头|领导|领跑|领袖|领先|引领|创领|领航|权威|先进|耀领|缔造者|极品|极佳|顶级|尖端|顶尖|终极|绝佳|绝对|绝版|终极|极致|极具|王牌|冠军|第一|极致|永久|王牌|掌门人|领袖|独一无二|绝无仅有|前无古人|史无前例|万能|绝对|绝顶|大牌|精确|超赚|巨星|至尊|巅峰|之王|巨星|王者|冠军|资深|至尊|著名|奢侈|百分之百|国家级产品|国家免检|国家领导人|填补国内空白|史无前例|前无古人|永久|永远|万能|祖传|特效|无敌|纯天然|超赚|国际品质|专家推荐|超强|全面|全网|全球|随时结束|仅此一次|空前绝后|随时涨价|马上降价|最后一波|包治百病|药到病除|特供|专供|专家推荐|热销|畅销|全效|标杆|精确|优秀|仅此|遥遥|高档|真皮|超赚|精准|指定|精品|特供|专供|军方|军事|国旗|国徽|党旗|驰名|秒杀|一步到位|', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('43', 'connector_title', '_', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('44', 'list_title', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('45', 'view_title', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('46', 'mobile', '138-0000-0000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('47', 'wx', 'WX8888888', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('48', 'qrcode', 'http://g.kbscdn.cn/kbcms/Public/images/wxaqrrrz.png', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('49', 'nav_hide_suffix', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('50', 'url_level_dir', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('51', 'app_debug', '2', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('52', 'hide_plugin', '0', 'admin', '', 'cn', '0');

-- ----------------------------
-- Table structure for `rrz_form_data`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_form_data`;
CREATE TABLE `rrz_form_data` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `form_id` int(10) unsigned DEFAULT '0' COMMENT '表单ID',
  `form_name` varchar(255) DEFAULT '' COMMENT '表单名称',
  `content` longtext COMMENT '提交内容',
  `ip` varchar(255) DEFAULT '' COMMENT '提交人IP',
  `add_time` int(10) unsigned DEFAULT NULL COMMENT '提交时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_form_id` (`form_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_forms`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_forms`;
CREATE TABLE `rrz_forms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '表单名称',
  `config` longtext COMMENT '表单配置',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '创建时间',
  `is_del` tinyint(1) unsigned DEFAULT '0' COMMENT '删除(0=否，1=是)',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_is_del` (`is_del`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- -----------------------------
-- Records of `rrz_forms`
-- -----------------------------
INSERT INTO `rrz_forms` VALUES ('1', '在线留言', 'a:3:{i:0;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:6:\"姓名\";s:8:\"required\";s:1:\"1\";}i:1;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:12:\"手机号码\";s:8:\"required\";s:1:\"1\";}i:2;a:3:{s:4:\"type\";s:8:\"textarea\";s:4:\"name\";s:12:\"留言内容\";s:8:\"required\";s:1:\"1\";}}', '1644386307', '0');

-- ----------------------------
-- Table structure for `rrz_goods`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods`;
CREATE TABLE `rrz_goods` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '产品名称',
  `subtitle` varchar(255) DEFAULT '' COMMENT '副标题',
  `brief` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '商品简介',
  `cat_id` mediumint(8) unsigned DEFAULT NULL COMMENT '产品分类id',
  `brand_id` int(10) unsigned DEFAULT '0' COMMENT '产品品牌id',
  `def_img` varchar(500) DEFAULT '' COMMENT '产品默认图片路径',
  `imgs` longtext COMMENT '产品图片集合',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `del_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品划线价格',
  `store` int(8) unsigned DEFAULT '0' COMMENT '产品库存',
  `is_presell` enum('true','false') DEFAULT 'false' COMMENT '是否预售（是否定金付款）',
  `presell_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '预售价格（定金）',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '产品规格',
  `content` longtext COMMENT '产品详情',
  `wap_content` longtext COMMENT '手机端详情',
  `sales` int(11) unsigned DEFAULT '0' COMMENT '产品销量',
  `addtime` int(11) unsigned DEFAULT '0' COMMENT '创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `is_news` tinyint(1) unsigned DEFAULT '0' COMMENT '新品（0=否，1=是）',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '上架',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_cat_id` (`cat_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_is_news` (`is_news`) USING BTREE,
  KEY `idx_brand_id` (`brand_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品管理';


-- ----------------------------
-- Table structure for `rrz_goods_attr`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attr`;
CREATE TABLE `rrz_goods_attr` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品属性id自增',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `attr_value` text COMMENT '属性值',
  `attr_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `goods_id` (`goods_id`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品扩展属性关联表';


-- ----------------------------
-- Table structure for `rrz_goods_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attribute`;
CREATE TABLE `rrz_goods_attribute` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '属性名称',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '类型（0 单行文本框 1下拉式列表 2多行文本框）',
  `values` text COMMENT '属性值集合',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '100' COMMENT '属性排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品扩展属性';


-- ----------------------------
-- Table structure for `rrz_goods_brand`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_brand`;
CREATE TABLE `rrz_goods_brand` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '品牌表',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌名称',
  `logo` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌logo',
  `desc` text COMMENT '备注介绍',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌地址',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品品牌';


-- ----------------------------
-- Table structure for `rrz_goods_cat`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_cat`;
CREATE TABLE `rrz_goods_cat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) DEFAULT '' COMMENT '分类名称',
  `en_title` varchar(255) NOT NULL DEFAULT '' COMMENT '分类英文名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '分类图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '节点深度',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '分类排序',
  `path` varchar(255) DEFAULT '' COMMENT '节点路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `view_route` varchar(255) NOT NULL DEFAULT '{typedir}/{aid}.html' COMMENT '详情页路由',
  `list_route` varchar(255) NOT NULL DEFAULT '{typedir}/list_{tid}_{page}.html' COMMENT '列表页路由',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `attrs` longtext COMMENT '参数列表',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '发布',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品分类';


-- ----------------------------
-- Table structure for `rrz_goods_skus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_skus`;
CREATE TABLE `rrz_goods_skus` (
  `sku_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品规格id',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '规格明细',
  PRIMARY KEY (`sku_id`) USING BTREE,
  KEY `idx_goods_id` (`goods_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品规格详情';


-- ----------------------------
-- Table structure for `rrz_goods_spec_values`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_spec_values`;
CREATE TABLE `rrz_goods_spec_values` (
  `spec_value_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '规格值ID',
  `spec_id` bigint(15) unsigned NOT NULL DEFAULT '0' COMMENT '规格ID',
  `spec_value` varchar(100) NOT NULL DEFAULT '' COMMENT '规格值',
  PRIMARY KEY (`spec_value_id`) USING BTREE,
  KEY `idx_spec_id` (`spec_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格值';


-- ----------------------------
-- Table structure for `rrz_goods_specification`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_specification`;
CREATE TABLE `rrz_goods_specification` (
  `spec_id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `spec_name` varchar(50) DEFAULT NULL COMMENT '规格名',
  `sort` smallint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序顺序',
  PRIMARY KEY (`spec_id`) USING BTREE,
  KEY `idx_sort` (`sort`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格表';


-- ----------------------------
-- Table structure for `rrz_plugin`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_plugin`;
CREATE TABLE `rrz_plugin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(20) NOT NULL DEFAULT '' COMMENT '编码',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `desc` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `version` varchar(20) NOT NULL DEFAULT '' COMMENT '版本号',
  `author` varchar(30) NOT NULL DEFAULT '' COMMENT '作者',
  `isadmin` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否存在后台（0否1是）',
  `ishome` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否存在前台（0否1是）',
  `isload` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否自动加载（0手动加载、1自动加载）',
  `loadtemp` text COMMENT '自动加载在指定模板，空白默认全部',
  `config` text COMMENT '额外参数',
  `data` text COMMENT '配置存储数据，简单插件可以不创建表',
  `saflag` varchar(500) DEFAULT NULL COMMENT '标示内容',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态（0未安装、1启用、2禁用）',
  `addtime` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '执行顺序',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_code` (`code`),
  KEY `idx_status` (`status`),
  KEY `idx_ishome` (`ishome`),
  KEY `idx_isload` (`isload`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='插件表';


-- ----------------------------
-- Table structure for `rrz_search_keywords`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_search_keywords`;
CREATE TABLE `rrz_search_keywords` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `keywords` text COMMENT '关键词',
  `type` varchar(50) DEFAULT 'article' COMMENT '搜索类型',
  `ip` varchar(100) DEFAULT NULL COMMENT '搜索客户端的ip地址',
  `hot` int(10) unsigned DEFAULT '0' COMMENT '关键词搜索量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '搜索时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_hot` (`hot`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_site_links`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_links`;
CREATE TABLE `rrz_site_links` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT '' COMMENT '网站标题',
  `url` varchar(255) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort` int(10) unsigned DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) unsigned DEFAULT '0' COMMENT '是否新窗口打开',
  `email` varchar(50) DEFAULT '',
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='友情链接表';

-- -----------------------------
-- Records of `rrz_site_links`
-- -----------------------------
INSERT INTO `rrz_site_links` VALUES ('1', '企业建站系统', 'http://www.rrzcms.com/', 'http://g.kbscdn.cn/kbcms/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1590481203', '1627543172');
INSERT INTO `rrz_site_links` VALUES ('2', '淘进微信', 'http://taobao.kbstore.cn/', 'http://taobao.kbstore.cn/Public/images/logo-1.png', '100', '1', '', '', '1', 'cn', '1590481246', '1627543144');
INSERT INTO `rrz_site_links` VALUES ('3', '人人站CMS', 'http://www.rrzcms.com/', 'http://g.kbscdn.cn/kbcms/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1590481266', '1627543178');
INSERT INTO `rrz_site_links` VALUES ('4', '抖进微信', 'http://dou.kbstore.cn/', 'http://dou.kbstore.cn/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1621244482', '1627543197');
INSERT INTO `rrz_site_links` VALUES ('5', '淘进微博', 'http://weibo.kbstore.cn/', 'http://weibo.kbstore.cn/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1621244551', '1631698452');

-- ----------------------------
-- Table structure for `rrz_site_menus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_menus`;
CREATE TABLE `rrz_site_menus` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '标题',
  `en_title` varchar(100) NOT NULL DEFAULT '' COMMENT '英文标题',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '上级菜单',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '菜单深度',
  `url` varchar(200) DEFAULT '' COMMENT '自定义链接',
  `sort` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `path` varchar(100) NOT NULL DEFAULT '' COMMENT '上下级路径',
  `target_blank` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '是否新开窗口',
  `config` longtext COMMENT '配置',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='导航菜单表';

-- -----------------------------
-- Records of `rrz_site_menus`
-- -----------------------------
INSERT INTO `rrz_site_menus` VALUES ('1', '首页', 'Home', 'index', '0', '1', '1', '/', '1', '1001', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('2', '景点介绍', '', 'jdjs', '0', '2', '1', '/node/1.html', '2', '1002', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('3', '客房展示', '', 'kfzs', '0', '3', '1', '/node/3.html', '3', '1003', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('4', '景点新闻', '', 'news', '0', '4', '1', '/node/9.html', '4', '1004', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('5', '路线推荐', '', 'lxtj', '0', '5', '1', '/node/2.html', '5', '1005', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('6', '农家大院', '', 'njdy', '0', '6', '1', '/node/10.html', '6', '1006', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('7', '特色美食', '', 'tsms', '0', '7', '1', '/node/8.html', '7', '1007', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('8', '活动专题', '', 'huodongzhuanti', '0', '8', '1', '/node/28.html', '8', '1008', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('9', '在线留言', '', 'zaixianliuyan', '0', '9', '1', '/node/11.html', '9', '1009', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('10', '联系我们', '', 'lianxiwomen', '0', '10', '1', '/node/12.html', '10', '1010', 'false', '');
