<?php
/**
 * 人人站CMS
 * ============================================================================
 * 版权所有 2015-2030 山东康程信息科技有限公司，并保留所有权利。
 * 网站地址: http://www.rrzcms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 */

namespace app\admin\model;

use think\Model;

class Articles extends Model
{

    public static function getInfo($id = 0) {
        $info = M('articles')->where('id', $id)->find();

        //标签数据
        $tags = M('tag_rel')->where('rel_id', $id)->where('tag_type', 1)->order('id asc')->column('tag_title');
        $info['tags'] = implode(',', $tags);

        return $info;
    }

    public static function onAfterSave($id, $data) {

        //标签处理
        $tags = I('post.tags');
        $tags = explode(',', $tags);
        $tags = array_map('trim', $tags);
        $tags = array_values(array_unique(array_filter($tags)));
        Tag::saveRelTags($tags, $id, $data['node_id'], 1);

    }
}