-- ----------------------------------------
-- RRZCMS MySQL Data Transfer 
-- 
-- Server         : 127.0.0.1_3306
-- Server Version : 5.7.26
-- Database       : rrzcms
-- 
-- Part : #1
-- Version : #v1.3.7
-- Date : 2022-02-09 11:37:23
-- -----------------------------------------

SET FOREIGN_KEY_CHECKS = 0;


-- ----------------------------
-- Table structure for `rrz_admin`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin`;
CREATE TABLE `rrz_admin` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `user_name` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `pen_name` varchar(50) DEFAULT '' COMMENT '笔名（发布文章后显示责任编辑的名字）',
  `true_name` varchar(50) DEFAULT '' COMMENT '真实姓名',
  `mobile` varchar(50) DEFAULT '' COMMENT '手机号码',
  `email` varchar(60) DEFAULT '' COMMENT 'email',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT '密码',
  `head_pic` varchar(255) DEFAULT '' COMMENT '头像',
  `last_login` int(11) unsigned DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_cnt` int(11) unsigned DEFAULT '0' COMMENT '登录次数',
  `session_id` varchar(50) DEFAULT '' COMMENT 'session_id',
  `parent_id` int(10) unsigned DEFAULT '0' COMMENT '父管理员ID',
  `role_id` int(10) NOT NULL DEFAULT '-1' COMMENT '角色组ID（-1表示超级管理员）',
  `mark_lang` varchar(50) DEFAULT 'cn' COMMENT '当前语言标识',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `syn_users_id` int(10) unsigned DEFAULT '0' COMMENT '同步注册到会员表',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_name` (`user_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员表';

-- -----------------------------
-- Records of `rrz_admin`
-- -----------------------------
INSERT INTO `rrz_admin` VALUES ('1', 'admin', '', 'admin', '', '', '21232f297a57a5a743894a0e4a801fc3', '/static/images/dfboy.png', '1644369107', '127.0.0.1', '43', '', '0', '1', 'cn', '1', '1', '1586479354', '1588751715');

-- ----------------------------
-- Table structure for `rrz_admin_log`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_log`;
CREATE TABLE `rrz_admin_log` (
  `id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `admin_id` int(10) NOT NULL DEFAULT '-1' COMMENT '管理员id',
  `log_info` text COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT '' COMMENT 'ip地址',
  `log_url` varchar(255) DEFAULT '' COMMENT 'url',
  `log_time` int(11) DEFAULT '0' COMMENT '日志时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员日志表';


-- ----------------------------
-- Table structure for `rrz_admin_role`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_role`;
CREATE TABLE `rrz_admin_role` (
  `role_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `role_name` varchar(30) DEFAULT NULL COMMENT '角色名称',
  `act_list` text COMMENT '权限列表',
  `role_desc` varchar(255) DEFAULT NULL COMMENT '角色描述',
  PRIMARY KEY (`role_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='用户角色表';

-- -----------------------------
-- Records of `rrz_admin_role`
-- -----------------------------
INSERT INTO `rrz_admin_role` VALUES ('1', '超级管理员', 'all', '管理全站');

-- ----------------------------
-- Table structure for `rrz_article_nodes`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_article_nodes`;
CREATE TABLE `rrz_article_nodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目名称',
  `en_title` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目英文名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '栏目图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '栏目深度',
  `sort` smallint(6) unsigned DEFAULT '50' COMMENT '排序',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `view_route` varchar(255) NOT NULL DEFAULT '{typedir}/{aid}.html' COMMENT '详情页路由',
  `list_route` varchar(255) NOT NULL DEFAULT '{typedir}/list_{tid}_{page}.html' COMMENT '列表页路由',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '发布',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章类目';

-- -----------------------------
-- Records of `rrz_article_nodes`
-- -----------------------------
INSERT INTO `rrz_article_nodes` VALUES ('1', '0', '关于我们', 'ABOUT US', 'guanyuwomen', '0', '', '1', '1', '1', '1001', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', 'ABOUT US', '四川省茶业集团股份有限公司(以下简称“川茶集团”)于2013年10月成立，是以原四川省叙府茶业有限公司为主体联合省内多家茶叶企业共同发起组建的四川首家集茶树良种繁育、种植示范、茶叶初精深加工、品牌营销、科技研发与推广、茶文化应用与茶旅游发展以及其他茶', '', '<p>&nbsp;四川省茶业集团股份有限公司(以下简称“川茶集团”)于2013年10月成立，是以原四川省叙府茶业有限公司为主体联合省内多家茶叶企业共同发起组建的四川首家集茶树良种繁育、种植示范、茶叶初精深加工、品牌营销、科技研发与推广、茶文化应用与茶旅游发展以及其他茶叶关联产业等为一体的现代茶产业集群。</p><p>\r\n	川茶集团是省、市、区各级党委政府重点扶持打造的“农业产业化国家重点龙头企业”、“全国农业产业化优秀龙头企业”、川茶千亿产业发展的排头兵企业。近年来，集团在翠屏区邱场、明威、金坪三个乡镇与茶农共同建设打造的十万亩优质早茶基地效果显著，得到省委省政府、相关部门和茶界同仁的高度肯定，在宜宾县打造的黄山有机茶基地现在已是全国连片规模最大的高山有机茶基地，同时也是全国唯一一个连续十年通过国内国际双认证的有机茶生产基地，集团创新产品“天府龙芽”更是获得一个世纪以来中国茶产业的顶级奖项——百年世博中国名茶金骆驼奖。</p><p>\r\n	集团公司坚持以科技创新支撑全茶产业链发展，在川茶产业转型升级发展中走出了一条科技支撑、创新驱动的道路，引领全国茶行业科技创新。2014年2月26日，“川茶产业商学院”挂牌成立；2014年3月19日，“川茶产业技术研究院”授牌，与川茶集团拥有的全国茶行业目前唯一的“国家认定企业技术中心”和全省唯一的“四川省茶业工程技术研究中心”，合称为四川省茶业集团“两院两中心”。2015年3月，根据四川省委组织部、省经济和信息化委、省国资委等七部门印发的《四川省院士（专家）工作站实施办法》，川茶集团成为四川省首家获批成立院士工作站的茶叶企业，进站院士（专家）由陈宗懋先生担任。自此，川茶集团最终形成了“一站两院两中心”的科技创新支持体系，实现了川茶集团在以科技创新为支撑引领四川、乃至全国茶产业发展道路上又一里程碑式的跨越。</p><p>\r\n	集团始终以推动川茶产业崛起振兴为己任，充分发挥千亿川茶产业排头兵作用，奋力领舞川茶产业整体转型升级。2013年，四川省委省政府明确提出了“组建川茶集团，实施抱团发展，打造川茶千亿大产业”的战略目标，作为“川茶集团联盟”的发起单位，集团秉承“资源共享、优势互补、抱团发展、联合共赢”的理念，联合峨眉雪芽、米仓山、早白尖等30多家茶企，共同促进川茶全产业链发展的体制机制创新、管理体系创新、品牌与营销体系创新，推进川茶产业转型升级。同时，作为四川省川茶品牌促进会会长单位，严格贯彻落实省委省政府一号文件《关于加快川茶产业转型升级建设茶业强省的意见》关于打造川茶大区域品牌重要指示精神，联合省内100多家茶企共同打造川茶大区域品牌，提升川茶品牌整体竞争力。2015年5月26日，省川茶产业发展联席会议办公室组织召开了“加快推进川茶品牌建设工作座谈会”，会议广泛讨论，再次征求意见，一致同意推选“天府龙芽”作为川茶大区域品牌。2015年6月7日，史哈副省长作出重要批示，同意将“天府龙芽”作为川茶大区域品牌来打造。目前，作为全国茶行业科技创新的引领者和川茶产业发展排头兵，川茶集团正肩负新的历史使命昂首前行。</p>', '', 'true', '1644308966');
INSERT INTO `rrz_article_nodes` VALUES ('13', '0', '公司介绍', '', 'guanyuwomen/gongsijieshao', '1', '', '1,13', '2', '1', '10011001', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '&nbsp;南方嘉木,其名曰茶，悠悠千古，即识茶香。巴山峡川，多古茶树，僰道三江，是茶故乡。钟山岳之灵秀，聚日月之精华；孕育名茶，甘霖滋润。水则三江之注，挹彼清流；地则膏腴肥美，育兹珍秀。由是，芳茶冠六合，醇味播四方。西周之时，即为贡品；丝绸之路，流布八荒。爰及蜀汉，诸葛渡泸，蛮烟瘴雾，实阻征途。幸遇高人指点，饮黄山茶，破除瘴疫，冠名龙芽而示瑞祥。茶马古道，山间铃响马帮来；墨迁客骚人，文思泉涌缘茶香。君不见，三苏父子观茶市，逸兴遄飞咏《戎州》；君不见，山谷赋诗锁江亭，茶鼎烹茗看日色。噫吁兮，满目青山，茶民辛劳，携篮过岭，采掇龙芽；御前大宴，丝管纷纷，龙团凤饼助歌舞。僰道茶业多少事，万里长江鑑古今。<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 往事越千年，涛声话春秋，何期一东夜春风起，叙府龙芽出江湖。承百代风华之余绪，贯千秋华夏之慧根。召天下英雄为我所用，集四方贤士共谋新运。天宫佛光，福泽黄山，蓊郁万亩茶园；金秋之湖，科技兴业，潋滟山色湖光。用心做好茶，技精近乎道；引领业界风流，桴鼓世界大潮。参百品而不混，越众饮而独高。斯茶也，形至美，色至清，味至宽，性至厚，益思提神，止渴生津；去腐化浊，强身防病；有道是，有机茶绿益寿延，不可一日无此君。此龙芽之为用也。洒扫庭除，烹茶净具，龙行十八式，天风十二品。人间要好茶，龙芽国之饮。金秋水碧碧于天，从来佳茗似佳人。仪态万方，延客品茗，契阔谈讌，馥郁香馨。珠光青瓷，映日月朝霞；宜兴紫砂，蕴江河灵性。可以兴，可以观，可以群，可以怨，诗境即茶境，茶汤生画意。此龙芽之为艺也。生命常绿，龙芽长青。人惟高洁，茶称上品。君子之交，清茶一杯。冲淡平和，俭德精行。寒夜客来茶当酒，龙芽水洗烦恼丝。心游物外，返朴归真；茶禅一味，见性明心。大隐居廛市，红尘识茶人。茶德修来悟真如，五蕴空灵六根净。此龙芽之为道也。吁嗟乎，茶运系乎国运，国运可昌茶运；茶兴农事兴，香茗复富民。君不见，叙府茶园十万亩，年年赐福种茶人！<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 盛世和平，万方乐奏，一壶龙芽，海宴河清。一品齿颊香，舌下顿生津，浊气安在哉，形神复相亲；再品思悠悠，两腋清风生，大道复自然，灵境无俗尘。三杯发奇想，大笔赋诗文：“安得龙芽亿万株，翡翠如碧植五州，四海之内皆兄弟，笑品香茗泯恩仇”。噫吁兮，茶之时义大矣哉，含弘光大话风流。千禧晋元，气象欣荣；中华龙芽，举世芳芬！大江浩浩来天地，叙府茶业，日新月新岁岁新！', '', 'true', '1644304546');
INSERT INTO `rrz_article_nodes` VALUES ('14', '0', '企业文化', '', 'guanyuwomen/qiyewenhua', '1', '', '1,14', '2', '2', '10011002', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '<span style=\"color: rgb(51, 51, 51); font-family: \'Microsoft YaHei\'; font-size: 15px; line-height: 30px;\">《人人站CMS》诞生于2014年6月（www.rrzcms.com），以提供分享精品人人站源码及人人站建站过程常遇到的问题解决方案汇总为主要宗旨。</span><br style=\"color: rgb(51, 51, 51); font-family: \'Microsoft YaHei\'; font-size: 15px; line-height: 30px;\" />\r\n<span style=\"color: rgb(51, 51, 51); font-family: \'Microsoft YaHei\'; font-size: 15px; line-height: 30px;\">《人人站CMS》内容涉及: 企业类人人站源码，门户类人人站源码，及工作室或博客类等基于人人站系统仿制等风格。</span><br style=\"color: rgb(51, 51, 51); font-family: \'Microsoft YaHei\'; font-size: 15px; line-height: 30px;\" />\r\n<span style=\"color: rgb(51, 51, 51); font-family: \'Microsoft YaHei\'; font-size: 15px; line-height: 30px;\">《人人站CMS》将向着共享化、全面化、专业化、深度化、免费化的多元方向发展，打造实用快捷的建站体验，为会员及用户提供高质量的服务。</span><br style=\"color: rgb(51, 51, 51); font-family: \'Microsoft YaHei\'; font-size: 15px; line-height: 30px;\" />\r\n<span style=\"color: rgb(51, 51, 51); font-family: \'Microsoft YaHei\'; font-size: 15px; line-height: 30px;\">《人人站CMS》感谢无数关注、支持我们的会员及各位访客们，感谢您们的信任。年轻的《人人站CMS》愿与同样充满活力的您，彼此相伴，共同成长！</span><br style=\"color: rgb(51, 51, 51); font-family: \'Microsoft YaHei\'; font-size: 15px; line-height: 30px;\" />\r\n<span style=\"color: rgb(51, 51, 51); font-family: \'Microsoft YaHei\'; font-size: 15px; line-height: 30px;\">《人人站CMS》只专心做一件事，便是做好的完整的人人站源码！</span><br style=\"color: rgb(51, 51, 51); font-family: \'Microsoft YaHei\'; font-size: 15px; line-height: 30px;\" />\r\n<br style=\"color: rgb(51, 51, 51); font-family: \'Microsoft YaHei\'; font-size: 15px; line-height: 30px;\" />\r\n<span style=\"color: rgb(51, 51, 51); font-family: \'Microsoft YaHei\'; font-size: 15px; line-height: 30px;\">人人站CMS开站以来，尽管没有积累太多用户口碑和市场份额，但我们一直努力，每天保持更新各行各业好源码，让找人人站源码去rrzcms已经成为很多人人站爱好者的习惯。</span><br style=\"color: rgb(51, 51, 51); font-family: \'Microsoft YaHei\'; font-size: 15px; line-height: 30px;\" />\r\n<span style=\"color: rgb(51, 51, 51); font-family: \'Microsoft YaHei\'; font-size: 15px; line-height: 30px;\">相信通过我们的努力,rrzcms会越来越好！</span><br style=\"color: rgb(51, 51, 51); font-family: \'Microsoft YaHei\'; font-size: 15px; line-height: 30px;\" />\r\n<br style=\"color: rgb(51, 51, 51); font-family: \'Microsoft YaHei\'; font-size: 15px; line-height: 30px;\" />\r\n<span style=\"color: rgb(51, 51, 51); font-family: \'Microsoft YaHei\'; font-size: 15px; line-height: 30px;\">rrzcms离不开您的参与，如果您：</span><br style=\"color: rgb(51, 51, 51); font-family: \'Microsoft YaHei\'; font-size: 15px; line-height: 30px;\" />\r\n<span style=\"color: rgb(51, 51, 51); font-family: \'Microsoft YaHei\'; font-size: 15px; line-height: 30px;\">1.要出售自己持有的好源码？欢迎您来这里分享，经过审核后会支付一定的金币做为回报。</span><br style=\"color: rgb(51, 51, 51); font-family: \'Microsoft YaHei\'; font-size: 15px; line-height: 30px;\" />\r\n<span style=\"color: rgb(51, 51, 51); font-family: \'Microsoft YaHei\'; font-size: 15px; line-height: 30px;\">2.苦苦寻觅人人站源码 、迫切希望得到一个改改就能用上的企业网站？这里或许能很快解决您的问题。</span><br style=\"color: rgb(51, 51, 51); font-family: \'Microsoft YaHei\'; font-size: 15px; line-height: 30px;\" />\r\n<span style=\"color: rgb(51, 51, 51); font-family: \'Microsoft YaHei\'; font-size: 15px; line-height: 30px;\">3.想找个网络模板收藏夹存放自己喜爱的源码或模板？ 这里就是您的选择。</span><br style=\"color: rgb(51, 51, 51); font-family: \'Microsoft YaHei\'; font-size: 15px; line-height: 30px;\" />\r\n<span style=\"color: rgb(51, 51, 51); font-family: \'Microsoft YaHei\'; font-size: 15px; line-height: 30px;\">4.想结交更多热爱人人站源码建站的朋友？那就快来分享您的源码，寻找志趣相投的朋友吧。</span>', '', 'true', '1644304547');
INSERT INTO `rrz_article_nodes` VALUES ('15', '0', '企业荣誉', '', 'guanyuwomen/qiyerongyu', '1', '', '1,15', '2', '3', '10011003', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '&nbsp;南方嘉木,其名曰茶，悠悠千古，即识茶香。巴山峡川，多古茶树，僰道三江，是茶故乡。钟山岳之灵秀，聚日月之精华；孕育名茶，甘霖滋润。水则三江之注，挹彼清流；地则膏腴肥美，育兹珍秀。由是，芳茶冠六合，醇味播四方。西周之时，即为贡品；丝绸之路，流布八荒。爰及蜀汉，诸葛渡泸，蛮烟瘴雾，实阻征途。幸遇高人指点，饮黄山茶，破除瘴疫，冠名龙芽而示瑞祥。茶马古道，山间铃响马帮来；墨迁客骚人，文思泉涌缘茶香。君不见，三苏父子观茶市，逸兴遄飞咏《戎州》；君不见，山谷赋诗锁江亭，茶鼎烹茗看日色。噫吁兮，满目青山，茶民辛劳，携篮过岭，采掇龙芽；御前大宴，丝管纷纷，龙团凤饼助歌舞。僰道茶业多少事，万里长江鑑古今。<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 往事越千年，涛声话春秋，何期一东夜春风起，叙府龙芽出江湖。承百代风华之余绪，贯千秋华夏之慧根。召天下英雄为我所用，集四方贤士共谋新运。天宫佛光，福泽黄山，蓊郁万亩茶园；金秋之湖，科技兴业，潋滟山色湖光。用心做好茶，技精近乎道；引领业界风流，桴鼓世界大潮。参百品而不混，越众饮而独高。斯茶也，形至美，色至清，味至宽，性至厚，益思提神，止渴生津；去腐化浊，强身防病；有道是，有机茶绿益寿延，不可一日无此君。此龙芽之为用也。洒扫庭除，烹茶净具，龙行十八式，天风十二品。人间要好茶，龙芽国之饮。金秋水碧碧于天，从来佳茗似佳人。仪态万方，延客品茗，契阔谈讌，馥郁香馨。珠光青瓷，映日月朝霞；宜兴紫砂，蕴江河灵性。可以兴，可以观，可以群，可以怨，诗境即茶境，茶汤生画意。此龙芽之为艺也。生命常绿，龙芽长青。人惟高洁，茶称上品。君子之交，清茶一杯。冲淡平和，俭德精行。寒夜客来茶当酒，龙芽水洗烦恼丝。心游物外，返朴归真；茶禅一味，见性明心。大隐居廛市，红尘识茶人。茶德修来悟真如，五蕴空灵六根净。此龙芽之为道也。吁嗟乎，茶运系乎国运，国运可昌茶运；茶兴农事兴，香茗复富民。君不见，叙府茶园十万亩，年年赐福种茶人！<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 盛世和平，万方乐奏，一壶龙芽，海宴河清。一品齿颊香，舌下顿生津，浊气安在哉，形神复相亲；再品思悠悠，两腋清风生，大道复自然，灵境无俗尘。三杯发奇想，大笔赋诗文：“安得龙芽亿万株，翡翠如碧植五州，四海之内皆兄弟，笑品香茗泯恩仇”。噫吁兮，茶之时义大矣哉，含弘光大话风流。千禧晋元，气象欣荣；中华龙芽，举世芳芬！大江浩浩来天地，叙府茶业，日新月新岁岁新！', '', 'true', '1644304547');
INSERT INTO `rrz_article_nodes` VALUES ('2', '0', '科普知识', 'CIENCE', 'kp', '0', '', '2', '1', '2', '1002', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', 'JOIN', '', '', '', '', 'true', '1644309406');
INSERT INTO `rrz_article_nodes` VALUES ('16', '0', '营养知识', '', 'zhaoshangjiameng/yyzs', '2', '', '2,16', '2', '1', '10021001', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '<br />\r\n', '', 'true', '1644304547');
INSERT INTO `rrz_article_nodes` VALUES ('17', '0', '营养搭配', '', 'zhaoshangjiameng/dp', '2', '', '2,17', '2', '2', '10021002', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '<br />\r\n', '', 'true', '1644304547');
INSERT INTO `rrz_article_nodes` VALUES ('8', '0', '案例展示', 'CASE', 'cases', '0', '', '8', '1', '4', '1004', 'case', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', 'CASE', '', '', '', '', 'true', '1644371614');
INSERT INTO `rrz_article_nodes` VALUES ('19', '0', '案例一类', '', 'cases/anliyilei', '8', '', '8,19', '2', '1', '10041001', 'case', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '', '', 'true', '1644304547');
INSERT INTO `rrz_article_nodes` VALUES ('20', '0', '案例二类', '', 'cases/anlierlei', '8', '', '8,20', '2', '2', '10041002', 'case', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '', '', 'true', '1644304547');
INSERT INTO `rrz_article_nodes` VALUES ('21', '0', '案例三类', '', 'cases/anlisanlei', '8', '', '8,21', '2', '3', '10041003', 'case', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '', '', 'true', '1644304547');
INSERT INTO `rrz_article_nodes` VALUES ('9', '0', '新闻资讯', 'EWS', 'xinwenzixun', '0', '', '9', '1', '5', '1005', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', 'GROUP NEWS', '', '', '', '', 'true', '1644308987');
INSERT INTO `rrz_article_nodes` VALUES ('22', '0', '公司新闻', '', 'xinwenzixun/gongsixinwen', '9', '', '9,22', '2', '1', '10051001', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '', '', 'true', '1644304547');
INSERT INTO `rrz_article_nodes` VALUES ('23', '0', '行业动态', '', 'xinwenzixun/xingyedongtai', '9', '', '9,23', '2', '2', '10051002', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '', '', 'true', '1644304547');
INSERT INTO `rrz_article_nodes` VALUES ('10', '0', '营养价值', 'RECRUITMENT', 'yyjz', '0', '', '10', '1', '6', '1006', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', 'RECRUITMENT', '四川省茶业集团股份有限公司(以下简称“川茶集团”)于2013年10月成立，是以原四川省叙府茶业有限公司为主体联合省内多家茶叶企业共同发起组建的四川首家集茶树良种繁育、种植示范、茶叶初精深加工、品牌营销、科技研发与推广、茶文化应用与茶旅游发展以及其他茶', '', '<p>&nbsp;四川省茶业集团股份有限公司(以下简称“川茶集团”)于2013年10月成立，是以原四川省叙府茶业有限公司为主体联合省内多家茶叶企业共同发起组建的四川首家集茶树良种繁育、种植示范、茶叶初精深加工、品牌营销、科技研发与推广、茶文化应用与茶旅游发展以及其他茶叶关联产业等为一体的现代茶产业集群。</p><p>\r\n	川茶集团是省、市、区各级党委政府重点扶持打造的“农业产业化国家重点龙头企业”、“全国农业产业化优秀龙头企业”、川茶千亿产业发展的排头兵企业。近年来，集团在翠屏区邱场、明威、金坪三个乡镇与茶农共同建设打造的十万亩优质早茶基地效果显著，得到省委省政府、相关部门和茶界同仁的高度肯定，在宜宾县打造的黄山有机茶基地现在已是全国连片规模最大的高山有机茶基地，同时也是全国唯一一个连续十年通过国内国际双认证的有机茶生产基地，集团创新产品“天府龙芽”更是获得一个世纪以来中国茶产业的顶级奖项——百年世博中国名茶金骆驼奖。</p><p>\r\n	集团公司坚持以科技创新支撑全茶产业链发展，在川茶产业转型升级发展中走出了一条科技支撑、创新驱动的道路，引领全国茶行业科技创新。2014年2月26日，“川茶产业商学院”挂牌成立；2014年3月19日，“川茶产业技术研究院”授牌，与川茶集团拥有的全国茶行业目前唯一的“国家认定企业技术中心”和全省唯一的“四川省茶业工程技术研究中心”，合称为四川省茶业集团“两院两中心”。2015年3月，根据四川省委组织部、省经济和信息化委、省国资委等七部门印发的《四川省院士（专家）工作站实施办法》，川茶集团成为四川省首家获批成立院士工作站的茶叶企业，进站院士（专家）由陈宗懋先生担任。自此，川茶集团最终形成了“一站两院两中心”的科技创新支持体系，实现了川茶集团在以科技创新为支撑引领四川、乃至全国茶产业发展道路上又一里程碑式的跨越。</p><p>\r\n	集团始终以推动川茶产业崛起振兴为己任，充分发挥千亿川茶产业排头兵作用，奋力领舞川茶产业整体转型升级。2013年，四川省委省政府明确提出了“组建川茶集团，实施抱团发展，打造川茶千亿大产业”的战略目标，作为“川茶集团联盟”的发起单位，集团秉承“资源共享、优势互补、抱团发展、联合共赢”的理念，联合峨眉雪芽、米仓山、早白尖等30多家茶企，共同促进川茶全产业链发展的体制机制创新、管理体系创新、品牌与营销体系创新，推进川茶产业转型升级。同时，作为四川省川茶品牌促进会会长单位，严格贯彻落实省委省政府一号文件《关于加快川茶产业转型升级建设茶业强省的意见》关于打造川茶大区域品牌重要指示精神，联合省内100多家茶企共同打造川茶大区域品牌，提升川茶品牌整体竞争力。2015年5月26日，省川茶产业发展联席会议办公室组织召开了“加快推进川茶品牌建设工作座谈会”，会议广泛讨论，再次征求意见，一致同意推选“天府龙芽”作为川茶大区域品牌。2015年6月7日，史哈副省长作出重要批示，同意将“天府龙芽”作为川茶大区域品牌来打造。目前，作为全国茶行业科技创新的引领者和川茶产业发展排头兵，川茶集团正肩负新的历史使命昂首前行。</p>', '', 'true', '1644371681');
INSERT INTO `rrz_article_nodes` VALUES ('25', '0', '营养理念', '', 'rencaizhaopin/ln', '10', '', '10,25', '2', '1', '10061001', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '&nbsp;《人人站CMS》诞生于2014年6月（www.rrzcms.com），以提供分享精品人人站源码及人人站建站过程常遇到的问题解决方案汇总为主要宗旨。<br />\r\n《人人站CMS》内容涉及: 企业类人人站源码，门户类人人站源码，及工作室或博客类等基于人人站系统仿制等风格。<br />\r\n《人人站CMS》将向着共享化、全面化、专业化、深度化、免费化的多元方向发展，打造实用快捷的建站体验，为会员及用户提供高质量的服务。<br />\r\n《人人站CMS》感谢无数关注、支持我们的会员及各位访客们，感谢您们的信任。年轻的《人人站CMS》愿与同样充满活力的您，彼此相伴，共同成长！<br />\r\n《人人站CMS》只专心做一件事，便是做好的完整的人人站源码！<br />\r\n<br />\r\n人人站CMS开站以来，尽管没有积累太多用户口碑和市场份额，但我们一直努力，每天保持更新各行各业好源码，让找人人站源码去rrzcms已经成为很多人人站爱好者的习惯。<br />\r\n相信通过我们的努力,rrzcms会越来越好！<br />\r\n<br />\r\nrrzcms离不开您的参与，如果您：<br />\r\n1.要出售自己持有的好源码？欢迎您来这里分享，经过审核后会支付一定的金币做为回报。<br />\r\n2.苦苦寻觅人人站源码 、迫切希望得到一个改改就能用上的企业网站？这里或许能很快解决您的问题。<br />\r\n3.想找个网络模板收藏夹存放自己喜爱的源码或模板？ 这里就是您的选择。<br />\r\n4.想结交更多热爱人人站源码建站的朋友？那就快来分享您的源码，寻找志趣相投的朋友吧。', '', 'true', '1644304547');
INSERT INTO `rrz_article_nodes` VALUES ('11', '0', '在线留言', 'FEEDBACK', 'zaixianliuyan', '0', '', '11', '1', '7', '1007', 'single_liuyan', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', 'FEEDBACK', '', '', '', '', 'true', '1644371701');
INSERT INTO `rrz_article_nodes` VALUES ('26', '0', '在线留言', '', 'zaixianliuyan/zaixianliuyan', '11', '', '11,26', '2', '1', '10071001', 'single_liuyan', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '', '', 'true', '1644304547');
INSERT INTO `rrz_article_nodes` VALUES ('12', '0', '联系我们', '', 'lianxiwomen', '0', '', '12', '1', '8', '1008', 'single_contact', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', 'CONTACT US', '', '', '<p>\r\n	地址：这里是您的公司地址<br />\r\n	电话：+86-0000-96877<br />\r\n	传真：+86-0000-96877<br />\r\n	邮编：000000<br />\r\n	邮箱：这里是您公司的邮箱地址 &nbsp;</p>\r\n', '', 'true', '1644304547');
INSERT INTO `rrz_article_nodes` VALUES ('27', '0', '联系方式', '', 'lianxiwomen/lianxifangshi', '12', '', '12,27', '2', '1', '10081001', 'single_contact', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '&nbsp;《人人站CMS》诞生于2014年6月（www.rrzcms.com），以提供分享精品人人站源码及人人站建站过程常遇到的问题解决方案汇总为主要宗旨。<br />\r\n《人人站CMS》内容涉及: 企业类人人站源码，门户类人人站源码，及工作室或博客类等基于人人站系统仿制等风格。<br />\r\n《人人站CMS》将向着共享化、全面化、专业化、深度化、免费化的多元方向发展，打造实用快捷的建站体验，为会员及用户提供高质量的服务。<br />\r\n《人人站CMS》感谢无数关注、支持我们的会员及各位访客们，感谢您们的信任。年轻的《人人站CMS》愿与同样充满活力的您，彼此相伴，共同成长！<br />\r\n《人人站CMS》只专心做一件事，便是做好的完整的人人站源码！<br />\r\n<br />\r\n人人站CMS开站以来，尽管没有积累太多用户口碑和市场份额，但我们一直努力，每天保持更新各行各业好源码，让找人人站源码去rrzcms已经成为很多人人站爱好者的习惯。<br />\r\n相信通过我们的努力,rrzcms会越来越好！<br />\r\n<br />\r\nrrzcms离不开您的参与，如果您：<br />\r\n1.要出售自己持有的好源码？欢迎您来这里分享，经过审核后会支付一定的金币做为回报。<br />\r\n2.苦苦寻觅人人站源码 、迫切希望得到一个改改就能用上的企业网站？这里或许能很快解决您的问题。<br />\r\n3.想找个网络模板收藏夹存放自己喜爱的源码或模板？ 这里就是您的选择。<br />\r\n4.想结交更多热爱人人站源码建站的朋友？那就快来分享您的源码，寻找志趣相投的朋友吧。', '', 'true', '1644304547');

-- ----------------------------
-- Table structure for `rrz_articles`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_articles`;
CREATE TABLE `rrz_articles` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `node_id` mediumint(8) NOT NULL DEFAULT '0' COMMENT '类别ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '文章标题',
  `subtitle` varchar(255) DEFAULT '' COMMENT '副标题',
  `img` varchar(255) NOT NULL DEFAULT '' COMMENT '文章配图',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `author` varchar(100) NOT NULL DEFAULT '' COMMENT '文章作者',
  `author_email` varchar(60) NOT NULL DEFAULT '' COMMENT '作者邮箱',
  `uptime` int(10) unsigned DEFAULT '0' COMMENT '更新时间',
  `pubtime` int(10) unsigned DEFAULT '0' COMMENT '文章发布时间',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '发布',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '文章创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  `source` varchar(100) NOT NULL DEFAULT '' COMMENT '来源',
  `source_url` varchar(255) NOT NULL DEFAULT '' COMMENT '来源URL',
  `tb1_imgurls` text COMMENT '图片集合',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_node_id` (`node_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章';

-- -----------------------------
-- Records of `rrz_articles`
-- -----------------------------
INSERT INTO `rrz_articles` VALUES ('1', '16', '科技攻关带“火”冷凉蔬菜', '', '/storage/images/20220208/12514L320-0-lp.jpg', '', '　　　<img alt=\"\" src=\"/storage/images/20220208/12514L320-0.jpg\" />&nbsp;<br />\r\n　　8月，全国大部分地区从南到北，正经历着盛夏的“烧烤”模式，而在内蒙古的乌兰察布市，已经凉风习习，大有初秋的味道。由于海拔和纬度的原因，这里即便是7~9月，平均气温也不会超过25℃。气候也是一种资源，比如近几年来内蒙古乌兰察布的冷凉蔬菜种植，就是利用这里在同期与全国的温湿度的差别而迅速发展起来的。&nbsp;<br />\r\n　　创新集成技术，攻克冷凉蔬菜种植难题&nbsp;<br />\r\n　　所谓冷凉蔬菜，是指适宜在气候冷凉地区夏季生产的蔬菜，主要包括甘蓝、大白菜、胡萝卜、洋葱、马铃薯等。由于7~9月全国普遍高温，而在高海拔、高纬度地区，此时正好生长冷凉蔬菜，与南方的蔬菜错季上市，市场优势不言而喻。&nbsp;<br />\r\n　　乌兰察布市是近几年发展起来的北方夏季冷凉蔬菜基地之一，尤其是2012年由中国农科院蔬菜花卉研究所方智远院士领衔的专家团队在这里建立了全国首个以冷凉蔬菜产业为研究方向的院士专家工作站后，以甘蓝种植为主的冷凉蔬菜发展有了质的飞跃。&nbsp;<br />\r\n　　“我国的甘蓝种植主要存在三大问题，一是抗病、抗逆品种的推广，二是虫害防治效率低、化学<a>农药</a>用量大，三是水肥利用率低，用工成本高。这几年来我们的科研攻关和技术示范主要就围绕着这三个方面展开。”中国农科院蔬菜花卉研究所、“甘蓝绿色增产增效技术集成”项目主持人杨丽梅介绍。&nbsp;<br />\r\n　　在乌兰察布市兴和县曹四夭村，这里有百亩甘蓝绿色增产增效技术示范田，三个甘蓝品种：中甘21、中甘628、中甘192进行示范展示，而其中长势最好的还是方智远院士的“得意之作”——中甘21。4月20日播种，5月10日定植，大约三个月，就能看到一片绿油油的甘蓝铺在眼前，一颗颗包球紧实，而且颜色漂亮。&nbsp;<br />\r\n　　乌兰察布市科技局研究员，也是院士专家工作站在当地的科技特派员关慧明告诉我们，这片示范田的成功之处首先是品种好，中甘系列甘蓝品种抗裂、耐贮运，已经超过了韩国品种铁头系列。其次是采用了一系列绿色增产增效栽培技术，如太阳能杀虫灯、性诱剂、生物农药，以及膜下滴灌、合理密植等。“通过集成技术打出组合拳，在我们的示范田里，减少了30%的化学农药用量，减少灌溉用水30%以上，减少人工20%以上，示范品种比对照品种（铁头4号）增产8~10%，每亩增值300~500元。”关慧明说。&nbsp;<br />\r\n　　由于“甘蓝绿色高产高效技术集成模式研究与示范”的带动，仅乌兰察布一地甘蓝种植就超过4万亩。周边农户大面积示范区5个，每个农户示范区面积约100亩，并进一步辐射到河北张家口及承德地区，辐射带动总面积8~10万亩。&nbsp;<br />\r\n　　产量高品质好，农民增收有了新途径&nbsp;<br />\r\n　　甘蓝，也就是我们日常餐桌上的圆白菜，经常是以凉拌的做法为主，这就对甘蓝的口感要求很高。在冷凉蔬菜院士工作站基地，工作人员把刚摘下的“中甘21”和当地原来的主栽品种韩国的“铁头4号”分别切开让大家品尝，“铁头4号”有一种微微的辛辣口感，而“中甘21”则更加脆嫩、鲜甜，中国农业科学院副院长王汉中笑着说：“可以当水果吃了。”也许正因为这种口感上的细微差别，让我国自己选育的甘蓝品种近几年在市场上大受欢迎。&nbsp;<br />\r\n　　46岁的河北承德人赵林，原先是蔬菜销售商。2003年他开始在曹四夭村承包流转地2500亩种菜。三年前他拿出100亩地试种甘蓝，当时他种的是“中甘11”，去年他又种了“中甘21”，结果非常喜人。&nbsp;<br />\r\n　　“产量特别高，亩产达到了每亩近9000斤，品质也特别好，去年的收购价每斤达到了1.2元，别的品种最多到0.6元。收购商大多数是从京津来，远的也有苏杭甚至广东，到了地头直接问有没有&lsquo;中甘21&rsquo;，无论多少，照单全收。用膜包好了装上冷藏车就直接运走了。”&nbsp;<br />\r\n　　去年是甘蓝市场的“大年”，农民增产又增收，随着甘蓝种植面积的扩大，加上今年雨水丰沛，地里的甘蓝又是一次大丰收，但甘蓝的价格却像是坐了过山车，赵林告诉记者：“两年暴赚、一年小赚、一年持平、一年赔本赚吆喝。”这基本就是甘蓝的价格周期。据了解，今年甘蓝的地头收购价跌到了谷底，从去年的1.2元到现在的0.2元，对于这种暴跌，赵林倒显得很平静，“0.2元的价格，对&lsquo;中甘21&rsquo;这种好的品种来说，刚刚够成本，今年不行明年再来，我对这种产量高、品质好的品种还是很有信心的。”&nbsp;<br />\r\n　　加强技术支撑，让产业走的更远&nbsp;<br />\r\n　　发展优势产业，是近几年来各地经济发展，开展扶贫的主要思路，而科技对产业发展的支撑作用功不可没。除了建立院士专家工作站，在当地设立科技特派员的岗位，中国农科院蔬菜所也利用自己的专业优势，围绕农户、农场、种植大户的需求，提供远程诊断、技术培训、现场指导和试验示范。从推广新品种到科学的栽培管理，对产业的提质增效帮助很大。但是生产是一方面，而市场又是另一方面。“我们一直在思考，是技术引导产业还是市场引导产业，事实上，这两者都不能忽略，我们的农业科技给农民带来了丰收，而且还要帮助他们丰收后再增收。”中国农科院科技管理局副局长陆建忠说。&nbsp;<br />\r\n　　位于河北张家口市的崇礼区，是我国着名的滑雪胜地，由于地形地势呈现为狭长的山区，夏季凉爽而短促，也特别适合种植冷凉蔬菜。驱车沿山路走，路两旁种植的都是甘蓝，张家口市农科院蔬菜所所长苏浴源很自豪地说：“我们这里是万亩甘蓝种植带，这里的气候种什么蔬菜都长不好，除了甘蓝。老百姓也是靠种甘蓝提高收入的。”&nbsp;<br />\r\n　　马丈子村也属于这个万亩甘蓝带中，今年甘蓝价格不好，当地科技人员组织农户延期定植，5月中旬播种，到采收的时候甘蓝的收购价已经从0.2元到了0.5元，保证了不亏损。&nbsp;<br />\r\n　　“考虑到蔬菜价格在市场上的波动情况，我们在育种中会发展不同品种的不同特征，让农民们有多种选择。中甘21的品质好，我们还有最新育成的中甘588和中甘590，它们的特点是采摘时间长，长达25天，这样农民可以根据市场的变化，调整供应。”杨丽梅说。此外，由于市场比较喜欢1~2斤重左右、可以单手握住大小的甘蓝，科技人员在指导农户种植的时候，也会教他们控制水肥，不让甘蓝长得太大。&nbsp;<br />\r\n　　“冷凉蔬菜”是我国特有的概念，也面临着蔬菜产业转型升级过程中所遇到的机遇与挑战，在市场面前，科研要尊重市场规律，同时也要利用市场规律，才能发挥科技的支撑作用。 （何烨）', '', 'admin', '', '1472014307', '1472014307', 'true', '', '8月，全国大部分地区从南到北，正经历着盛夏的烧烤模式，而在内蒙古的乌兰察布市，已经凉风习习，大有初秋的味道。由于海拔和纬度的原因，这里即便是7~9月，平均气温也不会超过', '科技,攻关,带,“,火,”,冷凉,蔬菜,8月,全国,', '104', '1472014294', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('2', '16', '大蒜开始响起“涨声”　“蒜你狠”卷土重来', '', '/storage/images/20220208/12521045V-0-lp.jpg', '', '　　<img alt=\"\" src=\"/storage/images/20220208/12521045V-0.jpg\" />&nbsp;<br />\r\n　　最近，不少市民发现大蒜越来越贵了，“蒜你狠”再度回归。记者调查发现，受市场供应量减少等因素影响，眼下辽宁鞍山市场大蒜的价格比一个月前上涨三成多，最高卖到9元/500克，蒜薹也跟风涨到6元/500克左右。&nbsp;<br />\r\n　　昨日，记者走访我市一些农贸市场了解到，大蒜最贵的已经卖到9元/500克了，而一个月前还只要7元/500克。一些市民听到价格不禁咋舌：“一块钱一头，做菜省着点用吧”。为此，一些烧烤店也不舍得“随便”给顾客免费吃大蒜了。不仅如此，蒜薹价格也由一个月前的3元—4元/500克左右，涨至眼下的6元/500克左右。&nbsp;<br />\r\n　　据了解，今年1月份开始，大蒜就开始响起“涨声”，3月份大蒜最贵的时候达到过9元/500克的“历史最高点”，五六月份时新蒜上市，给大蒜价格“降温”，不过之后几个月也一直在6元—7元/500克左右的高位运行，眼下再度冲高。对于大蒜价格上涨的原因，有菜贩介绍，由于大蒜原产地减产，大蒜价格被“炒”贵，另外一些批发商“惜售”大蒜不舍得出手，也使得本就供不应求的市场再陷窘境。 （于秀琪）', '', 'admin', '', '1472014330', '1472014330', 'true', '', '最近，不少市民发现大蒜越来越贵了，蒜你狠再度回归。记者调查发现，受市场供应量减少等因素影响，眼下辽宁鞍山市场大蒜的价格比一个月前上涨三成多，最高卖到9元/500克，蒜薹', '大蒜,开始,响起,“,涨声,”,蒜你狠,卷土重来,', '148', '1472014321', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('3', '16', '甘肃景泰3100亩西红柿滞销　低至一斤一毛', '', '/storage/images/20220208/1254594054-0-lp.jpg', '', '眼下正值西红柿成熟收获的季节，然而在甘肃省景泰县草窝滩镇、芦阳镇、喜泉镇等乡镇却是另外一番景象，丰收的西红柿反而让菜农犯了愁。&nbsp;<br />\r\n　　由于今年西红柿的收购价跌至每斤不到一毛钱，与去年每斤2元的收购价形成强大的反差，景泰县3100亩西红柿严重滞销，很多菜农的西红柿最后只能喂猪喂羊，或者当垃圾倒掉。到底是什么原因造成今年的西红柿如此便宜又滞销？带着这个疑问，8月12日，记者一行驱车来到景泰县进行了调查，发现造成滞销的主要因素是受农户盲目跟风、种植数量过剩、受低温灾害等因素影响。&nbsp;<br />\r\n　　　<img border=\"0\" src=\"/storage/images/20220208/1254594054-0.jpg\" />&nbsp;<br />\r\n　　　　　　　　　　　　　　　　　　▲农户张女士手拿西红柿愁容满面&nbsp;<br />\r\n　　菜农：三分之二的西红柿没人要&nbsp;<br />\r\n　　当日中午，记者在景泰县草窝滩镇八道泉的一处西红柿收购点见到了前来卖西红柿的村民张万翔，看着摆在眼前的一筐筐西红柿，他一脸愁容，蹲在地上欲哭无泪。&nbsp;<br />\r\n　　“这些西红柿都是我们一家人凌晨4点多起来从地里采摘的，总共1000多斤，到了收购点还要挑挑拣拣，小的不要大的不要，就要3个一斤的。1000斤西红柿经过挑拣后只能卖400来斤，也就40元钱。剩下的柿子没人要就只能拉回家喂猪喂羊。”&nbsp;<br />\r\n　　张万翔说，他们村种植西红柿已经有十多年了，他们家就种了七、八亩，往年西红柿都是贩子抢着收购，今年这么低的价钱都没人来收。&nbsp;<br />\r\n　　张万翔还说，以前也有过卖价低的时候，但像今年这样难卖的情况还是头一回遇见。&nbsp;<br />\r\n　　“这么低的价格，村民连温饱都解决不了了……”。草窝滩镇猎虎山村民政助理陈启政告诉记者，由于去年西红柿价钱高，收购价在2元左右，尝到甜头的村民盲目跟风，今年他们村种植了230亩的西红柿，是去年的3倍。种植面积大，5月份时又遭受低温灾害，导致西红柿品质上不去，大小不一，外地收购商又只收购大小均匀、表面光滑的西红柿。&nbsp;<br />\r\n　　陈启政给记者算了一笔账，西红柿最便宜的育苗也要3毛钱一棵，每棵还要有一根木棍辅助种植，木棍的价格是一毛一根，算上人工、水费、肥料等，今年一斤西红柿卖到5毛钱才算不赔。但令村民们没有的想到的是，今年每斤西红柿的收购价一落千丈，平均每斤只能卖到3—4分钱，农户们都亏死了。&nbsp;<br />\r\n　　陈启政告诉记者，景泰县当地昼夜温差大，如果种植苹果、李子等果树，甜度一定好，他希望政府能在来年引导农户合理性种植，倡导农民不要盲目跟风。&nbsp;<br />\r\n　　周俊海是草窝滩镇清泉村村民，记者遇到他时，他正在西安客商收购点。见到记者，周俊海指着多半车的西红柿说：“3000斤西红柿，只卖了200元。剩余 1000多斤的西红柿都是挑出来不要的。”记者正要离开时，一位擦着眼泪的农妇从收购站点里面走了出了。记者问及原因，她哭着告诉记者，大清早，她就和儿子两人一起去地里采摘西红柿，总共摘了1000多斤。本想着拉到收购站多少能卖些钱，可是没想到刚轮到她家，收购站今天的收购总量已满，而这1000多斤的西红柿只能全部倒掉。&nbsp;<br />\r\n　　收购商：今年几乎赔钱收购&nbsp;<br />\r\n　　李发展是来自西安的收购商，在草窝滩镇清泉村收购西红柿已经有10多年，村民一直都很相信他，每年都把好的西红柿优先卖给他。&nbsp;<br />\r\n　　“今年的西红柿在全国来说，种植面值大，产量多，原本预计景泰地区的收购价不低于3毛，但是景泰今年的西红柿个头大小不一，出现畸形、结疤等状况，西红柿的品质不好，就影响到价格了。”李发展说，西安当地市场西红柿价格在4—5毛，而他把西红柿拉回去成本就已经5—6毛了，已经算是亏本了。但是李发展说他在景泰县收购西红柿10多年，乡亲们信任他，在这种时候他更应该帮一把，就算是亏本，他依然来收购西红柿。&nbsp;<br />\r\n　　李发展还提到，今年西红柿质量如此差强人意，在他认为是育苗出了问题。记者在采访时，不少菜农也认为如此。&nbsp;<br />\r\n　　记者了解到，往年每村都有不少于3家的外地收购商，而今年每村仅有一家，甚至有些村民要自己拉到县城里找收购商，由于品质问题，西红柿又不好卖，大多收购商都不愿意来收购。农牧局：积极联系外地收购商收购&nbsp;<br />\r\n　　就景泰县西红柿大面积滞销的问题，记者采访了景泰县农牧局局长方耀儒。方耀儒向记者提供了一份关于2016年景泰县西红柿种植销售情况的材料，其中提到景泰县2016年的种植面积为3100亩，较2015年的1200亩增长了1900亩。&nbsp;<br />\r\n　　当前，西红柿正值上市期，价格低迷，每公斤收购价0.1元，对群众造成极大的打击。造成价格低迷的原因主要有三点：一是去年的西红柿价格高，每公斤达 2.5元，是近十几年价格最高的一年，农户种植积极性高，面积较去年翻了一倍还多；二是因为今年5·15低温冻害，幼苗被冻伤，头茬西红柿出现不同程度畸形、品相差、残次品多，整体售价较低；三是受近期高温天气，西红柿集中成熟，而且储存期短，周边地区的西红柿也同步上市，造成难以及时销售。针对西红柿大面积滞销，方耀儒说，农牧部门会积极协调银川、兰州、西安等地收购商，及时进行收购。同时，也会引进加工企业，做到就近加工番茄酱，避免成熟西红柿腐烂，农牧局里还会动员仓储企业，进行高峰期冷藏处理，实现错峰销售，以此方式尽量减少农民的损失。 （每日甘肃网）', '', 'admin', '', '1472014499', '1472014499', 'true', '', '眼下正值西红柿成熟收获的季节，然而在甘肃省景泰县草窝滩镇、芦阳镇、喜泉镇等乡镇却是另外一番景象，丰收的西红柿反而让菜农犯了愁。 由于今年西红柿的收购价跌至每斤不到一', '甘肃,景泰,3100亩,西红柿,滞销,低,至,一斤,', '183', '1472014488', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('4', '16', '香蕉价格大跌是谣言　市场缺口致高价依旧', '', '/storage/images/20220208/1255133128-0-lp.jpg', '', '　　<img alt=\"\" src=\"/storage/images/20220208/1255133128-0.jpg\" />&nbsp;<br />\r\n　　据中国乡村之声《三农中国》报道，近期有报道称，我国国产香蕉的价格、销售量目前都出现大幅下滑。然而有分析师却表示，按往年规律，7到9月份，海南香蕉出货基本结束，正是广东、广西香蕉上市的时节，但今年受灾后，上市时间普遍推迟达2个月，这段时间中国的香蕉市场出现了缺口。　　按道理来说，香蕉供应出现缺口，也就意味着价格会上涨，那么，有媒体报道的香蕉价格大跌是真的吗？目前的香蕉行情究竟如何？面对虚虚实实的各种市场信息，蕉农们又该怎么做？&nbsp;<br />\r\n　　在广西南宁市西乡塘区，香蕉收购商黄老板告诉记者，现在海南香蕉基本收尾，广西香蕉还没有大量上市，老挝香蕉也正处在产新淡季。三个产地的香蕉好货依然有2.7-3.0元/斤的高价。总体来说，今年香蕉价高、量少。&nbsp;<br />\r\n　　黄老板：香蕉两块五、六这样。价格高了，去年没有这个价。去年大概是一块二、三。产量低，还有台风影响。质量倒是没有什么影响，还是一样的好。&nbsp;<br />\r\n　　卓创资讯分析师刘帅介绍说，今年以来，产区香蕉价格上涨不仅发生在广西和海南，广东产区也不例外。受厄尔尼诺现象影响，今年菲律宾干旱严重，香蕉行业受到重创，预计菲律宾香蕉或减产30%左右，产量将减少280万吨左右。菲律宾香蕉减产，使得进入中国的香蕉价格在近一个月时间内出现了大幅上涨。<br />\r\n　　刘帅：海南地区香蕉好货价格2.90元/斤左右，去年同期价格1.20元/斤，同比上涨141.67%；广西地区香蕉好货价格2.80元/斤，较去年同期的1.20元/斤上涨133.33%；广东徐闻曲界地区档口香蕉好货价格1.60元/斤，去年同期价格0.65元/斤，同比上涨146.15%。&nbsp;<br />\r\n　　产区价格居高不下，而销区价格也一路上扬。记者在北京新发地农产品批发市场内看到，国产香蕉最高批发价为4.7元/公斤。一位水果商贩表示，在售的众多水果中，香蕉价格上涨的幅度比较明显。卓创资讯分析师刘帅介绍说，今年香蕉价格比去年同期上涨幅度明显。&nbsp;<br />\r\n　　刘帅：目前销区市场香蕉价格也处在较高的位置，河北廊坊市场24斤装生蕉中上货源价格63元/箱，新疆九鼎市场25.5斤装生蕉好货价格75到80元/箱。受高价影响，市场销量仅有正常月份的3到4成。&nbsp;<br />\r\n　　进入8月份，产地香蕉价格持续上涨，好货价格涨到3元/斤。高价香蕉进入市场，客户难接受，批发市场销量仅有正常月份的30%到40%。广西南宁市西乡塘区香蕉收购商黄老板告诉记者，目前为止，香蕉产新量不如去年，产量锐减。&nbsp;<br />\r\n　　黄老板：再去一两个月，差不多这样。再过去一两个月就多了，就是高峰期。口感可以。量很少。现在出来的货都是很抢手的。&nbsp;<br />\r\n　　据分析师刘帅介绍，引起这次香蕉上涨的主要原因是受天气影响，导致产地货源紧缺引起的。同时，广西、广东地区香蕉延缓上市，导致目前的供应处于青黄不接的状态。&nbsp;<br />\r\n　　刘帅：7月末8月初，产地香蕉价格持续上涨主要是由产地香蕉供应紧缺引起的。受去年寒潮和霜冻影响，广西、广东地区的香蕉上市时间向后推迟，现仅少数未受影响的蕉园零星产新。海南地区进入香蕉产新尾期，产地蕉园收尾，货源供应紧张。老挝、缅甸、云南等地正处香蕉产新淡季，货源少量供应。香蕉产地货源供应处青黄不接期，供不应求使得价格持续上涨。&nbsp;<br />\r\n　　眼下，市场客商生意难做，甚至部分有暂停歇业计划，采购积极性下降，产地香蕉出货变缓。而针对有报道说，我国香蕉的价格、销售量出现大幅下滑的消息，刘帅辟谣说，产地好货价格确实小幅向下调整0.1到0.2元/斤，但香蕉整体行情并没有出现传言中0.5元/斤的大幅下跌。&nbsp;<br />\r\n　　刘帅：9月中旬以后，广西、老挝产地香蕉上市量逐渐增大，产地价格有走低可能。但由于今年广西地区香蕉单株产量较去年减少20%到30%，卓创资讯预计今年香蕉价格不会低于去年同期。&nbsp;<br />\r\n　　面对目前香蕉的高价位，刘帅建议蕉农，尽量通过控制施肥和浇水，让香蕉赶在10月1日前上市，青黄不接期，蕉农收益会更高，而十月以后上市的香蕉，则应注意培育精品。&nbsp;<br />\r\n　　刘帅：10月以后上市的蕉农，注重蕉园管理，提高香蕉质量，今年产地香蕉好货偏少，精品蕉会卖出更高价格。（三农中国）', '', 'admin', '', '1472014513', '1472014513', 'true', '', '据中国乡村之声《三农中国》报道，近期有报道称，我国国产香蕉的价格、销售量目前都出现大幅下滑。然而有分析师却表示，按往年规律，7到9月份，海南香蕉出货基本结束，正是广', '香蕉,价格,大跌,是,谣言,市场,缺口,致,高价,', '165', '1472014505', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('5', '17', '山药遭雨灾减产　一月后价格或有所上涨', '', '/storage/images/20220208/12553C631-0-lp.jpg', '', '近年来，山药由于其富含多种维生素、氨基酸和矿物质的原因，成为人们养生保健的佳品。目前，全国山药主产区的山药正处于生长期，但是一场场的大雨让不少地势低洼的地区山药被淹没，减产严重。&nbsp;<br />\r\n　　　　&nbsp;　　　　<img alt=\"山药遭雨灾减产 一月后价格或有所上涨\" src=\"/storage/images/20220208/12553C631-0.jpg\" />&nbsp;<br />\r\n　　在河南商丘，记者了解到，近段时间由于雨水过大，导致该地区山药的被淹面积达到了50%，不少种植户都苦不堪言。而不只是农户，经销商也成为此次大雨最大的受害者。据悉，现在正是山药的生长期，再有一个月，新山药就要大量上市了，但是河南山药经销商王明的脸上，却看不到一丝笑容。她告诉记者，前一阵子接连不断的阴雨天气，给山药的生长“浇了一盆冷水”。王明告诉记者，近日的大雨不仅给山药带来大面积减产，还毁坏了大量农田。&nbsp;<br />\r\n　　在河北、山东等地，大约有30%的山药被淹。山药经销商孙雪涛痛心表示，在山药主产区，农民这一年都白忙活了。孙雪涛说：“因为我们这个地区，主要以山药为经济来源，有的种十亩，有的种十几亩，有的种一百多亩。一旦折了沟之后，山药的产量上不去，第二卖不到什么好价格，今年一年就白忙。”孙雪涛告诉记者，被淹的山药，根部会非常容易腐烂，外形也粗细不均。现如今，我国受损的山药已经占到了全国总产量的15%。山药品质的下降，直接影响了收购商和销售商的热情，目前市场上山药的销售情况非常不乐观。&nbsp;<br />\r\n　　卓创分析师王敏介绍，从目前情况来看，山东、河北等地的山药价格，并没有因为质量下降而产生大的变化。但是，一个月以后新山药上市，价格可能会因为货源变少而有所上涨。&nbsp;<br />\r\n　　记者在采访中了解到，山药主产区的很多种植户都已经对未来的收入失去了信心，大家只希望把损失尽量降到最低。对此，卓创资讯分析师王敏建议种植户，不要灰心，要时刻关注市场需求，存储优质货源，规避价格风险。同时，农户在种植山药时，特别是在雨水季节，每次大的降雨后，应及时挖沟排水，尽量避免田间积水，保持土壤空气流通，以此来规避降雨带来的风险。&nbsp;<br />\r\n　　相关链接&nbsp;<br />\r\n　　山药的益处&nbsp;<br />\r\n　　药不仅有“神仙之食”的美誉，还有“食物药”的功效。山药含有淀粉酶、多酚氧化酶等物质，有利于脾胃消化吸收；山药含有大量的黏液蛋白、维生素及微量元素，能有效阻止血脂在血管壁的沉淀，预防心血管疾病，有延年益寿的功效。最佳吃法是蒸着吃、做汤喝、炒菜均可。蒸着吃，营养损失最小。与此同时，山药性平味甘，有益胃气、止血、托痘疹等功效，可用于脾胃虚弱、食欲减退、少气乏力等症。此外，现代又发现其可用于佝偻病、高血脂症、胃癌、子宫颈癌的防治。 （中国商务新闻网）', '', 'admin', '', '1472014536', '1472014536', 'true', '', '近年来，山药由于其富含多种维生素、氨基酸和矿物质的原因，成为人们养生保健的佳品。目前，全国山药主产区的山药正处于生长期，但是一场场的大雨让不少地势低洼的地区山药被', '山药,遭雨,灾,减产,一,月后,价格,或,有所,', '51', '1472014527', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('6', '17', '中国十大最脏果蔬排行　葡萄含有15种农药成分', '', '/storage/images/20220208/1255543W6-0-lp.jpg', '', '　市面上的果蔬色泽鲜艳十分诱人，但是为了保证产量，在农作物种植的过程中经常使用一些农药杀虫剂。这些农药成分一部分会残留在水果蔬菜上，科学家经过化验，选出了十种最脏的水果蔬菜，一起来看看吧。&nbsp;<br />\r\n　　第10名：辣椒&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122093\" src=\"/storage/images/20220208/1255543W6-0.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　67%的辣椒样品中都含有可被检测到的农药残余，即使在经过水洗或者剥皮后仍然如此。&nbsp;<br />\r\n　　第9名：圣女果&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122094\" src=\"/storage/images/20220208/12555440J-1.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　一份圣女果样品中可以检测出13种不同的杀虫剂。&nbsp;<br />\r\n　　第8名：土豆&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122095\" src=\"/storage/images/20220208/1255541D7-2.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　与其他粮食作物相比，土豆中的农药残留重量明显偏高。&nbsp;<br />\r\n　　第7名：甜椒&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122096\" src=\"/storage/images/20220208/1255544Q3-3.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　像葡萄一样，一个甜椒样品就包含15种不同的农药残余物。&nbsp;<br />\r\n　　第6名：菠菜&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122097\" src=\"/storage/images/20220208/125554N17-4.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　菠菜是受农药残余污染最严重的蔬菜之一。&nbsp;<br />\r\n　　第5名：桃子&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122098\" src=\"/storage/images/20220208/1255544417-5.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　含有的杀虫剂较多。EWG在报告中强调：杀虫剂显然是有毒的，它们是为了杀死对农作物生长不利的活体害虫、杂草和真菌等。剥皮食用最安全。&nbsp;<br />\r\n　　第4名：芹菜&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122099\" src=\"/storage/images/20220208/12555412X-6.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　一份芹菜样本中能检测出13种不同的农药。&nbsp;<br />\r\n　　第3名：葡萄&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122100\" src=\"/storage/images/20220208/1255542944-7.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　一个葡萄样品里就能检测出15种农药残余成分。在含有的农药种类方面，葡萄位居榜首，总共含有64种不同的化学物质。&nbsp;<br />\r\n　　第2名：草莓&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122101\" src=\"/storage/images/20220208/1255541C1-8.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　正确的洗涤方法是：草莓不要去叶头，放入水中浸泡十五分钟，如此可让大多数的农药随著水溶解;而后将草莓去叶子，放入盐水中泡五分钟，再用清水冲洗，即可食用，并且应尽量避免用手搓揉，也不需使用清洁剂。&nbsp;<br />\r\n　　第1名：苹果&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122102\" src=\"/storage/images/20220208/1255546252-9.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　苹果最好削皮吃，吃苹果最好少吃果核周围的部分，因为果核的缝隙会导致农药渗入。&nbsp;<br />\r\n　　在农药的帮忙下，这些水果蔬菜才能够长得又大又好，不过也不用太担心，大部分的农药都会随水溶解，只要清洗方法得当，就完全不用担心了。 （科技讯）', '', 'admin', '', '1472014554', '1472014554', 'true', '', '市面上的果蔬色泽鲜艳十分诱人，但是为了保证产量，在农作物种植的过程中经常使用一些农药杀虫剂。这些农药成分一部分会残留在水果蔬菜上，科学家经过化验，选出了十种最脏的', '中国,十大,最脏,果蔬,排行,葡萄,含有,15种,市,', '135', '1472014542', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('7', '17', '山药遭雨灾减产　一月后价格或有所上涨', '', '/storage/images/20220208/12553C631-0-lp.jpg', '', '近年来，山药由于其富含多种维生素、氨基酸和矿物质的原因，成为人们养生保健的佳品。目前，全国山药主产区的山药正处于生长期，但是一场场的大雨让不少地势低洼的地区山药被淹没，减产严重。&nbsp;<br />\r\n　　　　&nbsp;　　　　<img alt=\"山药遭雨灾减产 一月后价格或有所上涨\" src=\"/storage/images/20220208/12553C631-0.jpg\" />&nbsp;<br />\r\n　　在河南商丘，记者了解到，近段时间由于雨水过大，导致该地区山药的被淹面积达到了50%，不少种植户都苦不堪言。而不只是农户，经销商也成为此次大雨最大的受害者。据悉，现在正是山药的生长期，再有一个月，新山药就要大量上市了，但是河南山药经销商王明的脸上，却看不到一丝笑容。她告诉记者，前一阵子接连不断的阴雨天气，给山药的生长“浇了一盆冷水”。王明告诉记者，近日的大雨不仅给山药带来大面积减产，还毁坏了大量农田。&nbsp;<br />\r\n　　在河北、山东等地，大约有30%的山药被淹。山药经销商孙雪涛痛心表示，在山药主产区，农民这一年都白忙活了。孙雪涛说：“因为我们这个地区，主要以山药为经济来源，有的种十亩，有的种十几亩，有的种一百多亩。一旦折了沟之后，山药的产量上不去，第二卖不到什么好价格，今年一年就白忙。”孙雪涛告诉记者，被淹的山药，根部会非常容易腐烂，外形也粗细不均。现如今，我国受损的山药已经占到了全国总产量的15%。山药品质的下降，直接影响了收购商和销售商的热情，目前市场上山药的销售情况非常不乐观。&nbsp;<br />\r\n　　卓创分析师王敏介绍，从目前情况来看，山东、河北等地的山药价格，并没有因为质量下降而产生大的变化。但是，一个月以后新山药上市，价格可能会因为货源变少而有所上涨。&nbsp;<br />\r\n　　记者在采访中了解到，山药主产区的很多种植户都已经对未来的收入失去了信心，大家只希望把损失尽量降到最低。对此，卓创资讯分析师王敏建议种植户，不要灰心，要时刻关注市场需求，存储优质货源，规避价格风险。同时，农户在种植山药时，特别是在雨水季节，每次大的降雨后，应及时挖沟排水，尽量避免田间积水，保持土壤空气流通，以此来规避降雨带来的风险。&nbsp;<br />\r\n　　相关链接&nbsp;<br />\r\n　　山药的益处&nbsp;<br />\r\n　　药不仅有“神仙之食”的美誉，还有“食物药”的功效。山药含有淀粉酶、多酚氧化酶等物质，有利于脾胃消化吸收；山药含有大量的黏液蛋白、维生素及微量元素，能有效阻止血脂在血管壁的沉淀，预防心血管疾病，有延年益寿的功效。最佳吃法是蒸着吃、做汤喝、炒菜均可。蒸着吃，营养损失最小。与此同时，山药性平味甘，有益胃气、止血、托痘疹等功效，可用于脾胃虚弱、食欲减退、少气乏力等症。此外，现代又发现其可用于佝偻病、高血脂症、胃癌、子宫颈癌的防治。 （中国商务新闻网）', '', 'admin', '', '1472014536', '1472014536', 'true', '', '近年来，山药由于其富含多种维生素、氨基酸和矿物质的原因，成为人们养生保健的佳品。目前，全国山药主产区的山药正处于生长期，但是一场场的大雨让不少地势低洼的地区山药被', '山药,遭雨,灾,减产,一,月后,价格,或,有所,', '51', '1472014527', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('8', '17', '中国十大最脏果蔬排行　葡萄含有15种农药成分', '', '/storage/images/20220208/1255543W6-0-lp.jpg', '', '　市面上的果蔬色泽鲜艳十分诱人，但是为了保证产量，在农作物种植的过程中经常使用一些农药杀虫剂。这些农药成分一部分会残留在水果蔬菜上，科学家经过化验，选出了十种最脏的水果蔬菜，一起来看看吧。&nbsp;<br />\r\n　　第10名：辣椒&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122093\" src=\"/storage/images/20220208/1255543W6-0.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　67%的辣椒样品中都含有可被检测到的农药残余，即使在经过水洗或者剥皮后仍然如此。&nbsp;<br />\r\n　　第9名：圣女果&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122094\" src=\"/storage/images/20220208/12555440J-1.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　一份圣女果样品中可以检测出13种不同的杀虫剂。&nbsp;<br />\r\n　　第8名：土豆&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122095\" src=\"/storage/images/20220208/1255541D7-2.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　与其他粮食作物相比，土豆中的农药残留重量明显偏高。&nbsp;<br />\r\n　　第7名：甜椒&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122096\" src=\"/storage/images/20220208/1255544Q3-3.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　像葡萄一样，一个甜椒样品就包含15种不同的农药残余物。&nbsp;<br />\r\n　　第6名：菠菜&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122097\" src=\"/storage/images/20220208/125554N17-4.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　菠菜是受农药残余污染最严重的蔬菜之一。&nbsp;<br />\r\n　　第5名：桃子&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122098\" src=\"/storage/images/20220208/1255544417-5.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　含有的杀虫剂较多。EWG在报告中强调：杀虫剂显然是有毒的，它们是为了杀死对农作物生长不利的活体害虫、杂草和真菌等。剥皮食用最安全。&nbsp;<br />\r\n　　第4名：芹菜&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122099\" src=\"/storage/images/20220208/12555412X-6.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　一份芹菜样本中能检测出13种不同的农药。&nbsp;<br />\r\n　　第3名：葡萄&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122100\" src=\"/storage/images/20220208/1255542944-7.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　一个葡萄样品里就能检测出15种农药残余成分。在含有的农药种类方面，葡萄位居榜首，总共含有64种不同的化学物质。&nbsp;<br />\r\n　　第2名：草莓&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122101\" src=\"/storage/images/20220208/1255541C1-8.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　正确的洗涤方法是：草莓不要去叶头，放入水中浸泡十五分钟，如此可让大多数的农药随著水溶解;而后将草莓去叶子，放入盐水中泡五分钟，再用清水冲洗，即可食用，并且应尽量避免用手搓揉，也不需使用清洁剂。&nbsp;<br />\r\n　　第1名：苹果&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122102\" src=\"/storage/images/20220208/1255546252-9.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　苹果最好削皮吃，吃苹果最好少吃果核周围的部分，因为果核的缝隙会导致农药渗入。&nbsp;<br />\r\n　　在农药的帮忙下，这些水果蔬菜才能够长得又大又好，不过也不用太担心，大部分的农药都会随水溶解，只要清洗方法得当，就完全不用担心了。 （科技讯）', '', 'admin', '', '1472014554', '1472014554', 'true', '', '市面上的果蔬色泽鲜艳十分诱人，但是为了保证产量，在农作物种植的过程中经常使用一些农药杀虫剂。这些农药成分一部分会残留在水果蔬菜上，科学家经过化验，选出了十种最脏的', '中国,十大,最脏,果蔬,排行,葡萄,含有,15种,市,', '135', '1472014542', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('9', '17', '山药遭雨灾减产　一月后价格或有所上涨', '', '/storage/images/20220208/12553C631-0-lp.jpg', '', '近年来，山药由于其富含多种维生素、氨基酸和矿物质的原因，成为人们养生保健的佳品。目前，全国山药主产区的山药正处于生长期，但是一场场的大雨让不少地势低洼的地区山药被淹没，减产严重。&nbsp;<br />\r\n　　　　&nbsp;　　　　<img alt=\"山药遭雨灾减产 一月后价格或有所上涨\" src=\"/storage/images/20220208/12553C631-0.jpg\" />&nbsp;<br />\r\n　　在河南商丘，记者了解到，近段时间由于雨水过大，导致该地区山药的被淹面积达到了50%，不少种植户都苦不堪言。而不只是农户，经销商也成为此次大雨最大的受害者。据悉，现在正是山药的生长期，再有一个月，新山药就要大量上市了，但是河南山药经销商王明的脸上，却看不到一丝笑容。她告诉记者，前一阵子接连不断的阴雨天气，给山药的生长“浇了一盆冷水”。王明告诉记者，近日的大雨不仅给山药带来大面积减产，还毁坏了大量农田。&nbsp;<br />\r\n　　在河北、山东等地，大约有30%的山药被淹。山药经销商孙雪涛痛心表示，在山药主产区，农民这一年都白忙活了。孙雪涛说：“因为我们这个地区，主要以山药为经济来源，有的种十亩，有的种十几亩，有的种一百多亩。一旦折了沟之后，山药的产量上不去，第二卖不到什么好价格，今年一年就白忙。”孙雪涛告诉记者，被淹的山药，根部会非常容易腐烂，外形也粗细不均。现如今，我国受损的山药已经占到了全国总产量的15%。山药品质的下降，直接影响了收购商和销售商的热情，目前市场上山药的销售情况非常不乐观。&nbsp;<br />\r\n　　卓创分析师王敏介绍，从目前情况来看，山东、河北等地的山药价格，并没有因为质量下降而产生大的变化。但是，一个月以后新山药上市，价格可能会因为货源变少而有所上涨。&nbsp;<br />\r\n　　记者在采访中了解到，山药主产区的很多种植户都已经对未来的收入失去了信心，大家只希望把损失尽量降到最低。对此，卓创资讯分析师王敏建议种植户，不要灰心，要时刻关注市场需求，存储优质货源，规避价格风险。同时，农户在种植山药时，特别是在雨水季节，每次大的降雨后，应及时挖沟排水，尽量避免田间积水，保持土壤空气流通，以此来规避降雨带来的风险。&nbsp;<br />\r\n　　相关链接&nbsp;<br />\r\n　　山药的益处&nbsp;<br />\r\n　　药不仅有“神仙之食”的美誉，还有“食物药”的功效。山药含有淀粉酶、多酚氧化酶等物质，有利于脾胃消化吸收；山药含有大量的黏液蛋白、维生素及微量元素，能有效阻止血脂在血管壁的沉淀，预防心血管疾病，有延年益寿的功效。最佳吃法是蒸着吃、做汤喝、炒菜均可。蒸着吃，营养损失最小。与此同时，山药性平味甘，有益胃气、止血、托痘疹等功效，可用于脾胃虚弱、食欲减退、少气乏力等症。此外，现代又发现其可用于佝偻病、高血脂症、胃癌、子宫颈癌的防治。 （中国商务新闻网）', '', 'admin', '', '1472014536', '1472014536', 'true', '', '近年来，山药由于其富含多种维生素、氨基酸和矿物质的原因，成为人们养生保健的佳品。目前，全国山药主产区的山药正处于生长期，但是一场场的大雨让不少地势低洼的地区山药被', '山药,遭雨,灾,减产,一,月后,价格,或,有所,', '51', '1472014527', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('10', '17', '中国十大最脏果蔬排行　葡萄含有15种农药成分', '', '/storage/images/20220208/1255543W6-0-lp.jpg', '', '　市面上的果蔬色泽鲜艳十分诱人，但是为了保证产量，在农作物种植的过程中经常使用一些农药杀虫剂。这些农药成分一部分会残留在水果蔬菜上，科学家经过化验，选出了十种最脏的水果蔬菜，一起来看看吧。&nbsp;<br />\r\n　　第10名：辣椒&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122093\" src=\"/storage/images/20220208/1255543W6-0.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　67%的辣椒样品中都含有可被检测到的农药残余，即使在经过水洗或者剥皮后仍然如此。&nbsp;<br />\r\n　　第9名：圣女果&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122094\" src=\"/storage/images/20220208/12555440J-1.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　一份圣女果样品中可以检测出13种不同的杀虫剂。&nbsp;<br />\r\n　　第8名：土豆&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122095\" src=\"/storage/images/20220208/1255541D7-2.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　与其他粮食作物相比，土豆中的农药残留重量明显偏高。&nbsp;<br />\r\n　　第7名：甜椒&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122096\" src=\"/storage/images/20220208/1255544Q3-3.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　像葡萄一样，一个甜椒样品就包含15种不同的农药残余物。&nbsp;<br />\r\n　　第6名：菠菜&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122097\" src=\"/storage/images/20220208/125554N17-4.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　菠菜是受农药残余污染最严重的蔬菜之一。&nbsp;<br />\r\n　　第5名：桃子&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122098\" src=\"/storage/images/20220208/1255544417-5.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　含有的杀虫剂较多。EWG在报告中强调：杀虫剂显然是有毒的，它们是为了杀死对农作物生长不利的活体害虫、杂草和真菌等。剥皮食用最安全。&nbsp;<br />\r\n　　第4名：芹菜&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122099\" src=\"/storage/images/20220208/12555412X-6.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　一份芹菜样本中能检测出13种不同的农药。&nbsp;<br />\r\n　　第3名：葡萄&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122100\" src=\"/storage/images/20220208/1255542944-7.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　一个葡萄样品里就能检测出15种农药残余成分。在含有的农药种类方面，葡萄位居榜首，总共含有64种不同的化学物质。&nbsp;<br />\r\n　　第2名：草莓&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122101\" src=\"/storage/images/20220208/1255541C1-8.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　正确的洗涤方法是：草莓不要去叶头，放入水中浸泡十五分钟，如此可让大多数的农药随著水溶解;而后将草莓去叶子，放入盐水中泡五分钟，再用清水冲洗，即可食用，并且应尽量避免用手搓揉，也不需使用清洁剂。&nbsp;<br />\r\n　　第1名：苹果&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122102\" src=\"/storage/images/20220208/1255546252-9.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　苹果最好削皮吃，吃苹果最好少吃果核周围的部分，因为果核的缝隙会导致农药渗入。&nbsp;<br />\r\n　　在农药的帮忙下，这些水果蔬菜才能够长得又大又好，不过也不用太担心，大部分的农药都会随水溶解，只要清洗方法得当，就完全不用担心了。 （科技讯）', '', 'admin', '', '1472014554', '1472014554', 'true', '', '市面上的果蔬色泽鲜艳十分诱人，但是为了保证产量，在农作物种植的过程中经常使用一些农药杀虫剂。这些农药成分一部分会残留在水果蔬菜上，科学家经过化验，选出了十种最脏的', '中国,十大,最脏,果蔬,排行,葡萄,含有,15种,市,', '135', '1472014542', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('11', '17', '山药遭雨灾减产　一月后价格或有所上涨', '', '/storage/images/20220208/12553C631-0-lp.jpg', '', '近年来，山药由于其富含多种维生素、氨基酸和矿物质的原因，成为人们养生保健的佳品。目前，全国山药主产区的山药正处于生长期，但是一场场的大雨让不少地势低洼的地区山药被淹没，减产严重。&nbsp;<br />\r\n　　　　&nbsp;　　　　<img alt=\"山药遭雨灾减产 一月后价格或有所上涨\" src=\"/storage/images/20220208/12553C631-0.jpg\" />&nbsp;<br />\r\n　　在河南商丘，记者了解到，近段时间由于雨水过大，导致该地区山药的被淹面积达到了50%，不少种植户都苦不堪言。而不只是农户，经销商也成为此次大雨最大的受害者。据悉，现在正是山药的生长期，再有一个月，新山药就要大量上市了，但是河南山药经销商王明的脸上，却看不到一丝笑容。她告诉记者，前一阵子接连不断的阴雨天气，给山药的生长“浇了一盆冷水”。王明告诉记者，近日的大雨不仅给山药带来大面积减产，还毁坏了大量农田。&nbsp;<br />\r\n　　在河北、山东等地，大约有30%的山药被淹。山药经销商孙雪涛痛心表示，在山药主产区，农民这一年都白忙活了。孙雪涛说：“因为我们这个地区，主要以山药为经济来源，有的种十亩，有的种十几亩，有的种一百多亩。一旦折了沟之后，山药的产量上不去，第二卖不到什么好价格，今年一年就白忙。”孙雪涛告诉记者，被淹的山药，根部会非常容易腐烂，外形也粗细不均。现如今，我国受损的山药已经占到了全国总产量的15%。山药品质的下降，直接影响了收购商和销售商的热情，目前市场上山药的销售情况非常不乐观。&nbsp;<br />\r\n　　卓创分析师王敏介绍，从目前情况来看，山东、河北等地的山药价格，并没有因为质量下降而产生大的变化。但是，一个月以后新山药上市，价格可能会因为货源变少而有所上涨。&nbsp;<br />\r\n　　记者在采访中了解到，山药主产区的很多种植户都已经对未来的收入失去了信心，大家只希望把损失尽量降到最低。对此，卓创资讯分析师王敏建议种植户，不要灰心，要时刻关注市场需求，存储优质货源，规避价格风险。同时，农户在种植山药时，特别是在雨水季节，每次大的降雨后，应及时挖沟排水，尽量避免田间积水，保持土壤空气流通，以此来规避降雨带来的风险。&nbsp;<br />\r\n　　相关链接&nbsp;<br />\r\n　　山药的益处&nbsp;<br />\r\n　　药不仅有“神仙之食”的美誉，还有“食物药”的功效。山药含有淀粉酶、多酚氧化酶等物质，有利于脾胃消化吸收；山药含有大量的黏液蛋白、维生素及微量元素，能有效阻止血脂在血管壁的沉淀，预防心血管疾病，有延年益寿的功效。最佳吃法是蒸着吃、做汤喝、炒菜均可。蒸着吃，营养损失最小。与此同时，山药性平味甘，有益胃气、止血、托痘疹等功效，可用于脾胃虚弱、食欲减退、少气乏力等症。此外，现代又发现其可用于佝偻病、高血脂症、胃癌、子宫颈癌的防治。 （中国商务新闻网）', '', 'admin', '', '1472014536', '1472014536', 'true', '', '近年来，山药由于其富含多种维生素、氨基酸和矿物质的原因，成为人们养生保健的佳品。目前，全国山药主产区的山药正处于生长期，但是一场场的大雨让不少地势低洼的地区山药被', '山药,遭雨,灾,减产,一,月后,价格,或,有所,', '51', '1472014527', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('12', '17', '中国十大最脏果蔬排行　葡萄含有15种农药成分', '', '/storage/images/20220208/1255543W6-0-lp.jpg', '', '　市面上的果蔬色泽鲜艳十分诱人，但是为了保证产量，在农作物种植的过程中经常使用一些农药杀虫剂。这些农药成分一部分会残留在水果蔬菜上，科学家经过化验，选出了十种最脏的水果蔬菜，一起来看看吧。&nbsp;<br />\r\n　　第10名：辣椒&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122093\" src=\"/storage/images/20220208/1255543W6-0.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　67%的辣椒样品中都含有可被检测到的农药残余，即使在经过水洗或者剥皮后仍然如此。&nbsp;<br />\r\n　　第9名：圣女果&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122094\" src=\"/storage/images/20220208/12555440J-1.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　一份圣女果样品中可以检测出13种不同的杀虫剂。&nbsp;<br />\r\n　　第8名：土豆&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122095\" src=\"/storage/images/20220208/1255541D7-2.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　与其他粮食作物相比，土豆中的农药残留重量明显偏高。&nbsp;<br />\r\n　　第7名：甜椒&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122096\" src=\"/storage/images/20220208/1255544Q3-3.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　像葡萄一样，一个甜椒样品就包含15种不同的农药残余物。&nbsp;<br />\r\n　　第6名：菠菜&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122097\" src=\"/storage/images/20220208/125554N17-4.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　菠菜是受农药残余污染最严重的蔬菜之一。&nbsp;<br />\r\n　　第5名：桃子&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122098\" src=\"/storage/images/20220208/1255544417-5.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　含有的杀虫剂较多。EWG在报告中强调：杀虫剂显然是有毒的，它们是为了杀死对农作物生长不利的活体害虫、杂草和真菌等。剥皮食用最安全。&nbsp;<br />\r\n　　第4名：芹菜&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122099\" src=\"/storage/images/20220208/12555412X-6.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　一份芹菜样本中能检测出13种不同的农药。&nbsp;<br />\r\n　　第3名：葡萄&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122100\" src=\"/storage/images/20220208/1255542944-7.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　一个葡萄样品里就能检测出15种农药残余成分。在含有的农药种类方面，葡萄位居榜首，总共含有64种不同的化学物质。&nbsp;<br />\r\n　　第2名：草莓&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122101\" src=\"/storage/images/20220208/1255541C1-8.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　正确的洗涤方法是：草莓不要去叶头，放入水中浸泡十五分钟，如此可让大多数的农药随著水溶解;而后将草莓去叶子，放入盐水中泡五分钟，再用清水冲洗，即可食用，并且应尽量避免用手搓揉，也不需使用清洁剂。&nbsp;<br />\r\n　　第1名：苹果&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122102\" src=\"/storage/images/20220208/1255546252-9.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　苹果最好削皮吃，吃苹果最好少吃果核周围的部分，因为果核的缝隙会导致农药渗入。&nbsp;<br />\r\n　　在农药的帮忙下，这些水果蔬菜才能够长得又大又好，不过也不用太担心，大部分的农药都会随水溶解，只要清洗方法得当，就完全不用担心了。 （科技讯）', '', 'admin', '', '1472014554', '1472014554', 'true', '', '市面上的果蔬色泽鲜艳十分诱人，但是为了保证产量，在农作物种植的过程中经常使用一些农药杀虫剂。这些农药成分一部分会残留在水果蔬菜上，科学家经过化验，选出了十种最脏的', '中国,十大,最脏,果蔬,排行,葡萄,含有,15种,市,', '135', '1472014542', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('13', '17', '山药遭雨灾减产　一月后价格或有所上涨', '', '/storage/images/20220208/12553C631-0-lp.jpg', '', '近年来，山药由于其富含多种维生素、氨基酸和矿物质的原因，成为人们养生保健的佳品。目前，全国山药主产区的山药正处于生长期，但是一场场的大雨让不少地势低洼的地区山药被淹没，减产严重。&nbsp;<br />\r\n　　　　&nbsp;　　　　<img alt=\"山药遭雨灾减产 一月后价格或有所上涨\" src=\"/storage/images/20220208/12553C631-0.jpg\" />&nbsp;<br />\r\n　　在河南商丘，记者了解到，近段时间由于雨水过大，导致该地区山药的被淹面积达到了50%，不少种植户都苦不堪言。而不只是农户，经销商也成为此次大雨最大的受害者。据悉，现在正是山药的生长期，再有一个月，新山药就要大量上市了，但是河南山药经销商王明的脸上，却看不到一丝笑容。她告诉记者，前一阵子接连不断的阴雨天气，给山药的生长“浇了一盆冷水”。王明告诉记者，近日的大雨不仅给山药带来大面积减产，还毁坏了大量农田。&nbsp;<br />\r\n　　在河北、山东等地，大约有30%的山药被淹。山药经销商孙雪涛痛心表示，在山药主产区，农民这一年都白忙活了。孙雪涛说：“因为我们这个地区，主要以山药为经济来源，有的种十亩，有的种十几亩，有的种一百多亩。一旦折了沟之后，山药的产量上不去，第二卖不到什么好价格，今年一年就白忙。”孙雪涛告诉记者，被淹的山药，根部会非常容易腐烂，外形也粗细不均。现如今，我国受损的山药已经占到了全国总产量的15%。山药品质的下降，直接影响了收购商和销售商的热情，目前市场上山药的销售情况非常不乐观。&nbsp;<br />\r\n　　卓创分析师王敏介绍，从目前情况来看，山东、河北等地的山药价格，并没有因为质量下降而产生大的变化。但是，一个月以后新山药上市，价格可能会因为货源变少而有所上涨。&nbsp;<br />\r\n　　记者在采访中了解到，山药主产区的很多种植户都已经对未来的收入失去了信心，大家只希望把损失尽量降到最低。对此，卓创资讯分析师王敏建议种植户，不要灰心，要时刻关注市场需求，存储优质货源，规避价格风险。同时，农户在种植山药时，特别是在雨水季节，每次大的降雨后，应及时挖沟排水，尽量避免田间积水，保持土壤空气流通，以此来规避降雨带来的风险。&nbsp;<br />\r\n　　相关链接&nbsp;<br />\r\n　　山药的益处&nbsp;<br />\r\n　　药不仅有“神仙之食”的美誉，还有“食物药”的功效。山药含有淀粉酶、多酚氧化酶等物质，有利于脾胃消化吸收；山药含有大量的黏液蛋白、维生素及微量元素，能有效阻止血脂在血管壁的沉淀，预防心血管疾病，有延年益寿的功效。最佳吃法是蒸着吃、做汤喝、炒菜均可。蒸着吃，营养损失最小。与此同时，山药性平味甘，有益胃气、止血、托痘疹等功效，可用于脾胃虚弱、食欲减退、少气乏力等症。此外，现代又发现其可用于佝偻病、高血脂症、胃癌、子宫颈癌的防治。 （中国商务新闻网）', '', 'admin', '', '1472014536', '1472014536', 'true', '', '近年来，山药由于其富含多种维生素、氨基酸和矿物质的原因，成为人们养生保健的佳品。目前，全国山药主产区的山药正处于生长期，但是一场场的大雨让不少地势低洼的地区山药被', '山药,遭雨,灾,减产,一,月后,价格,或,有所,', '51', '1472014527', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('14', '17', '中国十大最脏果蔬排行　葡萄含有15种农药成分', '', '/storage/images/20220208/1255543W6-0-lp.jpg', '', '　市面上的果蔬色泽鲜艳十分诱人，但是为了保证产量，在农作物种植的过程中经常使用一些农药杀虫剂。这些农药成分一部分会残留在水果蔬菜上，科学家经过化验，选出了十种最脏的水果蔬菜，一起来看看吧。&nbsp;<br />\r\n　　第10名：辣椒&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122093\" src=\"/storage/images/20220208/1255543W6-0.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　67%的辣椒样品中都含有可被检测到的农药残余，即使在经过水洗或者剥皮后仍然如此。&nbsp;<br />\r\n　　第9名：圣女果&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122094\" src=\"/storage/images/20220208/12555440J-1.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　一份圣女果样品中可以检测出13种不同的杀虫剂。&nbsp;<br />\r\n　　第8名：土豆&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122095\" src=\"/storage/images/20220208/1255541D7-2.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　与其他粮食作物相比，土豆中的农药残留重量明显偏高。&nbsp;<br />\r\n　　第7名：甜椒&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122096\" src=\"/storage/images/20220208/1255544Q3-3.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　像葡萄一样，一个甜椒样品就包含15种不同的农药残余物。&nbsp;<br />\r\n　　第6名：菠菜&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122097\" src=\"/storage/images/20220208/125554N17-4.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　菠菜是受农药残余污染最严重的蔬菜之一。&nbsp;<br />\r\n　　第5名：桃子&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122098\" src=\"/storage/images/20220208/1255544417-5.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　含有的杀虫剂较多。EWG在报告中强调：杀虫剂显然是有毒的，它们是为了杀死对农作物生长不利的活体害虫、杂草和真菌等。剥皮食用最安全。&nbsp;<br />\r\n　　第4名：芹菜&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122099\" src=\"/storage/images/20220208/12555412X-6.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　一份芹菜样本中能检测出13种不同的农药。&nbsp;<br />\r\n　　第3名：葡萄&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122100\" src=\"/storage/images/20220208/1255542944-7.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　一个葡萄样品里就能检测出15种农药残余成分。在含有的农药种类方面，葡萄位居榜首，总共含有64种不同的化学物质。&nbsp;<br />\r\n　　第2名：草莓&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122101\" src=\"/storage/images/20220208/1255541C1-8.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　正确的洗涤方法是：草莓不要去叶头，放入水中浸泡十五分钟，如此可让大多数的农药随著水溶解;而后将草莓去叶子，放入盐水中泡五分钟，再用清水冲洗，即可食用，并且应尽量避免用手搓揉，也不需使用清洁剂。&nbsp;<br />\r\n　　第1名：苹果&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122102\" src=\"/storage/images/20220208/1255546252-9.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　苹果最好削皮吃，吃苹果最好少吃果核周围的部分，因为果核的缝隙会导致农药渗入。&nbsp;<br />\r\n　　在农药的帮忙下，这些水果蔬菜才能够长得又大又好，不过也不用太担心，大部分的农药都会随水溶解，只要清洗方法得当，就完全不用担心了。 （科技讯）', '', 'admin', '', '1472014554', '1472014554', 'true', '', '市面上的果蔬色泽鲜艳十分诱人，但是为了保证产量，在农作物种植的过程中经常使用一些农药杀虫剂。这些农药成分一部分会残留在水果蔬菜上，科学家经过化验，选出了十种最脏的', '中国,十大,最脏,果蔬,排行,葡萄,含有,15种,市,', '135', '1472014542', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('15', '17', '山药遭雨灾减产　一月后价格或有所上涨', '', '/storage/images/20220208/12553C631-0-lp.jpg', '', '近年来，山药由于其富含多种维生素、氨基酸和矿物质的原因，成为人们养生保健的佳品。目前，全国山药主产区的山药正处于生长期，但是一场场的大雨让不少地势低洼的地区山药被淹没，减产严重。&nbsp;<br />\r\n　　　　&nbsp;　　　　<img alt=\"山药遭雨灾减产 一月后价格或有所上涨\" src=\"/storage/images/20220208/12553C631-0.jpg\" />&nbsp;<br />\r\n　　在河南商丘，记者了解到，近段时间由于雨水过大，导致该地区山药的被淹面积达到了50%，不少种植户都苦不堪言。而不只是农户，经销商也成为此次大雨最大的受害者。据悉，现在正是山药的生长期，再有一个月，新山药就要大量上市了，但是河南山药经销商王明的脸上，却看不到一丝笑容。她告诉记者，前一阵子接连不断的阴雨天气，给山药的生长“浇了一盆冷水”。王明告诉记者，近日的大雨不仅给山药带来大面积减产，还毁坏了大量农田。&nbsp;<br />\r\n　　在河北、山东等地，大约有30%的山药被淹。山药经销商孙雪涛痛心表示，在山药主产区，农民这一年都白忙活了。孙雪涛说：“因为我们这个地区，主要以山药为经济来源，有的种十亩，有的种十几亩，有的种一百多亩。一旦折了沟之后，山药的产量上不去，第二卖不到什么好价格，今年一年就白忙。”孙雪涛告诉记者，被淹的山药，根部会非常容易腐烂，外形也粗细不均。现如今，我国受损的山药已经占到了全国总产量的15%。山药品质的下降，直接影响了收购商和销售商的热情，目前市场上山药的销售情况非常不乐观。&nbsp;<br />\r\n　　卓创分析师王敏介绍，从目前情况来看，山东、河北等地的山药价格，并没有因为质量下降而产生大的变化。但是，一个月以后新山药上市，价格可能会因为货源变少而有所上涨。&nbsp;<br />\r\n　　记者在采访中了解到，山药主产区的很多种植户都已经对未来的收入失去了信心，大家只希望把损失尽量降到最低。对此，卓创资讯分析师王敏建议种植户，不要灰心，要时刻关注市场需求，存储优质货源，规避价格风险。同时，农户在种植山药时，特别是在雨水季节，每次大的降雨后，应及时挖沟排水，尽量避免田间积水，保持土壤空气流通，以此来规避降雨带来的风险。&nbsp;<br />\r\n　　相关链接&nbsp;<br />\r\n　　山药的益处&nbsp;<br />\r\n　　药不仅有“神仙之食”的美誉，还有“食物药”的功效。山药含有淀粉酶、多酚氧化酶等物质，有利于脾胃消化吸收；山药含有大量的黏液蛋白、维生素及微量元素，能有效阻止血脂在血管壁的沉淀，预防心血管疾病，有延年益寿的功效。最佳吃法是蒸着吃、做汤喝、炒菜均可。蒸着吃，营养损失最小。与此同时，山药性平味甘，有益胃气、止血、托痘疹等功效，可用于脾胃虚弱、食欲减退、少气乏力等症。此外，现代又发现其可用于佝偻病、高血脂症、胃癌、子宫颈癌的防治。 （中国商务新闻网）', '', 'admin', '', '1472014536', '1472014536', 'true', '', '近年来，山药由于其富含多种维生素、氨基酸和矿物质的原因，成为人们养生保健的佳品。目前，全国山药主产区的山药正处于生长期，但是一场场的大雨让不少地势低洼的地区山药被', '山药,遭雨,灾,减产,一,月后,价格,或,有所,', '51', '1472014527', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('16', '17', '中国十大最脏果蔬排行　葡萄含有15种农药成分', '', '/storage/images/20220208/1255543W6-0-lp.jpg', '', '　市面上的果蔬色泽鲜艳十分诱人，但是为了保证产量，在农作物种植的过程中经常使用一些农药杀虫剂。这些农药成分一部分会残留在水果蔬菜上，科学家经过化验，选出了十种最脏的水果蔬菜，一起来看看吧。&nbsp;<br />\r\n　　第10名：辣椒&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122093\" src=\"/storage/images/20220208/1255543W6-0.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　67%的辣椒样品中都含有可被检测到的农药残余，即使在经过水洗或者剥皮后仍然如此。&nbsp;<br />\r\n　　第9名：圣女果&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122094\" src=\"/storage/images/20220208/12555440J-1.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　一份圣女果样品中可以检测出13种不同的杀虫剂。&nbsp;<br />\r\n　　第8名：土豆&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122095\" src=\"/storage/images/20220208/1255541D7-2.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　与其他粮食作物相比，土豆中的农药残留重量明显偏高。&nbsp;<br />\r\n　　第7名：甜椒&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122096\" src=\"/storage/images/20220208/1255544Q3-3.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　像葡萄一样，一个甜椒样品就包含15种不同的农药残余物。&nbsp;<br />\r\n　　第6名：菠菜&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122097\" src=\"/storage/images/20220208/125554N17-4.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　菠菜是受农药残余污染最严重的蔬菜之一。&nbsp;<br />\r\n　　第5名：桃子&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122098\" src=\"/storage/images/20220208/1255544417-5.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　含有的杀虫剂较多。EWG在报告中强调：杀虫剂显然是有毒的，它们是为了杀死对农作物生长不利的活体害虫、杂草和真菌等。剥皮食用最安全。&nbsp;<br />\r\n　　第4名：芹菜&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122099\" src=\"/storage/images/20220208/12555412X-6.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　一份芹菜样本中能检测出13种不同的农药。&nbsp;<br />\r\n　　第3名：葡萄&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122100\" src=\"/storage/images/20220208/1255542944-7.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　一个葡萄样品里就能检测出15种农药残余成分。在含有的农药种类方面，葡萄位居榜首，总共含有64种不同的化学物质。&nbsp;<br />\r\n　　第2名：草莓&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122101\" src=\"/storage/images/20220208/1255541C1-8.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　正确的洗涤方法是：草莓不要去叶头，放入水中浸泡十五分钟，如此可让大多数的农药随著水溶解;而后将草莓去叶子，放入盐水中泡五分钟，再用清水冲洗，即可食用，并且应尽量避免用手搓揉，也不需使用清洁剂。&nbsp;<br />\r\n　　第1名：苹果&nbsp;<br />\r\n　　　<img alt=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" id=\"39122102\" src=\"/storage/images/20220208/1255546252-9.jpg\" title=\"中国十大最脏果蔬排行 葡萄含有15种农药成分!\" />&nbsp;<br />\r\n　　苹果最好削皮吃，吃苹果最好少吃果核周围的部分，因为果核的缝隙会导致农药渗入。&nbsp;<br />\r\n　　在农药的帮忙下，这些水果蔬菜才能够长得又大又好，不过也不用太担心，大部分的农药都会随水溶解，只要清洗方法得当，就完全不用担心了。 （科技讯）', '', 'admin', '', '1472014554', '1472014554', 'true', '', '市面上的果蔬色泽鲜艳十分诱人，但是为了保证产量，在农作物种植的过程中经常使用一些农药杀虫剂。这些农药成分一部分会残留在水果蔬菜上，科学家经过化验，选出了十种最脏的', '中国,十大,最脏,果蔬,排行,葡萄,含有,15种,市,', '138', '1472014542', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('29', '19', '成功案例', '', '/storage/images/20220208/1-160FQ64Q5537.jpg', '', '<div style=\"text-align: center;\">\r\n	<img src=\"/storage/images/20220208/1331134F0-0.jpg\" /></div>\r\n', '', 'admin', '', '1466832673', '1466832673', 'true', '', '', '成功案例,', '122', '1467967691', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('30', '19', '成功案例', '', '/storage/images/20220208/1-160FQ64P02X.jpg', '', '<div style=\"text-align: center;\">\r\n	<img src=\"/storage/images/20220208/13312a133-0.jpg\" style=\"margin: 0px auto; padding: 0px; border: 0px; max-width: 100%; color: rgb(75, 75, 75); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: center;\" /></div>\r\n', '', 'admin', '', '1466832689', '1466832689', 'true', '', '', '成功案例,', '108', '1467967676', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('31', '19', '成功案例', '', '/storage/images/20220208/1-160FQ64J5109.jpg', '', '<div style=\"text-align: center;\">\r\n	<img src=\"/storage/images/20220208/1332116407-0.jpg\" style=\"margin: 0px auto; padding: 0px; border: 0px; max-width: 100%; color: rgb(75, 75, 75); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: center; height: 788px; width: 600px;\" /></div>\r\n', '', 'admin', '', '1466832731', '1466832731', 'true', '', '', '成功案例,', '76', '1467967659', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('32', '19', '成功案例', '', '/storage/images/20220208/1-160FQ64HQ36.jpg', '', '<div style=\"text-align: center;\">\r\n	<img src=\"/storage/images/20220208/164I3F53-0.jpg\" /><br />\r\n	汽车防盗报警器是伴随汽车业的崛起而诞生的，为了应付汽车被盗或车零部件如：汽车音响抡胎、蓄电池等及车内物品的被盗，人们最初普遏使用的是机械式防盗器 具，如方向盘锁、排挡锁等，这些虽然有效的降低了汽车直接驾驶被盗的难度，但对汽车零部件及车内物品的被盗却显得无能为力。其缺点是只防盗不报警，容易被 发现和破坏，而优点是价格比较低廉，适合所有车辆使用，井且不需要车辆供电系统的支持，所以被人们采纳现在广泛使用的遥控汽车防盗报警器(也称报警系 统〕.是时下最流行而且普及率最高的电子防盗报警系统。</div>\r\n', '', 'admin', '', '1466832749', '1466832749', 'true', '', '汽车防盗报警器是伴随汽车业的崛起而诞生的，为了应付汽车被盗或车零部件如：汽车音响抡胎、蓄电池等及车内物品的被盗，人们最初普遏使用的是机械式防盗器 具，如方向盘锁、排', '成功案例,', '96', '1468391547', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('33', '20', '成功案例', '', '/storage/images/20220208/1-160FQ64AT58.jpg', '', '<div style=\"text-align: center;\">\r\n	<img src=\"/storage/images/20220208/13353C3I-0.jpg\" style=\"margin: 0px auto; padding: 0px; border: 0px; max-width: 100%; color: rgb(75, 75, 75); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: center;\" /></div>\r\n', '', 'admin', '', '1466832936', '1466832936', 'true', '', '', '成功案例,', '114', '1467967610', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('34', '20', '成功案例', '', '/storage/images/20220208/1-160FQ6463Y40.jpg', '', '<div style=\"text-align: center;\">\r\n	<img src=\"/storage/images/20220208/1335553107-0.jpg\" style=\"margin: 0px auto; padding: 0px; border: 0px; max-width: 100%; color: rgb(75, 75, 75); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: center;\" /></div>\r\n', '', 'admin', '', '1466832955', '1466832955', 'true', '', '', '成功案例,', '181', '1467967592', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('35', '22', '什么叫万能钥匙，怎么才能开万把锁？', '', '/storage/images/20220208/12514L320-0-lp.jpg', '', '俗话说，“一把钥匙开一把锁”，它不仅是指钥匙与锁之间的专一性，更表明晰锁的安全性。但记者近来在商场上查询发现，一把通常的钥匙能翻开多把锁的状况并不罕见，特别是在那些同一类型的锁之间。<br />\r\n业内人士表明，目前商场上有部分价低质劣的锁，其出产工艺底子不符合标准，防盗功能极差。它们的存在现已危害了全部锁具职业的开展。<br />\r\n有关部门也提示消费者，在采购锁具时，应挑选闻名和正规公司的产品。一起，如因锁具质量疑问造成财产损失的，受害者可凭有用依据，经过法令路径，追查经销商或出产公司的职责。<br />\r\n“万能钥匙”为何能开万把锁<br />\r\n锁具商场产品质量堪忧亟待进步准入门槛<br />\r\n一把旧钥匙开了4把新锁<br />\r\n家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！<br />\r\n愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！<br />\r\n记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”<br />\r\n为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。<br />\r\n传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。<br />\r\n记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”<br />\r\n记者提出想试试这些锁牢不牢靠，老板赞同了。当着老板的面，记者随意取出其中一把锁的钥匙，试开其他的锁。开到第三把时，只听“咔吧”一声，本来不相匹配的钥匙轻轻松松地把锁翻开了。老板气色略变，自个拿过钥匙连开几下，每次都能翻开。<br />\r\n“巧了，肯定是巧了。”老板情急之下说：“我半个月前进了一批锁，那批锁是真的有疑问，18把锁都能相互翻开，全被我退了。这一批是新进的，应当不至于啊。”<br />\r\n网上有人售卖“万能钥匙”<br />\r\n市民小张则在杭州某论坛里看到了一个“出售正宗万能钥匙”的帖子。这马上让他联想起了自个丢的两辆自行车。小张坚持以为，“一定是小偷用万能钥匙开的锁。”<br />\r\n依据小张提示，记者找到了这个帖子。帖子里有个“图样”，有十几件形状各异的东西，大多身形细长，有钩有齿。卖家在帖子里确保，用这些东西，“通常的锁都能翻开”。', '', 'admin', '', '1466829158', '1466829158', 'true', '', '俗话说，一把钥匙开一把锁，它不仅是指钥匙与锁之间的专一性，更表明晰锁的安全性。但记者近来在商场上查询发现，一把通常的钥匙能翻开多把锁的状况并不罕见，特别是在那些同', '什么,叫,万能,钥匙,怎么,才,能开,万把,锁,', '168', '1466829147', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('36', '22', '\'十二五\'发展目标任务打造世界锁具强国', '', '/storage/images/20220208/12514L320-0-lp.jpg', '', '<p>\r\n	随着锁具行业的发展趋势急剧上升，市场需求量也逐渐增大，中国已成为全球锁具的制造和消费大国。近年来欧美、德国、日本等发达国家经济回暖，我国经济持续高速发展，出口竞争力增强，外贸出口也成倍增长。我国多类锁具市场需求不断增加，更多优秀企业不断发展，锁具行业开始进入了品牌化之路。</p>\r\n<p>\r\n	　 　全球锁具产品及技术日新月异，锁具市场已成为一个众人来掘的&#39;超级金矿&#39;。由于住宅和汽车等支柱产业的发展、人们生活水平的提高及家居装潢增多，对锁具 的需求越来越多，极大带动了锁具市场的消费需求，也促使了锁具行业突飞猛进的发展。广州锁博会顺势而下，及时满足了全球经济的应时之需。</p>\r\n<p>\r\n	　 　依靠科技进步，提高装备水平，积极采用新工艺、新材料。加大自主研发力度，加强制锁企业和设备企业的合作，确定重点，联合攻关；加大投入，特别是一些大 企业要积极引进和消化国际一流水平的加工中心，带动全行业上档次，上水平；要在表面处理和加工工艺上做文章，提高产品的耐用度和装饰性；要开发和应用新技 术、新材料，在提高产品安全性、耐用性和装饰性的同时，节能降耗，减少污染并提高效率。以市场为导向，加大调整产品结构力度，选准切入点，把高科技、高附 加值的门锁及商用锁作为研发重点，加大材料工艺、技术上与国际标准相接轨的力度。实施名牌战略。进一步提高品牌意识，狠抓质量 管理，严格质量标准，培育出一批品质过硬，推出在国内外市场具有一定影响力的锁具品牌。面对经济全球化，国内国外两个市场一起抓。不断扩大住宅、汽车、酒 店等支柱型产业和国防、安全、金融等系统对高防范性安保产品的需求应用。开创锁具市场的新局面，把小产品做成大行业，把世界锁具大国发展成为世界锁具强 国。在此大环境之下，基于上届广州锁博会的成功举办对行业的极大推动，此展会已成为发展锁具产业的有力助手，2012年广州锁博会更是得到了政府的大力扶 持，本届展会企业参展将得到高达65%的参展补贴，鼓励行业企业参展，为加快行业快速发展提供了契机。</p>\r\n', '', 'admin', '', '1466832095', '1466832095', 'true', '', '随着锁具行业的发展趋势急剧上升，市场需求量也逐渐增大，中国已成为全球锁具的制造和消费大国。近年来欧美、德国、日本等发达国家经济回暖，我国经济持续高速发展，出口竞争', '十,二五,发展目标,任务,打造,世界,锁具,强国,', '129', '1466832086', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('37', '22', '什么叫万能钥匙，怎么才能开万把锁？', '', '/storage/images/20220208/12514L320-0-lp.jpg', '', '俗话说，“一把钥匙开一把锁”，它不仅是指钥匙与锁之间的专一性，更表明晰锁的安全性。但记者近来在商场上查询发现，一把通常的钥匙能翻开多把锁的状况并不罕见，特别是在那些同一类型的锁之间。<br />\r\n业内人士表明，目前商场上有部分价低质劣的锁，其出产工艺底子不符合标准，防盗功能极差。它们的存在现已危害了全部锁具职业的开展。<br />\r\n有关部门也提示消费者，在采购锁具时，应挑选闻名和正规公司的产品。一起，如因锁具质量疑问造成财产损失的，受害者可凭有用依据，经过法令路径，追查经销商或出产公司的职责。<br />\r\n“万能钥匙”为何能开万把锁<br />\r\n锁具商场产品质量堪忧亟待进步准入门槛<br />\r\n一把旧钥匙开了4把新锁<br />\r\n家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！<br />\r\n愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！<br />\r\n记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”<br />\r\n为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。<br />\r\n传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。<br />\r\n记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”<br />\r\n记者提出想试试这些锁牢不牢靠，老板赞同了。当着老板的面，记者随意取出其中一把锁的钥匙，试开其他的锁。开到第三把时，只听“咔吧”一声，本来不相匹配的钥匙轻轻松松地把锁翻开了。老板气色略变，自个拿过钥匙连开几下，每次都能翻开。<br />\r\n“巧了，肯定是巧了。”老板情急之下说：“我半个月前进了一批锁，那批锁是真的有疑问，18把锁都能相互翻开，全被我退了。这一批是新进的，应当不至于啊。”<br />\r\n网上有人售卖“万能钥匙”<br />\r\n市民小张则在杭州某论坛里看到了一个“出售正宗万能钥匙”的帖子。这马上让他联想起了自个丢的两辆自行车。小张坚持以为，“一定是小偷用万能钥匙开的锁。”<br />\r\n依据小张提示，记者找到了这个帖子。帖子里有个“图样”，有十几件形状各异的东西，大多身形细长，有钩有齿。卖家在帖子里确保，用这些东西，“通常的锁都能翻开”。', '', 'admin', '', '1466829158', '1466829158', 'true', '', '俗话说，一把钥匙开一把锁，它不仅是指钥匙与锁之间的专一性，更表明晰锁的安全性。但记者近来在商场上查询发现，一把通常的钥匙能翻开多把锁的状况并不罕见，特别是在那些同', '什么,叫,万能,钥匙,怎么,才,能开,万把,锁,', '168', '1466829147', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('38', '22', '\'十二五\'发展目标任务打造世界锁具强国', '', '/storage/images/20220208/12514L320-0-lp.jpg', '', '<p>\r\n	随着锁具行业的发展趋势急剧上升，市场需求量也逐渐增大，中国已成为全球锁具的制造和消费大国。近年来欧美、德国、日本等发达国家经济回暖，我国经济持续高速发展，出口竞争力增强，外贸出口也成倍增长。我国多类锁具市场需求不断增加，更多优秀企业不断发展，锁具行业开始进入了品牌化之路。</p>\r\n<p>\r\n	　 　全球锁具产品及技术日新月异，锁具市场已成为一个众人来掘的&#39;超级金矿&#39;。由于住宅和汽车等支柱产业的发展、人们生活水平的提高及家居装潢增多，对锁具 的需求越来越多，极大带动了锁具市场的消费需求，也促使了锁具行业突飞猛进的发展。广州锁博会顺势而下，及时满足了全球经济的应时之需。</p>\r\n<p>\r\n	　 　依靠科技进步，提高装备水平，积极采用新工艺、新材料。加大自主研发力度，加强制锁企业和设备企业的合作，确定重点，联合攻关；加大投入，特别是一些大 企业要积极引进和消化国际一流水平的加工中心，带动全行业上档次，上水平；要在表面处理和加工工艺上做文章，提高产品的耐用度和装饰性；要开发和应用新技 术、新材料，在提高产品安全性、耐用性和装饰性的同时，节能降耗，减少污染并提高效率。以市场为导向，加大调整产品结构力度，选准切入点，把高科技、高附 加值的门锁及商用锁作为研发重点，加大材料工艺、技术上与国际标准相接轨的力度。实施名牌战略。进一步提高品牌意识，狠抓质量 管理，严格质量标准，培育出一批品质过硬，推出在国内外市场具有一定影响力的锁具品牌。面对经济全球化，国内国外两个市场一起抓。不断扩大住宅、汽车、酒 店等支柱型产业和国防、安全、金融等系统对高防范性安保产品的需求应用。开创锁具市场的新局面，把小产品做成大行业，把世界锁具大国发展成为世界锁具强 国。在此大环境之下，基于上届广州锁博会的成功举办对行业的极大推动，此展会已成为发展锁具产业的有力助手，2012年广州锁博会更是得到了政府的大力扶 持，本届展会企业参展将得到高达65%的参展补贴，鼓励行业企业参展，为加快行业快速发展提供了契机。</p>\r\n', '', 'admin', '', '1466832095', '1466832095', 'true', '', '随着锁具行业的发展趋势急剧上升，市场需求量也逐渐增大，中国已成为全球锁具的制造和消费大国。近年来欧美、德国、日本等发达国家经济回暖，我国经济持续高速发展，出口竞争', '十,二五,发展目标,任务,打造,世界,锁具,强国,', '129', '1466832086', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('39', '22', '什么叫万能钥匙，怎么才能开万把锁？', '', '/storage/images/20220208/12514L320-0-lp.jpg', '', '俗话说，“一把钥匙开一把锁”，它不仅是指钥匙与锁之间的专一性，更表明晰锁的安全性。但记者近来在商场上查询发现，一把通常的钥匙能翻开多把锁的状况并不罕见，特别是在那些同一类型的锁之间。<br />\r\n业内人士表明，目前商场上有部分价低质劣的锁，其出产工艺底子不符合标准，防盗功能极差。它们的存在现已危害了全部锁具职业的开展。<br />\r\n有关部门也提示消费者，在采购锁具时，应挑选闻名和正规公司的产品。一起，如因锁具质量疑问造成财产损失的，受害者可凭有用依据，经过法令路径，追查经销商或出产公司的职责。<br />\r\n“万能钥匙”为何能开万把锁<br />\r\n锁具商场产品质量堪忧亟待进步准入门槛<br />\r\n一把旧钥匙开了4把新锁<br />\r\n家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！<br />\r\n愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！<br />\r\n记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”<br />\r\n为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。<br />\r\n传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。<br />\r\n记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”<br />\r\n记者提出想试试这些锁牢不牢靠，老板赞同了。当着老板的面，记者随意取出其中一把锁的钥匙，试开其他的锁。开到第三把时，只听“咔吧”一声，本来不相匹配的钥匙轻轻松松地把锁翻开了。老板气色略变，自个拿过钥匙连开几下，每次都能翻开。<br />\r\n“巧了，肯定是巧了。”老板情急之下说：“我半个月前进了一批锁，那批锁是真的有疑问，18把锁都能相互翻开，全被我退了。这一批是新进的，应当不至于啊。”<br />\r\n网上有人售卖“万能钥匙”<br />\r\n市民小张则在杭州某论坛里看到了一个“出售正宗万能钥匙”的帖子。这马上让他联想起了自个丢的两辆自行车。小张坚持以为，“一定是小偷用万能钥匙开的锁。”<br />\r\n依据小张提示，记者找到了这个帖子。帖子里有个“图样”，有十几件形状各异的东西，大多身形细长，有钩有齿。卖家在帖子里确保，用这些东西，“通常的锁都能翻开”。', '', 'admin', '', '1466829158', '1466829158', 'true', '', '俗话说，一把钥匙开一把锁，它不仅是指钥匙与锁之间的专一性，更表明晰锁的安全性。但记者近来在商场上查询发现，一把通常的钥匙能翻开多把锁的状况并不罕见，特别是在那些同', '什么,叫,万能,钥匙,怎么,才,能开,万把,锁,', '168', '1466829147', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('40', '22', '\'十二五\'发展目标任务打造世界锁具强国', '', '/storage/images/20220208/12514L320-0-lp.jpg', '', '<p>\r\n	随着锁具行业的发展趋势急剧上升，市场需求量也逐渐增大，中国已成为全球锁具的制造和消费大国。近年来欧美、德国、日本等发达国家经济回暖，我国经济持续高速发展，出口竞争力增强，外贸出口也成倍增长。我国多类锁具市场需求不断增加，更多优秀企业不断发展，锁具行业开始进入了品牌化之路。</p>\r\n<p>\r\n	　 　全球锁具产品及技术日新月异，锁具市场已成为一个众人来掘的&#39;超级金矿&#39;。由于住宅和汽车等支柱产业的发展、人们生活水平的提高及家居装潢增多，对锁具 的需求越来越多，极大带动了锁具市场的消费需求，也促使了锁具行业突飞猛进的发展。广州锁博会顺势而下，及时满足了全球经济的应时之需。</p>\r\n<p>\r\n	　 　依靠科技进步，提高装备水平，积极采用新工艺、新材料。加大自主研发力度，加强制锁企业和设备企业的合作，确定重点，联合攻关；加大投入，特别是一些大 企业要积极引进和消化国际一流水平的加工中心，带动全行业上档次，上水平；要在表面处理和加工工艺上做文章，提高产品的耐用度和装饰性；要开发和应用新技 术、新材料，在提高产品安全性、耐用性和装饰性的同时，节能降耗，减少污染并提高效率。以市场为导向，加大调整产品结构力度，选准切入点，把高科技、高附 加值的门锁及商用锁作为研发重点，加大材料工艺、技术上与国际标准相接轨的力度。实施名牌战略。进一步提高品牌意识，狠抓质量 管理，严格质量标准，培育出一批品质过硬，推出在国内外市场具有一定影响力的锁具品牌。面对经济全球化，国内国外两个市场一起抓。不断扩大住宅、汽车、酒 店等支柱型产业和国防、安全、金融等系统对高防范性安保产品的需求应用。开创锁具市场的新局面，把小产品做成大行业，把世界锁具大国发展成为世界锁具强 国。在此大环境之下，基于上届广州锁博会的成功举办对行业的极大推动，此展会已成为发展锁具产业的有力助手，2012年广州锁博会更是得到了政府的大力扶 持，本届展会企业参展将得到高达65%的参展补贴，鼓励行业企业参展，为加快行业快速发展提供了契机。</p>\r\n', '', 'admin', '', '1466832095', '1466832095', 'true', '', '随着锁具行业的发展趋势急剧上升，市场需求量也逐渐增大，中国已成为全球锁具的制造和消费大国。近年来欧美、德国、日本等发达国家经济回暖，我国经济持续高速发展，出口竞争', '十,二五,发展目标,任务,打造,世界,锁具,强国,', '129', '1466832086', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('41', '22', '什么叫万能钥匙，怎么才能开万把锁？', '', '/storage/images/20220208/12514L320-0-lp.jpg', '', '俗话说，“一把钥匙开一把锁”，它不仅是指钥匙与锁之间的专一性，更表明晰锁的安全性。但记者近来在商场上查询发现，一把通常的钥匙能翻开多把锁的状况并不罕见，特别是在那些同一类型的锁之间。<br />\r\n业内人士表明，目前商场上有部分价低质劣的锁，其出产工艺底子不符合标准，防盗功能极差。它们的存在现已危害了全部锁具职业的开展。<br />\r\n有关部门也提示消费者，在采购锁具时，应挑选闻名和正规公司的产品。一起，如因锁具质量疑问造成财产损失的，受害者可凭有用依据，经过法令路径，追查经销商或出产公司的职责。<br />\r\n“万能钥匙”为何能开万把锁<br />\r\n锁具商场产品质量堪忧亟待进步准入门槛<br />\r\n一把旧钥匙开了4把新锁<br />\r\n家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！<br />\r\n愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！<br />\r\n记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”<br />\r\n为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。<br />\r\n传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。<br />\r\n记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”<br />\r\n记者提出想试试这些锁牢不牢靠，老板赞同了。当着老板的面，记者随意取出其中一把锁的钥匙，试开其他的锁。开到第三把时，只听“咔吧”一声，本来不相匹配的钥匙轻轻松松地把锁翻开了。老板气色略变，自个拿过钥匙连开几下，每次都能翻开。<br />\r\n“巧了，肯定是巧了。”老板情急之下说：“我半个月前进了一批锁，那批锁是真的有疑问，18把锁都能相互翻开，全被我退了。这一批是新进的，应当不至于啊。”<br />\r\n网上有人售卖“万能钥匙”<br />\r\n市民小张则在杭州某论坛里看到了一个“出售正宗万能钥匙”的帖子。这马上让他联想起了自个丢的两辆自行车。小张坚持以为，“一定是小偷用万能钥匙开的锁。”<br />\r\n依据小张提示，记者找到了这个帖子。帖子里有个“图样”，有十几件形状各异的东西，大多身形细长，有钩有齿。卖家在帖子里确保，用这些东西，“通常的锁都能翻开”。', '', 'admin', '', '1466829158', '1466829158', 'true', '', '俗话说，一把钥匙开一把锁，它不仅是指钥匙与锁之间的专一性，更表明晰锁的安全性。但记者近来在商场上查询发现，一把通常的钥匙能翻开多把锁的状况并不罕见，特别是在那些同', '什么,叫,万能,钥匙,怎么,才,能开,万把,锁,', '168', '1466829147', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('42', '22', '\'十二五\'发展目标任务打造世界锁具强国', '', '/storage/images/20220208/12514L320-0-lp.jpg', '', '<p>\r\n	随着锁具行业的发展趋势急剧上升，市场需求量也逐渐增大，中国已成为全球锁具的制造和消费大国。近年来欧美、德国、日本等发达国家经济回暖，我国经济持续高速发展，出口竞争力增强，外贸出口也成倍增长。我国多类锁具市场需求不断增加，更多优秀企业不断发展，锁具行业开始进入了品牌化之路。</p>\r\n<p>\r\n	　 　全球锁具产品及技术日新月异，锁具市场已成为一个众人来掘的&#39;超级金矿&#39;。由于住宅和汽车等支柱产业的发展、人们生活水平的提高及家居装潢增多，对锁具 的需求越来越多，极大带动了锁具市场的消费需求，也促使了锁具行业突飞猛进的发展。广州锁博会顺势而下，及时满足了全球经济的应时之需。</p>\r\n<p>\r\n	　 　依靠科技进步，提高装备水平，积极采用新工艺、新材料。加大自主研发力度，加强制锁企业和设备企业的合作，确定重点，联合攻关；加大投入，特别是一些大 企业要积极引进和消化国际一流水平的加工中心，带动全行业上档次，上水平；要在表面处理和加工工艺上做文章，提高产品的耐用度和装饰性；要开发和应用新技 术、新材料，在提高产品安全性、耐用性和装饰性的同时，节能降耗，减少污染并提高效率。以市场为导向，加大调整产品结构力度，选准切入点，把高科技、高附 加值的门锁及商用锁作为研发重点，加大材料工艺、技术上与国际标准相接轨的力度。实施名牌战略。进一步提高品牌意识，狠抓质量 管理，严格质量标准，培育出一批品质过硬，推出在国内外市场具有一定影响力的锁具品牌。面对经济全球化，国内国外两个市场一起抓。不断扩大住宅、汽车、酒 店等支柱型产业和国防、安全、金融等系统对高防范性安保产品的需求应用。开创锁具市场的新局面，把小产品做成大行业，把世界锁具大国发展成为世界锁具强 国。在此大环境之下，基于上届广州锁博会的成功举办对行业的极大推动，此展会已成为发展锁具产业的有力助手，2012年广州锁博会更是得到了政府的大力扶 持，本届展会企业参展将得到高达65%的参展补贴，鼓励行业企业参展，为加快行业快速发展提供了契机。</p>\r\n', '', 'admin', '', '1466832095', '1466832095', 'true', '', '随着锁具行业的发展趋势急剧上升，市场需求量也逐渐增大，中国已成为全球锁具的制造和消费大国。近年来欧美、德国、日本等发达国家经济回暖，我国经济持续高速发展，出口竞争', '十,二五,发展目标,任务,打造,世界,锁具,强国,', '129', '1466832086', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('43', '22', '什么叫万能钥匙，怎么才能开万把锁？', '', '/storage/images/20220208/12514L320-0-lp.jpg', '', '俗话说，“一把钥匙开一把锁”，它不仅是指钥匙与锁之间的专一性，更表明晰锁的安全性。但记者近来在商场上查询发现，一把通常的钥匙能翻开多把锁的状况并不罕见，特别是在那些同一类型的锁之间。<br />\r\n业内人士表明，目前商场上有部分价低质劣的锁，其出产工艺底子不符合标准，防盗功能极差。它们的存在现已危害了全部锁具职业的开展。<br />\r\n有关部门也提示消费者，在采购锁具时，应挑选闻名和正规公司的产品。一起，如因锁具质量疑问造成财产损失的，受害者可凭有用依据，经过法令路径，追查经销商或出产公司的职责。<br />\r\n“万能钥匙”为何能开万把锁<br />\r\n锁具商场产品质量堪忧亟待进步准入门槛<br />\r\n一把旧钥匙开了4把新锁<br />\r\n家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！<br />\r\n愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！<br />\r\n记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”<br />\r\n为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。<br />\r\n传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。<br />\r\n记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”<br />\r\n记者提出想试试这些锁牢不牢靠，老板赞同了。当着老板的面，记者随意取出其中一把锁的钥匙，试开其他的锁。开到第三把时，只听“咔吧”一声，本来不相匹配的钥匙轻轻松松地把锁翻开了。老板气色略变，自个拿过钥匙连开几下，每次都能翻开。<br />\r\n“巧了，肯定是巧了。”老板情急之下说：“我半个月前进了一批锁，那批锁是真的有疑问，18把锁都能相互翻开，全被我退了。这一批是新进的，应当不至于啊。”<br />\r\n网上有人售卖“万能钥匙”<br />\r\n市民小张则在杭州某论坛里看到了一个“出售正宗万能钥匙”的帖子。这马上让他联想起了自个丢的两辆自行车。小张坚持以为，“一定是小偷用万能钥匙开的锁。”<br />\r\n依据小张提示，记者找到了这个帖子。帖子里有个“图样”，有十几件形状各异的东西，大多身形细长，有钩有齿。卖家在帖子里确保，用这些东西，“通常的锁都能翻开”。', '', 'admin', '', '1466829158', '1466829158', 'true', '', '俗话说，一把钥匙开一把锁，它不仅是指钥匙与锁之间的专一性，更表明晰锁的安全性。但记者近来在商场上查询发现，一把通常的钥匙能翻开多把锁的状况并不罕见，特别是在那些同', '什么,叫,万能,钥匙,怎么,才,能开,万把,锁,', '168', '1466829147', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('44', '22', '\'十二五\'发展目标任务打造世界锁具强国', '', '/storage/images/20220208/12514L320-0-lp.jpg', '', '<p>\r\n	随着锁具行业的发展趋势急剧上升，市场需求量也逐渐增大，中国已成为全球锁具的制造和消费大国。近年来欧美、德国、日本等发达国家经济回暖，我国经济持续高速发展，出口竞争力增强，外贸出口也成倍增长。我国多类锁具市场需求不断增加，更多优秀企业不断发展，锁具行业开始进入了品牌化之路。</p>\r\n<p>\r\n	　 　全球锁具产品及技术日新月异，锁具市场已成为一个众人来掘的&#39;超级金矿&#39;。由于住宅和汽车等支柱产业的发展、人们生活水平的提高及家居装潢增多，对锁具 的需求越来越多，极大带动了锁具市场的消费需求，也促使了锁具行业突飞猛进的发展。广州锁博会顺势而下，及时满足了全球经济的应时之需。</p>\r\n<p>\r\n	　 　依靠科技进步，提高装备水平，积极采用新工艺、新材料。加大自主研发力度，加强制锁企业和设备企业的合作，确定重点，联合攻关；加大投入，特别是一些大 企业要积极引进和消化国际一流水平的加工中心，带动全行业上档次，上水平；要在表面处理和加工工艺上做文章，提高产品的耐用度和装饰性；要开发和应用新技 术、新材料，在提高产品安全性、耐用性和装饰性的同时，节能降耗，减少污染并提高效率。以市场为导向，加大调整产品结构力度，选准切入点，把高科技、高附 加值的门锁及商用锁作为研发重点，加大材料工艺、技术上与国际标准相接轨的力度。实施名牌战略。进一步提高品牌意识，狠抓质量 管理，严格质量标准，培育出一批品质过硬，推出在国内外市场具有一定影响力的锁具品牌。面对经济全球化，国内国外两个市场一起抓。不断扩大住宅、汽车、酒 店等支柱型产业和国防、安全、金融等系统对高防范性安保产品的需求应用。开创锁具市场的新局面，把小产品做成大行业，把世界锁具大国发展成为世界锁具强 国。在此大环境之下，基于上届广州锁博会的成功举办对行业的极大推动，此展会已成为发展锁具产业的有力助手，2012年广州锁博会更是得到了政府的大力扶 持，本届展会企业参展将得到高达65%的参展补贴，鼓励行业企业参展，为加快行业快速发展提供了契机。</p>\r\n', '', 'admin', '', '1466832095', '1466832095', 'true', '', '随着锁具行业的发展趋势急剧上升，市场需求量也逐渐增大，中国已成为全球锁具的制造和消费大国。近年来欧美、德国、日本等发达国家经济回暖，我国经济持续高速发展，出口竞争', '十,二五,发展目标,任务,打造,世界,锁具,强国,', '129', '1466832086', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('45', '22', '什么叫万能钥匙，怎么才能开万把锁？', '', '/storage/images/20220208/12514L320-0-lp.jpg', '', '俗话说，“一把钥匙开一把锁”，它不仅是指钥匙与锁之间的专一性，更表明晰锁的安全性。但记者近来在商场上查询发现，一把通常的钥匙能翻开多把锁的状况并不罕见，特别是在那些同一类型的锁之间。<br />\r\n业内人士表明，目前商场上有部分价低质劣的锁，其出产工艺底子不符合标准，防盗功能极差。它们的存在现已危害了全部锁具职业的开展。<br />\r\n有关部门也提示消费者，在采购锁具时，应挑选闻名和正规公司的产品。一起，如因锁具质量疑问造成财产损失的，受害者可凭有用依据，经过法令路径，追查经销商或出产公司的职责。<br />\r\n“万能钥匙”为何能开万把锁<br />\r\n锁具商场产品质量堪忧亟待进步准入门槛<br />\r\n一把旧钥匙开了4把新锁<br />\r\n家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！<br />\r\n愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！<br />\r\n记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”<br />\r\n为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。<br />\r\n传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。<br />\r\n记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”<br />\r\n记者提出想试试这些锁牢不牢靠，老板赞同了。当着老板的面，记者随意取出其中一把锁的钥匙，试开其他的锁。开到第三把时，只听“咔吧”一声，本来不相匹配的钥匙轻轻松松地把锁翻开了。老板气色略变，自个拿过钥匙连开几下，每次都能翻开。<br />\r\n“巧了，肯定是巧了。”老板情急之下说：“我半个月前进了一批锁，那批锁是真的有疑问，18把锁都能相互翻开，全被我退了。这一批是新进的，应当不至于啊。”<br />\r\n网上有人售卖“万能钥匙”<br />\r\n市民小张则在杭州某论坛里看到了一个“出售正宗万能钥匙”的帖子。这马上让他联想起了自个丢的两辆自行车。小张坚持以为，“一定是小偷用万能钥匙开的锁。”<br />\r\n依据小张提示，记者找到了这个帖子。帖子里有个“图样”，有十几件形状各异的东西，大多身形细长，有钩有齿。卖家在帖子里确保，用这些东西，“通常的锁都能翻开”。', '', 'admin', '', '1466829158', '1466829158', 'true', '', '俗话说，一把钥匙开一把锁，它不仅是指钥匙与锁之间的专一性，更表明晰锁的安全性。但记者近来在商场上查询发现，一把通常的钥匙能翻开多把锁的状况并不罕见，特别是在那些同', '什么,叫,万能,钥匙,怎么,才,能开,万把,锁,', '168', '1466829147', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('46', '22', '\'十二五\'发展目标任务打造世界锁具强国', '', '/storage/images/20220208/12514L320-0-lp.jpg', '', '<p>\r\n	随着锁具行业的发展趋势急剧上升，市场需求量也逐渐增大，中国已成为全球锁具的制造和消费大国。近年来欧美、德国、日本等发达国家经济回暖，我国经济持续高速发展，出口竞争力增强，外贸出口也成倍增长。我国多类锁具市场需求不断增加，更多优秀企业不断发展，锁具行业开始进入了品牌化之路。</p>\r\n<p>\r\n	　 　全球锁具产品及技术日新月异，锁具市场已成为一个众人来掘的&#39;超级金矿&#39;。由于住宅和汽车等支柱产业的发展、人们生活水平的提高及家居装潢增多，对锁具 的需求越来越多，极大带动了锁具市场的消费需求，也促使了锁具行业突飞猛进的发展。广州锁博会顺势而下，及时满足了全球经济的应时之需。</p>\r\n<p>\r\n	　 　依靠科技进步，提高装备水平，积极采用新工艺、新材料。加大自主研发力度，加强制锁企业和设备企业的合作，确定重点，联合攻关；加大投入，特别是一些大 企业要积极引进和消化国际一流水平的加工中心，带动全行业上档次，上水平；要在表面处理和加工工艺上做文章，提高产品的耐用度和装饰性；要开发和应用新技 术、新材料，在提高产品安全性、耐用性和装饰性的同时，节能降耗，减少污染并提高效率。以市场为导向，加大调整产品结构力度，选准切入点，把高科技、高附 加值的门锁及商用锁作为研发重点，加大材料工艺、技术上与国际标准相接轨的力度。实施名牌战略。进一步提高品牌意识，狠抓质量 管理，严格质量标准，培育出一批品质过硬，推出在国内外市场具有一定影响力的锁具品牌。面对经济全球化，国内国外两个市场一起抓。不断扩大住宅、汽车、酒 店等支柱型产业和国防、安全、金融等系统对高防范性安保产品的需求应用。开创锁具市场的新局面，把小产品做成大行业，把世界锁具大国发展成为世界锁具强 国。在此大环境之下，基于上届广州锁博会的成功举办对行业的极大推动，此展会已成为发展锁具产业的有力助手，2012年广州锁博会更是得到了政府的大力扶 持，本届展会企业参展将得到高达65%的参展补贴，鼓励行业企业参展，为加快行业快速发展提供了契机。</p>\r\n', '', 'admin', '', '1466832095', '1466832095', 'true', '', '随着锁具行业的发展趋势急剧上升，市场需求量也逐渐增大，中国已成为全球锁具的制造和消费大国。近年来欧美、德国、日本等发达国家经济回暖，我国经济持续高速发展，出口竞争', '十,二五,发展目标,任务,打造,世界,锁具,强国,', '129', '1466832086', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('47', '23', '锁具行业分析：未来竞争新高地', '', '/storage/images/20220208/12514L320-0-lp.jpg', '', '<p>\r\n	锁 具与我们和社会的关系十分密切，它关系到每个家庭、单位和公共场所的安全。随着时代的进步，各种款式、质料、结构、功能不同的专业性用锁品种层出不穷。同 时，锁具作为一种较为特殊的商品，与安全有着极其重要的关系。随着我国住宅、汽车、中高档办公楼及酒店等支柱型产业的快速发展以及国防、公安、金融等系统 对具有高防范性锁具产品需求的日益加强，高档锁具市场的前景乐观。中国国内锁具市场对生物识别和电子技术等高技术产品的份额将达到60亿美元共5000多 万套，这绝对是一块诱人的大蛋糕。</p>\r\n<p>\r\n	　　目前 国内许多制锁企业的竞争力来自于低成本，价格战打得“热火朝天”，锁业的利润却越来越薄，一些低附加值的挂锁需要几十道生产工序才能生产出来，但是一把锁 只有几分钱的利润。制锁行业急需技术和产业升级，更新品牌创新模式。锁具行业的创新，需要企业转变观念，改变以模仿为主的想法，掌握自主技术，加大设备、 技术、研发的投入和专利创新，提高产品科技含量，增加产品的差异化程度；企业应注重提升品牌意识、实施品牌战略，以此改变自身处境，抢占中高档市场份额， 促进行业健康快速发展。</p>\r\n<p>\r\n	　　因此，中国制锁 行业应该有一个具备组织性的总体目标，科技提高才能逐年不乱进步，如产品结构、产品质量、技术装备、立异能力、人才结构等等缺一不可。中国已经形成了最主 要的四大出产基地，浙江温州、广东中山、山东和上海。一些大型锁具企业开始进入开发高端智能锁具的行列，海内高档锁有增长势头。锁具产品的发展要跟随着市 场走，只要市场有需求，锁具企业必然也要去开拓、去占领高端市场。跟着我国对外开放不断深入，高档建筑发展的加快，高档锁具市场发展潜力很大，必然将会涌 现出大批的高端企业。</p>\r\n<p>\r\n	　　由于高端锁具科技 含量高、更加凸显人性化、个性化的特点，所以产品利润也比较高。加上锁具产品换代速度加快，高端锁具将逐渐成为锁具市场的主流。制锁企业应该积极采用新材 料，注重产品造型及艺术装饰性的同时，逐步运用计算机电子、信息、生物识别、纳米材料等提高前辈技术嫁接传统制锁业，努力开发有市场远景的新产品，并在使 用机能长进行突破。如住宅中高档插芯门锁系列、汽车锁系列、民用锁系列、防盗门锁系列、动弹码遥控系列、中高档机电一体化IC卡智能锁、TM卡锁、射锁卡 锁系列、生物识别特征锁系列等，都可以在工艺、技术革新上加以改革，逐步成熟。</p>\r\n', '', 'admin', '', '1466832235', '1466832235', 'true', '', '锁 具与我们和社会的关系十分密切，它关系到每个家庭、单位和公共场所的安全。随着时代的进步，各种款式、质料、结构、功能不同的专业性用锁品种层出不穷。同 时，锁具作为一', '锁具,行业分析,未来,竞争,新高地,新,高地,锁,', '200', '1466832222', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('48', '23', '规范开锁行业 有利于锁具产业发展', '', '/storage/images/20220208/12514L320-0-lp.jpg', '', '一直以来，我国开锁行业都处于非常混乱的状态。传统开锁匠的水平参差不齐，为用户开锁不成功，往往会告诉用户是锁具的质量问题，建议用户换锁，然后采用破 坏性手段开锁。而门锁出现故障或者丢了钥匙的人在请锁匠开了锁之后，也都会选择立即换锁。有时即使锁本身并没有损坏，他们也担心自家的锁会被锁匠“破 解”，被配了钥匙，而选择立刻换新锁。这种开完锁后的换锁需求一度成为了锁具零售业的主要需求之一。\r\n<p>\r\n	　　很明显，这是一种畸形的需求，源自人们对于传统开锁人员深深的不信任。长此以往，人们不但会对开锁人员失去信任，也会对锁具产品的质量失去信心，非常不利于锁具行业的发展</p>\r\n<p>\r\n	　 　2002年左右，广州出现了中国第一家在公安部门注册的专业开锁公司。2004年，北京、哈尔滨等众多城市颁布行政法规，要求规范开锁行业。随后，公安 部门备案，持证上岗的正规开锁公司开始在全国各地出现。2007年4月，公安部、国家工商行政管理总局近日联合发出通知，要求进一步加强开锁行业管理，规 范开锁经营单位经营行为。此后，更多城市开始规范开锁行业，正规的开锁行业渐渐红火起来，以至于春晚上都出现了以此为题材的小品。开锁行业逐步规范起来以 后，大家对锁具的信任感也得到了增强。</p>\r\n<p>\r\n	　 　规范开锁业之后，如果您只是丢了钥匙，并不是锁具出现故障的话，专业合法的开锁公司不会采用破坏性的手段来开锁。开锁后，大部分的锁具都可以继续使用。 虽然会损失一部分市场需求，但是这保证了锁具产品的质量声誉。市场上的锁具需求不能依靠“损坏率”来拉动。相比那些眼前利益，长远的发展更加重要。而长远 的发展无疑需要良好的质量作保障。</p>\r\n', '', 'admin', '', '1466832250', '1466832250', 'true', '', '一直以来，我国开锁行业都处于非常混乱的状态。传统开锁匠的水平参差不齐，为用户开锁不成功，往往会告诉用户是锁具的质量问题，建议用户换锁，然后采用破 坏性手段开锁。而门', '规范,开锁,行业,有利于,锁具,产业发展,一直,', '81', '1466832242', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('49', '23', '锁具行业分析：未来竞争新高地', '', '/storage/images/20220208/12514L320-0-lp.jpg', '', '<p>\r\n	锁 具与我们和社会的关系十分密切，它关系到每个家庭、单位和公共场所的安全。随着时代的进步，各种款式、质料、结构、功能不同的专业性用锁品种层出不穷。同 时，锁具作为一种较为特殊的商品，与安全有着极其重要的关系。随着我国住宅、汽车、中高档办公楼及酒店等支柱型产业的快速发展以及国防、公安、金融等系统 对具有高防范性锁具产品需求的日益加强，高档锁具市场的前景乐观。中国国内锁具市场对生物识别和电子技术等高技术产品的份额将达到60亿美元共5000多 万套，这绝对是一块诱人的大蛋糕。</p>\r\n<p>\r\n	　　目前 国内许多制锁企业的竞争力来自于低成本，价格战打得“热火朝天”，锁业的利润却越来越薄，一些低附加值的挂锁需要几十道生产工序才能生产出来，但是一把锁 只有几分钱的利润。制锁行业急需技术和产业升级，更新品牌创新模式。锁具行业的创新，需要企业转变观念，改变以模仿为主的想法，掌握自主技术，加大设备、 技术、研发的投入和专利创新，提高产品科技含量，增加产品的差异化程度；企业应注重提升品牌意识、实施品牌战略，以此改变自身处境，抢占中高档市场份额， 促进行业健康快速发展。</p>\r\n<p>\r\n	　　因此，中国制锁 行业应该有一个具备组织性的总体目标，科技提高才能逐年不乱进步，如产品结构、产品质量、技术装备、立异能力、人才结构等等缺一不可。中国已经形成了最主 要的四大出产基地，浙江温州、广东中山、山东和上海。一些大型锁具企业开始进入开发高端智能锁具的行列，海内高档锁有增长势头。锁具产品的发展要跟随着市 场走，只要市场有需求，锁具企业必然也要去开拓、去占领高端市场。跟着我国对外开放不断深入，高档建筑发展的加快，高档锁具市场发展潜力很大，必然将会涌 现出大批的高端企业。</p>\r\n<p>\r\n	　　由于高端锁具科技 含量高、更加凸显人性化、个性化的特点，所以产品利润也比较高。加上锁具产品换代速度加快，高端锁具将逐渐成为锁具市场的主流。制锁企业应该积极采用新材 料，注重产品造型及艺术装饰性的同时，逐步运用计算机电子、信息、生物识别、纳米材料等提高前辈技术嫁接传统制锁业，努力开发有市场远景的新产品，并在使 用机能长进行突破。如住宅中高档插芯门锁系列、汽车锁系列、民用锁系列、防盗门锁系列、动弹码遥控系列、中高档机电一体化IC卡智能锁、TM卡锁、射锁卡 锁系列、生物识别特征锁系列等，都可以在工艺、技术革新上加以改革，逐步成熟。</p>\r\n', '', 'admin', '', '1466832235', '1466832235', 'true', '', '锁 具与我们和社会的关系十分密切，它关系到每个家庭、单位和公共场所的安全。随着时代的进步，各种款式、质料、结构、功能不同的专业性用锁品种层出不穷。同 时，锁具作为一', '锁具,行业分析,未来,竞争,新高地,新,高地,锁,', '200', '1466832222', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('50', '23', '规范开锁行业 有利于锁具产业发展', '', '/storage/images/20220208/12514L320-0-lp.jpg', '', '一直以来，我国开锁行业都处于非常混乱的状态。传统开锁匠的水平参差不齐，为用户开锁不成功，往往会告诉用户是锁具的质量问题，建议用户换锁，然后采用破 坏性手段开锁。而门锁出现故障或者丢了钥匙的人在请锁匠开了锁之后，也都会选择立即换锁。有时即使锁本身并没有损坏，他们也担心自家的锁会被锁匠“破 解”，被配了钥匙，而选择立刻换新锁。这种开完锁后的换锁需求一度成为了锁具零售业的主要需求之一。\r\n<p>\r\n	　　很明显，这是一种畸形的需求，源自人们对于传统开锁人员深深的不信任。长此以往，人们不但会对开锁人员失去信任，也会对锁具产品的质量失去信心，非常不利于锁具行业的发展</p>\r\n<p>\r\n	　 　2002年左右，广州出现了中国第一家在公安部门注册的专业开锁公司。2004年，北京、哈尔滨等众多城市颁布行政法规，要求规范开锁行业。随后，公安 部门备案，持证上岗的正规开锁公司开始在全国各地出现。2007年4月，公安部、国家工商行政管理总局近日联合发出通知，要求进一步加强开锁行业管理，规 范开锁经营单位经营行为。此后，更多城市开始规范开锁行业，正规的开锁行业渐渐红火起来，以至于春晚上都出现了以此为题材的小品。开锁行业逐步规范起来以 后，大家对锁具的信任感也得到了增强。</p>\r\n<p>\r\n	　 　规范开锁业之后，如果您只是丢了钥匙，并不是锁具出现故障的话，专业合法的开锁公司不会采用破坏性的手段来开锁。开锁后，大部分的锁具都可以继续使用。 虽然会损失一部分市场需求，但是这保证了锁具产品的质量声誉。市场上的锁具需求不能依靠“损坏率”来拉动。相比那些眼前利益，长远的发展更加重要。而长远 的发展无疑需要良好的质量作保障。</p>\r\n', '', 'admin', '', '1466832250', '1466832250', 'true', '', '一直以来，我国开锁行业都处于非常混乱的状态。传统开锁匠的水平参差不齐，为用户开锁不成功，往往会告诉用户是锁具的质量问题，建议用户换锁，然后采用破 坏性手段开锁。而门', '规范,开锁,行业,有利于,锁具,产业发展,一直,', '81', '1466832242', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('51', '23', '锁具行业分析：未来竞争新高地', '', '/storage/images/20220208/12514L320-0-lp.jpg', '', '<p>\r\n	锁 具与我们和社会的关系十分密切，它关系到每个家庭、单位和公共场所的安全。随着时代的进步，各种款式、质料、结构、功能不同的专业性用锁品种层出不穷。同 时，锁具作为一种较为特殊的商品，与安全有着极其重要的关系。随着我国住宅、汽车、中高档办公楼及酒店等支柱型产业的快速发展以及国防、公安、金融等系统 对具有高防范性锁具产品需求的日益加强，高档锁具市场的前景乐观。中国国内锁具市场对生物识别和电子技术等高技术产品的份额将达到60亿美元共5000多 万套，这绝对是一块诱人的大蛋糕。</p>\r\n<p>\r\n	　　目前 国内许多制锁企业的竞争力来自于低成本，价格战打得“热火朝天”，锁业的利润却越来越薄，一些低附加值的挂锁需要几十道生产工序才能生产出来，但是一把锁 只有几分钱的利润。制锁行业急需技术和产业升级，更新品牌创新模式。锁具行业的创新，需要企业转变观念，改变以模仿为主的想法，掌握自主技术，加大设备、 技术、研发的投入和专利创新，提高产品科技含量，增加产品的差异化程度；企业应注重提升品牌意识、实施品牌战略，以此改变自身处境，抢占中高档市场份额， 促进行业健康快速发展。</p>\r\n<p>\r\n	　　因此，中国制锁 行业应该有一个具备组织性的总体目标，科技提高才能逐年不乱进步，如产品结构、产品质量、技术装备、立异能力、人才结构等等缺一不可。中国已经形成了最主 要的四大出产基地，浙江温州、广东中山、山东和上海。一些大型锁具企业开始进入开发高端智能锁具的行列，海内高档锁有增长势头。锁具产品的发展要跟随着市 场走，只要市场有需求，锁具企业必然也要去开拓、去占领高端市场。跟着我国对外开放不断深入，高档建筑发展的加快，高档锁具市场发展潜力很大，必然将会涌 现出大批的高端企业。</p>\r\n<p>\r\n	　　由于高端锁具科技 含量高、更加凸显人性化、个性化的特点，所以产品利润也比较高。加上锁具产品换代速度加快，高端锁具将逐渐成为锁具市场的主流。制锁企业应该积极采用新材 料，注重产品造型及艺术装饰性的同时，逐步运用计算机电子、信息、生物识别、纳米材料等提高前辈技术嫁接传统制锁业，努力开发有市场远景的新产品，并在使 用机能长进行突破。如住宅中高档插芯门锁系列、汽车锁系列、民用锁系列、防盗门锁系列、动弹码遥控系列、中高档机电一体化IC卡智能锁、TM卡锁、射锁卡 锁系列、生物识别特征锁系列等，都可以在工艺、技术革新上加以改革，逐步成熟。</p>\r\n', '', 'admin', '', '1466832235', '1466832235', 'true', '', '锁 具与我们和社会的关系十分密切，它关系到每个家庭、单位和公共场所的安全。随着时代的进步，各种款式、质料、结构、功能不同的专业性用锁品种层出不穷。同 时，锁具作为一', '锁具,行业分析,未来,竞争,新高地,新,高地,锁,', '200', '1466832222', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('52', '23', '规范开锁行业 有利于锁具产业发展', '', '/storage/images/20220208/12514L320-0-lp.jpg', '', '一直以来，我国开锁行业都处于非常混乱的状态。传统开锁匠的水平参差不齐，为用户开锁不成功，往往会告诉用户是锁具的质量问题，建议用户换锁，然后采用破 坏性手段开锁。而门锁出现故障或者丢了钥匙的人在请锁匠开了锁之后，也都会选择立即换锁。有时即使锁本身并没有损坏，他们也担心自家的锁会被锁匠“破 解”，被配了钥匙，而选择立刻换新锁。这种开完锁后的换锁需求一度成为了锁具零售业的主要需求之一。\r\n<p>\r\n	　　很明显，这是一种畸形的需求，源自人们对于传统开锁人员深深的不信任。长此以往，人们不但会对开锁人员失去信任，也会对锁具产品的质量失去信心，非常不利于锁具行业的发展</p>\r\n<p>\r\n	　 　2002年左右，广州出现了中国第一家在公安部门注册的专业开锁公司。2004年，北京、哈尔滨等众多城市颁布行政法规，要求规范开锁行业。随后，公安 部门备案，持证上岗的正规开锁公司开始在全国各地出现。2007年4月，公安部、国家工商行政管理总局近日联合发出通知，要求进一步加强开锁行业管理，规 范开锁经营单位经营行为。此后，更多城市开始规范开锁行业，正规的开锁行业渐渐红火起来，以至于春晚上都出现了以此为题材的小品。开锁行业逐步规范起来以 后，大家对锁具的信任感也得到了增强。</p>\r\n<p>\r\n	　 　规范开锁业之后，如果您只是丢了钥匙，并不是锁具出现故障的话，专业合法的开锁公司不会采用破坏性的手段来开锁。开锁后，大部分的锁具都可以继续使用。 虽然会损失一部分市场需求，但是这保证了锁具产品的质量声誉。市场上的锁具需求不能依靠“损坏率”来拉动。相比那些眼前利益，长远的发展更加重要。而长远 的发展无疑需要良好的质量作保障。</p>\r\n', '', 'admin', '', '1466832250', '1466832250', 'true', '', '一直以来，我国开锁行业都处于非常混乱的状态。传统开锁匠的水平参差不齐，为用户开锁不成功，往往会告诉用户是锁具的质量问题，建议用户换锁，然后采用破 坏性手段开锁。而门', '规范,开锁,行业,有利于,锁具,产业发展,一直,', '81', '1466832242', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('53', '23', '锁具行业分析：未来竞争新高地', '', '/storage/images/20220208/12514L320-0-lp.jpg', '', '<p>\r\n	锁 具与我们和社会的关系十分密切，它关系到每个家庭、单位和公共场所的安全。随着时代的进步，各种款式、质料、结构、功能不同的专业性用锁品种层出不穷。同 时，锁具作为一种较为特殊的商品，与安全有着极其重要的关系。随着我国住宅、汽车、中高档办公楼及酒店等支柱型产业的快速发展以及国防、公安、金融等系统 对具有高防范性锁具产品需求的日益加强，高档锁具市场的前景乐观。中国国内锁具市场对生物识别和电子技术等高技术产品的份额将达到60亿美元共5000多 万套，这绝对是一块诱人的大蛋糕。</p>\r\n<p>\r\n	　　目前 国内许多制锁企业的竞争力来自于低成本，价格战打得“热火朝天”，锁业的利润却越来越薄，一些低附加值的挂锁需要几十道生产工序才能生产出来，但是一把锁 只有几分钱的利润。制锁行业急需技术和产业升级，更新品牌创新模式。锁具行业的创新，需要企业转变观念，改变以模仿为主的想法，掌握自主技术，加大设备、 技术、研发的投入和专利创新，提高产品科技含量，增加产品的差异化程度；企业应注重提升品牌意识、实施品牌战略，以此改变自身处境，抢占中高档市场份额， 促进行业健康快速发展。</p>\r\n<p>\r\n	　　因此，中国制锁 行业应该有一个具备组织性的总体目标，科技提高才能逐年不乱进步，如产品结构、产品质量、技术装备、立异能力、人才结构等等缺一不可。中国已经形成了最主 要的四大出产基地，浙江温州、广东中山、山东和上海。一些大型锁具企业开始进入开发高端智能锁具的行列，海内高档锁有增长势头。锁具产品的发展要跟随着市 场走，只要市场有需求，锁具企业必然也要去开拓、去占领高端市场。跟着我国对外开放不断深入，高档建筑发展的加快，高档锁具市场发展潜力很大，必然将会涌 现出大批的高端企业。</p>\r\n<p>\r\n	　　由于高端锁具科技 含量高、更加凸显人性化、个性化的特点，所以产品利润也比较高。加上锁具产品换代速度加快，高端锁具将逐渐成为锁具市场的主流。制锁企业应该积极采用新材 料，注重产品造型及艺术装饰性的同时，逐步运用计算机电子、信息、生物识别、纳米材料等提高前辈技术嫁接传统制锁业，努力开发有市场远景的新产品，并在使 用机能长进行突破。如住宅中高档插芯门锁系列、汽车锁系列、民用锁系列、防盗门锁系列、动弹码遥控系列、中高档机电一体化IC卡智能锁、TM卡锁、射锁卡 锁系列、生物识别特征锁系列等，都可以在工艺、技术革新上加以改革，逐步成熟。</p>\r\n', '', 'admin', '', '1466832235', '1466832235', 'true', '', '锁 具与我们和社会的关系十分密切，它关系到每个家庭、单位和公共场所的安全。随着时代的进步，各种款式、质料、结构、功能不同的专业性用锁品种层出不穷。同 时，锁具作为一', '锁具,行业分析,未来,竞争,新高地,新,高地,锁,', '200', '1466832222', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('54', '23', '规范开锁行业 有利于锁具产业发展', '', '/storage/images/20220208/12514L320-0-lp.jpg', '', '一直以来，我国开锁行业都处于非常混乱的状态。传统开锁匠的水平参差不齐，为用户开锁不成功，往往会告诉用户是锁具的质量问题，建议用户换锁，然后采用破 坏性手段开锁。而门锁出现故障或者丢了钥匙的人在请锁匠开了锁之后，也都会选择立即换锁。有时即使锁本身并没有损坏，他们也担心自家的锁会被锁匠“破 解”，被配了钥匙，而选择立刻换新锁。这种开完锁后的换锁需求一度成为了锁具零售业的主要需求之一。\r\n<p>\r\n	　　很明显，这是一种畸形的需求，源自人们对于传统开锁人员深深的不信任。长此以往，人们不但会对开锁人员失去信任，也会对锁具产品的质量失去信心，非常不利于锁具行业的发展</p>\r\n<p>\r\n	　 　2002年左右，广州出现了中国第一家在公安部门注册的专业开锁公司。2004年，北京、哈尔滨等众多城市颁布行政法规，要求规范开锁行业。随后，公安 部门备案，持证上岗的正规开锁公司开始在全国各地出现。2007年4月，公安部、国家工商行政管理总局近日联合发出通知，要求进一步加强开锁行业管理，规 范开锁经营单位经营行为。此后，更多城市开始规范开锁行业，正规的开锁行业渐渐红火起来，以至于春晚上都出现了以此为题材的小品。开锁行业逐步规范起来以 后，大家对锁具的信任感也得到了增强。</p>\r\n<p>\r\n	　 　规范开锁业之后，如果您只是丢了钥匙，并不是锁具出现故障的话，专业合法的开锁公司不会采用破坏性的手段来开锁。开锁后，大部分的锁具都可以继续使用。 虽然会损失一部分市场需求，但是这保证了锁具产品的质量声誉。市场上的锁具需求不能依靠“损坏率”来拉动。相比那些眼前利益，长远的发展更加重要。而长远 的发展无疑需要良好的质量作保障。</p>\r\n', '', 'admin', '', '1466832250', '1466832250', 'true', '', '一直以来，我国开锁行业都处于非常混乱的状态。传统开锁匠的水平参差不齐，为用户开锁不成功，往往会告诉用户是锁具的质量问题，建议用户换锁，然后采用破 坏性手段开锁。而门', '规范,开锁,行业,有利于,锁具,产业发展,一直,', '81', '1466832242', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('55', '23', '锁具行业分析：未来竞争新高地', '', '/storage/images/20220208/12514L320-0-lp.jpg', '', '<p>\r\n	锁 具与我们和社会的关系十分密切，它关系到每个家庭、单位和公共场所的安全。随着时代的进步，各种款式、质料、结构、功能不同的专业性用锁品种层出不穷。同 时，锁具作为一种较为特殊的商品，与安全有着极其重要的关系。随着我国住宅、汽车、中高档办公楼及酒店等支柱型产业的快速发展以及国防、公安、金融等系统 对具有高防范性锁具产品需求的日益加强，高档锁具市场的前景乐观。中国国内锁具市场对生物识别和电子技术等高技术产品的份额将达到60亿美元共5000多 万套，这绝对是一块诱人的大蛋糕。</p>\r\n<p>\r\n	　　目前 国内许多制锁企业的竞争力来自于低成本，价格战打得“热火朝天”，锁业的利润却越来越薄，一些低附加值的挂锁需要几十道生产工序才能生产出来，但是一把锁 只有几分钱的利润。制锁行业急需技术和产业升级，更新品牌创新模式。锁具行业的创新，需要企业转变观念，改变以模仿为主的想法，掌握自主技术，加大设备、 技术、研发的投入和专利创新，提高产品科技含量，增加产品的差异化程度；企业应注重提升品牌意识、实施品牌战略，以此改变自身处境，抢占中高档市场份额， 促进行业健康快速发展。</p>\r\n<p>\r\n	　　因此，中国制锁 行业应该有一个具备组织性的总体目标，科技提高才能逐年不乱进步，如产品结构、产品质量、技术装备、立异能力、人才结构等等缺一不可。中国已经形成了最主 要的四大出产基地，浙江温州、广东中山、山东和上海。一些大型锁具企业开始进入开发高端智能锁具的行列，海内高档锁有增长势头。锁具产品的发展要跟随着市 场走，只要市场有需求，锁具企业必然也要去开拓、去占领高端市场。跟着我国对外开放不断深入，高档建筑发展的加快，高档锁具市场发展潜力很大，必然将会涌 现出大批的高端企业。</p>\r\n<p>\r\n	　　由于高端锁具科技 含量高、更加凸显人性化、个性化的特点，所以产品利润也比较高。加上锁具产品换代速度加快，高端锁具将逐渐成为锁具市场的主流。制锁企业应该积极采用新材 料，注重产品造型及艺术装饰性的同时，逐步运用计算机电子、信息、生物识别、纳米材料等提高前辈技术嫁接传统制锁业，努力开发有市场远景的新产品，并在使 用机能长进行突破。如住宅中高档插芯门锁系列、汽车锁系列、民用锁系列、防盗门锁系列、动弹码遥控系列、中高档机电一体化IC卡智能锁、TM卡锁、射锁卡 锁系列、生物识别特征锁系列等，都可以在工艺、技术革新上加以改革，逐步成熟。</p>\r\n', '', 'admin', '', '1466832235', '1466832235', 'true', '', '锁 具与我们和社会的关系十分密切，它关系到每个家庭、单位和公共场所的安全。随着时代的进步，各种款式、质料、结构、功能不同的专业性用锁品种层出不穷。同 时，锁具作为一', '锁具,行业分析,未来,竞争,新高地,新,高地,锁,', '200', '1466832222', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('56', '23', '规范开锁行业 有利于锁具产业发展', '', '/storage/images/20220208/12514L320-0-lp.jpg', '', '一直以来，我国开锁行业都处于非常混乱的状态。传统开锁匠的水平参差不齐，为用户开锁不成功，往往会告诉用户是锁具的质量问题，建议用户换锁，然后采用破 坏性手段开锁。而门锁出现故障或者丢了钥匙的人在请锁匠开了锁之后，也都会选择立即换锁。有时即使锁本身并没有损坏，他们也担心自家的锁会被锁匠“破 解”，被配了钥匙，而选择立刻换新锁。这种开完锁后的换锁需求一度成为了锁具零售业的主要需求之一。\r\n<p>\r\n	　　很明显，这是一种畸形的需求，源自人们对于传统开锁人员深深的不信任。长此以往，人们不但会对开锁人员失去信任，也会对锁具产品的质量失去信心，非常不利于锁具行业的发展</p>\r\n<p>\r\n	　 　2002年左右，广州出现了中国第一家在公安部门注册的专业开锁公司。2004年，北京、哈尔滨等众多城市颁布行政法规，要求规范开锁行业。随后，公安 部门备案，持证上岗的正规开锁公司开始在全国各地出现。2007年4月，公安部、国家工商行政管理总局近日联合发出通知，要求进一步加强开锁行业管理，规 范开锁经营单位经营行为。此后，更多城市开始规范开锁行业，正规的开锁行业渐渐红火起来，以至于春晚上都出现了以此为题材的小品。开锁行业逐步规范起来以 后，大家对锁具的信任感也得到了增强。</p>\r\n<p>\r\n	　 　规范开锁业之后，如果您只是丢了钥匙，并不是锁具出现故障的话，专业合法的开锁公司不会采用破坏性的手段来开锁。开锁后，大部分的锁具都可以继续使用。 虽然会损失一部分市场需求，但是这保证了锁具产品的质量声誉。市场上的锁具需求不能依靠“损坏率”来拉动。相比那些眼前利益，长远的发展更加重要。而长远 的发展无疑需要良好的质量作保障。</p>\r\n', '', 'admin', '', '1466832250', '1466832250', 'true', '', '一直以来，我国开锁行业都处于非常混乱的状态。传统开锁匠的水平参差不齐，为用户开锁不成功，往往会告诉用户是锁具的质量问题，建议用户换锁，然后采用破 坏性手段开锁。而门', '规范,开锁,行业,有利于,锁具,产业发展,一直,', '81', '1466832242', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('57', '23', '锁具行业分析：未来竞争新高地', '', '/storage/images/20220208/12514L320-0-lp.jpg', '', '<p>\r\n	锁 具与我们和社会的关系十分密切，它关系到每个家庭、单位和公共场所的安全。随着时代的进步，各种款式、质料、结构、功能不同的专业性用锁品种层出不穷。同 时，锁具作为一种较为特殊的商品，与安全有着极其重要的关系。随着我国住宅、汽车、中高档办公楼及酒店等支柱型产业的快速发展以及国防、公安、金融等系统 对具有高防范性锁具产品需求的日益加强，高档锁具市场的前景乐观。中国国内锁具市场对生物识别和电子技术等高技术产品的份额将达到60亿美元共5000多 万套，这绝对是一块诱人的大蛋糕。</p>\r\n<p>\r\n	　　目前 国内许多制锁企业的竞争力来自于低成本，价格战打得“热火朝天”，锁业的利润却越来越薄，一些低附加值的挂锁需要几十道生产工序才能生产出来，但是一把锁 只有几分钱的利润。制锁行业急需技术和产业升级，更新品牌创新模式。锁具行业的创新，需要企业转变观念，改变以模仿为主的想法，掌握自主技术，加大设备、 技术、研发的投入和专利创新，提高产品科技含量，增加产品的差异化程度；企业应注重提升品牌意识、实施品牌战略，以此改变自身处境，抢占中高档市场份额， 促进行业健康快速发展。</p>\r\n<p>\r\n	　　因此，中国制锁 行业应该有一个具备组织性的总体目标，科技提高才能逐年不乱进步，如产品结构、产品质量、技术装备、立异能力、人才结构等等缺一不可。中国已经形成了最主 要的四大出产基地，浙江温州、广东中山、山东和上海。一些大型锁具企业开始进入开发高端智能锁具的行列，海内高档锁有增长势头。锁具产品的发展要跟随着市 场走，只要市场有需求，锁具企业必然也要去开拓、去占领高端市场。跟着我国对外开放不断深入，高档建筑发展的加快，高档锁具市场发展潜力很大，必然将会涌 现出大批的高端企业。</p>\r\n<p>\r\n	　　由于高端锁具科技 含量高、更加凸显人性化、个性化的特点，所以产品利润也比较高。加上锁具产品换代速度加快，高端锁具将逐渐成为锁具市场的主流。制锁企业应该积极采用新材 料，注重产品造型及艺术装饰性的同时，逐步运用计算机电子、信息、生物识别、纳米材料等提高前辈技术嫁接传统制锁业，努力开发有市场远景的新产品，并在使 用机能长进行突破。如住宅中高档插芯门锁系列、汽车锁系列、民用锁系列、防盗门锁系列、动弹码遥控系列、中高档机电一体化IC卡智能锁、TM卡锁、射锁卡 锁系列、生物识别特征锁系列等，都可以在工艺、技术革新上加以改革，逐步成熟。</p>\r\n', '', 'admin', '', '1466832235', '1466832235', 'true', '', '锁 具与我们和社会的关系十分密切，它关系到每个家庭、单位和公共场所的安全。随着时代的进步，各种款式、质料、结构、功能不同的专业性用锁品种层出不穷。同 时，锁具作为一', '锁具,行业分析,未来,竞争,新高地,新,高地,锁,', '200', '1466832222', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('58', '23', '规范开锁行业 有利于锁具产业发展', '', '/storage/images/20220208/12514L320-0-lp.jpg', '', '一直以来，我国开锁行业都处于非常混乱的状态。传统开锁匠的水平参差不齐，为用户开锁不成功，往往会告诉用户是锁具的质量问题，建议用户换锁，然后采用破 坏性手段开锁。而门锁出现故障或者丢了钥匙的人在请锁匠开了锁之后，也都会选择立即换锁。有时即使锁本身并没有损坏，他们也担心自家的锁会被锁匠“破 解”，被配了钥匙，而选择立刻换新锁。这种开完锁后的换锁需求一度成为了锁具零售业的主要需求之一。\r\n<p>\r\n	　　很明显，这是一种畸形的需求，源自人们对于传统开锁人员深深的不信任。长此以往，人们不但会对开锁人员失去信任，也会对锁具产品的质量失去信心，非常不利于锁具行业的发展</p>\r\n<p>\r\n	　 　2002年左右，广州出现了中国第一家在公安部门注册的专业开锁公司。2004年，北京、哈尔滨等众多城市颁布行政法规，要求规范开锁行业。随后，公安 部门备案，持证上岗的正规开锁公司开始在全国各地出现。2007年4月，公安部、国家工商行政管理总局近日联合发出通知，要求进一步加强开锁行业管理，规 范开锁经营单位经营行为。此后，更多城市开始规范开锁行业，正规的开锁行业渐渐红火起来，以至于春晚上都出现了以此为题材的小品。开锁行业逐步规范起来以 后，大家对锁具的信任感也得到了增强。</p>\r\n<p>\r\n	　 　规范开锁业之后，如果您只是丢了钥匙，并不是锁具出现故障的话，专业合法的开锁公司不会采用破坏性的手段来开锁。开锁后，大部分的锁具都可以继续使用。 虽然会损失一部分市场需求，但是这保证了锁具产品的质量声誉。市场上的锁具需求不能依靠“损坏率”来拉动。相比那些眼前利益，长远的发展更加重要。而长远 的发展无疑需要良好的质量作保障。</p>\r\n', '', 'admin', '', '1466832250', '1466832250', 'true', '', '一直以来，我国开锁行业都处于非常混乱的状态。传统开锁匠的水平参差不齐，为用户开锁不成功，往往会告诉用户是锁具的质量问题，建议用户换锁，然后采用破 坏性手段开锁。而门', '规范,开锁,行业,有利于,锁具,产业发展,一直,', '82', '1466832242', '0', '0', '0', '100', '未知', '', '');

-- ----------------------------
-- Table structure for `rrz_channelfield`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channelfield`;
CREATE TABLE `rrz_channelfield` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `channel_type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `title` varchar(32) NOT NULL DEFAULT '' COMMENT '字段标题',
  `dtype` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `define` text NOT NULL COMMENT '字段定义',
  `maxlength` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最大长度，文本数据必须填写，大于255为text类型',
  `dfvalue` longtext COMMENT '默认值',
  `dfvalue_unit` varchar(50) NOT NULL DEFAULT '' COMMENT '数值单位',
  `remark` varchar(256) NOT NULL DEFAULT '' COMMENT '提示说明',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `ifrequire` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否必填',
  `sort` int(5) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='自定义字段表';

-- ----------------------------
-- Table structure for `rrz_channeltype`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channeltype`;
CREATE TABLE `rrz_channeltype` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='文章（产品）类型';


-- ----------------------------
-- Table structure for `rrz_config`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_config`;
CREATE TABLE `rrz_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text COMMENT '配置内容',
  `type` varchar(64) DEFAULT '' COMMENT '类型',
  `desc` varchar(50) DEFAULT '' COMMENT '描述',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已删除（0：否，1：是）',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_name` (`name`) USING BTREE,
  KEY `idx_type` (`type`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='系统配置表';

-- -----------------------------
-- Records of `rrz_config`
-- -----------------------------
INSERT INTO `rrz_config` VALUES ('1', 'status', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('2', 'name', '某某网络科技有限公司', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('3', 'logo', '/storage/images/20220208/a9c9a5a5778110928f4826832266ab29.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('4', 'wap_logo', '/storage/images/20220208/059d8c4f5216dd0a8a334c5fa56c6a35.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('5', 'favicon', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('6', 'copyright', 'Copyright © 2012-2018 某某公司 版权所有', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('7', 'recordnum', '琼ICP备xxxxxxxx号', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('8', 'title', '绿色水果蔬菜类人人站模板(带手机端)', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('9', 'keywords', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('10', 'description', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('11', 'is_authorization', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('12', 'authortoken_code', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('13', 'popup_upgrade', '0', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('14', 'wap_domain', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('15', 'is_https', '0', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('16', 'logo', '/static/images/logo.png', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('17', 'sqldatapath', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('18', 'expiretime', '3600', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('19', 'name', '广州某某公司', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('20', 'telephone', '400-123-4567', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('21', 'fax', '020-99999999', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('22', 'qq', '88888888', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('23', 'email', 'admin@youweb.com', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('24', 'addr', '广东省广州市天河区88号', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('25', 'coord', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('26', 'thirdcode_pc', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('27', 'thirdcode_wap', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('28', 'inlet', '0', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('29', 'auto', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('30', 'filter_isurl', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('31', 'type', 'xml', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('32', 'index_changefreq', 'always', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('33', 'list_changefreq', 'hourly', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('34', 'view_changefreq', 'daily', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('35', 'index_priority', '1.0', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('36', 'list_priority', '0.8', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('37', 'view_priority', '0.5', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('38', 'articles_num', '100', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('39', 'zzbaidutoken', '', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('40', 'app_map', 'admin', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('41', 'status', '1', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('42', 'replace', '国家级|国际级|世界级|宇宙级|千万级|百万级|星级|甲级|超甲级|完美|唯一|一流|精确|顶级|顶尖|尖端|最|国际级产品|填补国内空白|带头|首个|首次|首发|首款|首家|首选|品牌|正品|金牌|名牌|优秀|顶级|独家|唯独|独有|独创|独据|开发者|缔造者|创始|发明者|领先|领头|领导|领跑|领袖|领先|引领|创领|领航|权威|先进|耀领|缔造者|极品|极佳|顶级|尖端|顶尖|终极|绝佳|绝对|绝版|终极|极致|极具|王牌|冠军|第一|极致|永久|王牌|掌门人|领袖|独一无二|绝无仅有|前无古人|史无前例|万能|绝对|绝顶|大牌|精确|超赚|巨星|至尊|巅峰|之王|巨星|王者|冠军|资深|至尊|著名|奢侈|百分之百|国家级产品|国家免检|国家领导人|填补国内空白|史无前例|前无古人|永久|永远|万能|祖传|特效|无敌|纯天然|超赚|国际品质|专家推荐|超强|全面|全网|全球|随时结束|仅此一次|空前绝后|随时涨价|马上降价|最后一波|包治百病|药到病除|特供|专供|专家推荐|热销|畅销|全效|标杆|精确|优秀|仅此|遥遥|高档|真皮|超赚|精准|指定|精品|特供|专供|军方|军事|国旗|国徽|党旗|驰名|秒杀|一步到位|', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('43', 'connector_title', '_', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('44', 'list_title', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('45', 'view_title', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('46', 'mobile', '138-0000-0000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('47', 'wx', 'WX8888888', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('48', 'qrcode', '/storage/images/20220208/e748f674ff99e1799e6b46f1357f7202.png', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('49', 'nav_hide_suffix', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('50', 'url_level_dir', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('51', 'app_debug', '2', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('52', 'hide_plugin', '0', 'admin', '', 'cn', '0');

-- ----------------------------
-- Table structure for `rrz_form_data`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_form_data`;
CREATE TABLE `rrz_form_data` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `form_id` int(10) unsigned DEFAULT '0' COMMENT '表单ID',
  `form_name` varchar(255) DEFAULT '' COMMENT '表单名称',
  `content` longtext COMMENT '提交内容',
  `ip` varchar(255) DEFAULT '' COMMENT '提交人IP',
  `add_time` int(10) unsigned DEFAULT NULL COMMENT '提交时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_form_id` (`form_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_forms`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_forms`;
CREATE TABLE `rrz_forms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '表单名称',
  `config` longtext COMMENT '表单配置',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '创建时间',
  `is_del` tinyint(1) unsigned DEFAULT '0' COMMENT '删除(0=否，1=是)',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_is_del` (`is_del`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- -----------------------------
-- Records of `rrz_forms`
-- -----------------------------
INSERT INTO `rrz_forms` VALUES ('1', '在线留言', 'a:3:{i:0;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:6:\"姓名\";s:8:\"required\";s:1:\"1\";}i:1;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:12:\"手机号码\";s:8:\"required\";s:1:\"1\";}i:2;a:3:{s:4:\"type\";s:8:\"textarea\";s:4:\"name\";s:12:\"留言内容\";s:8:\"required\";s:1:\"1\";}}', '1644304552', '0');

-- ----------------------------
-- Table structure for `rrz_goods`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods`;
CREATE TABLE `rrz_goods` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '产品名称',
  `subtitle` varchar(255) DEFAULT '' COMMENT '副标题',
  `brief` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '商品简介',
  `cat_id` mediumint(8) unsigned DEFAULT NULL COMMENT '产品分类id',
  `brand_id` int(10) unsigned DEFAULT '0' COMMENT '产品品牌id',
  `def_img` varchar(500) DEFAULT '' COMMENT '产品默认图片路径',
  `imgs` longtext COMMENT '产品图片集合',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `del_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品划线价格',
  `store` int(8) unsigned DEFAULT '0' COMMENT '产品库存',
  `is_presell` enum('true','false') DEFAULT 'false' COMMENT '是否预售（是否定金付款）',
  `presell_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '预售价格（定金）',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '产品规格',
  `content` longtext COMMENT '产品详情',
  `wap_content` longtext COMMENT '手机端详情',
  `sales` int(11) unsigned DEFAULT '0' COMMENT '产品销量',
  `addtime` int(11) unsigned DEFAULT '0' COMMENT '创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `is_news` tinyint(1) unsigned DEFAULT '0' COMMENT '新品（0=否，1=是）',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '上架',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_cat_id` (`cat_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_is_news` (`is_news`) USING BTREE,
  KEY `idx_brand_id` (`brand_id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品管理';

-- -----------------------------
-- Records of `rrz_goods`
-- -----------------------------
INSERT INTO `rrz_goods` VALUES ('1', '产品展示标题', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '1', '0', '/storage/images/20220208/1-160FQ64532221.jpg', '/storage/images/20220208/1-160FQ64532221.jpg,/storage/images/20220208/1-160625121627.jpg,/storage/images/20220208/1-160625121628.jpg,/storage/images/20220208/1-160625121629.jpg,/storage/images/20220208/1-160625121630.jpg,/storage/images/20220208/1-160625121631.jpg,/storage/images/20220208/1-160625121634.jpg,/storage/images/20220208/1-160625121637.jpg,/storage/images/20220208/1-160625121640.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！<br />\r\n愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！<br />\r\n记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”<br />\r\n为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。<br />\r\n传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。<br />\r\n记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”', '', '0', '1467967529', '0', '0', '0', '0', '172', '100', '', 'true', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '');
INSERT INTO `rrz_goods` VALUES ('2', '产品展示标题', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '1', '0', '/storage/images/20220208/1-160Q113202Q14.jpg', '/storage/images/20220208/1-160Q113202Q14.jpg,/storage/images/20220208/1-160625133I3.jpg,/storage/images/20220208/1-160625133I5.jpg,/storage/images/20220208/1-160625133I6.jpg,/storage/images/20220208/1-160625133I7.jpg,/storage/images/20220208/1-160625133I8.jpg,/storage/images/20220208/1-160625133I9.jpg,/storage/images/20220208/1-160625133J0.jpg,/storage/images/20220208/1-160625133J1.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”</span>', '', '0', '1470892824', '0', '0', '0', '0', '96', '100', '', 'true', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '');
INSERT INTO `rrz_goods` VALUES ('3', '产品展示标题', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '1', '0', '/storage/images/20220208/1-160FQ64532221.jpg', '/storage/images/20220208/1-160FQ64532221.jpg,/storage/images/20220208/1-160625121627.jpg,/storage/images/20220208/1-160625121628.jpg,/storage/images/20220208/1-160625121629.jpg,/storage/images/20220208/1-160625121630.jpg,/storage/images/20220208/1-160625121631.jpg,/storage/images/20220208/1-160625121634.jpg,/storage/images/20220208/1-160625121637.jpg,/storage/images/20220208/1-160625121640.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！<br />\r\n愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！<br />\r\n记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”<br />\r\n为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。<br />\r\n传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。<br />\r\n记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”', '', '0', '1467967529', '0', '0', '0', '0', '172', '100', '', 'true', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '');
INSERT INTO `rrz_goods` VALUES ('4', '产品展示标题', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '1', '0', '/storage/images/20220208/1-160Q113202Q14.jpg', '/storage/images/20220208/1-160Q113202Q14.jpg,/storage/images/20220208/1-160625133I3.jpg,/storage/images/20220208/1-160625133I5.jpg,/storage/images/20220208/1-160625133I6.jpg,/storage/images/20220208/1-160625133I7.jpg,/storage/images/20220208/1-160625133I8.jpg,/storage/images/20220208/1-160625133I9.jpg,/storage/images/20220208/1-160625133J0.jpg,/storage/images/20220208/1-160625133J1.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”</span>', '', '0', '1470892824', '0', '0', '0', '0', '96', '100', '', 'true', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '');
INSERT INTO `rrz_goods` VALUES ('5', '产品展示标题', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '1', '0', '/storage/images/20220208/1-160FQ64532221.jpg', '/storage/images/20220208/1-160FQ64532221.jpg,/storage/images/20220208/1-160625121627.jpg,/storage/images/20220208/1-160625121628.jpg,/storage/images/20220208/1-160625121629.jpg,/storage/images/20220208/1-160625121630.jpg,/storage/images/20220208/1-160625121631.jpg,/storage/images/20220208/1-160625121634.jpg,/storage/images/20220208/1-160625121637.jpg,/storage/images/20220208/1-160625121640.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！<br />\r\n愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！<br />\r\n记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”<br />\r\n为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。<br />\r\n传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。<br />\r\n记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”', '', '0', '1467967529', '0', '0', '0', '0', '172', '100', '', 'true', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '');
INSERT INTO `rrz_goods` VALUES ('6', '产品展示标题', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '1', '0', '/storage/images/20220208/1-160Q113202Q14.jpg', '/storage/images/20220208/1-160Q113202Q14.jpg,/storage/images/20220208/1-160625133I3.jpg,/storage/images/20220208/1-160625133I5.jpg,/storage/images/20220208/1-160625133I6.jpg,/storage/images/20220208/1-160625133I7.jpg,/storage/images/20220208/1-160625133I8.jpg,/storage/images/20220208/1-160625133I9.jpg,/storage/images/20220208/1-160625133J0.jpg,/storage/images/20220208/1-160625133J1.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”</span>', '', '0', '1470892824', '0', '0', '0', '0', '96', '100', '', 'true', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '');
INSERT INTO `rrz_goods` VALUES ('7', '产品展示标题', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '1', '0', '/storage/images/20220208/1-160FQ64532221.jpg', '/storage/images/20220208/1-160FQ64532221.jpg,/storage/images/20220208/1-160625121627.jpg,/storage/images/20220208/1-160625121628.jpg,/storage/images/20220208/1-160625121629.jpg,/storage/images/20220208/1-160625121630.jpg,/storage/images/20220208/1-160625121631.jpg,/storage/images/20220208/1-160625121634.jpg,/storage/images/20220208/1-160625121637.jpg,/storage/images/20220208/1-160625121640.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！<br />\r\n愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！<br />\r\n记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”<br />\r\n为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。<br />\r\n传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。<br />\r\n记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”', '', '0', '1467967529', '0', '0', '0', '0', '172', '100', '', 'true', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '');
INSERT INTO `rrz_goods` VALUES ('8', '产品展示标题', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '1', '0', '/storage/images/20220208/1-160Q113202Q14.jpg', '/storage/images/20220208/1-160Q113202Q14.jpg,/storage/images/20220208/1-160625133I3.jpg,/storage/images/20220208/1-160625133I5.jpg,/storage/images/20220208/1-160625133I6.jpg,/storage/images/20220208/1-160625133I7.jpg,/storage/images/20220208/1-160625133I8.jpg,/storage/images/20220208/1-160625133I9.jpg,/storage/images/20220208/1-160625133J0.jpg,/storage/images/20220208/1-160625133J1.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”</span>', '', '0', '1470892824', '0', '0', '0', '0', '96', '100', '', 'true', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '');
INSERT INTO `rrz_goods` VALUES ('9', '产品展示标题', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '1', '0', '/storage/images/20220208/1-160FQ64532221.jpg', '/storage/images/20220208/1-160FQ64532221.jpg,/storage/images/20220208/1-160625121627.jpg,/storage/images/20220208/1-160625121628.jpg,/storage/images/20220208/1-160625121629.jpg,/storage/images/20220208/1-160625121630.jpg,/storage/images/20220208/1-160625121631.jpg,/storage/images/20220208/1-160625121634.jpg,/storage/images/20220208/1-160625121637.jpg,/storage/images/20220208/1-160625121640.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！<br />\r\n愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！<br />\r\n记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”<br />\r\n为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。<br />\r\n传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。<br />\r\n记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”', '', '0', '1467967529', '0', '0', '0', '0', '172', '100', '', 'true', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '');
INSERT INTO `rrz_goods` VALUES ('10', '产品展示标题', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '1', '0', '/storage/images/20220208/1-160Q113202Q14.jpg', '/storage/images/20220208/1-160Q113202Q14.jpg,/storage/images/20220208/1-160625133I3.jpg,/storage/images/20220208/1-160625133I5.jpg,/storage/images/20220208/1-160625133I6.jpg,/storage/images/20220208/1-160625133I7.jpg,/storage/images/20220208/1-160625133I8.jpg,/storage/images/20220208/1-160625133I9.jpg,/storage/images/20220208/1-160625133J0.jpg,/storage/images/20220208/1-160625133J1.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”</span>', '', '0', '1470892824', '0', '0', '0', '0', '96', '100', '', 'true', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '');
INSERT INTO `rrz_goods` VALUES ('11', '产品展示标题', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '1', '0', '/storage/images/20220208/1-160FQ64532221.jpg', '/storage/images/20220208/1-160FQ64532221.jpg,/storage/images/20220208/1-160625121627.jpg,/storage/images/20220208/1-160625121628.jpg,/storage/images/20220208/1-160625121629.jpg,/storage/images/20220208/1-160625121630.jpg,/storage/images/20220208/1-160625121631.jpg,/storage/images/20220208/1-160625121634.jpg,/storage/images/20220208/1-160625121637.jpg,/storage/images/20220208/1-160625121640.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！<br />\r\n愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！<br />\r\n记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”<br />\r\n为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。<br />\r\n传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。<br />\r\n记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”', '', '0', '1467967529', '0', '0', '0', '0', '172', '100', '', 'true', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '');
INSERT INTO `rrz_goods` VALUES ('12', '产品展示标题', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '1', '0', '/storage/images/20220208/1-160Q113202Q14.jpg', '/storage/images/20220208/1-160Q113202Q14.jpg,/storage/images/20220208/1-160625133I3.jpg,/storage/images/20220208/1-160625133I5.jpg,/storage/images/20220208/1-160625133I6.jpg,/storage/images/20220208/1-160625133I7.jpg,/storage/images/20220208/1-160625133I8.jpg,/storage/images/20220208/1-160625133I9.jpg,/storage/images/20220208/1-160625133J0.jpg,/storage/images/20220208/1-160625133J1.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把“十字”孔的链子锁。但当李先生无意中把旧车锁的钥匙插到新车锁里时，令人意外的事发生了——锁居然开了！</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">愤慨的李先生马上找到修车店老板要求退货。为了证实锁有疑问，李先生在店里又用同一把钥匙试了试剩余的三把同款车锁，这三把锁居然也能用这把旧钥匙翻开！</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">记者来到李先生所说的这家自行车修理店，向老板问询此事。老板讪讪地说：“我也很吃惊，我后来马上就去找批发商退了这批货。”</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">为了了解锁具的质量状况，记者又去了绍兴路上的一家五交化商铺。</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">传闻记者要买好几把球形门锁，年轻的店老板很热心。“坚德利，老牌子，质量肯定过关。”他边说边取出一把9820SSP标准的锁。但记者发现，锁把手凸凹不平，黄色的锁身上还有点点锈迹，装锁的盒子上印的标志和商标文字模糊不清，仔细看却是“竖德利牌”。</span><br style=\"transition: background-color 0.3s ease; margin: 0px; padding: 0px; color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\" />\r\n<span style=\"color: rgb(39, 39, 39); font-family: 微软雅黑; font-size: 14px; line-height: 30px; text-align: justify;\">记者当即指出商标的猫腻，老板说：“你不说我还不知道哩，我也是上了批发商的当了——不过没关系，横竖都是锁，照样能用。”</span>', '', '0', '1470892824', '0', '0', '0', '0', '96', '100', '', 'true', '', '家住杭州采荷小区的市民李先生日前碰上了一件烦心事：一个星期连丢了两辆自行车。买新车后，他想买几把好锁，就到附近的自行车修理店买了一把十字孔的链子锁。但当李先生无意', '');

-- ----------------------------
-- Table structure for `rrz_goods_attr`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attr`;
CREATE TABLE `rrz_goods_attr` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品属性id自增',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `attr_value` text COMMENT '属性值',
  `attr_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `goods_id` (`goods_id`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品扩展属性关联表';


-- ----------------------------
-- Table structure for `rrz_goods_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attribute`;
CREATE TABLE `rrz_goods_attribute` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '属性名称',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '类型（0 单行文本框 1下拉式列表 2多行文本框）',
  `values` text COMMENT '属性值集合',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '100' COMMENT '属性排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品扩展属性';


-- ----------------------------
-- Table structure for `rrz_goods_brand`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_brand`;
CREATE TABLE `rrz_goods_brand` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '品牌表',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌名称',
  `logo` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌logo',
  `desc` text COMMENT '备注介绍',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌地址',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品品牌';


-- ----------------------------
-- Table structure for `rrz_goods_cat`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_cat`;
CREATE TABLE `rrz_goods_cat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) DEFAULT '' COMMENT '分类名称',
  `en_title` varchar(255) NOT NULL DEFAULT '' COMMENT '分类英文名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '分类图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '节点深度',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '分类排序',
  `path` varchar(255) DEFAULT '' COMMENT '节点路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `view_route` varchar(255) NOT NULL DEFAULT '{typedir}/{aid}.html' COMMENT '详情页路由',
  `list_route` varchar(255) NOT NULL DEFAULT '{typedir}/list_{tid}_{page}.html' COMMENT '列表页路由',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `attrs` longtext COMMENT '参数列表',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '发布',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品分类';

-- -----------------------------
-- Records of `rrz_goods_cat`
-- -----------------------------
INSERT INTO `rrz_goods_cat` VALUES ('1', '0', '产品一类', '', 'chanpinzhanshi/chanpinyilei', '0', '', '1', '1', '1', '1001', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '', 'true', '1644304547');
INSERT INTO `rrz_goods_cat` VALUES ('2', '0', '产品二类', '', 'chanpinzhanshi/chanpinerlei', '0', '', '2', '1', '2', '1002', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '', 'true', '1644304547');
INSERT INTO `rrz_goods_cat` VALUES ('3', '0', '产品三类', '', 'chanpinzhanshi/chanpinsanlei', '0', '', '3', '1', '3', '1003', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '', 'true', '1644304547');
INSERT INTO `rrz_goods_cat` VALUES ('4', '0', '产品四类', '', 'chanpinzhanshi/chanpinsilei', '0', '', '4', '1', '4', '1004', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '', 'true', '1644304547');

-- ----------------------------
-- Table structure for `rrz_goods_skus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_skus`;
CREATE TABLE `rrz_goods_skus` (
  `sku_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品规格id',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '规格明细',
  PRIMARY KEY (`sku_id`) USING BTREE,
  KEY `idx_goods_id` (`goods_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品规格详情';


-- ----------------------------
-- Table structure for `rrz_goods_spec_values`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_spec_values`;
CREATE TABLE `rrz_goods_spec_values` (
  `spec_value_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '规格值ID',
  `spec_id` bigint(15) unsigned NOT NULL DEFAULT '0' COMMENT '规格ID',
  `spec_value` varchar(100) NOT NULL DEFAULT '' COMMENT '规格值',
  PRIMARY KEY (`spec_value_id`) USING BTREE,
  KEY `idx_spec_id` (`spec_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格值';


-- ----------------------------
-- Table structure for `rrz_goods_specification`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_specification`;
CREATE TABLE `rrz_goods_specification` (
  `spec_id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `spec_name` varchar(50) DEFAULT NULL COMMENT '规格名',
  `sort` smallint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序顺序',
  PRIMARY KEY (`spec_id`) USING BTREE,
  KEY `idx_sort` (`sort`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格表';


-- ----------------------------
-- Table structure for `rrz_plugin`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_plugin`;
CREATE TABLE `rrz_plugin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(20) NOT NULL DEFAULT '' COMMENT '编码',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `desc` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `version` varchar(20) NOT NULL DEFAULT '' COMMENT '版本号',
  `author` varchar(30) NOT NULL DEFAULT '' COMMENT '作者',
  `isadmin` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否存在后台（0否1是）',
  `ishome` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否存在前台（0否1是）',
  `isload` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否自动加载（0手动加载、1自动加载）',
  `loadtemp` text COMMENT '自动加载在指定模板，空白默认全部',
  `config` text COMMENT '额外参数',
  `data` text COMMENT '配置存储数据，简单插件可以不创建表',
  `saflag` varchar(500) DEFAULT NULL COMMENT '标示内容',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态（0未安装、1启用、2禁用）',
  `addtime` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '执行顺序',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_code` (`code`),
  KEY `idx_status` (`status`),
  KEY `idx_ishome` (`ishome`),
  KEY `idx_isload` (`isload`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='插件表';


-- ----------------------------
-- Table structure for `rrz_search_keywords`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_search_keywords`;
CREATE TABLE `rrz_search_keywords` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `keywords` text COMMENT '关键词',
  `type` varchar(50) DEFAULT 'article' COMMENT '搜索类型',
  `ip` varchar(100) DEFAULT NULL COMMENT '搜索客户端的ip地址',
  `hot` int(10) unsigned DEFAULT '0' COMMENT '关键词搜索量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '搜索时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_hot` (`hot`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_site_links`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_links`;
CREATE TABLE `rrz_site_links` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT '' COMMENT '网站标题',
  `url` varchar(255) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort` int(10) unsigned DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) unsigned DEFAULT '0' COMMENT '是否新窗口打开',
  `email` varchar(50) DEFAULT '',
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='友情链接表';

-- -----------------------------
-- Records of `rrz_site_links`
-- -----------------------------
INSERT INTO `rrz_site_links` VALUES ('1', '企业建站系统', 'http://www.rrzcms.com/', 'http://g.kbscdn.cn/kbcms/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1590481203', '1627543172');
INSERT INTO `rrz_site_links` VALUES ('2', '淘进微信', 'http://taobao.kbstore.cn/', 'http://taobao.kbstore.cn/Public/images/logo-1.png', '100', '1', '', '', '1', 'cn', '1590481246', '1627543144');
INSERT INTO `rrz_site_links` VALUES ('3', '人人站CMS', 'http://www.rrzcms.com/', 'http://g.kbscdn.cn/kbcms/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1590481266', '1627543178');
INSERT INTO `rrz_site_links` VALUES ('4', '抖进微信', 'http://dou.kbstore.cn/', 'http://dou.kbstore.cn/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1621244482', '1627543197');
INSERT INTO `rrz_site_links` VALUES ('5', '淘进微博', 'http://weibo.kbstore.cn/', 'http://weibo.kbstore.cn/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1621244551', '1631698452');

-- ----------------------------
-- Table structure for `rrz_site_menus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_menus`;
CREATE TABLE `rrz_site_menus` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '标题',
  `en_title` varchar(100) NOT NULL DEFAULT '' COMMENT '英文标题',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '上级菜单',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '菜单深度',
  `url` varchar(200) DEFAULT '' COMMENT '自定义链接',
  `sort` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `path` varchar(100) NOT NULL DEFAULT '' COMMENT '上下级路径',
  `target_blank` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '是否新开窗口',
  `config` longtext COMMENT '配置',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='导航菜单表';

-- -----------------------------
-- Records of `rrz_site_menus`
-- -----------------------------
INSERT INTO `rrz_site_menus` VALUES ('1', '首页', 'Home', 'index', '0', '1', '1', '/', '1', '1001', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('2', '关于我们', '', 'guanyuwomen', '0', '2', '1', '/node/1.html', '2', '1002', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('3', '科普知识', '', 'kp', '0', '3', '1', '/node/2.html', '3', '1003', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('4', '产品展示', 'PRODUCT SHOW', 'chanpinzhanshi', '0', '4', '1', '/cats.html', '4', '1004', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('5', '案例展示', '', 'cases', '0', '5', '1', '/node/8.html', '5', '1005', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('6', '新闻资讯', '', 'xinwenzixun', '0', '6', '1', '/node/9.html', '6', '1006', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('7', '营养价值', '', 'yyjz', '0', '7', '1', '/node/10.html', '7', '1007', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('8', '在线留言', '', 'zaixianliuyan', '0', '8', '1', '/node/11.html', '8', '1008', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('9', '联系我们', '', 'lianxiwomen', '0', '9', '1', '/node/12.html', '9', '1009', 'false', '');
